# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
import sys
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object


class AcceleratorAuthSetting(_serialization.Model):
    """Auth setting payload.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AcceleratorBasicAuthSetting, AcceleratorPublicSetting, AcceleratorSshSetting

    All required parameters must be populated in order to send to Azure.

    :ivar auth_type: The type of the auth setting. Required.
    :vartype auth_type: str
    """

    _validation = {
        "auth_type": {"required": True},
    }

    _attribute_map = {
        "auth_type": {"key": "authType", "type": "str"},
    }

    _subtype_map = {
        "auth_type": {
            "BasicAuth": "AcceleratorBasicAuthSetting",
            "Public": "AcceleratorPublicSetting",
            "SSH": "AcceleratorSshSetting",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.auth_type: Optional[str] = None


class AcceleratorBasicAuthSetting(AcceleratorAuthSetting):
    """Auth setting for basic auth.

    All required parameters must be populated in order to send to Azure.

    :ivar auth_type: The type of the auth setting. Required.
    :vartype auth_type: str
    :ivar ca_cert_resource_id: Resource Id of CA certificate for https URL of Git repository.
    :vartype ca_cert_resource_id: str
    :ivar username: Username of git repository basic auth. Required.
    :vartype username: str
    :ivar password: Password of git repository basic auth.
    :vartype password: str
    """

    _validation = {
        "auth_type": {"required": True},
        "username": {"required": True},
    }

    _attribute_map = {
        "auth_type": {"key": "authType", "type": "str"},
        "ca_cert_resource_id": {"key": "caCertResourceId", "type": "str"},
        "username": {"key": "username", "type": "str"},
        "password": {"key": "password", "type": "str"},
    }

    def __init__(
        self, *, username: str, ca_cert_resource_id: Optional[str] = None, password: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword ca_cert_resource_id: Resource Id of CA certificate for https URL of Git repository.
        :paramtype ca_cert_resource_id: str
        :keyword username: Username of git repository basic auth. Required.
        :paramtype username: str
        :keyword password: Password of git repository basic auth.
        :paramtype password: str
        """
        super().__init__(**kwargs)
        self.auth_type: str = "BasicAuth"
        self.ca_cert_resource_id = ca_cert_resource_id
        self.username = username
        self.password = password


class AcceleratorGitRepository(_serialization.Model):
    """AcceleratorGitRepository.

    All required parameters must be populated in order to send to Azure.

    :ivar url: Git repository URL for the accelerator. Required.
    :vartype url: str
    :ivar interval_in_seconds: Interval for checking for updates to Git or image repository.
    :vartype interval_in_seconds: int
    :ivar branch: Git repository branch to be used.
    :vartype branch: str
    :ivar commit: Git repository commit to be used.
    :vartype commit: str
    :ivar git_tag: Git repository tag to be used.
    :vartype git_tag: str
    :ivar auth_setting: Properties of the auth setting payload. Required.
    :vartype auth_setting:
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.AcceleratorAuthSetting
    """

    _validation = {
        "url": {"required": True},
        "auth_setting": {"required": True},
    }

    _attribute_map = {
        "url": {"key": "url", "type": "str"},
        "interval_in_seconds": {"key": "intervalInSeconds", "type": "int"},
        "branch": {"key": "branch", "type": "str"},
        "commit": {"key": "commit", "type": "str"},
        "git_tag": {"key": "gitTag", "type": "str"},
        "auth_setting": {"key": "authSetting", "type": "AcceleratorAuthSetting"},
    }

    def __init__(
        self,
        *,
        url: str,
        auth_setting: "_models.AcceleratorAuthSetting",
        interval_in_seconds: Optional[int] = None,
        branch: Optional[str] = None,
        commit: Optional[str] = None,
        git_tag: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword url: Git repository URL for the accelerator. Required.
        :paramtype url: str
        :keyword interval_in_seconds: Interval for checking for updates to Git or image repository.
        :paramtype interval_in_seconds: int
        :keyword branch: Git repository branch to be used.
        :paramtype branch: str
        :keyword commit: Git repository commit to be used.
        :paramtype commit: str
        :keyword git_tag: Git repository tag to be used.
        :paramtype git_tag: str
        :keyword auth_setting: Properties of the auth setting payload. Required.
        :paramtype auth_setting:
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.AcceleratorAuthSetting
        """
        super().__init__(**kwargs)
        self.url = url
        self.interval_in_seconds = interval_in_seconds
        self.branch = branch
        self.commit = commit
        self.git_tag = git_tag
        self.auth_setting = auth_setting


class AcceleratorPublicSetting(AcceleratorAuthSetting):
    """Auth setting for public url.

    All required parameters must be populated in order to send to Azure.

    :ivar auth_type: The type of the auth setting. Required.
    :vartype auth_type: str
    :ivar ca_cert_resource_id: Resource Id of CA certificate for https URL of Git repository.
    :vartype ca_cert_resource_id: str
    """

    _validation = {
        "auth_type": {"required": True},
    }

    _attribute_map = {
        "auth_type": {"key": "authType", "type": "str"},
        "ca_cert_resource_id": {"key": "caCertResourceId", "type": "str"},
    }

    def __init__(self, *, ca_cert_resource_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword ca_cert_resource_id: Resource Id of CA certificate for https URL of Git repository.
        :paramtype ca_cert_resource_id: str
        """
        super().__init__(**kwargs)
        self.auth_type: str = "Public"
        self.ca_cert_resource_id = ca_cert_resource_id


class AcceleratorSshSetting(AcceleratorAuthSetting):
    """Auth setting for SSH auth.

    All required parameters must be populated in order to send to Azure.

    :ivar auth_type: The type of the auth setting. Required.
    :vartype auth_type: str
    :ivar host_key: Public SSH Key of git repository.
    :vartype host_key: str
    :ivar host_key_algorithm: SSH Key algorithm of git repository.
    :vartype host_key_algorithm: str
    :ivar private_key: Private SSH Key algorithm of git repository.
    :vartype private_key: str
    """

    _validation = {
        "auth_type": {"required": True},
    }

    _attribute_map = {
        "auth_type": {"key": "authType", "type": "str"},
        "host_key": {"key": "hostKey", "type": "str"},
        "host_key_algorithm": {"key": "hostKeyAlgorithm", "type": "str"},
        "private_key": {"key": "privateKey", "type": "str"},
    }

    def __init__(
        self,
        *,
        host_key: Optional[str] = None,
        host_key_algorithm: Optional[str] = None,
        private_key: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword host_key: Public SSH Key of git repository.
        :paramtype host_key: str
        :keyword host_key_algorithm: SSH Key algorithm of git repository.
        :paramtype host_key_algorithm: str
        :keyword private_key: Private SSH Key algorithm of git repository.
        :paramtype private_key: str
        """
        super().__init__(**kwargs)
        self.auth_type: str = "SSH"
        self.host_key = host_key
        self.host_key_algorithm = host_key_algorithm
        self.private_key = private_key


class ActiveDeploymentCollection(_serialization.Model):
    """Object that includes an array of Deployment resource name and set them as active.

    :ivar active_deployment_names: Collection of Deployment name.
    :vartype active_deployment_names: list[str]
    """

    _attribute_map = {
        "active_deployment_names": {"key": "activeDeploymentNames", "type": "[str]"},
    }

    def __init__(self, *, active_deployment_names: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword active_deployment_names: Collection of Deployment name.
        :paramtype active_deployment_names: list[str]
        """
        super().__init__(**kwargs)
        self.active_deployment_names = active_deployment_names


class ApiPortalCustomDomainProperties(_serialization.Model):
    """The properties of custom domain for API portal.

    :ivar thumbprint: The thumbprint of bound certificate.
    :vartype thumbprint: str
    """

    _attribute_map = {
        "thumbprint": {"key": "thumbprint", "type": "str"},
    }

    def __init__(self, *, thumbprint: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword thumbprint: The thumbprint of bound certificate.
        :paramtype thumbprint: str
        """
        super().__init__(**kwargs)
        self.thumbprint = thumbprint


class Resource(_serialization.Model):
    """The core properties of ARM resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.appplatform.v2023_07_01_preview.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class ProxyResource(Resource):
    """The resource model definition for a ARM proxy resource. It will have everything other than
    required location and tags.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.appplatform.v2023_07_01_preview.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)


class ApiPortalCustomDomainResource(ProxyResource):
    """Custom domain of the API portal.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.appplatform.v2023_07_01_preview.models.SystemData
    :ivar properties: The properties of custom domain for API portal.
    :vartype properties:
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.ApiPortalCustomDomainProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "ApiPortalCustomDomainProperties"},
    }

    def __init__(
        self, *, properties: Optional["_models.ApiPortalCustomDomainProperties"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword properties: The properties of custom domain for API portal.
        :paramtype properties:
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.ApiPortalCustomDomainProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class ApiPortalCustomDomainResourceCollection(_serialization.Model):
    """Object that includes an array of API portal custom domain resources and a possible link for
    next set.

    :ivar value: Collection of API portal custom domain resources.
    :vartype value:
     list[~azure.mgmt.appplatform.v2023_07_01_preview.models.ApiPortalCustomDomainResource]
    :ivar next_link: URL client should use to fetch the next page (per server side paging).
     It's null for now, added for future use.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ApiPortalCustomDomainResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ApiPortalCustomDomainResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Collection of API portal custom domain resources.
        :paramtype value:
         list[~azure.mgmt.appplatform.v2023_07_01_preview.models.ApiPortalCustomDomainResource]
        :keyword next_link: URL client should use to fetch the next page (per server side paging).
         It's null for now, added for future use.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ApiPortalInstance(_serialization.Model):
    """Collection of instances belong to the API portal.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the API portal instance.
    :vartype name: str
    :ivar status: Status of the API portal instance.
    :vartype status: str
    """

    _validation = {
        "name": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.status = None


class ApiPortalProperties(_serialization.Model):
    """API portal properties payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: State of the API portal. Known values are: "Creating", "Updating",
     "Succeeded", "Failed", and "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.ApiPortalProvisioningState
    :ivar public: Indicates whether the API portal exposes endpoint.
    :vartype public: bool
    :ivar url: URL of the API portal, exposed when 'public' is true.
    :vartype url: str
    :ivar https_only: Indicate if only https is allowed.
    :vartype https_only: bool
    :ivar gateway_ids: The array of resource Ids of gateway to integrate with API portal.
    :vartype gateway_ids: list[str]
    :ivar source_urls: Collection of OpenAPI source URL locations.
    :vartype source_urls: list[str]
    :ivar sso_properties: Single sign-on related configuration.
    :vartype sso_properties: ~azure.mgmt.appplatform.v2023_07_01_preview.models.SsoProperties
    :ivar resource_requests: The requested resource quantity for required CPU and Memory.
    :vartype resource_requests:
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.ApiPortalResourceRequests
    :ivar instances: Collection of instances belong to API portal.
    :vartype instances: list[~azure.mgmt.appplatform.v2023_07_01_preview.models.ApiPortalInstance]
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "url": {"readonly": True},
        "resource_requests": {"readonly": True},
        "instances": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "public": {"key": "public", "type": "bool"},
        "url": {"key": "url", "type": "str"},
        "https_only": {"key": "httpsOnly", "type": "bool"},
        "gateway_ids": {"key": "gatewayIds", "type": "[str]"},
        "source_urls": {"key": "sourceUrls", "type": "[str]"},
        "sso_properties": {"key": "ssoProperties", "type": "SsoProperties"},
        "resource_requests": {"key": "resourceRequests", "type": "ApiPortalResourceRequests"},
        "instances": {"key": "instances", "type": "[ApiPortalInstance]"},
    }

    def __init__(
        self,
        *,
        public: bool = False,
        https_only: bool = False,
        gateway_ids: Optional[List[str]] = None,
        source_urls: Optional[List[str]] = None,
        sso_properties: Optional["_models.SsoProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword public: Indicates whether the API portal exposes endpoint.
        :paramtype public: bool
        :keyword https_only: Indicate if only https is allowed.
        :paramtype https_only: bool
        :keyword gateway_ids: The array of resource Ids of gateway to integrate with API portal.
        :paramtype gateway_ids: list[str]
        :keyword source_urls: Collection of OpenAPI source URL locations.
        :paramtype source_urls: list[str]
        :keyword sso_properties: Single sign-on related configuration.
        :paramtype sso_properties: ~azure.mgmt.appplatform.v2023_07_01_preview.models.SsoProperties
        """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.public = public
        self.url = None
        self.https_only = https_only
        self.gateway_ids = gateway_ids
        self.source_urls = source_urls
        self.sso_properties = sso_properties
        self.resource_requests = None
        self.instances = None


class ApiPortalResource(ProxyResource):
    """API portal resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.appplatform.v2023_07_01_preview.models.SystemData
    :ivar properties: API portal properties payload.
    :vartype properties: ~azure.mgmt.appplatform.v2023_07_01_preview.models.ApiPortalProperties
    :ivar sku: Sku of the API portal resource.
    :vartype sku: ~azure.mgmt.appplatform.v2023_07_01_preview.models.Sku
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "ApiPortalProperties"},
        "sku": {"key": "sku", "type": "Sku"},
    }

    def __init__(
        self,
        *,
        properties: Optional["_models.ApiPortalProperties"] = None,
        sku: Optional["_models.Sku"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword properties: API portal properties payload.
        :paramtype properties: ~azure.mgmt.appplatform.v2023_07_01_preview.models.ApiPortalProperties
        :keyword sku: Sku of the API portal resource.
        :paramtype sku: ~azure.mgmt.appplatform.v2023_07_01_preview.models.Sku
        """
        super().__init__(**kwargs)
        self.properties = properties
        self.sku = sku


class ApiPortalResourceCollection(_serialization.Model):
    """Object that includes an array of API portal resources and a possible link for next set.

    :ivar value: Collection of API portal resources.
    :vartype value: list[~azure.mgmt.appplatform.v2023_07_01_preview.models.ApiPortalResource]
    :ivar next_link: URL client should use to fetch the next page (per server side paging).
     It's null for now, added for future use.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ApiPortalResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ApiPortalResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Collection of API portal resources.
        :paramtype value: list[~azure.mgmt.appplatform.v2023_07_01_preview.models.ApiPortalResource]
        :keyword next_link: URL client should use to fetch the next page (per server side paging).
         It's null for now, added for future use.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ApiPortalResourceRequests(_serialization.Model):
    """Resource requests of the API portal.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar cpu: Cpu allocated to each API portal instance.
    :vartype cpu: str
    :ivar memory: Memory allocated to each API portal instance.
    :vartype memory: str
    """

    _validation = {
        "cpu": {"readonly": True},
        "memory": {"readonly": True},
    }

    _attribute_map = {
        "cpu": {"key": "cpu", "type": "str"},
        "memory": {"key": "memory", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.cpu = None
        self.memory = None


class ApmProperties(_serialization.Model):
    """Properties of an APM.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: APM Type. Required.
    :vartype type: str
    :ivar provisioning_state: State of the APM. Known values are: "Creating", "Updating",
     "Succeeded", "Failed", "Deleting", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.ApmProvisioningState
    :ivar properties: Non-sensitive properties for the APM.
    :vartype properties: dict[str, str]
    :ivar secrets: Sensitive properties for the APM.
    :vartype secrets: dict[str, str]
    """

    _validation = {
        "type": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "properties": {"key": "properties", "type": "{str}"},
        "secrets": {"key": "secrets", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        type: str,
        properties: Optional[Dict[str, str]] = None,
        secrets: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: APM Type. Required.
        :paramtype type: str
        :keyword properties: Non-sensitive properties for the APM.
        :paramtype properties: dict[str, str]
        :keyword secrets: Sensitive properties for the APM.
        :paramtype secrets: dict[str, str]
        """
        super().__init__(**kwargs)
        self.type = type
        self.provisioning_state = None
        self.properties = properties
        self.secrets = secrets


class ApmReference(_serialization.Model):
    """A reference to the APM.

    All required parameters must be populated in order to send to Azure.

    :ivar resource_id: Resource Id of the APM. Required.
    :vartype resource_id: str
    """

    _validation = {
        "resource_id": {"required": True},
    }

    _attribute_map = {
        "resource_id": {"key": "resourceId", "type": "str"},
    }

    def __init__(self, *, resource_id: str, **kwargs: Any) -> None:
        """
        :keyword resource_id: Resource Id of the APM. Required.
        :paramtype resource_id: str
        """
        super().__init__(**kwargs)
        self.resource_id = resource_id


class ApmResource(ProxyResource):
    """APM Resource object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.appplatform.v2023_07_01_preview.models.SystemData
    :ivar properties: Properties of an APM.
    :vartype properties: ~azure.mgmt.appplatform.v2023_07_01_preview.models.ApmProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "ApmProperties"},
    }

    def __init__(self, *, properties: Optional["_models.ApmProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: Properties of an APM.
        :paramtype properties: ~azure.mgmt.appplatform.v2023_07_01_preview.models.ApmProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class ApmResourceCollection(_serialization.Model):
    """Object that includes an array of APM resources and a possible link for next set.

    :ivar value: Collection of APM resources.
    :vartype value: list[~azure.mgmt.appplatform.v2023_07_01_preview.models.ApmResource]
    :ivar next_link: URL client should use to fetch the next page (per server side paging).
     It's null for now, added for future use.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ApmResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.ApmResource"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Collection of APM resources.
        :paramtype value: list[~azure.mgmt.appplatform.v2023_07_01_preview.models.ApmResource]
        :keyword next_link: URL client should use to fetch the next page (per server side paging).
         It's null for now, added for future use.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ApmSecretKeys(_serialization.Model):
    """Keys of APM sensitive properties.

    :ivar value: Collection of the keys for the APM sensitive properties.
    :vartype value: list[str]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[str]"},
    }

    def __init__(self, *, value: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword value: Collection of the keys for the APM sensitive properties.
        :paramtype value: list[str]
        """
        super().__init__(**kwargs)
        self.value = value


class ApplicationAcceleratorComponent(_serialization.Model):
    """ApplicationAcceleratorComponent.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name:
    :vartype name: str
    :ivar resource_requests:
    :vartype resource_requests:
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.ApplicationAcceleratorResourceRequests
    :ivar instances:
    :vartype instances:
     list[~azure.mgmt.appplatform.v2023_07_01_preview.models.ApplicationAcceleratorInstance]
    """

    _validation = {
        "name": {"readonly": True},
        "instances": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "resource_requests": {"key": "resourceRequests", "type": "ApplicationAcceleratorResourceRequests"},
        "instances": {"key": "instances", "type": "[ApplicationAcceleratorInstance]"},
    }

    def __init__(
        self, *, resource_requests: Optional["_models.ApplicationAcceleratorResourceRequests"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword resource_requests:
        :paramtype resource_requests:
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.ApplicationAcceleratorResourceRequests
        """
        super().__init__(**kwargs)
        self.name = None
        self.resource_requests = resource_requests
        self.instances = None


class ApplicationAcceleratorInstance(_serialization.Model):
    """ApplicationAcceleratorInstance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the Application Accelerator instance.
    :vartype name: str
    :ivar status: Status of the Application Accelerator instance. It can be Pending, Running,
     Succeeded, Failed, Unknown.
    :vartype status: str
    """

    _validation = {
        "name": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.status = None


class ApplicationAcceleratorProperties(_serialization.Model):
    """Application accelerator properties payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: State of the application accelerator. Known values are: "Creating",
     "Updating", "Succeeded", "Failed", and "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.ApplicationAcceleratorProvisioningState
    :ivar components: Collection of components belong to application accelerator.
    :vartype components:
     list[~azure.mgmt.appplatform.v2023_07_01_preview.models.ApplicationAcceleratorComponent]
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "components": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "components": {"key": "components", "type": "[ApplicationAcceleratorComponent]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.components = None


class ApplicationAcceleratorResource(ProxyResource):
    """Application accelerator resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.appplatform.v2023_07_01_preview.models.SystemData
    :ivar properties: Application accelerator properties payload.
    :vartype properties:
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.ApplicationAcceleratorProperties
    :ivar sku: Sku of the application accelerator resource.
    :vartype sku: ~azure.mgmt.appplatform.v2023_07_01_preview.models.Sku
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "ApplicationAcceleratorProperties"},
        "sku": {"key": "sku", "type": "Sku"},
    }

    def __init__(
        self,
        *,
        properties: Optional["_models.ApplicationAcceleratorProperties"] = None,
        sku: Optional["_models.Sku"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword properties: Application accelerator properties payload.
        :paramtype properties:
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.ApplicationAcceleratorProperties
        :keyword sku: Sku of the application accelerator resource.
        :paramtype sku: ~azure.mgmt.appplatform.v2023_07_01_preview.models.Sku
        """
        super().__init__(**kwargs)
        self.properties = properties
        self.sku = sku


class ApplicationAcceleratorResourceCollection(_serialization.Model):
    """Object that includes an array of application accelerator resources and a possible link for next
    set.

    :ivar value: Collection of application accelerator resources.
    :vartype value:
     list[~azure.mgmt.appplatform.v2023_07_01_preview.models.ApplicationAcceleratorResource]
    :ivar next_link: URL client should use to fetch the next page (per server side paging).
     It's null for now, added for future use.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ApplicationAcceleratorResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ApplicationAcceleratorResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Collection of application accelerator resources.
        :paramtype value:
         list[~azure.mgmt.appplatform.v2023_07_01_preview.models.ApplicationAcceleratorResource]
        :keyword next_link: URL client should use to fetch the next page (per server side paging).
         It's null for now, added for future use.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ApplicationAcceleratorResourceRequests(_serialization.Model):
    """ApplicationAcceleratorResourceRequests.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar cpu: Cpu allocated to each application accelerator component. 1 core can be represented
     by 1 or 1000m.
    :vartype cpu: str
    :ivar memory: Memory allocated to each application accelerator component. 1 GB can be
     represented by 1Gi or 1024Mi.
    :vartype memory: str
    :ivar instance_count: Instance count of the application accelerator component.
    :vartype instance_count: int
    """

    _validation = {
        "cpu": {"readonly": True},
        "memory": {"readonly": True},
        "instance_count": {"readonly": True},
    }

    _attribute_map = {
        "cpu": {"key": "cpu", "type": "str"},
        "memory": {"key": "memory", "type": "str"},
        "instance_count": {"key": "instanceCount", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.cpu = None
        self.memory = None
        self.instance_count = None


class ApplicationInsightsAgentVersions(_serialization.Model):
    """Application Insights agent versions properties payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar java: Indicates the version of application insight java agent.
    :vartype java: str
    """

    _validation = {
        "java": {"readonly": True},
    }

    _attribute_map = {
        "java": {"key": "java", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.java = None


class ApplicationLiveViewComponent(_serialization.Model):
    """Application Live View properties payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the component.
    :vartype name: any
    :ivar resource_requests: The requested resource quantity for required CPU and Memory.
    :vartype resource_requests:
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.ApplicationLiveViewResourceRequests
    :ivar instances: Collection of instances belong to Application Live View.
    :vartype instances:
     list[~azure.mgmt.appplatform.v2023_07_01_preview.models.ApplicationLiveViewInstance]
    """

    _validation = {
        "name": {"readonly": True},
        "resource_requests": {"readonly": True},
        "instances": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "object"},
        "resource_requests": {"key": "resourceRequests", "type": "ApplicationLiveViewResourceRequests"},
        "instances": {"key": "instances", "type": "[ApplicationLiveViewInstance]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.resource_requests = None
        self.instances = None


class ApplicationLiveViewInstance(_serialization.Model):
    """Collection of instances belong to the Application Live View.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the Application Live View instance.
    :vartype name: str
    :ivar status: Status of the Application Live View instance. It can be Pending, Running,
     Succeeded, Failed, Unknown.
    :vartype status: str
    """

    _validation = {
        "name": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.status = None


class ApplicationLiveViewProperties(_serialization.Model):
    """Application Live View properties payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: State of the Application Live View. Known values are: "Creating",
     "Updating", "Succeeded", "Failed", "Deleting", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.ApplicationLiveViewProvisioningState
    :ivar components: Component details of Application Live View.
    :vartype components:
     list[~azure.mgmt.appplatform.v2023_07_01_preview.models.ApplicationLiveViewComponent]
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "components": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "components": {"key": "components", "type": "[ApplicationLiveViewComponent]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.components = None


class ApplicationLiveViewResource(ProxyResource):
    """Application Live View resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.appplatform.v2023_07_01_preview.models.SystemData
    :ivar properties: Application Live View properties payload.
    :vartype properties:
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.ApplicationLiveViewProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "ApplicationLiveViewProperties"},
    }

    def __init__(self, *, properties: Optional["_models.ApplicationLiveViewProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: Application Live View properties payload.
        :paramtype properties:
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.ApplicationLiveViewProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class ApplicationLiveViewResourceCollection(_serialization.Model):
    """Object that includes an array of Application Live View resources and a possible link for next
    set.

    :ivar value: Collection of Application Live View resources.
    :vartype value:
     list[~azure.mgmt.appplatform.v2023_07_01_preview.models.ApplicationLiveViewResource]
    :ivar next_link: URL client should use to fetch the next page (per server side paging).
     It's null for now, added for future use.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ApplicationLiveViewResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ApplicationLiveViewResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Collection of Application Live View resources.
        :paramtype value:
         list[~azure.mgmt.appplatform.v2023_07_01_preview.models.ApplicationLiveViewResource]
        :keyword next_link: URL client should use to fetch the next page (per server side paging).
         It's null for now, added for future use.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ApplicationLiveViewResourceRequests(_serialization.Model):
    """The resource quantity for required CPU and Memory of Application Live View component.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar cpu: Cpu quantity allocated to each Application Live View component instance. 1 core can
     be represented by 1 or 1000m.
    :vartype cpu: str
    :ivar memory: Memory quantity allocated to each Application Live View component instance. 1 GB
     can be represented by 1Gi or 1024Mi.
    :vartype memory: str
    :ivar instance_count: Desired instance count of Application Live View component instance.
    :vartype instance_count: int
    """

    _validation = {
        "cpu": {"readonly": True},
        "memory": {"readonly": True},
        "instance_count": {"readonly": True},
    }

    _attribute_map = {
        "cpu": {"key": "cpu", "type": "str"},
        "memory": {"key": "memory", "type": "str"},
        "instance_count": {"key": "instanceCount", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.cpu = None
        self.memory = None
        self.instance_count = None


class AppResource(ProxyResource):
    """App resource payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.appplatform.v2023_07_01_preview.models.SystemData
    :ivar properties: Properties of the App resource.
    :vartype properties: ~azure.mgmt.appplatform.v2023_07_01_preview.models.AppResourceProperties
    :ivar identity: The Managed Identity type of the app resource.
    :vartype identity: ~azure.mgmt.appplatform.v2023_07_01_preview.models.ManagedIdentityProperties
    :ivar location: The GEO location of the application, always the same with its parent resource.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "AppResourceProperties"},
        "identity": {"key": "identity", "type": "ManagedIdentityProperties"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(
        self,
        *,
        properties: Optional["_models.AppResourceProperties"] = None,
        identity: Optional["_models.ManagedIdentityProperties"] = None,
        location: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword properties: Properties of the App resource.
        :paramtype properties: ~azure.mgmt.appplatform.v2023_07_01_preview.models.AppResourceProperties
        :keyword identity: The Managed Identity type of the app resource.
        :paramtype identity:
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.ManagedIdentityProperties
        :keyword location: The GEO location of the application, always the same with its parent
         resource.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.properties = properties
        self.identity = identity
        self.location = location


class AppResourceCollection(_serialization.Model):
    """Object that includes an array of App resources and a possible link for next set.

    :ivar value: Collection of App resources.
    :vartype value: list[~azure.mgmt.appplatform.v2023_07_01_preview.models.AppResource]
    :ivar next_link: URL client should use to fetch the next page (per server side paging).
     It's null for now, added for future use.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[AppResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.AppResource"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Collection of App resources.
        :paramtype value: list[~azure.mgmt.appplatform.v2023_07_01_preview.models.AppResource]
        :keyword next_link: URL client should use to fetch the next page (per server side paging).
         It's null for now, added for future use.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AppResourceProperties(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """App resource properties payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar public: Indicates whether the App exposes public endpoint.
    :vartype public: bool
    :ivar url: URL of the App.
    :vartype url: str
    :ivar addon_configs: Collection of addons.
    :vartype addon_configs: dict[str, JSON]
    :ivar provisioning_state: Provisioning state of the App. Known values are: "Succeeded",
     "Failed", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.AppResourceProvisioningState
    :ivar fqdn: Fully qualified dns Name.
    :vartype fqdn: str
    :ivar https_only: Indicate if only https is allowed.
    :vartype https_only: bool
    :ivar temporary_disk: Temporary disk settings.
    :vartype temporary_disk: ~azure.mgmt.appplatform.v2023_07_01_preview.models.TemporaryDisk
    :ivar persistent_disk: Persistent disk settings.
    :vartype persistent_disk: ~azure.mgmt.appplatform.v2023_07_01_preview.models.PersistentDisk
    :ivar custom_persistent_disks: List of custom persistent disks.
    :vartype custom_persistent_disks:
     list[~azure.mgmt.appplatform.v2023_07_01_preview.models.CustomPersistentDiskResource]
    :ivar enable_end_to_end_tls: Indicate if end to end TLS is enabled.
    :vartype enable_end_to_end_tls: bool
    :ivar loaded_certificates: Collection of loaded certificates.
    :vartype loaded_certificates:
     list[~azure.mgmt.appplatform.v2023_07_01_preview.models.LoadedCertificate]
    :ivar vnet_addons: Additional App settings in vnet injection instance.
    :vartype vnet_addons: ~azure.mgmt.appplatform.v2023_07_01_preview.models.AppVNetAddons
    :ivar ingress_settings: App ingress settings payload.
    :vartype ingress_settings: ~azure.mgmt.appplatform.v2023_07_01_preview.models.IngressSettings
    :ivar secrets: Collection of auth secrets.
    :vartype secrets: list[~azure.mgmt.appplatform.v2023_07_01_preview.models.Secret]
    :ivar workload_profile_name: The workload profile used for this app. Supported for Consumption
     + Dedicated plan.
    :vartype workload_profile_name: str
    """

    _validation = {
        "url": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "fqdn": {"readonly": True},
    }

    _attribute_map = {
        "public": {"key": "public", "type": "bool"},
        "url": {"key": "url", "type": "str"},
        "addon_configs": {"key": "addonConfigs", "type": "{object}"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "fqdn": {"key": "fqdn", "type": "str"},
        "https_only": {"key": "httpsOnly", "type": "bool"},
        "temporary_disk": {"key": "temporaryDisk", "type": "TemporaryDisk"},
        "persistent_disk": {"key": "persistentDisk", "type": "PersistentDisk"},
        "custom_persistent_disks": {"key": "customPersistentDisks", "type": "[CustomPersistentDiskResource]"},
        "enable_end_to_end_tls": {"key": "enableEndToEndTLS", "type": "bool"},
        "loaded_certificates": {"key": "loadedCertificates", "type": "[LoadedCertificate]"},
        "vnet_addons": {"key": "vnetAddons", "type": "AppVNetAddons"},
        "ingress_settings": {"key": "ingressSettings", "type": "IngressSettings"},
        "secrets": {"key": "secrets", "type": "[Secret]"},
        "workload_profile_name": {"key": "workloadProfileName", "type": "str"},
    }

    def __init__(
        self,
        *,
        public: Optional[bool] = None,
        addon_configs: Optional[Dict[str, JSON]] = None,
        https_only: bool = False,
        temporary_disk: Optional["_models.TemporaryDisk"] = None,
        persistent_disk: Optional["_models.PersistentDisk"] = None,
        custom_persistent_disks: Optional[List["_models.CustomPersistentDiskResource"]] = None,
        enable_end_to_end_tls: bool = False,
        loaded_certificates: Optional[List["_models.LoadedCertificate"]] = None,
        vnet_addons: Optional["_models.AppVNetAddons"] = None,
        ingress_settings: Optional["_models.IngressSettings"] = None,
        secrets: Optional[List["_models.Secret"]] = None,
        workload_profile_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword public: Indicates whether the App exposes public endpoint.
        :paramtype public: bool
        :keyword addon_configs: Collection of addons.
        :paramtype addon_configs: dict[str, JSON]
        :keyword https_only: Indicate if only https is allowed.
        :paramtype https_only: bool
        :keyword temporary_disk: Temporary disk settings.
        :paramtype temporary_disk: ~azure.mgmt.appplatform.v2023_07_01_preview.models.TemporaryDisk
        :keyword persistent_disk: Persistent disk settings.
        :paramtype persistent_disk: ~azure.mgmt.appplatform.v2023_07_01_preview.models.PersistentDisk
        :keyword custom_persistent_disks: List of custom persistent disks.
        :paramtype custom_persistent_disks:
         list[~azure.mgmt.appplatform.v2023_07_01_preview.models.CustomPersistentDiskResource]
        :keyword enable_end_to_end_tls: Indicate if end to end TLS is enabled.
        :paramtype enable_end_to_end_tls: bool
        :keyword loaded_certificates: Collection of loaded certificates.
        :paramtype loaded_certificates:
         list[~azure.mgmt.appplatform.v2023_07_01_preview.models.LoadedCertificate]
        :keyword vnet_addons: Additional App settings in vnet injection instance.
        :paramtype vnet_addons: ~azure.mgmt.appplatform.v2023_07_01_preview.models.AppVNetAddons
        :keyword ingress_settings: App ingress settings payload.
        :paramtype ingress_settings: ~azure.mgmt.appplatform.v2023_07_01_preview.models.IngressSettings
        :keyword secrets: Collection of auth secrets.
        :paramtype secrets: list[~azure.mgmt.appplatform.v2023_07_01_preview.models.Secret]
        :keyword workload_profile_name: The workload profile used for this app. Supported for
         Consumption + Dedicated plan.
        :paramtype workload_profile_name: str
        """
        super().__init__(**kwargs)
        self.public = public
        self.url = None
        self.addon_configs = addon_configs
        self.provisioning_state = None
        self.fqdn = None
        self.https_only = https_only
        self.temporary_disk = temporary_disk
        self.persistent_disk = persistent_disk
        self.custom_persistent_disks = custom_persistent_disks
        self.enable_end_to_end_tls = enable_end_to_end_tls
        self.loaded_certificates = loaded_certificates
        self.vnet_addons = vnet_addons
        self.ingress_settings = ingress_settings
        self.secrets = secrets
        self.workload_profile_name = workload_profile_name


class AppVNetAddons(_serialization.Model):
    """Additional App settings in vnet injection instance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar public_endpoint: Indicates whether the App in vnet injection instance exposes endpoint
     which could be accessed from internet.
    :vartype public_endpoint: bool
    :ivar public_endpoint_url: URL of the App in vnet injection instance which could be accessed
     from internet.
    :vartype public_endpoint_url: str
    """

    _validation = {
        "public_endpoint_url": {"readonly": True},
    }

    _attribute_map = {
        "public_endpoint": {"key": "publicEndpoint", "type": "bool"},
        "public_endpoint_url": {"key": "publicEndpointUrl", "type": "str"},
    }

    def __init__(self, *, public_endpoint: bool = False, **kwargs: Any) -> None:
        """
        :keyword public_endpoint: Indicates whether the App in vnet injection instance exposes endpoint
         which could be accessed from internet.
        :paramtype public_endpoint: bool
        """
        super().__init__(**kwargs)
        self.public_endpoint = public_endpoint
        self.public_endpoint_url = None


class AvailableOperations(_serialization.Model):
    """Available operations of the service.

    :ivar value: Collection of available operation details.
    :vartype value: list[~azure.mgmt.appplatform.v2023_07_01_preview.models.OperationDetail]
    :ivar next_link: URL client should use to fetch the next page (per server side paging).
     It's null for now, added for future use.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[OperationDetail]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.OperationDetail"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Collection of available operation details.
        :paramtype value: list[~azure.mgmt.appplatform.v2023_07_01_preview.models.OperationDetail]
        :keyword next_link: URL client should use to fetch the next page (per server side paging).
         It's null for now, added for future use.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AvailableRuntimeVersions(_serialization.Model):
    """AvailableRuntimeVersions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of all supported runtime versions.
    :vartype value:
     list[~azure.mgmt.appplatform.v2023_07_01_preview.models.SupportedRuntimeVersion]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SupportedRuntimeVersion]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None


class CustomPersistentDiskProperties(_serialization.Model):
    """Custom persistent disk resource payload.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureFileVolume

    All required parameters must be populated in order to send to Azure.

    :ivar type: The type of the underlying resource to mount as a persistent disk. Required.
     "AzureFileVolume"
    :vartype type: str or ~azure.mgmt.appplatform.v2023_07_01_preview.models.Type
    :ivar mount_path: The mount path of the persistent disk. Required.
    :vartype mount_path: str
    :ivar read_only: Indicates whether the persistent disk is a readOnly one.
    :vartype read_only: bool
    :ivar enable_sub_path: If set to true, it will create and mount a dedicated directory for every
     individual app instance.
    :vartype enable_sub_path: bool
    :ivar mount_options: These are the mount options for a persistent disk.
    :vartype mount_options: list[str]
    """

    _validation = {
        "type": {"required": True},
        "mount_path": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "mount_path": {"key": "mountPath", "type": "str"},
        "read_only": {"key": "readOnly", "type": "bool"},
        "enable_sub_path": {"key": "enableSubPath", "type": "bool"},
        "mount_options": {"key": "mountOptions", "type": "[str]"},
    }

    _subtype_map = {"type": {"AzureFileVolume": "AzureFileVolume"}}

    def __init__(
        self,
        *,
        mount_path: str,
        read_only: Optional[bool] = None,
        enable_sub_path: bool = False,
        mount_options: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword mount_path: The mount path of the persistent disk. Required.
        :paramtype mount_path: str
        :keyword read_only: Indicates whether the persistent disk is a readOnly one.
        :paramtype read_only: bool
        :keyword enable_sub_path: If set to true, it will create and mount a dedicated directory for
         every individual app instance.
        :paramtype enable_sub_path: bool
        :keyword mount_options: These are the mount options for a persistent disk.
        :paramtype mount_options: list[str]
        """
        super().__init__(**kwargs)
        self.type: Optional[str] = None
        self.mount_path = mount_path
        self.read_only = read_only
        self.enable_sub_path = enable_sub_path
        self.mount_options = mount_options


class AzureFileVolume(CustomPersistentDiskProperties):
    """The properties of the Azure File volume. Azure File shares are mounted as volumes.

    All required parameters must be populated in order to send to Azure.

    :ivar type: The type of the underlying resource to mount as a persistent disk. Required.
     "AzureFileVolume"
    :vartype type: str or ~azure.mgmt.appplatform.v2023_07_01_preview.models.Type
    :ivar mount_path: The mount path of the persistent disk. Required.
    :vartype mount_path: str
    :ivar read_only: Indicates whether the persistent disk is a readOnly one.
    :vartype read_only: bool
    :ivar enable_sub_path: If set to true, it will create and mount a dedicated directory for every
     individual app instance.
    :vartype enable_sub_path: bool
    :ivar mount_options: These are the mount options for a persistent disk.
    :vartype mount_options: list[str]
    :ivar share_name: The share name of the Azure File share.
    :vartype share_name: str
    """

    _validation = {
        "type": {"required": True},
        "mount_path": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "mount_path": {"key": "mountPath", "type": "str"},
        "read_only": {"key": "readOnly", "type": "bool"},
        "enable_sub_path": {"key": "enableSubPath", "type": "bool"},
        "mount_options": {"key": "mountOptions", "type": "[str]"},
        "share_name": {"key": "shareName", "type": "str"},
    }

    def __init__(
        self,
        *,
        mount_path: str,
        read_only: Optional[bool] = None,
        enable_sub_path: bool = False,
        mount_options: Optional[List[str]] = None,
        share_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword mount_path: The mount path of the persistent disk. Required.
        :paramtype mount_path: str
        :keyword read_only: Indicates whether the persistent disk is a readOnly one.
        :paramtype read_only: bool
        :keyword enable_sub_path: If set to true, it will create and mount a dedicated directory for
         every individual app instance.
        :paramtype enable_sub_path: bool
        :keyword mount_options: These are the mount options for a persistent disk.
        :paramtype mount_options: list[str]
        :keyword share_name: The share name of the Azure File share.
        :paramtype share_name: str
        """
        super().__init__(
            mount_path=mount_path,
            read_only=read_only,
            enable_sub_path=enable_sub_path,
            mount_options=mount_options,
            **kwargs
        )
        self.type: str = "AzureFileVolume"
        self.share_name = share_name


class BindingResource(ProxyResource):
    """Binding resource payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.appplatform.v2023_07_01_preview.models.SystemData
    :ivar properties: Properties of the Binding resource.
    :vartype properties:
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.BindingResourceProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "BindingResourceProperties"},
    }

    def __init__(self, *, properties: Optional["_models.BindingResourceProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: Properties of the Binding resource.
        :paramtype properties:
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.BindingResourceProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class BindingResourceCollection(_serialization.Model):
    """Object that includes an array of Binding resources and a possible link for next set.

    :ivar value: Collection of Binding resources.
    :vartype value: list[~azure.mgmt.appplatform.v2023_07_01_preview.models.BindingResource]
    :ivar next_link: URL client should use to fetch the next page (per server side paging).
     It's null for now, added for future use.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[BindingResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.BindingResource"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Collection of Binding resources.
        :paramtype value: list[~azure.mgmt.appplatform.v2023_07_01_preview.models.BindingResource]
        :keyword next_link: URL client should use to fetch the next page (per server side paging).
         It's null for now, added for future use.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class BindingResourceProperties(_serialization.Model):
    """Binding resource properties payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar resource_name: The name of the bound resource.
    :vartype resource_name: str
    :ivar resource_type: The standard Azure resource type of the bound resource.
    :vartype resource_type: str
    :ivar resource_id: The Azure resource id of the bound resource.
    :vartype resource_id: str
    :ivar key: The key of the bound resource.
    :vartype key: str
    :ivar binding_parameters: Binding parameters of the Binding resource.
    :vartype binding_parameters: dict[str, str]
    :ivar generated_properties: The generated Spring Boot property file for this binding. The
     secret will be deducted.
    :vartype generated_properties: str
    :ivar created_at: Creation time of the Binding resource.
    :vartype created_at: str
    :ivar updated_at: Update time of the Binding resource.
    :vartype updated_at: str
    """

    _validation = {
        "resource_name": {"readonly": True},
        "resource_type": {"readonly": True},
        "generated_properties": {"readonly": True},
        "created_at": {"readonly": True},
        "updated_at": {"readonly": True},
    }

    _attribute_map = {
        "resource_name": {"key": "resourceName", "type": "str"},
        "resource_type": {"key": "resourceType", "type": "str"},
        "resource_id": {"key": "resourceId", "type": "str"},
        "key": {"key": "key", "type": "str"},
        "binding_parameters": {"key": "bindingParameters", "type": "{str}"},
        "generated_properties": {"key": "generatedProperties", "type": "str"},
        "created_at": {"key": "createdAt", "type": "str"},
        "updated_at": {"key": "updatedAt", "type": "str"},
    }

    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
        key: Optional[str] = None,
        binding_parameters: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword resource_id: The Azure resource id of the bound resource.
        :paramtype resource_id: str
        :keyword key: The key of the bound resource.
        :paramtype key: str
        :keyword binding_parameters: Binding parameters of the Binding resource.
        :paramtype binding_parameters: dict[str, str]
        """
        super().__init__(**kwargs)
        self.resource_name = None
        self.resource_type = None
        self.resource_id = resource_id
        self.key = key
        self.binding_parameters = binding_parameters
        self.generated_properties = None
        self.created_at = None
        self.updated_at = None


class Build(ProxyResource):
    """Build resource payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.appplatform.v2023_07_01_preview.models.SystemData
    :ivar properties: Properties of the build resource.
    :vartype properties: ~azure.mgmt.appplatform.v2023_07_01_preview.models.BuildProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "BuildProperties"},
    }

    def __init__(self, *, properties: Optional["_models.BuildProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: Properties of the build resource.
        :paramtype properties: ~azure.mgmt.appplatform.v2023_07_01_preview.models.BuildProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class BuildCollection(_serialization.Model):
    """Object that includes an array of Build resources and a possible link for next set.

    :ivar value: Collection of Build resources.
    :vartype value: list[~azure.mgmt.appplatform.v2023_07_01_preview.models.Build]
    :ivar next_link: URL client should use to fetch the next page (per server side paging).
     It's null for now, added for future use.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Build]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Build"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Collection of Build resources.
        :paramtype value: list[~azure.mgmt.appplatform.v2023_07_01_preview.models.Build]
        :keyword next_link: URL client should use to fetch the next page (per server side paging).
         It's null for now, added for future use.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class BuilderProperties(_serialization.Model):
    """KPack Builder properties payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: Builder provision status. Known values are: "Creating", "Updating",
     "Succeeded", "Failed", and "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.BuilderProvisioningState
    :ivar stack: Builder cluster stack property.
    :vartype stack: ~azure.mgmt.appplatform.v2023_07_01_preview.models.StackProperties
    :ivar buildpack_groups: Builder buildpack groups.
    :vartype buildpack_groups:
     list[~azure.mgmt.appplatform.v2023_07_01_preview.models.BuildpacksGroupProperties]
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "stack": {"key": "stack", "type": "StackProperties"},
        "buildpack_groups": {"key": "buildpackGroups", "type": "[BuildpacksGroupProperties]"},
    }

    def __init__(
        self,
        *,
        stack: Optional["_models.StackProperties"] = None,
        buildpack_groups: Optional[List["_models.BuildpacksGroupProperties"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword stack: Builder cluster stack property.
        :paramtype stack: ~azure.mgmt.appplatform.v2023_07_01_preview.models.StackProperties
        :keyword buildpack_groups: Builder buildpack groups.
        :paramtype buildpack_groups:
         list[~azure.mgmt.appplatform.v2023_07_01_preview.models.BuildpacksGroupProperties]
        """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.stack = stack
        self.buildpack_groups = buildpack_groups


class BuilderResource(ProxyResource):
    """KPack Builder resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.appplatform.v2023_07_01_preview.models.SystemData
    :ivar properties: Property of the Builder resource.
    :vartype properties: ~azure.mgmt.appplatform.v2023_07_01_preview.models.BuilderProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "BuilderProperties"},
    }

    def __init__(self, *, properties: Optional["_models.BuilderProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: Property of the Builder resource.
        :paramtype properties: ~azure.mgmt.appplatform.v2023_07_01_preview.models.BuilderProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class BuilderResourceCollection(_serialization.Model):
    """Object that includes an array of Builder resources and a possible link for next set.

    :ivar value: Collection of Builder resources.
    :vartype value: list[~azure.mgmt.appplatform.v2023_07_01_preview.models.BuilderResource]
    :ivar next_link: URL client should use to fetch the next page (per server side paging).
     It's null for now, added for future use.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[BuilderResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.BuilderResource"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Collection of Builder resources.
        :paramtype value: list[~azure.mgmt.appplatform.v2023_07_01_preview.models.BuilderResource]
        :keyword next_link: URL client should use to fetch the next page (per server side paging).
         It's null for now, added for future use.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class BuildpackBindingLaunchProperties(_serialization.Model):
    """Buildpack Binding Launch Properties.

    :ivar properties: Non-sensitive properties for launchProperties.
    :vartype properties: dict[str, str]
    :ivar secrets: Sensitive properties for launchProperties.
    :vartype secrets: dict[str, str]
    """

    _attribute_map = {
        "properties": {"key": "properties", "type": "{str}"},
        "secrets": {"key": "secrets", "type": "{str}"},
    }

    def __init__(
        self, *, properties: Optional[Dict[str, str]] = None, secrets: Optional[Dict[str, str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword properties: Non-sensitive properties for launchProperties.
        :paramtype properties: dict[str, str]
        :keyword secrets: Sensitive properties for launchProperties.
        :paramtype secrets: dict[str, str]
        """
        super().__init__(**kwargs)
        self.properties = properties
        self.secrets = secrets


class BuildpackBindingProperties(_serialization.Model):
    """Properties of a buildpack binding.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar binding_type: Buildpack Binding Type. Known values are: "ApplicationInsights",
     "ApacheSkyWalking", "AppDynamics", "Dynatrace", "NewRelic", "ElasticAPM", and "CACertificates".
    :vartype binding_type: str or ~azure.mgmt.appplatform.v2023_07_01_preview.models.BindingType
    :ivar provisioning_state: State of the Buildpack Binding. Known values are: "Creating",
     "Updating", "Succeeded", "Failed", and "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.BuildpackBindingProvisioningState
    :ivar launch_properties: The object describes the buildpack binding launch properties.
    :vartype launch_properties:
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.BuildpackBindingLaunchProperties
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "binding_type": {"key": "bindingType", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "launch_properties": {"key": "launchProperties", "type": "BuildpackBindingLaunchProperties"},
    }

    def __init__(
        self,
        *,
        binding_type: Optional[Union[str, "_models.BindingType"]] = None,
        launch_properties: Optional["_models.BuildpackBindingLaunchProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword binding_type: Buildpack Binding Type. Known values are: "ApplicationInsights",
         "ApacheSkyWalking", "AppDynamics", "Dynatrace", "NewRelic", "ElasticAPM", and "CACertificates".
        :paramtype binding_type: str or ~azure.mgmt.appplatform.v2023_07_01_preview.models.BindingType
        :keyword launch_properties: The object describes the buildpack binding launch properties.
        :paramtype launch_properties:
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.BuildpackBindingLaunchProperties
        """
        super().__init__(**kwargs)
        self.binding_type = binding_type
        self.provisioning_state = None
        self.launch_properties = launch_properties


class BuildpackBindingResource(ProxyResource):
    """Buildpack Binding Resource object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.appplatform.v2023_07_01_preview.models.SystemData
    :ivar properties: Properties of a buildpack binding.
    :vartype properties:
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.BuildpackBindingProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "BuildpackBindingProperties"},
    }

    def __init__(self, *, properties: Optional["_models.BuildpackBindingProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: Properties of a buildpack binding.
        :paramtype properties:
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.BuildpackBindingProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class BuildpackBindingResourceCollection(_serialization.Model):
    """Object that includes an array of BuildpackBinding resources and a possible link for next set.

    :ivar value: Collection of BuildpackBinding resources.
    :vartype value:
     list[~azure.mgmt.appplatform.v2023_07_01_preview.models.BuildpackBindingResource]
    :ivar next_link: URL client should use to fetch the next page (per server side paging).
     It's null for now, added for future use.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[BuildpackBindingResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.BuildpackBindingResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Collection of BuildpackBinding resources.
        :paramtype value:
         list[~azure.mgmt.appplatform.v2023_07_01_preview.models.BuildpackBindingResource]
        :keyword next_link: URL client should use to fetch the next page (per server side paging).
         It's null for now, added for future use.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class BuildpackProperties(_serialization.Model):
    """Buildpack properties payload.

    :ivar id: Id of the buildpack.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Id of the buildpack.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class BuildpacksGroupProperties(_serialization.Model):
    """Buildpack group properties of the Builder.

    :ivar name: Buildpack group name.
    :vartype name: str
    :ivar buildpacks: Buildpacks in the buildpack group.
    :vartype buildpacks:
     list[~azure.mgmt.appplatform.v2023_07_01_preview.models.BuildpackProperties]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "buildpacks": {"key": "buildpacks", "type": "[BuildpackProperties]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        buildpacks: Optional[List["_models.BuildpackProperties"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Buildpack group name.
        :paramtype name: str
        :keyword buildpacks: Buildpacks in the buildpack group.
        :paramtype buildpacks:
         list[~azure.mgmt.appplatform.v2023_07_01_preview.models.BuildpackProperties]
        """
        super().__init__(**kwargs)
        self.name = name
        self.buildpacks = buildpacks


class BuildProperties(_serialization.Model):
    """Build resource properties payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar relative_path: The relative path of source code.
    :vartype relative_path: str
    :ivar builder: The resource id of builder to build the source code.
    :vartype builder: str
    :ivar agent_pool: The resource id of agent pool.
    :vartype agent_pool: str
    :ivar provisioning_state: Provisioning state of the KPack build result. Known values are:
     "Creating", "Updating", "Succeeded", "Failed", and "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.BuildProvisioningState
    :ivar env: The environment variables for this build.
    :vartype env: dict[str, str]
    :ivar apms: The APMs for this build.
    :vartype apms: list[~azure.mgmt.appplatform.v2023_07_01_preview.models.ApmReference]
    :ivar certificates: The CA Certificates for this build.
    :vartype certificates:
     list[~azure.mgmt.appplatform.v2023_07_01_preview.models.CertificateReference]
    :ivar triggered_build_result: The build result triggered by this build.
    :vartype triggered_build_result:
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.TriggeredBuildResult
    :ivar resource_requests: The customized build resource for this build.
    :vartype resource_requests:
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.BuildResourceRequests
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "triggered_build_result": {"readonly": True},
    }

    _attribute_map = {
        "relative_path": {"key": "relativePath", "type": "str"},
        "builder": {"key": "builder", "type": "str"},
        "agent_pool": {"key": "agentPool", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "env": {"key": "env", "type": "{str}"},
        "apms": {"key": "apms", "type": "[ApmReference]"},
        "certificates": {"key": "certificates", "type": "[CertificateReference]"},
        "triggered_build_result": {"key": "triggeredBuildResult", "type": "TriggeredBuildResult"},
        "resource_requests": {"key": "resourceRequests", "type": "BuildResourceRequests"},
    }

    def __init__(
        self,
        *,
        relative_path: Optional[str] = None,
        builder: Optional[str] = None,
        agent_pool: Optional[str] = None,
        env: Optional[Dict[str, str]] = None,
        apms: Optional[List["_models.ApmReference"]] = None,
        certificates: Optional[List["_models.CertificateReference"]] = None,
        resource_requests: Optional["_models.BuildResourceRequests"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword relative_path: The relative path of source code.
        :paramtype relative_path: str
        :keyword builder: The resource id of builder to build the source code.
        :paramtype builder: str
        :keyword agent_pool: The resource id of agent pool.
        :paramtype agent_pool: str
        :keyword env: The environment variables for this build.
        :paramtype env: dict[str, str]
        :keyword apms: The APMs for this build.
        :paramtype apms: list[~azure.mgmt.appplatform.v2023_07_01_preview.models.ApmReference]
        :keyword certificates: The CA Certificates for this build.
        :paramtype certificates:
         list[~azure.mgmt.appplatform.v2023_07_01_preview.models.CertificateReference]
        :keyword resource_requests: The customized build resource for this build.
        :paramtype resource_requests:
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.BuildResourceRequests
        """
        super().__init__(**kwargs)
        self.relative_path = relative_path
        self.builder = builder
        self.agent_pool = agent_pool
        self.provisioning_state = None
        self.env = env
        self.apms = apms
        self.certificates = certificates
        self.triggered_build_result = None
        self.resource_requests = resource_requests


class BuildResourceRequests(_serialization.Model):
    """Resource request payload of Build Resource.

    :ivar cpu: Optional Cpu allocated to the build resource. 1 core can be represented by 1 or
     1000m.
     The default value is 1, this should not exceed build service agent pool cpu size.
    :vartype cpu: str
    :ivar memory: Optional Memory allocated to the build resource. 1 GB can be represented by 1Gi
     or 1024Mi.
     The default value is 2Gi, this should not exceed build service agent pool memory size.
    :vartype memory: str
    """

    _attribute_map = {
        "cpu": {"key": "cpu", "type": "str"},
        "memory": {"key": "memory", "type": "str"},
    }

    def __init__(self, *, cpu: str = "1", memory: str = "2Gi", **kwargs: Any) -> None:
        """
        :keyword cpu: Optional Cpu allocated to the build resource. 1 core can be represented by 1 or
         1000m.
         The default value is 1, this should not exceed build service agent pool cpu size.
        :paramtype cpu: str
        :keyword memory: Optional Memory allocated to the build resource. 1 GB can be represented by
         1Gi or 1024Mi.
         The default value is 2Gi, this should not exceed build service agent pool memory size.
        :paramtype memory: str
        """
        super().__init__(**kwargs)
        self.cpu = cpu
        self.memory = memory


class BuildResult(ProxyResource):
    """Build result resource payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.appplatform.v2023_07_01_preview.models.SystemData
    :ivar properties: Properties of the build result resource.
    :vartype properties: ~azure.mgmt.appplatform.v2023_07_01_preview.models.BuildResultProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "BuildResultProperties"},
    }

    def __init__(self, *, properties: Optional["_models.BuildResultProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: Properties of the build result resource.
        :paramtype properties: ~azure.mgmt.appplatform.v2023_07_01_preview.models.BuildResultProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class BuildResultCollection(_serialization.Model):
    """Object that includes an array of Build result resources and a possible link for next set.

    :ivar value: Collection of Build result resources.
    :vartype value: list[~azure.mgmt.appplatform.v2023_07_01_preview.models.BuildResult]
    :ivar next_link: URL client should use to fetch the next page (per server side paging).
     It's null for now, added for future use.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[BuildResult]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.BuildResult"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Collection of Build result resources.
        :paramtype value: list[~azure.mgmt.appplatform.v2023_07_01_preview.models.BuildResult]
        :keyword next_link: URL client should use to fetch the next page (per server side paging).
         It's null for now, added for future use.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class BuildResultLog(_serialization.Model):
    """Build result log resource properties payload.

    :ivar blob_url: The public download URL of this build result log.
    :vartype blob_url: str
    """

    _attribute_map = {
        "blob_url": {"key": "blobUrl", "type": "str"},
    }

    def __init__(self, *, blob_url: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword blob_url: The public download URL of this build result log.
        :paramtype blob_url: str
        """
        super().__init__(**kwargs)
        self.blob_url = blob_url


class BuildResultProperties(_serialization.Model):
    """Build result resource properties payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of this build result.
    :vartype name: str
    :ivar provisioning_state: Provisioning state of the KPack build result. Known values are:
     "Queuing", "Building", "Succeeded", "Failed", and "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.BuildResultProvisioningState
    :ivar error: Error when build is failed.
    :vartype error: ~azure.mgmt.appplatform.v2023_07_01_preview.models.Error
    :ivar build_pod_name: The build pod name which can be used to get the build log streaming.
    :vartype build_pod_name: str
    :ivar build_stages: All of the build stage (init-container and container) resources in build
     pod.
    :vartype build_stages:
     list[~azure.mgmt.appplatform.v2023_07_01_preview.models.BuildStageProperties]
    :ivar image: The container registry image of this build result.
    :vartype image: str
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "build_stages": {"readonly": True},
        "image": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "error": {"key": "error", "type": "Error"},
        "build_pod_name": {"key": "buildPodName", "type": "str"},
        "build_stages": {"key": "buildStages", "type": "[BuildStageProperties]"},
        "image": {"key": "image", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        error: Optional["_models.Error"] = None,
        build_pod_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of this build result.
        :paramtype name: str
        :keyword error: Error when build is failed.
        :paramtype error: ~azure.mgmt.appplatform.v2023_07_01_preview.models.Error
        :keyword build_pod_name: The build pod name which can be used to get the build log streaming.
        :paramtype build_pod_name: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.provisioning_state = None
        self.error = error
        self.build_pod_name = build_pod_name
        self.build_stages = None
        self.image = None


class UserSourceInfo(_serialization.Model):
    """Source information for a deployment.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    BuildResultUserSourceInfo, CustomContainerUserSourceInfo, UploadedUserSourceInfo

    All required parameters must be populated in order to send to Azure.

    :ivar type: Type of the source uploaded. Required.
    :vartype type: str
    :ivar version: Version of the source.
    :vartype version: str
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "version": {"key": "version", "type": "str"},
    }

    _subtype_map = {
        "type": {
            "BuildResult": "BuildResultUserSourceInfo",
            "Container": "CustomContainerUserSourceInfo",
            "UploadedUserSourceInfo": "UploadedUserSourceInfo",
        }
    }

    def __init__(self, *, version: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword version: Version of the source.
        :paramtype version: str
        """
        super().__init__(**kwargs)
        self.type: Optional[str] = None
        self.version = version


class BuildResultUserSourceInfo(UserSourceInfo):
    """Reference to a build result.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Type of the source uploaded. Required.
    :vartype type: str
    :ivar version: Version of the source.
    :vartype version: str
    :ivar build_result_id: Resource id of an existing succeeded build result under the same Spring
     instance.
    :vartype build_result_id: str
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "version": {"key": "version", "type": "str"},
        "build_result_id": {"key": "buildResultId", "type": "str"},
    }

    def __init__(self, *, version: Optional[str] = None, build_result_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword version: Version of the source.
        :paramtype version: str
        :keyword build_result_id: Resource id of an existing succeeded build result under the same
         Spring instance.
        :paramtype build_result_id: str
        """
        super().__init__(version=version, **kwargs)
        self.type: str = "BuildResult"
        self.build_result_id = build_result_id


class BuildService(ProxyResource):
    """Build service resource payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.appplatform.v2023_07_01_preview.models.SystemData
    :ivar properties: Properties of the build resource.
    :vartype properties: ~azure.mgmt.appplatform.v2023_07_01_preview.models.BuildServiceProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "BuildServiceProperties"},
    }

    def __init__(self, *, properties: Optional["_models.BuildServiceProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: Properties of the build resource.
        :paramtype properties:
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.BuildServiceProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class BuildServiceAgentPoolProperties(_serialization.Model):
    """Build service agent pool properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: Provisioning state of the build service agent pool.
    :vartype provisioning_state: str
    :ivar pool_size: build service agent pool size properties.
    :vartype pool_size:
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.BuildServiceAgentPoolSizeProperties
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "pool_size": {"key": "poolSize", "type": "BuildServiceAgentPoolSizeProperties"},
    }

    def __init__(
        self, *, pool_size: Optional["_models.BuildServiceAgentPoolSizeProperties"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword pool_size: build service agent pool size properties.
        :paramtype pool_size:
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.BuildServiceAgentPoolSizeProperties
        """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.pool_size = pool_size


class BuildServiceAgentPoolResource(ProxyResource):
    """The build service agent pool resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.appplatform.v2023_07_01_preview.models.SystemData
    :ivar properties: build service agent pool properties.
    :vartype properties:
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.BuildServiceAgentPoolProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "BuildServiceAgentPoolProperties"},
    }

    def __init__(
        self, *, properties: Optional["_models.BuildServiceAgentPoolProperties"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword properties: build service agent pool properties.
        :paramtype properties:
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.BuildServiceAgentPoolProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class BuildServiceAgentPoolResourceCollection(_serialization.Model):
    """Object that includes an array of build service agent pool resources and a possible link for
    next set.

    :ivar value: Collection of build service agent pool resource.
    :vartype value:
     list[~azure.mgmt.appplatform.v2023_07_01_preview.models.BuildServiceAgentPoolResource]
    :ivar next_link: URL client should use to fetch the next page (per server side paging).
     It's null for now, added for future use.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[BuildServiceAgentPoolResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.BuildServiceAgentPoolResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Collection of build service agent pool resource.
        :paramtype value:
         list[~azure.mgmt.appplatform.v2023_07_01_preview.models.BuildServiceAgentPoolResource]
        :keyword next_link: URL client should use to fetch the next page (per server side paging).
         It's null for now, added for future use.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class BuildServiceAgentPoolSizeProperties(_serialization.Model):
    """Build service agent pool size properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of build service agent pool size.
    :vartype name: str
    :ivar cpu: The cpu property of build service agent pool size.
    :vartype cpu: str
    :ivar memory: The memory property of build service agent pool size.
    :vartype memory: str
    """

    _validation = {
        "cpu": {"readonly": True},
        "memory": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "cpu": {"key": "cpu", "type": "str"},
        "memory": {"key": "memory", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: The name of build service agent pool size.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.cpu = None
        self.memory = None


class BuildServiceCollection(_serialization.Model):
    """Object that includes an array of Build service resources and a possible link for next set.

    :ivar value: Collection of Build service resources.
    :vartype value: list[~azure.mgmt.appplatform.v2023_07_01_preview.models.BuildService]
    :ivar next_link: URL client should use to fetch the next page (per server side paging).
     It's null for now, added for future use.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[BuildService]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.BuildService"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Collection of Build service resources.
        :paramtype value: list[~azure.mgmt.appplatform.v2023_07_01_preview.models.BuildService]
        :keyword next_link: URL client should use to fetch the next page (per server side paging).
         It's null for now, added for future use.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class BuildServiceProperties(_serialization.Model):
    """Build service resource properties payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar container_registry: The resource id of the container registry used in this build service.
    :vartype container_registry: str
    :ivar k_pack_version: The installed KPack version in this build service.
    :vartype k_pack_version: str
    :ivar provisioning_state: Provisioning state of the KPack build service. Known values are:
     "Creating", "Updating", "Succeeded", "Failed", and "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.BuildServiceProvisioningState
    :ivar resource_requests: The runtime resource configuration of this build service.
    :vartype resource_requests:
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.BuildServicePropertiesResourceRequests
    """

    _validation = {
        "k_pack_version": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "container_registry": {"key": "containerRegistry", "type": "str"},
        "k_pack_version": {"key": "kPackVersion", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "resource_requests": {"key": "resourceRequests", "type": "BuildServicePropertiesResourceRequests"},
    }

    def __init__(
        self,
        *,
        container_registry: Optional[str] = None,
        resource_requests: Optional["_models.BuildServicePropertiesResourceRequests"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword container_registry: The resource id of the container registry used in this build
         service.
        :paramtype container_registry: str
        :keyword resource_requests: The runtime resource configuration of this build service.
        :paramtype resource_requests:
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.BuildServicePropertiesResourceRequests
        """
        super().__init__(**kwargs)
        self.container_registry = container_registry
        self.k_pack_version = None
        self.provisioning_state = None
        self.resource_requests = resource_requests


class BuildServicePropertiesResourceRequests(_serialization.Model):
    """The runtime resource configuration of this build service.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar cpu: vCPU allocated to the entire build service node pool.
    :vartype cpu: str
    :ivar memory: Memory allocated to the entire build service node pool.
    :vartype memory: str
    """

    _validation = {
        "cpu": {"readonly": True},
        "memory": {"readonly": True},
    }

    _attribute_map = {
        "cpu": {"key": "cpu", "type": "str"},
        "memory": {"key": "memory", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.cpu = None
        self.memory = None


class BuildStageProperties(_serialization.Model):
    """The build stage (init-container and container) resources in build pod.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of this build stage resource.
    :vartype name: str
    :ivar status: The provisioning state of this build stage resource. Known values are:
     "NotStarted", "Running", "Succeeded", and "Failed".
    :vartype status: str or
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.KPackBuildStageProvisioningState
    :ivar exit_code: The exit code of this build init container.
    :vartype exit_code: str
    :ivar reason: The reason of this build init container.
    :vartype reason: str
    """

    _validation = {
        "name": {"readonly": True},
        "status": {"readonly": True},
        "exit_code": {"readonly": True},
        "reason": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "exit_code": {"key": "exitCode", "type": "str"},
        "reason": {"key": "reason", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.status = None
        self.exit_code = None
        self.reason = None


class CertificateProperties(_serialization.Model):
    """Certificate resource payload.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ContentCertificateProperties, KeyVaultCertificateProperties

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: The type of the certificate source. Required.
    :vartype type: str
    :ivar thumbprint: The thumbprint of certificate.
    :vartype thumbprint: str
    :ivar issuer: The issuer of certificate.
    :vartype issuer: str
    :ivar issued_date: The issue date of certificate.
    :vartype issued_date: str
    :ivar expiration_date: The expiration date of certificate.
    :vartype expiration_date: str
    :ivar activate_date: The activate date of certificate.
    :vartype activate_date: str
    :ivar subject_name: The subject name of certificate.
    :vartype subject_name: str
    :ivar dns_names: The domain list of certificate.
    :vartype dns_names: list[str]
    :ivar provisioning_state: Provisioning state of the Certificate. Known values are: "Creating",
     "Updating", "Succeeded", "Failed", and "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.CertificateResourceProvisioningState
    """

    _validation = {
        "type": {"required": True},
        "thumbprint": {"readonly": True},
        "issuer": {"readonly": True},
        "issued_date": {"readonly": True},
        "expiration_date": {"readonly": True},
        "activate_date": {"readonly": True},
        "subject_name": {"readonly": True},
        "dns_names": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "thumbprint": {"key": "thumbprint", "type": "str"},
        "issuer": {"key": "issuer", "type": "str"},
        "issued_date": {"key": "issuedDate", "type": "str"},
        "expiration_date": {"key": "expirationDate", "type": "str"},
        "activate_date": {"key": "activateDate", "type": "str"},
        "subject_name": {"key": "subjectName", "type": "str"},
        "dns_names": {"key": "dnsNames", "type": "[str]"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    _subtype_map = {
        "type": {
            "ContentCertificate": "ContentCertificateProperties",
            "KeyVaultCertificate": "KeyVaultCertificateProperties",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type: Optional[str] = None
        self.thumbprint = None
        self.issuer = None
        self.issued_date = None
        self.expiration_date = None
        self.activate_date = None
        self.subject_name = None
        self.dns_names = None
        self.provisioning_state = None


class CertificateReference(_serialization.Model):
    """A reference to the certificate.

    All required parameters must be populated in order to send to Azure.

    :ivar resource_id: Resource Id of the certificate. Required.
    :vartype resource_id: str
    """

    _validation = {
        "resource_id": {"required": True},
    }

    _attribute_map = {
        "resource_id": {"key": "resourceId", "type": "str"},
    }

    def __init__(self, *, resource_id: str, **kwargs: Any) -> None:
        """
        :keyword resource_id: Resource Id of the certificate. Required.
        :paramtype resource_id: str
        """
        super().__init__(**kwargs)
        self.resource_id = resource_id


class CertificateResource(ProxyResource):
    """Certificate resource payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.appplatform.v2023_07_01_preview.models.SystemData
    :ivar properties: Properties of the certificate resource payload.
    :vartype properties: ~azure.mgmt.appplatform.v2023_07_01_preview.models.CertificateProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "CertificateProperties"},
    }

    def __init__(self, *, properties: Optional["_models.CertificateProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: Properties of the certificate resource payload.
        :paramtype properties: ~azure.mgmt.appplatform.v2023_07_01_preview.models.CertificateProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class CertificateResourceCollection(_serialization.Model):
    """Collection compose of certificate resources list and a possible link for next page.

    :ivar value: The certificate resources list.
    :vartype value: list[~azure.mgmt.appplatform.v2023_07_01_preview.models.CertificateResource]
    :ivar next_link: The link to next page of certificate list.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[CertificateResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.CertificateResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The certificate resources list.
        :paramtype value: list[~azure.mgmt.appplatform.v2023_07_01_preview.models.CertificateResource]
        :keyword next_link: The link to next page of certificate list.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class CloudErrorBody(_serialization.Model):
    """An error response from the service.

    :ivar code: An identifier for the error. Codes are invariant and are intended to be consumed
     programmatically.
    :vartype code: str
    :ivar message: A message describing the error, intended to be suitable for display in a user
     interface.
    :vartype message: str
    :ivar target: The target of the particular error. For example, the name of the property in
     error.
    :vartype target: str
    :ivar details: A list of additional details about the error.
    :vartype details: list[~azure.mgmt.appplatform.v2023_07_01_preview.models.CloudErrorBody]
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[CloudErrorBody]"},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        target: Optional[str] = None,
        details: Optional[List["_models.CloudErrorBody"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword code: An identifier for the error. Codes are invariant and are intended to be consumed
         programmatically.
        :paramtype code: str
        :keyword message: A message describing the error, intended to be suitable for display in a user
         interface.
        :paramtype message: str
        :keyword target: The target of the particular error. For example, the name of the property in
         error.
        :paramtype target: str
        :keyword details: A list of additional details about the error.
        :paramtype details: list[~azure.mgmt.appplatform.v2023_07_01_preview.models.CloudErrorBody]
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details


class ClusterResourceProperties(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Service properties payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: Provisioning state of the Service. Known values are: "Creating",
     "Updating", "Starting", "Stopping", "Deleting", "Deleted", "Succeeded", "Failed", "Moving",
     "Moved", and "MoveFailed".
    :vartype provisioning_state: str or
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.ProvisioningState
    :ivar network_profile: Network profile of the Service.
    :vartype network_profile: ~azure.mgmt.appplatform.v2023_07_01_preview.models.NetworkProfile
    :ivar vnet_addons: Additional Service settings in vnet injection instance.
    :vartype vnet_addons: ~azure.mgmt.appplatform.v2023_07_01_preview.models.ServiceVNetAddons
    :ivar maintenance_schedule_configuration: Additional Service settings for planned maintenance.
    :vartype maintenance_schedule_configuration:
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.MaintenanceScheduleConfiguration
    :ivar version: Version of the Service.
    :vartype version: int
    :ivar service_id: ServiceInstanceEntity Id which uniquely identifies a created resource.
    :vartype service_id: str
    :ivar managed_environment_id: The resource Id of the Managed Environment that the Spring Apps
     instance builds on.
    :vartype managed_environment_id: str
    :ivar infra_resource_group: The name of the resource group that contains the infrastructure
     resources.
    :vartype infra_resource_group: str
    :ivar power_state: Power state of the Service. Known values are: "Running" and "Stopped".
    :vartype power_state: str or ~azure.mgmt.appplatform.v2023_07_01_preview.models.PowerState
    :ivar zone_redundant:
    :vartype zone_redundant: bool
    :ivar fqdn: Fully qualified dns name of the service instance.
    :vartype fqdn: str
    :ivar marketplace_resource: Purchasing 3rd party product of the Service resource.
    :vartype marketplace_resource:
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.MarketplaceResource
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "version": {"readonly": True},
        "service_id": {"readonly": True},
        "power_state": {"readonly": True},
        "fqdn": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "network_profile": {"key": "networkProfile", "type": "NetworkProfile"},
        "vnet_addons": {"key": "vnetAddons", "type": "ServiceVNetAddons"},
        "maintenance_schedule_configuration": {
            "key": "maintenanceScheduleConfiguration",
            "type": "MaintenanceScheduleConfiguration",
        },
        "version": {"key": "version", "type": "int"},
        "service_id": {"key": "serviceId", "type": "str"},
        "managed_environment_id": {"key": "managedEnvironmentId", "type": "str"},
        "infra_resource_group": {"key": "infraResourceGroup", "type": "str"},
        "power_state": {"key": "powerState", "type": "str"},
        "zone_redundant": {"key": "zoneRedundant", "type": "bool"},
        "fqdn": {"key": "fqdn", "type": "str"},
        "marketplace_resource": {"key": "marketplaceResource", "type": "MarketplaceResource"},
    }

    def __init__(
        self,
        *,
        network_profile: Optional["_models.NetworkProfile"] = None,
        vnet_addons: Optional["_models.ServiceVNetAddons"] = None,
        maintenance_schedule_configuration: Optional["_models.MaintenanceScheduleConfiguration"] = None,
        managed_environment_id: Optional[str] = None,
        infra_resource_group: Optional[str] = None,
        zone_redundant: bool = False,
        marketplace_resource: Optional["_models.MarketplaceResource"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword network_profile: Network profile of the Service.
        :paramtype network_profile: ~azure.mgmt.appplatform.v2023_07_01_preview.models.NetworkProfile
        :keyword vnet_addons: Additional Service settings in vnet injection instance.
        :paramtype vnet_addons: ~azure.mgmt.appplatform.v2023_07_01_preview.models.ServiceVNetAddons
        :keyword maintenance_schedule_configuration: Additional Service settings for planned
         maintenance.
        :paramtype maintenance_schedule_configuration:
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.MaintenanceScheduleConfiguration
        :keyword managed_environment_id: The resource Id of the Managed Environment that the Spring
         Apps instance builds on.
        :paramtype managed_environment_id: str
        :keyword infra_resource_group: The name of the resource group that contains the infrastructure
         resources.
        :paramtype infra_resource_group: str
        :keyword zone_redundant:
        :paramtype zone_redundant: bool
        :keyword marketplace_resource: Purchasing 3rd party product of the Service resource.
        :paramtype marketplace_resource:
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.MarketplaceResource
        """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.network_profile = network_profile
        self.vnet_addons = vnet_addons
        self.maintenance_schedule_configuration = maintenance_schedule_configuration
        self.version = None
        self.service_id = None
        self.managed_environment_id = managed_environment_id
        self.infra_resource_group = infra_resource_group
        self.power_state = None
        self.zone_redundant = zone_redundant
        self.fqdn = None
        self.marketplace_resource = marketplace_resource


class ConfigServerGitProperty(_serialization.Model):
    """Property of git.

    All required parameters must be populated in order to send to Azure.

    :ivar repositories: Repositories of git.
    :vartype repositories:
     list[~azure.mgmt.appplatform.v2023_07_01_preview.models.GitPatternRepository]
    :ivar uri: URI of the repository. Required.
    :vartype uri: str
    :ivar label: Label of the repository.
    :vartype label: str
    :ivar search_paths: Searching path of the repository.
    :vartype search_paths: list[str]
    :ivar username: Username of git repository basic auth.
    :vartype username: str
    :ivar password: Password of git repository basic auth.
    :vartype password: str
    :ivar host_key: Public sshKey of git repository.
    :vartype host_key: str
    :ivar host_key_algorithm: SshKey algorithm of git repository.
    :vartype host_key_algorithm: str
    :ivar private_key: Private sshKey algorithm of git repository.
    :vartype private_key: str
    :ivar strict_host_key_checking: Strict host key checking or not.
    :vartype strict_host_key_checking: bool
    """

    _validation = {
        "uri": {"required": True},
    }

    _attribute_map = {
        "repositories": {"key": "repositories", "type": "[GitPatternRepository]"},
        "uri": {"key": "uri", "type": "str"},
        "label": {"key": "label", "type": "str"},
        "search_paths": {"key": "searchPaths", "type": "[str]"},
        "username": {"key": "username", "type": "str"},
        "password": {"key": "password", "type": "str"},
        "host_key": {"key": "hostKey", "type": "str"},
        "host_key_algorithm": {"key": "hostKeyAlgorithm", "type": "str"},
        "private_key": {"key": "privateKey", "type": "str"},
        "strict_host_key_checking": {"key": "strictHostKeyChecking", "type": "bool"},
    }

    def __init__(
        self,
        *,
        uri: str,
        repositories: Optional[List["_models.GitPatternRepository"]] = None,
        label: Optional[str] = None,
        search_paths: Optional[List[str]] = None,
        username: Optional[str] = None,
        password: Optional[str] = None,
        host_key: Optional[str] = None,
        host_key_algorithm: Optional[str] = None,
        private_key: Optional[str] = None,
        strict_host_key_checking: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword repositories: Repositories of git.
        :paramtype repositories:
         list[~azure.mgmt.appplatform.v2023_07_01_preview.models.GitPatternRepository]
        :keyword uri: URI of the repository. Required.
        :paramtype uri: str
        :keyword label: Label of the repository.
        :paramtype label: str
        :keyword search_paths: Searching path of the repository.
        :paramtype search_paths: list[str]
        :keyword username: Username of git repository basic auth.
        :paramtype username: str
        :keyword password: Password of git repository basic auth.
        :paramtype password: str
        :keyword host_key: Public sshKey of git repository.
        :paramtype host_key: str
        :keyword host_key_algorithm: SshKey algorithm of git repository.
        :paramtype host_key_algorithm: str
        :keyword private_key: Private sshKey algorithm of git repository.
        :paramtype private_key: str
        :keyword strict_host_key_checking: Strict host key checking or not.
        :paramtype strict_host_key_checking: bool
        """
        super().__init__(**kwargs)
        self.repositories = repositories
        self.uri = uri
        self.label = label
        self.search_paths = search_paths
        self.username = username
        self.password = password
        self.host_key = host_key
        self.host_key_algorithm = host_key_algorithm
        self.private_key = private_key
        self.strict_host_key_checking = strict_host_key_checking


class ConfigServerProperties(_serialization.Model):
    """Config server git properties payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: State of the config server. Known values are: "NotAvailable",
     "Deleted", "Failed", "Succeeded", and "Updating".
    :vartype provisioning_state: str or
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.ConfigServerState
    :ivar error: Error when apply config server settings.
    :vartype error: ~azure.mgmt.appplatform.v2023_07_01_preview.models.Error
    :ivar enabled_state: Enabled state of the config server. This is only used in Consumption tier.
     Known values are: "Enabled" and "Disabled".
    :vartype enabled_state: str or
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.ConfigServerEnabledState
    :ivar config_server: Settings of config server.
    :vartype config_server: ~azure.mgmt.appplatform.v2023_07_01_preview.models.ConfigServerSettings
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "error": {"key": "error", "type": "Error"},
        "enabled_state": {"key": "enabledState", "type": "str"},
        "config_server": {"key": "configServer", "type": "ConfigServerSettings"},
    }

    def __init__(
        self,
        *,
        error: Optional["_models.Error"] = None,
        enabled_state: Optional[Union[str, "_models.ConfigServerEnabledState"]] = None,
        config_server: Optional["_models.ConfigServerSettings"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword error: Error when apply config server settings.
        :paramtype error: ~azure.mgmt.appplatform.v2023_07_01_preview.models.Error
        :keyword enabled_state: Enabled state of the config server. This is only used in Consumption
         tier. Known values are: "Enabled" and "Disabled".
        :paramtype enabled_state: str or
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.ConfigServerEnabledState
        :keyword config_server: Settings of config server.
        :paramtype config_server:
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.ConfigServerSettings
        """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.error = error
        self.enabled_state = enabled_state
        self.config_server = config_server


class ConfigServerResource(ProxyResource):
    """Config Server resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.appplatform.v2023_07_01_preview.models.SystemData
    :ivar properties: Properties of the Config Server resource.
    :vartype properties: ~azure.mgmt.appplatform.v2023_07_01_preview.models.ConfigServerProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "ConfigServerProperties"},
    }

    def __init__(self, *, properties: Optional["_models.ConfigServerProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: Properties of the Config Server resource.
        :paramtype properties:
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.ConfigServerProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class ConfigServerSettings(_serialization.Model):
    """The settings of config server.

    :ivar git_property: Property of git environment.
    :vartype git_property:
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.ConfigServerGitProperty
    """

    _attribute_map = {
        "git_property": {"key": "gitProperty", "type": "ConfigServerGitProperty"},
    }

    def __init__(self, *, git_property: Optional["_models.ConfigServerGitProperty"] = None, **kwargs: Any) -> None:
        """
        :keyword git_property: Property of git environment.
        :paramtype git_property:
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.ConfigServerGitProperty
        """
        super().__init__(**kwargs)
        self.git_property = git_property


class ConfigServerSettingsErrorRecord(_serialization.Model):
    """Error record of the config server settings.

    :ivar name: The name of the config server settings error record.
    :vartype name: str
    :ivar uri: The uri of the config server settings error record.
    :vartype uri: str
    :ivar messages: The detail error messages of the record.
    :vartype messages: list[str]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "uri": {"key": "uri", "type": "str"},
        "messages": {"key": "messages", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        uri: Optional[str] = None,
        messages: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the config server settings error record.
        :paramtype name: str
        :keyword uri: The uri of the config server settings error record.
        :paramtype uri: str
        :keyword messages: The detail error messages of the record.
        :paramtype messages: list[str]
        """
        super().__init__(**kwargs)
        self.name = name
        self.uri = uri
        self.messages = messages


class ConfigServerSettingsValidateResult(_serialization.Model):
    """Validation result for config server settings.

    :ivar is_valid: Indicate if the config server settings are valid.
    :vartype is_valid: bool
    :ivar details: The detail validation results.
    :vartype details:
     list[~azure.mgmt.appplatform.v2023_07_01_preview.models.ConfigServerSettingsErrorRecord]
    """

    _attribute_map = {
        "is_valid": {"key": "isValid", "type": "bool"},
        "details": {"key": "details", "type": "[ConfigServerSettingsErrorRecord]"},
    }

    def __init__(
        self,
        *,
        is_valid: Optional[bool] = None,
        details: Optional[List["_models.ConfigServerSettingsErrorRecord"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword is_valid: Indicate if the config server settings are valid.
        :paramtype is_valid: bool
        :keyword details: The detail validation results.
        :paramtype details:
         list[~azure.mgmt.appplatform.v2023_07_01_preview.models.ConfigServerSettingsErrorRecord]
        """
        super().__init__(**kwargs)
        self.is_valid = is_valid
        self.details = details


class ConfigurationServiceGitProperty(_serialization.Model):
    """Property of git environment.

    :ivar repositories: Repositories of Application Configuration Service git property.
    :vartype repositories:
     list[~azure.mgmt.appplatform.v2023_07_01_preview.models.ConfigurationServiceGitRepository]
    """

    _attribute_map = {
        "repositories": {"key": "repositories", "type": "[ConfigurationServiceGitRepository]"},
    }

    def __init__(
        self, *, repositories: Optional[List["_models.ConfigurationServiceGitRepository"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword repositories: Repositories of Application Configuration Service git property.
        :paramtype repositories:
         list[~azure.mgmt.appplatform.v2023_07_01_preview.models.ConfigurationServiceGitRepository]
        """
        super().__init__(**kwargs)
        self.repositories = repositories


class ConfigurationServiceGitPropertyValidateResult(_serialization.Model):
    """Validation result for configuration service settings.

    :ivar is_valid: Indicate if the configuration service settings are valid.
    :vartype is_valid: bool
    :ivar git_repos_validation_result: The detail validation results.
    :vartype git_repos_validation_result:
     list[~azure.mgmt.appplatform.v2023_07_01_preview.models.ValidationMessages]
    """

    _attribute_map = {
        "is_valid": {"key": "isValid", "type": "bool"},
        "git_repos_validation_result": {"key": "gitReposValidationResult", "type": "[ValidationMessages]"},
    }

    def __init__(
        self,
        *,
        is_valid: Optional[bool] = None,
        git_repos_validation_result: Optional[List["_models.ValidationMessages"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword is_valid: Indicate if the configuration service settings are valid.
        :paramtype is_valid: bool
        :keyword git_repos_validation_result: The detail validation results.
        :paramtype git_repos_validation_result:
         list[~azure.mgmt.appplatform.v2023_07_01_preview.models.ValidationMessages]
        """
        super().__init__(**kwargs)
        self.is_valid = is_valid
        self.git_repos_validation_result = git_repos_validation_result


class ConfigurationServiceGitRepository(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Git repository property payload for Application Configuration Service.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Name of the repository. Required.
    :vartype name: str
    :ivar patterns: Collection of patterns of the repository. Required.
    :vartype patterns: list[str]
    :ivar uri: URI of the repository. Required.
    :vartype uri: str
    :ivar label: Label of the repository. Required.
    :vartype label: str
    :ivar search_paths: Searching path of the repository.
    :vartype search_paths: list[str]
    :ivar username: Username of git repository basic auth.
    :vartype username: str
    :ivar password: Password of git repository basic auth.
    :vartype password: str
    :ivar host_key: Public sshKey of git repository.
    :vartype host_key: str
    :ivar host_key_algorithm: SshKey algorithm of git repository.
    :vartype host_key_algorithm: str
    :ivar private_key: Private sshKey algorithm of git repository.
    :vartype private_key: str
    :ivar strict_host_key_checking: Strict host key checking or not.
    :vartype strict_host_key_checking: bool
    :ivar git_implementation: Git libraries used to support various repository providers. Known
     values are: "go-git" and "libgit2".
    :vartype git_implementation: str or
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.GitImplementation
    :ivar ca_cert_resource_id: Resource Id of CA certificate for https URL of Git repository.
    :vartype ca_cert_resource_id: str
    """

    _validation = {
        "name": {"required": True},
        "patterns": {"required": True},
        "uri": {"required": True},
        "label": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "patterns": {"key": "patterns", "type": "[str]"},
        "uri": {"key": "uri", "type": "str"},
        "label": {"key": "label", "type": "str"},
        "search_paths": {"key": "searchPaths", "type": "[str]"},
        "username": {"key": "username", "type": "str"},
        "password": {"key": "password", "type": "str"},
        "host_key": {"key": "hostKey", "type": "str"},
        "host_key_algorithm": {"key": "hostKeyAlgorithm", "type": "str"},
        "private_key": {"key": "privateKey", "type": "str"},
        "strict_host_key_checking": {"key": "strictHostKeyChecking", "type": "bool"},
        "git_implementation": {"key": "gitImplementation", "type": "str"},
        "ca_cert_resource_id": {"key": "caCertResourceId", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: str,
        patterns: List[str],
        uri: str,
        label: str,
        search_paths: Optional[List[str]] = None,
        username: Optional[str] = None,
        password: Optional[str] = None,
        host_key: Optional[str] = None,
        host_key_algorithm: Optional[str] = None,
        private_key: Optional[str] = None,
        strict_host_key_checking: Optional[bool] = None,
        git_implementation: Optional[Union[str, "_models.GitImplementation"]] = None,
        ca_cert_resource_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the repository. Required.
        :paramtype name: str
        :keyword patterns: Collection of patterns of the repository. Required.
        :paramtype patterns: list[str]
        :keyword uri: URI of the repository. Required.
        :paramtype uri: str
        :keyword label: Label of the repository. Required.
        :paramtype label: str
        :keyword search_paths: Searching path of the repository.
        :paramtype search_paths: list[str]
        :keyword username: Username of git repository basic auth.
        :paramtype username: str
        :keyword password: Password of git repository basic auth.
        :paramtype password: str
        :keyword host_key: Public sshKey of git repository.
        :paramtype host_key: str
        :keyword host_key_algorithm: SshKey algorithm of git repository.
        :paramtype host_key_algorithm: str
        :keyword private_key: Private sshKey algorithm of git repository.
        :paramtype private_key: str
        :keyword strict_host_key_checking: Strict host key checking or not.
        :paramtype strict_host_key_checking: bool
        :keyword git_implementation: Git libraries used to support various repository providers. Known
         values are: "go-git" and "libgit2".
        :paramtype git_implementation: str or
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.GitImplementation
        :keyword ca_cert_resource_id: Resource Id of CA certificate for https URL of Git repository.
        :paramtype ca_cert_resource_id: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.patterns = patterns
        self.uri = uri
        self.label = label
        self.search_paths = search_paths
        self.username = username
        self.password = password
        self.host_key = host_key
        self.host_key_algorithm = host_key_algorithm
        self.private_key = private_key
        self.strict_host_key_checking = strict_host_key_checking
        self.git_implementation = git_implementation
        self.ca_cert_resource_id = ca_cert_resource_id


class ConfigurationServiceInstance(_serialization.Model):
    """Collection of instances belong to the Application Configuration Service.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the Application Configuration Service instance.
    :vartype name: str
    :ivar status: Status of the Application Configuration Service instance.
    :vartype status: str
    """

    _validation = {
        "name": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.status = None


class ConfigurationServiceProperties(_serialization.Model):
    """Application Configuration Service properties payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: State of the Application Configuration Service. Known values are:
     "Creating", "Updating", "Succeeded", "Failed", and "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.ConfigurationServiceProvisioningState
    :ivar generation: The generation of the Application Configuration Service. Known values are:
     "Gen1" and "Gen2".
    :vartype generation: str or
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.ConfigurationServiceGeneration
    :ivar resource_requests: The requested resource quantity for required CPU and Memory.
    :vartype resource_requests:
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.ConfigurationServiceResourceRequests
    :ivar instances: Collection of instances belong to Application Configuration Service.
    :vartype instances:
     list[~azure.mgmt.appplatform.v2023_07_01_preview.models.ConfigurationServiceInstance]
    :ivar settings: The settings of Application Configuration Service.
    :vartype settings:
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.ConfigurationServiceSettings
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "resource_requests": {"readonly": True},
        "instances": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "generation": {"key": "generation", "type": "str"},
        "resource_requests": {"key": "resourceRequests", "type": "ConfigurationServiceResourceRequests"},
        "instances": {"key": "instances", "type": "[ConfigurationServiceInstance]"},
        "settings": {"key": "settings", "type": "ConfigurationServiceSettings"},
    }

    def __init__(
        self,
        *,
        generation: Union[str, "_models.ConfigurationServiceGeneration"] = "Gen1",
        settings: Optional["_models.ConfigurationServiceSettings"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword generation: The generation of the Application Configuration Service. Known values are:
         "Gen1" and "Gen2".
        :paramtype generation: str or
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.ConfigurationServiceGeneration
        :keyword settings: The settings of Application Configuration Service.
        :paramtype settings:
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.ConfigurationServiceSettings
        """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.generation = generation
        self.resource_requests = None
        self.instances = None
        self.settings = settings


class ConfigurationServiceResource(ProxyResource):
    """Application Configuration Service resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.appplatform.v2023_07_01_preview.models.SystemData
    :ivar properties: Application Configuration Service properties payload.
    :vartype properties:
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.ConfigurationServiceProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "ConfigurationServiceProperties"},
    }

    def __init__(self, *, properties: Optional["_models.ConfigurationServiceProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: Application Configuration Service properties payload.
        :paramtype properties:
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.ConfigurationServiceProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class ConfigurationServiceResourceCollection(_serialization.Model):
    """Object that includes an array of configuration service resources and a possible link for next
    set.

    :ivar value: Collection of configuration service resources.
    :vartype value:
     list[~azure.mgmt.appplatform.v2023_07_01_preview.models.ConfigurationServiceResource]
    :ivar next_link: URL client should use to fetch the next page (per server side paging).
     It's null for now, added for future use.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ConfigurationServiceResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ConfigurationServiceResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Collection of configuration service resources.
        :paramtype value:
         list[~azure.mgmt.appplatform.v2023_07_01_preview.models.ConfigurationServiceResource]
        :keyword next_link: URL client should use to fetch the next page (per server side paging).
         It's null for now, added for future use.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ConfigurationServiceResourceRequests(_serialization.Model):
    """Resource request payload of Application Configuration Service.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar cpu: Cpu allocated to each Application Configuration Service instance.
    :vartype cpu: str
    :ivar memory: Memory allocated to each Application Configuration Service instance.
    :vartype memory: str
    :ivar instance_count: Instance count of the Application Configuration Service.
    :vartype instance_count: int
    """

    _validation = {
        "cpu": {"readonly": True},
        "memory": {"readonly": True},
        "instance_count": {"readonly": True},
    }

    _attribute_map = {
        "cpu": {"key": "cpu", "type": "str"},
        "memory": {"key": "memory", "type": "str"},
        "instance_count": {"key": "instanceCount", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.cpu = None
        self.memory = None
        self.instance_count = None


class ConfigurationServiceSettings(_serialization.Model):
    """The settings of Application Configuration Service.

    :ivar git_property: Property of git environment.
    :vartype git_property:
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.ConfigurationServiceGitProperty
    """

    _attribute_map = {
        "git_property": {"key": "gitProperty", "type": "ConfigurationServiceGitProperty"},
    }

    def __init__(
        self, *, git_property: Optional["_models.ConfigurationServiceGitProperty"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword git_property: Property of git environment.
        :paramtype git_property:
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.ConfigurationServiceGitProperty
        """
        super().__init__(**kwargs)
        self.git_property = git_property


class ConfigurationServiceSettingsValidateResult(_serialization.Model):
    """Validation result for configuration service settings.

    :ivar git_property_validation_result: Validation result for configuration service settings.
    :vartype git_property_validation_result:
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.ConfigurationServiceGitPropertyValidateResult
    """

    _attribute_map = {
        "git_property_validation_result": {
            "key": "gitPropertyValidationResult",
            "type": "ConfigurationServiceGitPropertyValidateResult",
        },
    }

    def __init__(
        self,
        *,
        git_property_validation_result: Optional["_models.ConfigurationServiceGitPropertyValidateResult"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword git_property_validation_result: Validation result for configuration service settings.
        :paramtype git_property_validation_result:
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.ConfigurationServiceGitPropertyValidateResult
        """
        super().__init__(**kwargs)
        self.git_property_validation_result = git_property_validation_result


class ContainerProbeSettings(_serialization.Model):
    """Container liveness and readiness probe settings.

    :ivar disable_probe: Indicates whether disable the liveness and readiness probe.
    :vartype disable_probe: bool
    """

    _attribute_map = {
        "disable_probe": {"key": "disableProbe", "type": "bool"},
    }

    def __init__(self, *, disable_probe: Optional[bool] = None, **kwargs: Any) -> None:
        """
        :keyword disable_probe: Indicates whether disable the liveness and readiness probe.
        :paramtype disable_probe: bool
        """
        super().__init__(**kwargs)
        self.disable_probe = disable_probe


class ContainerRegistryCredentials(_serialization.Model):
    """The credential for the container registry resource.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ContainerRegistryBasicCredentials

    All required parameters must be populated in order to send to Azure.

    :ivar type: The credential type of the container registry credentials. Required.
    :vartype type: str
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
    }

    _subtype_map = {"type": {"BasicAuth": "ContainerRegistryBasicCredentials"}}

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type: Optional[str] = None


class ContainerRegistryBasicCredentials(ContainerRegistryCredentials):
    """The basic authentication properties for the container registry resource.

    All required parameters must be populated in order to send to Azure.

    :ivar type: The credential type of the container registry credentials. Required.
    :vartype type: str
    :ivar server: The login server of the Container Registry. Required.
    :vartype server: str
    :ivar username: The username of the Container Registry. Required.
    :vartype username: str
    :ivar password: The password of the Container Registry. Required.
    :vartype password: str
    """

    _validation = {
        "type": {"required": True},
        "server": {"required": True},
        "username": {"required": True},
        "password": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "server": {"key": "server", "type": "str"},
        "username": {"key": "username", "type": "str"},
        "password": {"key": "password", "type": "str"},
    }

    def __init__(self, *, server: str, username: str, password: str, **kwargs: Any) -> None:
        """
        :keyword server: The login server of the Container Registry. Required.
        :paramtype server: str
        :keyword username: The username of the Container Registry. Required.
        :paramtype username: str
        :keyword password: The password of the Container Registry. Required.
        :paramtype password: str
        """
        super().__init__(**kwargs)
        self.type: str = "BasicAuth"
        self.server = server
        self.username = username
        self.password = password


class ContainerRegistryProperties(_serialization.Model):
    """Container registry resource payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar credentials: The credentials of the container registry resource. Required.
    :vartype credentials:
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.ContainerRegistryCredentials
    :ivar provisioning_state: State of the Container Registry. Known values are: "Creating",
     "Updating", "Succeeded", "Failed", "Deleting", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.ContainerRegistryProvisioningState
    """

    _validation = {
        "credentials": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "credentials": {"key": "credentials", "type": "ContainerRegistryCredentials"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(self, *, credentials: "_models.ContainerRegistryCredentials", **kwargs: Any) -> None:
        """
        :keyword credentials: The credentials of the container registry resource. Required.
        :paramtype credentials:
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.ContainerRegistryCredentials
        """
        super().__init__(**kwargs)
        self.credentials = credentials
        self.provisioning_state = None


class ContainerRegistryResource(ProxyResource):
    """Container registry resource payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.appplatform.v2023_07_01_preview.models.SystemData
    :ivar properties: Properties of the container registry resource payload.
    :vartype properties:
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.ContainerRegistryProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "ContainerRegistryProperties"},
    }

    def __init__(self, *, properties: Optional["_models.ContainerRegistryProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: Properties of the container registry resource payload.
        :paramtype properties:
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.ContainerRegistryProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class ContainerRegistryResourceCollection(_serialization.Model):
    """Collection compose of container registry resources list and a possible link for next page.

    :ivar value: The container registry resources list.
    :vartype value:
     list[~azure.mgmt.appplatform.v2023_07_01_preview.models.ContainerRegistryResource]
    :ivar next_link: The link to next page of storage list.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ContainerRegistryResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ContainerRegistryResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The container registry resources list.
        :paramtype value:
         list[~azure.mgmt.appplatform.v2023_07_01_preview.models.ContainerRegistryResource]
        :keyword next_link: The link to next page of storage list.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ContainerRegistryValidateResult(_serialization.Model):
    """Validation result for container registry properties.

    :ivar is_valid: Indicate if the container registry properties are valid.
    :vartype is_valid: bool
    :ivar message: Detailed validation messages.
    :vartype message: str
    """

    _attribute_map = {
        "is_valid": {"key": "isValid", "type": "bool"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, *, is_valid: Optional[bool] = None, message: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword is_valid: Indicate if the container registry properties are valid.
        :paramtype is_valid: bool
        :keyword message: Detailed validation messages.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.is_valid = is_valid
        self.message = message


class ContentCertificateProperties(CertificateProperties):
    """Properties of certificate imported from key vault.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: The type of the certificate source. Required.
    :vartype type: str
    :ivar thumbprint: The thumbprint of certificate.
    :vartype thumbprint: str
    :ivar issuer: The issuer of certificate.
    :vartype issuer: str
    :ivar issued_date: The issue date of certificate.
    :vartype issued_date: str
    :ivar expiration_date: The expiration date of certificate.
    :vartype expiration_date: str
    :ivar activate_date: The activate date of certificate.
    :vartype activate_date: str
    :ivar subject_name: The subject name of certificate.
    :vartype subject_name: str
    :ivar dns_names: The domain list of certificate.
    :vartype dns_names: list[str]
    :ivar provisioning_state: Provisioning state of the Certificate. Known values are: "Creating",
     "Updating", "Succeeded", "Failed", and "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.CertificateResourceProvisioningState
    :ivar content: The content of uploaded certificate.
    :vartype content: str
    """

    _validation = {
        "type": {"required": True},
        "thumbprint": {"readonly": True},
        "issuer": {"readonly": True},
        "issued_date": {"readonly": True},
        "expiration_date": {"readonly": True},
        "activate_date": {"readonly": True},
        "subject_name": {"readonly": True},
        "dns_names": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "thumbprint": {"key": "thumbprint", "type": "str"},
        "issuer": {"key": "issuer", "type": "str"},
        "issued_date": {"key": "issuedDate", "type": "str"},
        "expiration_date": {"key": "expirationDate", "type": "str"},
        "activate_date": {"key": "activateDate", "type": "str"},
        "subject_name": {"key": "subjectName", "type": "str"},
        "dns_names": {"key": "dnsNames", "type": "[str]"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "content": {"key": "content", "type": "str"},
    }

    def __init__(self, *, content: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword content: The content of uploaded certificate.
        :paramtype content: str
        """
        super().__init__(**kwargs)
        self.type: str = "ContentCertificate"
        self.content = content


class CustomContainer(_serialization.Model):
    """Custom container payload.

    :ivar server: The name of the registry that contains the container image.
    :vartype server: str
    :ivar container_image: Container image of the custom container. This should be in the form of
     :code:`<repository>`::code:`<tag>` without the server name of the registry.
    :vartype container_image: str
    :ivar command: Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is
     used if this is not provided.
    :vartype command: list[str]
    :ivar args: Arguments to the entrypoint. The docker image's CMD is used if this is not
     provided.
    :vartype args: list[str]
    :ivar image_registry_credential: Credential of the image registry.
    :vartype image_registry_credential:
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.ImageRegistryCredential
    :ivar language_framework: Language framework of the container image uploaded. Supported values:
     "springboot", "", null.
    :vartype language_framework: str
    """

    _attribute_map = {
        "server": {"key": "server", "type": "str"},
        "container_image": {"key": "containerImage", "type": "str"},
        "command": {"key": "command", "type": "[str]"},
        "args": {"key": "args", "type": "[str]"},
        "image_registry_credential": {"key": "imageRegistryCredential", "type": "ImageRegistryCredential"},
        "language_framework": {"key": "languageFramework", "type": "str"},
    }

    def __init__(
        self,
        *,
        server: Optional[str] = None,
        container_image: Optional[str] = None,
        command: Optional[List[str]] = None,
        args: Optional[List[str]] = None,
        image_registry_credential: Optional["_models.ImageRegistryCredential"] = None,
        language_framework: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword server: The name of the registry that contains the container image.
        :paramtype server: str
        :keyword container_image: Container image of the custom container. This should be in the form
         of :code:`<repository>`::code:`<tag>` without the server name of the registry.
        :paramtype container_image: str
        :keyword command: Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT
         is used if this is not provided.
        :paramtype command: list[str]
        :keyword args: Arguments to the entrypoint. The docker image's CMD is used if this is not
         provided.
        :paramtype args: list[str]
        :keyword image_registry_credential: Credential of the image registry.
        :paramtype image_registry_credential:
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.ImageRegistryCredential
        :keyword language_framework: Language framework of the container image uploaded. Supported
         values: "springboot", "", null.
        :paramtype language_framework: str
        """
        super().__init__(**kwargs)
        self.server = server
        self.container_image = container_image
        self.command = command
        self.args = args
        self.image_registry_credential = image_registry_credential
        self.language_framework = language_framework


class CustomContainerUserSourceInfo(UserSourceInfo):
    """Custom container user source info.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Type of the source uploaded. Required.
    :vartype type: str
    :ivar version: Version of the source.
    :vartype version: str
    :ivar custom_container: Custom container payload.
    :vartype custom_container: ~azure.mgmt.appplatform.v2023_07_01_preview.models.CustomContainer
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "version": {"key": "version", "type": "str"},
        "custom_container": {"key": "customContainer", "type": "CustomContainer"},
    }

    def __init__(
        self,
        *,
        version: Optional[str] = None,
        custom_container: Optional["_models.CustomContainer"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword version: Version of the source.
        :paramtype version: str
        :keyword custom_container: Custom container payload.
        :paramtype custom_container: ~azure.mgmt.appplatform.v2023_07_01_preview.models.CustomContainer
        """
        super().__init__(version=version, **kwargs)
        self.type: str = "Container"
        self.custom_container = custom_container


class CustomDomainProperties(_serialization.Model):
    """Custom domain of app resource payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar thumbprint: The thumbprint of bound certificate.
    :vartype thumbprint: str
    :ivar app_name: The app name of domain.
    :vartype app_name: str
    :ivar cert_name: The bound certificate name of domain.
    :vartype cert_name: str
    :ivar provisioning_state: Provisioning state of the Domain. Known values are: "Creating",
     "Updating", "Succeeded", "Failed", and "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.CustomDomainResourceProvisioningState
    """

    _validation = {
        "app_name": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "thumbprint": {"key": "thumbprint", "type": "str"},
        "app_name": {"key": "appName", "type": "str"},
        "cert_name": {"key": "certName", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(self, *, thumbprint: Optional[str] = None, cert_name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword thumbprint: The thumbprint of bound certificate.
        :paramtype thumbprint: str
        :keyword cert_name: The bound certificate name of domain.
        :paramtype cert_name: str
        """
        super().__init__(**kwargs)
        self.thumbprint = thumbprint
        self.app_name = None
        self.cert_name = cert_name
        self.provisioning_state = None


class CustomDomainResource(ProxyResource):
    """Custom domain resource payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.appplatform.v2023_07_01_preview.models.SystemData
    :ivar properties: Properties of the custom domain resource.
    :vartype properties: ~azure.mgmt.appplatform.v2023_07_01_preview.models.CustomDomainProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "CustomDomainProperties"},
    }

    def __init__(self, *, properties: Optional["_models.CustomDomainProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: Properties of the custom domain resource.
        :paramtype properties:
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.CustomDomainProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class CustomDomainResourceCollection(_serialization.Model):
    """Collection compose of a custom domain resources list and a possible link for next page.

    :ivar value: The custom domain resources list.
    :vartype value: list[~azure.mgmt.appplatform.v2023_07_01_preview.models.CustomDomainResource]
    :ivar next_link: The link to next page of custom domain list.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[CustomDomainResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.CustomDomainResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The custom domain resources list.
        :paramtype value: list[~azure.mgmt.appplatform.v2023_07_01_preview.models.CustomDomainResource]
        :keyword next_link: The link to next page of custom domain list.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class CustomDomainValidatePayload(_serialization.Model):
    """Custom domain validate payload.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Name to be validated. Required.
    :vartype name: str
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, name: str, **kwargs: Any) -> None:
        """
        :keyword name: Name to be validated. Required.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.name = name


class CustomDomainValidateResult(_serialization.Model):
    """Validation result for custom domain.

    :ivar is_valid: Indicates if domain name is valid.
    :vartype is_valid: bool
    :ivar message: Message of why domain name is invalid.
    :vartype message: str
    """

    _attribute_map = {
        "is_valid": {"key": "isValid", "type": "bool"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, *, is_valid: Optional[bool] = None, message: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword is_valid: Indicates if domain name is valid.
        :paramtype is_valid: bool
        :keyword message: Message of why domain name is invalid.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.is_valid = is_valid
        self.message = message


class CustomizedAcceleratorProperties(_serialization.Model):
    """Customized accelerator properties payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar provisioning_state: State of the customized accelerator. Known values are: "Creating",
     "Updating", "Succeeded", "Failed", and "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.CustomizedAcceleratorProvisioningState
    :ivar display_name:
    :vartype display_name: str
    :ivar description:
    :vartype description: str
    :ivar icon_url:
    :vartype icon_url: str
    :ivar accelerator_tags:
    :vartype accelerator_tags: list[str]
    :ivar git_repository: Required.
    :vartype git_repository:
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.AcceleratorGitRepository
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "git_repository": {"required": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "icon_url": {"key": "iconUrl", "type": "str"},
        "accelerator_tags": {"key": "acceleratorTags", "type": "[str]"},
        "git_repository": {"key": "gitRepository", "type": "AcceleratorGitRepository"},
    }

    def __init__(
        self,
        *,
        git_repository: "_models.AcceleratorGitRepository",
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        icon_url: Optional[str] = None,
        accelerator_tags: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword display_name:
        :paramtype display_name: str
        :keyword description:
        :paramtype description: str
        :keyword icon_url:
        :paramtype icon_url: str
        :keyword accelerator_tags:
        :paramtype accelerator_tags: list[str]
        :keyword git_repository: Required.
        :paramtype git_repository:
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.AcceleratorGitRepository
        """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.display_name = display_name
        self.description = description
        self.icon_url = icon_url
        self.accelerator_tags = accelerator_tags
        self.git_repository = git_repository


class CustomizedAcceleratorResource(ProxyResource):
    """Customized accelerator resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.appplatform.v2023_07_01_preview.models.SystemData
    :ivar properties: Customized accelerator properties payload.
    :vartype properties:
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.CustomizedAcceleratorProperties
    :ivar sku: Sku of the customized accelerator resource.
    :vartype sku: ~azure.mgmt.appplatform.v2023_07_01_preview.models.Sku
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "CustomizedAcceleratorProperties"},
        "sku": {"key": "sku", "type": "Sku"},
    }

    def __init__(
        self,
        *,
        properties: Optional["_models.CustomizedAcceleratorProperties"] = None,
        sku: Optional["_models.Sku"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword properties: Customized accelerator properties payload.
        :paramtype properties:
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.CustomizedAcceleratorProperties
        :keyword sku: Sku of the customized accelerator resource.
        :paramtype sku: ~azure.mgmt.appplatform.v2023_07_01_preview.models.Sku
        """
        super().__init__(**kwargs)
        self.properties = properties
        self.sku = sku


class CustomizedAcceleratorResourceCollection(_serialization.Model):
    """CustomizedAcceleratorResourceCollection.

    :ivar value:
    :vartype value:
     list[~azure.mgmt.appplatform.v2023_07_01_preview.models.CustomizedAcceleratorResource]
    :ivar next_link:
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[CustomizedAcceleratorResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.CustomizedAcceleratorResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value:
        :paramtype value:
         list[~azure.mgmt.appplatform.v2023_07_01_preview.models.CustomizedAcceleratorResource]
        :keyword next_link:
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class CustomizedAcceleratorValidateResult(_serialization.Model):
    """Validation result for customized accelerator properties.

    :ivar state: State of the customized accelerator validation result. Known values are: "Valid"
     and "Invalid".
    :vartype state: str or
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.CustomizedAcceleratorValidateResultState
    :ivar error_message: The detail validation results.
    :vartype error_message: str
    """

    _attribute_map = {
        "state": {"key": "state", "type": "str"},
        "error_message": {"key": "errorMessage", "type": "str"},
    }

    def __init__(
        self,
        *,
        state: Union[str, "_models.CustomizedAcceleratorValidateResultState"] = "Valid",
        error_message: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword state: State of the customized accelerator validation result. Known values are:
         "Valid" and "Invalid".
        :paramtype state: str or
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.CustomizedAcceleratorValidateResultState
        :keyword error_message: The detail validation results.
        :paramtype error_message: str
        """
        super().__init__(**kwargs)
        self.state = state
        self.error_message = error_message


class CustomPersistentDiskResource(_serialization.Model):
    """Custom persistent disk resource payload.

    All required parameters must be populated in order to send to Azure.

    :ivar custom_persistent_disk_properties: Properties of the custom persistent disk resource
     payload.
    :vartype custom_persistent_disk_properties:
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.CustomPersistentDiskProperties
    :ivar storage_id: The resource id of Azure Spring Apps Storage resource. Required.
    :vartype storage_id: str
    """

    _validation = {
        "storage_id": {"required": True},
    }

    _attribute_map = {
        "custom_persistent_disk_properties": {
            "key": "customPersistentDiskProperties",
            "type": "CustomPersistentDiskProperties",
        },
        "storage_id": {"key": "storageId", "type": "str"},
    }

    def __init__(
        self,
        *,
        storage_id: str,
        custom_persistent_disk_properties: Optional["_models.CustomPersistentDiskProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword custom_persistent_disk_properties: Properties of the custom persistent disk resource
         payload.
        :paramtype custom_persistent_disk_properties:
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.CustomPersistentDiskProperties
        :keyword storage_id: The resource id of Azure Spring Apps Storage resource. Required.
        :paramtype storage_id: str
        """
        super().__init__(**kwargs)
        self.custom_persistent_disk_properties = custom_persistent_disk_properties
        self.storage_id = storage_id


class CustomScaleRule(_serialization.Model):
    """Azure Spring Apps App Instance Custom scaling rule.

    :ivar type: Type of the custom scale rule
     eg: azure-servicebus, redis etc.
    :vartype type: str
    :ivar metadata: Metadata properties to describe custom scale rule.
    :vartype metadata: dict[str, str]
    :ivar auth: Authentication secrets for the custom scale rule.
    :vartype auth: list[~azure.mgmt.appplatform.v2023_07_01_preview.models.ScaleRuleAuth]
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "metadata": {"key": "metadata", "type": "{str}"},
        "auth": {"key": "auth", "type": "[ScaleRuleAuth]"},
    }

    def __init__(
        self,
        *,
        type: Optional[str] = None,
        metadata: Optional[Dict[str, str]] = None,
        auth: Optional[List["_models.ScaleRuleAuth"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Type of the custom scale rule
         eg: azure-servicebus, redis etc.
        :paramtype type: str
        :keyword metadata: Metadata properties to describe custom scale rule.
        :paramtype metadata: dict[str, str]
        :keyword auth: Authentication secrets for the custom scale rule.
        :paramtype auth: list[~azure.mgmt.appplatform.v2023_07_01_preview.models.ScaleRuleAuth]
        """
        super().__init__(**kwargs)
        self.type = type
        self.metadata = metadata
        self.auth = auth


class DeploymentInstance(_serialization.Model):
    """Deployment instance payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the deployment instance.
    :vartype name: str
    :ivar status: Status of the deployment instance.
    :vartype status: str
    :ivar reason: Failed reason of the deployment instance.
    :vartype reason: str
    :ivar discovery_status: Discovery status of the deployment instance.
    :vartype discovery_status: str
    :ivar start_time: Start time of the deployment instance.
    :vartype start_time: str
    :ivar zone: Availability zone information of the deployment instance.
    :vartype zone: str
    """

    _validation = {
        "name": {"readonly": True},
        "status": {"readonly": True},
        "reason": {"readonly": True},
        "discovery_status": {"readonly": True},
        "start_time": {"readonly": True},
        "zone": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "reason": {"key": "reason", "type": "str"},
        "discovery_status": {"key": "discoveryStatus", "type": "str"},
        "start_time": {"key": "startTime", "type": "str"},
        "zone": {"key": "zone", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.status = None
        self.reason = None
        self.discovery_status = None
        self.start_time = None
        self.zone = None


class DeploymentList(_serialization.Model):
    """A list of deployments resource ids.

    :ivar deployments: A list of deployment resource ids.
    :vartype deployments: list[str]
    """

    _attribute_map = {
        "deployments": {"key": "deployments", "type": "[str]"},
    }

    def __init__(self, *, deployments: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword deployments: A list of deployment resource ids.
        :paramtype deployments: list[str]
        """
        super().__init__(**kwargs)
        self.deployments = deployments


class DeploymentResource(ProxyResource):
    """Deployment resource payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.appplatform.v2023_07_01_preview.models.SystemData
    :ivar properties: Properties of the Deployment resource.
    :vartype properties:
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.DeploymentResourceProperties
    :ivar sku: Sku of the Deployment resource.
    :vartype sku: ~azure.mgmt.appplatform.v2023_07_01_preview.models.Sku
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "DeploymentResourceProperties"},
        "sku": {"key": "sku", "type": "Sku"},
    }

    def __init__(
        self,
        *,
        properties: Optional["_models.DeploymentResourceProperties"] = None,
        sku: Optional["_models.Sku"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword properties: Properties of the Deployment resource.
        :paramtype properties:
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.DeploymentResourceProperties
        :keyword sku: Sku of the Deployment resource.
        :paramtype sku: ~azure.mgmt.appplatform.v2023_07_01_preview.models.Sku
        """
        super().__init__(**kwargs)
        self.properties = properties
        self.sku = sku


class DeploymentResourceCollection(_serialization.Model):
    """Object that includes an array of App resources and a possible link for next set.

    :ivar value: Collection of Deployment resources.
    :vartype value: list[~azure.mgmt.appplatform.v2023_07_01_preview.models.DeploymentResource]
    :ivar next_link: URL client should use to fetch the next page (per server side paging).
     It's null for now, added for future use.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[DeploymentResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.DeploymentResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Collection of Deployment resources.
        :paramtype value: list[~azure.mgmt.appplatform.v2023_07_01_preview.models.DeploymentResource]
        :keyword next_link: URL client should use to fetch the next page (per server side paging).
         It's null for now, added for future use.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DeploymentResourceProperties(_serialization.Model):
    """Deployment resource properties payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar source: Uploaded source information of the deployment.
    :vartype source: ~azure.mgmt.appplatform.v2023_07_01_preview.models.UserSourceInfo
    :ivar deployment_settings: Deployment settings of the Deployment.
    :vartype deployment_settings:
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.DeploymentSettings
    :ivar provisioning_state: Provisioning state of the Deployment. Known values are: "Creating",
     "Updating", "Succeeded", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.DeploymentResourceProvisioningState
    :ivar status: Status of the Deployment. Known values are: "Stopped" and "Running".
    :vartype status: str or
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.DeploymentResourceStatus
    :ivar active: Indicates whether the Deployment is active.
    :vartype active: bool
    :ivar instances: Collection of instances belong to the Deployment.
    :vartype instances: list[~azure.mgmt.appplatform.v2023_07_01_preview.models.DeploymentInstance]
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "status": {"readonly": True},
        "instances": {"readonly": True},
    }

    _attribute_map = {
        "source": {"key": "source", "type": "UserSourceInfo"},
        "deployment_settings": {"key": "deploymentSettings", "type": "DeploymentSettings"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "active": {"key": "active", "type": "bool"},
        "instances": {"key": "instances", "type": "[DeploymentInstance]"},
    }

    def __init__(
        self,
        *,
        source: Optional["_models.UserSourceInfo"] = None,
        deployment_settings: Optional["_models.DeploymentSettings"] = None,
        active: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword source: Uploaded source information of the deployment.
        :paramtype source: ~azure.mgmt.appplatform.v2023_07_01_preview.models.UserSourceInfo
        :keyword deployment_settings: Deployment settings of the Deployment.
        :paramtype deployment_settings:
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.DeploymentSettings
        :keyword active: Indicates whether the Deployment is active.
        :paramtype active: bool
        """
        super().__init__(**kwargs)
        self.source = source
        self.deployment_settings = deployment_settings
        self.provisioning_state = None
        self.status = None
        self.active = active
        self.instances = None


class DeploymentSettings(_serialization.Model):
    """Deployment settings payload.

    :ivar resource_requests: The requested resource quantity for required CPU and Memory. It is
     recommended that using this field to represent the required CPU and Memory, the old field cpu
     and memoryInGB will be deprecated later.
    :vartype resource_requests: ~azure.mgmt.appplatform.v2023_07_01_preview.models.ResourceRequests
    :ivar environment_variables: Collection of environment variables.
    :vartype environment_variables: dict[str, str]
    :ivar apms: Collection of ApmReferences.
    :vartype apms: list[~azure.mgmt.appplatform.v2023_07_01_preview.models.ApmReference]
    :ivar addon_configs: Collection of addons.
    :vartype addon_configs: dict[str, JSON]
    :ivar liveness_probe: Periodic probe of App Instance liveness. App Instance will be restarted
     if the probe fails. More info:
     https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes.
    :vartype liveness_probe: ~azure.mgmt.appplatform.v2023_07_01_preview.models.Probe
    :ivar readiness_probe: Periodic probe of App Instance service readiness. App Instance will be
     removed from service endpoints if the probe fails. More info:
     https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes.
    :vartype readiness_probe: ~azure.mgmt.appplatform.v2023_07_01_preview.models.Probe
    :ivar startup_probe: StartupProbe indicates that the App Instance has successfully initialized.
     If specified, no other probes are executed until this completes successfully. If this probe
     fails, the Pod will be restarted, just as if the livenessProbe failed. This can be used to
     provide different probe parameters at the beginning of a App Instance's lifecycle, when it
     might take a long time to load data or warm a cache, than during steady-state operation. This
     cannot be updated. More info:
     https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes.
    :vartype startup_probe: ~azure.mgmt.appplatform.v2023_07_01_preview.models.Probe
    :ivar termination_grace_period_seconds: Optional duration in seconds the App Instance needs to
     terminate gracefully. May be decreased in delete request. Value must be non-negative integer.
     The value zero indicates stop immediately via the kill signal (no opportunity to shut down). If
     this value is nil, the default grace period will be used instead. The grace period is the
     duration in seconds after the processes running in the App Instance are sent a termination
     signal and the time when the processes are forcibly halted with a kill signal. Set this value
     longer than the expected cleanup time for your process. Defaults to 90 seconds.
    :vartype termination_grace_period_seconds: int
    :ivar scale: Scaling properties for the Azure Spring Apps App Instance.
    :vartype scale: ~azure.mgmt.appplatform.v2023_07_01_preview.models.Scale
    :ivar container_probe_settings: Container liveness and readiness probe settings.
    :vartype container_probe_settings:
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.ContainerProbeSettings
    """

    _attribute_map = {
        "resource_requests": {"key": "resourceRequests", "type": "ResourceRequests"},
        "environment_variables": {"key": "environmentVariables", "type": "{str}"},
        "apms": {"key": "apms", "type": "[ApmReference]"},
        "addon_configs": {"key": "addonConfigs", "type": "{object}"},
        "liveness_probe": {"key": "livenessProbe", "type": "Probe"},
        "readiness_probe": {"key": "readinessProbe", "type": "Probe"},
        "startup_probe": {"key": "startupProbe", "type": "Probe"},
        "termination_grace_period_seconds": {"key": "terminationGracePeriodSeconds", "type": "int"},
        "scale": {"key": "scale", "type": "Scale"},
        "container_probe_settings": {"key": "containerProbeSettings", "type": "ContainerProbeSettings"},
    }

    def __init__(
        self,
        *,
        resource_requests: Optional["_models.ResourceRequests"] = None,
        environment_variables: Optional[Dict[str, str]] = None,
        apms: Optional[List["_models.ApmReference"]] = None,
        addon_configs: Optional[Dict[str, JSON]] = None,
        liveness_probe: Optional["_models.Probe"] = None,
        readiness_probe: Optional["_models.Probe"] = None,
        startup_probe: Optional["_models.Probe"] = None,
        termination_grace_period_seconds: int = 90,
        scale: Optional["_models.Scale"] = None,
        container_probe_settings: Optional["_models.ContainerProbeSettings"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword resource_requests: The requested resource quantity for required CPU and Memory. It is
         recommended that using this field to represent the required CPU and Memory, the old field cpu
         and memoryInGB will be deprecated later.
        :paramtype resource_requests:
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.ResourceRequests
        :keyword environment_variables: Collection of environment variables.
        :paramtype environment_variables: dict[str, str]
        :keyword apms: Collection of ApmReferences.
        :paramtype apms: list[~azure.mgmt.appplatform.v2023_07_01_preview.models.ApmReference]
        :keyword addon_configs: Collection of addons.
        :paramtype addon_configs: dict[str, JSON]
        :keyword liveness_probe: Periodic probe of App Instance liveness. App Instance will be
         restarted if the probe fails. More info:
         https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes.
        :paramtype liveness_probe: ~azure.mgmt.appplatform.v2023_07_01_preview.models.Probe
        :keyword readiness_probe: Periodic probe of App Instance service readiness. App Instance will
         be removed from service endpoints if the probe fails. More info:
         https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes.
        :paramtype readiness_probe: ~azure.mgmt.appplatform.v2023_07_01_preview.models.Probe
        :keyword startup_probe: StartupProbe indicates that the App Instance has successfully
         initialized. If specified, no other probes are executed until this completes successfully. If
         this probe fails, the Pod will be restarted, just as if the livenessProbe failed. This can be
         used to provide different probe parameters at the beginning of a App Instance's lifecycle, when
         it might take a long time to load data or warm a cache, than during steady-state operation.
         This cannot be updated. More info:
         https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes.
        :paramtype startup_probe: ~azure.mgmt.appplatform.v2023_07_01_preview.models.Probe
        :keyword termination_grace_period_seconds: Optional duration in seconds the App Instance needs
         to terminate gracefully. May be decreased in delete request. Value must be non-negative
         integer. The value zero indicates stop immediately via the kill signal (no opportunity to shut
         down). If this value is nil, the default grace period will be used instead. The grace period is
         the duration in seconds after the processes running in the App Instance are sent a termination
         signal and the time when the processes are forcibly halted with a kill signal. Set this value
         longer than the expected cleanup time for your process. Defaults to 90 seconds.
        :paramtype termination_grace_period_seconds: int
        :keyword scale: Scaling properties for the Azure Spring Apps App Instance.
        :paramtype scale: ~azure.mgmt.appplatform.v2023_07_01_preview.models.Scale
        :keyword container_probe_settings: Container liveness and readiness probe settings.
        :paramtype container_probe_settings:
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.ContainerProbeSettings
        """
        super().__init__(**kwargs)
        self.resource_requests = resource_requests
        self.environment_variables = environment_variables
        self.apms = apms
        self.addon_configs = addon_configs
        self.liveness_probe = liveness_probe
        self.readiness_probe = readiness_probe
        self.startup_probe = startup_probe
        self.termination_grace_period_seconds = termination_grace_period_seconds
        self.scale = scale
        self.container_probe_settings = container_probe_settings


class DevToolPortalComponent(_serialization.Model):
    """DevToolPortalComponent.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name:
    :vartype name: str
    :ivar resource_requests: The requested resource quantity for required CPU and Memory.
    :vartype resource_requests:
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.DevToolPortalResourceRequests
    :ivar instances: Collection of instances belong to Dev Tool Portal.
    :vartype instances:
     list[~azure.mgmt.appplatform.v2023_07_01_preview.models.DevToolPortalInstance]
    """

    _validation = {
        "name": {"readonly": True},
        "resource_requests": {"readonly": True},
        "instances": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "resource_requests": {"key": "resourceRequests", "type": "DevToolPortalResourceRequests"},
        "instances": {"key": "instances", "type": "[DevToolPortalInstance]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.resource_requests = None
        self.instances = None


class DevToolPortalFeatureDetail(_serialization.Model):
    """Detail settings for Dev Tool Portal feature.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar state: State of the plugin. Known values are: "Enabled" and "Disabled".
    :vartype state: str or
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.DevToolPortalFeatureState
    :ivar route: Route path to visit the plugin.
    :vartype route: str
    """

    _validation = {
        "route": {"readonly": True},
    }

    _attribute_map = {
        "state": {"key": "state", "type": "str"},
        "route": {"key": "route", "type": "str"},
    }

    def __init__(self, *, state: Union[str, "_models.DevToolPortalFeatureState"] = "Enabled", **kwargs: Any) -> None:
        """
        :keyword state: State of the plugin. Known values are: "Enabled" and "Disabled".
        :paramtype state: str or
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.DevToolPortalFeatureState
        """
        super().__init__(**kwargs)
        self.state = state
        self.route = None


class DevToolPortalFeatureSettings(_serialization.Model):
    """Settings for Dev Tool Portal.

    :ivar application_accelerator: Detail of Accelerator plugin.
    :vartype application_accelerator:
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.DevToolPortalFeatureDetail
    :ivar application_live_view: Detail of App Live View plugin.
    :vartype application_live_view:
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.DevToolPortalFeatureDetail
    """

    _attribute_map = {
        "application_accelerator": {"key": "applicationAccelerator", "type": "DevToolPortalFeatureDetail"},
        "application_live_view": {"key": "applicationLiveView", "type": "DevToolPortalFeatureDetail"},
    }

    def __init__(
        self,
        *,
        application_accelerator: Optional["_models.DevToolPortalFeatureDetail"] = None,
        application_live_view: Optional["_models.DevToolPortalFeatureDetail"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword application_accelerator: Detail of Accelerator plugin.
        :paramtype application_accelerator:
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.DevToolPortalFeatureDetail
        :keyword application_live_view: Detail of App Live View plugin.
        :paramtype application_live_view:
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.DevToolPortalFeatureDetail
        """
        super().__init__(**kwargs)
        self.application_accelerator = application_accelerator
        self.application_live_view = application_live_view


class DevToolPortalInstance(_serialization.Model):
    """Collection of instances belong to the Dev Tool Portal.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the Dev Tool Portal instance.
    :vartype name: str
    :ivar status: Status of the Dev Tool Portal instance. It can be Pending, Running, Succeeded,
     Failed, Unknown.
    :vartype status: str
    """

    _validation = {
        "name": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.status = None


class DevToolPortalProperties(_serialization.Model):
    """Dev Tool Portal properties payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: State of the Dev Tool Portal. Known values are: "Creating",
     "Updating", "Succeeded", "Failed", "Deleting", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.DevToolPortalProvisioningState
    :ivar components: Collection of components belong to Dev Tool Portal.
    :vartype components:
     list[~azure.mgmt.appplatform.v2023_07_01_preview.models.DevToolPortalComponent]
    :ivar public: Indicates whether the resource exposes public endpoint.
    :vartype public: bool
    :ivar url: URL of the resource, exposed when 'public' is true.
    :vartype url: str
    :ivar sso_properties: Single sign-on related configuration.
    :vartype sso_properties:
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.DevToolPortalSsoProperties
    :ivar features: Settings for Dev Tool Portal.
    :vartype features:
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.DevToolPortalFeatureSettings
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "components": {"readonly": True},
        "url": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "components": {"key": "components", "type": "[DevToolPortalComponent]"},
        "public": {"key": "public", "type": "bool"},
        "url": {"key": "url", "type": "str"},
        "sso_properties": {"key": "ssoProperties", "type": "DevToolPortalSsoProperties"},
        "features": {"key": "features", "type": "DevToolPortalFeatureSettings"},
    }

    def __init__(
        self,
        *,
        public: bool = False,
        sso_properties: Optional["_models.DevToolPortalSsoProperties"] = None,
        features: Optional["_models.DevToolPortalFeatureSettings"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword public: Indicates whether the resource exposes public endpoint.
        :paramtype public: bool
        :keyword sso_properties: Single sign-on related configuration.
        :paramtype sso_properties:
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.DevToolPortalSsoProperties
        :keyword features: Settings for Dev Tool Portal.
        :paramtype features:
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.DevToolPortalFeatureSettings
        """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.components = None
        self.public = public
        self.url = None
        self.sso_properties = sso_properties
        self.features = features


class DevToolPortalResource(ProxyResource):
    """Dev Tool Portal resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.appplatform.v2023_07_01_preview.models.SystemData
    :ivar properties: Dev Tool Portal properties payload.
    :vartype properties: ~azure.mgmt.appplatform.v2023_07_01_preview.models.DevToolPortalProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "DevToolPortalProperties"},
    }

    def __init__(self, *, properties: Optional["_models.DevToolPortalProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: Dev Tool Portal properties payload.
        :paramtype properties:
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.DevToolPortalProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class DevToolPortalResourceCollection(_serialization.Model):
    """Object that includes an array of Dev Tool Portal resources and a possible link for next set.

    :ivar value: Collection of Dev Tool Portal resources.
    :vartype value: list[~azure.mgmt.appplatform.v2023_07_01_preview.models.DevToolPortalResource]
    :ivar next_link: URL client should use to fetch the next page (per server side paging).
     It's null for now, added for future use.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[DevToolPortalResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.DevToolPortalResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Collection of Dev Tool Portal resources.
        :paramtype value:
         list[~azure.mgmt.appplatform.v2023_07_01_preview.models.DevToolPortalResource]
        :keyword next_link: URL client should use to fetch the next page (per server side paging).
         It's null for now, added for future use.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DevToolPortalResourceRequests(_serialization.Model):
    """The resource quantity for required CPU and Memory of Dev Tool Portal.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar cpu: Cpu quantity allocated to each Dev Tool Portal instance. 1 core can be represented
     by 1 or 1000m.
    :vartype cpu: str
    :ivar memory: Memory quantity allocated to each Dev Tool Portal instance. 1 GB can be
     represented by 1Gi or 1024Mi.
    :vartype memory: str
    :ivar instance_count: Desired instance count of Dev Tool Portal.
    :vartype instance_count: int
    """

    _validation = {
        "cpu": {"readonly": True},
        "memory": {"readonly": True},
        "instance_count": {"readonly": True},
    }

    _attribute_map = {
        "cpu": {"key": "cpu", "type": "str"},
        "memory": {"key": "memory", "type": "str"},
        "instance_count": {"key": "instanceCount", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.cpu = None
        self.memory = None
        self.instance_count = None


class DevToolPortalSsoProperties(_serialization.Model):
    """Single sign-on related configuration.

    :ivar scopes: It defines the specific actions applications can be allowed to do on a user's
     behalf.
    :vartype scopes: list[str]
    :ivar client_id: The public identifier for the application.
    :vartype client_id: str
    :ivar client_secret: The secret known only to the application and the authorization server.
    :vartype client_secret: str
    :ivar metadata_url: The URI of a JSON file with generic OIDC provider configuration.
    :vartype metadata_url: str
    """

    _attribute_map = {
        "scopes": {"key": "scopes", "type": "[str]"},
        "client_id": {"key": "clientId", "type": "str"},
        "client_secret": {"key": "clientSecret", "type": "str"},
        "metadata_url": {"key": "metadataUrl", "type": "str"},
    }

    def __init__(
        self,
        *,
        scopes: Optional[List[str]] = None,
        client_id: Optional[str] = None,
        client_secret: Optional[str] = None,
        metadata_url: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword scopes: It defines the specific actions applications can be allowed to do on a user's
         behalf.
        :paramtype scopes: list[str]
        :keyword client_id: The public identifier for the application.
        :paramtype client_id: str
        :keyword client_secret: The secret known only to the application and the authorization server.
        :paramtype client_secret: str
        :keyword metadata_url: The URI of a JSON file with generic OIDC provider configuration.
        :paramtype metadata_url: str
        """
        super().__init__(**kwargs)
        self.scopes = scopes
        self.client_id = client_id
        self.client_secret = client_secret
        self.metadata_url = metadata_url


class DiagnosticParameters(_serialization.Model):
    """Diagnostic parameters of diagnostic operations.

    :ivar app_instance: App instance name.
    :vartype app_instance: str
    :ivar file_path: Your target file path in your own BYOS.
    :vartype file_path: str
    :ivar duration: Duration of your JFR. 1 min can be represented by 1m or 60s.
    :vartype duration: str
    """

    _attribute_map = {
        "app_instance": {"key": "appInstance", "type": "str"},
        "file_path": {"key": "filePath", "type": "str"},
        "duration": {"key": "duration", "type": "str"},
    }

    def __init__(
        self,
        *,
        app_instance: Optional[str] = None,
        file_path: Optional[str] = None,
        duration: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword app_instance: App instance name.
        :paramtype app_instance: str
        :keyword file_path: Your target file path in your own BYOS.
        :paramtype file_path: str
        :keyword duration: Duration of your JFR. 1 min can be represented by 1m or 60s.
        :paramtype duration: str
        """
        super().__init__(**kwargs)
        self.app_instance = app_instance
        self.file_path = file_path
        self.duration = duration


class Error(_serialization.Model):
    """The error code compose of code and message.

    :ivar code: The code of error.
    :vartype code: str
    :ivar message: The message of error.
    :vartype message: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, *, code: Optional[str] = None, message: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword code: The code of error.
        :paramtype code: str
        :keyword message: The message of error.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message


class EurekaServerProperties(_serialization.Model):
    """Eureka server properties payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: State of the eureka server. Known values are: "Failed", "Succeeded",
     "Updating", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.EurekaServerState
    :ivar enabled_state: Enabled state of the eureka server. This is only used in Consumption tier.
     Known values are: "Enabled" and "Disabled".
    :vartype enabled_state: str or
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.EurekaServerEnabledState
    :ivar error: Error when applying eureka server settings.
    :vartype error: ~azure.mgmt.appplatform.v2023_07_01_preview.models.Error
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "enabled_state": {"key": "enabledState", "type": "str"},
        "error": {"key": "error", "type": "Error"},
    }

    def __init__(
        self,
        *,
        enabled_state: Optional[Union[str, "_models.EurekaServerEnabledState"]] = None,
        error: Optional["_models.Error"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled_state: Enabled state of the eureka server. This is only used in Consumption
         tier. Known values are: "Enabled" and "Disabled".
        :paramtype enabled_state: str or
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.EurekaServerEnabledState
        :keyword error: Error when applying eureka server settings.
        :paramtype error: ~azure.mgmt.appplatform.v2023_07_01_preview.models.Error
        """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.enabled_state = enabled_state
        self.error = error


class EurekaServerResource(ProxyResource):
    """Eureka server resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.appplatform.v2023_07_01_preview.models.SystemData
    :ivar properties: Properties of the eureka server resource.
    :vartype properties: ~azure.mgmt.appplatform.v2023_07_01_preview.models.EurekaServerProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "EurekaServerProperties"},
    }

    def __init__(self, *, properties: Optional["_models.EurekaServerProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: Properties of the eureka server resource.
        :paramtype properties:
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.EurekaServerProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class EurekaServerResourceCollection(_serialization.Model):
    """Object that includes an array of Eureka server resources and a possible link for next set.

    :ivar value: Collection of Eureka server resources.
    :vartype value: list[~azure.mgmt.appplatform.v2023_07_01_preview.models.EurekaServerResource]
    :ivar next_link: URL client should use to fetch the next page (per server side paging).
     It's null for now, added for future use.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[EurekaServerResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.EurekaServerResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Collection of Eureka server resources.
        :paramtype value: list[~azure.mgmt.appplatform.v2023_07_01_preview.models.EurekaServerResource]
        :keyword next_link: URL client should use to fetch the next page (per server side paging).
         It's null for now, added for future use.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ProbeAction(_serialization.Model):
    """The action of the probe.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ExecAction, HTTPGetAction, TCPSocketAction

    All required parameters must be populated in order to send to Azure.

    :ivar type: The type of the action to take to perform the health check. Required. Known values
     are: "HTTPGetAction", "TCPSocketAction", and "ExecAction".
    :vartype type: str or ~azure.mgmt.appplatform.v2023_07_01_preview.models.ProbeActionType
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
    }

    _subtype_map = {
        "type": {"ExecAction": "ExecAction", "HTTPGetAction": "HTTPGetAction", "TCPSocketAction": "TCPSocketAction"}
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type: Optional[str] = None


class ExecAction(ProbeAction):
    """ExecAction describes a "run in container" action.

    All required parameters must be populated in order to send to Azure.

    :ivar type: The type of the action to take to perform the health check. Required. Known values
     are: "HTTPGetAction", "TCPSocketAction", and "ExecAction".
    :vartype type: str or ~azure.mgmt.appplatform.v2023_07_01_preview.models.ProbeActionType
    :ivar command: Command is the command line to execute inside the container, the working
     directory for the command is root ('/') in the container's filesystem. The command is not run
     inside a shell, so traditional shell instructions ('|', etc) won't work. To use a shell, you
     need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and
     non-zero is unhealthy.
    :vartype command: list[str]
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "command": {"key": "command", "type": "[str]"},
    }

    def __init__(self, *, command: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword command: Command is the command line to execute inside the container, the working
         directory for the command is root ('/') in the container's filesystem. The command is not run
         inside a shell, so traditional shell instructions ('|', etc) won't work. To use a shell, you
         need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and
         non-zero is unhealthy.
        :paramtype command: list[str]
        """
        super().__init__(**kwargs)
        self.type: str = "ExecAction"
        self.command = command


class GatewayApiMetadataProperties(_serialization.Model):
    """API metadata property for Spring Cloud Gateway.

    :ivar title: Title describing the context of the APIs available on the Gateway instance
     (default: ``Spring Cloud Gateway for K8S``\ ).
    :vartype title: str
    :ivar description: Detailed description of the APIs available on the Gateway instance (default:
     ``Generated OpenAPI 3 document that describes the API routes configured.``\ ).
    :vartype description: str
    :ivar documentation: Location of additional documentation for the APIs available on the Gateway
     instance.
    :vartype documentation: str
    :ivar version: Version of APIs available on this Gateway instance (default: ``unspecified``\ ).
    :vartype version: str
    :ivar server_url: Base URL that API consumers will use to access APIs on the Gateway instance.
    :vartype server_url: str
    """

    _attribute_map = {
        "title": {"key": "title", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "documentation": {"key": "documentation", "type": "str"},
        "version": {"key": "version", "type": "str"},
        "server_url": {"key": "serverUrl", "type": "str"},
    }

    def __init__(
        self,
        *,
        title: Optional[str] = None,
        description: Optional[str] = None,
        documentation: Optional[str] = None,
        version: Optional[str] = None,
        server_url: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword title: Title describing the context of the APIs available on the Gateway instance
         (default: ``Spring Cloud Gateway for K8S``\ ).
        :paramtype title: str
        :keyword description: Detailed description of the APIs available on the Gateway instance
         (default: ``Generated OpenAPI 3 document that describes the API routes configured.``\ ).
        :paramtype description: str
        :keyword documentation: Location of additional documentation for the APIs available on the
         Gateway instance.
        :paramtype documentation: str
        :keyword version: Version of APIs available on this Gateway instance (default: ``unspecified``\
         ).
        :paramtype version: str
        :keyword server_url: Base URL that API consumers will use to access APIs on the Gateway
         instance.
        :paramtype server_url: str
        """
        super().__init__(**kwargs)
        self.title = title
        self.description = description
        self.documentation = documentation
        self.version = version
        self.server_url = server_url


class GatewayApiRoute(_serialization.Model):
    """API route config of the Spring Cloud Gateway.

    :ivar title: A title, will be applied to methods in the generated OpenAPI documentation.
    :vartype title: str
    :ivar description: A description, will be applied to methods in the generated OpenAPI
     documentation.
    :vartype description: str
    :ivar uri: Full uri, will override ``appName``.
    :vartype uri: str
    :ivar sso_enabled: Enable sso validation.
    :vartype sso_enabled: bool
    :ivar token_relay: Pass currently-authenticated user's identity token to application service,
     default is 'false'.
    :vartype token_relay: bool
    :ivar predicates: A number of conditions to evaluate a route for each request. Each predicate
     may be evaluated against request headers and parameter values. All of the predicates associated
     with a route must evaluate to true for the route to be matched to the request.
    :vartype predicates: list[str]
    :ivar filters: To modify the request before sending it to the target endpoint, or the received
     response.
    :vartype filters: list[str]
    :ivar order: Route processing order.
    :vartype order: int
    :ivar tags: Classification tags, will be applied to methods in the generated OpenAPI
     documentation.
    :vartype tags: list[str]
    """

    _attribute_map = {
        "title": {"key": "title", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "uri": {"key": "uri", "type": "str"},
        "sso_enabled": {"key": "ssoEnabled", "type": "bool"},
        "token_relay": {"key": "tokenRelay", "type": "bool"},
        "predicates": {"key": "predicates", "type": "[str]"},
        "filters": {"key": "filters", "type": "[str]"},
        "order": {"key": "order", "type": "int"},
        "tags": {"key": "tags", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        title: Optional[str] = None,
        description: Optional[str] = None,
        uri: Optional[str] = None,
        sso_enabled: Optional[bool] = None,
        token_relay: Optional[bool] = None,
        predicates: Optional[List[str]] = None,
        filters: Optional[List[str]] = None,
        order: Optional[int] = None,
        tags: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword title: A title, will be applied to methods in the generated OpenAPI documentation.
        :paramtype title: str
        :keyword description: A description, will be applied to methods in the generated OpenAPI
         documentation.
        :paramtype description: str
        :keyword uri: Full uri, will override ``appName``.
        :paramtype uri: str
        :keyword sso_enabled: Enable sso validation.
        :paramtype sso_enabled: bool
        :keyword token_relay: Pass currently-authenticated user's identity token to application
         service, default is 'false'.
        :paramtype token_relay: bool
        :keyword predicates: A number of conditions to evaluate a route for each request. Each
         predicate may be evaluated against request headers and parameter values. All of the predicates
         associated with a route must evaluate to true for the route to be matched to the request.
        :paramtype predicates: list[str]
        :keyword filters: To modify the request before sending it to the target endpoint, or the
         received response.
        :paramtype filters: list[str]
        :keyword order: Route processing order.
        :paramtype order: int
        :keyword tags: Classification tags, will be applied to methods in the generated OpenAPI
         documentation.
        :paramtype tags: list[str]
        """
        super().__init__(**kwargs)
        self.title = title
        self.description = description
        self.uri = uri
        self.sso_enabled = sso_enabled
        self.token_relay = token_relay
        self.predicates = predicates
        self.filters = filters
        self.order = order
        self.tags = tags


class GatewayCorsProperties(_serialization.Model):
    """Cross-Origin Resource Sharing property.

    :ivar allowed_origins: Allowed origins to make cross-site requests. The special value ``*``
     allows all domains.
    :vartype allowed_origins: list[str]
    :ivar allowed_origin_patterns: Allowed origin patterns to make cross-site requests.
    :vartype allowed_origin_patterns: list[str]
    :ivar allowed_methods: Allowed HTTP methods on cross-site requests. The special value ``*``
     allows all methods. If not set, ``GET`` and ``HEAD`` are allowed by default.
    :vartype allowed_methods: list[str]
    :ivar allowed_headers: Allowed headers in cross-site requests. The special value ``*`` allows
     actual requests to send any header.
    :vartype allowed_headers: list[str]
    :ivar max_age: How long, in seconds, the response from a pre-flight request can be cached by
     clients.
    :vartype max_age: int
    :ivar allow_credentials: Whether user credentials are supported on cross-site requests. Valid
     values: ``true``\ , ``false``.
    :vartype allow_credentials: bool
    :ivar exposed_headers: HTTP response headers to expose for cross-site requests.
    :vartype exposed_headers: list[str]
    """

    _attribute_map = {
        "allowed_origins": {"key": "allowedOrigins", "type": "[str]"},
        "allowed_origin_patterns": {"key": "allowedOriginPatterns", "type": "[str]"},
        "allowed_methods": {"key": "allowedMethods", "type": "[str]"},
        "allowed_headers": {"key": "allowedHeaders", "type": "[str]"},
        "max_age": {"key": "maxAge", "type": "int"},
        "allow_credentials": {"key": "allowCredentials", "type": "bool"},
        "exposed_headers": {"key": "exposedHeaders", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        allowed_origins: Optional[List[str]] = None,
        allowed_origin_patterns: Optional[List[str]] = None,
        allowed_methods: Optional[List[str]] = None,
        allowed_headers: Optional[List[str]] = None,
        max_age: Optional[int] = None,
        allow_credentials: Optional[bool] = None,
        exposed_headers: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword allowed_origins: Allowed origins to make cross-site requests. The special value ``*``
         allows all domains.
        :paramtype allowed_origins: list[str]
        :keyword allowed_origin_patterns: Allowed origin patterns to make cross-site requests.
        :paramtype allowed_origin_patterns: list[str]
        :keyword allowed_methods: Allowed HTTP methods on cross-site requests. The special value ``*``
         allows all methods. If not set, ``GET`` and ``HEAD`` are allowed by default.
        :paramtype allowed_methods: list[str]
        :keyword allowed_headers: Allowed headers in cross-site requests. The special value ``*``
         allows actual requests to send any header.
        :paramtype allowed_headers: list[str]
        :keyword max_age: How long, in seconds, the response from a pre-flight request can be cached by
         clients.
        :paramtype max_age: int
        :keyword allow_credentials: Whether user credentials are supported on cross-site requests.
         Valid values: ``true``\ , ``false``.
        :paramtype allow_credentials: bool
        :keyword exposed_headers: HTTP response headers to expose for cross-site requests.
        :paramtype exposed_headers: list[str]
        """
        super().__init__(**kwargs)
        self.allowed_origins = allowed_origins
        self.allowed_origin_patterns = allowed_origin_patterns
        self.allowed_methods = allowed_methods
        self.allowed_headers = allowed_headers
        self.max_age = max_age
        self.allow_credentials = allow_credentials
        self.exposed_headers = exposed_headers


class GatewayCustomDomainProperties(_serialization.Model):
    """The properties of custom domain for Spring Cloud Gateway.

    :ivar thumbprint: The thumbprint of bound certificate.
    :vartype thumbprint: str
    """

    _attribute_map = {
        "thumbprint": {"key": "thumbprint", "type": "str"},
    }

    def __init__(self, *, thumbprint: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword thumbprint: The thumbprint of bound certificate.
        :paramtype thumbprint: str
        """
        super().__init__(**kwargs)
        self.thumbprint = thumbprint


class GatewayCustomDomainResource(ProxyResource):
    """Custom domain of the Spring Cloud Gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.appplatform.v2023_07_01_preview.models.SystemData
    :ivar properties: The properties of custom domain for Spring Cloud Gateway.
    :vartype properties:
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.GatewayCustomDomainProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "GatewayCustomDomainProperties"},
    }

    def __init__(self, *, properties: Optional["_models.GatewayCustomDomainProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: The properties of custom domain for Spring Cloud Gateway.
        :paramtype properties:
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.GatewayCustomDomainProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class GatewayCustomDomainResourceCollection(_serialization.Model):
    """Object that includes an array of Spring Cloud Gateway custom domain resources and a possible
    link for next set.

    :ivar value: Collection of Spring Cloud Gateway custom domain resources.
    :vartype value:
     list[~azure.mgmt.appplatform.v2023_07_01_preview.models.GatewayCustomDomainResource]
    :ivar next_link: URL client should use to fetch the next page (per server side paging).
     It's null for now, added for future use.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[GatewayCustomDomainResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.GatewayCustomDomainResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Collection of Spring Cloud Gateway custom domain resources.
        :paramtype value:
         list[~azure.mgmt.appplatform.v2023_07_01_preview.models.GatewayCustomDomainResource]
        :keyword next_link: URL client should use to fetch the next page (per server side paging).
         It's null for now, added for future use.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class GatewayInstance(_serialization.Model):
    """Collection of instances belong to the Spring Cloud Gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the Spring Cloud Gateway instance.
    :vartype name: str
    :ivar status: Status of the Spring Cloud Gateway instance.
    :vartype status: str
    """

    _validation = {
        "name": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.status = None


class GatewayOperatorProperties(_serialization.Model):
    """Properties of the Spring Cloud Gateway Operator.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar resource_requests: The requested resource quantity for required CPU and Memory.
    :vartype resource_requests:
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.GatewayOperatorResourceRequests
    :ivar instances: Collection of instances belong to Spring Cloud Gateway operator.
    :vartype instances: list[~azure.mgmt.appplatform.v2023_07_01_preview.models.GatewayInstance]
    """

    _validation = {
        "resource_requests": {"readonly": True},
        "instances": {"readonly": True},
    }

    _attribute_map = {
        "resource_requests": {"key": "resourceRequests", "type": "GatewayOperatorResourceRequests"},
        "instances": {"key": "instances", "type": "[GatewayInstance]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.resource_requests = None
        self.instances = None


class GatewayOperatorResourceRequests(_serialization.Model):
    """Properties of the Spring Cloud Gateway Operator.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar cpu: Cpu allocated to each Spring Cloud Gateway Operator instance.
    :vartype cpu: str
    :ivar memory: Memory allocated to each Spring Cloud Gateway Operator instance.
    :vartype memory: str
    :ivar instance_count: Instance count of the Spring Cloud Gateway Operator.
    :vartype instance_count: int
    """

    _validation = {
        "cpu": {"readonly": True},
        "memory": {"readonly": True},
        "instance_count": {"readonly": True},
    }

    _attribute_map = {
        "cpu": {"key": "cpu", "type": "str"},
        "memory": {"key": "memory", "type": "str"},
        "instance_count": {"key": "instanceCount", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.cpu = None
        self.memory = None
        self.instance_count = None


class GatewayProperties(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Spring Cloud Gateway properties payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: State of the Spring Cloud Gateway. Known values are: "Creating",
     "Updating", "Succeeded", "Failed", and "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.GatewayProvisioningState
    :ivar public: Indicates whether the Spring Cloud Gateway exposes endpoint.
    :vartype public: bool
    :ivar url: URL of the Spring Cloud Gateway, exposed when 'public' is true.
    :vartype url: str
    :ivar https_only: Indicate if only https is allowed.
    :vartype https_only: bool
    :ivar sso_properties: Single sign-on related configuration.
    :vartype sso_properties: ~azure.mgmt.appplatform.v2023_07_01_preview.models.SsoProperties
    :ivar api_metadata_properties: API metadata property for Spring Cloud Gateway.
    :vartype api_metadata_properties:
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.GatewayApiMetadataProperties
    :ivar cors_properties: Cross-Origin Resource Sharing property.
    :vartype cors_properties:
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.GatewayCorsProperties
    :ivar client_auth: Client-Certification Authentication.
    :vartype client_auth:
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.GatewayPropertiesClientAuth
    :ivar apm_types: Collection of APM type used in Spring Cloud Gateway.
    :vartype apm_types: list[str or ~azure.mgmt.appplatform.v2023_07_01_preview.models.ApmType]
    :ivar environment_variables: Environment variables of Spring Cloud Gateway.
    :vartype environment_variables:
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.GatewayPropertiesEnvironmentVariables
    :ivar resource_requests: The requested resource quantity for required CPU and Memory.
    :vartype resource_requests:
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.GatewayResourceRequests
    :ivar addon_configs: Collection of addons for Spring Cloud Gateway.
    :vartype addon_configs: dict[str, JSON]
    :ivar instances: Collection of instances belong to Spring Cloud Gateway.
    :vartype instances: list[~azure.mgmt.appplatform.v2023_07_01_preview.models.GatewayInstance]
    :ivar operator_properties: Properties of the Spring Cloud Gateway Operator.
    :vartype operator_properties:
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.GatewayOperatorProperties
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "url": {"readonly": True},
        "apm_types": {"unique": True},
        "instances": {"readonly": True},
        "operator_properties": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "public": {"key": "public", "type": "bool"},
        "url": {"key": "url", "type": "str"},
        "https_only": {"key": "httpsOnly", "type": "bool"},
        "sso_properties": {"key": "ssoProperties", "type": "SsoProperties"},
        "api_metadata_properties": {"key": "apiMetadataProperties", "type": "GatewayApiMetadataProperties"},
        "cors_properties": {"key": "corsProperties", "type": "GatewayCorsProperties"},
        "client_auth": {"key": "clientAuth", "type": "GatewayPropertiesClientAuth"},
        "apm_types": {"key": "apmTypes", "type": "[str]"},
        "environment_variables": {"key": "environmentVariables", "type": "GatewayPropertiesEnvironmentVariables"},
        "resource_requests": {"key": "resourceRequests", "type": "GatewayResourceRequests"},
        "addon_configs": {"key": "addonConfigs", "type": "{object}"},
        "instances": {"key": "instances", "type": "[GatewayInstance]"},
        "operator_properties": {"key": "operatorProperties", "type": "GatewayOperatorProperties"},
    }

    def __init__(
        self,
        *,
        public: bool = False,
        https_only: bool = False,
        sso_properties: Optional["_models.SsoProperties"] = None,
        api_metadata_properties: Optional["_models.GatewayApiMetadataProperties"] = None,
        cors_properties: Optional["_models.GatewayCorsProperties"] = None,
        client_auth: Optional["_models.GatewayPropertiesClientAuth"] = None,
        apm_types: Optional[List[Union[str, "_models.ApmType"]]] = None,
        environment_variables: Optional["_models.GatewayPropertiesEnvironmentVariables"] = None,
        resource_requests: Optional["_models.GatewayResourceRequests"] = None,
        addon_configs: Optional[Dict[str, JSON]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword public: Indicates whether the Spring Cloud Gateway exposes endpoint.
        :paramtype public: bool
        :keyword https_only: Indicate if only https is allowed.
        :paramtype https_only: bool
        :keyword sso_properties: Single sign-on related configuration.
        :paramtype sso_properties: ~azure.mgmt.appplatform.v2023_07_01_preview.models.SsoProperties
        :keyword api_metadata_properties: API metadata property for Spring Cloud Gateway.
        :paramtype api_metadata_properties:
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.GatewayApiMetadataProperties
        :keyword cors_properties: Cross-Origin Resource Sharing property.
        :paramtype cors_properties:
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.GatewayCorsProperties
        :keyword client_auth: Client-Certification Authentication.
        :paramtype client_auth:
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.GatewayPropertiesClientAuth
        :keyword apm_types: Collection of APM type used in Spring Cloud Gateway.
        :paramtype apm_types: list[str or ~azure.mgmt.appplatform.v2023_07_01_preview.models.ApmType]
        :keyword environment_variables: Environment variables of Spring Cloud Gateway.
        :paramtype environment_variables:
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.GatewayPropertiesEnvironmentVariables
        :keyword resource_requests: The requested resource quantity for required CPU and Memory.
        :paramtype resource_requests:
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.GatewayResourceRequests
        :keyword addon_configs: Collection of addons for Spring Cloud Gateway.
        :paramtype addon_configs: dict[str, JSON]
        """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.public = public
        self.url = None
        self.https_only = https_only
        self.sso_properties = sso_properties
        self.api_metadata_properties = api_metadata_properties
        self.cors_properties = cors_properties
        self.client_auth = client_auth
        self.apm_types = apm_types
        self.environment_variables = environment_variables
        self.resource_requests = resource_requests
        self.addon_configs = addon_configs
        self.instances = None
        self.operator_properties = None


class GatewayPropertiesClientAuth(_serialization.Model):
    """Client-Certification Authentication.

    :ivar certificates: Collection of certificate resource Ids in Azure Spring Apps.
    :vartype certificates: list[str]
    :ivar certificate_verification: Whether to enable certificate verification or not. Known values
     are: "Enabled" and "Disabled".
    :vartype certificate_verification: str or
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.GatewayCertificateVerification
    """

    _validation = {
        "certificates": {"unique": True},
    }

    _attribute_map = {
        "certificates": {"key": "certificates", "type": "[str]"},
        "certificate_verification": {"key": "certificateVerification", "type": "str"},
    }

    def __init__(
        self,
        *,
        certificates: Optional[List[str]] = None,
        certificate_verification: Union[str, "_models.GatewayCertificateVerification"] = "Disabled",
        **kwargs: Any
    ) -> None:
        """
        :keyword certificates: Collection of certificate resource Ids in Azure Spring Apps.
        :paramtype certificates: list[str]
        :keyword certificate_verification: Whether to enable certificate verification or not. Known
         values are: "Enabled" and "Disabled".
        :paramtype certificate_verification: str or
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.GatewayCertificateVerification
        """
        super().__init__(**kwargs)
        self.certificates = certificates
        self.certificate_verification = certificate_verification


class GatewayPropertiesEnvironmentVariables(_serialization.Model):
    """Environment variables of Spring Cloud Gateway.

    :ivar properties: Non-sensitive properties.
    :vartype properties: dict[str, str]
    :ivar secrets: Sensitive properties.
    :vartype secrets: dict[str, str]
    """

    _attribute_map = {
        "properties": {"key": "properties", "type": "{str}"},
        "secrets": {"key": "secrets", "type": "{str}"},
    }

    def __init__(
        self, *, properties: Optional[Dict[str, str]] = None, secrets: Optional[Dict[str, str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword properties: Non-sensitive properties.
        :paramtype properties: dict[str, str]
        :keyword secrets: Sensitive properties.
        :paramtype secrets: dict[str, str]
        """
        super().__init__(**kwargs)
        self.properties = properties
        self.secrets = secrets


class GatewayResource(ProxyResource):
    """Spring Cloud Gateway resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.appplatform.v2023_07_01_preview.models.SystemData
    :ivar properties: Spring Cloud Gateway properties payload.
    :vartype properties: ~azure.mgmt.appplatform.v2023_07_01_preview.models.GatewayProperties
    :ivar sku: Sku of the Spring Cloud Gateway resource.
    :vartype sku: ~azure.mgmt.appplatform.v2023_07_01_preview.models.Sku
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "GatewayProperties"},
        "sku": {"key": "sku", "type": "Sku"},
    }

    def __init__(
        self,
        *,
        properties: Optional["_models.GatewayProperties"] = None,
        sku: Optional["_models.Sku"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword properties: Spring Cloud Gateway properties payload.
        :paramtype properties: ~azure.mgmt.appplatform.v2023_07_01_preview.models.GatewayProperties
        :keyword sku: Sku of the Spring Cloud Gateway resource.
        :paramtype sku: ~azure.mgmt.appplatform.v2023_07_01_preview.models.Sku
        """
        super().__init__(**kwargs)
        self.properties = properties
        self.sku = sku


class GatewayResourceCollection(_serialization.Model):
    """Object that includes an array of gateway resources and a possible link for next set.

    :ivar value: Collection of gateway resources.
    :vartype value: list[~azure.mgmt.appplatform.v2023_07_01_preview.models.GatewayResource]
    :ivar next_link: URL client should use to fetch the next page (per server side paging).
     It's null for now, added for future use.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[GatewayResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.GatewayResource"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Collection of gateway resources.
        :paramtype value: list[~azure.mgmt.appplatform.v2023_07_01_preview.models.GatewayResource]
        :keyword next_link: URL client should use to fetch the next page (per server side paging).
         It's null for now, added for future use.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class GatewayResourceRequests(_serialization.Model):
    """Resource request payload of Spring Cloud Gateway.

    :ivar cpu: Cpu allocated to each Spring Cloud Gateway instance.
    :vartype cpu: str
    :ivar memory: Memory allocated to each Spring Cloud Gateway instance.
    :vartype memory: str
    """

    _attribute_map = {
        "cpu": {"key": "cpu", "type": "str"},
        "memory": {"key": "memory", "type": "str"},
    }

    def __init__(self, *, cpu: str = "1", memory: str = "2Gi", **kwargs: Any) -> None:
        """
        :keyword cpu: Cpu allocated to each Spring Cloud Gateway instance.
        :paramtype cpu: str
        :keyword memory: Memory allocated to each Spring Cloud Gateway instance.
        :paramtype memory: str
        """
        super().__init__(**kwargs)
        self.cpu = cpu
        self.memory = memory


class GatewayRouteConfigOpenApiProperties(_serialization.Model):
    """OpenAPI properties of Spring Cloud Gateway route config.

    :ivar uri: The URI of OpenAPI specification.
    :vartype uri: str
    """

    _attribute_map = {
        "uri": {"key": "uri", "type": "str"},
    }

    def __init__(self, *, uri: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword uri: The URI of OpenAPI specification.
        :paramtype uri: str
        """
        super().__init__(**kwargs)
        self.uri = uri


class GatewayRouteConfigProperties(_serialization.Model):
    """API route config of the Spring Cloud Gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: State of the Spring Cloud Gateway route config. Known values are:
     "Creating", "Updating", "Succeeded", "Failed", and "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.GatewayProvisioningState
    :ivar app_resource_id: The resource Id of the Azure Spring Apps app, required unless route
     defines ``uri``.
    :vartype app_resource_id: str
    :ivar open_api: OpenAPI properties of Spring Cloud Gateway route config.
    :vartype open_api:
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.GatewayRouteConfigOpenApiProperties
    :ivar protocol: Protocol of routed Azure Spring Apps applications. Known values are: "HTTP" and
     "HTTPS".
    :vartype protocol: str or
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.GatewayRouteConfigProtocol
    :ivar routes: Array of API routes, each route contains properties such as ``title``\ , ``uri``\
     , ``ssoEnabled``\ , ``predicates``\ , ``filters``.
    :vartype routes: list[~azure.mgmt.appplatform.v2023_07_01_preview.models.GatewayApiRoute]
    :ivar sso_enabled: Enable Single Sign-On in app level.
    :vartype sso_enabled: bool
    :ivar predicates: A number of conditions to evaluate a route for each request in app level.
     Each predicate may be evaluated against request headers and parameter values. All of the
     predicates associated with a route must evaluate to true for the route to be matched to the
     request.
    :vartype predicates: list[str]
    :ivar filters: To modify the request before sending it to the target endpoint, or the received
     response in app level.
    :vartype filters: list[str]
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "app_resource_id": {"key": "appResourceId", "type": "str"},
        "open_api": {"key": "openApi", "type": "GatewayRouteConfigOpenApiProperties"},
        "protocol": {"key": "protocol", "type": "str"},
        "routes": {"key": "routes", "type": "[GatewayApiRoute]"},
        "sso_enabled": {"key": "ssoEnabled", "type": "bool"},
        "predicates": {"key": "predicates", "type": "[str]"},
        "filters": {"key": "filters", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        app_resource_id: Optional[str] = None,
        open_api: Optional["_models.GatewayRouteConfigOpenApiProperties"] = None,
        protocol: Union[str, "_models.GatewayRouteConfigProtocol"] = "HTTP",
        routes: Optional[List["_models.GatewayApiRoute"]] = None,
        sso_enabled: Optional[bool] = None,
        predicates: Optional[List[str]] = None,
        filters: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword app_resource_id: The resource Id of the Azure Spring Apps app, required unless route
         defines ``uri``.
        :paramtype app_resource_id: str
        :keyword open_api: OpenAPI properties of Spring Cloud Gateway route config.
        :paramtype open_api:
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.GatewayRouteConfigOpenApiProperties
        :keyword protocol: Protocol of routed Azure Spring Apps applications. Known values are: "HTTP"
         and "HTTPS".
        :paramtype protocol: str or
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.GatewayRouteConfigProtocol
        :keyword routes: Array of API routes, each route contains properties such as ``title``\ ,
         ``uri``\ , ``ssoEnabled``\ , ``predicates``\ , ``filters``.
        :paramtype routes: list[~azure.mgmt.appplatform.v2023_07_01_preview.models.GatewayApiRoute]
        :keyword sso_enabled: Enable Single Sign-On in app level.
        :paramtype sso_enabled: bool
        :keyword predicates: A number of conditions to evaluate a route for each request in app level.
         Each predicate may be evaluated against request headers and parameter values. All of the
         predicates associated with a route must evaluate to true for the route to be matched to the
         request.
        :paramtype predicates: list[str]
        :keyword filters: To modify the request before sending it to the target endpoint, or the
         received response in app level.
        :paramtype filters: list[str]
        """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.app_resource_id = app_resource_id
        self.open_api = open_api
        self.protocol = protocol
        self.routes = routes
        self.sso_enabled = sso_enabled
        self.predicates = predicates
        self.filters = filters


class GatewayRouteConfigResource(ProxyResource):
    """Spring Cloud Gateway route config resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.appplatform.v2023_07_01_preview.models.SystemData
    :ivar properties: API route config of the Spring Cloud Gateway.
    :vartype properties:
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.GatewayRouteConfigProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "GatewayRouteConfigProperties"},
    }

    def __init__(self, *, properties: Optional["_models.GatewayRouteConfigProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: API route config of the Spring Cloud Gateway.
        :paramtype properties:
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.GatewayRouteConfigProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class GatewayRouteConfigResourceCollection(_serialization.Model):
    """Object that includes an array of Spring Cloud Gateway route config resources and a possible
    link for next set.

    :ivar value: Collection of Spring Cloud Gateway route config resources.
    :vartype value:
     list[~azure.mgmt.appplatform.v2023_07_01_preview.models.GatewayRouteConfigResource]
    :ivar next_link: URL client should use to fetch the next page (per server side paging).
     It's null for now, added for future use.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[GatewayRouteConfigResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.GatewayRouteConfigResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Collection of Spring Cloud Gateway route config resources.
        :paramtype value:
         list[~azure.mgmt.appplatform.v2023_07_01_preview.models.GatewayRouteConfigResource]
        :keyword next_link: URL client should use to fetch the next page (per server side paging).
         It's null for now, added for future use.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class GitPatternRepository(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Git repository property payload for config server.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Name of the repository. Required.
    :vartype name: str
    :ivar pattern: Collection of pattern of the repository.
    :vartype pattern: list[str]
    :ivar uri: URI of the repository. Required.
    :vartype uri: str
    :ivar label: Label of the repository.
    :vartype label: str
    :ivar search_paths: Searching path of the repository.
    :vartype search_paths: list[str]
    :ivar username: Username of git repository basic auth.
    :vartype username: str
    :ivar password: Password of git repository basic auth.
    :vartype password: str
    :ivar host_key: Public sshKey of git repository.
    :vartype host_key: str
    :ivar host_key_algorithm: SshKey algorithm of git repository.
    :vartype host_key_algorithm: str
    :ivar private_key: Private sshKey algorithm of git repository.
    :vartype private_key: str
    :ivar strict_host_key_checking: Strict host key checking or not.
    :vartype strict_host_key_checking: bool
    """

    _validation = {
        "name": {"required": True},
        "uri": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "pattern": {"key": "pattern", "type": "[str]"},
        "uri": {"key": "uri", "type": "str"},
        "label": {"key": "label", "type": "str"},
        "search_paths": {"key": "searchPaths", "type": "[str]"},
        "username": {"key": "username", "type": "str"},
        "password": {"key": "password", "type": "str"},
        "host_key": {"key": "hostKey", "type": "str"},
        "host_key_algorithm": {"key": "hostKeyAlgorithm", "type": "str"},
        "private_key": {"key": "privateKey", "type": "str"},
        "strict_host_key_checking": {"key": "strictHostKeyChecking", "type": "bool"},
    }

    def __init__(
        self,
        *,
        name: str,
        uri: str,
        pattern: Optional[List[str]] = None,
        label: Optional[str] = None,
        search_paths: Optional[List[str]] = None,
        username: Optional[str] = None,
        password: Optional[str] = None,
        host_key: Optional[str] = None,
        host_key_algorithm: Optional[str] = None,
        private_key: Optional[str] = None,
        strict_host_key_checking: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the repository. Required.
        :paramtype name: str
        :keyword pattern: Collection of pattern of the repository.
        :paramtype pattern: list[str]
        :keyword uri: URI of the repository. Required.
        :paramtype uri: str
        :keyword label: Label of the repository.
        :paramtype label: str
        :keyword search_paths: Searching path of the repository.
        :paramtype search_paths: list[str]
        :keyword username: Username of git repository basic auth.
        :paramtype username: str
        :keyword password: Password of git repository basic auth.
        :paramtype password: str
        :keyword host_key: Public sshKey of git repository.
        :paramtype host_key: str
        :keyword host_key_algorithm: SshKey algorithm of git repository.
        :paramtype host_key_algorithm: str
        :keyword private_key: Private sshKey algorithm of git repository.
        :paramtype private_key: str
        :keyword strict_host_key_checking: Strict host key checking or not.
        :paramtype strict_host_key_checking: bool
        """
        super().__init__(**kwargs)
        self.name = name
        self.pattern = pattern
        self.uri = uri
        self.label = label
        self.search_paths = search_paths
        self.username = username
        self.password = password
        self.host_key = host_key
        self.host_key_algorithm = host_key_algorithm
        self.private_key = private_key
        self.strict_host_key_checking = strict_host_key_checking


class GloballyEnabledApms(_serialization.Model):
    """Globally enabled APMs payload.

    :ivar value: Collection of the globally enabled APMs.
    :vartype value: list[str]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[str]"},
    }

    def __init__(self, *, value: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword value: Collection of the globally enabled APMs.
        :paramtype value: list[str]
        """
        super().__init__(**kwargs)
        self.value = value


class HTTPGetAction(ProbeAction):
    """HTTPGetAction describes an action based on HTTP Get requests.

    All required parameters must be populated in order to send to Azure.

    :ivar type: The type of the action to take to perform the health check. Required. Known values
     are: "HTTPGetAction", "TCPSocketAction", and "ExecAction".
    :vartype type: str or ~azure.mgmt.appplatform.v2023_07_01_preview.models.ProbeActionType
    :ivar path: Path to access on the HTTP server.
    :vartype path: str
    :ivar scheme: Scheme to use for connecting to the host. Defaults to HTTP.

     Possible enum values:


     * ``"HTTP"`` means that the scheme used will be http://
     * ``"HTTPS"`` means that the scheme used will be https://. Known values are: "HTTP" and
     "HTTPS".
    :vartype scheme: str or ~azure.mgmt.appplatform.v2023_07_01_preview.models.HTTPSchemeType
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "path": {"key": "path", "type": "str"},
        "scheme": {"key": "scheme", "type": "str"},
    }

    def __init__(
        self,
        *,
        path: Optional[str] = None,
        scheme: Optional[Union[str, "_models.HTTPSchemeType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword path: Path to access on the HTTP server.
        :paramtype path: str
        :keyword scheme: Scheme to use for connecting to the host. Defaults to HTTP.

         Possible enum values:


         * ``"HTTP"`` means that the scheme used will be http://
         * ``"HTTPS"`` means that the scheme used will be https://. Known values are: "HTTP" and
         "HTTPS".
        :paramtype scheme: str or ~azure.mgmt.appplatform.v2023_07_01_preview.models.HTTPSchemeType
        """
        super().__init__(**kwargs)
        self.type: str = "HTTPGetAction"
        self.path = path
        self.scheme = scheme


class HttpScaleRule(_serialization.Model):
    """Azure Spring Apps App Instance Http scaling rule.

    :ivar metadata: Metadata properties to describe http scale rule.
    :vartype metadata: dict[str, str]
    :ivar auth: Authentication secrets for the custom scale rule.
    :vartype auth: list[~azure.mgmt.appplatform.v2023_07_01_preview.models.ScaleRuleAuth]
    """

    _attribute_map = {
        "metadata": {"key": "metadata", "type": "{str}"},
        "auth": {"key": "auth", "type": "[ScaleRuleAuth]"},
    }

    def __init__(
        self,
        *,
        metadata: Optional[Dict[str, str]] = None,
        auth: Optional[List["_models.ScaleRuleAuth"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword metadata: Metadata properties to describe http scale rule.
        :paramtype metadata: dict[str, str]
        :keyword auth: Authentication secrets for the custom scale rule.
        :paramtype auth: list[~azure.mgmt.appplatform.v2023_07_01_preview.models.ScaleRuleAuth]
        """
        super().__init__(**kwargs)
        self.metadata = metadata
        self.auth = auth


class ImageRegistryCredential(_serialization.Model):
    """Credential of the image registry.

    :ivar username: The username of the image registry credential.
    :vartype username: str
    :ivar password: The password of the image registry credential.
    :vartype password: str
    """

    _attribute_map = {
        "username": {"key": "username", "type": "str"},
        "password": {"key": "password", "type": "str"},
    }

    def __init__(self, *, username: Optional[str] = None, password: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword username: The username of the image registry credential.
        :paramtype username: str
        :keyword password: The password of the image registry credential.
        :paramtype password: str
        """
        super().__init__(**kwargs)
        self.username = username
        self.password = password


class IngressConfig(_serialization.Model):
    """Ingress configuration payload for Azure Spring Apps resource.

    :ivar read_timeout_in_seconds: Ingress read time out in seconds.
    :vartype read_timeout_in_seconds: int
    """

    _attribute_map = {
        "read_timeout_in_seconds": {"key": "readTimeoutInSeconds", "type": "int"},
    }

    def __init__(self, *, read_timeout_in_seconds: Optional[int] = None, **kwargs: Any) -> None:
        """
        :keyword read_timeout_in_seconds: Ingress read time out in seconds.
        :paramtype read_timeout_in_seconds: int
        """
        super().__init__(**kwargs)
        self.read_timeout_in_seconds = read_timeout_in_seconds


class IngressSettings(_serialization.Model):
    """App ingress settings payload.

    :ivar read_timeout_in_seconds: Ingress read time out in seconds.
    :vartype read_timeout_in_seconds: int
    :ivar send_timeout_in_seconds: Ingress send time out in seconds.
    :vartype send_timeout_in_seconds: int
    :ivar session_affinity: Type of the affinity, set this to Cookie to enable session affinity.
     Known values are: "Cookie" and "None".
    :vartype session_affinity: str or
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.SessionAffinity
    :ivar session_cookie_max_age: Time in seconds until the cookie expires.
    :vartype session_cookie_max_age: int
    :ivar backend_protocol: How ingress should communicate with this app backend service. Known
     values are: "GRPC" and "Default".
    :vartype backend_protocol: str or
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.BackendProtocol
    :ivar client_auth: Client-Certification Authentication.
    :vartype client_auth:
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.IngressSettingsClientAuth
    """

    _attribute_map = {
        "read_timeout_in_seconds": {"key": "readTimeoutInSeconds", "type": "int"},
        "send_timeout_in_seconds": {"key": "sendTimeoutInSeconds", "type": "int"},
        "session_affinity": {"key": "sessionAffinity", "type": "str"},
        "session_cookie_max_age": {"key": "sessionCookieMaxAge", "type": "int"},
        "backend_protocol": {"key": "backendProtocol", "type": "str"},
        "client_auth": {"key": "clientAuth", "type": "IngressSettingsClientAuth"},
    }

    def __init__(
        self,
        *,
        read_timeout_in_seconds: Optional[int] = None,
        send_timeout_in_seconds: Optional[int] = None,
        session_affinity: Optional[Union[str, "_models.SessionAffinity"]] = None,
        session_cookie_max_age: Optional[int] = None,
        backend_protocol: Optional[Union[str, "_models.BackendProtocol"]] = None,
        client_auth: Optional["_models.IngressSettingsClientAuth"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword read_timeout_in_seconds: Ingress read time out in seconds.
        :paramtype read_timeout_in_seconds: int
        :keyword send_timeout_in_seconds: Ingress send time out in seconds.
        :paramtype send_timeout_in_seconds: int
        :keyword session_affinity: Type of the affinity, set this to Cookie to enable session affinity.
         Known values are: "Cookie" and "None".
        :paramtype session_affinity: str or
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.SessionAffinity
        :keyword session_cookie_max_age: Time in seconds until the cookie expires.
        :paramtype session_cookie_max_age: int
        :keyword backend_protocol: How ingress should communicate with this app backend service. Known
         values are: "GRPC" and "Default".
        :paramtype backend_protocol: str or
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.BackendProtocol
        :keyword client_auth: Client-Certification Authentication.
        :paramtype client_auth:
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.IngressSettingsClientAuth
        """
        super().__init__(**kwargs)
        self.read_timeout_in_seconds = read_timeout_in_seconds
        self.send_timeout_in_seconds = send_timeout_in_seconds
        self.session_affinity = session_affinity
        self.session_cookie_max_age = session_cookie_max_age
        self.backend_protocol = backend_protocol
        self.client_auth = client_auth


class IngressSettingsClientAuth(_serialization.Model):
    """Client-Certification Authentication.

    :ivar certificates: Collection of certificate resource id.
    :vartype certificates: list[str]
    """

    _attribute_map = {
        "certificates": {"key": "certificates", "type": "[str]"},
    }

    def __init__(self, *, certificates: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword certificates: Collection of certificate resource id.
        :paramtype certificates: list[str]
        """
        super().__init__(**kwargs)
        self.certificates = certificates


class UploadedUserSourceInfo(UserSourceInfo):
    """Source with uploaded location.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    JarUploadedUserSourceInfo, NetCoreZipUploadedUserSourceInfo, SourceUploadedUserSourceInfo

    All required parameters must be populated in order to send to Azure.

    :ivar type: Type of the source uploaded. Required.
    :vartype type: str
    :ivar version: Version of the source.
    :vartype version: str
    :ivar relative_path: Relative path of the storage which stores the source.
    :vartype relative_path: str
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "version": {"key": "version", "type": "str"},
        "relative_path": {"key": "relativePath", "type": "str"},
    }

    _subtype_map = {
        "type": {
            "Jar": "JarUploadedUserSourceInfo",
            "NetCoreZip": "NetCoreZipUploadedUserSourceInfo",
            "Source": "SourceUploadedUserSourceInfo",
        }
    }

    def __init__(self, *, version: Optional[str] = None, relative_path: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword version: Version of the source.
        :paramtype version: str
        :keyword relative_path: Relative path of the storage which stores the source.
        :paramtype relative_path: str
        """
        super().__init__(version=version, **kwargs)
        self.type: str = "UploadedUserSourceInfo"
        self.relative_path = relative_path


class JarUploadedUserSourceInfo(UploadedUserSourceInfo):
    """Uploaded Jar binary for a deployment.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Type of the source uploaded. Required.
    :vartype type: str
    :ivar version: Version of the source.
    :vartype version: str
    :ivar relative_path: Relative path of the storage which stores the source.
    :vartype relative_path: str
    :ivar runtime_version: Runtime version of the Jar file.
    :vartype runtime_version: str
    :ivar jvm_options: JVM parameter.
    :vartype jvm_options: str
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "version": {"key": "version", "type": "str"},
        "relative_path": {"key": "relativePath", "type": "str"},
        "runtime_version": {"key": "runtimeVersion", "type": "str"},
        "jvm_options": {"key": "jvmOptions", "type": "str"},
    }

    def __init__(
        self,
        *,
        version: Optional[str] = None,
        relative_path: Optional[str] = None,
        runtime_version: Optional[str] = None,
        jvm_options: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword version: Version of the source.
        :paramtype version: str
        :keyword relative_path: Relative path of the storage which stores the source.
        :paramtype relative_path: str
        :keyword runtime_version: Runtime version of the Jar file.
        :paramtype runtime_version: str
        :keyword jvm_options: JVM parameter.
        :paramtype jvm_options: str
        """
        super().__init__(version=version, relative_path=relative_path, **kwargs)
        self.type: str = "Jar"
        self.runtime_version = runtime_version
        self.jvm_options = jvm_options


class KeyVaultCertificateProperties(CertificateProperties):  # pylint: disable=too-many-instance-attributes
    """Properties of certificate imported from key vault.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: The type of the certificate source. Required.
    :vartype type: str
    :ivar thumbprint: The thumbprint of certificate.
    :vartype thumbprint: str
    :ivar issuer: The issuer of certificate.
    :vartype issuer: str
    :ivar issued_date: The issue date of certificate.
    :vartype issued_date: str
    :ivar expiration_date: The expiration date of certificate.
    :vartype expiration_date: str
    :ivar activate_date: The activate date of certificate.
    :vartype activate_date: str
    :ivar subject_name: The subject name of certificate.
    :vartype subject_name: str
    :ivar dns_names: The domain list of certificate.
    :vartype dns_names: list[str]
    :ivar provisioning_state: Provisioning state of the Certificate. Known values are: "Creating",
     "Updating", "Succeeded", "Failed", and "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.CertificateResourceProvisioningState
    :ivar vault_uri: The vault uri of user key vault. Required.
    :vartype vault_uri: str
    :ivar key_vault_cert_name: The certificate name of key vault. Required.
    :vartype key_vault_cert_name: str
    :ivar cert_version: The certificate version of key vault.
    :vartype cert_version: str
    :ivar exclude_private_key: Optional. If set to true, it will not import private key from key
     vault.
    :vartype exclude_private_key: bool
    """

    _validation = {
        "type": {"required": True},
        "thumbprint": {"readonly": True},
        "issuer": {"readonly": True},
        "issued_date": {"readonly": True},
        "expiration_date": {"readonly": True},
        "activate_date": {"readonly": True},
        "subject_name": {"readonly": True},
        "dns_names": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "vault_uri": {"required": True},
        "key_vault_cert_name": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "thumbprint": {"key": "thumbprint", "type": "str"},
        "issuer": {"key": "issuer", "type": "str"},
        "issued_date": {"key": "issuedDate", "type": "str"},
        "expiration_date": {"key": "expirationDate", "type": "str"},
        "activate_date": {"key": "activateDate", "type": "str"},
        "subject_name": {"key": "subjectName", "type": "str"},
        "dns_names": {"key": "dnsNames", "type": "[str]"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "vault_uri": {"key": "vaultUri", "type": "str"},
        "key_vault_cert_name": {"key": "keyVaultCertName", "type": "str"},
        "cert_version": {"key": "certVersion", "type": "str"},
        "exclude_private_key": {"key": "excludePrivateKey", "type": "bool"},
    }

    def __init__(
        self,
        *,
        vault_uri: str,
        key_vault_cert_name: str,
        cert_version: Optional[str] = None,
        exclude_private_key: bool = False,
        **kwargs: Any
    ) -> None:
        """
        :keyword vault_uri: The vault uri of user key vault. Required.
        :paramtype vault_uri: str
        :keyword key_vault_cert_name: The certificate name of key vault. Required.
        :paramtype key_vault_cert_name: str
        :keyword cert_version: The certificate version of key vault.
        :paramtype cert_version: str
        :keyword exclude_private_key: Optional. If set to true, it will not import private key from key
         vault.
        :paramtype exclude_private_key: bool
        """
        super().__init__(**kwargs)
        self.type: str = "KeyVaultCertificate"
        self.vault_uri = vault_uri
        self.key_vault_cert_name = key_vault_cert_name
        self.cert_version = cert_version
        self.exclude_private_key = exclude_private_key


class LoadedCertificate(_serialization.Model):
    """Loaded certificate payload.

    All required parameters must be populated in order to send to Azure.

    :ivar resource_id: Resource Id of loaded certificate. Required.
    :vartype resource_id: str
    :ivar load_trust_store: Indicate whether the certificate will be loaded into default trust
     store, only work for Java runtime.
    :vartype load_trust_store: bool
    """

    _validation = {
        "resource_id": {"required": True},
    }

    _attribute_map = {
        "resource_id": {"key": "resourceId", "type": "str"},
        "load_trust_store": {"key": "loadTrustStore", "type": "bool"},
    }

    def __init__(self, *, resource_id: str, load_trust_store: bool = False, **kwargs: Any) -> None:
        """
        :keyword resource_id: Resource Id of loaded certificate. Required.
        :paramtype resource_id: str
        :keyword load_trust_store: Indicate whether the certificate will be loaded into default trust
         store, only work for Java runtime.
        :paramtype load_trust_store: bool
        """
        super().__init__(**kwargs)
        self.resource_id = resource_id
        self.load_trust_store = load_trust_store


class LogFileUrlResponse(_serialization.Model):
    """Log file URL payload.

    All required parameters must be populated in order to send to Azure.

    :ivar url: URL of the log file. Required.
    :vartype url: str
    """

    _validation = {
        "url": {"required": True},
    }

    _attribute_map = {
        "url": {"key": "url", "type": "str"},
    }

    def __init__(self, *, url: str, **kwargs: Any) -> None:
        """
        :keyword url: URL of the log file. Required.
        :paramtype url: str
        """
        super().__init__(**kwargs)
        self.url = url


class LogSpecification(_serialization.Model):
    """Specifications of the Log for Azure Monitoring.

    :ivar name: Name of the log.
    :vartype name: str
    :ivar display_name: Localized friendly display name of the log.
    :vartype display_name: str
    :ivar blob_duration: Blob duration of the log.
    :vartype blob_duration: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "blob_duration": {"key": "blobDuration", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        blob_duration: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the log.
        :paramtype name: str
        :keyword display_name: Localized friendly display name of the log.
        :paramtype display_name: str
        :keyword blob_duration: Blob duration of the log.
        :paramtype blob_duration: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.blob_duration = blob_duration


class MaintenanceScheduleConfiguration(_serialization.Model):
    """Configuration for the planned maintenance.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    WeeklyMaintenanceScheduleConfiguration

    All required parameters must be populated in order to send to Azure.

    :ivar frequency: The frequency to run the maintenance job. Required. "Weekly"
    :vartype frequency: str or ~azure.mgmt.appplatform.v2023_07_01_preview.models.Frequency
    """

    _validation = {
        "frequency": {"required": True},
    }

    _attribute_map = {
        "frequency": {"key": "frequency", "type": "str"},
    }

    _subtype_map = {"frequency": {"Weekly": "WeeklyMaintenanceScheduleConfiguration"}}

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.frequency: Optional[str] = None


class ManagedIdentityProperties(_serialization.Model):
    """Managed identity properties retrieved from ARM request headers.

    :ivar type: Type of the managed identity. Known values are: "None", "SystemAssigned",
     "UserAssigned", and "SystemAssigned,UserAssigned".
    :vartype type: str or ~azure.mgmt.appplatform.v2023_07_01_preview.models.ManagedIdentityType
    :ivar principal_id: Principal Id of system-assigned managed identity.
    :vartype principal_id: str
    :ivar tenant_id: Tenant Id of system-assigned managed identity.
    :vartype tenant_id: str
    :ivar user_assigned_identities: Properties of user-assigned managed identities.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.UserAssignedManagedIdentity]
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "user_assigned_identities": {"key": "userAssignedIdentities", "type": "{UserAssignedManagedIdentity}"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.ManagedIdentityType"]] = None,
        principal_id: Optional[str] = None,
        tenant_id: Optional[str] = None,
        user_assigned_identities: Optional[Dict[str, "_models.UserAssignedManagedIdentity"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Type of the managed identity. Known values are: "None", "SystemAssigned",
         "UserAssigned", and "SystemAssigned,UserAssigned".
        :paramtype type: str or ~azure.mgmt.appplatform.v2023_07_01_preview.models.ManagedIdentityType
        :keyword principal_id: Principal Id of system-assigned managed identity.
        :paramtype principal_id: str
        :keyword tenant_id: Tenant Id of system-assigned managed identity.
        :paramtype tenant_id: str
        :keyword user_assigned_identities: Properties of user-assigned managed identities.
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.UserAssignedManagedIdentity]
        """
        super().__init__(**kwargs)
        self.type = type
        self.principal_id = principal_id
        self.tenant_id = tenant_id
        self.user_assigned_identities = user_assigned_identities


class MarketplaceResource(_serialization.Model):
    """Purchasing 3rd Party product for one Azure Spring Apps instance.

    :ivar plan: The plan id of the 3rd Party Artifact that is being procured.
    :vartype plan: str
    :ivar publisher: The publisher id of the 3rd Party Artifact that is being bought.
    :vartype publisher: str
    :ivar product: The 3rd Party artifact that is being procured.
    :vartype product: str
    """

    _attribute_map = {
        "plan": {"key": "plan", "type": "str"},
        "publisher": {"key": "publisher", "type": "str"},
        "product": {"key": "product", "type": "str"},
    }

    def __init__(
        self,
        *,
        plan: Optional[str] = None,
        publisher: Optional[str] = None,
        product: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword plan: The plan id of the 3rd Party Artifact that is being procured.
        :paramtype plan: str
        :keyword publisher: The publisher id of the 3rd Party Artifact that is being bought.
        :paramtype publisher: str
        :keyword product: The 3rd Party artifact that is being procured.
        :paramtype product: str
        """
        super().__init__(**kwargs)
        self.plan = plan
        self.publisher = publisher
        self.product = product


class MetricDimension(_serialization.Model):
    """Specifications of the Dimension of metrics.

    :ivar name: Name of the dimension.
    :vartype name: str
    :ivar display_name: Localized friendly display name of the dimension.
    :vartype display_name: str
    :ivar to_be_exported_for_shoebox: Whether this dimension should be included for the Shoebox
     export scenario.
    :vartype to_be_exported_for_shoebox: bool
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "to_be_exported_for_shoebox": {"key": "toBeExportedForShoebox", "type": "bool"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        to_be_exported_for_shoebox: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the dimension.
        :paramtype name: str
        :keyword display_name: Localized friendly display name of the dimension.
        :paramtype display_name: str
        :keyword to_be_exported_for_shoebox: Whether this dimension should be included for the Shoebox
         export scenario.
        :paramtype to_be_exported_for_shoebox: bool
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.to_be_exported_for_shoebox = to_be_exported_for_shoebox


class MetricSpecification(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Specifications of the Metrics for Azure Monitoring.

    :ivar name: Name of the metric.
    :vartype name: str
    :ivar display_name: Localized friendly display name of the metric.
    :vartype display_name: str
    :ivar display_description: Localized friendly description of the metric.
    :vartype display_description: str
    :ivar unit: Unit that makes sense for the metric.
    :vartype unit: str
    :ivar category: Name of the metric category that the metric belongs to. A metric can only
     belong to a single category.
    :vartype category: str
    :ivar aggregation_type: Only provide one value for this field. Valid values: Average, Minimum,
     Maximum, Total, Count.
    :vartype aggregation_type: str
    :ivar supported_aggregation_types: Supported aggregation types.
    :vartype supported_aggregation_types: list[str]
    :ivar supported_time_grain_types: Supported time grain types.
    :vartype supported_time_grain_types: list[str]
    :ivar fill_gap_with_zero: Optional. If set to true, then zero will be returned for time
     duration where no metric is emitted/published.
    :vartype fill_gap_with_zero: bool
    :ivar dimensions: Dimensions of the metric.
    :vartype dimensions: list[~azure.mgmt.appplatform.v2023_07_01_preview.models.MetricDimension]
    :ivar source_mdm_namespace: Name of the MDM namespace. Optional.
    :vartype source_mdm_namespace: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "display_description": {"key": "displayDescription", "type": "str"},
        "unit": {"key": "unit", "type": "str"},
        "category": {"key": "category", "type": "str"},
        "aggregation_type": {"key": "aggregationType", "type": "str"},
        "supported_aggregation_types": {"key": "supportedAggregationTypes", "type": "[str]"},
        "supported_time_grain_types": {"key": "supportedTimeGrainTypes", "type": "[str]"},
        "fill_gap_with_zero": {"key": "fillGapWithZero", "type": "bool"},
        "dimensions": {"key": "dimensions", "type": "[MetricDimension]"},
        "source_mdm_namespace": {"key": "sourceMdmNamespace", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        display_description: Optional[str] = None,
        unit: Optional[str] = None,
        category: Optional[str] = None,
        aggregation_type: Optional[str] = None,
        supported_aggregation_types: Optional[List[str]] = None,
        supported_time_grain_types: Optional[List[str]] = None,
        fill_gap_with_zero: Optional[bool] = None,
        dimensions: Optional[List["_models.MetricDimension"]] = None,
        source_mdm_namespace: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the metric.
        :paramtype name: str
        :keyword display_name: Localized friendly display name of the metric.
        :paramtype display_name: str
        :keyword display_description: Localized friendly description of the metric.
        :paramtype display_description: str
        :keyword unit: Unit that makes sense for the metric.
        :paramtype unit: str
        :keyword category: Name of the metric category that the metric belongs to. A metric can only
         belong to a single category.
        :paramtype category: str
        :keyword aggregation_type: Only provide one value for this field. Valid values: Average,
         Minimum, Maximum, Total, Count.
        :paramtype aggregation_type: str
        :keyword supported_aggregation_types: Supported aggregation types.
        :paramtype supported_aggregation_types: list[str]
        :keyword supported_time_grain_types: Supported time grain types.
        :paramtype supported_time_grain_types: list[str]
        :keyword fill_gap_with_zero: Optional. If set to true, then zero will be returned for time
         duration where no metric is emitted/published.
        :paramtype fill_gap_with_zero: bool
        :keyword dimensions: Dimensions of the metric.
        :paramtype dimensions: list[~azure.mgmt.appplatform.v2023_07_01_preview.models.MetricDimension]
        :keyword source_mdm_namespace: Name of the MDM namespace. Optional.
        :paramtype source_mdm_namespace: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.display_description = display_description
        self.unit = unit
        self.category = category
        self.aggregation_type = aggregation_type
        self.supported_aggregation_types = supported_aggregation_types
        self.supported_time_grain_types = supported_time_grain_types
        self.fill_gap_with_zero = fill_gap_with_zero
        self.dimensions = dimensions
        self.source_mdm_namespace = source_mdm_namespace


class MonitoringSettingProperties(_serialization.Model):
    """Monitoring Setting properties payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: State of the Monitoring Setting. Known values are: "NotAvailable",
     "Failed", "Succeeded", and "Updating".
    :vartype provisioning_state: str or
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.MonitoringSettingState
    :ivar error: Error when apply Monitoring Setting changes.
    :vartype error: ~azure.mgmt.appplatform.v2023_07_01_preview.models.Error
    :ivar trace_enabled: Indicates whether enable the trace functionality, which will be deprecated
     since api version 2020-11-01-preview. Please leverage appInsightsInstrumentationKey to indicate
     if monitoringSettings enabled or not.
    :vartype trace_enabled: bool
    :ivar app_insights_instrumentation_key: Target application insight instrumentation key, null or
     whitespace include empty will disable monitoringSettings.
    :vartype app_insights_instrumentation_key: str
    :ivar app_insights_sampling_rate: Indicates the sampling rate of application insight agent,
     should be in range [0.0, 100.0].
    :vartype app_insights_sampling_rate: float
    :ivar app_insights_agent_versions: Indicates the versions of application insight agent.
    :vartype app_insights_agent_versions:
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.ApplicationInsightsAgentVersions
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "app_insights_sampling_rate": {"maximum": 100, "minimum": 0},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "error": {"key": "error", "type": "Error"},
        "trace_enabled": {"key": "traceEnabled", "type": "bool"},
        "app_insights_instrumentation_key": {"key": "appInsightsInstrumentationKey", "type": "str"},
        "app_insights_sampling_rate": {"key": "appInsightsSamplingRate", "type": "float"},
        "app_insights_agent_versions": {"key": "appInsightsAgentVersions", "type": "ApplicationInsightsAgentVersions"},
    }

    def __init__(
        self,
        *,
        error: Optional["_models.Error"] = None,
        trace_enabled: Optional[bool] = None,
        app_insights_instrumentation_key: Optional[str] = None,
        app_insights_sampling_rate: Optional[float] = None,
        app_insights_agent_versions: Optional["_models.ApplicationInsightsAgentVersions"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword error: Error when apply Monitoring Setting changes.
        :paramtype error: ~azure.mgmt.appplatform.v2023_07_01_preview.models.Error
        :keyword trace_enabled: Indicates whether enable the trace functionality, which will be
         deprecated since api version 2020-11-01-preview. Please leverage appInsightsInstrumentationKey
         to indicate if monitoringSettings enabled or not.
        :paramtype trace_enabled: bool
        :keyword app_insights_instrumentation_key: Target application insight instrumentation key, null
         or whitespace include empty will disable monitoringSettings.
        :paramtype app_insights_instrumentation_key: str
        :keyword app_insights_sampling_rate: Indicates the sampling rate of application insight agent,
         should be in range [0.0, 100.0].
        :paramtype app_insights_sampling_rate: float
        :keyword app_insights_agent_versions: Indicates the versions of application insight agent.
        :paramtype app_insights_agent_versions:
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.ApplicationInsightsAgentVersions
        """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.error = error
        self.trace_enabled = trace_enabled
        self.app_insights_instrumentation_key = app_insights_instrumentation_key
        self.app_insights_sampling_rate = app_insights_sampling_rate
        self.app_insights_agent_versions = app_insights_agent_versions


class MonitoringSettingResource(ProxyResource):
    """Monitoring Setting resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.appplatform.v2023_07_01_preview.models.SystemData
    :ivar properties: Properties of the Monitoring Setting resource.
    :vartype properties:
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.MonitoringSettingProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "MonitoringSettingProperties"},
    }

    def __init__(self, *, properties: Optional["_models.MonitoringSettingProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: Properties of the Monitoring Setting resource.
        :paramtype properties:
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.MonitoringSettingProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class NameAvailability(_serialization.Model):
    """Name availability result payload.

    :ivar name_available: Indicates whether the name is available.
    :vartype name_available: bool
    :ivar reason: Reason why the name is not available.
    :vartype reason: str
    :ivar message: Message why the name is not available.
    :vartype message: str
    """

    _attribute_map = {
        "name_available": {"key": "nameAvailable", "type": "bool"},
        "reason": {"key": "reason", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(
        self,
        *,
        name_available: Optional[bool] = None,
        reason: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name_available: Indicates whether the name is available.
        :paramtype name_available: bool
        :keyword reason: Reason why the name is not available.
        :paramtype reason: str
        :keyword message: Message why the name is not available.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.name_available = name_available
        self.reason = reason
        self.message = message


class NameAvailabilityParameters(_serialization.Model):
    """Name availability parameters payload.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Type of the resource to check name availability. Required.
    :vartype type: str
    :ivar name: Name to be checked. Required.
    :vartype name: str
    """

    _validation = {
        "type": {"required": True},
        "name": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, type: str, name: str, **kwargs: Any) -> None:
        """
        :keyword type: Type of the resource to check name availability. Required.
        :paramtype type: str
        :keyword name: Name to be checked. Required.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.type = type
        self.name = name


class NetCoreZipUploadedUserSourceInfo(UploadedUserSourceInfo):
    """Uploaded Jar binary for a deployment.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Type of the source uploaded. Required.
    :vartype type: str
    :ivar version: Version of the source.
    :vartype version: str
    :ivar relative_path: Relative path of the storage which stores the source.
    :vartype relative_path: str
    :ivar net_core_main_entry_path: The path to the .NET executable relative to zip root.
    :vartype net_core_main_entry_path: str
    :ivar runtime_version: Runtime version of the .Net file.
    :vartype runtime_version: str
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "version": {"key": "version", "type": "str"},
        "relative_path": {"key": "relativePath", "type": "str"},
        "net_core_main_entry_path": {"key": "netCoreMainEntryPath", "type": "str"},
        "runtime_version": {"key": "runtimeVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        version: Optional[str] = None,
        relative_path: Optional[str] = None,
        net_core_main_entry_path: Optional[str] = None,
        runtime_version: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword version: Version of the source.
        :paramtype version: str
        :keyword relative_path: Relative path of the storage which stores the source.
        :paramtype relative_path: str
        :keyword net_core_main_entry_path: The path to the .NET executable relative to zip root.
        :paramtype net_core_main_entry_path: str
        :keyword runtime_version: Runtime version of the .Net file.
        :paramtype runtime_version: str
        """
        super().__init__(version=version, relative_path=relative_path, **kwargs)
        self.type: str = "NetCoreZip"
        self.net_core_main_entry_path = net_core_main_entry_path
        self.runtime_version = runtime_version


class NetworkProfile(_serialization.Model):
    """Service network profile payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar service_runtime_subnet_id: Fully qualified resource Id of the subnet to host Azure Spring
     Apps Service Runtime.
    :vartype service_runtime_subnet_id: str
    :ivar app_subnet_id: Fully qualified resource Id of the subnet to host customer apps in Azure
     Spring Apps.
    :vartype app_subnet_id: str
    :ivar service_cidr: Azure Spring Apps service reserved CIDR.
    :vartype service_cidr: str
    :ivar service_runtime_network_resource_group: Name of the resource group containing network
     resources of Azure Spring Apps Service Runtime.
    :vartype service_runtime_network_resource_group: str
    :ivar app_network_resource_group: Name of the resource group containing network resources for
     customer apps in Azure Spring Apps.
    :vartype app_network_resource_group: str
    :ivar outbound_i_ps: Desired outbound IP resources for Azure Spring Apps resource.
    :vartype outbound_i_ps:
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.NetworkProfileOutboundIPs
    :ivar required_traffics: Required inbound or outbound traffics for Azure Spring Apps resource.
    :vartype required_traffics:
     list[~azure.mgmt.appplatform.v2023_07_01_preview.models.RequiredTraffic]
    :ivar ingress_config: Ingress configuration payload for Azure Spring Apps resource.
    :vartype ingress_config: ~azure.mgmt.appplatform.v2023_07_01_preview.models.IngressConfig
    :ivar outbound_type: The egress traffic type of Azure Spring Apps VNet instances.
    :vartype outbound_type: str
    """

    _validation = {
        "outbound_i_ps": {"readonly": True},
        "required_traffics": {"readonly": True},
    }

    _attribute_map = {
        "service_runtime_subnet_id": {"key": "serviceRuntimeSubnetId", "type": "str"},
        "app_subnet_id": {"key": "appSubnetId", "type": "str"},
        "service_cidr": {"key": "serviceCidr", "type": "str"},
        "service_runtime_network_resource_group": {"key": "serviceRuntimeNetworkResourceGroup", "type": "str"},
        "app_network_resource_group": {"key": "appNetworkResourceGroup", "type": "str"},
        "outbound_i_ps": {"key": "outboundIPs", "type": "NetworkProfileOutboundIPs"},
        "required_traffics": {"key": "requiredTraffics", "type": "[RequiredTraffic]"},
        "ingress_config": {"key": "ingressConfig", "type": "IngressConfig"},
        "outbound_type": {"key": "outboundType", "type": "str"},
    }

    def __init__(
        self,
        *,
        service_runtime_subnet_id: Optional[str] = None,
        app_subnet_id: Optional[str] = None,
        service_cidr: Optional[str] = None,
        service_runtime_network_resource_group: Optional[str] = None,
        app_network_resource_group: Optional[str] = None,
        ingress_config: Optional["_models.IngressConfig"] = None,
        outbound_type: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword service_runtime_subnet_id: Fully qualified resource Id of the subnet to host Azure
         Spring Apps Service Runtime.
        :paramtype service_runtime_subnet_id: str
        :keyword app_subnet_id: Fully qualified resource Id of the subnet to host customer apps in
         Azure Spring Apps.
        :paramtype app_subnet_id: str
        :keyword service_cidr: Azure Spring Apps service reserved CIDR.
        :paramtype service_cidr: str
        :keyword service_runtime_network_resource_group: Name of the resource group containing network
         resources of Azure Spring Apps Service Runtime.
        :paramtype service_runtime_network_resource_group: str
        :keyword app_network_resource_group: Name of the resource group containing network resources
         for customer apps in Azure Spring Apps.
        :paramtype app_network_resource_group: str
        :keyword ingress_config: Ingress configuration payload for Azure Spring Apps resource.
        :paramtype ingress_config: ~azure.mgmt.appplatform.v2023_07_01_preview.models.IngressConfig
        :keyword outbound_type: The egress traffic type of Azure Spring Apps VNet instances.
        :paramtype outbound_type: str
        """
        super().__init__(**kwargs)
        self.service_runtime_subnet_id = service_runtime_subnet_id
        self.app_subnet_id = app_subnet_id
        self.service_cidr = service_cidr
        self.service_runtime_network_resource_group = service_runtime_network_resource_group
        self.app_network_resource_group = app_network_resource_group
        self.outbound_i_ps = None
        self.required_traffics = None
        self.ingress_config = ingress_config
        self.outbound_type = outbound_type


class NetworkProfileOutboundIPs(_serialization.Model):
    """Desired outbound IP resources for Azure Spring Apps resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar public_i_ps: A list of public IP addresses.
    :vartype public_i_ps: list[str]
    """

    _validation = {
        "public_i_ps": {"readonly": True},
    }

    _attribute_map = {
        "public_i_ps": {"key": "publicIPs", "type": "[str]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.public_i_ps = None


class OperationDetail(_serialization.Model):
    """Operation detail payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the operation.
    :vartype name: str
    :ivar is_data_action: Indicates whether the operation is a data action.
    :vartype is_data_action: bool
    :ivar display: Display of the operation.
    :vartype display: ~azure.mgmt.appplatform.v2023_07_01_preview.models.OperationDisplay
    :ivar action_type: Enum. Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.appplatform.v2023_07_01_preview.models.ActionType
    :ivar origin: Origin of the operation.
    :vartype origin: str
    :ivar properties: Properties of the operation.
    :vartype properties: ~azure.mgmt.appplatform.v2023_07_01_preview.models.OperationProperties
    """

    _validation = {
        "action_type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "action_type": {"key": "actionType", "type": "str"},
        "origin": {"key": "origin", "type": "str"},
        "properties": {"key": "properties", "type": "OperationProperties"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        is_data_action: Optional[bool] = None,
        display: Optional["_models.OperationDisplay"] = None,
        origin: Optional[str] = None,
        properties: Optional["_models.OperationProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the operation.
        :paramtype name: str
        :keyword is_data_action: Indicates whether the operation is a data action.
        :paramtype is_data_action: bool
        :keyword display: Display of the operation.
        :paramtype display: ~azure.mgmt.appplatform.v2023_07_01_preview.models.OperationDisplay
        :keyword origin: Origin of the operation.
        :paramtype origin: str
        :keyword properties: Properties of the operation.
        :paramtype properties: ~azure.mgmt.appplatform.v2023_07_01_preview.models.OperationProperties
        """
        super().__init__(**kwargs)
        self.name = name
        self.is_data_action = is_data_action
        self.display = display
        self.action_type = None
        self.origin = origin
        self.properties = properties


class OperationDisplay(_serialization.Model):
    """Operation display payload.

    :ivar provider: Resource provider of the operation.
    :vartype provider: str
    :ivar resource: Resource of the operation.
    :vartype resource: str
    :ivar operation: Localized friendly name for the operation.
    :vartype operation: str
    :ivar description: Localized friendly description for the operation.
    :vartype description: str
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provider: Resource provider of the operation.
        :paramtype provider: str
        :keyword resource: Resource of the operation.
        :paramtype resource: str
        :keyword operation: Localized friendly name for the operation.
        :paramtype operation: str
        :keyword description: Localized friendly description for the operation.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationProperties(_serialization.Model):
    """Extra Operation properties.

    :ivar service_specification: Service specifications of the operation.
    :vartype service_specification:
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.ServiceSpecification
    """

    _attribute_map = {
        "service_specification": {"key": "serviceSpecification", "type": "ServiceSpecification"},
    }

    def __init__(
        self, *, service_specification: Optional["_models.ServiceSpecification"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword service_specification: Service specifications of the operation.
        :paramtype service_specification:
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.ServiceSpecification
        """
        super().__init__(**kwargs)
        self.service_specification = service_specification


class PersistentDisk(_serialization.Model):
    """Persistent disk payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar size_in_gb: Size of the persistent disk in GB.
    :vartype size_in_gb: int
    :ivar used_in_gb: Size of the used persistent disk in GB.
    :vartype used_in_gb: int
    :ivar mount_path: Mount path of the persistent disk.
    :vartype mount_path: str
    """

    _validation = {
        "size_in_gb": {"maximum": 50, "minimum": 0},
        "used_in_gb": {"readonly": True, "maximum": 50, "minimum": 0},
    }

    _attribute_map = {
        "size_in_gb": {"key": "sizeInGB", "type": "int"},
        "used_in_gb": {"key": "usedInGB", "type": "int"},
        "mount_path": {"key": "mountPath", "type": "str"},
    }

    def __init__(self, *, size_in_gb: Optional[int] = None, mount_path: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword size_in_gb: Size of the persistent disk in GB.
        :paramtype size_in_gb: int
        :keyword mount_path: Mount path of the persistent disk.
        :paramtype mount_path: str
        """
        super().__init__(**kwargs)
        self.size_in_gb = size_in_gb
        self.used_in_gb = None
        self.mount_path = mount_path


class PredefinedAcceleratorProperties(_serialization.Model):
    """Predefined accelerator properties payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: Provisioning state of the predefined accelerator. Known values are:
     "Creating", "Updating", "Succeeded", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.PredefinedAcceleratorProvisioningState
    :ivar display_name:
    :vartype display_name: str
    :ivar description:
    :vartype description: str
    :ivar icon_url:
    :vartype icon_url: str
    :ivar accelerator_tags:
    :vartype accelerator_tags: list[str]
    :ivar state: State of the predefined accelerator. Known values are: "Enabled" and "Disabled".
    :vartype state: str or
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.PredefinedAcceleratorState
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "icon_url": {"readonly": True},
        "accelerator_tags": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "icon_url": {"key": "iconUrl", "type": "str"},
        "accelerator_tags": {"key": "acceleratorTags", "type": "[str]"},
        "state": {"key": "state", "type": "str"},
    }

    def __init__(self, *, state: Union[str, "_models.PredefinedAcceleratorState"] = "Enabled", **kwargs: Any) -> None:
        """
        :keyword state: State of the predefined accelerator. Known values are: "Enabled" and
         "Disabled".
        :paramtype state: str or
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.PredefinedAcceleratorState
        """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.display_name = None
        self.description = None
        self.icon_url = None
        self.accelerator_tags = None
        self.state = state


class PredefinedAcceleratorResource(ProxyResource):
    """Predefined accelerator resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.appplatform.v2023_07_01_preview.models.SystemData
    :ivar properties: Predefined accelerator properties payload.
    :vartype properties:
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.PredefinedAcceleratorProperties
    :ivar sku: Sku of the predefined accelerator resource.
    :vartype sku: ~azure.mgmt.appplatform.v2023_07_01_preview.models.Sku
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "PredefinedAcceleratorProperties"},
        "sku": {"key": "sku", "type": "Sku"},
    }

    def __init__(
        self,
        *,
        properties: Optional["_models.PredefinedAcceleratorProperties"] = None,
        sku: Optional["_models.Sku"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword properties: Predefined accelerator properties payload.
        :paramtype properties:
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.PredefinedAcceleratorProperties
        :keyword sku: Sku of the predefined accelerator resource.
        :paramtype sku: ~azure.mgmt.appplatform.v2023_07_01_preview.models.Sku
        """
        super().__init__(**kwargs)
        self.properties = properties
        self.sku = sku


class PredefinedAcceleratorResourceCollection(_serialization.Model):
    """PredefinedAcceleratorResourceCollection.

    :ivar value:
    :vartype value:
     list[~azure.mgmt.appplatform.v2023_07_01_preview.models.PredefinedAcceleratorResource]
    :ivar next_link:
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PredefinedAcceleratorResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.PredefinedAcceleratorResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value:
        :paramtype value:
         list[~azure.mgmt.appplatform.v2023_07_01_preview.models.PredefinedAcceleratorResource]
        :keyword next_link:
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class Probe(_serialization.Model):
    """Probe describes a health check to be performed against an App Instance to determine whether it
    is alive or ready to receive traffic.

    All required parameters must be populated in order to send to Azure.

    :ivar probe_action: The action of the probe.
    :vartype probe_action: ~azure.mgmt.appplatform.v2023_07_01_preview.models.ProbeAction
    :ivar disable_probe: Indicate whether the probe is disabled. Required.
    :vartype disable_probe: bool
    :ivar initial_delay_seconds: Number of seconds after the App Instance has started before probes
     are initiated. More info:
     https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes.
    :vartype initial_delay_seconds: int
    :ivar period_seconds: How often (in seconds) to perform the probe. Minimum value is 1.
    :vartype period_seconds: int
    :ivar timeout_seconds: Number of seconds after which the probe times out. Minimum value is 1.
    :vartype timeout_seconds: int
    :ivar failure_threshold: Minimum consecutive failures for the probe to be considered failed
     after having succeeded. Minimum value is 1.
    :vartype failure_threshold: int
    :ivar success_threshold: Minimum consecutive successes for the probe to be considered
     successful after having failed. Must be 1 for liveness and startup. Minimum value is 1.
    :vartype success_threshold: int
    """

    _validation = {
        "disable_probe": {"required": True},
    }

    _attribute_map = {
        "probe_action": {"key": "probeAction", "type": "ProbeAction"},
        "disable_probe": {"key": "disableProbe", "type": "bool"},
        "initial_delay_seconds": {"key": "initialDelaySeconds", "type": "int"},
        "period_seconds": {"key": "periodSeconds", "type": "int"},
        "timeout_seconds": {"key": "timeoutSeconds", "type": "int"},
        "failure_threshold": {"key": "failureThreshold", "type": "int"},
        "success_threshold": {"key": "successThreshold", "type": "int"},
    }

    def __init__(
        self,
        *,
        disable_probe: bool = False,
        probe_action: Optional["_models.ProbeAction"] = None,
        initial_delay_seconds: Optional[int] = None,
        period_seconds: Optional[int] = None,
        timeout_seconds: Optional[int] = None,
        failure_threshold: Optional[int] = None,
        success_threshold: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword probe_action: The action of the probe.
        :paramtype probe_action: ~azure.mgmt.appplatform.v2023_07_01_preview.models.ProbeAction
        :keyword disable_probe: Indicate whether the probe is disabled. Required.
        :paramtype disable_probe: bool
        :keyword initial_delay_seconds: Number of seconds after the App Instance has started before
         probes are initiated. More info:
         https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes.
        :paramtype initial_delay_seconds: int
        :keyword period_seconds: How often (in seconds) to perform the probe. Minimum value is 1.
        :paramtype period_seconds: int
        :keyword timeout_seconds: Number of seconds after which the probe times out. Minimum value is
         1.
        :paramtype timeout_seconds: int
        :keyword failure_threshold: Minimum consecutive failures for the probe to be considered failed
         after having succeeded. Minimum value is 1.
        :paramtype failure_threshold: int
        :keyword success_threshold: Minimum consecutive successes for the probe to be considered
         successful after having failed. Must be 1 for liveness and startup. Minimum value is 1.
        :paramtype success_threshold: int
        """
        super().__init__(**kwargs)
        self.probe_action = probe_action
        self.disable_probe = disable_probe
        self.initial_delay_seconds = initial_delay_seconds
        self.period_seconds = period_seconds
        self.timeout_seconds = timeout_seconds
        self.failure_threshold = failure_threshold
        self.success_threshold = success_threshold


class QueueScaleRule(_serialization.Model):
    """Azure Spring Apps App Instance Azure Queue based scaling rule.

    :ivar queue_name: Queue name.
    :vartype queue_name: str
    :ivar queue_length: Queue length.
    :vartype queue_length: int
    :ivar auth: Authentication secrets for the queue scale rule.
    :vartype auth: list[~azure.mgmt.appplatform.v2023_07_01_preview.models.ScaleRuleAuth]
    """

    _attribute_map = {
        "queue_name": {"key": "queueName", "type": "str"},
        "queue_length": {"key": "queueLength", "type": "int"},
        "auth": {"key": "auth", "type": "[ScaleRuleAuth]"},
    }

    def __init__(
        self,
        *,
        queue_name: Optional[str] = None,
        queue_length: Optional[int] = None,
        auth: Optional[List["_models.ScaleRuleAuth"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword queue_name: Queue name.
        :paramtype queue_name: str
        :keyword queue_length: Queue length.
        :paramtype queue_length: int
        :keyword auth: Authentication secrets for the queue scale rule.
        :paramtype auth: list[~azure.mgmt.appplatform.v2023_07_01_preview.models.ScaleRuleAuth]
        """
        super().__init__(**kwargs)
        self.queue_name = queue_name
        self.queue_length = queue_length
        self.auth = auth


class RegenerateTestKeyRequestPayload(_serialization.Model):
    """Regenerate test key request payload.

    All required parameters must be populated in order to send to Azure.

    :ivar key_type: Type of the test key. Required. Known values are: "Primary" and "Secondary".
    :vartype key_type: str or ~azure.mgmt.appplatform.v2023_07_01_preview.models.TestKeyType
    """

    _validation = {
        "key_type": {"required": True},
    }

    _attribute_map = {
        "key_type": {"key": "keyType", "type": "str"},
    }

    def __init__(self, *, key_type: Union[str, "_models.TestKeyType"], **kwargs: Any) -> None:
        """
        :keyword key_type: Type of the test key. Required. Known values are: "Primary" and "Secondary".
        :paramtype key_type: str or ~azure.mgmt.appplatform.v2023_07_01_preview.models.TestKeyType
        """
        super().__init__(**kwargs)
        self.key_type = key_type


class RemoteDebugging(_serialization.Model):
    """Remote debugging config.

    :ivar port: Application debugging port.
    :vartype port: int
    :ivar enabled: Indicate if remote debugging is enabled.
    :vartype enabled: bool
    """

    _attribute_map = {
        "port": {"key": "port", "type": "int"},
        "enabled": {"key": "enabled", "type": "bool"},
    }

    def __init__(self, *, port: Optional[int] = None, enabled: Optional[bool] = None, **kwargs: Any) -> None:
        """
        :keyword port: Application debugging port.
        :paramtype port: int
        :keyword enabled: Indicate if remote debugging is enabled.
        :paramtype enabled: bool
        """
        super().__init__(**kwargs)
        self.port = port
        self.enabled = enabled


class RemoteDebuggingPayload(_serialization.Model):
    """Remote debugging payload.

    :ivar port: Application debugging port.
    :vartype port: int
    """

    _attribute_map = {
        "port": {"key": "port", "type": "int"},
    }

    def __init__(self, *, port: Optional[int] = None, **kwargs: Any) -> None:
        """
        :keyword port: Application debugging port.
        :paramtype port: int
        """
        super().__init__(**kwargs)
        self.port = port


class RequiredTraffic(_serialization.Model):
    """Required inbound or outbound traffic for Azure Spring Apps resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar protocol: The protocol of required traffic.
    :vartype protocol: str
    :ivar port: The port of required traffic.
    :vartype port: int
    :ivar ips: The ip list of required traffic.
    :vartype ips: list[str]
    :ivar fqdns: The FQDN list of required traffic.
    :vartype fqdns: list[str]
    :ivar direction: The direction of required traffic. Known values are: "Inbound" and "Outbound".
    :vartype direction: str or ~azure.mgmt.appplatform.v2023_07_01_preview.models.TrafficDirection
    """

    _validation = {
        "protocol": {"readonly": True},
        "port": {"readonly": True},
        "ips": {"readonly": True},
        "fqdns": {"readonly": True},
        "direction": {"readonly": True},
    }

    _attribute_map = {
        "protocol": {"key": "protocol", "type": "str"},
        "port": {"key": "port", "type": "int"},
        "ips": {"key": "ips", "type": "[str]"},
        "fqdns": {"key": "fqdns", "type": "[str]"},
        "direction": {"key": "direction", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.protocol = None
        self.port = None
        self.ips = None
        self.fqdns = None
        self.direction = None


class ResourceRequests(_serialization.Model):
    """Deployment resource request payload.

    :ivar cpu: Required CPU. 1 core can be represented by 1 or 1000m. This should be 500m or 1 for
     Basic tier, and {500m, 1, 2, 3, 4} for Standard tier.
    :vartype cpu: str
    :ivar memory: Required memory. 1 GB can be represented by 1Gi or 1024Mi. This should be {512Mi,
     1Gi, 2Gi} for Basic tier, and {512Mi, 1Gi, 2Gi, ..., 8Gi} for Standard tier.
    :vartype memory: str
    """

    _attribute_map = {
        "cpu": {"key": "cpu", "type": "str"},
        "memory": {"key": "memory", "type": "str"},
    }

    def __init__(self, *, cpu: Optional[str] = None, memory: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword cpu: Required CPU. 1 core can be represented by 1 or 1000m. This should be 500m or 1
         for Basic tier, and {500m, 1, 2, 3, 4} for Standard tier.
        :paramtype cpu: str
        :keyword memory: Required memory. 1 GB can be represented by 1Gi or 1024Mi. This should be
         {512Mi, 1Gi, 2Gi} for Basic tier, and {512Mi, 1Gi, 2Gi, ..., 8Gi} for Standard tier.
        :paramtype memory: str
        """
        super().__init__(**kwargs)
        self.cpu = cpu
        self.memory = memory


class ResourceSku(_serialization.Model):
    """Describes an available Azure Spring Apps SKU.

    :ivar resource_type: Gets the type of resource the SKU applies to.
    :vartype resource_type: str
    :ivar name: Gets the name of SKU.
    :vartype name: str
    :ivar tier: Gets the tier of SKU.
    :vartype tier: str
    :ivar capacity: Gets the capacity of SKU.
    :vartype capacity: ~azure.mgmt.appplatform.v2023_07_01_preview.models.SkuCapacity
    :ivar locations: Gets the set of locations that the SKU is available.
    :vartype locations: list[str]
    :ivar location_info: Gets a list of locations and availability zones in those locations where
     the SKU is available.
    :vartype location_info:
     list[~azure.mgmt.appplatform.v2023_07_01_preview.models.ResourceSkuLocationInfo]
    :ivar restrictions: Gets the restrictions because of which SKU cannot be used. This is
     empty if there are no restrictions.
    :vartype restrictions:
     list[~azure.mgmt.appplatform.v2023_07_01_preview.models.ResourceSkuRestrictions]
    """

    _attribute_map = {
        "resource_type": {"key": "resourceType", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
        "capacity": {"key": "capacity", "type": "SkuCapacity"},
        "locations": {"key": "locations", "type": "[str]"},
        "location_info": {"key": "locationInfo", "type": "[ResourceSkuLocationInfo]"},
        "restrictions": {"key": "restrictions", "type": "[ResourceSkuRestrictions]"},
    }

    def __init__(
        self,
        *,
        resource_type: Optional[str] = None,
        name: Optional[str] = None,
        tier: Optional[str] = None,
        capacity: Optional["_models.SkuCapacity"] = None,
        locations: Optional[List[str]] = None,
        location_info: Optional[List["_models.ResourceSkuLocationInfo"]] = None,
        restrictions: Optional[List["_models.ResourceSkuRestrictions"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword resource_type: Gets the type of resource the SKU applies to.
        :paramtype resource_type: str
        :keyword name: Gets the name of SKU.
        :paramtype name: str
        :keyword tier: Gets the tier of SKU.
        :paramtype tier: str
        :keyword capacity: Gets the capacity of SKU.
        :paramtype capacity: ~azure.mgmt.appplatform.v2023_07_01_preview.models.SkuCapacity
        :keyword locations: Gets the set of locations that the SKU is available.
        :paramtype locations: list[str]
        :keyword location_info: Gets a list of locations and availability zones in those locations
         where the SKU is available.
        :paramtype location_info:
         list[~azure.mgmt.appplatform.v2023_07_01_preview.models.ResourceSkuLocationInfo]
        :keyword restrictions: Gets the restrictions because of which SKU cannot be used. This is
         empty if there are no restrictions.
        :paramtype restrictions:
         list[~azure.mgmt.appplatform.v2023_07_01_preview.models.ResourceSkuRestrictions]
        """
        super().__init__(**kwargs)
        self.resource_type = resource_type
        self.name = name
        self.tier = tier
        self.capacity = capacity
        self.locations = locations
        self.location_info = location_info
        self.restrictions = restrictions


class ResourceSkuCapabilities(_serialization.Model):
    """ResourceSkuCapabilities.

    :ivar name: Gets an invariant to describe the feature.
    :vartype name: str
    :ivar value: Gets an invariant if the feature is measured by quantity.
    :vartype value: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: Gets an invariant to describe the feature.
        :paramtype name: str
        :keyword value: Gets an invariant if the feature is measured by quantity.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value


class ResourceSkuCollection(_serialization.Model):
    """Object that includes an array of Azure Spring Apps SKU and a possible link for next set.

    :ivar value: Collection of resource SKU.
    :vartype value: list[~azure.mgmt.appplatform.v2023_07_01_preview.models.ResourceSku]
    :ivar next_link: URL client should use to fetch the next page (per server side paging).
     It's null for now, added for future use.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ResourceSku]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.ResourceSku"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Collection of resource SKU.
        :paramtype value: list[~azure.mgmt.appplatform.v2023_07_01_preview.models.ResourceSku]
        :keyword next_link: URL client should use to fetch the next page (per server side paging).
         It's null for now, added for future use.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ResourceSkuLocationInfo(_serialization.Model):
    """Locations and availability zones where the SKU is available.

    :ivar location: Gets location of the SKU.
    :vartype location: str
    :ivar zones: Gets list of availability zones where the SKU is supported.
    :vartype zones: list[str]
    :ivar zone_details: Gets details of capabilities available to a SKU in specific zones.
    :vartype zone_details:
     list[~azure.mgmt.appplatform.v2023_07_01_preview.models.ResourceSkuZoneDetails]
    """

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "zones": {"key": "zones", "type": "[str]"},
        "zone_details": {"key": "zoneDetails", "type": "[ResourceSkuZoneDetails]"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        zones: Optional[List[str]] = None,
        zone_details: Optional[List["_models.ResourceSkuZoneDetails"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Gets location of the SKU.
        :paramtype location: str
        :keyword zones: Gets list of availability zones where the SKU is supported.
        :paramtype zones: list[str]
        :keyword zone_details: Gets details of capabilities available to a SKU in specific zones.
        :paramtype zone_details:
         list[~azure.mgmt.appplatform.v2023_07_01_preview.models.ResourceSkuZoneDetails]
        """
        super().__init__(**kwargs)
        self.location = location
        self.zones = zones
        self.zone_details = zone_details


class ResourceSkuRestrictionInfo(_serialization.Model):
    """Information about the restriction where the SKU cannot be used.

    :ivar locations: Gets locations where the SKU is restricted.
    :vartype locations: list[str]
    :ivar zones: Gets list of availability zones where the SKU is restricted.
    :vartype zones: list[str]
    """

    _attribute_map = {
        "locations": {"key": "locations", "type": "[str]"},
        "zones": {"key": "zones", "type": "[str]"},
    }

    def __init__(
        self, *, locations: Optional[List[str]] = None, zones: Optional[List[str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword locations: Gets locations where the SKU is restricted.
        :paramtype locations: list[str]
        :keyword zones: Gets list of availability zones where the SKU is restricted.
        :paramtype zones: list[str]
        """
        super().__init__(**kwargs)
        self.locations = locations
        self.zones = zones


class ResourceSkuRestrictions(_serialization.Model):
    """Restrictions where the SKU cannot be used.

    :ivar type: Gets the type of restrictions. Possible values include: 'Location', 'Zone'. Known
     values are: "Location" and "Zone".
    :vartype type: str or
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.ResourceSkuRestrictionsType
    :ivar values: Gets the value of restrictions. If the restriction type is set to
     location. This would be different locations where the SKU is restricted.
    :vartype values: list[str]
    :ivar restriction_info: Gets the information about the restriction where the SKU cannot be
     used.
    :vartype restriction_info:
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.ResourceSkuRestrictionInfo
    :ivar reason_code: Gets the reason for restriction. Possible values include: 'QuotaId',
     'NotAvailableForSubscription'. Known values are: "QuotaId" and "NotAvailableForSubscription".
    :vartype reason_code: str or
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.ResourceSkuRestrictionsReasonCode
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "values": {"key": "values", "type": "[str]"},
        "restriction_info": {"key": "restrictionInfo", "type": "ResourceSkuRestrictionInfo"},
        "reason_code": {"key": "reasonCode", "type": "str"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.ResourceSkuRestrictionsType"]] = None,
        values: Optional[List[str]] = None,
        restriction_info: Optional["_models.ResourceSkuRestrictionInfo"] = None,
        reason_code: Optional[Union[str, "_models.ResourceSkuRestrictionsReasonCode"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Gets the type of restrictions. Possible values include: 'Location', 'Zone'.
         Known values are: "Location" and "Zone".
        :paramtype type: str or
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.ResourceSkuRestrictionsType
        :keyword values: Gets the value of restrictions. If the restriction type is set to
         location. This would be different locations where the SKU is restricted.
        :paramtype values: list[str]
        :keyword restriction_info: Gets the information about the restriction where the SKU cannot be
         used.
        :paramtype restriction_info:
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.ResourceSkuRestrictionInfo
        :keyword reason_code: Gets the reason for restriction. Possible values include: 'QuotaId',
         'NotAvailableForSubscription'. Known values are: "QuotaId" and "NotAvailableForSubscription".
        :paramtype reason_code: str or
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.ResourceSkuRestrictionsReasonCode
        """
        super().__init__(**kwargs)
        self.type = type
        self.values = values
        self.restriction_info = restriction_info
        self.reason_code = reason_code


class ResourceSkuZoneDetails(_serialization.Model):
    """Details of capabilities available to a SKU in specific zones.

    :ivar name: Gets the set of zones that the SKU is available in with the
     specified capabilities.
    :vartype name: list[str]
    :ivar capabilities: Gets a list of capabilities that are available for the SKU in the
     specified list of zones.
    :vartype capabilities:
     list[~azure.mgmt.appplatform.v2023_07_01_preview.models.ResourceSkuCapabilities]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "[str]"},
        "capabilities": {"key": "capabilities", "type": "[ResourceSkuCapabilities]"},
    }

    def __init__(
        self,
        *,
        name: Optional[List[str]] = None,
        capabilities: Optional[List["_models.ResourceSkuCapabilities"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Gets the set of zones that the SKU is available in with the
         specified capabilities.
        :paramtype name: list[str]
        :keyword capabilities: Gets a list of capabilities that are available for the SKU in the
         specified list of zones.
        :paramtype capabilities:
         list[~azure.mgmt.appplatform.v2023_07_01_preview.models.ResourceSkuCapabilities]
        """
        super().__init__(**kwargs)
        self.name = name
        self.capabilities = capabilities


class ResourceUploadDefinition(_serialization.Model):
    """Resource upload definition payload.

    :ivar relative_path: Source relative path.
    :vartype relative_path: str
    :ivar upload_url: Upload URL.
    :vartype upload_url: str
    """

    _attribute_map = {
        "relative_path": {"key": "relativePath", "type": "str"},
        "upload_url": {"key": "uploadUrl", "type": "str"},
    }

    def __init__(self, *, relative_path: Optional[str] = None, upload_url: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword relative_path: Source relative path.
        :paramtype relative_path: str
        :keyword upload_url: Upload URL.
        :paramtype upload_url: str
        """
        super().__init__(**kwargs)
        self.relative_path = relative_path
        self.upload_url = upload_url


class Scale(_serialization.Model):
    """Azure Spring Apps scaling configurations.

    :ivar min_replicas: Optional. Minimum number of container replicas.
    :vartype min_replicas: int
    :ivar max_replicas: Optional. Maximum number of container replicas. Defaults to 10 if not set.
    :vartype max_replicas: int
    :ivar rules: Scaling rules.
    :vartype rules: list[~azure.mgmt.appplatform.v2023_07_01_preview.models.ScaleRule]
    """

    _attribute_map = {
        "min_replicas": {"key": "minReplicas", "type": "int"},
        "max_replicas": {"key": "maxReplicas", "type": "int"},
        "rules": {"key": "rules", "type": "[ScaleRule]"},
    }

    def __init__(
        self,
        *,
        min_replicas: Optional[int] = None,
        max_replicas: int = 10,
        rules: Optional[List["_models.ScaleRule"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword min_replicas: Optional. Minimum number of container replicas.
        :paramtype min_replicas: int
        :keyword max_replicas: Optional. Maximum number of container replicas. Defaults to 10 if not
         set.
        :paramtype max_replicas: int
        :keyword rules: Scaling rules.
        :paramtype rules: list[~azure.mgmt.appplatform.v2023_07_01_preview.models.ScaleRule]
        """
        super().__init__(**kwargs)
        self.min_replicas = min_replicas
        self.max_replicas = max_replicas
        self.rules = rules


class ScaleRule(_serialization.Model):
    """Azure Spring Apps App Instance scaling rule.

    :ivar name: Scale Rule Name.
    :vartype name: str
    :ivar azure_queue: Azure Queue based scaling.
    :vartype azure_queue: ~azure.mgmt.appplatform.v2023_07_01_preview.models.QueueScaleRule
    :ivar custom: Custom scale rule.
    :vartype custom: ~azure.mgmt.appplatform.v2023_07_01_preview.models.CustomScaleRule
    :ivar http: HTTP requests based scaling.
    :vartype http: ~azure.mgmt.appplatform.v2023_07_01_preview.models.HttpScaleRule
    :ivar tcp: Tcp requests based scaling.
    :vartype tcp: ~azure.mgmt.appplatform.v2023_07_01_preview.models.TcpScaleRule
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "azure_queue": {"key": "azureQueue", "type": "QueueScaleRule"},
        "custom": {"key": "custom", "type": "CustomScaleRule"},
        "http": {"key": "http", "type": "HttpScaleRule"},
        "tcp": {"key": "tcp", "type": "TcpScaleRule"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        azure_queue: Optional["_models.QueueScaleRule"] = None,
        custom: Optional["_models.CustomScaleRule"] = None,
        http: Optional["_models.HttpScaleRule"] = None,
        tcp: Optional["_models.TcpScaleRule"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Scale Rule Name.
        :paramtype name: str
        :keyword azure_queue: Azure Queue based scaling.
        :paramtype azure_queue: ~azure.mgmt.appplatform.v2023_07_01_preview.models.QueueScaleRule
        :keyword custom: Custom scale rule.
        :paramtype custom: ~azure.mgmt.appplatform.v2023_07_01_preview.models.CustomScaleRule
        :keyword http: HTTP requests based scaling.
        :paramtype http: ~azure.mgmt.appplatform.v2023_07_01_preview.models.HttpScaleRule
        :keyword tcp: Tcp requests based scaling.
        :paramtype tcp: ~azure.mgmt.appplatform.v2023_07_01_preview.models.TcpScaleRule
        """
        super().__init__(**kwargs)
        self.name = name
        self.azure_queue = azure_queue
        self.custom = custom
        self.http = http
        self.tcp = tcp


class ScaleRuleAuth(_serialization.Model):
    """Auth Secrets for Azure Spring Apps App Instance Scale Rule.

    :ivar secret_ref: Name of the Azure Spring Apps App Instance secret from which to pull the auth
     params.
    :vartype secret_ref: str
    :ivar trigger_parameter: Trigger Parameter that uses the secret.
    :vartype trigger_parameter: str
    """

    _attribute_map = {
        "secret_ref": {"key": "secretRef", "type": "str"},
        "trigger_parameter": {"key": "triggerParameter", "type": "str"},
    }

    def __init__(
        self, *, secret_ref: Optional[str] = None, trigger_parameter: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword secret_ref: Name of the Azure Spring Apps App Instance secret from which to pull the
         auth params.
        :paramtype secret_ref: str
        :keyword trigger_parameter: Trigger Parameter that uses the secret.
        :paramtype trigger_parameter: str
        """
        super().__init__(**kwargs)
        self.secret_ref = secret_ref
        self.trigger_parameter = trigger_parameter


class Secret(_serialization.Model):
    """Secret definition.

    :ivar name: Secret Name.
    :vartype name: str
    :ivar value: Secret Value.
    :vartype value: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: Secret Name.
        :paramtype name: str
        :keyword value: Secret Value.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value


class ServiceRegistryInstance(_serialization.Model):
    """Collection of instances belong to the Service Registry.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the Service Registry instance.
    :vartype name: str
    :ivar status: Status of the Service Registry instance.
    :vartype status: str
    """

    _validation = {
        "name": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.status = None


class ServiceRegistryProperties(_serialization.Model):
    """Service Registry properties payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: State of the Service Registry. Known values are: "Creating",
     "Updating", "Succeeded", "Failed", and "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.ServiceRegistryProvisioningState
    :ivar resource_requests: The requested resource quantity for required CPU and Memory.
    :vartype resource_requests:
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.ServiceRegistryResourceRequests
    :ivar instances: Collection of instances belong to Service Registry.
    :vartype instances:
     list[~azure.mgmt.appplatform.v2023_07_01_preview.models.ServiceRegistryInstance]
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "resource_requests": {"readonly": True},
        "instances": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "resource_requests": {"key": "resourceRequests", "type": "ServiceRegistryResourceRequests"},
        "instances": {"key": "instances", "type": "[ServiceRegistryInstance]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.resource_requests = None
        self.instances = None


class ServiceRegistryResource(ProxyResource):
    """Service Registry resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.appplatform.v2023_07_01_preview.models.SystemData
    :ivar properties: Service Registry properties payload.
    :vartype properties:
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.ServiceRegistryProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "ServiceRegistryProperties"},
    }

    def __init__(self, *, properties: Optional["_models.ServiceRegistryProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: Service Registry properties payload.
        :paramtype properties:
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.ServiceRegistryProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class ServiceRegistryResourceCollection(_serialization.Model):
    """Object that includes an array of Service Registry resources and a possible link for next set.

    :ivar value: Collection of Service Registry resources.
    :vartype value:
     list[~azure.mgmt.appplatform.v2023_07_01_preview.models.ServiceRegistryResource]
    :ivar next_link: URL client should use to fetch the next page (per server side paging).
     It's null for now, added for future use.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ServiceRegistryResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ServiceRegistryResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Collection of Service Registry resources.
        :paramtype value:
         list[~azure.mgmt.appplatform.v2023_07_01_preview.models.ServiceRegistryResource]
        :keyword next_link: URL client should use to fetch the next page (per server side paging).
         It's null for now, added for future use.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ServiceRegistryResourceRequests(_serialization.Model):
    """Resource request payload of Service Registry.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar cpu: Cpu allocated to each Service Registry instance.
    :vartype cpu: str
    :ivar memory: Memory allocated to each Service Registry instance.
    :vartype memory: str
    :ivar instance_count: Instance count of the Service Registry.
    :vartype instance_count: int
    """

    _validation = {
        "cpu": {"readonly": True},
        "memory": {"readonly": True},
        "instance_count": {"readonly": True},
    }

    _attribute_map = {
        "cpu": {"key": "cpu", "type": "str"},
        "memory": {"key": "memory", "type": "str"},
        "instance_count": {"key": "instanceCount", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.cpu = None
        self.memory = None
        self.instance_count = None


class TrackedResource(Resource):
    """The resource model definition for a ARM tracked top level resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.appplatform.v2023_07_01_preview.models.SystemData
    :ivar location: The GEO location of the resource.
    :vartype location: str
    :ivar tags: Tags of the service which is a list of key value pairs that describe the resource.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, location: Optional[str] = None, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword location: The GEO location of the resource.
        :paramtype location: str
        :keyword tags: Tags of the service which is a list of key value pairs that describe the
         resource.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.location = location
        self.tags = tags


class ServiceResource(TrackedResource):
    """Service resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.appplatform.v2023_07_01_preview.models.SystemData
    :ivar location: The GEO location of the resource.
    :vartype location: str
    :ivar tags: Tags of the service which is a list of key value pairs that describe the resource.
    :vartype tags: dict[str, str]
    :ivar properties: Properties of the Service resource.
    :vartype properties:
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.ClusterResourceProperties
    :ivar sku: Sku of the Service resource.
    :vartype sku: ~azure.mgmt.appplatform.v2023_07_01_preview.models.Sku
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "properties": {"key": "properties", "type": "ClusterResourceProperties"},
        "sku": {"key": "sku", "type": "Sku"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.ClusterResourceProperties"] = None,
        sku: Optional["_models.Sku"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The GEO location of the resource.
        :paramtype location: str
        :keyword tags: Tags of the service which is a list of key value pairs that describe the
         resource.
        :paramtype tags: dict[str, str]
        :keyword properties: Properties of the Service resource.
        :paramtype properties:
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.ClusterResourceProperties
        :keyword sku: Sku of the Service resource.
        :paramtype sku: ~azure.mgmt.appplatform.v2023_07_01_preview.models.Sku
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.properties = properties
        self.sku = sku


class ServiceResourceList(_serialization.Model):
    """Object that includes an array of Service resources and a possible link for next set.

    :ivar value: Collection of Service resources.
    :vartype value: list[~azure.mgmt.appplatform.v2023_07_01_preview.models.ServiceResource]
    :ivar next_link: URL client should use to fetch the next page (per server side paging).
     It's null for now, added for future use.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ServiceResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.ServiceResource"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Collection of Service resources.
        :paramtype value: list[~azure.mgmt.appplatform.v2023_07_01_preview.models.ServiceResource]
        :keyword next_link: URL client should use to fetch the next page (per server side paging).
         It's null for now, added for future use.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ServiceSpecification(_serialization.Model):
    """Service specification payload.

    :ivar log_specifications: Specifications of the Log for Azure Monitoring.
    :vartype log_specifications:
     list[~azure.mgmt.appplatform.v2023_07_01_preview.models.LogSpecification]
    :ivar metric_specifications: Specifications of the Metrics for Azure Monitoring.
    :vartype metric_specifications:
     list[~azure.mgmt.appplatform.v2023_07_01_preview.models.MetricSpecification]
    """

    _attribute_map = {
        "log_specifications": {"key": "logSpecifications", "type": "[LogSpecification]"},
        "metric_specifications": {"key": "metricSpecifications", "type": "[MetricSpecification]"},
    }

    def __init__(
        self,
        *,
        log_specifications: Optional[List["_models.LogSpecification"]] = None,
        metric_specifications: Optional[List["_models.MetricSpecification"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword log_specifications: Specifications of the Log for Azure Monitoring.
        :paramtype log_specifications:
         list[~azure.mgmt.appplatform.v2023_07_01_preview.models.LogSpecification]
        :keyword metric_specifications: Specifications of the Metrics for Azure Monitoring.
        :paramtype metric_specifications:
         list[~azure.mgmt.appplatform.v2023_07_01_preview.models.MetricSpecification]
        """
        super().__init__(**kwargs)
        self.log_specifications = log_specifications
        self.metric_specifications = metric_specifications


class ServiceVNetAddons(_serialization.Model):
    """Additional Service settings in vnet injection instance.

    :ivar log_stream_public_endpoint: Indicates whether the log stream in vnet injection instance
     could be accessed from internet.
    :vartype log_stream_public_endpoint: bool
    :ivar data_plane_public_endpoint: Indicates whether the data plane components(log stream, app
     connect, remote debugging) in vnet injection instance could be accessed from internet.
    :vartype data_plane_public_endpoint: bool
    """

    _attribute_map = {
        "log_stream_public_endpoint": {"key": "logStreamPublicEndpoint", "type": "bool"},
        "data_plane_public_endpoint": {"key": "dataPlanePublicEndpoint", "type": "bool"},
    }

    def __init__(
        self, *, log_stream_public_endpoint: bool = False, data_plane_public_endpoint: bool = False, **kwargs: Any
    ) -> None:
        """
        :keyword log_stream_public_endpoint: Indicates whether the log stream in vnet injection
         instance could be accessed from internet.
        :paramtype log_stream_public_endpoint: bool
        :keyword data_plane_public_endpoint: Indicates whether the data plane components(log stream,
         app connect, remote debugging) in vnet injection instance could be accessed from internet.
        :paramtype data_plane_public_endpoint: bool
        """
        super().__init__(**kwargs)
        self.log_stream_public_endpoint = log_stream_public_endpoint
        self.data_plane_public_endpoint = data_plane_public_endpoint


class Sku(_serialization.Model):
    """Sku of Azure Spring Apps.

    :ivar name: Name of the Sku.
    :vartype name: str
    :ivar tier: Tier of the Sku.
    :vartype tier: str
    :ivar capacity: Current capacity of the target resource.
    :vartype capacity: int
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
        "capacity": {"key": "capacity", "type": "int"},
    }

    def __init__(
        self, *, name: str = "S0", tier: str = "Standard", capacity: Optional[int] = None, **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the Sku.
        :paramtype name: str
        :keyword tier: Tier of the Sku.
        :paramtype tier: str
        :keyword capacity: Current capacity of the target resource.
        :paramtype capacity: int
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.capacity = capacity


class SkuCapacity(_serialization.Model):
    """The SKU capacity.

    All required parameters must be populated in order to send to Azure.

    :ivar minimum: Gets or sets the minimum. Required.
    :vartype minimum: int
    :ivar maximum: Gets or sets the maximum.
    :vartype maximum: int
    :ivar default: Gets or sets the default.
    :vartype default: int
    :ivar scale_type: Gets or sets the type of the scale. Known values are: "None", "Manual", and
     "Automatic".
    :vartype scale_type: str or ~azure.mgmt.appplatform.v2023_07_01_preview.models.SkuScaleType
    """

    _validation = {
        "minimum": {"required": True},
    }

    _attribute_map = {
        "minimum": {"key": "minimum", "type": "int"},
        "maximum": {"key": "maximum", "type": "int"},
        "default": {"key": "default", "type": "int"},
        "scale_type": {"key": "scaleType", "type": "str"},
    }

    def __init__(
        self,
        *,
        minimum: int,
        maximum: Optional[int] = None,
        default: Optional[int] = None,
        scale_type: Optional[Union[str, "_models.SkuScaleType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword minimum: Gets or sets the minimum. Required.
        :paramtype minimum: int
        :keyword maximum: Gets or sets the maximum.
        :paramtype maximum: int
        :keyword default: Gets or sets the default.
        :paramtype default: int
        :keyword scale_type: Gets or sets the type of the scale. Known values are: "None", "Manual",
         and "Automatic".
        :paramtype scale_type: str or ~azure.mgmt.appplatform.v2023_07_01_preview.models.SkuScaleType
        """
        super().__init__(**kwargs)
        self.minimum = minimum
        self.maximum = maximum
        self.default = default
        self.scale_type = scale_type


class SkuObject(_serialization.Model):
    """Resource Sku object used for scaling out and scaling in.

    :ivar sku: Sku of the Spring Cloud Gateway resource.
    :vartype sku: ~azure.mgmt.appplatform.v2023_07_01_preview.models.Sku
    """

    _attribute_map = {
        "sku": {"key": "sku", "type": "Sku"},
    }

    def __init__(self, *, sku: Optional["_models.Sku"] = None, **kwargs: Any) -> None:
        """
        :keyword sku: Sku of the Spring Cloud Gateway resource.
        :paramtype sku: ~azure.mgmt.appplatform.v2023_07_01_preview.models.Sku
        """
        super().__init__(**kwargs)
        self.sku = sku


class SourceUploadedUserSourceInfo(UploadedUserSourceInfo):
    """Uploaded Java source code binary for a deployment.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Type of the source uploaded. Required.
    :vartype type: str
    :ivar version: Version of the source.
    :vartype version: str
    :ivar relative_path: Relative path of the storage which stores the source.
    :vartype relative_path: str
    :ivar artifact_selector: Selector for the artifact to be used for the deployment for
     multi-module projects. This should be
     the relative path to the target module/project.
    :vartype artifact_selector: str
    :ivar runtime_version: Runtime version of the source file.
    :vartype runtime_version: str
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "version": {"key": "version", "type": "str"},
        "relative_path": {"key": "relativePath", "type": "str"},
        "artifact_selector": {"key": "artifactSelector", "type": "str"},
        "runtime_version": {"key": "runtimeVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        version: Optional[str] = None,
        relative_path: Optional[str] = None,
        artifact_selector: Optional[str] = None,
        runtime_version: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword version: Version of the source.
        :paramtype version: str
        :keyword relative_path: Relative path of the storage which stores the source.
        :paramtype relative_path: str
        :keyword artifact_selector: Selector for the artifact to be used for the deployment for
         multi-module projects. This should be
         the relative path to the target module/project.
        :paramtype artifact_selector: str
        :keyword runtime_version: Runtime version of the source file.
        :paramtype runtime_version: str
        """
        super().__init__(version=version, relative_path=relative_path, **kwargs)
        self.type: str = "Source"
        self.artifact_selector = artifact_selector
        self.runtime_version = runtime_version


class SsoProperties(_serialization.Model):
    """Single sign-on related configuration.

    :ivar scope: It defines the specific actions applications can be allowed to do on a user's
     behalf.
    :vartype scope: list[str]
    :ivar client_id: The public identifier for the application.
    :vartype client_id: str
    :ivar client_secret: The secret known only to the application and the authorization server.
    :vartype client_secret: str
    :ivar issuer_uri: The URI of Issuer Identifier.
    :vartype issuer_uri: str
    """

    _attribute_map = {
        "scope": {"key": "scope", "type": "[str]"},
        "client_id": {"key": "clientId", "type": "str"},
        "client_secret": {"key": "clientSecret", "type": "str"},
        "issuer_uri": {"key": "issuerUri", "type": "str"},
    }

    def __init__(
        self,
        *,
        scope: Optional[List[str]] = None,
        client_id: Optional[str] = None,
        client_secret: Optional[str] = None,
        issuer_uri: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword scope: It defines the specific actions applications can be allowed to do on a user's
         behalf.
        :paramtype scope: list[str]
        :keyword client_id: The public identifier for the application.
        :paramtype client_id: str
        :keyword client_secret: The secret known only to the application and the authorization server.
        :paramtype client_secret: str
        :keyword issuer_uri: The URI of Issuer Identifier.
        :paramtype issuer_uri: str
        """
        super().__init__(**kwargs)
        self.scope = scope
        self.client_id = client_id
        self.client_secret = client_secret
        self.issuer_uri = issuer_uri


class StackProperties(_serialization.Model):
    """KPack ClusterStack properties payload.

    :ivar id: Id of the ClusterStack.
    :vartype id: str
    :ivar version: Version of the ClusterStack.
    :vartype version: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "version": {"key": "version", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        version: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Id of the ClusterStack.
        :paramtype id: str
        :keyword version: Version of the ClusterStack.
        :paramtype version: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.version = version


class StorageProperties(_serialization.Model):
    """Storage resource payload.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    StorageAccount

    All required parameters must be populated in order to send to Azure.

    :ivar storage_type: The type of the storage. Required. "StorageAccount"
    :vartype storage_type: str or ~azure.mgmt.appplatform.v2023_07_01_preview.models.StorageType
    """

    _validation = {
        "storage_type": {"required": True},
    }

    _attribute_map = {
        "storage_type": {"key": "storageType", "type": "str"},
    }

    _subtype_map = {"storage_type": {"StorageAccount": "StorageAccount"}}

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.storage_type: Optional[str] = None


class StorageAccount(StorageProperties):
    """storage resource of type Azure Storage Account.

    All required parameters must be populated in order to send to Azure.

    :ivar storage_type: The type of the storage. Required. "StorageAccount"
    :vartype storage_type: str or ~azure.mgmt.appplatform.v2023_07_01_preview.models.StorageType
    :ivar account_name: The account name of the Azure Storage Account. Required.
    :vartype account_name: str
    :ivar account_key: The account key of the Azure Storage Account. Required.
    :vartype account_key: str
    """

    _validation = {
        "storage_type": {"required": True},
        "account_name": {"required": True},
        "account_key": {"required": True},
    }

    _attribute_map = {
        "storage_type": {"key": "storageType", "type": "str"},
        "account_name": {"key": "accountName", "type": "str"},
        "account_key": {"key": "accountKey", "type": "str"},
    }

    def __init__(self, *, account_name: str, account_key: str, **kwargs: Any) -> None:
        """
        :keyword account_name: The account name of the Azure Storage Account. Required.
        :paramtype account_name: str
        :keyword account_key: The account key of the Azure Storage Account. Required.
        :paramtype account_key: str
        """
        super().__init__(**kwargs)
        self.storage_type: str = "StorageAccount"
        self.account_name = account_name
        self.account_key = account_key


class StorageResource(ProxyResource):
    """Storage resource payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.appplatform.v2023_07_01_preview.models.SystemData
    :ivar properties: Properties of the storage resource payload.
    :vartype properties: ~azure.mgmt.appplatform.v2023_07_01_preview.models.StorageProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "StorageProperties"},
    }

    def __init__(self, *, properties: Optional["_models.StorageProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: Properties of the storage resource payload.
        :paramtype properties: ~azure.mgmt.appplatform.v2023_07_01_preview.models.StorageProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class StorageResourceCollection(_serialization.Model):
    """Collection compose of storage resources list and a possible link for next page.

    :ivar value: The storage resources list.
    :vartype value: list[~azure.mgmt.appplatform.v2023_07_01_preview.models.StorageResource]
    :ivar next_link: The link to next page of storage list.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[StorageResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.StorageResource"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The storage resources list.
        :paramtype value: list[~azure.mgmt.appplatform.v2023_07_01_preview.models.StorageResource]
        :keyword next_link: The link to next page of storage list.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SupportedApmType(_serialization.Model):
    """Supported APM type.

    :ivar name: The name of the supported APM type.
    :vartype name: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: The name of the supported APM type.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.name = name


class SupportedApmTypes(_serialization.Model):
    """Supported APM types payload.

    :ivar value: Collection of the supported APM type.
    :vartype value: list[~azure.mgmt.appplatform.v2023_07_01_preview.models.SupportedApmType]
    :ivar next_link: URL client should use to fetch the next page (per server side paging).
     It's null for now, added for future use.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[SupportedApmType]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.SupportedApmType"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Collection of the supported APM type.
        :paramtype value: list[~azure.mgmt.appplatform.v2023_07_01_preview.models.SupportedApmType]
        :keyword next_link: URL client should use to fetch the next page (per server side paging).
         It's null for now, added for future use.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SupportedBuildpackResource(ProxyResource):
    """Supported buildpack resource payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.appplatform.v2023_07_01_preview.models.SystemData
    :ivar properties: Supported buildpack resource properties.
    :vartype properties:
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.SupportedBuildpackResourceProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "SupportedBuildpackResourceProperties"},
    }

    def __init__(
        self, *, properties: Optional["_models.SupportedBuildpackResourceProperties"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword properties: Supported buildpack resource properties.
        :paramtype properties:
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.SupportedBuildpackResourceProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class SupportedBuildpackResourceProperties(_serialization.Model):
    """Supported buildpack resource properties.

    :ivar buildpack_id: The id of supported buildpack.
    :vartype buildpack_id: str
    """

    _attribute_map = {
        "buildpack_id": {"key": "buildpackId", "type": "str"},
    }

    def __init__(self, *, buildpack_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword buildpack_id: The id of supported buildpack.
        :paramtype buildpack_id: str
        """
        super().__init__(**kwargs)
        self.buildpack_id = buildpack_id


class SupportedBuildpacksCollection(_serialization.Model):
    """Object that includes an array of supported buildpacks resources and a possible link for next
    set.

    :ivar value: Collection of supported buildpacks resources.
    :vartype value:
     list[~azure.mgmt.appplatform.v2023_07_01_preview.models.SupportedBuildpackResource]
    :ivar next_link: URL client should use to fetch the next page (per server side paging).
     It's null for now, added for future use.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[SupportedBuildpackResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.SupportedBuildpackResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Collection of supported buildpacks resources.
        :paramtype value:
         list[~azure.mgmt.appplatform.v2023_07_01_preview.models.SupportedBuildpackResource]
        :keyword next_link: URL client should use to fetch the next page (per server side paging).
         It's null for now, added for future use.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SupportedRuntimeVersion(_serialization.Model):
    """Supported deployment runtime version descriptor.

    :ivar value: The raw value which could be passed to deployment CRUD operations. Known values
     are: "Java_8", "Java_11", "Java_17", and "NetCore_31".
    :vartype value: str or ~azure.mgmt.appplatform.v2023_07_01_preview.models.SupportedRuntimeValue
    :ivar platform: The platform of this runtime version (possible values: "Java" or ".NET"). Known
     values are: "Java" and ".NET Core".
    :vartype platform: str or
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.SupportedRuntimePlatform
    :ivar version: The detailed version (major.minor) of the platform.
    :vartype version: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
        "platform": {"key": "platform", "type": "str"},
        "version": {"key": "version", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[Union[str, "_models.SupportedRuntimeValue"]] = None,
        platform: Optional[Union[str, "_models.SupportedRuntimePlatform"]] = None,
        version: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The raw value which could be passed to deployment CRUD operations. Known values
         are: "Java_8", "Java_11", "Java_17", and "NetCore_31".
        :paramtype value: str or
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.SupportedRuntimeValue
        :keyword platform: The platform of this runtime version (possible values: "Java" or ".NET").
         Known values are: "Java" and ".NET Core".
        :paramtype platform: str or
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.SupportedRuntimePlatform
        :keyword version: The detailed version (major.minor) of the platform.
        :paramtype version: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.platform = platform
        self.version = version


class SupportedStackResource(ProxyResource):
    """Supported stack resource payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.appplatform.v2023_07_01_preview.models.SystemData
    :ivar properties: Supported stack resource properties.
    :vartype properties:
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.SupportedStackResourceProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "SupportedStackResourceProperties"},
    }

    def __init__(
        self, *, properties: Optional["_models.SupportedStackResourceProperties"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword properties: Supported stack resource properties.
        :paramtype properties:
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.SupportedStackResourceProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class SupportedStackResourceProperties(_serialization.Model):
    """Supported stack resource properties.

    :ivar stack_id: The id of supported stack.
    :vartype stack_id: str
    :ivar version: The version of supported stack.
    :vartype version: str
    """

    _attribute_map = {
        "stack_id": {"key": "stackId", "type": "str"},
        "version": {"key": "version", "type": "str"},
    }

    def __init__(self, *, stack_id: Optional[str] = None, version: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword stack_id: The id of supported stack.
        :paramtype stack_id: str
        :keyword version: The version of supported stack.
        :paramtype version: str
        """
        super().__init__(**kwargs)
        self.stack_id = stack_id
        self.version = version


class SupportedStacksCollection(_serialization.Model):
    """Object that includes an array of supported stacks resources and a possible link for next set.

    :ivar value: Collection of supported stacks resources.
    :vartype value: list[~azure.mgmt.appplatform.v2023_07_01_preview.models.SupportedStackResource]
    :ivar next_link: URL client should use to fetch the next page (per server side paging).
     It's null for now, added for future use.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[SupportedStackResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.SupportedStackResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Collection of supported stacks resources.
        :paramtype value:
         list[~azure.mgmt.appplatform.v2023_07_01_preview.models.SupportedStackResource]
        :keyword next_link: URL client should use to fetch the next page (per server side paging).
         It's null for now, added for future use.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or
     ~azure.mgmt.appplatform.v2023_07_01_preview.models.LastModifiedByType
    :ivar last_modified_at: The timestamp of resource modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.LastModifiedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or
         ~azure.mgmt.appplatform.v2023_07_01_preview.models.LastModifiedByType
        :keyword last_modified_at: The timestamp of resource modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class TcpScaleRule(_serialization.Model):
    """Azure Spring Apps App Instance Tcp scaling rule.

    :ivar metadata: Metadata properties to describe tcp scale rule.
    :vartype metadata: dict[str, str]
    :ivar auth: Authentication secrets for the tcp scale rule.
    :vartype auth: list[~azure.mgmt.appplatform.v2023_07_01_preview.models.ScaleRuleAuth]
    """

    _attribute_map = {
        "metadata": {"key": "metadata", "type": "{str}"},
        "auth": {"key": "auth", "type": "[ScaleRuleAuth]"},
    }

    def __init__(
        self,
        *,
        metadata: Optional[Dict[str, str]] = None,
        auth: Optional[List["_models.ScaleRuleAuth"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword metadata: Metadata properties to describe tcp scale rule.
        :paramtype metadata: dict[str, str]
        :keyword auth: Authentication secrets for the tcp scale rule.
        :paramtype auth: list[~azure.mgmt.appplatform.v2023_07_01_preview.models.ScaleRuleAuth]
        """
        super().__init__(**kwargs)
        self.metadata = metadata
        self.auth = auth


class TCPSocketAction(ProbeAction):
    """TCPSocketAction describes an action based on opening a socket.

    All required parameters must be populated in order to send to Azure.

    :ivar type: The type of the action to take to perform the health check. Required. Known values
     are: "HTTPGetAction", "TCPSocketAction", and "ExecAction".
    :vartype type: str or ~azure.mgmt.appplatform.v2023_07_01_preview.models.ProbeActionType
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type: str = "TCPSocketAction"


class TemporaryDisk(_serialization.Model):
    """Temporary disk payload.

    :ivar size_in_gb: Size of the temporary disk in GB.
    :vartype size_in_gb: int
    :ivar mount_path: Mount path of the temporary disk.
    :vartype mount_path: str
    """

    _validation = {
        "size_in_gb": {"maximum": 5, "minimum": 0},
    }

    _attribute_map = {
        "size_in_gb": {"key": "sizeInGB", "type": "int"},
        "mount_path": {"key": "mountPath", "type": "str"},
    }

    def __init__(self, *, size_in_gb: Optional[int] = None, mount_path: str = "/tmp", **kwargs: Any) -> None:
        """
        :keyword size_in_gb: Size of the temporary disk in GB.
        :paramtype size_in_gb: int
        :keyword mount_path: Mount path of the temporary disk.
        :paramtype mount_path: str
        """
        super().__init__(**kwargs)
        self.size_in_gb = size_in_gb
        self.mount_path = mount_path


class TestKeys(_serialization.Model):
    """Test keys payload.

    :ivar primary_key: Primary key.
    :vartype primary_key: str
    :ivar secondary_key: Secondary key.
    :vartype secondary_key: str
    :ivar primary_test_endpoint: Primary test endpoint.
    :vartype primary_test_endpoint: str
    :ivar secondary_test_endpoint: Secondary test endpoint.
    :vartype secondary_test_endpoint: str
    :ivar enabled: Indicates whether the test endpoint feature enabled or not.
    :vartype enabled: bool
    """

    _attribute_map = {
        "primary_key": {"key": "primaryKey", "type": "str"},
        "secondary_key": {"key": "secondaryKey", "type": "str"},
        "primary_test_endpoint": {"key": "primaryTestEndpoint", "type": "str"},
        "secondary_test_endpoint": {"key": "secondaryTestEndpoint", "type": "str"},
        "enabled": {"key": "enabled", "type": "bool"},
    }

    def __init__(
        self,
        *,
        primary_key: Optional[str] = None,
        secondary_key: Optional[str] = None,
        primary_test_endpoint: Optional[str] = None,
        secondary_test_endpoint: Optional[str] = None,
        enabled: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword primary_key: Primary key.
        :paramtype primary_key: str
        :keyword secondary_key: Secondary key.
        :paramtype secondary_key: str
        :keyword primary_test_endpoint: Primary test endpoint.
        :paramtype primary_test_endpoint: str
        :keyword secondary_test_endpoint: Secondary test endpoint.
        :paramtype secondary_test_endpoint: str
        :keyword enabled: Indicates whether the test endpoint feature enabled or not.
        :paramtype enabled: bool
        """
        super().__init__(**kwargs)
        self.primary_key = primary_key
        self.secondary_key = secondary_key
        self.primary_test_endpoint = primary_test_endpoint
        self.secondary_test_endpoint = secondary_test_endpoint
        self.enabled = enabled


class TriggeredBuildResult(_serialization.Model):
    """The build result triggered by a build.

    :ivar id: The unique build id of this build result.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: The unique build id of this build result.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class UserAssignedManagedIdentity(_serialization.Model):
    """The details of the user-assigned managed identity assigned to an App.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: Principal Id of user-assigned managed identity.
    :vartype principal_id: str
    :ivar client_id: Client Id of user-assigned managed identity.
    :vartype client_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "client_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.principal_id = None
        self.client_id = None


class ValidationMessages(_serialization.Model):
    """Validate messages of the configuration service git repositories.

    :ivar name: The name of the configuration service git repository.
    :vartype name: str
    :ivar messages: Detailed validation messages.
    :vartype messages: list[str]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "messages": {"key": "messages", "type": "[str]"},
    }

    def __init__(self, *, name: Optional[str] = None, messages: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword name: The name of the configuration service git repository.
        :paramtype name: str
        :keyword messages: Detailed validation messages.
        :paramtype messages: list[str]
        """
        super().__init__(**kwargs)
        self.name = name
        self.messages = messages


class WeeklyMaintenanceScheduleConfiguration(MaintenanceScheduleConfiguration):
    """Weekly planned maintenance.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar frequency: The frequency to run the maintenance job. Required. "Weekly"
    :vartype frequency: str or ~azure.mgmt.appplatform.v2023_07_01_preview.models.Frequency
    :ivar hour: The hour to run the maintenance job. Required.
    :vartype hour: int
    :ivar duration: The duration time to run the maintenance job, specified in ISO8601 format, e.g.
     PT8H.
    :vartype duration: str
    :ivar day: The day to run the maintenance job. Required. Known values are: "Monday", "Tuesday",
     "Wednesday", "Thursday", "Friday", "Saturday", and "Sunday".
    :vartype day: str or ~azure.mgmt.appplatform.v2023_07_01_preview.models.WeekDay
    """

    _validation = {
        "frequency": {"required": True},
        "hour": {"required": True, "maximum": 23, "minimum": 0},
        "duration": {"readonly": True},
        "day": {"required": True},
    }

    _attribute_map = {
        "frequency": {"key": "frequency", "type": "str"},
        "hour": {"key": "hour", "type": "int"},
        "duration": {"key": "duration", "type": "str"},
        "day": {"key": "day", "type": "str"},
    }

    def __init__(self, *, hour: int, day: Union[str, "_models.WeekDay"], **kwargs: Any) -> None:
        """
        :keyword hour: The hour to run the maintenance job. Required.
        :paramtype hour: int
        :keyword day: The day to run the maintenance job. Required. Known values are: "Monday",
         "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", and "Sunday".
        :paramtype day: str or ~azure.mgmt.appplatform.v2023_07_01_preview.models.WeekDay
        """
        super().__init__(**kwargs)
        self.frequency: str = "Weekly"
        self.hour = hour
        self.duration = None
        self.day = day
