/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.Serializer;
import org.apache.xml.serialize.XMLSerializer;
import org.exolab.castor.util.Configuration;
import org.exolab.castor.util.Logger;
import org.exolab.castor.util.Messages;
import org.exolab.castor.util.RegExpEvaluator;
import org.exolab.castor.xml.NodeType;
import org.exolab.castor.xml.XMLNaming;
import org.exolab.castor.xml.util.DefaultNaming;
import org.xml.sax.DocumentHandler;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class LocalConfiguration
extends Configuration {
    private Properties _props;
    private Configuration.ConfigValues _values = new Configuration.ConfigValues();
    private static Hashtable _configurations = new Hashtable();
    private String _resourceUrl = null;

    public LocalConfiguration() {
        this.load();
    }

    public static synchronized LocalConfiguration getInstance() {
        LocalConfiguration config = null;
        URL url = null;
        String key = "";
        if (url != null) {
            key = url.toString();
        }
        if ((config = (LocalConfiguration)_configurations.get(key)) == null) {
            config = new LocalConfiguration();
            _configurations.put(key, config);
        }
        return config;
    }

    public boolean debug() {
        this.getProperties();
        return this._values.debug;
    }

    public boolean strictElements() {
        this.getProperties();
        return this._values.strictElements;
    }

    public boolean marshallingValidation() {
        this.getProperties();
        return this._values.marshallingValidation;
    }

    public synchronized Properties getProperties() {
        if (this._props == null) {
            this.load();
        }
        return this._props;
    }

    public XMLNaming getXMLNaming() {
        if (this._values.naming != null) {
            return this._values.naming;
        }
        String prop = this.getProperty("org.exolab.castor.xml.naming", null);
        if (prop == null || prop.equalsIgnoreCase("lower")) {
            this._values.naming = new DefaultNaming();
        } else if (prop.equalsIgnoreCase("mixed")) {
            DefaultNaming dn = new DefaultNaming();
            dn.setStyle((short)1);
            this._values.naming = dn;
        } else {
            try {
                Class<?> cls = Class.forName(prop);
                this._values.naming = (XMLNaming)cls.newInstance();
            }
            catch (Exception except) {
                throw new RuntimeException("Failed to load XMLNaming: " + except);
            }
        }
        return this._values.naming;
    }

    public Parser getParser() {
        return this.getParser(null);
    }

    public Parser getParser(String features) {
        Parser parser;
        String prop = this.getProperties().getProperty("org.exolab.castor.parser.validation", "false");
        boolean validation = prop.equalsIgnoreCase("true") || prop.equalsIgnoreCase("on");
        prop = this.getProperties().getProperty("org.exolab.castor.parser.namespaces", "false");
        boolean namespaces = prop.equalsIgnoreCase("true") || prop.equalsIgnoreCase("on");
        prop = this.getProperties().getProperty("org.exolab.castor.parser");
        if (prop == null || prop.length() == 0) {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(namespaces);
            factory.setValidating(validation);
            try {
                SAXParser saxParser = factory.newSAXParser();
                return saxParser.getParser();
            }
            catch (ParserConfigurationException pcx) {
                Logger.getSystemLogger().println(Messages.format("conf.configurationError", pcx));
            }
            catch (SAXException sx) {
                Logger.getSystemLogger().println(Messages.format("conf.configurationError", sx));
            }
        }
        if (prop == null || prop.length() == 0 || prop.equalsIgnoreCase("xerces")) {
            prop = "org.apache.xerces.parsers.SAXParser";
        }
        try {
            Class<?> cls = Class.forName(prop);
            parser = (Parser)cls.newInstance();
        }
        catch (Exception except) {
            throw new RuntimeException(Messages.format("conf.failedInstantiateParser", prop, except));
        }
        if (parser instanceof XMLReader) {
            XMLReader xmlReader = (XMLReader)((Object)parser);
            try {
                xmlReader.setFeature("http://xml.org/sax/features/validation", validation);
                xmlReader.setFeature("http://xml.org/sax/features/namespaces", namespaces);
                features = this.getProperties().getProperty("org.exolab.castor.sax.features", features);
                if (features != null) {
                    StringTokenizer token = new StringTokenizer(features, ", ");
                    while (token.hasMoreTokens()) {
                        xmlReader.setFeature(token.nextToken(), true);
                    }
                }
            }
            catch (SAXException except) {
                Logger.getSystemLogger().println(Messages.format("conf.configurationError", except));
            }
        }
        return parser;
    }

    public XMLReader getXMLReader() {
        return this.getXMLReader(null);
    }

    public XMLReader getXMLReader(String features) {
        XMLReader reader = null;
        String prop = this.getProperties().getProperty("org.exolab.castor.parser.validation", "false");
        boolean validation = prop.equalsIgnoreCase("true") || prop.equalsIgnoreCase("on");
        prop = this.getProperties().getProperty("org.exolab.castor.parser.namespaces", "false");
        boolean namespaces = prop.equalsIgnoreCase("true") || prop.equalsIgnoreCase("on");
        prop = this.getProperties().getProperty("org.exolab.castor.parser");
        if (prop == null || prop.length() == 0) {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(namespaces);
            factory.setValidating(validation);
            try {
                SAXParser saxParser = factory.newSAXParser();
                reader = saxParser.getXMLReader();
            }
            catch (ParserConfigurationException pcx) {
                Logger.getSystemLogger().println(Messages.format("conf.configurationError", pcx));
            }
            catch (SAXException sx) {
                Logger.getSystemLogger().println(Messages.format("conf.configurationError", sx));
            }
        }
        if (reader == null) {
            if (prop == null || prop.length() == 0 || prop.equalsIgnoreCase("xerces")) {
                prop = "org.apache.xerces.parsers.SAXParser";
            }
            try {
                Class<?> cls = Class.forName(prop);
                reader = (XMLReader)cls.newInstance();
            }
            catch (Exception except) {
                throw new RuntimeException(Messages.format("conf.failedInstantiateParser", prop, except));
            }
        }
        try {
            reader.setFeature("http://xml.org/sax/features/validation", validation);
            reader.setFeature("http://xml.org/sax/features/namespaces", namespaces);
            features = this.getProperties().getProperty("org.exolab.castor.sax.features", features);
            if (features != null) {
                StringTokenizer token = new StringTokenizer(features, ", ");
                while (token.hasMoreTokens()) {
                    reader.setFeature(token.nextToken(), true);
                }
            }
        }
        catch (SAXException except) {
            Logger.getSystemLogger().println(Messages.format("conf.configurationError", except));
        }
        return reader;
    }

    public NodeType getPrimitiveNodeType() {
        if (this._values.primitiveNodeType != null) {
            return this._values.primitiveNodeType;
        }
        String prop = this.getProperty("org.exolab.castor.xml.introspector.primitive.nodetype", null);
        if (prop == null) {
            return null;
        }
        this._values.primitiveNodeType = NodeType.getNodeType(prop);
        return this._values.primitiveNodeType;
    }

    public RegExpEvaluator getRegExpEvaluator() {
        String prop = this.getProperties().getProperty("org.exolab.castor.regexp");
        RegExpEvaluator regex = null;
        if (prop == null) {
            return null;
        }
        try {
            if (this._values.regExpEvalClass == null) {
                this._values.regExpEvalClass = Class.forName(prop);
            }
            regex = (RegExpEvaluator)this._values.regExpEvalClass.newInstance();
        }
        catch (Exception except) {
            throw new RuntimeException(Messages.format("conf.failedInstantiateRegExp", prop, except));
        }
        return regex;
    }

    /*
     * WARNING - void declaration
     */
    public Serializer getSerializer() {
        void var2_2;
        XMLSerializer serializer;
        String prop = this._props.getProperty("org.exolab.castor.serializer");
        if (prop == null || prop.equalsIgnoreCase("xerces")) {
            serializer = new XMLSerializer();
        } else {
            try {
                serializer = (Serializer)Class.forName(prop).newInstance();
            }
            catch (Exception except) {
                throw new RuntimeException(Messages.format("conf.failedInstantiateSerializer", prop, except));
            }
        }
        var2_2.setOutputFormat(this.getOutputFormat());
        return var2_2;
    }

    public OutputFormat getOutputFormat() {
        boolean indent = false;
        String prop = this._props.getProperty("org.exolab.castor.indent", "");
        indent = prop.equalsIgnoreCase("true") || prop.equalsIgnoreCase("on");
        OutputFormat format = new OutputFormat();
        format.setMethod("xml");
        format.setIndenting(indent);
        if (!indent) {
            format.setPreserveSpace(true);
        }
        return format;
    }

    public DocumentHandler getSerializer(OutputStream output) throws IOException {
        Serializer serializer = this.getSerializer();
        serializer.setOutputByteStream(output);
        DocumentHandler docHandler = serializer.asDocumentHandler();
        if (docHandler == null) {
            throw new RuntimeException(Messages.format("conf.serializerNotSaxCapable", serializer.getClass().getName()));
        }
        return docHandler;
    }

    public DocumentHandler getSerializer(Writer output) throws IOException {
        Serializer serializer = this.getSerializer();
        serializer.setOutputCharStream(output);
        DocumentHandler docHandler = serializer.asDocumentHandler();
        if (docHandler == null) {
            throw new RuntimeException(Messages.format("conf.serializerNotSaxCapable", serializer.getClass().getName()));
        }
        return docHandler;
    }

    protected void load() {
        this._props = new Properties(LocalConfiguration.getDefault());
        try {
            this.loadProperties("castor.properties");
        }
        catch (FileNotFoundException fnfe) {
            // empty catch block
        }
        String prop = this._props.getProperty("org.exolab.castor.debug", "");
        if (prop.equalsIgnoreCase("true") || prop.equalsIgnoreCase("on")) {
            this._values.debug = true;
        }
        if ((prop = this._props.getProperty("org.exolab.castor.marshalling.validation", "")).equalsIgnoreCase("false") || prop.equalsIgnoreCase("off")) {
            this._values.marshallingValidation = false;
        }
        this._values.strictElements = !(prop = this._props.getProperty("org.exolab.castor.xml.strictelements", "")).equalsIgnoreCase("false") && !prop.equalsIgnoreCase("off");
        prop = null;
    }

    public void loadProperties(String fileOrResourceName) throws FileNotFoundException {
        boolean found = false;
        try {
            URL url = this.getClass().getResource("/" + fileOrResourceName);
            if (url != null) {
                this._resourceUrl = url.toString();
                this._props.load(url.openStream());
                found = true;
            }
        }
        catch (Exception except) {
            // empty catch block
        }
        if (!found) {
            try {
                File file = new File(fileOrResourceName);
                if (file.exists() && file.canRead()) {
                    FileInputStream is = new FileInputStream(file);
                    this._props.load(is);
                    ((InputStream)is).close();
                    found = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

