/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.pict;

import com.sun.jimi.core.decoder.pict.PICTRectangle;
import java.io.DataInputStream;
import java.io.IOException;

class PICT2Header {
    short opcode;
    short version;
    short reserved;
    int origHoriz;
    int origVert;
    PICTRectangle frame;
    int reserved2;

    public PICT2Header(DataInputStream dataInputStream) throws IOException {
        this.opcode = dataInputStream.readShort();
        if (this.opcode != 3072) {
            throw new IOException("Pict Version 2 Header opcode not 0xC00 " + this.opcode);
        }
        this.version = dataInputStream.readShort();
        this.reserved = dataInputStream.readShort();
        this.origHoriz = dataInputStream.readInt();
        this.origVert = dataInputStream.readInt();
        this.frame = new PICTRectangle(dataInputStream);
        this.reserved2 = dataInputStream.readInt();
    }

    public String toString() {
        return "opcode " + Integer.toHexString(this.opcode & 0xFFFF) + " version " + Integer.toHexString(this.version & 0xFFFF) + " frame " + this.frame.toString();
    }
}

