/*
 * brass - Braille and speech server
 *
 * Copyright (C) 2001 by Roger Butenuth, All rights reserved.
 *
 * This is free software, placed under the terms of the
 * GNU General Public License, as published by the Free Software
 * Foundation.  Please see the file COPYING for details.
 *
 * $Id: synth_buffer.c,v 1.1 2001/01/18 19:48:54 butenuth Exp $
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "language.h"

/*
 * ----------------------------------------------------------------------
 * Initalize the buffer between the language modules and the synthesizer
 * modules.
 * ----------------------------------------------------------------------
 */
void init_synth_buffer (lang_t * lang)
{
  lang->s_buf = NULL;
  lang->s_buf_used = 0;
  lang->s_buf_size = 0;
}

/*
 * ----------------------------------------------------------------------
 * De-initalize the buffer between the language modules and the synthesizer
 * modules. If there is memory allocated, free it.
 * ----------------------------------------------------------------------
 */
void deinit_synth_buffer (lang_t * lang)
{
  if (lang->s_buf != NULL)
   {
     free (lang->s_buf);
   }
  lang->s_buf = NULL;
  lang->s_buf_used = 0;
  lang->s_buf_size = 0;
}

/*
 * ----------------------------------------------------------------------
 * Add a string to the buffer. Increase memory if necessary.
 * ----------------------------------------------------------------------
 */
int add_to_synth_buffer (lang_t * lang, const char *str)
{
  const int INCREMENT = 500;

  if (lang->s_buf_used + strlen (str) + 1 > lang->s_buf_size)
   {
     lang->s_buf_size += lang->s_buf_used + INCREMENT + strlen (str) + 1;
     lang->s_buf = realloc (lang->s_buf, lang->s_buf_size);

     if (lang->s_buf == NULL)
      {
        return 1;
      }
   }
  strcpy (lang->s_buf + lang->s_buf_used, str);
  lang->s_buf_used += strlen (str);

  return 0;
}

/*
 * ----------------------------------------------------------------------
 * Send the contents of the buffer to the synthesizer and to a flush.
 * The buffer remains allocated, it is just marked as free.
 * ----------------------------------------------------------------------
 */
int flush_synth_buffer (lang_t * lang)
{
  int result = 0;

  result = lang->synth->synth (lang->synth, (unsigned char *) lang->s_buf);
  lang->s_buf_used = 0;
  if (result == 0)
    result = lang->synth->flush (lang->synth);

  return result;
}
