PUSHDIVERT(-1)
#
# Copyright (c) 1999,2000 SuSE GmbH Nuernberg, Germany.
# Copyright (c) 2006 SuSE LINUX Products GmbH, Germany.
# Author: Werner Fink
# Please send feedback to http://www.suse.de/feedback/
#
# Define mail500 accordingly to the manual page of mail500(1)
# of the openldap package.  We use a more flexible rule for
# domains given in class {mail500} similar to those of uucp
# mailers. The host part of header and envelope is removed
# for the recipient just like in local mailer part.
# 
# `MAIL500_SERVER_HOST'  alternate host on which the LDAP server is running.
# `MAIL500_CONFIG_PATH'  only for new OpenLDAP
# `MAIL500_MAILER_PATH'  path of mail500 binary
# `MAIL500_MAILER_FLAGS' the flags for sendmail (see op.txt)
# `MAIL500_MAILER_ARGS'  the mailer arguments (see mail500(1))
#

ifelse(_ARG_,`',`errprint(`*** MAILER(`mail500') requires domain name(s) as argument!
')')dnl

ifdef(`_MAILER_smtp_', `',
	`errprint(`*** MAILER(`smtp') must appear before MAILER(`mail500', `ldap-domain')')')dnl

_DEFIFNOT(`_USE_MAIL500_MAILER_ARGS', `mail500')
_DEFIFNOT(`_DEF_MAIL500_MAILER_FLAGS', `DFM')

dnl _DEFIFNOT(`MAIL500_CONFIG_PATH', `/etc/openldap/mail500.conf')
_DEFIFNOT(`MAIL500_MAILER_PATH', `/usr/libexec/openldap/mail500')
_DEFIFNOT(`MAIL500_MAILER_FLAGS', `SmnXuh')
_DEFIFNOT(`MAIL500_MAILER_ARGS', `-f $f -m $n@$w $u')

define(`_USE_MAIL500_MAILER_ARGS', CONCAT(`_USE_MAIL500_MAILER_ARGS', _OPTINS(`MAIL500_SERVER_HOST', ` -l ', `')))
define(`_USE_MAIL500_MAILER_ARGS', CONCAT(`_USE_MAIL500_MAILER_ARGS', _OPTINS(`MAIL500_CONFIG_PATH', ` -C ', `')))
define(`_USE_MAIL500_MAILER_ARGS', CONCAT(`_USE_MAIL500_MAILER_ARGS', _OPTINS(`MAIL500_MAILER_ARGS', ` ', `')))

POPDIVERT

########################################
###   MAIL500 Mailer specification   ###
########################################

VERSIONID(`@(#) mail500.m4 0.1 (SUSE Linux) 2000/03/22')

MAILER_DEFINITIONS
Mmail500,	P=MAIL500_MAILER_PATH, F=_MODMF_(CONCAT(_DEF_MAIL500_MAILER_FLAGS, MAIL500_MAILER_FLAGS), `MAIL500'), S=EnvFromSMTP/HdrFromSMTP, R=EnvToL/HdrToL
		ifdef(`MAIL500_MAILER_MAX', `M=MAIL500_MAILER_MAX, ')T=DNS/RFC822/X-Unix,
		A=_USE_MAIL500_MAILER_ARGS

LOCAL_RULE_0
# redirect messages for domain given in Class for mail500
R$* < @ $={mail500} > $*	$#mail500 $@ $2 $: <$1@$2>

LOCAL_CONFIG
C{mail500}`'_ARG_
