/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

// TestEmbeddedTypeApplyConfiguration represents a declarative configuration of the TestEmbeddedType type for use
// with apply.
//
// TestEmbeddedType is a type intended to create conflicts with other embedded structs:
// Kind conflicts with TypeMeta (inlined), and Namespace conflicts with ObjectMeta (embedded).
type TestEmbeddedTypeApplyConfiguration struct {
	Kind      *string `json:"kind,omitempty"`
	Namespace *string `json:"namespace,omitempty"`
}

// TestEmbeddedTypeApplyConfiguration constructs a declarative configuration of the TestEmbeddedType type for use with
// apply.
func TestEmbeddedType() *TestEmbeddedTypeApplyConfiguration {
	return &TestEmbeddedTypeApplyConfiguration{}
}

// WithKind sets the Kind field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Kind field is set to the value of the last call.
func (b *TestEmbeddedTypeApplyConfiguration) WithKind(value string) *TestEmbeddedTypeApplyConfiguration {
	b.Kind = &value
	return b
}

// WithNamespace sets the Namespace field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Namespace field is set to the value of the last call.
func (b *TestEmbeddedTypeApplyConfiguration) WithNamespace(value string) *TestEmbeddedTypeApplyConfiguration {
	b.Namespace = &value
	return b
}
