; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 3
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+sse2 | FileCheck %s --check-prefixes=X86
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx | FileCheck %s --check-prefixes=X64

define i32 @sext_known_nonzero(i16 %xx) {
; X86-LABEL: sext_known_nonzero:
; X86:       # %bb.0:
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl $256, %eax # imm = 0x100
; X86-NEXT:    shll %cl, %eax
; X86-NEXT:    cwtl
; X86-NEXT:    testl %eax, %eax
; X86-NEXT:    je .LBB0_1
; X86-NEXT:  # %bb.2: # %cond.false
; X86-NEXT:    rep bsfl %eax, %eax
; X86-NEXT:    retl
; X86-NEXT:  .LBB0_1:
; X86-NEXT:    movl $32, %eax
; X86-NEXT:    retl
;
; X64-LABEL: sext_known_nonzero:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %ecx
; X64-NEXT:    movl $256, %eax # imm = 0x100
; X64-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-NEXT:    shll %cl, %eax
; X64-NEXT:    cwtl
; X64-NEXT:    testl %eax, %eax
; X64-NEXT:    je .LBB0_1
; X64-NEXT:  # %bb.2: # %cond.false
; X64-NEXT:    rep bsfl %eax, %eax
; X64-NEXT:    retq
; X64-NEXT:  .LBB0_1:
; X64-NEXT:    movl $32, %eax
; X64-NEXT:    retq
  %x = shl i16 256, %xx
  %z = sext i16 %x to i32
  %r = call i32 @llvm.cttz.i32(i32 %z, i1 false)
  ret i32 %r
}

define i32 @sext_known_nonzero_nuw(i16 %xx) {
; X86-LABEL: sext_known_nonzero_nuw:
; X86:       # %bb.0:
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl $256, %eax # imm = 0x100
; X86-NEXT:    shll %cl, %eax
; X86-NEXT:    cwtl
; X86-NEXT:    rep bsfl %eax, %eax
; X86-NEXT:    retl
;
; X64-LABEL: sext_known_nonzero_nuw:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %ecx
; X64-NEXT:    movl $256, %eax # imm = 0x100
; X64-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-NEXT:    shll %cl, %eax
; X64-NEXT:    cwtl
; X64-NEXT:    rep bsfl %eax, %eax
; X64-NEXT:    retq
  %x = shl nuw i16 256, %xx
  %z = sext i16 %x to i32
  %r = call i32 @llvm.cttz.i32(i32 %z, i1 false)
  ret i32 %r
}

define i32 @sext_known_nonzero_nsw(i16 %xx) {
; X86-LABEL: sext_known_nonzero_nsw:
; X86:       # %bb.0:
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl $256, %eax # imm = 0x100
; X86-NEXT:    shll %cl, %eax
; X86-NEXT:    movzwl %ax, %eax
; X86-NEXT:    rep bsfl %eax, %eax
; X86-NEXT:    retl
;
; X64-LABEL: sext_known_nonzero_nsw:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %ecx
; X64-NEXT:    movl $256, %eax # imm = 0x100
; X64-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-NEXT:    shll %cl, %eax
; X64-NEXT:    movzwl %ax, %eax
; X64-NEXT:    rep bsfl %eax, %eax
; X64-NEXT:    retq
  %x = shl nsw i16 256, %xx
  %z = sext i16 %x to i32
  %r = call i32 @llvm.cttz.i32(i32 %z, i1 false)
  ret i32 %r
}

define i32 @sext_known_nonzero_nuw_nsw(i16 %xx) {
; X86-LABEL: sext_known_nonzero_nuw_nsw:
; X86:       # %bb.0:
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl $256, %eax # imm = 0x100
; X86-NEXT:    shll %cl, %eax
; X86-NEXT:    movzwl %ax, %eax
; X86-NEXT:    rep bsfl %eax, %eax
; X86-NEXT:    retl
;
; X64-LABEL: sext_known_nonzero_nuw_nsw:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %ecx
; X64-NEXT:    movl $256, %eax # imm = 0x100
; X64-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-NEXT:    shll %cl, %eax
; X64-NEXT:    movzwl %ax, %eax
; X64-NEXT:    rep bsfl %eax, %eax
; X64-NEXT:    retq
  %x = shl nuw nsw i16 256, %xx
  %z = sext i16 %x to i32
  %r = call i32 @llvm.cttz.i32(i32 %z, i1 false)
  ret i32 %r
}
