# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


class Create(AAZCommand):
    """Create an autoscale setting.

    For more information on autoscaling, visit: https://docs.microsoft.com/azure/monitoring-and-diagnostics/monitoring-understanding-autoscale-settings.

    :example: Create autoscale settings to scale between 2 and 5 instances (3 as default). Email the administrator when scaling occurs.
        az monitor autoscale create -g myrg --resource resource-id --min-count 2 --max-count 5 --count 3 --email-administrator
        az monitor autoscale rule create -g myrg --autoscale-name resource-name --scale out 1 --condition "Percentage CPU > 75 avg 5m"
        az monitor autoscale rule create -g myrg --autoscale-name resource-name --scale in 1 --condition "Percentage CPU < 25 avg 5m"

    :example: Create autoscale settings for exactly 4 instances.
        az monitor autoscale create -g myrg --resource resource-id --count 4

    :example: Create new autoscale settings.
        az monitor autoscale create --count 3 --max-count 5 --min-count 2 --name MyAutoscaleSettings --resource myScaleSet --resource-group MyResourceGroup --resource-type Microsoft.Compute/virtualMachineScaleSets
    """

    _aaz_info = {
        "version": "2022-10-01",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.insights/autoscalesettings/{}", "2022-10-01"],
        ]
    }

    def _handler(self, command_args):
        super()._handler(command_args)
        self._execute_operations()
        return self._output()

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.autoscale_name = AAZStrArg(
            options=["-n", "--name", "--autoscale-name"],
            help="The autoscale setting name.",
            required=True,
        )
        _args_schema.resource_group = AAZResourceGroupNameArg(
            required=True,
        )
        _args_schema.location = AAZResourceLocationArg(
            help="Resource location",
            required=True,
            fmt=AAZResourceLocationArgFormat(
                resource_group_arg="resource_group",
            ),
        )
        _args_schema.enabled = AAZBoolArg(
            options=["--enabled"],
            help="the enabled flag. Specifies whether automatic scaling is enabled for the resource. The default value is 'false'.",
            default=False,
        )
        _args_schema.tags = AAZDictArg(
            options=["--tags"],
            help="Gets or sets a list of key value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater in length than 128 characters and a value no greater in length than 256 characters.",
        )

        tags = cls._args_schema.tags
        tags.Element = AAZStrArg()

        # define Arg Group "Predictive Policy"

        _args_schema = cls._args_schema
        _args_schema.scale_look_ahead_time = AAZDurationArg(
            options=["--scale-look-ahead-time"],
            arg_group="Predictive Policy",
            help="the amount of time to specify by which instances are launched in advance. It must be between 1 minute and 60 minutes in ISO 8601 format (for example, 100 days would be P100D).",
        )
        _args_schema.scale_mode = AAZStrArg(
            options=["--scale-mode"],
            arg_group="Predictive Policy",
            help="the predictive autoscale mode",
            enum={"Disabled": "Disabled", "Enabled": "Enabled", "ForecastOnly": "ForecastOnly"},
        )

        # define Arg Group "Properties"

        _args_schema = cls._args_schema
        _args_schema.notifications = AAZListArg(
            options=["--notifications"],
            arg_group="Properties",
            help="the collection of notifications.",
        )
        _args_schema.profiles = AAZListArg(
            options=["--profiles"],
            arg_group="Properties",
            help="the collection of automatic scaling profiles that specify different scaling parameters for different time periods. A maximum of 20 profiles can be specified.",
            required=True,
        )
        _args_schema.target_resource_location = AAZStrArg(
            options=["--target-resource-location"],
            arg_group="Properties",
            help="the location of the resource that the autoscale setting should be added to.",
        )
        _args_schema.target_resource_uri = AAZStrArg(
            options=["--target-resource-uri"],
            arg_group="Properties",
            help="the resource identifier of the resource that the autoscale setting should be added to.",
        )

        notifications = cls._args_schema.notifications
        notifications.Element = AAZObjectArg()

        _element = cls._args_schema.notifications.Element
        _element.email = AAZObjectArg(
            options=["email"],
            help="the email notification.",
        )
        _element.operation = AAZStrArg(
            options=["operation"],
            help="the operation associated with the notification and its value must be \"scale\"",
            required=True,
            enum={"Scale": "Scale"},
        )
        _element.webhooks = AAZListArg(
            options=["webhooks"],
            help="the collection of webhook notifications.",
        )

        email = cls._args_schema.notifications.Element.email
        email.custom_emails = AAZListArg(
            options=["custom-emails"],
            help="the custom e-mails list. This value can be null or empty, in which case this attribute will be ignored.",
        )
        email.send_to_subscription_administrator = AAZBoolArg(
            options=["send-to-subscription-administrator"],
            help="a value indicating whether to send email to subscription administrator.",
            default=False,
        )
        email.send_to_subscription_co_administrators = AAZBoolArg(
            options=["send-to-subscription-co-administrators"],
            help="a value indicating whether to send email to subscription co-administrators.",
            default=False,
        )

        custom_emails = cls._args_schema.notifications.Element.email.custom_emails
        custom_emails.Element = AAZStrArg()

        webhooks = cls._args_schema.notifications.Element.webhooks
        webhooks.Element = AAZObjectArg()

        _element = cls._args_schema.notifications.Element.webhooks.Element
        _element.properties = AAZDictArg(
            options=["properties"],
            help="a property bag of settings. This value can be empty.",
        )
        _element.service_uri = AAZStrArg(
            options=["service-uri"],
            help="the service address to receive the notification.",
        )

        properties = cls._args_schema.notifications.Element.webhooks.Element.properties
        properties.Element = AAZStrArg()

        profiles = cls._args_schema.profiles
        profiles.Element = AAZObjectArg()

        _element = cls._args_schema.profiles.Element
        _element.capacity = AAZObjectArg(
            options=["capacity"],
            help="the number of instances that can be used during this profile.",
            required=True,
        )
        _element.fixed_date = AAZObjectArg(
            options=["fixed-date"],
            help="the specific date-time for the profile. This element is not used if the Recurrence element is used.",
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="the name of the profile.",
            required=True,
        )
        _element.recurrence = AAZObjectArg(
            options=["recurrence"],
            help="the repeating times at which this profile begins. This element is not used if the FixedDate element is used.",
        )
        _element.rules = AAZListArg(
            options=["rules"],
            help="the collection of rules that provide the triggers and parameters for the scaling action. A maximum of 10 rules can be specified.",
            required=True,
        )

        capacity = cls._args_schema.profiles.Element.capacity
        capacity.default = AAZStrArg(
            options=["default"],
            help="the number of instances that will be set if metrics are not available for evaluation. The default is only used if the current instance count is lower than the default.",
            required=True,
        )
        capacity.maximum = AAZStrArg(
            options=["maximum"],
            help="the maximum number of instances for the resource. The actual maximum number of instances is limited by the cores that are available in the subscription.",
            required=True,
        )
        capacity.minimum = AAZStrArg(
            options=["minimum"],
            help="the minimum number of instances for the resource.",
            required=True,
        )

        fixed_date = cls._args_schema.profiles.Element.fixed_date
        fixed_date.end = AAZDateTimeArg(
            options=["end"],
            help="the end time for the profile in ISO 8601 format.",
            required=True,
        )
        fixed_date.start = AAZDateTimeArg(
            options=["start"],
            help="the start time for the profile in ISO 8601 format.",
            required=True,
        )
        fixed_date.time_zone = AAZStrArg(
            options=["time-zone"],
            help="the timezone of the start and end times for the profile. Some examples of valid time zones are: Dateline Standard Time, UTC-11, Hawaiian Standard Time, Alaskan Standard Time, Pacific Standard Time (Mexico), Pacific Standard Time, US Mountain Standard Time, Mountain Standard Time (Mexico), Mountain Standard Time, Central America Standard Time, Central Standard Time, Central Standard Time (Mexico), Canada Central Standard Time, SA Pacific Standard Time, Eastern Standard Time, US Eastern Standard Time, Venezuela Standard Time, Paraguay Standard Time, Atlantic Standard Time, Central Brazilian Standard Time, SA Western Standard Time, Pacific SA Standard Time, Newfoundland Standard Time, E. South America Standard Time, Argentina Standard Time, SA Eastern Standard Time, Greenland Standard Time, Montevideo Standard Time, Bahia Standard Time, UTC-02, Mid-Atlantic Standard Time, Azores Standard Time, Cape Verde Standard Time, Morocco Standard Time, UTC, GMT Standard Time, Greenwich Standard Time, W. Europe Standard Time, Central Europe Standard Time, Romance Standard Time, Central European Standard Time, W. Central Africa Standard Time, Namibia Standard Time, Jordan Standard Time, GTB Standard Time, Middle East Standard Time, Egypt Standard Time, Syria Standard Time, E. Europe Standard Time, South Africa Standard Time, FLE Standard Time, Turkey Standard Time, Israel Standard Time, Kaliningrad Standard Time, Libya Standard Time, Arabic Standard Time, Arab Standard Time, Belarus Standard Time, Russian Standard Time, E. Africa Standard Time, Iran Standard Time, Arabian Standard Time, Azerbaijan Standard Time, Russia Time Zone 3, Mauritius Standard Time, Georgian Standard Time, Caucasus Standard Time, Afghanistan Standard Time, West Asia Standard Time, Ekaterinburg Standard Time, Pakistan Standard Time, India Standard Time, Sri Lanka Standard Time, Nepal Standard Time, Central Asia Standard Time, Bangladesh Standard Time, N. Central Asia Standard Time, Myanmar Standard Time, SE Asia Standard Time, North Asia Standard Time, China Standard Time, North Asia East Standard Time, Singapore Standard Time, W. Australia Standard Time, Taipei Standard Time, Ulaanbaatar Standard Time, Tokyo Standard Time, Korea Standard Time, Yakutsk Standard Time, Cen. Australia Standard Time, AUS Central Standard Time, E. Australia Standard Time, AUS Eastern Standard Time, West Pacific Standard Time, Tasmania Standard Time, Magadan Standard Time, Vladivostok Standard Time, Russia Time Zone 10, Central Pacific Standard Time, Russia Time Zone 11, New Zealand Standard Time, UTC+12, Fiji Standard Time, Kamchatka Standard Time, Tonga Standard Time, Samoa Standard Time, Line Islands Standard Time",
        )

        recurrence = cls._args_schema.profiles.Element.recurrence
        recurrence.frequency = AAZStrArg(
            options=["frequency"],
            help="the recurrence frequency. How often the schedule profile should take effect. This value must be Week, meaning each week will have the same set of profiles. For example, to set a daily schedule, set **schedule** to every day of the week. The frequency property specifies that the schedule is repeated weekly.",
            required=True,
            enum={"Day": "Day", "Hour": "Hour", "Minute": "Minute", "Month": "Month", "None": "None", "Second": "Second", "Week": "Week", "Year": "Year"},
        )
        recurrence.schedule = AAZObjectArg(
            options=["schedule"],
            help="the scheduling constraints for when the profile begins.",
            required=True,
        )

        schedule = cls._args_schema.profiles.Element.recurrence.schedule
        schedule.days = AAZListArg(
            options=["days"],
            help="the collection of days that the profile takes effect on. Possible values are Sunday through Saturday.",
            required=True,
        )
        schedule.hours = AAZListArg(
            options=["hours"],
            help="A collection of hours that the profile takes effect on. Values supported are 0 to 23 on the 24-hour clock (AM/PM times are not supported).",
            required=True,
        )
        schedule.minutes = AAZListArg(
            options=["minutes"],
            help="A collection of minutes at which the profile takes effect at.",
            required=True,
        )
        schedule.time_zone = AAZStrArg(
            options=["time-zone"],
            help="the timezone for the hours of the profile. Some examples of valid time zones are: Dateline Standard Time, UTC-11, Hawaiian Standard Time, Alaskan Standard Time, Pacific Standard Time (Mexico), Pacific Standard Time, US Mountain Standard Time, Mountain Standard Time (Mexico), Mountain Standard Time, Central America Standard Time, Central Standard Time, Central Standard Time (Mexico), Canada Central Standard Time, SA Pacific Standard Time, Eastern Standard Time, US Eastern Standard Time, Venezuela Standard Time, Paraguay Standard Time, Atlantic Standard Time, Central Brazilian Standard Time, SA Western Standard Time, Pacific SA Standard Time, Newfoundland Standard Time, E. South America Standard Time, Argentina Standard Time, SA Eastern Standard Time, Greenland Standard Time, Montevideo Standard Time, Bahia Standard Time, UTC-02, Mid-Atlantic Standard Time, Azores Standard Time, Cape Verde Standard Time, Morocco Standard Time, UTC, GMT Standard Time, Greenwich Standard Time, W. Europe Standard Time, Central Europe Standard Time, Romance Standard Time, Central European Standard Time, W. Central Africa Standard Time, Namibia Standard Time, Jordan Standard Time, GTB Standard Time, Middle East Standard Time, Egypt Standard Time, Syria Standard Time, E. Europe Standard Time, South Africa Standard Time, FLE Standard Time, Turkey Standard Time, Israel Standard Time, Kaliningrad Standard Time, Libya Standard Time, Arabic Standard Time, Arab Standard Time, Belarus Standard Time, Russian Standard Time, E. Africa Standard Time, Iran Standard Time, Arabian Standard Time, Azerbaijan Standard Time, Russia Time Zone 3, Mauritius Standard Time, Georgian Standard Time, Caucasus Standard Time, Afghanistan Standard Time, West Asia Standard Time, Ekaterinburg Standard Time, Pakistan Standard Time, India Standard Time, Sri Lanka Standard Time, Nepal Standard Time, Central Asia Standard Time, Bangladesh Standard Time, N. Central Asia Standard Time, Myanmar Standard Time, SE Asia Standard Time, North Asia Standard Time, China Standard Time, North Asia East Standard Time, Singapore Standard Time, W. Australia Standard Time, Taipei Standard Time, Ulaanbaatar Standard Time, Tokyo Standard Time, Korea Standard Time, Yakutsk Standard Time, Cen. Australia Standard Time, AUS Central Standard Time, E. Australia Standard Time, AUS Eastern Standard Time, West Pacific Standard Time, Tasmania Standard Time, Magadan Standard Time, Vladivostok Standard Time, Russia Time Zone 10, Central Pacific Standard Time, Russia Time Zone 11, New Zealand Standard Time, UTC+12, Fiji Standard Time, Kamchatka Standard Time, Tonga Standard Time, Samoa Standard Time, Line Islands Standard Time",
            required=True,
        )

        days = cls._args_schema.profiles.Element.recurrence.schedule.days
        days.Element = AAZStrArg()

        hours = cls._args_schema.profiles.Element.recurrence.schedule.hours
        hours.Element = AAZIntArg()

        minutes = cls._args_schema.profiles.Element.recurrence.schedule.minutes
        minutes.Element = AAZIntArg()

        rules = cls._args_schema.profiles.Element.rules
        rules.Element = AAZObjectArg()

        _element = cls._args_schema.profiles.Element.rules.Element
        _element.metric_trigger = AAZObjectArg(
            options=["metric-trigger"],
            help="the trigger that results in a scaling action.",
            required=True,
        )
        _element.scale_action = AAZObjectArg(
            options=["scale-action"],
            help="the parameters for the scaling action.",
            required=True,
        )

        metric_trigger = cls._args_schema.profiles.Element.rules.Element.metric_trigger
        metric_trigger.dimensions = AAZListArg(
            options=["dimensions"],
            help="List of dimension conditions. For example: [{\"DimensionName\":\"AppName\",\"Operator\":\"Equals\",\"Values\":[\"App1\"]},{\"DimensionName\":\"Deployment\",\"Operator\":\"Equals\",\"Values\":[\"default\"]}].",
        )
        metric_trigger.divide_per_instance = AAZBoolArg(
            options=["divide-per-instance"],
            help="a value indicating whether metric should divide per instance.",
        )
        metric_trigger.metric_name = AAZStrArg(
            options=["metric-name"],
            help="the name of the metric that defines what the rule monitors.",
            required=True,
        )
        metric_trigger.metric_namespace = AAZStrArg(
            options=["metric-namespace"],
            help="the namespace of the metric that defines what the rule monitors.",
        )
        metric_trigger.metric_resource_location = AAZStrArg(
            options=["metric-resource-location"],
            help="the location of the resource the rule monitors.",
        )
        metric_trigger.metric_resource_uri = AAZStrArg(
            options=["metric-resource-uri"],
            help="the resource identifier of the resource the rule monitors.",
            required=True,
        )
        metric_trigger.operator = AAZStrArg(
            options=["operator"],
            help="the operator that is used to compare the metric data and the threshold.",
            required=True,
            enum={"Equals": "Equals", "GreaterThan": "GreaterThan", "GreaterThanOrEqual": "GreaterThanOrEqual", "LessThan": "LessThan", "LessThanOrEqual": "LessThanOrEqual", "NotEquals": "NotEquals"},
        )
        metric_trigger.statistic = AAZStrArg(
            options=["statistic"],
            help="the metric statistic type. How the metrics from multiple instances are combined.",
            required=True,
            enum={"Average": "Average", "Count": "Count", "Max": "Max", "Min": "Min", "Sum": "Sum"},
        )
        metric_trigger.threshold = AAZFloatArg(
            options=["threshold"],
            help="the threshold of the metric that triggers the scale action.",
            required=True,
        )
        metric_trigger.time_aggregation = AAZStrArg(
            options=["time-aggregation"],
            help="time aggregation type. How the data that is collected should be combined over time. The default value is Average.",
            required=True,
            enum={"Average": "Average", "Count": "Count", "Last": "Last", "Maximum": "Maximum", "Minimum": "Minimum", "Total": "Total"},
        )
        metric_trigger.time_grain = AAZDurationArg(
            options=["time-grain"],
            help="the granularity of metrics the rule monitors. Must be one of the predefined values returned from metric definitions for the metric. Must be between 12 hours and 1 minute.",
            required=True,
        )
        metric_trigger.time_window = AAZDurationArg(
            options=["time-window"],
            help="the range of time in which instance data is collected. This value must be greater than the delay in metric collection, which can vary from resource-to-resource. Must be between 12 hours and 5 minutes.",
            required=True,
        )

        dimensions = cls._args_schema.profiles.Element.rules.Element.metric_trigger.dimensions
        dimensions.Element = AAZObjectArg()

        _element = cls._args_schema.profiles.Element.rules.Element.metric_trigger.dimensions.Element
        _element.dimension_name = AAZStrArg(
            options=["dimension-name"],
            help="Name of the dimension.",
            required=True,
        )
        _element.operator = AAZStrArg(
            options=["operator"],
            help="the dimension operator. Only 'Equals' and 'NotEquals' are supported. 'Equals' being equal to any of the values. 'NotEquals' being not equal to all of the values",
            required=True,
            enum={"Equals": "Equals", "NotEquals": "NotEquals"},
        )
        _element.values = AAZListArg(
            options=["values"],
            help="list of dimension values. For example: [\"App1\",\"App2\"].",
            required=True,
        )

        values = cls._args_schema.profiles.Element.rules.Element.metric_trigger.dimensions.Element.values
        values.Element = AAZStrArg()

        scale_action = cls._args_schema.profiles.Element.rules.Element.scale_action
        scale_action.cooldown = AAZDurationArg(
            options=["cooldown"],
            help="the amount of time to wait since the last scaling action before this action occurs. It must be between 1 week and 1 minute in ISO 8601 format.",
            required=True,
        )
        scale_action.direction = AAZStrArg(
            options=["direction"],
            help="the scale direction. Whether the scaling action increases or decreases the number of instances.",
            required=True,
            enum={"Decrease": "Decrease", "Increase": "Increase", "None": "None"},
        )
        scale_action.type = AAZStrArg(
            options=["type"],
            help="the type of action that should occur when the scale rule fires.",
            required=True,
            enum={"ChangeCount": "ChangeCount", "ExactCount": "ExactCount", "PercentChangeCount": "PercentChangeCount", "ServiceAllowedNextValue": "ServiceAllowedNextValue"},
        )
        scale_action.value = AAZStrArg(
            options=["value"],
            help="the number of instances that are involved in the scaling action. This value must be 1 or greater. The default value is 1.",
            default="1",
        )
        return cls._args_schema

    def _execute_operations(self):
        self.pre_operations()
        self.AutoscaleSettingsCreateOrUpdate(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=True)
        return result

    class AutoscaleSettingsCreateOrUpdate(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200, 201]:
                return self.on_200_201(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Insights/autoscalesettings/{autoscaleSettingName}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "PUT"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "autoscaleSettingName", self.ctx.args.autoscale_name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2022-10-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Content-Type", "application/json",
                ),
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        @property
        def content(self):
            _content_value, _builder = self.new_content_builder(
                self.ctx.args,
                typ=AAZObjectType,
                typ_kwargs={"flags": {"required": True, "client_flatten": True}}
            )
            _builder.set_prop("location", AAZStrType, ".location", typ_kwargs={"flags": {"required": True}})
            _builder.set_prop("properties", AAZObjectType, ".", typ_kwargs={"flags": {"required": True, "client_flatten": True}})
            _builder.set_prop("tags", AAZDictType, ".tags")

            properties = _builder.get(".properties")
            if properties is not None:
                properties.set_prop("enabled", AAZBoolType, ".enabled")
                properties.set_prop("name", AAZStrType, ".autoscale_name")
                properties.set_prop("notifications", AAZListType, ".notifications")
                properties.set_prop("predictiveAutoscalePolicy", AAZObjectType)
                properties.set_prop("profiles", AAZListType, ".profiles", typ_kwargs={"flags": {"required": True}})
                properties.set_prop("targetResourceLocation", AAZStrType, ".target_resource_location")
                properties.set_prop("targetResourceUri", AAZStrType, ".target_resource_uri")

            notifications = _builder.get(".properties.notifications")
            if notifications is not None:
                notifications.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.notifications[]")
            if _elements is not None:
                _elements.set_prop("email", AAZObjectType, ".email")
                _elements.set_prop("operation", AAZStrType, ".operation", typ_kwargs={"flags": {"required": True}})
                _elements.set_prop("webhooks", AAZListType, ".webhooks")

            email = _builder.get(".properties.notifications[].email")
            if email is not None:
                email.set_prop("customEmails", AAZListType, ".custom_emails")
                email.set_prop("sendToSubscriptionAdministrator", AAZBoolType, ".send_to_subscription_administrator")
                email.set_prop("sendToSubscriptionCoAdministrators", AAZBoolType, ".send_to_subscription_co_administrators")

            custom_emails = _builder.get(".properties.notifications[].email.customEmails")
            if custom_emails is not None:
                custom_emails.set_elements(AAZStrType, ".")

            webhooks = _builder.get(".properties.notifications[].webhooks")
            if webhooks is not None:
                webhooks.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.notifications[].webhooks[]")
            if _elements is not None:
                _elements.set_prop("properties", AAZDictType, ".properties")
                _elements.set_prop("serviceUri", AAZStrType, ".service_uri")

            properties = _builder.get(".properties.notifications[].webhooks[].properties")
            if properties is not None:
                properties.set_elements(AAZStrType, ".")

            predictive_autoscale_policy = _builder.get(".properties.predictiveAutoscalePolicy")
            if predictive_autoscale_policy is not None:
                predictive_autoscale_policy.set_prop("scaleLookAheadTime", AAZStrType, ".scale_look_ahead_time")
                predictive_autoscale_policy.set_prop("scaleMode", AAZStrType, ".scale_mode", typ_kwargs={"flags": {"required": True}})

            profiles = _builder.get(".properties.profiles")
            if profiles is not None:
                profiles.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.profiles[]")
            if _elements is not None:
                _elements.set_prop("capacity", AAZObjectType, ".capacity", typ_kwargs={"flags": {"required": True}})
                _elements.set_prop("fixedDate", AAZObjectType, ".fixed_date")
                _elements.set_prop("name", AAZStrType, ".name", typ_kwargs={"flags": {"required": True}})
                _elements.set_prop("recurrence", AAZObjectType, ".recurrence")
                _elements.set_prop("rules", AAZListType, ".rules", typ_kwargs={"flags": {"required": True}})

            capacity = _builder.get(".properties.profiles[].capacity")
            if capacity is not None:
                capacity.set_prop("default", AAZStrType, ".default", typ_kwargs={"flags": {"required": True}})
                capacity.set_prop("maximum", AAZStrType, ".maximum", typ_kwargs={"flags": {"required": True}})
                capacity.set_prop("minimum", AAZStrType, ".minimum", typ_kwargs={"flags": {"required": True}})

            fixed_date = _builder.get(".properties.profiles[].fixedDate")
            if fixed_date is not None:
                fixed_date.set_prop("end", AAZStrType, ".end", typ_kwargs={"flags": {"required": True}})
                fixed_date.set_prop("start", AAZStrType, ".start", typ_kwargs={"flags": {"required": True}})
                fixed_date.set_prop("timeZone", AAZStrType, ".time_zone")

            recurrence = _builder.get(".properties.profiles[].recurrence")
            if recurrence is not None:
                recurrence.set_prop("frequency", AAZStrType, ".frequency", typ_kwargs={"flags": {"required": True}})
                recurrence.set_prop("schedule", AAZObjectType, ".schedule", typ_kwargs={"flags": {"required": True}})

            schedule = _builder.get(".properties.profiles[].recurrence.schedule")
            if schedule is not None:
                schedule.set_prop("days", AAZListType, ".days", typ_kwargs={"flags": {"required": True}})
                schedule.set_prop("hours", AAZListType, ".hours", typ_kwargs={"flags": {"required": True}})
                schedule.set_prop("minutes", AAZListType, ".minutes", typ_kwargs={"flags": {"required": True}})
                schedule.set_prop("timeZone", AAZStrType, ".time_zone", typ_kwargs={"flags": {"required": True}})

            days = _builder.get(".properties.profiles[].recurrence.schedule.days")
            if days is not None:
                days.set_elements(AAZStrType, ".")

            hours = _builder.get(".properties.profiles[].recurrence.schedule.hours")
            if hours is not None:
                hours.set_elements(AAZIntType, ".")

            minutes = _builder.get(".properties.profiles[].recurrence.schedule.minutes")
            if minutes is not None:
                minutes.set_elements(AAZIntType, ".")

            rules = _builder.get(".properties.profiles[].rules")
            if rules is not None:
                rules.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.profiles[].rules[]")
            if _elements is not None:
                _elements.set_prop("metricTrigger", AAZObjectType, ".metric_trigger", typ_kwargs={"flags": {"required": True}})
                _elements.set_prop("scaleAction", AAZObjectType, ".scale_action", typ_kwargs={"flags": {"required": True}})

            metric_trigger = _builder.get(".properties.profiles[].rules[].metricTrigger")
            if metric_trigger is not None:
                metric_trigger.set_prop("dimensions", AAZListType, ".dimensions")
                metric_trigger.set_prop("dividePerInstance", AAZBoolType, ".divide_per_instance")
                metric_trigger.set_prop("metricName", AAZStrType, ".metric_name", typ_kwargs={"flags": {"required": True}})
                metric_trigger.set_prop("metricNamespace", AAZStrType, ".metric_namespace")
                metric_trigger.set_prop("metricResourceLocation", AAZStrType, ".metric_resource_location")
                metric_trigger.set_prop("metricResourceUri", AAZStrType, ".metric_resource_uri", typ_kwargs={"flags": {"required": True}})
                metric_trigger.set_prop("operator", AAZStrType, ".operator", typ_kwargs={"flags": {"required": True}})
                metric_trigger.set_prop("statistic", AAZStrType, ".statistic", typ_kwargs={"flags": {"required": True}})
                metric_trigger.set_prop("threshold", AAZFloatType, ".threshold", typ_kwargs={"flags": {"required": True}})
                metric_trigger.set_prop("timeAggregation", AAZStrType, ".time_aggregation", typ_kwargs={"flags": {"required": True}})
                metric_trigger.set_prop("timeGrain", AAZStrType, ".time_grain", typ_kwargs={"flags": {"required": True}})
                metric_trigger.set_prop("timeWindow", AAZStrType, ".time_window", typ_kwargs={"flags": {"required": True}})

            dimensions = _builder.get(".properties.profiles[].rules[].metricTrigger.dimensions")
            if dimensions is not None:
                dimensions.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.profiles[].rules[].metricTrigger.dimensions[]")
            if _elements is not None:
                _elements.set_prop("DimensionName", AAZStrType, ".dimension_name", typ_kwargs={"flags": {"required": True}})
                _elements.set_prop("Operator", AAZStrType, ".operator", typ_kwargs={"flags": {"required": True}})
                _elements.set_prop("Values", AAZListType, ".values", typ_kwargs={"flags": {"required": True}})

            values = _builder.get(".properties.profiles[].rules[].metricTrigger.dimensions[].Values")
            if values is not None:
                values.set_elements(AAZStrType, ".")

            scale_action = _builder.get(".properties.profiles[].rules[].scaleAction")
            if scale_action is not None:
                scale_action.set_prop("cooldown", AAZStrType, ".cooldown", typ_kwargs={"flags": {"required": True}})
                scale_action.set_prop("direction", AAZStrType, ".direction", typ_kwargs={"flags": {"required": True}})
                scale_action.set_prop("type", AAZStrType, ".type", typ_kwargs={"flags": {"required": True}})
                scale_action.set_prop("value", AAZStrType, ".value")

            tags = _builder.get(".tags")
            if tags is not None:
                tags.set_elements(AAZStrType, ".")

            return self.serialize_content(_content_value)

        def on_200_201(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200_201
            )

        _schema_on_200_201 = None

        @classmethod
        def _build_schema_on_200_201(cls):
            if cls._schema_on_200_201 is not None:
                return cls._schema_on_200_201

            cls._schema_on_200_201 = AAZObjectType()

            _schema_on_200_201 = cls._schema_on_200_201
            _schema_on_200_201.id = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200_201.location = AAZStrType(
                flags={"required": True},
            )
            _schema_on_200_201.name = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200_201.properties = AAZObjectType(
                flags={"required": True, "client_flatten": True},
            )
            _schema_on_200_201.system_data = AAZObjectType(
                serialized_name="systemData",
                flags={"read_only": True},
            )
            _CreateHelper._build_schema_system_data_read(_schema_on_200_201.system_data)
            _schema_on_200_201.tags = AAZDictType()
            _schema_on_200_201.type = AAZStrType(
                flags={"read_only": True},
            )

            properties = cls._schema_on_200_201.properties
            properties.enabled = AAZBoolType()
            properties.name = AAZStrType()
            properties.notifications = AAZListType()
            properties.predictive_autoscale_policy = AAZObjectType(
                serialized_name="predictiveAutoscalePolicy",
            )
            properties.profiles = AAZListType(
                flags={"required": True},
            )
            properties.target_resource_location = AAZStrType(
                serialized_name="targetResourceLocation",
            )
            properties.target_resource_uri = AAZStrType(
                serialized_name="targetResourceUri",
            )

            notifications = cls._schema_on_200_201.properties.notifications
            notifications.Element = AAZObjectType()

            _element = cls._schema_on_200_201.properties.notifications.Element
            _element.email = AAZObjectType()
            _element.operation = AAZStrType(
                flags={"required": True},
            )
            _element.webhooks = AAZListType()

            email = cls._schema_on_200_201.properties.notifications.Element.email
            email.custom_emails = AAZListType(
                serialized_name="customEmails",
            )
            email.send_to_subscription_administrator = AAZBoolType(
                serialized_name="sendToSubscriptionAdministrator",
            )
            email.send_to_subscription_co_administrators = AAZBoolType(
                serialized_name="sendToSubscriptionCoAdministrators",
            )

            custom_emails = cls._schema_on_200_201.properties.notifications.Element.email.custom_emails
            custom_emails.Element = AAZStrType()

            webhooks = cls._schema_on_200_201.properties.notifications.Element.webhooks
            webhooks.Element = AAZObjectType()

            _element = cls._schema_on_200_201.properties.notifications.Element.webhooks.Element
            _element.properties = AAZDictType()
            _element.service_uri = AAZStrType(
                serialized_name="serviceUri",
            )

            properties = cls._schema_on_200_201.properties.notifications.Element.webhooks.Element.properties
            properties.Element = AAZStrType()

            predictive_autoscale_policy = cls._schema_on_200_201.properties.predictive_autoscale_policy
            predictive_autoscale_policy.scale_look_ahead_time = AAZStrType(
                serialized_name="scaleLookAheadTime",
            )
            predictive_autoscale_policy.scale_mode = AAZStrType(
                serialized_name="scaleMode",
                flags={"required": True},
            )

            profiles = cls._schema_on_200_201.properties.profiles
            profiles.Element = AAZObjectType()

            _element = cls._schema_on_200_201.properties.profiles.Element
            _element.capacity = AAZObjectType(
                flags={"required": True},
            )
            _element.fixed_date = AAZObjectType(
                serialized_name="fixedDate",
            )
            _element.name = AAZStrType(
                flags={"required": True},
            )
            _element.recurrence = AAZObjectType()
            _element.rules = AAZListType(
                flags={"required": True},
            )

            capacity = cls._schema_on_200_201.properties.profiles.Element.capacity
            capacity.default = AAZStrType(
                flags={"required": True},
            )
            capacity.maximum = AAZStrType(
                flags={"required": True},
            )
            capacity.minimum = AAZStrType(
                flags={"required": True},
            )

            fixed_date = cls._schema_on_200_201.properties.profiles.Element.fixed_date
            fixed_date.end = AAZStrType(
                flags={"required": True},
            )
            fixed_date.start = AAZStrType(
                flags={"required": True},
            )
            fixed_date.time_zone = AAZStrType(
                serialized_name="timeZone",
            )

            recurrence = cls._schema_on_200_201.properties.profiles.Element.recurrence
            recurrence.frequency = AAZStrType(
                flags={"required": True},
            )
            recurrence.schedule = AAZObjectType(
                flags={"required": True},
            )

            schedule = cls._schema_on_200_201.properties.profiles.Element.recurrence.schedule
            schedule.days = AAZListType(
                flags={"required": True},
            )
            schedule.hours = AAZListType(
                flags={"required": True},
            )
            schedule.minutes = AAZListType(
                flags={"required": True},
            )
            schedule.time_zone = AAZStrType(
                serialized_name="timeZone",
                flags={"required": True},
            )

            days = cls._schema_on_200_201.properties.profiles.Element.recurrence.schedule.days
            days.Element = AAZStrType()

            hours = cls._schema_on_200_201.properties.profiles.Element.recurrence.schedule.hours
            hours.Element = AAZIntType()

            minutes = cls._schema_on_200_201.properties.profiles.Element.recurrence.schedule.minutes
            minutes.Element = AAZIntType()

            rules = cls._schema_on_200_201.properties.profiles.Element.rules
            rules.Element = AAZObjectType()

            _element = cls._schema_on_200_201.properties.profiles.Element.rules.Element
            _element.metric_trigger = AAZObjectType(
                serialized_name="metricTrigger",
                flags={"required": True},
            )
            _element.scale_action = AAZObjectType(
                serialized_name="scaleAction",
                flags={"required": True},
            )

            metric_trigger = cls._schema_on_200_201.properties.profiles.Element.rules.Element.metric_trigger
            metric_trigger.dimensions = AAZListType()
            metric_trigger.divide_per_instance = AAZBoolType(
                serialized_name="dividePerInstance",
            )
            metric_trigger.metric_name = AAZStrType(
                serialized_name="metricName",
                flags={"required": True},
            )
            metric_trigger.metric_namespace = AAZStrType(
                serialized_name="metricNamespace",
            )
            metric_trigger.metric_resource_location = AAZStrType(
                serialized_name="metricResourceLocation",
            )
            metric_trigger.metric_resource_uri = AAZStrType(
                serialized_name="metricResourceUri",
                flags={"required": True},
            )
            metric_trigger.operator = AAZStrType(
                flags={"required": True},
            )
            metric_trigger.statistic = AAZStrType(
                flags={"required": True},
            )
            metric_trigger.threshold = AAZFloatType(
                flags={"required": True},
            )
            metric_trigger.time_aggregation = AAZStrType(
                serialized_name="timeAggregation",
                flags={"required": True},
            )
            metric_trigger.time_grain = AAZStrType(
                serialized_name="timeGrain",
                flags={"required": True},
            )
            metric_trigger.time_window = AAZStrType(
                serialized_name="timeWindow",
                flags={"required": True},
            )

            dimensions = cls._schema_on_200_201.properties.profiles.Element.rules.Element.metric_trigger.dimensions
            dimensions.Element = AAZObjectType()

            _element = cls._schema_on_200_201.properties.profiles.Element.rules.Element.metric_trigger.dimensions.Element
            _element.dimension_name = AAZStrType(
                serialized_name="DimensionName",
                flags={"required": True},
            )
            _element.operator = AAZStrType(
                serialized_name="Operator",
                flags={"required": True},
            )
            _element.values = AAZListType(
                serialized_name="Values",
                flags={"required": True},
            )

            values = cls._schema_on_200_201.properties.profiles.Element.rules.Element.metric_trigger.dimensions.Element.values
            values.Element = AAZStrType()

            scale_action = cls._schema_on_200_201.properties.profiles.Element.rules.Element.scale_action
            scale_action.cooldown = AAZStrType(
                flags={"required": True},
            )
            scale_action.direction = AAZStrType(
                flags={"required": True},
            )
            scale_action.type = AAZStrType(
                flags={"required": True},
            )
            scale_action.value = AAZStrType()

            tags = cls._schema_on_200_201.tags
            tags.Element = AAZStrType()

            return cls._schema_on_200_201


class _CreateHelper:
    """Helper class for Create"""

    _schema_system_data_read = None

    @classmethod
    def _build_schema_system_data_read(cls, _schema):
        if cls._schema_system_data_read is not None:
            _schema.created_at = cls._schema_system_data_read.created_at
            _schema.created_by = cls._schema_system_data_read.created_by
            _schema.created_by_type = cls._schema_system_data_read.created_by_type
            _schema.last_modified_at = cls._schema_system_data_read.last_modified_at
            _schema.last_modified_by = cls._schema_system_data_read.last_modified_by
            _schema.last_modified_by_type = cls._schema_system_data_read.last_modified_by_type
            return

        cls._schema_system_data_read = _schema_system_data_read = AAZObjectType(
            flags={"read_only": True}
        )

        system_data_read = _schema_system_data_read
        system_data_read.created_at = AAZStrType(
            serialized_name="createdAt",
        )
        system_data_read.created_by = AAZStrType(
            serialized_name="createdBy",
        )
        system_data_read.created_by_type = AAZStrType(
            serialized_name="createdByType",
        )
        system_data_read.last_modified_at = AAZStrType(
            serialized_name="lastModifiedAt",
        )
        system_data_read.last_modified_by = AAZStrType(
            serialized_name="lastModifiedBy",
        )
        system_data_read.last_modified_by_type = AAZStrType(
            serialized_name="lastModifiedByType",
        )

        _schema.created_at = cls._schema_system_data_read.created_at
        _schema.created_by = cls._schema_system_data_read.created_by
        _schema.created_by_type = cls._schema_system_data_read.created_by_type
        _schema.last_modified_at = cls._schema_system_data_read.last_modified_at
        _schema.last_modified_by = cls._schema_system_data_read.last_modified_by
        _schema.last_modified_by_type = cls._schema_system_data_read.last_modified_by_type


__all__ = ["Create"]
