// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"net/http"

	v1 "github.com/openshift/api/config/v1"
	"github.com/openshift/client-go/config/clientset/versioned/scheme"
	rest "k8s.io/client-go/rest"
)

type ConfigV1Interface interface {
	RESTClient() rest.Interface
	APIServersGetter
	AuthenticationsGetter
	BuildsGetter
	ClusterOperatorsGetter
	ClusterVersionsGetter
	ConsolesGetter
	DNSesGetter
	FeatureGatesGetter
	ImagesGetter
	ImageContentPoliciesGetter
	ImageDigestMirrorSetsGetter
	ImageTagMirrorSetsGetter
	InfrastructuresGetter
	IngressesGetter
	NetworksGetter
	NodesGetter
	OAuthsGetter
	OperatorHubsGetter
	ProjectsGetter
	ProxiesGetter
	SchedulersGetter
}

// ConfigV1Client is used to interact with features provided by the config.openshift.io group.
type ConfigV1Client struct {
	restClient rest.Interface
}

func (c *ConfigV1Client) APIServers() APIServerInterface {
	return newAPIServers(c)
}

func (c *ConfigV1Client) Authentications() AuthenticationInterface {
	return newAuthentications(c)
}

func (c *ConfigV1Client) Builds() BuildInterface {
	return newBuilds(c)
}

func (c *ConfigV1Client) ClusterOperators() ClusterOperatorInterface {
	return newClusterOperators(c)
}

func (c *ConfigV1Client) ClusterVersions() ClusterVersionInterface {
	return newClusterVersions(c)
}

func (c *ConfigV1Client) Consoles() ConsoleInterface {
	return newConsoles(c)
}

func (c *ConfigV1Client) DNSes() DNSInterface {
	return newDNSes(c)
}

func (c *ConfigV1Client) FeatureGates() FeatureGateInterface {
	return newFeatureGates(c)
}

func (c *ConfigV1Client) Images() ImageInterface {
	return newImages(c)
}

func (c *ConfigV1Client) ImageContentPolicies() ImageContentPolicyInterface {
	return newImageContentPolicies(c)
}

func (c *ConfigV1Client) ImageDigestMirrorSets() ImageDigestMirrorSetInterface {
	return newImageDigestMirrorSets(c)
}

func (c *ConfigV1Client) ImageTagMirrorSets() ImageTagMirrorSetInterface {
	return newImageTagMirrorSets(c)
}

func (c *ConfigV1Client) Infrastructures() InfrastructureInterface {
	return newInfrastructures(c)
}

func (c *ConfigV1Client) Ingresses() IngressInterface {
	return newIngresses(c)
}

func (c *ConfigV1Client) Networks() NetworkInterface {
	return newNetworks(c)
}

func (c *ConfigV1Client) Nodes() NodeInterface {
	return newNodes(c)
}

func (c *ConfigV1Client) OAuths() OAuthInterface {
	return newOAuths(c)
}

func (c *ConfigV1Client) OperatorHubs() OperatorHubInterface {
	return newOperatorHubs(c)
}

func (c *ConfigV1Client) Projects() ProjectInterface {
	return newProjects(c)
}

func (c *ConfigV1Client) Proxies() ProxyInterface {
	return newProxies(c)
}

func (c *ConfigV1Client) Schedulers() SchedulerInterface {
	return newSchedulers(c)
}

// NewForConfig creates a new ConfigV1Client for the given config.
// NewForConfig is equivalent to NewForConfigAndClient(c, httpClient),
// where httpClient was generated with rest.HTTPClientFor(c).
func NewForConfig(c *rest.Config) (*ConfigV1Client, error) {
	config := *c
	if err := setConfigDefaults(&config); err != nil {
		return nil, err
	}
	httpClient, err := rest.HTTPClientFor(&config)
	if err != nil {
		return nil, err
	}
	return NewForConfigAndClient(&config, httpClient)
}

// NewForConfigAndClient creates a new ConfigV1Client for the given config and http client.
// Note the http client provided takes precedence over the configured transport values.
func NewForConfigAndClient(c *rest.Config, h *http.Client) (*ConfigV1Client, error) {
	config := *c
	if err := setConfigDefaults(&config); err != nil {
		return nil, err
	}
	client, err := rest.RESTClientForConfigAndClient(&config, h)
	if err != nil {
		return nil, err
	}
	return &ConfigV1Client{client}, nil
}

// NewForConfigOrDie creates a new ConfigV1Client for the given config and
// panics if there is an error in the config.
func NewForConfigOrDie(c *rest.Config) *ConfigV1Client {
	client, err := NewForConfig(c)
	if err != nil {
		panic(err)
	}
	return client
}

// New creates a new ConfigV1Client for the given RESTClient.
func New(c rest.Interface) *ConfigV1Client {
	return &ConfigV1Client{c}
}

func setConfigDefaults(config *rest.Config) error {
	gv := v1.SchemeGroupVersion
	config.GroupVersion = &gv
	config.APIPath = "/apis"
	config.NegotiatedSerializer = scheme.Codecs.WithoutConversion()

	if config.UserAgent == "" {
		config.UserAgent = rest.DefaultKubernetesUserAgent()
	}

	return nil
}

// RESTClient returns a RESTClient that is used to communicate
// with API server by this client implementation.
func (c *ConfigV1Client) RESTClient() rest.Interface {
	if c == nil {
		return nil
	}
	return c.restClient
}
