# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
import sys
from typing import Any, Dict, List, Literal, Optional, TYPE_CHECKING, Union

from ... import _serialization

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore

if TYPE_CHECKING:
    from .. import models as _models
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object


class AccessUri(_serialization.Model):
    """A disk access SAS uri.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar access_sas: A SAS uri for accessing a disk.
    :vartype access_sas: str
    """

    _validation = {
        "access_sas": {"readonly": True},
    }

    _attribute_map = {
        "access_sas": {"key": "properties.output.accessSAS", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.access_sas = None


class AdditionalUnattendContent(_serialization.Model):
    """Specifies additional XML formatted information that can be included in the Unattend.xml file,
    which is used by Windows Setup. Contents are defined by setting name, component name, and the
    pass in which the content is applied.

    :ivar pass_name: The pass name. Currently, the only allowable value is OobeSystem. Default
     value is "OobeSystem".
    :vartype pass_name: str
    :ivar component_name: The component name. Currently, the only allowable value is
     Microsoft-Windows-Shell-Setup. Default value is "Microsoft-Windows-Shell-Setup".
    :vartype component_name: str
    :ivar setting_name: Specifies the name of the setting to which the content applies. Possible
     values are: FirstLogonCommands and AutoLogon. Known values are: "AutoLogon" and
     "FirstLogonCommands".
    :vartype setting_name: str or ~azure.mgmt.compute.v2016_04_30_preview.models.SettingNames
    :ivar content: Specifies the XML formatted content that is added to the unattend.xml file for
     the specified path and component. The XML must be less than 4KB and must include the root
     element for the setting or feature that is being inserted.
    :vartype content: str
    """

    _attribute_map = {
        "pass_name": {"key": "passName", "type": "str"},
        "component_name": {"key": "componentName", "type": "str"},
        "setting_name": {"key": "settingName", "type": "str"},
        "content": {"key": "content", "type": "str"},
    }

    def __init__(
        self,
        *,
        pass_name: Optional[Literal["OobeSystem"]] = None,
        component_name: Optional[Literal["Microsoft-Windows-Shell-Setup"]] = None,
        setting_name: Optional[Union[str, "_models.SettingNames"]] = None,
        content: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword pass_name: The pass name. Currently, the only allowable value is OobeSystem. Default
         value is "OobeSystem".
        :paramtype pass_name: str
        :keyword component_name: The component name. Currently, the only allowable value is
         Microsoft-Windows-Shell-Setup. Default value is "Microsoft-Windows-Shell-Setup".
        :paramtype component_name: str
        :keyword setting_name: Specifies the name of the setting to which the content applies. Possible
         values are: FirstLogonCommands and AutoLogon. Known values are: "AutoLogon" and
         "FirstLogonCommands".
        :paramtype setting_name: str or ~azure.mgmt.compute.v2016_04_30_preview.models.SettingNames
        :keyword content: Specifies the XML formatted content that is added to the unattend.xml file
         for the specified path and component. The XML must be less than 4KB and must include the root
         element for the setting or feature that is being inserted.
        :paramtype content: str
        """
        super().__init__(**kwargs)
        self.pass_name = pass_name
        self.component_name = component_name
        self.setting_name = setting_name
        self.content = content


class ApiEntityReference(_serialization.Model):
    """The API entity reference.

    :ivar id: The ARM resource id in the form of
     /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/...
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: The ARM resource id in the form of
         /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/...
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class ApiError(_serialization.Model):
    """Api error.

    :ivar details: The Api error details.
    :vartype details: list[~azure.mgmt.compute.v2016_04_30_preview.models.ApiErrorBase]
    :ivar innererror: The Api inner error.
    :vartype innererror: ~azure.mgmt.compute.v2016_04_30_preview.models.InnerError
    :ivar code: The error code.
    :vartype code: str
    :ivar target: The target of the particular error.
    :vartype target: str
    :ivar message: The error message.
    :vartype message: str
    """

    _attribute_map = {
        "details": {"key": "details", "type": "[ApiErrorBase]"},
        "innererror": {"key": "innererror", "type": "InnerError"},
        "code": {"key": "code", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(
        self,
        *,
        details: Optional[List["_models.ApiErrorBase"]] = None,
        innererror: Optional["_models.InnerError"] = None,
        code: Optional[str] = None,
        target: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword details: The Api error details.
        :paramtype details: list[~azure.mgmt.compute.v2016_04_30_preview.models.ApiErrorBase]
        :keyword innererror: The Api inner error.
        :paramtype innererror: ~azure.mgmt.compute.v2016_04_30_preview.models.InnerError
        :keyword code: The error code.
        :paramtype code: str
        :keyword target: The target of the particular error.
        :paramtype target: str
        :keyword message: The error message.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.details = details
        self.innererror = innererror
        self.code = code
        self.target = target
        self.message = message


class ApiErrorBase(_serialization.Model):
    """Api error base.

    :ivar code: The error code.
    :vartype code: str
    :ivar target: The target of the particular error.
    :vartype target: str
    :ivar message: The error message.
    :vartype message: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(
        self, *, code: Optional[str] = None, target: Optional[str] = None, message: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword code: The error code.
        :paramtype code: str
        :keyword target: The target of the particular error.
        :paramtype target: str
        :keyword message: The error message.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.target = target
        self.message = message


class Resource(_serialization.Model):
    """The Resource model definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags


class AvailabilitySet(Resource):
    """Specifies information about the availability set that the virtual machine should be assigned
    to. Virtual machines specified in the same availability set are allocated to different nodes to
    maximize availability. For more information about availability sets, see `Manage the
    availability of virtual machines
    <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-manage-availability?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_.
    :code:`<br>`:code:`<br>` For more information on Azure planned maintenance, see `Planned
    maintenance for virtual machines in Azure
    <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-planned-maintenance?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_
    :code:`<br>`:code:`<br>` Currently, a VM can only be added to availability set at creation
    time. An existing VM cannot be added to an availability set.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: Sku of the availability set.
    :vartype sku: ~azure.mgmt.compute.v2016_04_30_preview.models.Sku
    :ivar platform_update_domain_count: Update Domain count.
    :vartype platform_update_domain_count: int
    :ivar platform_fault_domain_count: Fault Domain count.
    :vartype platform_fault_domain_count: int
    :ivar virtual_machines: A list of references to all virtual machines in the availability set.
    :vartype virtual_machines: list[~azure.mgmt.compute.v2016_04_30_preview.models.SubResource]
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.compute.v2016_04_30_preview.models.InstanceViewStatus]
    :ivar managed: If the availability set supports managed disks.
    :vartype managed: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "statuses": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "Sku"},
        "platform_update_domain_count": {"key": "properties.platformUpdateDomainCount", "type": "int"},
        "platform_fault_domain_count": {"key": "properties.platformFaultDomainCount", "type": "int"},
        "virtual_machines": {"key": "properties.virtualMachines", "type": "[SubResource]"},
        "statuses": {"key": "properties.statuses", "type": "[InstanceViewStatus]"},
        "managed": {"key": "properties.managed", "type": "bool"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["_models.Sku"] = None,
        platform_update_domain_count: Optional[int] = None,
        platform_fault_domain_count: Optional[int] = None,
        virtual_machines: Optional[List["_models.SubResource"]] = None,
        managed: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: Sku of the availability set.
        :paramtype sku: ~azure.mgmt.compute.v2016_04_30_preview.models.Sku
        :keyword platform_update_domain_count: Update Domain count.
        :paramtype platform_update_domain_count: int
        :keyword platform_fault_domain_count: Fault Domain count.
        :paramtype platform_fault_domain_count: int
        :keyword virtual_machines: A list of references to all virtual machines in the availability
         set.
        :paramtype virtual_machines: list[~azure.mgmt.compute.v2016_04_30_preview.models.SubResource]
        :keyword managed: If the availability set supports managed disks.
        :paramtype managed: bool
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.sku = sku
        self.platform_update_domain_count = platform_update_domain_count
        self.platform_fault_domain_count = platform_fault_domain_count
        self.virtual_machines = virtual_machines
        self.statuses = None
        self.managed = managed


class AvailabilitySetListResult(_serialization.Model):
    """The List Availability Set operation response.

    All required parameters must be populated in order to send to server.

    :ivar value: The list of availability sets. Required.
    :vartype value: list[~azure.mgmt.compute.v2016_04_30_preview.models.AvailabilitySet]
    :ivar next_link: The URI to fetch the next page of AvailabilitySets. Call ListNext() with this
     URI to fetch the next page of AvailabilitySets.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AvailabilitySet]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.AvailabilitySet"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of availability sets. Required.
        :paramtype value: list[~azure.mgmt.compute.v2016_04_30_preview.models.AvailabilitySet]
        :keyword next_link: The URI to fetch the next page of AvailabilitySets. Call ListNext() with
         this URI to fetch the next page of AvailabilitySets.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class BootDiagnostics(_serialization.Model):
    """Boot Diagnostics is a debugging feature which allows you to view Console Output and Screenshot
    to diagnose VM status. :code:`<br>`:code:`<br>` You can easily view the output of your console
    log. :code:`<br>`:code:`<br>` Azure also enables you to see a screenshot of the VM from the
    hypervisor.

    :ivar enabled: Whether boot diagnostics should be enabled on the Virtual Machine.
    :vartype enabled: bool
    :ivar storage_uri: Uri of the storage account to use for placing the console output and
     screenshot.
    :vartype storage_uri: str
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "storage_uri": {"key": "storageUri", "type": "str"},
    }

    def __init__(self, *, enabled: Optional[bool] = None, storage_uri: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword enabled: Whether boot diagnostics should be enabled on the Virtual Machine.
        :paramtype enabled: bool
        :keyword storage_uri: Uri of the storage account to use for placing the console output and
         screenshot.
        :paramtype storage_uri: str
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.storage_uri = storage_uri


class BootDiagnosticsInstanceView(_serialization.Model):
    """The instance view of a virtual machine boot diagnostics.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar console_screenshot_blob_uri: The console screenshot blob URI.
    :vartype console_screenshot_blob_uri: str
    :ivar serial_console_log_blob_uri: The Linux serial console log blob Uri.
    :vartype serial_console_log_blob_uri: str
    """

    _validation = {
        "console_screenshot_blob_uri": {"readonly": True},
        "serial_console_log_blob_uri": {"readonly": True},
    }

    _attribute_map = {
        "console_screenshot_blob_uri": {"key": "consoleScreenshotBlobUri", "type": "str"},
        "serial_console_log_blob_uri": {"key": "serialConsoleLogBlobUri", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.console_screenshot_blob_uri = None
        self.serial_console_log_blob_uri = None


class ComputeLongRunningOperationProperties(_serialization.Model):
    """Compute-specific operation properties, including output.

    :ivar output: Operation output data (raw JSON).
    :vartype output: JSON
    """

    _attribute_map = {
        "output": {"key": "output", "type": "object"},
    }

    def __init__(self, *, output: Optional[JSON] = None, **kwargs: Any) -> None:
        """
        :keyword output: Operation output data (raw JSON).
        :paramtype output: JSON
        """
        super().__init__(**kwargs)
        self.output = output


class CreationData(_serialization.Model):
    """Data used when creating a disk.

    All required parameters must be populated in order to send to server.

    :ivar create_option: This enumerates the possible sources of a disk's creation. Required. Known
     values are: "Empty", "Attach", "FromImage", "Import", "Copy", "Restore", and "Import".
    :vartype create_option: str or ~azure.mgmt.compute.v2016_04_30_preview.models.DiskCreateOption
    :ivar storage_account_id: If createOption is Import, the Azure Resource Manager identifier of
     the storage account containing the blob to import as a disk. Required only if the blob is in a
     different subscription.
    :vartype storage_account_id: str
    :ivar image_reference: Disk source information.
    :vartype image_reference: ~azure.mgmt.compute.v2016_04_30_preview.models.ImageDiskReference
    :ivar source_uri: If createOption is Import, this is a SAS URI to a blob to be imported into a
     managed disk. If createOption is Copy, this is a relative Uri containing the id of the source
     snapshot to be copied into a managed disk.
    :vartype source_uri: str
    :ivar source_resource_id: If createOption is Copy, this is the ARM id of the source snapshot or
     disk. If createOption is Restore, this is the ARM-like id of the source disk restore point.
    :vartype source_resource_id: str
    """

    _validation = {
        "create_option": {"required": True},
    }

    _attribute_map = {
        "create_option": {"key": "createOption", "type": "str"},
        "storage_account_id": {"key": "storageAccountId", "type": "str"},
        "image_reference": {"key": "imageReference", "type": "ImageDiskReference"},
        "source_uri": {"key": "sourceUri", "type": "str"},
        "source_resource_id": {"key": "sourceResourceId", "type": "str"},
    }

    def __init__(
        self,
        *,
        create_option: Union[str, "_models.DiskCreateOption"],
        storage_account_id: Optional[str] = None,
        image_reference: Optional["_models.ImageDiskReference"] = None,
        source_uri: Optional[str] = None,
        source_resource_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword create_option: This enumerates the possible sources of a disk's creation. Required.
         Known values are: "Empty", "Attach", "FromImage", "Import", "Copy", "Restore", and "Import".
        :paramtype create_option: str or
         ~azure.mgmt.compute.v2016_04_30_preview.models.DiskCreateOption
        :keyword storage_account_id: If createOption is Import, the Azure Resource Manager identifier
         of the storage account containing the blob to import as a disk. Required only if the blob is in
         a different subscription.
        :paramtype storage_account_id: str
        :keyword image_reference: Disk source information.
        :paramtype image_reference: ~azure.mgmt.compute.v2016_04_30_preview.models.ImageDiskReference
        :keyword source_uri: If createOption is Import, this is a SAS URI to a blob to be imported into
         a managed disk. If createOption is Copy, this is a relative Uri containing the id of the source
         snapshot to be copied into a managed disk.
        :paramtype source_uri: str
        :keyword source_resource_id: If createOption is Copy, this is the ARM id of the source snapshot
         or disk. If createOption is Restore, this is the ARM-like id of the source disk restore point.
        :paramtype source_resource_id: str
        """
        super().__init__(**kwargs)
        self.create_option = create_option
        self.storage_account_id = storage_account_id
        self.image_reference = image_reference
        self.source_uri = source_uri
        self.source_resource_id = source_resource_id


class DataDisk(_serialization.Model):
    """Describes a data disk.

    All required parameters must be populated in order to send to server.

    :ivar lun: Specifies the logical unit number of the data disk. This value is used to identify
     data disks within the VM and therefore must be unique for each data disk attached to a VM.
     Required.
    :vartype lun: int
    :ivar name: The disk name.
    :vartype name: str
    :ivar vhd: The virtual hard disk.
    :vartype vhd: ~azure.mgmt.compute.v2016_04_30_preview.models.VirtualHardDisk
    :ivar image: The source user image virtual hard disk. The virtual hard disk will be copied
     before being attached to the virtual machine. If SourceImage is provided, the destination
     virtual hard drive must not exist.
    :vartype image: ~azure.mgmt.compute.v2016_04_30_preview.models.VirtualHardDisk
    :ivar caching: Specifies the caching requirements. :code:`<br>`:code:`<br>` Possible values
     are: :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **ReadOnly**
     :code:`<br>`:code:`<br>` **ReadWrite** :code:`<br>`:code:`<br>` Default: **None for Standard
     storage. ReadOnly for Premium storage**. Known values are: "None", "ReadOnly", and "ReadWrite".
    :vartype caching: str or ~azure.mgmt.compute.v2016_04_30_preview.models.CachingTypes
    :ivar create_option: Specifies how the virtual machine should be
     created.:code:`<br>`:code:`<br>` Possible values are::code:`<br>`:code:`<br>` **Attach**
     \\u2013 This value is used when you are using a specialized disk to create the virtual
     machine.:code:`<br>`:code:`<br>` **FromImage** \\u2013 This value is used when you are using an
     image to create the virtual machine. If you are using a platform image, you also use the
     imageReference element described above. If you are using a marketplace image, you  also use the
     plan element previously described. Required. Known values are: "FromImage", "Empty", and
     "Attach".
    :vartype create_option: str or
     ~azure.mgmt.compute.v2016_04_30_preview.models.DiskCreateOptionTypes
    :ivar disk_size_gb: Specifies the size of an empty data disk in gigabytes. This element can be
     used to overwrite the size of the disk in a virtual machine image. :code:`<br>`:code:`<br>`
     This value cannot be larger than 1023 GB.
    :vartype disk_size_gb: int
    :ivar managed_disk: The managed disk parameters.
    :vartype managed_disk: ~azure.mgmt.compute.v2016_04_30_preview.models.ManagedDiskParameters
    """

    _validation = {
        "lun": {"required": True},
        "create_option": {"required": True},
    }

    _attribute_map = {
        "lun": {"key": "lun", "type": "int"},
        "name": {"key": "name", "type": "str"},
        "vhd": {"key": "vhd", "type": "VirtualHardDisk"},
        "image": {"key": "image", "type": "VirtualHardDisk"},
        "caching": {"key": "caching", "type": "str"},
        "create_option": {"key": "createOption", "type": "str"},
        "disk_size_gb": {"key": "diskSizeGB", "type": "int"},
        "managed_disk": {"key": "managedDisk", "type": "ManagedDiskParameters"},
    }

    def __init__(
        self,
        *,
        lun: int,
        create_option: Union[str, "_models.DiskCreateOptionTypes"],
        name: Optional[str] = None,
        vhd: Optional["_models.VirtualHardDisk"] = None,
        image: Optional["_models.VirtualHardDisk"] = None,
        caching: Optional[Union[str, "_models.CachingTypes"]] = None,
        disk_size_gb: Optional[int] = None,
        managed_disk: Optional["_models.ManagedDiskParameters"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword lun: Specifies the logical unit number of the data disk. This value is used to
         identify data disks within the VM and therefore must be unique for each data disk attached to a
         VM. Required.
        :paramtype lun: int
        :keyword name: The disk name.
        :paramtype name: str
        :keyword vhd: The virtual hard disk.
        :paramtype vhd: ~azure.mgmt.compute.v2016_04_30_preview.models.VirtualHardDisk
        :keyword image: The source user image virtual hard disk. The virtual hard disk will be copied
         before being attached to the virtual machine. If SourceImage is provided, the destination
         virtual hard drive must not exist.
        :paramtype image: ~azure.mgmt.compute.v2016_04_30_preview.models.VirtualHardDisk
        :keyword caching: Specifies the caching requirements. :code:`<br>`:code:`<br>` Possible values
         are: :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **ReadOnly**
         :code:`<br>`:code:`<br>` **ReadWrite** :code:`<br>`:code:`<br>` Default: **None for Standard
         storage. ReadOnly for Premium storage**. Known values are: "None", "ReadOnly", and "ReadWrite".
        :paramtype caching: str or ~azure.mgmt.compute.v2016_04_30_preview.models.CachingTypes
        :keyword create_option: Specifies how the virtual machine should be
         created.:code:`<br>`:code:`<br>` Possible values are::code:`<br>`:code:`<br>` **Attach**
         \\u2013 This value is used when you are using a specialized disk to create the virtual
         machine.:code:`<br>`:code:`<br>` **FromImage** \\u2013 This value is used when you are using an
         image to create the virtual machine. If you are using a platform image, you also use the
         imageReference element described above. If you are using a marketplace image, you  also use the
         plan element previously described. Required. Known values are: "FromImage", "Empty", and
         "Attach".
        :paramtype create_option: str or
         ~azure.mgmt.compute.v2016_04_30_preview.models.DiskCreateOptionTypes
        :keyword disk_size_gb: Specifies the size of an empty data disk in gigabytes. This element can
         be used to overwrite the size of the disk in a virtual machine image. :code:`<br>`:code:`<br>`
         This value cannot be larger than 1023 GB.
        :paramtype disk_size_gb: int
        :keyword managed_disk: The managed disk parameters.
        :paramtype managed_disk: ~azure.mgmt.compute.v2016_04_30_preview.models.ManagedDiskParameters
        """
        super().__init__(**kwargs)
        self.lun = lun
        self.name = name
        self.vhd = vhd
        self.image = image
        self.caching = caching
        self.create_option = create_option
        self.disk_size_gb = disk_size_gb
        self.managed_disk = managed_disk


class DataDiskImage(_serialization.Model):
    """Contains the data disk images information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar lun: Specifies the logical unit number of the data disk. This value is used to identify
     data disks within the VM and therefore must be unique for each data disk attached to a VM.
    :vartype lun: int
    """

    _validation = {
        "lun": {"readonly": True},
    }

    _attribute_map = {
        "lun": {"key": "lun", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.lun = None


class DiagnosticsProfile(_serialization.Model):
    """Specifies the boot diagnostic settings state. :code:`<br>`:code:`<br>`Minimum api-version:
    2015-06-15.

    :ivar boot_diagnostics: Boot Diagnostics is a debugging feature which allows you to view
     Console Output and Screenshot to diagnose VM status. :code:`<br>`:code:`<br>` You can easily
     view the output of your console log. :code:`<br>`:code:`<br>` Azure also enables you to see a
     screenshot of the VM from the hypervisor.
    :vartype boot_diagnostics: ~azure.mgmt.compute.v2016_04_30_preview.models.BootDiagnostics
    """

    _attribute_map = {
        "boot_diagnostics": {"key": "bootDiagnostics", "type": "BootDiagnostics"},
    }

    def __init__(self, *, boot_diagnostics: Optional["_models.BootDiagnostics"] = None, **kwargs: Any) -> None:
        """
        :keyword boot_diagnostics: Boot Diagnostics is a debugging feature which allows you to view
         Console Output and Screenshot to diagnose VM status. :code:`<br>`:code:`<br>` You can easily
         view the output of your console log. :code:`<br>`:code:`<br>` Azure also enables you to see a
         screenshot of the VM from the hypervisor.
        :paramtype boot_diagnostics: ~azure.mgmt.compute.v2016_04_30_preview.models.BootDiagnostics
        """
        super().__init__(**kwargs)
        self.boot_diagnostics = boot_diagnostics


class Disk(Resource):
    """Disk resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar account_type: the storage account type of the disk. Known values are: "Standard_LRS" and
     "Premium_LRS".
    :vartype account_type: str or
     ~azure.mgmt.compute.v2016_04_30_preview.models.StorageAccountTypes
    :ivar time_created: The time when the disk was created.
    :vartype time_created: ~datetime.datetime
    :ivar os_type: The Operating System type. Known values are: "Windows" and "Linux".
    :vartype os_type: str or ~azure.mgmt.compute.v2016_04_30_preview.models.OperatingSystemTypes
    :ivar creation_data: Disk source information. CreationData information cannot be changed after
     the disk has been created.
    :vartype creation_data: ~azure.mgmt.compute.v2016_04_30_preview.models.CreationData
    :ivar disk_size_gb: If creationData.createOption is Empty, this field is mandatory and it
     indicates the size of the VHD to create. If this field is present for updates or creation with
     other options, it indicates a resize. Resizes are only allowed if the disk is not attached to a
     running VM, and can only increase the disk's size.
    :vartype disk_size_gb: int
    :ivar encryption_settings: Encryption settings for disk or snapshot.
    :vartype encryption_settings: ~azure.mgmt.compute.v2016_04_30_preview.models.EncryptionSettings
    :ivar owner_id: A relative URI containing the VM id that has the disk attached.
    :vartype owner_id: str
    :ivar provisioning_state: The disk provisioning state.
    :vartype provisioning_state: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "time_created": {"readonly": True},
        "owner_id": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "account_type": {"key": "properties.accountType", "type": "str"},
        "time_created": {"key": "properties.timeCreated", "type": "iso-8601"},
        "os_type": {"key": "properties.osType", "type": "str"},
        "creation_data": {"key": "properties.creationData", "type": "CreationData"},
        "disk_size_gb": {"key": "properties.diskSizeGB", "type": "int"},
        "encryption_settings": {"key": "properties.encryptionSettings", "type": "EncryptionSettings"},
        "owner_id": {"key": "properties.ownerId", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        account_type: Optional[Union[str, "_models.StorageAccountTypes"]] = None,
        os_type: Optional[Union[str, "_models.OperatingSystemTypes"]] = None,
        creation_data: Optional["_models.CreationData"] = None,
        disk_size_gb: Optional[int] = None,
        encryption_settings: Optional["_models.EncryptionSettings"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword account_type: the storage account type of the disk. Known values are: "Standard_LRS"
         and "Premium_LRS".
        :paramtype account_type: str or
         ~azure.mgmt.compute.v2016_04_30_preview.models.StorageAccountTypes
        :keyword os_type: The Operating System type. Known values are: "Windows" and "Linux".
        :paramtype os_type: str or ~azure.mgmt.compute.v2016_04_30_preview.models.OperatingSystemTypes
        :keyword creation_data: Disk source information. CreationData information cannot be changed
         after the disk has been created.
        :paramtype creation_data: ~azure.mgmt.compute.v2016_04_30_preview.models.CreationData
        :keyword disk_size_gb: If creationData.createOption is Empty, this field is mandatory and it
         indicates the size of the VHD to create. If this field is present for updates or creation with
         other options, it indicates a resize. Resizes are only allowed if the disk is not attached to a
         running VM, and can only increase the disk's size.
        :paramtype disk_size_gb: int
        :keyword encryption_settings: Encryption settings for disk or snapshot.
        :paramtype encryption_settings:
         ~azure.mgmt.compute.v2016_04_30_preview.models.EncryptionSettings
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.account_type = account_type
        self.time_created = None
        self.os_type = os_type
        self.creation_data = creation_data
        self.disk_size_gb = disk_size_gb
        self.encryption_settings = encryption_settings
        self.owner_id = None
        self.provisioning_state = None


class DiskEncryptionSettings(_serialization.Model):
    """Describes a Encryption Settings for a Disk.

    :ivar disk_encryption_key: Specifies the location of the disk encryption key, which is a Key
     Vault Secret.
    :vartype disk_encryption_key:
     ~azure.mgmt.compute.v2016_04_30_preview.models.KeyVaultSecretReference
    :ivar key_encryption_key: Specifies the location of the key encryption key in Key Vault.
    :vartype key_encryption_key:
     ~azure.mgmt.compute.v2016_04_30_preview.models.KeyVaultKeyReference
    :ivar enabled: Specifies whether disk encryption should be enabled on the virtual machine.
    :vartype enabled: bool
    """

    _attribute_map = {
        "disk_encryption_key": {"key": "diskEncryptionKey", "type": "KeyVaultSecretReference"},
        "key_encryption_key": {"key": "keyEncryptionKey", "type": "KeyVaultKeyReference"},
        "enabled": {"key": "enabled", "type": "bool"},
    }

    def __init__(
        self,
        *,
        disk_encryption_key: Optional["_models.KeyVaultSecretReference"] = None,
        key_encryption_key: Optional["_models.KeyVaultKeyReference"] = None,
        enabled: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword disk_encryption_key: Specifies the location of the disk encryption key, which is a Key
         Vault Secret.
        :paramtype disk_encryption_key:
         ~azure.mgmt.compute.v2016_04_30_preview.models.KeyVaultSecretReference
        :keyword key_encryption_key: Specifies the location of the key encryption key in Key Vault.
        :paramtype key_encryption_key:
         ~azure.mgmt.compute.v2016_04_30_preview.models.KeyVaultKeyReference
        :keyword enabled: Specifies whether disk encryption should be enabled on the virtual machine.
        :paramtype enabled: bool
        """
        super().__init__(**kwargs)
        self.disk_encryption_key = disk_encryption_key
        self.key_encryption_key = key_encryption_key
        self.enabled = enabled


class DiskInstanceView(_serialization.Model):
    """The instance view of the disk.

    :ivar name: The disk name.
    :vartype name: str
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.compute.v2016_04_30_preview.models.InstanceViewStatus]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "statuses": {"key": "statuses", "type": "[InstanceViewStatus]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        statuses: Optional[List["_models.InstanceViewStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The disk name.
        :paramtype name: str
        :keyword statuses: The resource status information.
        :paramtype statuses: list[~azure.mgmt.compute.v2016_04_30_preview.models.InstanceViewStatus]
        """
        super().__init__(**kwargs)
        self.name = name
        self.statuses = statuses


class DiskList(_serialization.Model):
    """The List Disks operation response.

    All required parameters must be populated in order to send to server.

    :ivar value: A list of disks. Required.
    :vartype value: list[~azure.mgmt.compute.v2016_04_30_preview.models.Disk]
    :ivar next_link: the uri to fetch the next page of disks. Call ListNext() with this to fetch
     the next page of disks.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Disk]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.Disk"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: A list of disks. Required.
        :paramtype value: list[~azure.mgmt.compute.v2016_04_30_preview.models.Disk]
        :keyword next_link: the uri to fetch the next page of disks. Call ListNext() with this to fetch
         the next page of disks.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ResourceUpdate(_serialization.Model):
    """The Resource model definition.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class DiskUpdate(ResourceUpdate):
    """Disk update resource.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar account_type: the storage account type of the disk. Known values are: "Standard_LRS" and
     "Premium_LRS".
    :vartype account_type: str or
     ~azure.mgmt.compute.v2016_04_30_preview.models.StorageAccountTypes
    :ivar os_type: the Operating System type. Known values are: "Windows" and "Linux".
    :vartype os_type: str or ~azure.mgmt.compute.v2016_04_30_preview.models.OperatingSystemTypes
    :ivar creation_data: disk source information. CreationData information cannot be changed after
     the disk has been created.
    :vartype creation_data: ~azure.mgmt.compute.v2016_04_30_preview.models.CreationData
    :ivar disk_size_gb: If creationData.createOption is Empty, this field is mandatory and it
     indicates the size of the VHD to create. If this field is present for updates or creation with
     other options, it indicates a resize. Resizes are only allowed if the disk is not attached to a
     running VM, and can only increase the disk's size.
    :vartype disk_size_gb: int
    :ivar encryption_settings: Encryption settings for disk or snapshot.
    :vartype encryption_settings: ~azure.mgmt.compute.v2016_04_30_preview.models.EncryptionSettings
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "account_type": {"key": "properties.accountType", "type": "str"},
        "os_type": {"key": "properties.osType", "type": "str"},
        "creation_data": {"key": "properties.creationData", "type": "CreationData"},
        "disk_size_gb": {"key": "properties.diskSizeGB", "type": "int"},
        "encryption_settings": {"key": "properties.encryptionSettings", "type": "EncryptionSettings"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        account_type: Optional[Union[str, "_models.StorageAccountTypes"]] = None,
        os_type: Optional[Union[str, "_models.OperatingSystemTypes"]] = None,
        creation_data: Optional["_models.CreationData"] = None,
        disk_size_gb: Optional[int] = None,
        encryption_settings: Optional["_models.EncryptionSettings"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword account_type: the storage account type of the disk. Known values are: "Standard_LRS"
         and "Premium_LRS".
        :paramtype account_type: str or
         ~azure.mgmt.compute.v2016_04_30_preview.models.StorageAccountTypes
        :keyword os_type: the Operating System type. Known values are: "Windows" and "Linux".
        :paramtype os_type: str or ~azure.mgmt.compute.v2016_04_30_preview.models.OperatingSystemTypes
        :keyword creation_data: disk source information. CreationData information cannot be changed
         after the disk has been created.
        :paramtype creation_data: ~azure.mgmt.compute.v2016_04_30_preview.models.CreationData
        :keyword disk_size_gb: If creationData.createOption is Empty, this field is mandatory and it
         indicates the size of the VHD to create. If this field is present for updates or creation with
         other options, it indicates a resize. Resizes are only allowed if the disk is not attached to a
         running VM, and can only increase the disk's size.
        :paramtype disk_size_gb: int
        :keyword encryption_settings: Encryption settings for disk or snapshot.
        :paramtype encryption_settings:
         ~azure.mgmt.compute.v2016_04_30_preview.models.EncryptionSettings
        """
        super().__init__(tags=tags, **kwargs)
        self.account_type = account_type
        self.os_type = os_type
        self.creation_data = creation_data
        self.disk_size_gb = disk_size_gb
        self.encryption_settings = encryption_settings


class EncryptionSettings(_serialization.Model):
    """Encryption settings for disk or snapshot.

    :ivar enabled: Set this flag to true and provide DiskEncryptionKey and optional
     KeyEncryptionKey to enable encryption. Set this flag to false and remove DiskEncryptionKey and
     KeyEncryptionKey to disable encryption. If EncryptionSettings is null in the request object,
     the existing settings remain unchanged.
    :vartype enabled: bool
    :ivar disk_encryption_key: Key Vault Secret Url and vault id of the disk encryption key.
    :vartype disk_encryption_key:
     ~azure.mgmt.compute.v2016_04_30_preview.models.KeyVaultAndSecretReference
    :ivar key_encryption_key: Key Vault Key Url and vault id of the key encryption key.
    :vartype key_encryption_key:
     ~azure.mgmt.compute.v2016_04_30_preview.models.KeyVaultAndKeyReference
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "disk_encryption_key": {"key": "diskEncryptionKey", "type": "KeyVaultAndSecretReference"},
        "key_encryption_key": {"key": "keyEncryptionKey", "type": "KeyVaultAndKeyReference"},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        disk_encryption_key: Optional["_models.KeyVaultAndSecretReference"] = None,
        key_encryption_key: Optional["_models.KeyVaultAndKeyReference"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: Set this flag to true and provide DiskEncryptionKey and optional
         KeyEncryptionKey to enable encryption. Set this flag to false and remove DiskEncryptionKey and
         KeyEncryptionKey to disable encryption. If EncryptionSettings is null in the request object,
         the existing settings remain unchanged.
        :paramtype enabled: bool
        :keyword disk_encryption_key: Key Vault Secret Url and vault id of the disk encryption key.
        :paramtype disk_encryption_key:
         ~azure.mgmt.compute.v2016_04_30_preview.models.KeyVaultAndSecretReference
        :keyword key_encryption_key: Key Vault Key Url and vault id of the key encryption key.
        :paramtype key_encryption_key:
         ~azure.mgmt.compute.v2016_04_30_preview.models.KeyVaultAndKeyReference
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.disk_encryption_key = disk_encryption_key
        self.key_encryption_key = key_encryption_key


class GrantAccessData(_serialization.Model):
    """Data used for requesting a SAS.

    All required parameters must be populated in order to send to server.

    :ivar access: Required. Known values are: "None" and "Read".
    :vartype access: str or ~azure.mgmt.compute.v2016_04_30_preview.models.AccessLevel
    :ivar duration_in_seconds: Time duration in seconds until the SAS access expires. Required.
    :vartype duration_in_seconds: int
    """

    _validation = {
        "access": {"required": True},
        "duration_in_seconds": {"required": True},
    }

    _attribute_map = {
        "access": {"key": "access", "type": "str"},
        "duration_in_seconds": {"key": "durationInSeconds", "type": "int"},
    }

    def __init__(self, *, access: Union[str, "_models.AccessLevel"], duration_in_seconds: int, **kwargs: Any) -> None:
        """
        :keyword access: Required. Known values are: "None" and "Read".
        :paramtype access: str or ~azure.mgmt.compute.v2016_04_30_preview.models.AccessLevel
        :keyword duration_in_seconds: Time duration in seconds until the SAS access expires. Required.
        :paramtype duration_in_seconds: int
        """
        super().__init__(**kwargs)
        self.access = access
        self.duration_in_seconds = duration_in_seconds


class HardwareProfile(_serialization.Model):
    """Specifies the hardware settings for the virtual machine.

    :ivar vm_size: Specifies the size of the virtual machine. For more information about virtual
     machine sizes, see `Sizes for virtual machines
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-sizes?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_.  # pylint: disable=line-too-long
     :code:`<br>`:code:`<br>` The available VM sizes depend on region and availability set. For a
     list of available sizes use these APIs:  :code:`<br>`:code:`<br>` `List all available virtual
     machine sizes in an availability set <virtualmachines-list-sizes-availability-set.md>`_
     :code:`<br>`:code:`<br>` `List all available virtual machine sizes in a region
     <virtualmachines-list-sizes-region.md>`_ :code:`<br>`:code:`<br>` `List all available virtual
     machine sizes for resizing <virtualmachines-list-sizes-for-resizing.md>`_. Known values are:
     "Basic_A0", "Basic_A1", "Basic_A2", "Basic_A3", "Basic_A4", "Standard_A0", "Standard_A1",
     "Standard_A2", "Standard_A3", "Standard_A4", "Standard_A5", "Standard_A6", "Standard_A7",
     "Standard_A8", "Standard_A9", "Standard_A10", "Standard_A11", "Standard_D1", "Standard_D2",
     "Standard_D3", "Standard_D4", "Standard_D11", "Standard_D12", "Standard_D13", "Standard_D14",
     "Standard_D1_v2", "Standard_D2_v2", "Standard_D3_v2", "Standard_D4_v2", "Standard_D5_v2",
     "Standard_D11_v2", "Standard_D12_v2", "Standard_D13_v2", "Standard_D14_v2", "Standard_D15_v2",
     "Standard_DS1", "Standard_DS2", "Standard_DS3", "Standard_DS4", "Standard_DS11",
     "Standard_DS12", "Standard_DS13", "Standard_DS14", "Standard_DS1_v2", "Standard_DS2_v2",
     "Standard_DS3_v2", "Standard_DS4_v2", "Standard_DS5_v2", "Standard_DS11_v2",
     "Standard_DS12_v2", "Standard_DS13_v2", "Standard_DS14_v2", "Standard_DS15_v2", "Standard_G1",
     "Standard_G2", "Standard_G3", "Standard_G4", "Standard_G5", "Standard_GS1", "Standard_GS2",
     "Standard_GS3", "Standard_GS4", and "Standard_GS5".
    :vartype vm_size: str or ~azure.mgmt.compute.v2016_04_30_preview.models.VirtualMachineSizeTypes
    """

    _attribute_map = {
        "vm_size": {"key": "vmSize", "type": "str"},
    }

    def __init__(
        self, *, vm_size: Optional[Union[str, "_models.VirtualMachineSizeTypes"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword vm_size: Specifies the size of the virtual machine. For more information about virtual
         machine sizes, see `Sizes for virtual machines
         <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-sizes?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_.  # pylint: disable=line-too-long
         :code:`<br>`:code:`<br>` The available VM sizes depend on region and availability set. For a
         list of available sizes use these APIs:  :code:`<br>`:code:`<br>` `List all available virtual
         machine sizes in an availability set <virtualmachines-list-sizes-availability-set.md>`_
         :code:`<br>`:code:`<br>` `List all available virtual machine sizes in a region
         <virtualmachines-list-sizes-region.md>`_ :code:`<br>`:code:`<br>` `List all available virtual
         machine sizes for resizing <virtualmachines-list-sizes-for-resizing.md>`_. Known values are:
         "Basic_A0", "Basic_A1", "Basic_A2", "Basic_A3", "Basic_A4", "Standard_A0", "Standard_A1",
         "Standard_A2", "Standard_A3", "Standard_A4", "Standard_A5", "Standard_A6", "Standard_A7",
         "Standard_A8", "Standard_A9", "Standard_A10", "Standard_A11", "Standard_D1", "Standard_D2",
         "Standard_D3", "Standard_D4", "Standard_D11", "Standard_D12", "Standard_D13", "Standard_D14",
         "Standard_D1_v2", "Standard_D2_v2", "Standard_D3_v2", "Standard_D4_v2", "Standard_D5_v2",
         "Standard_D11_v2", "Standard_D12_v2", "Standard_D13_v2", "Standard_D14_v2", "Standard_D15_v2",
         "Standard_DS1", "Standard_DS2", "Standard_DS3", "Standard_DS4", "Standard_DS11",
         "Standard_DS12", "Standard_DS13", "Standard_DS14", "Standard_DS1_v2", "Standard_DS2_v2",
         "Standard_DS3_v2", "Standard_DS4_v2", "Standard_DS5_v2", "Standard_DS11_v2",
         "Standard_DS12_v2", "Standard_DS13_v2", "Standard_DS14_v2", "Standard_DS15_v2", "Standard_G1",
         "Standard_G2", "Standard_G3", "Standard_G4", "Standard_G5", "Standard_GS1", "Standard_GS2",
         "Standard_GS3", "Standard_GS4", and "Standard_GS5".
        :paramtype vm_size: str or
         ~azure.mgmt.compute.v2016_04_30_preview.models.VirtualMachineSizeTypes
        """
        super().__init__(**kwargs)
        self.vm_size = vm_size


class Image(Resource):
    """The source user image virtual hard disk. The virtual hard disk will be copied before being
    attached to the virtual machine. If SourceImage is provided, the destination virtual hard drive
    must not exist.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar source_virtual_machine: The source virtual machine from which Image is created.
    :vartype source_virtual_machine: ~azure.mgmt.compute.v2016_04_30_preview.models.SubResource
    :ivar storage_profile: Specifies the storage settings for the virtual machine disks.
    :vartype storage_profile: ~azure.mgmt.compute.v2016_04_30_preview.models.ImageStorageProfile
    :ivar provisioning_state: The provisioning state.
    :vartype provisioning_state: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "source_virtual_machine": {"key": "properties.sourceVirtualMachine", "type": "SubResource"},
        "storage_profile": {"key": "properties.storageProfile", "type": "ImageStorageProfile"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        source_virtual_machine: Optional["_models.SubResource"] = None,
        storage_profile: Optional["_models.ImageStorageProfile"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword source_virtual_machine: The source virtual machine from which Image is created.
        :paramtype source_virtual_machine: ~azure.mgmt.compute.v2016_04_30_preview.models.SubResource
        :keyword storage_profile: Specifies the storage settings for the virtual machine disks.
        :paramtype storage_profile: ~azure.mgmt.compute.v2016_04_30_preview.models.ImageStorageProfile
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.source_virtual_machine = source_virtual_machine
        self.storage_profile = storage_profile
        self.provisioning_state = None


class ImageDataDisk(_serialization.Model):
    """Describes a data disk.

    All required parameters must be populated in order to send to server.

    :ivar lun: Specifies the logical unit number of the data disk. This value is used to identify
     data disks within the VM and therefore must be unique for each data disk attached to a VM.
     Required.
    :vartype lun: int
    :ivar snapshot: The snapshot.
    :vartype snapshot: ~azure.mgmt.compute.v2016_04_30_preview.models.SubResource
    :ivar managed_disk: The managedDisk.
    :vartype managed_disk: ~azure.mgmt.compute.v2016_04_30_preview.models.SubResource
    :ivar blob_uri: The Virtual Hard Disk.
    :vartype blob_uri: str
    :ivar caching: Specifies the caching requirements. :code:`<br>`:code:`<br>` Possible values
     are: :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **ReadOnly**
     :code:`<br>`:code:`<br>` **ReadWrite** :code:`<br>`:code:`<br>` Default: **None for Standard
     storage. ReadOnly for Premium storage**. Known values are: "None", "ReadOnly", and "ReadWrite".
    :vartype caching: str or ~azure.mgmt.compute.v2016_04_30_preview.models.CachingTypes
    :ivar disk_size_gb: Specifies the size of empty data disks in gigabytes. This element can be
     used to overwrite the name of the disk in a virtual machine image. :code:`<br>`:code:`<br>`
     This value cannot be larger than 1023 GB.
    :vartype disk_size_gb: int
    """

    _validation = {
        "lun": {"required": True},
    }

    _attribute_map = {
        "lun": {"key": "lun", "type": "int"},
        "snapshot": {"key": "snapshot", "type": "SubResource"},
        "managed_disk": {"key": "managedDisk", "type": "SubResource"},
        "blob_uri": {"key": "blobUri", "type": "str"},
        "caching": {"key": "caching", "type": "str"},
        "disk_size_gb": {"key": "diskSizeGB", "type": "int"},
    }

    def __init__(
        self,
        *,
        lun: int,
        snapshot: Optional["_models.SubResource"] = None,
        managed_disk: Optional["_models.SubResource"] = None,
        blob_uri: Optional[str] = None,
        caching: Optional[Union[str, "_models.CachingTypes"]] = None,
        disk_size_gb: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword lun: Specifies the logical unit number of the data disk. This value is used to
         identify data disks within the VM and therefore must be unique for each data disk attached to a
         VM. Required.
        :paramtype lun: int
        :keyword snapshot: The snapshot.
        :paramtype snapshot: ~azure.mgmt.compute.v2016_04_30_preview.models.SubResource
        :keyword managed_disk: The managedDisk.
        :paramtype managed_disk: ~azure.mgmt.compute.v2016_04_30_preview.models.SubResource
        :keyword blob_uri: The Virtual Hard Disk.
        :paramtype blob_uri: str
        :keyword caching: Specifies the caching requirements. :code:`<br>`:code:`<br>` Possible values
         are: :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **ReadOnly**
         :code:`<br>`:code:`<br>` **ReadWrite** :code:`<br>`:code:`<br>` Default: **None for Standard
         storage. ReadOnly for Premium storage**. Known values are: "None", "ReadOnly", and "ReadWrite".
        :paramtype caching: str or ~azure.mgmt.compute.v2016_04_30_preview.models.CachingTypes
        :keyword disk_size_gb: Specifies the size of empty data disks in gigabytes. This element can be
         used to overwrite the name of the disk in a virtual machine image. :code:`<br>`:code:`<br>`
         This value cannot be larger than 1023 GB.
        :paramtype disk_size_gb: int
        """
        super().__init__(**kwargs)
        self.lun = lun
        self.snapshot = snapshot
        self.managed_disk = managed_disk
        self.blob_uri = blob_uri
        self.caching = caching
        self.disk_size_gb = disk_size_gb


class ImageDiskReference(_serialization.Model):
    """The source image used for creating the disk.

    All required parameters must be populated in order to send to server.

    :ivar id: A relative uri containing either a Platform Image Repository or user image reference.
     Required.
    :vartype id: str
    :ivar lun: If the disk is created from an image's data disk, this is an index that indicates
     which of the data disks in the image to use. For OS disks, this field is null.
    :vartype lun: int
    """

    _validation = {
        "id": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "lun": {"key": "lun", "type": "int"},
    }

    def __init__(
        self, *, id: str, lun: Optional[int] = None, **kwargs: Any  # pylint: disable=redefined-builtin
    ) -> None:
        """
        :keyword id: A relative uri containing either a Platform Image Repository or user image
         reference. Required.
        :paramtype id: str
        :keyword lun: If the disk is created from an image's data disk, this is an index that indicates
         which of the data disks in the image to use. For OS disks, this field is null.
        :paramtype lun: int
        """
        super().__init__(**kwargs)
        self.id = id
        self.lun = lun


class ImageListResult(_serialization.Model):
    """The List Image operation response.

    All required parameters must be populated in order to send to server.

    :ivar value: The list of Images. Required.
    :vartype value: list[~azure.mgmt.compute.v2016_04_30_preview.models.Image]
    :ivar next_link: The uri to fetch the next page of Images. Call ListNext() with this to fetch
     the next page of Images.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Image]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.Image"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The list of Images. Required.
        :paramtype value: list[~azure.mgmt.compute.v2016_04_30_preview.models.Image]
        :keyword next_link: The uri to fetch the next page of Images. Call ListNext() with this to
         fetch the next page of Images.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ImageOSDisk(_serialization.Model):
    """Describes an Operating System disk.

    All required parameters must be populated in order to send to server.

    :ivar os_type: This property allows you to specify the type of the OS that is included in the
     disk if creating a VM from a custom image. :code:`<br>`:code:`<br>` Possible values are:
     :code:`<br>`:code:`<br>` **Windows** :code:`<br>`:code:`<br>` **Linux**. Required. Known values
     are: "Windows" and "Linux".
    :vartype os_type: str or ~azure.mgmt.compute.v2016_04_30_preview.models.OperatingSystemTypes
    :ivar os_state: The OS State. Required. Known values are: "Generalized" and "Specialized".
    :vartype os_state: str or
     ~azure.mgmt.compute.v2016_04_30_preview.models.OperatingSystemStateTypes
    :ivar snapshot: The snapshot.
    :vartype snapshot: ~azure.mgmt.compute.v2016_04_30_preview.models.SubResource
    :ivar managed_disk: The managedDisk.
    :vartype managed_disk: ~azure.mgmt.compute.v2016_04_30_preview.models.SubResource
    :ivar blob_uri: The Virtual Hard Disk.
    :vartype blob_uri: str
    :ivar caching: Specifies the caching requirements. :code:`<br>`:code:`<br>` Possible values
     are: :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **ReadOnly**
     :code:`<br>`:code:`<br>` **ReadWrite** :code:`<br>`:code:`<br>` Default: **None for Standard
     storage. ReadOnly for Premium storage**. Known values are: "None", "ReadOnly", and "ReadWrite".
    :vartype caching: str or ~azure.mgmt.compute.v2016_04_30_preview.models.CachingTypes
    :ivar disk_size_gb: Specifies the size of empty data disks in gigabytes. This element can be
     used to overwrite the name of the disk in a virtual machine image. :code:`<br>`:code:`<br>`
     This value cannot be larger than 1023 GB.
    :vartype disk_size_gb: int
    """

    _validation = {
        "os_type": {"required": True},
        "os_state": {"required": True},
    }

    _attribute_map = {
        "os_type": {"key": "osType", "type": "str"},
        "os_state": {"key": "osState", "type": "str"},
        "snapshot": {"key": "snapshot", "type": "SubResource"},
        "managed_disk": {"key": "managedDisk", "type": "SubResource"},
        "blob_uri": {"key": "blobUri", "type": "str"},
        "caching": {"key": "caching", "type": "str"},
        "disk_size_gb": {"key": "diskSizeGB", "type": "int"},
    }

    def __init__(
        self,
        *,
        os_type: Union[str, "_models.OperatingSystemTypes"],
        os_state: Union[str, "_models.OperatingSystemStateTypes"],
        snapshot: Optional["_models.SubResource"] = None,
        managed_disk: Optional["_models.SubResource"] = None,
        blob_uri: Optional[str] = None,
        caching: Optional[Union[str, "_models.CachingTypes"]] = None,
        disk_size_gb: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword os_type: This property allows you to specify the type of the OS that is included in
         the disk if creating a VM from a custom image. :code:`<br>`:code:`<br>` Possible values are:
         :code:`<br>`:code:`<br>` **Windows** :code:`<br>`:code:`<br>` **Linux**. Required. Known values
         are: "Windows" and "Linux".
        :paramtype os_type: str or ~azure.mgmt.compute.v2016_04_30_preview.models.OperatingSystemTypes
        :keyword os_state: The OS State. Required. Known values are: "Generalized" and "Specialized".
        :paramtype os_state: str or
         ~azure.mgmt.compute.v2016_04_30_preview.models.OperatingSystemStateTypes
        :keyword snapshot: The snapshot.
        :paramtype snapshot: ~azure.mgmt.compute.v2016_04_30_preview.models.SubResource
        :keyword managed_disk: The managedDisk.
        :paramtype managed_disk: ~azure.mgmt.compute.v2016_04_30_preview.models.SubResource
        :keyword blob_uri: The Virtual Hard Disk.
        :paramtype blob_uri: str
        :keyword caching: Specifies the caching requirements. :code:`<br>`:code:`<br>` Possible values
         are: :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **ReadOnly**
         :code:`<br>`:code:`<br>` **ReadWrite** :code:`<br>`:code:`<br>` Default: **None for Standard
         storage. ReadOnly for Premium storage**. Known values are: "None", "ReadOnly", and "ReadWrite".
        :paramtype caching: str or ~azure.mgmt.compute.v2016_04_30_preview.models.CachingTypes
        :keyword disk_size_gb: Specifies the size of empty data disks in gigabytes. This element can be
         used to overwrite the name of the disk in a virtual machine image. :code:`<br>`:code:`<br>`
         This value cannot be larger than 1023 GB.
        :paramtype disk_size_gb: int
        """
        super().__init__(**kwargs)
        self.os_type = os_type
        self.os_state = os_state
        self.snapshot = snapshot
        self.managed_disk = managed_disk
        self.blob_uri = blob_uri
        self.caching = caching
        self.disk_size_gb = disk_size_gb


class SubResource(_serialization.Model):
    """SubResource.

    :ivar id: Resource Id.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Resource Id.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class ImageReference(SubResource):
    """Specifies information about the image to use. You can specify information about platform
    images, marketplace images, or virtual machine images. This element is required when you want
    to use a platform image, marketplace image, or virtual machine image, but is not used in other
    creation operations.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar publisher: The image publisher.
    :vartype publisher: str
    :ivar offer: Specifies the offer of the platform image or marketplace image used to create the
     virtual machine.
    :vartype offer: str
    :ivar sku: The image SKU.
    :vartype sku: str
    :ivar version: Specifies the version of the platform image or marketplace image used to create
     the virtual machine. The allowed formats are Major.Minor.Build or 'latest'. Major, Minor, and
     Build are decimal numbers. Specify 'latest' to use the latest version of an image available at
     deploy time. Even if you use 'latest', the VM image will not automatically update after deploy
     time even if a new version becomes available.
    :vartype version: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "publisher": {"key": "publisher", "type": "str"},
        "offer": {"key": "offer", "type": "str"},
        "sku": {"key": "sku", "type": "str"},
        "version": {"key": "version", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        publisher: Optional[str] = None,
        offer: Optional[str] = None,
        sku: Optional[str] = None,
        version: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Id.
        :paramtype id: str
        :keyword publisher: The image publisher.
        :paramtype publisher: str
        :keyword offer: Specifies the offer of the platform image or marketplace image used to create
         the virtual machine.
        :paramtype offer: str
        :keyword sku: The image SKU.
        :paramtype sku: str
        :keyword version: Specifies the version of the platform image or marketplace image used to
         create the virtual machine. The allowed formats are Major.Minor.Build or 'latest'. Major,
         Minor, and Build are decimal numbers. Specify 'latest' to use the latest version of an image
         available at deploy time. Even if you use 'latest', the VM image will not automatically update
         after deploy time even if a new version becomes available.
        :paramtype version: str
        """
        super().__init__(id=id, **kwargs)
        self.publisher = publisher
        self.offer = offer
        self.sku = sku
        self.version = version


class ImageStorageProfile(_serialization.Model):
    """Describes a storage profile.

    All required parameters must be populated in order to send to server.

    :ivar os_disk: Specifies information about the operating system disk used by the virtual
     machine. :code:`<br>`:code:`<br>` For more information about disks, see `About disks and VHDs
     for Azure virtual machines
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_.  # pylint: disable=line-too-long
     Required.
    :vartype os_disk: ~azure.mgmt.compute.v2016_04_30_preview.models.ImageOSDisk
    :ivar data_disks: Specifies the parameters that are used to add a data disk to a virtual
     machine. :code:`<br>`:code:`<br>` For more information about disks, see `About disks and VHDs
     for Azure virtual machines
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_.  # pylint: disable=line-too-long
    :vartype data_disks: list[~azure.mgmt.compute.v2016_04_30_preview.models.ImageDataDisk]
    """

    _validation = {
        "os_disk": {"required": True},
    }

    _attribute_map = {
        "os_disk": {"key": "osDisk", "type": "ImageOSDisk"},
        "data_disks": {"key": "dataDisks", "type": "[ImageDataDisk]"},
    }

    def __init__(
        self,
        *,
        os_disk: "_models.ImageOSDisk",
        data_disks: Optional[List["_models.ImageDataDisk"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword os_disk: Specifies information about the operating system disk used by the virtual
         machine. :code:`<br>`:code:`<br>` For more information about disks, see `About disks and VHDs
         for Azure virtual machines
         <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_.  # pylint: disable=line-too-long
         Required.
        :paramtype os_disk: ~azure.mgmt.compute.v2016_04_30_preview.models.ImageOSDisk
        :keyword data_disks: Specifies the parameters that are used to add a data disk to a virtual
         machine. :code:`<br>`:code:`<br>` For more information about disks, see `About disks and VHDs
         for Azure virtual machines
         <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_.  # pylint: disable=line-too-long
        :paramtype data_disks: list[~azure.mgmt.compute.v2016_04_30_preview.models.ImageDataDisk]
        """
        super().__init__(**kwargs)
        self.os_disk = os_disk
        self.data_disks = data_disks


class InnerError(_serialization.Model):
    """Inner error details.

    :ivar exceptiontype: The exception type.
    :vartype exceptiontype: str
    :ivar errordetail: The internal error message or exception dump.
    :vartype errordetail: str
    """

    _attribute_map = {
        "exceptiontype": {"key": "exceptiontype", "type": "str"},
        "errordetail": {"key": "errordetail", "type": "str"},
    }

    def __init__(
        self, *, exceptiontype: Optional[str] = None, errordetail: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword exceptiontype: The exception type.
        :paramtype exceptiontype: str
        :keyword errordetail: The internal error message or exception dump.
        :paramtype errordetail: str
        """
        super().__init__(**kwargs)
        self.exceptiontype = exceptiontype
        self.errordetail = errordetail


class InstanceViewStatus(_serialization.Model):
    """Instance view status.

    :ivar code: The status code.
    :vartype code: str
    :ivar level: The level code. Known values are: "Info", "Warning", and "Error".
    :vartype level: str or ~azure.mgmt.compute.v2016_04_30_preview.models.StatusLevelTypes
    :ivar display_status: The short localizable label for the status.
    :vartype display_status: str
    :ivar message: The detailed status message, including for alerts and error messages.
    :vartype message: str
    :ivar time: The time of the status.
    :vartype time: ~datetime.datetime
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "level": {"key": "level", "type": "str"},
        "display_status": {"key": "displayStatus", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "time": {"key": "time", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        level: Optional[Union[str, "_models.StatusLevelTypes"]] = None,
        display_status: Optional[str] = None,
        message: Optional[str] = None,
        time: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword code: The status code.
        :paramtype code: str
        :keyword level: The level code. Known values are: "Info", "Warning", and "Error".
        :paramtype level: str or ~azure.mgmt.compute.v2016_04_30_preview.models.StatusLevelTypes
        :keyword display_status: The short localizable label for the status.
        :paramtype display_status: str
        :keyword message: The detailed status message, including for alerts and error messages.
        :paramtype message: str
        :keyword time: The time of the status.
        :paramtype time: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.code = code
        self.level = level
        self.display_status = display_status
        self.message = message
        self.time = time


class KeyVaultAndKeyReference(_serialization.Model):
    """Key Vault Key Url and vault id of KeK, KeK is optional and when provided is used to unwrap the
    encryptionKey.

    All required parameters must be populated in order to send to server.

    :ivar source_vault: Resource id of the KeyVault containing the key or secret. Required.
    :vartype source_vault: ~azure.mgmt.compute.v2016_04_30_preview.models.SourceVault
    :ivar key_url: Url pointing to a key or secret in KeyVault. Required.
    :vartype key_url: str
    """

    _validation = {
        "source_vault": {"required": True},
        "key_url": {"required": True},
    }

    _attribute_map = {
        "source_vault": {"key": "sourceVault", "type": "SourceVault"},
        "key_url": {"key": "keyUrl", "type": "str"},
    }

    def __init__(self, *, source_vault: "_models.SourceVault", key_url: str, **kwargs: Any) -> None:
        """
        :keyword source_vault: Resource id of the KeyVault containing the key or secret. Required.
        :paramtype source_vault: ~azure.mgmt.compute.v2016_04_30_preview.models.SourceVault
        :keyword key_url: Url pointing to a key or secret in KeyVault. Required.
        :paramtype key_url: str
        """
        super().__init__(**kwargs)
        self.source_vault = source_vault
        self.key_url = key_url


class KeyVaultAndSecretReference(_serialization.Model):
    """Key Vault Secret Url and vault id of the encryption key.

    All required parameters must be populated in order to send to server.

    :ivar source_vault: Resource id of the KeyVault containing the key or secret. Required.
    :vartype source_vault: ~azure.mgmt.compute.v2016_04_30_preview.models.SourceVault
    :ivar secret_url: Url pointing to a key or secret in KeyVault. Required.
    :vartype secret_url: str
    """

    _validation = {
        "source_vault": {"required": True},
        "secret_url": {"required": True},
    }

    _attribute_map = {
        "source_vault": {"key": "sourceVault", "type": "SourceVault"},
        "secret_url": {"key": "secretUrl", "type": "str"},
    }

    def __init__(self, *, source_vault: "_models.SourceVault", secret_url: str, **kwargs: Any) -> None:
        """
        :keyword source_vault: Resource id of the KeyVault containing the key or secret. Required.
        :paramtype source_vault: ~azure.mgmt.compute.v2016_04_30_preview.models.SourceVault
        :keyword secret_url: Url pointing to a key or secret in KeyVault. Required.
        :paramtype secret_url: str
        """
        super().__init__(**kwargs)
        self.source_vault = source_vault
        self.secret_url = secret_url


class KeyVaultKeyReference(_serialization.Model):
    """Describes a reference to Key Vault Key.

    All required parameters must be populated in order to send to server.

    :ivar key_url: The URL referencing a key encryption key in Key Vault. Required.
    :vartype key_url: str
    :ivar source_vault: The relative URL of the Key Vault containing the key. Required.
    :vartype source_vault: ~azure.mgmt.compute.v2016_04_30_preview.models.SubResource
    """

    _validation = {
        "key_url": {"required": True},
        "source_vault": {"required": True},
    }

    _attribute_map = {
        "key_url": {"key": "keyUrl", "type": "str"},
        "source_vault": {"key": "sourceVault", "type": "SubResource"},
    }

    def __init__(self, *, key_url: str, source_vault: "_models.SubResource", **kwargs: Any) -> None:
        """
        :keyword key_url: The URL referencing a key encryption key in Key Vault. Required.
        :paramtype key_url: str
        :keyword source_vault: The relative URL of the Key Vault containing the key. Required.
        :paramtype source_vault: ~azure.mgmt.compute.v2016_04_30_preview.models.SubResource
        """
        super().__init__(**kwargs)
        self.key_url = key_url
        self.source_vault = source_vault


class KeyVaultSecretReference(_serialization.Model):
    """Describes a reference to Key Vault Secret.

    All required parameters must be populated in order to send to server.

    :ivar secret_url: The URL referencing a secret in a Key Vault. Required.
    :vartype secret_url: str
    :ivar source_vault: The relative URL of the Key Vault containing the secret. Required.
    :vartype source_vault: ~azure.mgmt.compute.v2016_04_30_preview.models.SubResource
    """

    _validation = {
        "secret_url": {"required": True},
        "source_vault": {"required": True},
    }

    _attribute_map = {
        "secret_url": {"key": "secretUrl", "type": "str"},
        "source_vault": {"key": "sourceVault", "type": "SubResource"},
    }

    def __init__(self, *, secret_url: str, source_vault: "_models.SubResource", **kwargs: Any) -> None:
        """
        :keyword secret_url: The URL referencing a secret in a Key Vault. Required.
        :paramtype secret_url: str
        :keyword source_vault: The relative URL of the Key Vault containing the secret. Required.
        :paramtype source_vault: ~azure.mgmt.compute.v2016_04_30_preview.models.SubResource
        """
        super().__init__(**kwargs)
        self.secret_url = secret_url
        self.source_vault = source_vault


class LinuxConfiguration(_serialization.Model):
    """Specifies the Linux operating system settings on the virtual machine.
    :code:`<br>`:code:`<br>`For a list of supported Linux distributions, see `Linux on
    Azure-Endorsed Distributions
    <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-endorsed-distros?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_
    :code:`<br>`:code:`<br>` For running non-endorsed distributions, see `Information for
    Non-Endorsed Distributions
    <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-create-upload-generic?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_.

    :ivar disable_password_authentication: Specifies whether password authentication should be
     disabled.
    :vartype disable_password_authentication: bool
    :ivar ssh: Specifies the ssh key configuration for a Linux OS.
    :vartype ssh: ~azure.mgmt.compute.v2016_04_30_preview.models.SshConfiguration
    """

    _attribute_map = {
        "disable_password_authentication": {"key": "disablePasswordAuthentication", "type": "bool"},
        "ssh": {"key": "ssh", "type": "SshConfiguration"},
    }

    def __init__(
        self,
        *,
        disable_password_authentication: Optional[bool] = None,
        ssh: Optional["_models.SshConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword disable_password_authentication: Specifies whether password authentication should be
         disabled.
        :paramtype disable_password_authentication: bool
        :keyword ssh: Specifies the ssh key configuration for a Linux OS.
        :paramtype ssh: ~azure.mgmt.compute.v2016_04_30_preview.models.SshConfiguration
        """
        super().__init__(**kwargs)
        self.disable_password_authentication = disable_password_authentication
        self.ssh = ssh


class ListUsagesResult(_serialization.Model):
    """The List Usages operation response.

    All required parameters must be populated in order to send to server.

    :ivar value: The list of compute resource usages. Required.
    :vartype value: list[~azure.mgmt.compute.v2016_04_30_preview.models.Usage]
    :ivar next_link: The URI to fetch the next page of compute resource usage information. Call
     ListNext() with this to fetch the next page of compute resource usage information.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Usage]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.Usage"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The list of compute resource usages. Required.
        :paramtype value: list[~azure.mgmt.compute.v2016_04_30_preview.models.Usage]
        :keyword next_link: The URI to fetch the next page of compute resource usage information. Call
         ListNext() with this to fetch the next page of compute resource usage information.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ManagedDiskParameters(SubResource):
    """The parameters of a managed disk.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar storage_account_type: Specifies the storage account type for the managed disk. Possible
     values are: Standard_LRS or Premium_LRS. Known values are: "Standard_LRS" and "Premium_LRS".
    :vartype storage_account_type: str or
     ~azure.mgmt.compute.v2016_04_30_preview.models.StorageAccountTypes
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "storage_account_type": {"key": "storageAccountType", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        storage_account_type: Optional[Union[str, "_models.StorageAccountTypes"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Id.
        :paramtype id: str
        :keyword storage_account_type: Specifies the storage account type for the managed disk.
         Possible values are: Standard_LRS or Premium_LRS. Known values are: "Standard_LRS" and
         "Premium_LRS".
        :paramtype storage_account_type: str or
         ~azure.mgmt.compute.v2016_04_30_preview.models.StorageAccountTypes
        """
        super().__init__(id=id, **kwargs)
        self.storage_account_type = storage_account_type


class NetworkInterfaceReference(SubResource):
    """Describes a network interface reference.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar primary: Specifies the primary network interface in case the virtual machine has more
     than 1 network interface.
    :vartype primary: bool
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "primary": {"key": "properties.primary", "type": "bool"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        primary: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Id.
        :paramtype id: str
        :keyword primary: Specifies the primary network interface in case the virtual machine has more
         than 1 network interface.
        :paramtype primary: bool
        """
        super().__init__(id=id, **kwargs)
        self.primary = primary


class NetworkProfile(_serialization.Model):
    """Specifies the network interfaces of the virtual machine.

    :ivar network_interfaces: Specifies the list of resource Ids for the network interfaces
     associated with the virtual machine.
    :vartype network_interfaces:
     list[~azure.mgmt.compute.v2016_04_30_preview.models.NetworkInterfaceReference]
    """

    _attribute_map = {
        "network_interfaces": {"key": "networkInterfaces", "type": "[NetworkInterfaceReference]"},
    }

    def __init__(
        self, *, network_interfaces: Optional[List["_models.NetworkInterfaceReference"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword network_interfaces: Specifies the list of resource Ids for the network interfaces
         associated with the virtual machine.
        :paramtype network_interfaces:
         list[~azure.mgmt.compute.v2016_04_30_preview.models.NetworkInterfaceReference]
        """
        super().__init__(**kwargs)
        self.network_interfaces = network_interfaces


class OperationStatusResponse(_serialization.Model):
    """Operation status response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Operation ID.
    :vartype name: str
    :ivar status: Operation status.
    :vartype status: str
    :ivar start_time: Start time of the operation.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: End time of the operation.
    :vartype end_time: ~datetime.datetime
    :ivar error: Api error.
    :vartype error: ~azure.mgmt.compute.v2016_04_30_preview.models.ApiError
    """

    _validation = {
        "name": {"readonly": True},
        "status": {"readonly": True},
        "start_time": {"readonly": True},
        "end_time": {"readonly": True},
        "error": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "error": {"key": "error", "type": "ApiError"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.status = None
        self.start_time = None
        self.end_time = None
        self.error = None


class OSDisk(_serialization.Model):
    """Specifies information about the operating system disk used by the virtual machine.
    :code:`<br>`:code:`<br>` For more information about disks, see `About disks and VHDs for Azure
    virtual machines
    <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_.

    All required parameters must be populated in order to send to server.

    :ivar os_type: This property allows you to specify the type of the OS that is included in the
     disk if creating a VM from user-image or a specialized VHD. :code:`<br>`:code:`<br>` Possible
     values are: :code:`<br>`:code:`<br>` **Windows** :code:`<br>`:code:`<br>` **Linux**. Known
     values are: "Windows" and "Linux".
    :vartype os_type: str or ~azure.mgmt.compute.v2016_04_30_preview.models.OperatingSystemTypes
    :ivar encryption_settings: Specifies the encryption settings for the OS Disk.
     :code:`<br>`:code:`<br>` Minimum api-version: 2015-06-15.
    :vartype encryption_settings:
     ~azure.mgmt.compute.v2016_04_30_preview.models.DiskEncryptionSettings
    :ivar name: The disk name.
    :vartype name: str
    :ivar vhd: The virtual hard disk.
    :vartype vhd: ~azure.mgmt.compute.v2016_04_30_preview.models.VirtualHardDisk
    :ivar image: The source user image virtual hard disk. The virtual hard disk will be copied
     before being attached to the virtual machine. If SourceImage is provided, the destination
     virtual hard drive must not exist.
    :vartype image: ~azure.mgmt.compute.v2016_04_30_preview.models.VirtualHardDisk
    :ivar caching: Specifies the caching requirements. :code:`<br>`:code:`<br>` Possible values
     are: :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **ReadOnly**
     :code:`<br>`:code:`<br>` **ReadWrite** :code:`<br>`:code:`<br>` Default: **None for Standard
     storage. ReadOnly for Premium storage**. Known values are: "None", "ReadOnly", and "ReadWrite".
    :vartype caching: str or ~azure.mgmt.compute.v2016_04_30_preview.models.CachingTypes
    :ivar create_option: Specifies how the virtual machine should be
     created.:code:`<br>`:code:`<br>` Possible values are::code:`<br>`:code:`<br>` **Attach**
     \\u2013 This value is used when you are using a specialized disk to create the virtual
     machine.:code:`<br>`:code:`<br>` **FromImage** \\u2013 This value is used when you are using an
     image to create the virtual machine. If you are using a platform image, you also use the
     imageReference element described above. If you are using a marketplace image, you  also use the
     plan element previously described. Required. Known values are: "FromImage", "Empty", and
     "Attach".
    :vartype create_option: str or
     ~azure.mgmt.compute.v2016_04_30_preview.models.DiskCreateOptionTypes
    :ivar disk_size_gb: Specifies the size of an empty data disk in gigabytes. This element can be
     used to overwrite the size of the disk in a virtual machine image. :code:`<br>`:code:`<br>`
     This value cannot be larger than 1023 GB.
    :vartype disk_size_gb: int
    :ivar managed_disk: The managed disk parameters.
    :vartype managed_disk: ~azure.mgmt.compute.v2016_04_30_preview.models.ManagedDiskParameters
    """

    _validation = {
        "create_option": {"required": True},
    }

    _attribute_map = {
        "os_type": {"key": "osType", "type": "str"},
        "encryption_settings": {"key": "encryptionSettings", "type": "DiskEncryptionSettings"},
        "name": {"key": "name", "type": "str"},
        "vhd": {"key": "vhd", "type": "VirtualHardDisk"},
        "image": {"key": "image", "type": "VirtualHardDisk"},
        "caching": {"key": "caching", "type": "str"},
        "create_option": {"key": "createOption", "type": "str"},
        "disk_size_gb": {"key": "diskSizeGB", "type": "int"},
        "managed_disk": {"key": "managedDisk", "type": "ManagedDiskParameters"},
    }

    def __init__(
        self,
        *,
        create_option: Union[str, "_models.DiskCreateOptionTypes"],
        os_type: Optional[Union[str, "_models.OperatingSystemTypes"]] = None,
        encryption_settings: Optional["_models.DiskEncryptionSettings"] = None,
        name: Optional[str] = None,
        vhd: Optional["_models.VirtualHardDisk"] = None,
        image: Optional["_models.VirtualHardDisk"] = None,
        caching: Optional[Union[str, "_models.CachingTypes"]] = None,
        disk_size_gb: Optional[int] = None,
        managed_disk: Optional["_models.ManagedDiskParameters"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword os_type: This property allows you to specify the type of the OS that is included in
         the disk if creating a VM from user-image or a specialized VHD. :code:`<br>`:code:`<br>`
         Possible values are: :code:`<br>`:code:`<br>` **Windows** :code:`<br>`:code:`<br>` **Linux**.
         Known values are: "Windows" and "Linux".
        :paramtype os_type: str or ~azure.mgmt.compute.v2016_04_30_preview.models.OperatingSystemTypes
        :keyword encryption_settings: Specifies the encryption settings for the OS Disk.
         :code:`<br>`:code:`<br>` Minimum api-version: 2015-06-15.
        :paramtype encryption_settings:
         ~azure.mgmt.compute.v2016_04_30_preview.models.DiskEncryptionSettings
        :keyword name: The disk name.
        :paramtype name: str
        :keyword vhd: The virtual hard disk.
        :paramtype vhd: ~azure.mgmt.compute.v2016_04_30_preview.models.VirtualHardDisk
        :keyword image: The source user image virtual hard disk. The virtual hard disk will be copied
         before being attached to the virtual machine. If SourceImage is provided, the destination
         virtual hard drive must not exist.
        :paramtype image: ~azure.mgmt.compute.v2016_04_30_preview.models.VirtualHardDisk
        :keyword caching: Specifies the caching requirements. :code:`<br>`:code:`<br>` Possible values
         are: :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **ReadOnly**
         :code:`<br>`:code:`<br>` **ReadWrite** :code:`<br>`:code:`<br>` Default: **None for Standard
         storage. ReadOnly for Premium storage**. Known values are: "None", "ReadOnly", and "ReadWrite".
        :paramtype caching: str or ~azure.mgmt.compute.v2016_04_30_preview.models.CachingTypes
        :keyword create_option: Specifies how the virtual machine should be
         created.:code:`<br>`:code:`<br>` Possible values are::code:`<br>`:code:`<br>` **Attach**
         \\u2013 This value is used when you are using a specialized disk to create the virtual
         machine.:code:`<br>`:code:`<br>` **FromImage** \\u2013 This value is used when you are using an
         image to create the virtual machine. If you are using a platform image, you also use the
         imageReference element described above. If you are using a marketplace image, you  also use the
         plan element previously described. Required. Known values are: "FromImage", "Empty", and
         "Attach".
        :paramtype create_option: str or
         ~azure.mgmt.compute.v2016_04_30_preview.models.DiskCreateOptionTypes
        :keyword disk_size_gb: Specifies the size of an empty data disk in gigabytes. This element can
         be used to overwrite the size of the disk in a virtual machine image. :code:`<br>`:code:`<br>`
         This value cannot be larger than 1023 GB.
        :paramtype disk_size_gb: int
        :keyword managed_disk: The managed disk parameters.
        :paramtype managed_disk: ~azure.mgmt.compute.v2016_04_30_preview.models.ManagedDiskParameters
        """
        super().__init__(**kwargs)
        self.os_type = os_type
        self.encryption_settings = encryption_settings
        self.name = name
        self.vhd = vhd
        self.image = image
        self.caching = caching
        self.create_option = create_option
        self.disk_size_gb = disk_size_gb
        self.managed_disk = managed_disk


class OSDiskImage(_serialization.Model):
    """Contains the os disk image information.

    All required parameters must be populated in order to send to server.

    :ivar operating_system: The operating system of the osDiskImage. Required. Known values are:
     "Windows" and "Linux".
    :vartype operating_system: str or
     ~azure.mgmt.compute.v2016_04_30_preview.models.OperatingSystemTypes
    """

    _validation = {
        "operating_system": {"required": True},
    }

    _attribute_map = {
        "operating_system": {"key": "operatingSystem", "type": "str"},
    }

    def __init__(self, *, operating_system: Union[str, "_models.OperatingSystemTypes"], **kwargs: Any) -> None:
        """
        :keyword operating_system: The operating system of the osDiskImage. Required. Known values are:
         "Windows" and "Linux".
        :paramtype operating_system: str or
         ~azure.mgmt.compute.v2016_04_30_preview.models.OperatingSystemTypes
        """
        super().__init__(**kwargs)
        self.operating_system = operating_system


class OSProfile(_serialization.Model):
    """Specifies the operating system settings for the virtual machine.

    :ivar computer_name: Specifies the host OS name of the virtual machine.
     :code:`<br>`:code:`<br>` This name cannot be updated after the VM is created.
     :code:`<br>`:code:`<br>` **Max-length (Windows):** 15 characters :code:`<br>`:code:`<br>`
     **Max-length (Linux):** 64 characters. :code:`<br>`:code:`<br>` For naming conventions and
     restrictions see `Azure infrastructure services implementation guidelines
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-infrastructure-subscription-accounts-guidelines?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json#1-naming-conventions>`_.  # pylint: disable=line-too-long
    :vartype computer_name: str
    :ivar admin_username: Specifies the name of the administrator account. :code:`<br>`:code:`<br>`
     **Windows-only restriction:** Cannot end in "." :code:`<br>`:code:`<br>` **Disallowed values:**
     "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1",
     "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest",
     "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2",
     "test3", "user4", "user5". :code:`<br>`:code:`<br>` **Minimum-length (Linux):** 1  character
     :code:`<br>`:code:`<br>` **Max-length (Linux):** 64 characters :code:`<br>`:code:`<br>`
     **Max-length (Windows):** 20 characters  :code:`<br>`:code:`<br>`:code:`<li>` For root access
     to the Linux VM, see `Using root privileges on Linux virtual machines in Azure
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-use-root-privileges?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_\\  # pylint: disable=line-too-long
     :code:`<br>`:code:`<li>` For a list of built-in system users on Linux that should not be used
     in this field, see `Selecting User Names for Linux on Azure
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-usernames?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_.  # pylint: disable=line-too-long
    :vartype admin_username: str
    :ivar admin_password: Specifies the password of the administrator account.
     :code:`<br>`:code:`<br>` **Minimum-length (Windows):** 8 characters :code:`<br>`:code:`<br>`
     **Minimum-length (Linux):** 6 characters :code:`<br>`:code:`<br>` **Max-length (Windows):** 123
     characters :code:`<br>`:code:`<br>` **Max-length (Linux):** 72 characters
     :code:`<br>`:code:`<br>` **Complexity requirements:** 3 out of 4 conditions below need to be
     fulfilled :code:`<br>` Has lower characters :code:`<br>`Has upper characters :code:`<br>` Has a
     digit :code:`<br>` Has a special character (Regex match [\\W_]) :code:`<br>`:code:`<br>`
     **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word",
     "pass@word1", "Password!", "Password1", "Password22", "iloveyou!" :code:`<br>`:code:`<br>` For
     resetting the password, see `How to reset the Remote Desktop service or its login password in a
     Windows VM
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-reset-rdp?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_  # pylint: disable=line-too-long
     :code:`<br>`:code:`<br>` For resetting root password, see `Manage users, SSH, and check or
     repair disks on Azure Linux VMs using the VMAccess Extension
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-using-vmaccess-extension?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json#reset-root-password>`_.  # pylint: disable=line-too-long
    :vartype admin_password: str
    :ivar custom_data: Specifies a base-64 encoded string of custom data. The base-64 encoded
     string is decoded to a binary array that is saved as a file on the Virtual Machine. The maximum
     length of the binary array is 65535 bytes. :code:`<br>`:code:`<br>` For using cloud-init for
     your VM, see `Using cloud-init to customize a Linux VM during creation
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-using-cloud-init?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_.  # pylint: disable=line-too-long
    :vartype custom_data: str
    :ivar windows_configuration: Specifies Windows operating system settings on the virtual
     machine.
    :vartype windows_configuration:
     ~azure.mgmt.compute.v2016_04_30_preview.models.WindowsConfiguration
    :ivar linux_configuration: Specifies the Linux operating system settings on the virtual
     machine. :code:`<br>`:code:`<br>`For a list of supported Linux distributions, see `Linux on
     Azure-Endorsed Distributions
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-endorsed-distros?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_  # pylint: disable=line-too-long
     :code:`<br>`:code:`<br>` For running non-endorsed distributions, see `Information for
     Non-Endorsed Distributions
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-create-upload-generic?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_.  # pylint: disable=line-too-long
    :vartype linux_configuration: ~azure.mgmt.compute.v2016_04_30_preview.models.LinuxConfiguration
    :ivar secrets: Specifies set of certificates that should be installed onto the virtual machine.
    :vartype secrets: list[~azure.mgmt.compute.v2016_04_30_preview.models.VaultSecretGroup]
    """

    _attribute_map = {
        "computer_name": {"key": "computerName", "type": "str"},
        "admin_username": {"key": "adminUsername", "type": "str"},
        "admin_password": {"key": "adminPassword", "type": "str"},
        "custom_data": {"key": "customData", "type": "str"},
        "windows_configuration": {"key": "windowsConfiguration", "type": "WindowsConfiguration"},
        "linux_configuration": {"key": "linuxConfiguration", "type": "LinuxConfiguration"},
        "secrets": {"key": "secrets", "type": "[VaultSecretGroup]"},
    }

    def __init__(
        self,
        *,
        computer_name: Optional[str] = None,
        admin_username: Optional[str] = None,
        admin_password: Optional[str] = None,
        custom_data: Optional[str] = None,
        windows_configuration: Optional["_models.WindowsConfiguration"] = None,
        linux_configuration: Optional["_models.LinuxConfiguration"] = None,
        secrets: Optional[List["_models.VaultSecretGroup"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword computer_name: Specifies the host OS name of the virtual machine.
         :code:`<br>`:code:`<br>` This name cannot be updated after the VM is created.
         :code:`<br>`:code:`<br>` **Max-length (Windows):** 15 characters :code:`<br>`:code:`<br>`
         **Max-length (Linux):** 64 characters. :code:`<br>`:code:`<br>` For naming conventions and
         restrictions see `Azure infrastructure services implementation guidelines
         <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-infrastructure-subscription-accounts-guidelines?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json#1-naming-conventions>`_.  # pylint: disable=line-too-long
        :paramtype computer_name: str
        :keyword admin_username: Specifies the name of the administrator account.
         :code:`<br>`:code:`<br>` **Windows-only restriction:** Cannot end in "."
         :code:`<br>`:code:`<br>` **Disallowed values:** "administrator", "admin", "user", "user1",
         "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2",
         "aspnet", "backup", "console", "david", "guest", "john", "owner", "root", "server", "sql",
         "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5".
         :code:`<br>`:code:`<br>` **Minimum-length (Linux):** 1  character :code:`<br>`:code:`<br>`
         **Max-length (Linux):** 64 characters :code:`<br>`:code:`<br>` **Max-length (Windows):** 20
         characters  :code:`<br>`:code:`<br>`:code:`<li>` For root access to the Linux VM, see `Using
         root privileges on Linux virtual machines in Azure
         <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-use-root-privileges?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_\\  # pylint: disable=line-too-long
         :code:`<br>`:code:`<li>` For a list of built-in system users on Linux that should not be used
         in this field, see `Selecting User Names for Linux on Azure
         <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-usernames?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_.  # pylint: disable=line-too-long
        :paramtype admin_username: str
        :keyword admin_password: Specifies the password of the administrator account.
         :code:`<br>`:code:`<br>` **Minimum-length (Windows):** 8 characters :code:`<br>`:code:`<br>`
         **Minimum-length (Linux):** 6 characters :code:`<br>`:code:`<br>` **Max-length (Windows):** 123
         characters :code:`<br>`:code:`<br>` **Max-length (Linux):** 72 characters
         :code:`<br>`:code:`<br>` **Complexity requirements:** 3 out of 4 conditions below need to be
         fulfilled :code:`<br>` Has lower characters :code:`<br>`Has upper characters :code:`<br>` Has a
         digit :code:`<br>` Has a special character (Regex match [\\W_]) :code:`<br>`:code:`<br>`
         **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word",
         "pass@word1", "Password!", "Password1", "Password22", "iloveyou!" :code:`<br>`:code:`<br>` For
         resetting the password, see `How to reset the Remote Desktop service or its login password in a
         Windows VM
         <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-reset-rdp?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_  # pylint: disable=line-too-long
         :code:`<br>`:code:`<br>` For resetting root password, see `Manage users, SSH, and check or
         repair disks on Azure Linux VMs using the VMAccess Extension
         <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-using-vmaccess-extension?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json#reset-root-password>`_.  # pylint: disable=line-too-long
        :paramtype admin_password: str
        :keyword custom_data: Specifies a base-64 encoded string of custom data. The base-64 encoded
         string is decoded to a binary array that is saved as a file on the Virtual Machine. The maximum
         length of the binary array is 65535 bytes. :code:`<br>`:code:`<br>` For using cloud-init for
         your VM, see `Using cloud-init to customize a Linux VM during creation
         <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-using-cloud-init?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_.  # pylint: disable=line-too-long
        :paramtype custom_data: str
        :keyword windows_configuration: Specifies Windows operating system settings on the virtual
         machine.
        :paramtype windows_configuration:
         ~azure.mgmt.compute.v2016_04_30_preview.models.WindowsConfiguration
        :keyword linux_configuration: Specifies the Linux operating system settings on the virtual
         machine. :code:`<br>`:code:`<br>`For a list of supported Linux distributions, see `Linux on
         Azure-Endorsed Distributions
         <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-endorsed-distros?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_  # pylint: disable=line-too-long
         :code:`<br>`:code:`<br>` For running non-endorsed distributions, see `Information for
         Non-Endorsed Distributions
         <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-create-upload-generic?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_.  # pylint: disable=line-too-long
        :paramtype linux_configuration:
         ~azure.mgmt.compute.v2016_04_30_preview.models.LinuxConfiguration
        :keyword secrets: Specifies set of certificates that should be installed onto the virtual
         machine.
        :paramtype secrets: list[~azure.mgmt.compute.v2016_04_30_preview.models.VaultSecretGroup]
        """
        super().__init__(**kwargs)
        self.computer_name = computer_name
        self.admin_username = admin_username
        self.admin_password = admin_password
        self.custom_data = custom_data
        self.windows_configuration = windows_configuration
        self.linux_configuration = linux_configuration
        self.secrets = secrets


class Plan(_serialization.Model):
    """Specifies information about the marketplace image used to create the virtual machine. This
    element is only used for marketplace images. Before you can use a marketplace image from an
    API, you must enable the image for programmatic use.  In the Azure portal, find the marketplace
    image that you want to use and then click **Want to deploy programmatically, Get Started ->**.
    Enter any required information and then click **Save**.

    :ivar name: The plan ID.
    :vartype name: str
    :ivar publisher: The publisher ID.
    :vartype publisher: str
    :ivar product: Specifies the product of the image from the marketplace. This is the same value
     as Offer under the imageReference element.
    :vartype product: str
    :ivar promotion_code: The promotion code.
    :vartype promotion_code: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "publisher": {"key": "publisher", "type": "str"},
        "product": {"key": "product", "type": "str"},
        "promotion_code": {"key": "promotionCode", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        publisher: Optional[str] = None,
        product: Optional[str] = None,
        promotion_code: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The plan ID.
        :paramtype name: str
        :keyword publisher: The publisher ID.
        :paramtype publisher: str
        :keyword product: Specifies the product of the image from the marketplace. This is the same
         value as Offer under the imageReference element.
        :paramtype product: str
        :keyword promotion_code: The promotion code.
        :paramtype promotion_code: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.publisher = publisher
        self.product = product
        self.promotion_code = promotion_code


class PurchasePlan(_serialization.Model):
    """Used for establishing the purchase context of any 3rd Party artifact through MarketPlace.

    All required parameters must be populated in order to send to server.

    :ivar publisher: The publisher ID. Required.
    :vartype publisher: str
    :ivar name: The plan ID. Required.
    :vartype name: str
    :ivar product: Specifies the product of the image from the marketplace. This is the same value
     as Offer under the imageReference element. Required.
    :vartype product: str
    """

    _validation = {
        "publisher": {"required": True},
        "name": {"required": True},
        "product": {"required": True},
    }

    _attribute_map = {
        "publisher": {"key": "publisher", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "product": {"key": "product", "type": "str"},
    }

    def __init__(self, *, publisher: str, name: str, product: str, **kwargs: Any) -> None:
        """
        :keyword publisher: The publisher ID. Required.
        :paramtype publisher: str
        :keyword name: The plan ID. Required.
        :paramtype name: str
        :keyword product: Specifies the product of the image from the marketplace. This is the same
         value as Offer under the imageReference element. Required.
        :paramtype product: str
        """
        super().__init__(**kwargs)
        self.publisher = publisher
        self.name = name
        self.product = product


class Sku(_serialization.Model):
    """Describes a virtual machine scale set sku.

    :ivar name: The sku name.
    :vartype name: str
    :ivar tier: Specifies the tier of virtual machines in a scale set.:code:`<br />`:code:`<br />`
     Possible Values::code:`<br />`:code:`<br />` **Standard**\\ :code:`<br />`:code:`<br />`
     **Basic**.
    :vartype tier: str
    :ivar capacity: Specifies the number of virtual machines in the scale set.
    :vartype capacity: int
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
        "capacity": {"key": "capacity", "type": "int"},
    }

    def __init__(
        self, *, name: Optional[str] = None, tier: Optional[str] = None, capacity: Optional[int] = None, **kwargs: Any
    ) -> None:
        """
        :keyword name: The sku name.
        :paramtype name: str
        :keyword tier: Specifies the tier of virtual machines in a scale set.:code:`<br />`:code:`<br
         />` Possible Values::code:`<br />`:code:`<br />` **Standard**\\ :code:`<br />`:code:`<br />`
         **Basic**.
        :paramtype tier: str
        :keyword capacity: Specifies the number of virtual machines in the scale set.
        :paramtype capacity: int
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.capacity = capacity


class Snapshot(Resource):
    """Snapshot resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar account_type: the storage account type of the disk. Known values are: "Standard_LRS" and
     "Premium_LRS".
    :vartype account_type: str or
     ~azure.mgmt.compute.v2016_04_30_preview.models.StorageAccountTypes
    :ivar time_created: The time when the disk was created.
    :vartype time_created: ~datetime.datetime
    :ivar os_type: The Operating System type. Known values are: "Windows" and "Linux".
    :vartype os_type: str or ~azure.mgmt.compute.v2016_04_30_preview.models.OperatingSystemTypes
    :ivar creation_data: Disk source information. CreationData information cannot be changed after
     the disk has been created.
    :vartype creation_data: ~azure.mgmt.compute.v2016_04_30_preview.models.CreationData
    :ivar disk_size_gb: If creationData.createOption is Empty, this field is mandatory and it
     indicates the size of the VHD to create. If this field is present for updates or creation with
     other options, it indicates a resize. Resizes are only allowed if the disk is not attached to a
     running VM, and can only increase the disk's size.
    :vartype disk_size_gb: int
    :ivar encryption_settings: Encryption settings for disk or snapshot.
    :vartype encryption_settings: ~azure.mgmt.compute.v2016_04_30_preview.models.EncryptionSettings
    :ivar owner_id: A relative URI containing the VM id that has the disk attached.
    :vartype owner_id: str
    :ivar provisioning_state: The disk provisioning state.
    :vartype provisioning_state: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "time_created": {"readonly": True},
        "owner_id": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "account_type": {"key": "properties.accountType", "type": "str"},
        "time_created": {"key": "properties.timeCreated", "type": "iso-8601"},
        "os_type": {"key": "properties.osType", "type": "str"},
        "creation_data": {"key": "properties.creationData", "type": "CreationData"},
        "disk_size_gb": {"key": "properties.diskSizeGB", "type": "int"},
        "encryption_settings": {"key": "properties.encryptionSettings", "type": "EncryptionSettings"},
        "owner_id": {"key": "properties.ownerId", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        account_type: Optional[Union[str, "_models.StorageAccountTypes"]] = None,
        os_type: Optional[Union[str, "_models.OperatingSystemTypes"]] = None,
        creation_data: Optional["_models.CreationData"] = None,
        disk_size_gb: Optional[int] = None,
        encryption_settings: Optional["_models.EncryptionSettings"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword account_type: the storage account type of the disk. Known values are: "Standard_LRS"
         and "Premium_LRS".
        :paramtype account_type: str or
         ~azure.mgmt.compute.v2016_04_30_preview.models.StorageAccountTypes
        :keyword os_type: The Operating System type. Known values are: "Windows" and "Linux".
        :paramtype os_type: str or ~azure.mgmt.compute.v2016_04_30_preview.models.OperatingSystemTypes
        :keyword creation_data: Disk source information. CreationData information cannot be changed
         after the disk has been created.
        :paramtype creation_data: ~azure.mgmt.compute.v2016_04_30_preview.models.CreationData
        :keyword disk_size_gb: If creationData.createOption is Empty, this field is mandatory and it
         indicates the size of the VHD to create. If this field is present for updates or creation with
         other options, it indicates a resize. Resizes are only allowed if the disk is not attached to a
         running VM, and can only increase the disk's size.
        :paramtype disk_size_gb: int
        :keyword encryption_settings: Encryption settings for disk or snapshot.
        :paramtype encryption_settings:
         ~azure.mgmt.compute.v2016_04_30_preview.models.EncryptionSettings
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.account_type = account_type
        self.time_created = None
        self.os_type = os_type
        self.creation_data = creation_data
        self.disk_size_gb = disk_size_gb
        self.encryption_settings = encryption_settings
        self.owner_id = None
        self.provisioning_state = None


class SnapshotList(_serialization.Model):
    """The List Snapshots operation response.

    All required parameters must be populated in order to send to server.

    :ivar value: A list of snapshots. Required.
    :vartype value: list[~azure.mgmt.compute.v2016_04_30_preview.models.Snapshot]
    :ivar next_link: The uri to fetch the next page of snapshots. Call ListNext() with this to
     fetch the next page of snapshots.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Snapshot]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.Snapshot"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: A list of snapshots. Required.
        :paramtype value: list[~azure.mgmt.compute.v2016_04_30_preview.models.Snapshot]
        :keyword next_link: The uri to fetch the next page of snapshots. Call ListNext() with this to
         fetch the next page of snapshots.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SnapshotUpdate(ResourceUpdate):
    """Snapshot update resource.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar account_type: the storage account type of the disk. Known values are: "Standard_LRS" and
     "Premium_LRS".
    :vartype account_type: str or
     ~azure.mgmt.compute.v2016_04_30_preview.models.StorageAccountTypes
    :ivar os_type: the Operating System type. Known values are: "Windows" and "Linux".
    :vartype os_type: str or ~azure.mgmt.compute.v2016_04_30_preview.models.OperatingSystemTypes
    :ivar creation_data: disk source information. CreationData information cannot be changed after
     the disk has been created.
    :vartype creation_data: ~azure.mgmt.compute.v2016_04_30_preview.models.CreationData
    :ivar disk_size_gb: If creationData.createOption is Empty, this field is mandatory and it
     indicates the size of the VHD to create. If this field is present for updates or creation with
     other options, it indicates a resize. Resizes are only allowed if the disk is not attached to a
     running VM, and can only increase the disk's size.
    :vartype disk_size_gb: int
    :ivar encryption_settings: Encryption settings for disk or snapshot.
    :vartype encryption_settings: ~azure.mgmt.compute.v2016_04_30_preview.models.EncryptionSettings
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "account_type": {"key": "properties.accountType", "type": "str"},
        "os_type": {"key": "properties.osType", "type": "str"},
        "creation_data": {"key": "properties.creationData", "type": "CreationData"},
        "disk_size_gb": {"key": "properties.diskSizeGB", "type": "int"},
        "encryption_settings": {"key": "properties.encryptionSettings", "type": "EncryptionSettings"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        account_type: Optional[Union[str, "_models.StorageAccountTypes"]] = None,
        os_type: Optional[Union[str, "_models.OperatingSystemTypes"]] = None,
        creation_data: Optional["_models.CreationData"] = None,
        disk_size_gb: Optional[int] = None,
        encryption_settings: Optional["_models.EncryptionSettings"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword account_type: the storage account type of the disk. Known values are: "Standard_LRS"
         and "Premium_LRS".
        :paramtype account_type: str or
         ~azure.mgmt.compute.v2016_04_30_preview.models.StorageAccountTypes
        :keyword os_type: the Operating System type. Known values are: "Windows" and "Linux".
        :paramtype os_type: str or ~azure.mgmt.compute.v2016_04_30_preview.models.OperatingSystemTypes
        :keyword creation_data: disk source information. CreationData information cannot be changed
         after the disk has been created.
        :paramtype creation_data: ~azure.mgmt.compute.v2016_04_30_preview.models.CreationData
        :keyword disk_size_gb: If creationData.createOption is Empty, this field is mandatory and it
         indicates the size of the VHD to create. If this field is present for updates or creation with
         other options, it indicates a resize. Resizes are only allowed if the disk is not attached to a
         running VM, and can only increase the disk's size.
        :paramtype disk_size_gb: int
        :keyword encryption_settings: Encryption settings for disk or snapshot.
        :paramtype encryption_settings:
         ~azure.mgmt.compute.v2016_04_30_preview.models.EncryptionSettings
        """
        super().__init__(tags=tags, **kwargs)
        self.account_type = account_type
        self.os_type = os_type
        self.creation_data = creation_data
        self.disk_size_gb = disk_size_gb
        self.encryption_settings = encryption_settings


class SourceVault(_serialization.Model):
    """The vault id is an Azure Resource Manager Resource id in the form
    /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}.

    :ivar id: Resource Id.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Resource Id.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class SshConfiguration(_serialization.Model):
    """SSH configuration for Linux based VMs running on Azure.

    :ivar public_keys: The list of SSH public keys used to authenticate with linux based VMs.
    :vartype public_keys: list[~azure.mgmt.compute.v2016_04_30_preview.models.SshPublicKey]
    """

    _attribute_map = {
        "public_keys": {"key": "publicKeys", "type": "[SshPublicKey]"},
    }

    def __init__(self, *, public_keys: Optional[List["_models.SshPublicKey"]] = None, **kwargs: Any) -> None:
        """
        :keyword public_keys: The list of SSH public keys used to authenticate with linux based VMs.
        :paramtype public_keys: list[~azure.mgmt.compute.v2016_04_30_preview.models.SshPublicKey]
        """
        super().__init__(**kwargs)
        self.public_keys = public_keys


class SshPublicKey(_serialization.Model):
    """Contains information about SSH certificate public key and the path on the Linux VM where the
    public key is placed.

    :ivar path: Specifies the full path on the created VM where ssh public key is stored. If the
     file already exists, the specified key is appended to the file. Example:
     /home/user/.ssh/authorized_keys.
    :vartype path: str
    :ivar key_data: SSH public key certificate used to authenticate with the VM through ssh. The
     key needs to be at least 2048-bit and in ssh-rsa format. :code:`<br>`:code:`<br>` For creating
     ssh keys, see `Create SSH keys on Linux and Mac for Linux VMs in Azure
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-mac-create-ssh-keys?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_.  # pylint: disable=line-too-long
    :vartype key_data: str
    """

    _attribute_map = {
        "path": {"key": "path", "type": "str"},
        "key_data": {"key": "keyData", "type": "str"},
    }

    def __init__(self, *, path: Optional[str] = None, key_data: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword path: Specifies the full path on the created VM where ssh public key is stored. If the
         file already exists, the specified key is appended to the file. Example:
         /home/user/.ssh/authorized_keys.
        :paramtype path: str
        :keyword key_data: SSH public key certificate used to authenticate with the VM through ssh. The
         key needs to be at least 2048-bit and in ssh-rsa format. :code:`<br>`:code:`<br>` For creating
         ssh keys, see `Create SSH keys on Linux and Mac for Linux VMs in Azure
         <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-mac-create-ssh-keys?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_.  # pylint: disable=line-too-long
        :paramtype key_data: str
        """
        super().__init__(**kwargs)
        self.path = path
        self.key_data = key_data


class StorageProfile(_serialization.Model):
    """Specifies the storage settings for the virtual machine disks.

    :ivar image_reference: Specifies information about the image to use. You can specify
     information about platform images, marketplace images, or virtual machine images. This element
     is required when you want to use a platform image, marketplace image, or virtual machine image,
     but is not used in other creation operations.
    :vartype image_reference: ~azure.mgmt.compute.v2016_04_30_preview.models.ImageReference
    :ivar os_disk: Specifies information about the operating system disk used by the virtual
     machine. :code:`<br>`:code:`<br>` For more information about disks, see `About disks and VHDs
     for Azure virtual machines
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_.  # pylint: disable=line-too-long
    :vartype os_disk: ~azure.mgmt.compute.v2016_04_30_preview.models.OSDisk
    :ivar data_disks: Specifies the parameters that are used to add a data disk to a virtual
     machine. :code:`<br>`:code:`<br>` For more information about disks, see `About disks and VHDs
     for Azure virtual machines
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_.  # pylint: disable=line-too-long
    :vartype data_disks: list[~azure.mgmt.compute.v2016_04_30_preview.models.DataDisk]
    """

    _attribute_map = {
        "image_reference": {"key": "imageReference", "type": "ImageReference"},
        "os_disk": {"key": "osDisk", "type": "OSDisk"},
        "data_disks": {"key": "dataDisks", "type": "[DataDisk]"},
    }

    def __init__(
        self,
        *,
        image_reference: Optional["_models.ImageReference"] = None,
        os_disk: Optional["_models.OSDisk"] = None,
        data_disks: Optional[List["_models.DataDisk"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword image_reference: Specifies information about the image to use. You can specify
         information about platform images, marketplace images, or virtual machine images. This element
         is required when you want to use a platform image, marketplace image, or virtual machine image,
         but is not used in other creation operations.
        :paramtype image_reference: ~azure.mgmt.compute.v2016_04_30_preview.models.ImageReference
        :keyword os_disk: Specifies information about the operating system disk used by the virtual
         machine. :code:`<br>`:code:`<br>` For more information about disks, see `About disks and VHDs
         for Azure virtual machines
         <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_.  # pylint: disable=line-too-long
        :paramtype os_disk: ~azure.mgmt.compute.v2016_04_30_preview.models.OSDisk
        :keyword data_disks: Specifies the parameters that are used to add a data disk to a virtual
         machine. :code:`<br>`:code:`<br>` For more information about disks, see `About disks and VHDs
         for Azure virtual machines
         <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_.  # pylint: disable=line-too-long
        :paramtype data_disks: list[~azure.mgmt.compute.v2016_04_30_preview.models.DataDisk]
        """
        super().__init__(**kwargs)
        self.image_reference = image_reference
        self.os_disk = os_disk
        self.data_disks = data_disks


class SubResourceReadOnly(_serialization.Model):
    """SubResourceReadOnly.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None


class UpdateResource(_serialization.Model):
    """The Update Resource model definition.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class UpgradePolicy(_serialization.Model):
    """Describes an upgrade policy - automatic or manual.

    :ivar mode: Specifies the mode of an upgrade to virtual machines in the scale set.:code:`<br
     />`:code:`<br />` Possible values are::code:`<br />`:code:`<br />` **Manual** - You  control
     the application of updates to virtual machines in the scale set. You do this by using the
     manualUpgrade action.:code:`<br />`:code:`<br />` **Automatic** - All virtual machines in the
     scale set are  automatically updated at the same time. Known values are: "Automatic" and
     "Manual".
    :vartype mode: str or ~azure.mgmt.compute.v2016_04_30_preview.models.UpgradeMode
    """

    _attribute_map = {
        "mode": {"key": "mode", "type": "str"},
    }

    def __init__(self, *, mode: Optional[Union[str, "_models.UpgradeMode"]] = None, **kwargs: Any) -> None:
        """
        :keyword mode: Specifies the mode of an upgrade to virtual machines in the scale set.:code:`<br
         />`:code:`<br />` Possible values are::code:`<br />`:code:`<br />` **Manual** - You  control
         the application of updates to virtual machines in the scale set. You do this by using the
         manualUpgrade action.:code:`<br />`:code:`<br />` **Automatic** - All virtual machines in the
         scale set are  automatically updated at the same time. Known values are: "Automatic" and
         "Manual".
        :paramtype mode: str or ~azure.mgmt.compute.v2016_04_30_preview.models.UpgradeMode
        """
        super().__init__(**kwargs)
        self.mode = mode


class Usage(_serialization.Model):
    """Describes Compute Resource Usage.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar unit: An enum describing the unit of usage measurement. Required. Default value is
     "Count".
    :vartype unit: str
    :ivar current_value: The current usage of the resource. Required.
    :vartype current_value: int
    :ivar limit: The maximum permitted usage of the resource. Required.
    :vartype limit: int
    :ivar name: The name of the type of usage. Required.
    :vartype name: ~azure.mgmt.compute.v2016_04_30_preview.models.UsageName
    """

    _validation = {
        "unit": {"required": True, "constant": True},
        "current_value": {"required": True},
        "limit": {"required": True},
        "name": {"required": True},
    }

    _attribute_map = {
        "unit": {"key": "unit", "type": "str"},
        "current_value": {"key": "currentValue", "type": "int"},
        "limit": {"key": "limit", "type": "int"},
        "name": {"key": "name", "type": "UsageName"},
    }

    unit = "Count"

    def __init__(self, *, current_value: int, limit: int, name: "_models.UsageName", **kwargs: Any) -> None:
        """
        :keyword current_value: The current usage of the resource. Required.
        :paramtype current_value: int
        :keyword limit: The maximum permitted usage of the resource. Required.
        :paramtype limit: int
        :keyword name: The name of the type of usage. Required.
        :paramtype name: ~azure.mgmt.compute.v2016_04_30_preview.models.UsageName
        """
        super().__init__(**kwargs)
        self.current_value = current_value
        self.limit = limit
        self.name = name


class UsageName(_serialization.Model):
    """The Usage Names.

    :ivar value: The name of the resource.
    :vartype value: str
    :ivar localized_value: The localized name of the resource.
    :vartype localized_value: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
        "localized_value": {"key": "localizedValue", "type": "str"},
    }

    def __init__(self, *, value: Optional[str] = None, localized_value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The name of the resource.
        :paramtype value: str
        :keyword localized_value: The localized name of the resource.
        :paramtype localized_value: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.localized_value = localized_value


class VaultCertificate(_serialization.Model):
    """Describes a single certificate reference in a Key Vault, and where the certificate should
    reside on the VM.

    :ivar certificate_url: This is the URL of a certificate that has been uploaded to Key Vault as
     a secret. For adding a secret to the Key Vault, see `Add a key or secret to the key vault
     <https://docs.microsoft.com/azure/key-vault/key-vault-get-started/#add>`_. In this case, your
     certificate needs to be It is the Base64 encoding of the following JSON Object which is encoded
     in UTF-8: :code:`<br>`:code:`<br>` {:code:`<br>`
     "data":":code:`<Base64-encoded-certificate>`",:code:`<br>`  "dataType":"pfx",:code:`<br>`
     "password":":code:`<pfx-file-password>`":code:`<br>`}.
    :vartype certificate_url: str
    :ivar certificate_store: For Windows VMs, specifies the certificate store on the Virtual
     Machine to which the certificate should be added. The specified certificate store is implicitly
     in the LocalMachine account. :code:`<br>`:code:`<br>`For Linux VMs, the certificate file is
     placed under the /var/lib/waagent directory, with the file name
     :code:`<UppercaseThumbprint>`.crt for the X509 certificate file and
     :code:`<UppercaseThumbprint>`.prv for private key. Both of these files are .pem formatted.
    :vartype certificate_store: str
    """

    _attribute_map = {
        "certificate_url": {"key": "certificateUrl", "type": "str"},
        "certificate_store": {"key": "certificateStore", "type": "str"},
    }

    def __init__(
        self, *, certificate_url: Optional[str] = None, certificate_store: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword certificate_url: This is the URL of a certificate that has been uploaded to Key Vault
         as a secret. For adding a secret to the Key Vault, see `Add a key or secret to the key vault
         <https://docs.microsoft.com/azure/key-vault/key-vault-get-started/#add>`_. In this case, your
         certificate needs to be It is the Base64 encoding of the following JSON Object which is encoded
         in UTF-8: :code:`<br>`:code:`<br>` {:code:`<br>`
         "data":":code:`<Base64-encoded-certificate>`",:code:`<br>`  "dataType":"pfx",:code:`<br>`
         "password":":code:`<pfx-file-password>`":code:`<br>`}.
        :paramtype certificate_url: str
        :keyword certificate_store: For Windows VMs, specifies the certificate store on the Virtual
         Machine to which the certificate should be added. The specified certificate store is implicitly
         in the LocalMachine account. :code:`<br>`:code:`<br>`For Linux VMs, the certificate file is
         placed under the /var/lib/waagent directory, with the file name
         :code:`<UppercaseThumbprint>`.crt for the X509 certificate file and
         :code:`<UppercaseThumbprint>`.prv for private key. Both of these files are .pem formatted.
        :paramtype certificate_store: str
        """
        super().__init__(**kwargs)
        self.certificate_url = certificate_url
        self.certificate_store = certificate_store


class VaultSecretGroup(_serialization.Model):
    """Describes a set of certificates which are all in the same Key Vault.

    :ivar source_vault: The relative URL of the Key Vault containing all of the certificates in
     VaultCertificates.
    :vartype source_vault: ~azure.mgmt.compute.v2016_04_30_preview.models.SubResource
    :ivar vault_certificates: The list of key vault references in SourceVault which contain
     certificates.
    :vartype vault_certificates:
     list[~azure.mgmt.compute.v2016_04_30_preview.models.VaultCertificate]
    """

    _attribute_map = {
        "source_vault": {"key": "sourceVault", "type": "SubResource"},
        "vault_certificates": {"key": "vaultCertificates", "type": "[VaultCertificate]"},
    }

    def __init__(
        self,
        *,
        source_vault: Optional["_models.SubResource"] = None,
        vault_certificates: Optional[List["_models.VaultCertificate"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword source_vault: The relative URL of the Key Vault containing all of the certificates in
         VaultCertificates.
        :paramtype source_vault: ~azure.mgmt.compute.v2016_04_30_preview.models.SubResource
        :keyword vault_certificates: The list of key vault references in SourceVault which contain
         certificates.
        :paramtype vault_certificates:
         list[~azure.mgmt.compute.v2016_04_30_preview.models.VaultCertificate]
        """
        super().__init__(**kwargs)
        self.source_vault = source_vault
        self.vault_certificates = vault_certificates


class VirtualHardDisk(_serialization.Model):
    """Describes the uri of a disk.

    :ivar uri: Specifies the virtual hard disk's uri.
    :vartype uri: str
    """

    _attribute_map = {
        "uri": {"key": "uri", "type": "str"},
    }

    def __init__(self, *, uri: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword uri: Specifies the virtual hard disk's uri.
        :paramtype uri: str
        """
        super().__init__(**kwargs)
        self.uri = uri


class VirtualMachine(Resource):
    """Describes a Virtual Machine.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar plan: Specifies information about the marketplace image used to create the virtual
     machine. This element is only used for marketplace images. Before you can use a marketplace
     image from an API, you must enable the image for programmatic use.  In the Azure portal, find
     the marketplace image that you want to use and then click **Want to deploy programmatically,
     Get Started ->**. Enter any required information and then click **Save**.
    :vartype plan: ~azure.mgmt.compute.v2016_04_30_preview.models.Plan
    :ivar resources: The virtual machine child extension resources.
    :vartype resources:
     list[~azure.mgmt.compute.v2016_04_30_preview.models.VirtualMachineExtension]
    :ivar identity: The identity of the virtual machine, if configured.
    :vartype identity: ~azure.mgmt.compute.v2016_04_30_preview.models.VirtualMachineIdentity
    :ivar hardware_profile: Specifies the hardware settings for the virtual machine.
    :vartype hardware_profile: ~azure.mgmt.compute.v2016_04_30_preview.models.HardwareProfile
    :ivar storage_profile: Specifies the storage settings for the virtual machine disks.
    :vartype storage_profile: ~azure.mgmt.compute.v2016_04_30_preview.models.StorageProfile
    :ivar os_profile: Specifies the operating system settings for the virtual machine.
    :vartype os_profile: ~azure.mgmt.compute.v2016_04_30_preview.models.OSProfile
    :ivar network_profile: Specifies the network interfaces of the virtual machine.
    :vartype network_profile: ~azure.mgmt.compute.v2016_04_30_preview.models.NetworkProfile
    :ivar diagnostics_profile: Specifies the boot diagnostic settings state.
     :code:`<br>`:code:`<br>`Minimum api-version: 2015-06-15.
    :vartype diagnostics_profile: ~azure.mgmt.compute.v2016_04_30_preview.models.DiagnosticsProfile
    :ivar availability_set: Specifies information about the availability set that the virtual
     machine should be assigned to. Virtual machines specified in the same availability set are
     allocated to different nodes to maximize availability. For more information about availability
     sets, see `Manage the availability of virtual machines
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-manage-availability?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_.  # pylint: disable=line-too-long
     :code:`<br>`:code:`<br>` For more information on Azure planned maintenance, see `Planned
     maintenance for virtual machines in Azure
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-planned-maintenance?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_  # pylint: disable=line-too-long
     :code:`<br>`:code:`<br>` Currently, a VM can only be added to availability set at creation
     time. An existing VM cannot be added to an availability set.
    :vartype availability_set: ~azure.mgmt.compute.v2016_04_30_preview.models.SubResource
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :ivar instance_view: The virtual machine instance view.
    :vartype instance_view:
     ~azure.mgmt.compute.v2016_04_30_preview.models.VirtualMachineInstanceView
    :ivar license_type: Specifies that the image or disk that is being used was licensed
     on-premises. This element is only used for images that contain the Windows Server operating
     system. :code:`<br>`:code:`<br>` Possible values are: :code:`<br>`:code:`<br>` Windows_Client
     :code:`<br>`:code:`<br>` Windows_Server :code:`<br>`:code:`<br>` If this element is included in
     a request for an update, the value must match the initial value. This value cannot be updated.
     :code:`<br>`:code:`<br>` For more information, see `Azure Hybrid Use Benefit for Windows Server
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-hybrid-use-benefit-licensing?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_  # pylint: disable=line-too-long
     :code:`<br>`:code:`<br>` Minimum api-version: 2015-06-15.
    :vartype license_type: str
    :ivar vm_id: Specifies the VM unique ID which is a 128-bits identifier that is encoded and
     stored in all Azure IaaS VMs SMBIOS and can be read using platform BIOS commands.
    :vartype vm_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "resources": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "instance_view": {"readonly": True},
        "vm_id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "plan": {"key": "plan", "type": "Plan"},
        "resources": {"key": "resources", "type": "[VirtualMachineExtension]"},
        "identity": {"key": "identity", "type": "VirtualMachineIdentity"},
        "hardware_profile": {"key": "properties.hardwareProfile", "type": "HardwareProfile"},
        "storage_profile": {"key": "properties.storageProfile", "type": "StorageProfile"},
        "os_profile": {"key": "properties.osProfile", "type": "OSProfile"},
        "network_profile": {"key": "properties.networkProfile", "type": "NetworkProfile"},
        "diagnostics_profile": {"key": "properties.diagnosticsProfile", "type": "DiagnosticsProfile"},
        "availability_set": {"key": "properties.availabilitySet", "type": "SubResource"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "instance_view": {"key": "properties.instanceView", "type": "VirtualMachineInstanceView"},
        "license_type": {"key": "properties.licenseType", "type": "str"},
        "vm_id": {"key": "properties.vmId", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        plan: Optional["_models.Plan"] = None,
        identity: Optional["_models.VirtualMachineIdentity"] = None,
        hardware_profile: Optional["_models.HardwareProfile"] = None,
        storage_profile: Optional["_models.StorageProfile"] = None,
        os_profile: Optional["_models.OSProfile"] = None,
        network_profile: Optional["_models.NetworkProfile"] = None,
        diagnostics_profile: Optional["_models.DiagnosticsProfile"] = None,
        availability_set: Optional["_models.SubResource"] = None,
        license_type: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword plan: Specifies information about the marketplace image used to create the virtual
         machine. This element is only used for marketplace images. Before you can use a marketplace
         image from an API, you must enable the image for programmatic use.  In the Azure portal, find
         the marketplace image that you want to use and then click **Want to deploy programmatically,
         Get Started ->**. Enter any required information and then click **Save**.
        :paramtype plan: ~azure.mgmt.compute.v2016_04_30_preview.models.Plan
        :keyword identity: The identity of the virtual machine, if configured.
        :paramtype identity: ~azure.mgmt.compute.v2016_04_30_preview.models.VirtualMachineIdentity
        :keyword hardware_profile: Specifies the hardware settings for the virtual machine.
        :paramtype hardware_profile: ~azure.mgmt.compute.v2016_04_30_preview.models.HardwareProfile
        :keyword storage_profile: Specifies the storage settings for the virtual machine disks.
        :paramtype storage_profile: ~azure.mgmt.compute.v2016_04_30_preview.models.StorageProfile
        :keyword os_profile: Specifies the operating system settings for the virtual machine.
        :paramtype os_profile: ~azure.mgmt.compute.v2016_04_30_preview.models.OSProfile
        :keyword network_profile: Specifies the network interfaces of the virtual machine.
        :paramtype network_profile: ~azure.mgmt.compute.v2016_04_30_preview.models.NetworkProfile
        :keyword diagnostics_profile: Specifies the boot diagnostic settings state.
         :code:`<br>`:code:`<br>`Minimum api-version: 2015-06-15.
        :paramtype diagnostics_profile:
         ~azure.mgmt.compute.v2016_04_30_preview.models.DiagnosticsProfile
        :keyword availability_set: Specifies information about the availability set that the virtual
         machine should be assigned to. Virtual machines specified in the same availability set are
         allocated to different nodes to maximize availability. For more information about availability
         sets, see `Manage the availability of virtual machines
         <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-manage-availability?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_.  # pylint: disable=line-too-long
         :code:`<br>`:code:`<br>` For more information on Azure planned maintenance, see `Planned
         maintenance for virtual machines in Azure
         <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-planned-maintenance?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_  # pylint: disable=line-too-long
         :code:`<br>`:code:`<br>` Currently, a VM can only be added to availability set at creation
         time. An existing VM cannot be added to an availability set.
        :paramtype availability_set: ~azure.mgmt.compute.v2016_04_30_preview.models.SubResource
        :keyword license_type: Specifies that the image or disk that is being used was licensed
         on-premises. This element is only used for images that contain the Windows Server operating
         system. :code:`<br>`:code:`<br>` Possible values are: :code:`<br>`:code:`<br>` Windows_Client
         :code:`<br>`:code:`<br>` Windows_Server :code:`<br>`:code:`<br>` If this element is included in
         a request for an update, the value must match the initial value. This value cannot be updated.
         :code:`<br>`:code:`<br>` For more information, see `Azure Hybrid Use Benefit for Windows Server
         <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-hybrid-use-benefit-licensing?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_  # pylint: disable=line-too-long
         :code:`<br>`:code:`<br>` Minimum api-version: 2015-06-15.
        :paramtype license_type: str
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.plan = plan
        self.resources = None
        self.identity = identity
        self.hardware_profile = hardware_profile
        self.storage_profile = storage_profile
        self.os_profile = os_profile
        self.network_profile = network_profile
        self.diagnostics_profile = diagnostics_profile
        self.availability_set = availability_set
        self.provisioning_state = None
        self.instance_view = None
        self.license_type = license_type
        self.vm_id = None


class VirtualMachineAgentInstanceView(_serialization.Model):
    """The instance view of the VM Agent running on the virtual machine.

    :ivar vm_agent_version: The VM Agent full version.
    :vartype vm_agent_version: str
    :ivar extension_handlers: The virtual machine extension handler instance view.
    :vartype extension_handlers:
     list[~azure.mgmt.compute.v2016_04_30_preview.models.VirtualMachineExtensionHandlerInstanceView]
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.compute.v2016_04_30_preview.models.InstanceViewStatus]
    """

    _attribute_map = {
        "vm_agent_version": {"key": "vmAgentVersion", "type": "str"},
        "extension_handlers": {"key": "extensionHandlers", "type": "[VirtualMachineExtensionHandlerInstanceView]"},
        "statuses": {"key": "statuses", "type": "[InstanceViewStatus]"},
    }

    def __init__(
        self,
        *,
        vm_agent_version: Optional[str] = None,
        extension_handlers: Optional[List["_models.VirtualMachineExtensionHandlerInstanceView"]] = None,
        statuses: Optional[List["_models.InstanceViewStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword vm_agent_version: The VM Agent full version.
        :paramtype vm_agent_version: str
        :keyword extension_handlers: The virtual machine extension handler instance view.
        :paramtype extension_handlers:
         list[~azure.mgmt.compute.v2016_04_30_preview.models.VirtualMachineExtensionHandlerInstanceView]
        :keyword statuses: The resource status information.
        :paramtype statuses: list[~azure.mgmt.compute.v2016_04_30_preview.models.InstanceViewStatus]
        """
        super().__init__(**kwargs)
        self.vm_agent_version = vm_agent_version
        self.extension_handlers = extension_handlers
        self.statuses = statuses


class VirtualMachineCaptureParameters(_serialization.Model):
    """Capture Virtual Machine parameters.

    All required parameters must be populated in order to send to server.

    :ivar vhd_prefix: The captured virtual hard disk's name prefix. Required.
    :vartype vhd_prefix: str
    :ivar destination_container_name: The destination container name. Required.
    :vartype destination_container_name: str
    :ivar overwrite_vhds: Specifies whether to overwrite the destination virtual hard disk, in case
     of conflict. Required.
    :vartype overwrite_vhds: bool
    """

    _validation = {
        "vhd_prefix": {"required": True},
        "destination_container_name": {"required": True},
        "overwrite_vhds": {"required": True},
    }

    _attribute_map = {
        "vhd_prefix": {"key": "vhdPrefix", "type": "str"},
        "destination_container_name": {"key": "destinationContainerName", "type": "str"},
        "overwrite_vhds": {"key": "overwriteVhds", "type": "bool"},
    }

    def __init__(
        self, *, vhd_prefix: str, destination_container_name: str, overwrite_vhds: bool, **kwargs: Any
    ) -> None:
        """
        :keyword vhd_prefix: The captured virtual hard disk's name prefix. Required.
        :paramtype vhd_prefix: str
        :keyword destination_container_name: The destination container name. Required.
        :paramtype destination_container_name: str
        :keyword overwrite_vhds: Specifies whether to overwrite the destination virtual hard disk, in
         case of conflict. Required.
        :paramtype overwrite_vhds: bool
        """
        super().__init__(**kwargs)
        self.vhd_prefix = vhd_prefix
        self.destination_container_name = destination_container_name
        self.overwrite_vhds = overwrite_vhds


class VirtualMachineCaptureResult(SubResource):
    """Resource Id.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar output: Operation output data (raw JSON).
    :vartype output: JSON
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "output": {"key": "properties.output", "type": "object"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        output: Optional[JSON] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Id.
        :paramtype id: str
        :keyword output: Operation output data (raw JSON).
        :paramtype output: JSON
        """
        super().__init__(id=id, **kwargs)
        self.output = output


class VirtualMachineExtension(Resource):
    """Describes a Virtual Machine Extension.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar force_update_tag: How the extension handler should be forced to update even if the
     extension configuration has not changed.
    :vartype force_update_tag: str
    :ivar publisher: The name of the extension handler publisher.
    :vartype publisher: str
    :ivar type_properties_type: Specifies the type of the extension; an example is
     "CustomScriptExtension".
    :vartype type_properties_type: str
    :ivar type_handler_version: Specifies the version of the script handler.
    :vartype type_handler_version: str
    :ivar auto_upgrade_minor_version: Indicates whether the extension should use a newer minor
     version if one is available at deployment time. Once deployed, however, the extension will not
     upgrade minor versions unless redeployed, even with this property set to true.
    :vartype auto_upgrade_minor_version: bool
    :ivar settings: Json formatted public settings for the extension.
    :vartype settings: JSON
    :ivar protected_settings: The extension can contain either protectedSettings or
     protectedSettingsFromKeyVault or no protected settings at all.
    :vartype protected_settings: JSON
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :ivar instance_view: The virtual machine extension instance view.
    :vartype instance_view:
     ~azure.mgmt.compute.v2016_04_30_preview.models.VirtualMachineExtensionInstanceView
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "force_update_tag": {"key": "properties.forceUpdateTag", "type": "str"},
        "publisher": {"key": "properties.publisher", "type": "str"},
        "type_properties_type": {"key": "properties.type", "type": "str"},
        "type_handler_version": {"key": "properties.typeHandlerVersion", "type": "str"},
        "auto_upgrade_minor_version": {"key": "properties.autoUpgradeMinorVersion", "type": "bool"},
        "settings": {"key": "properties.settings", "type": "object"},
        "protected_settings": {"key": "properties.protectedSettings", "type": "object"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "instance_view": {"key": "properties.instanceView", "type": "VirtualMachineExtensionInstanceView"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        force_update_tag: Optional[str] = None,
        publisher: Optional[str] = None,
        type_properties_type: Optional[str] = None,
        type_handler_version: Optional[str] = None,
        auto_upgrade_minor_version: Optional[bool] = None,
        settings: Optional[JSON] = None,
        protected_settings: Optional[JSON] = None,
        instance_view: Optional["_models.VirtualMachineExtensionInstanceView"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword force_update_tag: How the extension handler should be forced to update even if the
         extension configuration has not changed.
        :paramtype force_update_tag: str
        :keyword publisher: The name of the extension handler publisher.
        :paramtype publisher: str
        :keyword type_properties_type: Specifies the type of the extension; an example is
         "CustomScriptExtension".
        :paramtype type_properties_type: str
        :keyword type_handler_version: Specifies the version of the script handler.
        :paramtype type_handler_version: str
        :keyword auto_upgrade_minor_version: Indicates whether the extension should use a newer minor
         version if one is available at deployment time. Once deployed, however, the extension will not
         upgrade minor versions unless redeployed, even with this property set to true.
        :paramtype auto_upgrade_minor_version: bool
        :keyword settings: Json formatted public settings for the extension.
        :paramtype settings: JSON
        :keyword protected_settings: The extension can contain either protectedSettings or
         protectedSettingsFromKeyVault or no protected settings at all.
        :paramtype protected_settings: JSON
        :keyword instance_view: The virtual machine extension instance view.
        :paramtype instance_view:
         ~azure.mgmt.compute.v2016_04_30_preview.models.VirtualMachineExtensionInstanceView
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.force_update_tag = force_update_tag
        self.publisher = publisher
        self.type_properties_type = type_properties_type
        self.type_handler_version = type_handler_version
        self.auto_upgrade_minor_version = auto_upgrade_minor_version
        self.settings = settings
        self.protected_settings = protected_settings
        self.provisioning_state = None
        self.instance_view = instance_view


class VirtualMachineExtensionHandlerInstanceView(_serialization.Model):  # pylint: disable=name-too-long
    """The instance view of a virtual machine extension handler.

    :ivar type: Specifies the type of the extension; an example is "CustomScriptExtension".
    :vartype type: str
    :ivar type_handler_version: Specifies the version of the script handler.
    :vartype type_handler_version: str
    :ivar status: The extension handler status.
    :vartype status: ~azure.mgmt.compute.v2016_04_30_preview.models.InstanceViewStatus
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "type_handler_version": {"key": "typeHandlerVersion", "type": "str"},
        "status": {"key": "status", "type": "InstanceViewStatus"},
    }

    def __init__(
        self,
        *,
        type: Optional[str] = None,
        type_handler_version: Optional[str] = None,
        status: Optional["_models.InstanceViewStatus"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Specifies the type of the extension; an example is "CustomScriptExtension".
        :paramtype type: str
        :keyword type_handler_version: Specifies the version of the script handler.
        :paramtype type_handler_version: str
        :keyword status: The extension handler status.
        :paramtype status: ~azure.mgmt.compute.v2016_04_30_preview.models.InstanceViewStatus
        """
        super().__init__(**kwargs)
        self.type = type
        self.type_handler_version = type_handler_version
        self.status = status


class VirtualMachineExtensionImage(Resource):
    """Describes a Virtual Machine Extension Image.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar operating_system: The operating system this extension supports.
    :vartype operating_system: str
    :ivar compute_role: The type of role (IaaS or PaaS) this extension supports.
    :vartype compute_role: str
    :ivar handler_schema: The schema defined by publisher, where extension consumers should provide
     settings in a matching schema.
    :vartype handler_schema: str
    :ivar vm_scale_set_enabled: Whether the extension can be used on xRP VMScaleSets. By default
     existing extensions are usable on scalesets, but there might be cases where a publisher wants
     to explicitly indicate the extension is only enabled for CRP VMs but not VMSS.
    :vartype vm_scale_set_enabled: bool
    :ivar supports_multiple_extensions: Whether the handler can support multiple extensions.
    :vartype supports_multiple_extensions: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "operating_system": {"key": "properties.operatingSystem", "type": "str"},
        "compute_role": {"key": "properties.computeRole", "type": "str"},
        "handler_schema": {"key": "properties.handlerSchema", "type": "str"},
        "vm_scale_set_enabled": {"key": "properties.vmScaleSetEnabled", "type": "bool"},
        "supports_multiple_extensions": {"key": "properties.supportsMultipleExtensions", "type": "bool"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        operating_system: Optional[str] = None,
        compute_role: Optional[str] = None,
        handler_schema: Optional[str] = None,
        vm_scale_set_enabled: Optional[bool] = None,
        supports_multiple_extensions: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword operating_system: The operating system this extension supports.
        :paramtype operating_system: str
        :keyword compute_role: The type of role (IaaS or PaaS) this extension supports.
        :paramtype compute_role: str
        :keyword handler_schema: The schema defined by publisher, where extension consumers should
         provide settings in a matching schema.
        :paramtype handler_schema: str
        :keyword vm_scale_set_enabled: Whether the extension can be used on xRP VMScaleSets. By default
         existing extensions are usable on scalesets, but there might be cases where a publisher wants
         to explicitly indicate the extension is only enabled for CRP VMs but not VMSS.
        :paramtype vm_scale_set_enabled: bool
        :keyword supports_multiple_extensions: Whether the handler can support multiple extensions.
        :paramtype supports_multiple_extensions: bool
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.operating_system = operating_system
        self.compute_role = compute_role
        self.handler_schema = handler_schema
        self.vm_scale_set_enabled = vm_scale_set_enabled
        self.supports_multiple_extensions = supports_multiple_extensions


class VirtualMachineExtensionInstanceView(_serialization.Model):
    """The instance view of a virtual machine extension.

    :ivar name: The virtual machine extension name.
    :vartype name: str
    :ivar type: Specifies the type of the extension; an example is "CustomScriptExtension".
    :vartype type: str
    :ivar type_handler_version: Specifies the version of the script handler.
    :vartype type_handler_version: str
    :ivar substatuses: The resource status information.
    :vartype substatuses: list[~azure.mgmt.compute.v2016_04_30_preview.models.InstanceViewStatus]
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.compute.v2016_04_30_preview.models.InstanceViewStatus]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "type_handler_version": {"key": "typeHandlerVersion", "type": "str"},
        "substatuses": {"key": "substatuses", "type": "[InstanceViewStatus]"},
        "statuses": {"key": "statuses", "type": "[InstanceViewStatus]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        type: Optional[str] = None,
        type_handler_version: Optional[str] = None,
        substatuses: Optional[List["_models.InstanceViewStatus"]] = None,
        statuses: Optional[List["_models.InstanceViewStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The virtual machine extension name.
        :paramtype name: str
        :keyword type: Specifies the type of the extension; an example is "CustomScriptExtension".
        :paramtype type: str
        :keyword type_handler_version: Specifies the version of the script handler.
        :paramtype type_handler_version: str
        :keyword substatuses: The resource status information.
        :paramtype substatuses: list[~azure.mgmt.compute.v2016_04_30_preview.models.InstanceViewStatus]
        :keyword statuses: The resource status information.
        :paramtype statuses: list[~azure.mgmt.compute.v2016_04_30_preview.models.InstanceViewStatus]
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = type
        self.type_handler_version = type_handler_version
        self.substatuses = substatuses
        self.statuses = statuses


class VirtualMachineExtensionsListResult(_serialization.Model):
    """The List Extension operation response.

    :ivar value: The list of extensions.
    :vartype value: list[~azure.mgmt.compute.v2016_04_30_preview.models.VirtualMachineExtension]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualMachineExtension]"},
    }

    def __init__(self, *, value: Optional[List["_models.VirtualMachineExtension"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: The list of extensions.
        :paramtype value: list[~azure.mgmt.compute.v2016_04_30_preview.models.VirtualMachineExtension]
        """
        super().__init__(**kwargs)
        self.value = value


class VirtualMachineExtensionUpdate(UpdateResource):
    """Describes a Virtual Machine Extension.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar force_update_tag: How the extension handler should be forced to update even if the
     extension configuration has not changed.
    :vartype force_update_tag: str
    :ivar publisher: The name of the extension handler publisher.
    :vartype publisher: str
    :ivar type: Specifies the type of the extension; an example is "CustomScriptExtension".
    :vartype type: str
    :ivar type_handler_version: Specifies the version of the script handler.
    :vartype type_handler_version: str
    :ivar auto_upgrade_minor_version: Indicates whether the extension should use a newer minor
     version if one is available at deployment time. Once deployed, however, the extension will not
     upgrade minor versions unless redeployed, even with this property set to true.
    :vartype auto_upgrade_minor_version: bool
    :ivar settings: Json formatted public settings for the extension.
    :vartype settings: JSON
    :ivar protected_settings: The extension can contain either protectedSettings or
     protectedSettingsFromKeyVault or no protected settings at all.
    :vartype protected_settings: JSON
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "force_update_tag": {"key": "properties.forceUpdateTag", "type": "str"},
        "publisher": {"key": "properties.publisher", "type": "str"},
        "type": {"key": "properties.type", "type": "str"},
        "type_handler_version": {"key": "properties.typeHandlerVersion", "type": "str"},
        "auto_upgrade_minor_version": {"key": "properties.autoUpgradeMinorVersion", "type": "bool"},
        "settings": {"key": "properties.settings", "type": "object"},
        "protected_settings": {"key": "properties.protectedSettings", "type": "object"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        force_update_tag: Optional[str] = None,
        publisher: Optional[str] = None,
        type: Optional[str] = None,
        type_handler_version: Optional[str] = None,
        auto_upgrade_minor_version: Optional[bool] = None,
        settings: Optional[JSON] = None,
        protected_settings: Optional[JSON] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword force_update_tag: How the extension handler should be forced to update even if the
         extension configuration has not changed.
        :paramtype force_update_tag: str
        :keyword publisher: The name of the extension handler publisher.
        :paramtype publisher: str
        :keyword type: Specifies the type of the extension; an example is "CustomScriptExtension".
        :paramtype type: str
        :keyword type_handler_version: Specifies the version of the script handler.
        :paramtype type_handler_version: str
        :keyword auto_upgrade_minor_version: Indicates whether the extension should use a newer minor
         version if one is available at deployment time. Once deployed, however, the extension will not
         upgrade minor versions unless redeployed, even with this property set to true.
        :paramtype auto_upgrade_minor_version: bool
        :keyword settings: Json formatted public settings for the extension.
        :paramtype settings: JSON
        :keyword protected_settings: The extension can contain either protectedSettings or
         protectedSettingsFromKeyVault or no protected settings at all.
        :paramtype protected_settings: JSON
        """
        super().__init__(tags=tags, **kwargs)
        self.force_update_tag = force_update_tag
        self.publisher = publisher
        self.type = type
        self.type_handler_version = type_handler_version
        self.auto_upgrade_minor_version = auto_upgrade_minor_version
        self.settings = settings
        self.protected_settings = protected_settings


class VirtualMachineIdentity(_serialization.Model):
    """Identity for the virtual machine.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of virtual machine identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant id associated with the virtual machine.
    :vartype tenant_id: str
    :ivar type: The type of identity used for the virtual machine. Currently, the only supported
     type is 'SystemAssigned', which implicitly creates an identity. Default value is
     "SystemAssigned".
    :vartype type: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, type: Optional[Literal["SystemAssigned"]] = None, **kwargs: Any) -> None:
        """
        :keyword type: The type of identity used for the virtual machine. Currently, the only supported
         type is 'SystemAssigned', which implicitly creates an identity. Default value is
         "SystemAssigned".
        :paramtype type: str
        """
        super().__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type


class VirtualMachineImageResource(SubResource):
    """Virtual machine image resource information.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: The name of the resource. Required.
    :vartype name: str
    :ivar location: The supported Azure location of the resource. Required.
    :vartype location: str
    :ivar tags: Specifies the tags that are assigned to the virtual machine. For more information
     about using tags, see `Using tags to organize your Azure resources
     <https://docs.microsoft.com/azure/azure-resource-manager/resource-group-using-tags.md>`_.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "name": {"required": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        name: str,
        location: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        tags: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Id.
        :paramtype id: str
        :keyword name: The name of the resource. Required.
        :paramtype name: str
        :keyword location: The supported Azure location of the resource. Required.
        :paramtype location: str
        :keyword tags: Specifies the tags that are assigned to the virtual machine. For more
         information about using tags, see `Using tags to organize your Azure resources
         <https://docs.microsoft.com/azure/azure-resource-manager/resource-group-using-tags.md>`_.
        :paramtype tags: dict[str, str]
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.location = location
        self.tags = tags


class VirtualMachineImage(VirtualMachineImageResource):
    """Describes a Virtual Machine Image.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: The name of the resource. Required.
    :vartype name: str
    :ivar location: The supported Azure location of the resource. Required.
    :vartype location: str
    :ivar tags: Specifies the tags that are assigned to the virtual machine. For more information
     about using tags, see `Using tags to organize your Azure resources
     <https://docs.microsoft.com/azure/azure-resource-manager/resource-group-using-tags.md>`_.
    :vartype tags: dict[str, str]
    :ivar plan: Used for establishing the purchase context of any 3rd Party artifact through
     MarketPlace.
    :vartype plan: ~azure.mgmt.compute.v2016_04_30_preview.models.PurchasePlan
    :ivar os_disk_image: Contains the os disk image information.
    :vartype os_disk_image: ~azure.mgmt.compute.v2016_04_30_preview.models.OSDiskImage
    :ivar data_disk_images:
    :vartype data_disk_images: list[~azure.mgmt.compute.v2016_04_30_preview.models.DataDiskImage]
    """

    _validation = {
        "name": {"required": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "plan": {"key": "properties.plan", "type": "PurchasePlan"},
        "os_disk_image": {"key": "properties.osDiskImage", "type": "OSDiskImage"},
        "data_disk_images": {"key": "properties.dataDiskImages", "type": "[DataDiskImage]"},
    }

    def __init__(
        self,
        *,
        name: str,
        location: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        tags: Optional[Dict[str, str]] = None,
        plan: Optional["_models.PurchasePlan"] = None,
        os_disk_image: Optional["_models.OSDiskImage"] = None,
        data_disk_images: Optional[List["_models.DataDiskImage"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Id.
        :paramtype id: str
        :keyword name: The name of the resource. Required.
        :paramtype name: str
        :keyword location: The supported Azure location of the resource. Required.
        :paramtype location: str
        :keyword tags: Specifies the tags that are assigned to the virtual machine. For more
         information about using tags, see `Using tags to organize your Azure resources
         <https://docs.microsoft.com/azure/azure-resource-manager/resource-group-using-tags.md>`_.
        :paramtype tags: dict[str, str]
        :keyword plan: Used for establishing the purchase context of any 3rd Party artifact through
         MarketPlace.
        :paramtype plan: ~azure.mgmt.compute.v2016_04_30_preview.models.PurchasePlan
        :keyword os_disk_image: Contains the os disk image information.
        :paramtype os_disk_image: ~azure.mgmt.compute.v2016_04_30_preview.models.OSDiskImage
        :keyword data_disk_images:
        :paramtype data_disk_images: list[~azure.mgmt.compute.v2016_04_30_preview.models.DataDiskImage]
        """
        super().__init__(id=id, name=name, location=location, tags=tags, **kwargs)
        self.plan = plan
        self.os_disk_image = os_disk_image
        self.data_disk_images = data_disk_images


class VirtualMachineInstanceView(_serialization.Model):
    """The instance view of a virtual machine.

    :ivar platform_update_domain: Specifies the update domain of the virtual machine.
    :vartype platform_update_domain: int
    :ivar platform_fault_domain: Specifies the fault domain of the virtual machine.
    :vartype platform_fault_domain: int
    :ivar rdp_thumb_print: The Remote desktop certificate thumbprint.
    :vartype rdp_thumb_print: str
    :ivar vm_agent: The VM Agent running on the virtual machine.
    :vartype vm_agent:
     ~azure.mgmt.compute.v2016_04_30_preview.models.VirtualMachineAgentInstanceView
    :ivar disks: The virtual machine disk information.
    :vartype disks: list[~azure.mgmt.compute.v2016_04_30_preview.models.DiskInstanceView]
    :ivar extensions: The extensions information.
    :vartype extensions:
     list[~azure.mgmt.compute.v2016_04_30_preview.models.VirtualMachineExtensionInstanceView]
    :ivar boot_diagnostics: Boot Diagnostics is a debugging feature which allows you to view
     Console Output and Screenshot to diagnose VM status. :code:`<br>`:code:`<br>` You can easily
     view the output of your console log. :code:`<br>`:code:`<br>` Azure also enables you to see a
     screenshot of the VM from the hypervisor.
    :vartype boot_diagnostics:
     ~azure.mgmt.compute.v2016_04_30_preview.models.BootDiagnosticsInstanceView
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.compute.v2016_04_30_preview.models.InstanceViewStatus]
    """

    _attribute_map = {
        "platform_update_domain": {"key": "platformUpdateDomain", "type": "int"},
        "platform_fault_domain": {"key": "platformFaultDomain", "type": "int"},
        "rdp_thumb_print": {"key": "rdpThumbPrint", "type": "str"},
        "vm_agent": {"key": "vmAgent", "type": "VirtualMachineAgentInstanceView"},
        "disks": {"key": "disks", "type": "[DiskInstanceView]"},
        "extensions": {"key": "extensions", "type": "[VirtualMachineExtensionInstanceView]"},
        "boot_diagnostics": {"key": "bootDiagnostics", "type": "BootDiagnosticsInstanceView"},
        "statuses": {"key": "statuses", "type": "[InstanceViewStatus]"},
    }

    def __init__(
        self,
        *,
        platform_update_domain: Optional[int] = None,
        platform_fault_domain: Optional[int] = None,
        rdp_thumb_print: Optional[str] = None,
        vm_agent: Optional["_models.VirtualMachineAgentInstanceView"] = None,
        disks: Optional[List["_models.DiskInstanceView"]] = None,
        extensions: Optional[List["_models.VirtualMachineExtensionInstanceView"]] = None,
        boot_diagnostics: Optional["_models.BootDiagnosticsInstanceView"] = None,
        statuses: Optional[List["_models.InstanceViewStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword platform_update_domain: Specifies the update domain of the virtual machine.
        :paramtype platform_update_domain: int
        :keyword platform_fault_domain: Specifies the fault domain of the virtual machine.
        :paramtype platform_fault_domain: int
        :keyword rdp_thumb_print: The Remote desktop certificate thumbprint.
        :paramtype rdp_thumb_print: str
        :keyword vm_agent: The VM Agent running on the virtual machine.
        :paramtype vm_agent:
         ~azure.mgmt.compute.v2016_04_30_preview.models.VirtualMachineAgentInstanceView
        :keyword disks: The virtual machine disk information.
        :paramtype disks: list[~azure.mgmt.compute.v2016_04_30_preview.models.DiskInstanceView]
        :keyword extensions: The extensions information.
        :paramtype extensions:
         list[~azure.mgmt.compute.v2016_04_30_preview.models.VirtualMachineExtensionInstanceView]
        :keyword boot_diagnostics: Boot Diagnostics is a debugging feature which allows you to view
         Console Output and Screenshot to diagnose VM status. :code:`<br>`:code:`<br>` You can easily
         view the output of your console log. :code:`<br>`:code:`<br>` Azure also enables you to see a
         screenshot of the VM from the hypervisor.
        :paramtype boot_diagnostics:
         ~azure.mgmt.compute.v2016_04_30_preview.models.BootDiagnosticsInstanceView
        :keyword statuses: The resource status information.
        :paramtype statuses: list[~azure.mgmt.compute.v2016_04_30_preview.models.InstanceViewStatus]
        """
        super().__init__(**kwargs)
        self.platform_update_domain = platform_update_domain
        self.platform_fault_domain = platform_fault_domain
        self.rdp_thumb_print = rdp_thumb_print
        self.vm_agent = vm_agent
        self.disks = disks
        self.extensions = extensions
        self.boot_diagnostics = boot_diagnostics
        self.statuses = statuses


class VirtualMachineListResult(_serialization.Model):
    """The List Virtual Machine operation response.

    All required parameters must be populated in order to send to server.

    :ivar value: The list of virtual machines. Required.
    :vartype value: list[~azure.mgmt.compute.v2016_04_30_preview.models.VirtualMachine]
    :ivar next_link: The URI to fetch the next page of VMs. Call ListNext() with this URI to fetch
     the next page of Virtual Machines.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualMachine]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.VirtualMachine"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of virtual machines. Required.
        :paramtype value: list[~azure.mgmt.compute.v2016_04_30_preview.models.VirtualMachine]
        :keyword next_link: The URI to fetch the next page of VMs. Call ListNext() with this URI to
         fetch the next page of Virtual Machines.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VirtualMachineScaleSet(Resource):
    """Describes a Virtual Machine Scale Set.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: The virtual machine scale set sku.
    :vartype sku: ~azure.mgmt.compute.v2016_04_30_preview.models.Sku
    :ivar plan: Specifies information about the marketplace image used to create the virtual
     machine. This element is only used for marketplace images. Before you can use a marketplace
     image from an API, you must enable the image for programmatic use.  In the Azure portal, find
     the marketplace image that you want to use and then click **Want to deploy programmatically,
     Get Started ->**. Enter any required information and then click **Save**.
    :vartype plan: ~azure.mgmt.compute.v2016_04_30_preview.models.Plan
    :ivar identity: The identity of the virtual machine scale set, if configured.
    :vartype identity:
     ~azure.mgmt.compute.v2016_04_30_preview.models.VirtualMachineScaleSetIdentity
    :ivar upgrade_policy: The upgrade policy.
    :vartype upgrade_policy: ~azure.mgmt.compute.v2016_04_30_preview.models.UpgradePolicy
    :ivar virtual_machine_profile: The virtual machine profile.
    :vartype virtual_machine_profile:
     ~azure.mgmt.compute.v2016_04_30_preview.models.VirtualMachineScaleSetVMProfile
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :ivar over_provision: Specifies whether the Virtual Machine Scale Set should be
     overprovisioned.
    :vartype over_provision: bool
    :ivar single_placement_group: When true this limits the scale set to a single placement group,
     of max size 100 virtual machines.
    :vartype single_placement_group: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "Sku"},
        "plan": {"key": "plan", "type": "Plan"},
        "identity": {"key": "identity", "type": "VirtualMachineScaleSetIdentity"},
        "upgrade_policy": {"key": "properties.upgradePolicy", "type": "UpgradePolicy"},
        "virtual_machine_profile": {
            "key": "properties.virtualMachineProfile",
            "type": "VirtualMachineScaleSetVMProfile",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "over_provision": {"key": "properties.overProvision", "type": "bool"},
        "single_placement_group": {"key": "properties.singlePlacementGroup", "type": "bool"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["_models.Sku"] = None,
        plan: Optional["_models.Plan"] = None,
        identity: Optional["_models.VirtualMachineScaleSetIdentity"] = None,
        upgrade_policy: Optional["_models.UpgradePolicy"] = None,
        virtual_machine_profile: Optional["_models.VirtualMachineScaleSetVMProfile"] = None,
        over_provision: Optional[bool] = None,
        single_placement_group: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: The virtual machine scale set sku.
        :paramtype sku: ~azure.mgmt.compute.v2016_04_30_preview.models.Sku
        :keyword plan: Specifies information about the marketplace image used to create the virtual
         machine. This element is only used for marketplace images. Before you can use a marketplace
         image from an API, you must enable the image for programmatic use.  In the Azure portal, find
         the marketplace image that you want to use and then click **Want to deploy programmatically,
         Get Started ->**. Enter any required information and then click **Save**.
        :paramtype plan: ~azure.mgmt.compute.v2016_04_30_preview.models.Plan
        :keyword identity: The identity of the virtual machine scale set, if configured.
        :paramtype identity:
         ~azure.mgmt.compute.v2016_04_30_preview.models.VirtualMachineScaleSetIdentity
        :keyword upgrade_policy: The upgrade policy.
        :paramtype upgrade_policy: ~azure.mgmt.compute.v2016_04_30_preview.models.UpgradePolicy
        :keyword virtual_machine_profile: The virtual machine profile.
        :paramtype virtual_machine_profile:
         ~azure.mgmt.compute.v2016_04_30_preview.models.VirtualMachineScaleSetVMProfile
        :keyword over_provision: Specifies whether the Virtual Machine Scale Set should be
         overprovisioned.
        :paramtype over_provision: bool
        :keyword single_placement_group: When true this limits the scale set to a single placement
         group, of max size 100 virtual machines.
        :paramtype single_placement_group: bool
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.sku = sku
        self.plan = plan
        self.identity = identity
        self.upgrade_policy = upgrade_policy
        self.virtual_machine_profile = virtual_machine_profile
        self.provisioning_state = None
        self.over_provision = over_provision
        self.single_placement_group = single_placement_group


class VirtualMachineScaleSetDataDisk(_serialization.Model):
    """Describes a virtual machine scale set data disk.

    All required parameters must be populated in order to send to server.

    :ivar name: The disk name.
    :vartype name: str
    :ivar lun: Specifies the logical unit number of the data disk. This value is used to identify
     data disks within the VM and therefore must be unique for each data disk attached to a VM.
     Required.
    :vartype lun: int
    :ivar caching: Specifies the caching requirements. :code:`<br>`:code:`<br>` Possible values
     are: :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **ReadOnly**
     :code:`<br>`:code:`<br>` **ReadWrite** :code:`<br>`:code:`<br>` Default: **None for Standard
     storage. ReadOnly for Premium storage**. Known values are: "None", "ReadOnly", and "ReadWrite".
    :vartype caching: str or ~azure.mgmt.compute.v2016_04_30_preview.models.CachingTypes
    :ivar create_option: The create option. Required. Known values are: "FromImage", "Empty", and
     "Attach".
    :vartype create_option: str or
     ~azure.mgmt.compute.v2016_04_30_preview.models.DiskCreateOptionTypes
    :ivar disk_size_gb: Specifies the size of an empty data disk in gigabytes. This element can be
     used to overwrite the size of the disk in a virtual machine image. :code:`<br>`:code:`<br>`
     This value cannot be larger than 1023 GB.
    :vartype disk_size_gb: int
    :ivar managed_disk: The managed disk parameters.
    :vartype managed_disk:
     ~azure.mgmt.compute.v2016_04_30_preview.models.VirtualMachineScaleSetManagedDiskParameters
    """

    _validation = {
        "lun": {"required": True},
        "create_option": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "lun": {"key": "lun", "type": "int"},
        "caching": {"key": "caching", "type": "str"},
        "create_option": {"key": "createOption", "type": "str"},
        "disk_size_gb": {"key": "diskSizeGB", "type": "int"},
        "managed_disk": {"key": "managedDisk", "type": "VirtualMachineScaleSetManagedDiskParameters"},
    }

    def __init__(
        self,
        *,
        lun: int,
        create_option: Union[str, "_models.DiskCreateOptionTypes"],
        name: Optional[str] = None,
        caching: Optional[Union[str, "_models.CachingTypes"]] = None,
        disk_size_gb: Optional[int] = None,
        managed_disk: Optional["_models.VirtualMachineScaleSetManagedDiskParameters"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The disk name.
        :paramtype name: str
        :keyword lun: Specifies the logical unit number of the data disk. This value is used to
         identify data disks within the VM and therefore must be unique for each data disk attached to a
         VM. Required.
        :paramtype lun: int
        :keyword caching: Specifies the caching requirements. :code:`<br>`:code:`<br>` Possible values
         are: :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **ReadOnly**
         :code:`<br>`:code:`<br>` **ReadWrite** :code:`<br>`:code:`<br>` Default: **None for Standard
         storage. ReadOnly for Premium storage**. Known values are: "None", "ReadOnly", and "ReadWrite".
        :paramtype caching: str or ~azure.mgmt.compute.v2016_04_30_preview.models.CachingTypes
        :keyword create_option: The create option. Required. Known values are: "FromImage", "Empty",
         and "Attach".
        :paramtype create_option: str or
         ~azure.mgmt.compute.v2016_04_30_preview.models.DiskCreateOptionTypes
        :keyword disk_size_gb: Specifies the size of an empty data disk in gigabytes. This element can
         be used to overwrite the size of the disk in a virtual machine image. :code:`<br>`:code:`<br>`
         This value cannot be larger than 1023 GB.
        :paramtype disk_size_gb: int
        :keyword managed_disk: The managed disk parameters.
        :paramtype managed_disk:
         ~azure.mgmt.compute.v2016_04_30_preview.models.VirtualMachineScaleSetManagedDiskParameters
        """
        super().__init__(**kwargs)
        self.name = name
        self.lun = lun
        self.caching = caching
        self.create_option = create_option
        self.disk_size_gb = disk_size_gb
        self.managed_disk = managed_disk


class VirtualMachineScaleSetExtension(SubResourceReadOnly):
    """Describes a Virtual Machine Scale Set Extension.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: The name of the extension.
    :vartype name: str
    :ivar publisher: The name of the extension handler publisher.
    :vartype publisher: str
    :ivar type: Specifies the type of the extension; an example is "CustomScriptExtension".
    :vartype type: str
    :ivar type_handler_version: Specifies the version of the script handler.
    :vartype type_handler_version: str
    :ivar auto_upgrade_minor_version: Indicates whether the extension should use a newer minor
     version if one is available at deployment time. Once deployed, however, the extension will not
     upgrade minor versions unless redeployed, even with this property set to true.
    :vartype auto_upgrade_minor_version: bool
    :ivar settings: Json formatted public settings for the extension.
    :vartype settings: JSON
    :ivar protected_settings: The extension can contain either protectedSettings or
     protectedSettingsFromKeyVault or no protected settings at all.
    :vartype protected_settings: JSON
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    """

    _validation = {
        "id": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "publisher": {"key": "properties.publisher", "type": "str"},
        "type": {"key": "properties.type", "type": "str"},
        "type_handler_version": {"key": "properties.typeHandlerVersion", "type": "str"},
        "auto_upgrade_minor_version": {"key": "properties.autoUpgradeMinorVersion", "type": "bool"},
        "settings": {"key": "properties.settings", "type": "object"},
        "protected_settings": {"key": "properties.protectedSettings", "type": "object"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        publisher: Optional[str] = None,
        type: Optional[str] = None,
        type_handler_version: Optional[str] = None,
        auto_upgrade_minor_version: Optional[bool] = None,
        settings: Optional[JSON] = None,
        protected_settings: Optional[JSON] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the extension.
        :paramtype name: str
        :keyword publisher: The name of the extension handler publisher.
        :paramtype publisher: str
        :keyword type: Specifies the type of the extension; an example is "CustomScriptExtension".
        :paramtype type: str
        :keyword type_handler_version: Specifies the version of the script handler.
        :paramtype type_handler_version: str
        :keyword auto_upgrade_minor_version: Indicates whether the extension should use a newer minor
         version if one is available at deployment time. Once deployed, however, the extension will not
         upgrade minor versions unless redeployed, even with this property set to true.
        :paramtype auto_upgrade_minor_version: bool
        :keyword settings: Json formatted public settings for the extension.
        :paramtype settings: JSON
        :keyword protected_settings: The extension can contain either protectedSettings or
         protectedSettingsFromKeyVault or no protected settings at all.
        :paramtype protected_settings: JSON
        """
        super().__init__(**kwargs)
        self.name = name
        self.publisher = publisher
        self.type = type
        self.type_handler_version = type_handler_version
        self.auto_upgrade_minor_version = auto_upgrade_minor_version
        self.settings = settings
        self.protected_settings = protected_settings
        self.provisioning_state = None


class VirtualMachineScaleSetExtensionProfile(_serialization.Model):
    """Describes a virtual machine scale set extension profile.

    :ivar extensions: The virtual machine scale set child extension resources.
    :vartype extensions:
     list[~azure.mgmt.compute.v2016_04_30_preview.models.VirtualMachineScaleSetExtension]
    """

    _attribute_map = {
        "extensions": {"key": "extensions", "type": "[VirtualMachineScaleSetExtension]"},
    }

    def __init__(
        self, *, extensions: Optional[List["_models.VirtualMachineScaleSetExtension"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword extensions: The virtual machine scale set child extension resources.
        :paramtype extensions:
         list[~azure.mgmt.compute.v2016_04_30_preview.models.VirtualMachineScaleSetExtension]
        """
        super().__init__(**kwargs)
        self.extensions = extensions


class VirtualMachineScaleSetIdentity(_serialization.Model):
    """Identity for the virtual machine scale set.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of virtual machine scale set identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant id associated with the virtual machine scale set.
    :vartype tenant_id: str
    :ivar type: The type of identity used for the virtual machine scale set. Currently, the only
     supported type is 'SystemAssigned', which implicitly creates an identity. Default value is
     "SystemAssigned".
    :vartype type: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, type: Optional[Literal["SystemAssigned"]] = None, **kwargs: Any) -> None:
        """
        :keyword type: The type of identity used for the virtual machine scale set. Currently, the only
         supported type is 'SystemAssigned', which implicitly creates an identity. Default value is
         "SystemAssigned".
        :paramtype type: str
        """
        super().__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type


class VirtualMachineScaleSetInstanceView(_serialization.Model):
    """The instance view of a virtual machine scale set.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar virtual_machine: The instance view status summary for the virtual machine scale set.
    :vartype virtual_machine:
     ~azure.mgmt.compute.v2016_04_30_preview.models.VirtualMachineScaleSetInstanceViewStatusesSummary
    :ivar extensions: The extensions information.
    :vartype extensions:
     list[~azure.mgmt.compute.v2016_04_30_preview.models.VirtualMachineScaleSetVMExtensionsSummary]
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.compute.v2016_04_30_preview.models.InstanceViewStatus]
    """

    _validation = {
        "virtual_machine": {"readonly": True},
        "extensions": {"readonly": True},
    }

    _attribute_map = {
        "virtual_machine": {"key": "virtualMachine", "type": "VirtualMachineScaleSetInstanceViewStatusesSummary"},
        "extensions": {"key": "extensions", "type": "[VirtualMachineScaleSetVMExtensionsSummary]"},
        "statuses": {"key": "statuses", "type": "[InstanceViewStatus]"},
    }

    def __init__(self, *, statuses: Optional[List["_models.InstanceViewStatus"]] = None, **kwargs: Any) -> None:
        """
        :keyword statuses: The resource status information.
        :paramtype statuses: list[~azure.mgmt.compute.v2016_04_30_preview.models.InstanceViewStatus]
        """
        super().__init__(**kwargs)
        self.virtual_machine = None
        self.extensions = None
        self.statuses = statuses


class VirtualMachineScaleSetInstanceViewStatusesSummary(_serialization.Model):  # pylint: disable=name-too-long
    """Instance view statuses summary for virtual machines of a virtual machine scale set.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar statuses_summary: The extensions information.
    :vartype statuses_summary:
     list[~azure.mgmt.compute.v2016_04_30_preview.models.VirtualMachineStatusCodeCount]
    """

    _validation = {
        "statuses_summary": {"readonly": True},
    }

    _attribute_map = {
        "statuses_summary": {"key": "statusesSummary", "type": "[VirtualMachineStatusCodeCount]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.statuses_summary = None


class VirtualMachineScaleSetIPConfiguration(SubResource):
    """Describes a virtual machine scale set network profile's IP configuration.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: The IP configuration name. Required.
    :vartype name: str
    :ivar subnet: The subnet.
    :vartype subnet: ~azure.mgmt.compute.v2016_04_30_preview.models.ApiEntityReference
    :ivar application_gateway_backend_address_pools: The application gateway backend address pools.
    :vartype application_gateway_backend_address_pools:
     list[~azure.mgmt.compute.v2016_04_30_preview.models.SubResource]
    :ivar load_balancer_backend_address_pools: The load balancer backend address pools.
    :vartype load_balancer_backend_address_pools:
     list[~azure.mgmt.compute.v2016_04_30_preview.models.SubResource]
    :ivar load_balancer_inbound_nat_pools: The load balancer inbound nat pools.
    :vartype load_balancer_inbound_nat_pools:
     list[~azure.mgmt.compute.v2016_04_30_preview.models.SubResource]
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "subnet": {"key": "properties.subnet", "type": "ApiEntityReference"},
        "application_gateway_backend_address_pools": {
            "key": "properties.applicationGatewayBackendAddressPools",
            "type": "[SubResource]",
        },
        "load_balancer_backend_address_pools": {
            "key": "properties.loadBalancerBackendAddressPools",
            "type": "[SubResource]",
        },
        "load_balancer_inbound_nat_pools": {"key": "properties.loadBalancerInboundNatPools", "type": "[SubResource]"},
    }

    def __init__(
        self,
        *,
        name: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        subnet: Optional["_models.ApiEntityReference"] = None,
        application_gateway_backend_address_pools: Optional[List["_models.SubResource"]] = None,
        load_balancer_backend_address_pools: Optional[List["_models.SubResource"]] = None,
        load_balancer_inbound_nat_pools: Optional[List["_models.SubResource"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Id.
        :paramtype id: str
        :keyword name: The IP configuration name. Required.
        :paramtype name: str
        :keyword subnet: The subnet.
        :paramtype subnet: ~azure.mgmt.compute.v2016_04_30_preview.models.ApiEntityReference
        :keyword application_gateway_backend_address_pools: The application gateway backend address
         pools.
        :paramtype application_gateway_backend_address_pools:
         list[~azure.mgmt.compute.v2016_04_30_preview.models.SubResource]
        :keyword load_balancer_backend_address_pools: The load balancer backend address pools.
        :paramtype load_balancer_backend_address_pools:
         list[~azure.mgmt.compute.v2016_04_30_preview.models.SubResource]
        :keyword load_balancer_inbound_nat_pools: The load balancer inbound nat pools.
        :paramtype load_balancer_inbound_nat_pools:
         list[~azure.mgmt.compute.v2016_04_30_preview.models.SubResource]
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.subnet = subnet
        self.application_gateway_backend_address_pools = application_gateway_backend_address_pools
        self.load_balancer_backend_address_pools = load_balancer_backend_address_pools
        self.load_balancer_inbound_nat_pools = load_balancer_inbound_nat_pools


class VirtualMachineScaleSetListResult(_serialization.Model):
    """The List Virtual Machine operation response.

    All required parameters must be populated in order to send to server.

    :ivar value: The list of virtual machine scale sets. Required.
    :vartype value: list[~azure.mgmt.compute.v2016_04_30_preview.models.VirtualMachineScaleSet]
    :ivar next_link: The uri to fetch the next page of Virtual Machine Scale Sets. Call ListNext()
     with this to fetch the next page of VMSS.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualMachineScaleSet]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.VirtualMachineScaleSet"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of virtual machine scale sets. Required.
        :paramtype value: list[~azure.mgmt.compute.v2016_04_30_preview.models.VirtualMachineScaleSet]
        :keyword next_link: The uri to fetch the next page of Virtual Machine Scale Sets. Call
         ListNext() with this to fetch the next page of VMSS.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VirtualMachineScaleSetListSkusResult(_serialization.Model):
    """The Virtual Machine Scale Set List Skus operation response.

    All required parameters must be populated in order to send to server.

    :ivar value: The list of skus available for the virtual machine scale set. Required.
    :vartype value: list[~azure.mgmt.compute.v2016_04_30_preview.models.VirtualMachineScaleSetSku]
    :ivar next_link: The uri to fetch the next page of Virtual Machine Scale Set Skus. Call
     ListNext() with this to fetch the next page of VMSS Skus.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualMachineScaleSetSku]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.VirtualMachineScaleSetSku"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of skus available for the virtual machine scale set. Required.
        :paramtype value:
         list[~azure.mgmt.compute.v2016_04_30_preview.models.VirtualMachineScaleSetSku]
        :keyword next_link: The uri to fetch the next page of Virtual Machine Scale Set Skus. Call
         ListNext() with this to fetch the next page of VMSS Skus.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VirtualMachineScaleSetListWithLinkResult(_serialization.Model):
    """The List Virtual Machine operation response.

    All required parameters must be populated in order to send to server.

    :ivar value: The list of virtual machine scale sets. Required.
    :vartype value: list[~azure.mgmt.compute.v2016_04_30_preview.models.VirtualMachineScaleSet]
    :ivar next_link: The uri to fetch the next page of Virtual Machine Scale Sets. Call ListNext()
     with this to fetch the next page of Virtual Machine Scale Sets.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualMachineScaleSet]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.VirtualMachineScaleSet"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of virtual machine scale sets. Required.
        :paramtype value: list[~azure.mgmt.compute.v2016_04_30_preview.models.VirtualMachineScaleSet]
        :keyword next_link: The uri to fetch the next page of Virtual Machine Scale Sets. Call
         ListNext() with this to fetch the next page of Virtual Machine Scale Sets.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VirtualMachineScaleSetManagedDiskParameters(_serialization.Model):  # pylint: disable=name-too-long
    """Describes the parameters of a ScaleSet managed disk.

    :ivar storage_account_type: Specifies the storage account type for the managed disk. Possible
     values are: Standard_LRS or Premium_LRS. Known values are: "Standard_LRS" and "Premium_LRS".
    :vartype storage_account_type: str or
     ~azure.mgmt.compute.v2016_04_30_preview.models.StorageAccountTypes
    """

    _attribute_map = {
        "storage_account_type": {"key": "storageAccountType", "type": "str"},
    }

    def __init__(
        self, *, storage_account_type: Optional[Union[str, "_models.StorageAccountTypes"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword storage_account_type: Specifies the storage account type for the managed disk.
         Possible values are: Standard_LRS or Premium_LRS. Known values are: "Standard_LRS" and
         "Premium_LRS".
        :paramtype storage_account_type: str or
         ~azure.mgmt.compute.v2016_04_30_preview.models.StorageAccountTypes
        """
        super().__init__(**kwargs)
        self.storage_account_type = storage_account_type


class VirtualMachineScaleSetNetworkConfiguration(SubResource):  # pylint: disable=name-too-long
    """Describes a virtual machine scale set network profile's network configurations.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: The network configuration name. Required.
    :vartype name: str
    :ivar primary: Whether this is a primary NIC on a virtual machine.
    :vartype primary: bool
    :ivar ip_configurations: The virtual machine scale set IP Configuration.
    :vartype ip_configurations:
     list[~azure.mgmt.compute.v2016_04_30_preview.models.VirtualMachineScaleSetIPConfiguration]
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "primary": {"key": "properties.primary", "type": "bool"},
        "ip_configurations": {"key": "properties.ipConfigurations", "type": "[VirtualMachineScaleSetIPConfiguration]"},
    }

    def __init__(
        self,
        *,
        name: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        primary: Optional[bool] = None,
        ip_configurations: Optional[List["_models.VirtualMachineScaleSetIPConfiguration"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Id.
        :paramtype id: str
        :keyword name: The network configuration name. Required.
        :paramtype name: str
        :keyword primary: Whether this is a primary NIC on a virtual machine.
        :paramtype primary: bool
        :keyword ip_configurations: The virtual machine scale set IP Configuration.
        :paramtype ip_configurations:
         list[~azure.mgmt.compute.v2016_04_30_preview.models.VirtualMachineScaleSetIPConfiguration]
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.primary = primary
        self.ip_configurations = ip_configurations


class VirtualMachineScaleSetNetworkProfile(_serialization.Model):
    """Describes a virtual machine scale set network profile.

    :ivar network_interface_configurations: The list of network configurations.
    :vartype network_interface_configurations:
     list[~azure.mgmt.compute.v2016_04_30_preview.models.VirtualMachineScaleSetNetworkConfiguration]
    """

    _attribute_map = {
        "network_interface_configurations": {
            "key": "networkInterfaceConfigurations",
            "type": "[VirtualMachineScaleSetNetworkConfiguration]",
        },
    }

    def __init__(
        self,
        *,
        network_interface_configurations: Optional[List["_models.VirtualMachineScaleSetNetworkConfiguration"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword network_interface_configurations: The list of network configurations.
        :paramtype network_interface_configurations:
         list[~azure.mgmt.compute.v2016_04_30_preview.models.VirtualMachineScaleSetNetworkConfiguration]
        """
        super().__init__(**kwargs)
        self.network_interface_configurations = network_interface_configurations


class VirtualMachineScaleSetOSDisk(_serialization.Model):
    """Describes a virtual machine scale set operating system disk.

    All required parameters must be populated in order to send to server.

    :ivar name: The disk name.
    :vartype name: str
    :ivar caching: Specifies the caching requirements. :code:`<br>`:code:`<br>` Possible values
     are: :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **ReadOnly**
     :code:`<br>`:code:`<br>` **ReadWrite** :code:`<br>`:code:`<br>` Default: **None for Standard
     storage. ReadOnly for Premium storage**. Known values are: "None", "ReadOnly", and "ReadWrite".
    :vartype caching: str or ~azure.mgmt.compute.v2016_04_30_preview.models.CachingTypes
    :ivar create_option: Specifies how the virtual machines in the scale set should be
     created.:code:`<br>`:code:`<br>` The only allowed value is: **FromImage** \\u2013 This value is
     used when you are using an image to create the virtual machine. If you are using a platform
     image, you also use the imageReference element described above. If you are using a marketplace
     image, you  also use the plan element previously described. Required. Known values are:
     "FromImage", "Empty", and "Attach".
    :vartype create_option: str or
     ~azure.mgmt.compute.v2016_04_30_preview.models.DiskCreateOptionTypes
    :ivar os_type: This property allows you to specify the type of the OS that is included in the
     disk if creating a VM from user-image or a specialized VHD. :code:`<br>`:code:`<br>` Possible
     values are: :code:`<br>`:code:`<br>` **Windows** :code:`<br>`:code:`<br>` **Linux**. Known
     values are: "Windows" and "Linux".
    :vartype os_type: str or ~azure.mgmt.compute.v2016_04_30_preview.models.OperatingSystemTypes
    :ivar image: The Source User Image VirtualHardDisk. This VirtualHardDisk will be copied before
     using it to attach to the Virtual Machine. If SourceImage is provided, the destination
     VirtualHardDisk should not exist.
    :vartype image: ~azure.mgmt.compute.v2016_04_30_preview.models.VirtualHardDisk
    :ivar vhd_containers: The list of virtual hard disk container uris.
    :vartype vhd_containers: list[str]
    :ivar managed_disk: The managed disk parameters.
    :vartype managed_disk:
     ~azure.mgmt.compute.v2016_04_30_preview.models.VirtualMachineScaleSetManagedDiskParameters
    """

    _validation = {
        "create_option": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "caching": {"key": "caching", "type": "str"},
        "create_option": {"key": "createOption", "type": "str"},
        "os_type": {"key": "osType", "type": "str"},
        "image": {"key": "image", "type": "VirtualHardDisk"},
        "vhd_containers": {"key": "vhdContainers", "type": "[str]"},
        "managed_disk": {"key": "managedDisk", "type": "VirtualMachineScaleSetManagedDiskParameters"},
    }

    def __init__(
        self,
        *,
        create_option: Union[str, "_models.DiskCreateOptionTypes"],
        name: Optional[str] = None,
        caching: Optional[Union[str, "_models.CachingTypes"]] = None,
        os_type: Optional[Union[str, "_models.OperatingSystemTypes"]] = None,
        image: Optional["_models.VirtualHardDisk"] = None,
        vhd_containers: Optional[List[str]] = None,
        managed_disk: Optional["_models.VirtualMachineScaleSetManagedDiskParameters"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The disk name.
        :paramtype name: str
        :keyword caching: Specifies the caching requirements. :code:`<br>`:code:`<br>` Possible values
         are: :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **ReadOnly**
         :code:`<br>`:code:`<br>` **ReadWrite** :code:`<br>`:code:`<br>` Default: **None for Standard
         storage. ReadOnly for Premium storage**. Known values are: "None", "ReadOnly", and "ReadWrite".
        :paramtype caching: str or ~azure.mgmt.compute.v2016_04_30_preview.models.CachingTypes
        :keyword create_option: Specifies how the virtual machines in the scale set should be
         created.:code:`<br>`:code:`<br>` The only allowed value is: **FromImage** \\u2013 This value is
         used when you are using an image to create the virtual machine. If you are using a platform
         image, you also use the imageReference element described above. If you are using a marketplace
         image, you  also use the plan element previously described. Required. Known values are:
         "FromImage", "Empty", and "Attach".
        :paramtype create_option: str or
         ~azure.mgmt.compute.v2016_04_30_preview.models.DiskCreateOptionTypes
        :keyword os_type: This property allows you to specify the type of the OS that is included in
         the disk if creating a VM from user-image or a specialized VHD. :code:`<br>`:code:`<br>`
         Possible values are: :code:`<br>`:code:`<br>` **Windows** :code:`<br>`:code:`<br>` **Linux**.
         Known values are: "Windows" and "Linux".
        :paramtype os_type: str or ~azure.mgmt.compute.v2016_04_30_preview.models.OperatingSystemTypes
        :keyword image: The Source User Image VirtualHardDisk. This VirtualHardDisk will be copied
         before using it to attach to the Virtual Machine. If SourceImage is provided, the destination
         VirtualHardDisk should not exist.
        :paramtype image: ~azure.mgmt.compute.v2016_04_30_preview.models.VirtualHardDisk
        :keyword vhd_containers: The list of virtual hard disk container uris.
        :paramtype vhd_containers: list[str]
        :keyword managed_disk: The managed disk parameters.
        :paramtype managed_disk:
         ~azure.mgmt.compute.v2016_04_30_preview.models.VirtualMachineScaleSetManagedDiskParameters
        """
        super().__init__(**kwargs)
        self.name = name
        self.caching = caching
        self.create_option = create_option
        self.os_type = os_type
        self.image = image
        self.vhd_containers = vhd_containers
        self.managed_disk = managed_disk


class VirtualMachineScaleSetOSProfile(_serialization.Model):
    """Describes a virtual machine scale set OS profile.

    :ivar computer_name_prefix: Specifies the computer name prefix for all of the virtual machines
     in the scale set. Computer name prefixes must be 1 to 15 characters long.
    :vartype computer_name_prefix: str
    :ivar admin_username: Specifies the name of the administrator account. :code:`<br>`:code:`<br>`
     **Windows-only restriction:** Cannot end in "." :code:`<br>`:code:`<br>` **Disallowed values:**
     "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1",
     "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest",
     "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2",
     "test3", "user4", "user5". :code:`<br>`:code:`<br>` **Minimum-length (Linux):** 1  character
     :code:`<br>`:code:`<br>` **Max-length (Linux):** 64 characters :code:`<br>`:code:`<br>`
     **Max-length (Windows):** 20 characters  :code:`<br>`:code:`<br>`:code:`<li>` For root access
     to the Linux VM, see `Using root privileges on Linux virtual machines in Azure
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-use-root-privileges?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_\\  # pylint: disable=line-too-long
     :code:`<br>`:code:`<li>` For a list of built-in system users on Linux that should not be used
     in this field, see `Selecting User Names for Linux on Azure
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-usernames?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_.  # pylint: disable=line-too-long
    :vartype admin_username: str
    :ivar admin_password: Specifies the password of the administrator account.
     :code:`<br>`:code:`<br>` **Minimum-length (Windows):** 8 characters :code:`<br>`:code:`<br>`
     **Minimum-length (Linux):** 6 characters :code:`<br>`:code:`<br>` **Max-length (Windows):** 123
     characters :code:`<br>`:code:`<br>` **Max-length (Linux):** 72 characters
     :code:`<br>`:code:`<br>` **Complexity requirements:** 3 out of 4 conditions below need to be
     fulfilled :code:`<br>` Has lower characters :code:`<br>`Has upper characters :code:`<br>` Has a
     digit :code:`<br>` Has a special character (Regex match [\\W_]) :code:`<br>`:code:`<br>`
     **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word",
     "pass@word1", "Password!", "Password1", "Password22", "iloveyou!" :code:`<br>`:code:`<br>` For
     resetting the password, see `How to reset the Remote Desktop service or its login password in a
     Windows VM
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-reset-rdp?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_  # pylint: disable=line-too-long
     :code:`<br>`:code:`<br>` For resetting root password, see `Manage users, SSH, and check or
     repair disks on Azure Linux VMs using the VMAccess Extension
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-using-vmaccess-extension?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json#reset-root-password>`_.  # pylint: disable=line-too-long
    :vartype admin_password: str
    :ivar custom_data: A base-64 encoded string of custom data.
    :vartype custom_data: str
    :ivar windows_configuration: The Windows Configuration of the OS profile.
    :vartype windows_configuration:
     ~azure.mgmt.compute.v2016_04_30_preview.models.WindowsConfiguration
    :ivar linux_configuration: The Linux Configuration of the OS profile.
    :vartype linux_configuration: ~azure.mgmt.compute.v2016_04_30_preview.models.LinuxConfiguration
    :ivar secrets: The List of certificates for addition to the VM.
    :vartype secrets: list[~azure.mgmt.compute.v2016_04_30_preview.models.VaultSecretGroup]
    """

    _attribute_map = {
        "computer_name_prefix": {"key": "computerNamePrefix", "type": "str"},
        "admin_username": {"key": "adminUsername", "type": "str"},
        "admin_password": {"key": "adminPassword", "type": "str"},
        "custom_data": {"key": "customData", "type": "str"},
        "windows_configuration": {"key": "windowsConfiguration", "type": "WindowsConfiguration"},
        "linux_configuration": {"key": "linuxConfiguration", "type": "LinuxConfiguration"},
        "secrets": {"key": "secrets", "type": "[VaultSecretGroup]"},
    }

    def __init__(
        self,
        *,
        computer_name_prefix: Optional[str] = None,
        admin_username: Optional[str] = None,
        admin_password: Optional[str] = None,
        custom_data: Optional[str] = None,
        windows_configuration: Optional["_models.WindowsConfiguration"] = None,
        linux_configuration: Optional["_models.LinuxConfiguration"] = None,
        secrets: Optional[List["_models.VaultSecretGroup"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword computer_name_prefix: Specifies the computer name prefix for all of the virtual
         machines in the scale set. Computer name prefixes must be 1 to 15 characters long.
        :paramtype computer_name_prefix: str
        :keyword admin_username: Specifies the name of the administrator account.
         :code:`<br>`:code:`<br>` **Windows-only restriction:** Cannot end in "."
         :code:`<br>`:code:`<br>` **Disallowed values:** "administrator", "admin", "user", "user1",
         "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2",
         "aspnet", "backup", "console", "david", "guest", "john", "owner", "root", "server", "sql",
         "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5".
         :code:`<br>`:code:`<br>` **Minimum-length (Linux):** 1  character :code:`<br>`:code:`<br>`
         **Max-length (Linux):** 64 characters :code:`<br>`:code:`<br>` **Max-length (Windows):** 20
         characters  :code:`<br>`:code:`<br>`:code:`<li>` For root access to the Linux VM, see `Using
         root privileges on Linux virtual machines in Azure
         <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-use-root-privileges?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_\\  # pylint: disable=line-too-long
         :code:`<br>`:code:`<li>` For a list of built-in system users on Linux that should not be used
         in this field, see `Selecting User Names for Linux on Azure
         <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-usernames?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_.  # pylint: disable=line-too-long
        :paramtype admin_username: str
        :keyword admin_password: Specifies the password of the administrator account.
         :code:`<br>`:code:`<br>` **Minimum-length (Windows):** 8 characters :code:`<br>`:code:`<br>`
         **Minimum-length (Linux):** 6 characters :code:`<br>`:code:`<br>` **Max-length (Windows):** 123
         characters :code:`<br>`:code:`<br>` **Max-length (Linux):** 72 characters
         :code:`<br>`:code:`<br>` **Complexity requirements:** 3 out of 4 conditions below need to be
         fulfilled :code:`<br>` Has lower characters :code:`<br>`Has upper characters :code:`<br>` Has a
         digit :code:`<br>` Has a special character (Regex match [\\W_]) :code:`<br>`:code:`<br>`
         **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word",
         "pass@word1", "Password!", "Password1", "Password22", "iloveyou!" :code:`<br>`:code:`<br>` For
         resetting the password, see `How to reset the Remote Desktop service or its login password in a
         Windows VM
         <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-reset-rdp?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_  # pylint: disable=line-too-long
         :code:`<br>`:code:`<br>` For resetting root password, see `Manage users, SSH, and check or
         repair disks on Azure Linux VMs using the VMAccess Extension
         <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-using-vmaccess-extension?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json#reset-root-password>`_.  # pylint: disable=line-too-long
        :paramtype admin_password: str
        :keyword custom_data: A base-64 encoded string of custom data.
        :paramtype custom_data: str
        :keyword windows_configuration: The Windows Configuration of the OS profile.
        :paramtype windows_configuration:
         ~azure.mgmt.compute.v2016_04_30_preview.models.WindowsConfiguration
        :keyword linux_configuration: The Linux Configuration of the OS profile.
        :paramtype linux_configuration:
         ~azure.mgmt.compute.v2016_04_30_preview.models.LinuxConfiguration
        :keyword secrets: The List of certificates for addition to the VM.
        :paramtype secrets: list[~azure.mgmt.compute.v2016_04_30_preview.models.VaultSecretGroup]
        """
        super().__init__(**kwargs)
        self.computer_name_prefix = computer_name_prefix
        self.admin_username = admin_username
        self.admin_password = admin_password
        self.custom_data = custom_data
        self.windows_configuration = windows_configuration
        self.linux_configuration = linux_configuration
        self.secrets = secrets


class VirtualMachineScaleSetSku(_serialization.Model):
    """Describes an available virtual machine scale set sku.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar resource_type: The type of resource the sku applies to.
    :vartype resource_type: str
    :ivar sku: The Sku.
    :vartype sku: ~azure.mgmt.compute.v2016_04_30_preview.models.Sku
    :ivar capacity: Specifies the number of virtual machines in the scale set.
    :vartype capacity:
     ~azure.mgmt.compute.v2016_04_30_preview.models.VirtualMachineScaleSetSkuCapacity
    """

    _validation = {
        "resource_type": {"readonly": True},
        "sku": {"readonly": True},
        "capacity": {"readonly": True},
    }

    _attribute_map = {
        "resource_type": {"key": "resourceType", "type": "str"},
        "sku": {"key": "sku", "type": "Sku"},
        "capacity": {"key": "capacity", "type": "VirtualMachineScaleSetSkuCapacity"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.resource_type = None
        self.sku = None
        self.capacity = None


class VirtualMachineScaleSetSkuCapacity(_serialization.Model):
    """Describes scaling information of a sku.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar minimum: The minimum capacity.
    :vartype minimum: int
    :ivar maximum: The maximum capacity that can be set.
    :vartype maximum: int
    :ivar default_capacity: The default capacity.
    :vartype default_capacity: int
    :ivar scale_type: The scale type applicable to the sku. Known values are: "Automatic" and
     "None".
    :vartype scale_type: str or
     ~azure.mgmt.compute.v2016_04_30_preview.models.VirtualMachineScaleSetSkuScaleType
    """

    _validation = {
        "minimum": {"readonly": True},
        "maximum": {"readonly": True},
        "default_capacity": {"readonly": True},
        "scale_type": {"readonly": True},
    }

    _attribute_map = {
        "minimum": {"key": "minimum", "type": "int"},
        "maximum": {"key": "maximum", "type": "int"},
        "default_capacity": {"key": "defaultCapacity", "type": "int"},
        "scale_type": {"key": "scaleType", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.minimum = None
        self.maximum = None
        self.default_capacity = None
        self.scale_type = None


class VirtualMachineScaleSetStorageProfile(_serialization.Model):
    """Describes a virtual machine scale set storage profile.

    :ivar image_reference: The image reference.
    :vartype image_reference: ~azure.mgmt.compute.v2016_04_30_preview.models.ImageReference
    :ivar os_disk: The OS disk.
    :vartype os_disk: ~azure.mgmt.compute.v2016_04_30_preview.models.VirtualMachineScaleSetOSDisk
    :ivar data_disks: The data disks.
    :vartype data_disks:
     list[~azure.mgmt.compute.v2016_04_30_preview.models.VirtualMachineScaleSetDataDisk]
    """

    _attribute_map = {
        "image_reference": {"key": "imageReference", "type": "ImageReference"},
        "os_disk": {"key": "osDisk", "type": "VirtualMachineScaleSetOSDisk"},
        "data_disks": {"key": "dataDisks", "type": "[VirtualMachineScaleSetDataDisk]"},
    }

    def __init__(
        self,
        *,
        image_reference: Optional["_models.ImageReference"] = None,
        os_disk: Optional["_models.VirtualMachineScaleSetOSDisk"] = None,
        data_disks: Optional[List["_models.VirtualMachineScaleSetDataDisk"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword image_reference: The image reference.
        :paramtype image_reference: ~azure.mgmt.compute.v2016_04_30_preview.models.ImageReference
        :keyword os_disk: The OS disk.
        :paramtype os_disk: ~azure.mgmt.compute.v2016_04_30_preview.models.VirtualMachineScaleSetOSDisk
        :keyword data_disks: The data disks.
        :paramtype data_disks:
         list[~azure.mgmt.compute.v2016_04_30_preview.models.VirtualMachineScaleSetDataDisk]
        """
        super().__init__(**kwargs)
        self.image_reference = image_reference
        self.os_disk = os_disk
        self.data_disks = data_disks


class VirtualMachineScaleSetVM(Resource):
    """Describes a virtual machine scale set virtual machine.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar instance_id: The virtual machine instance ID.
    :vartype instance_id: str
    :ivar sku: The virtual machine SKU.
    :vartype sku: ~azure.mgmt.compute.v2016_04_30_preview.models.Sku
    :ivar plan: Specifies information about the marketplace image used to create the virtual
     machine. This element is only used for marketplace images. Before you can use a marketplace
     image from an API, you must enable the image for programmatic use.  In the Azure portal, find
     the marketplace image that you want to use and then click **Want to deploy programmatically,
     Get Started ->**. Enter any required information and then click **Save**.
    :vartype plan: ~azure.mgmt.compute.v2016_04_30_preview.models.Plan
    :ivar resources: The virtual machine child extension resources.
    :vartype resources:
     list[~azure.mgmt.compute.v2016_04_30_preview.models.VirtualMachineExtension]
    :ivar latest_model_applied: Specifies whether the latest model has been applied to the virtual
     machine.
    :vartype latest_model_applied: bool
    :ivar vm_id: Azure VM unique ID.
    :vartype vm_id: str
    :ivar instance_view: The virtual machine instance view.
    :vartype instance_view:
     ~azure.mgmt.compute.v2016_04_30_preview.models.VirtualMachineScaleSetVMInstanceView
    :ivar hardware_profile: Specifies the hardware settings for the virtual machine.
    :vartype hardware_profile: ~azure.mgmt.compute.v2016_04_30_preview.models.HardwareProfile
    :ivar storage_profile: Specifies the storage settings for the virtual machine disks.
    :vartype storage_profile: ~azure.mgmt.compute.v2016_04_30_preview.models.StorageProfile
    :ivar os_profile: Specifies the operating system settings for the virtual machine.
    :vartype os_profile: ~azure.mgmt.compute.v2016_04_30_preview.models.OSProfile
    :ivar network_profile: Specifies the network interfaces of the virtual machine.
    :vartype network_profile: ~azure.mgmt.compute.v2016_04_30_preview.models.NetworkProfile
    :ivar diagnostics_profile: Specifies the boot diagnostic settings state.
     :code:`<br>`:code:`<br>`Minimum api-version: 2015-06-15.
    :vartype diagnostics_profile: ~azure.mgmt.compute.v2016_04_30_preview.models.DiagnosticsProfile
    :ivar availability_set: Specifies information about the availability set that the virtual
     machine should be assigned to. Virtual machines specified in the same availability set are
     allocated to different nodes to maximize availability. For more information about availability
     sets, see `Manage the availability of virtual machines
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-manage-availability?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_.  # pylint: disable=line-too-long
     :code:`<br>`:code:`<br>` For more information on Azure planned maintenance, see `Planned
     maintenance for virtual machines in Azure
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-planned-maintenance?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_  # pylint: disable=line-too-long
     :code:`<br>`:code:`<br>` Currently, a VM can only be added to availability set at creation
     time. An existing VM cannot be added to an availability set.
    :vartype availability_set: ~azure.mgmt.compute.v2016_04_30_preview.models.SubResource
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :ivar license_type: Specifies that the image or disk that is being used was licensed
     on-premises. This element is only used for images that contain the Windows Server operating
     system. :code:`<br>`:code:`<br>` Possible values are: :code:`<br>`:code:`<br>` Windows_Client
     :code:`<br>`:code:`<br>` Windows_Server :code:`<br>`:code:`<br>` If this element is included in
     a request for an update, the value must match the initial value. This value cannot be updated.
     :code:`<br>`:code:`<br>` For more information, see `Azure Hybrid Use Benefit for Windows Server
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-hybrid-use-benefit-licensing?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_  # pylint: disable=line-too-long
     :code:`<br>`:code:`<br>` Minimum api-version: 2015-06-15.
    :vartype license_type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "instance_id": {"readonly": True},
        "sku": {"readonly": True},
        "resources": {"readonly": True},
        "latest_model_applied": {"readonly": True},
        "vm_id": {"readonly": True},
        "instance_view": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "instance_id": {"key": "instanceId", "type": "str"},
        "sku": {"key": "sku", "type": "Sku"},
        "plan": {"key": "plan", "type": "Plan"},
        "resources": {"key": "resources", "type": "[VirtualMachineExtension]"},
        "latest_model_applied": {"key": "properties.latestModelApplied", "type": "bool"},
        "vm_id": {"key": "properties.vmId", "type": "str"},
        "instance_view": {"key": "properties.instanceView", "type": "VirtualMachineScaleSetVMInstanceView"},
        "hardware_profile": {"key": "properties.hardwareProfile", "type": "HardwareProfile"},
        "storage_profile": {"key": "properties.storageProfile", "type": "StorageProfile"},
        "os_profile": {"key": "properties.osProfile", "type": "OSProfile"},
        "network_profile": {"key": "properties.networkProfile", "type": "NetworkProfile"},
        "diagnostics_profile": {"key": "properties.diagnosticsProfile", "type": "DiagnosticsProfile"},
        "availability_set": {"key": "properties.availabilitySet", "type": "SubResource"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "license_type": {"key": "properties.licenseType", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        plan: Optional["_models.Plan"] = None,
        hardware_profile: Optional["_models.HardwareProfile"] = None,
        storage_profile: Optional["_models.StorageProfile"] = None,
        os_profile: Optional["_models.OSProfile"] = None,
        network_profile: Optional["_models.NetworkProfile"] = None,
        diagnostics_profile: Optional["_models.DiagnosticsProfile"] = None,
        availability_set: Optional["_models.SubResource"] = None,
        license_type: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword plan: Specifies information about the marketplace image used to create the virtual
         machine. This element is only used for marketplace images. Before you can use a marketplace
         image from an API, you must enable the image for programmatic use.  In the Azure portal, find
         the marketplace image that you want to use and then click **Want to deploy programmatically,
         Get Started ->**. Enter any required information and then click **Save**.
        :paramtype plan: ~azure.mgmt.compute.v2016_04_30_preview.models.Plan
        :keyword hardware_profile: Specifies the hardware settings for the virtual machine.
        :paramtype hardware_profile: ~azure.mgmt.compute.v2016_04_30_preview.models.HardwareProfile
        :keyword storage_profile: Specifies the storage settings for the virtual machine disks.
        :paramtype storage_profile: ~azure.mgmt.compute.v2016_04_30_preview.models.StorageProfile
        :keyword os_profile: Specifies the operating system settings for the virtual machine.
        :paramtype os_profile: ~azure.mgmt.compute.v2016_04_30_preview.models.OSProfile
        :keyword network_profile: Specifies the network interfaces of the virtual machine.
        :paramtype network_profile: ~azure.mgmt.compute.v2016_04_30_preview.models.NetworkProfile
        :keyword diagnostics_profile: Specifies the boot diagnostic settings state.
         :code:`<br>`:code:`<br>`Minimum api-version: 2015-06-15.
        :paramtype diagnostics_profile:
         ~azure.mgmt.compute.v2016_04_30_preview.models.DiagnosticsProfile
        :keyword availability_set: Specifies information about the availability set that the virtual
         machine should be assigned to. Virtual machines specified in the same availability set are
         allocated to different nodes to maximize availability. For more information about availability
         sets, see `Manage the availability of virtual machines
         <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-manage-availability?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_.  # pylint: disable=line-too-long
         :code:`<br>`:code:`<br>` For more information on Azure planned maintenance, see `Planned
         maintenance for virtual machines in Azure
         <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-planned-maintenance?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_  # pylint: disable=line-too-long
         :code:`<br>`:code:`<br>` Currently, a VM can only be added to availability set at creation
         time. An existing VM cannot be added to an availability set.
        :paramtype availability_set: ~azure.mgmt.compute.v2016_04_30_preview.models.SubResource
        :keyword license_type: Specifies that the image or disk that is being used was licensed
         on-premises. This element is only used for images that contain the Windows Server operating
         system. :code:`<br>`:code:`<br>` Possible values are: :code:`<br>`:code:`<br>` Windows_Client
         :code:`<br>`:code:`<br>` Windows_Server :code:`<br>`:code:`<br>` If this element is included in
         a request for an update, the value must match the initial value. This value cannot be updated.
         :code:`<br>`:code:`<br>` For more information, see `Azure Hybrid Use Benefit for Windows Server
         <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-hybrid-use-benefit-licensing?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_  # pylint: disable=line-too-long
         :code:`<br>`:code:`<br>` Minimum api-version: 2015-06-15.
        :paramtype license_type: str
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.instance_id = None
        self.sku = None
        self.plan = plan
        self.resources = None
        self.latest_model_applied = None
        self.vm_id = None
        self.instance_view = None
        self.hardware_profile = hardware_profile
        self.storage_profile = storage_profile
        self.os_profile = os_profile
        self.network_profile = network_profile
        self.diagnostics_profile = diagnostics_profile
        self.availability_set = availability_set
        self.provisioning_state = None
        self.license_type = license_type


class VirtualMachineScaleSetVMExtensionsSummary(_serialization.Model):  # pylint: disable=name-too-long
    """Extensions summary for virtual machines of a virtual machine scale set.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The extension name.
    :vartype name: str
    :ivar statuses_summary: The extensions information.
    :vartype statuses_summary:
     list[~azure.mgmt.compute.v2016_04_30_preview.models.VirtualMachineStatusCodeCount]
    """

    _validation = {
        "name": {"readonly": True},
        "statuses_summary": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "statuses_summary": {"key": "statusesSummary", "type": "[VirtualMachineStatusCodeCount]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.statuses_summary = None


class VirtualMachineScaleSetVMInstanceIDs(_serialization.Model):
    """Specifies a list of virtual machine instance IDs from the VM scale set.

    :ivar instance_ids: The virtual machine scale set instance ids. Omitting the virtual machine
     scale set instance ids will result in the operation being performed on all virtual machines in
     the virtual machine scale set.
    :vartype instance_ids: list[str]
    """

    _attribute_map = {
        "instance_ids": {"key": "instanceIds", "type": "[str]"},
    }

    def __init__(self, *, instance_ids: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword instance_ids: The virtual machine scale set instance ids. Omitting the virtual machine
         scale set instance ids will result in the operation being performed on all virtual machines in
         the virtual machine scale set.
        :paramtype instance_ids: list[str]
        """
        super().__init__(**kwargs)
        self.instance_ids = instance_ids


class VirtualMachineScaleSetVMInstanceRequiredIDs(_serialization.Model):  # pylint: disable=name-too-long
    """Specifies a list of virtual machine instance IDs from the VM scale set.

    All required parameters must be populated in order to send to server.

    :ivar instance_ids: The virtual machine scale set instance ids. Required.
    :vartype instance_ids: list[str]
    """

    _validation = {
        "instance_ids": {"required": True},
    }

    _attribute_map = {
        "instance_ids": {"key": "instanceIds", "type": "[str]"},
    }

    def __init__(self, *, instance_ids: List[str], **kwargs: Any) -> None:
        """
        :keyword instance_ids: The virtual machine scale set instance ids. Required.
        :paramtype instance_ids: list[str]
        """
        super().__init__(**kwargs)
        self.instance_ids = instance_ids


class VirtualMachineScaleSetVMInstanceView(_serialization.Model):
    """The instance view of a virtual machine scale set VM.

    :ivar platform_update_domain: The Update Domain count.
    :vartype platform_update_domain: int
    :ivar platform_fault_domain: The Fault Domain count.
    :vartype platform_fault_domain: int
    :ivar rdp_thumb_print: The Remote desktop certificate thumbprint.
    :vartype rdp_thumb_print: str
    :ivar vm_agent: The VM Agent running on the virtual machine.
    :vartype vm_agent:
     ~azure.mgmt.compute.v2016_04_30_preview.models.VirtualMachineAgentInstanceView
    :ivar disks: The disks information.
    :vartype disks: list[~azure.mgmt.compute.v2016_04_30_preview.models.DiskInstanceView]
    :ivar extensions: The extensions information.
    :vartype extensions:
     list[~azure.mgmt.compute.v2016_04_30_preview.models.VirtualMachineExtensionInstanceView]
    :ivar boot_diagnostics: Boot Diagnostics is a debugging feature which allows you to view
     Console Output and Screenshot to diagnose VM status. :code:`<br>`:code:`<br>` You can easily
     view the output of your console log. :code:`<br>`:code:`<br>` Azure also enables you to see a
     screenshot of the VM from the hypervisor.
    :vartype boot_diagnostics:
     ~azure.mgmt.compute.v2016_04_30_preview.models.BootDiagnosticsInstanceView
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.compute.v2016_04_30_preview.models.InstanceViewStatus]
    :ivar placement_group_id: The placement group in which the VM is running. If the VM is
     deallocated it will not have a placementGroupId.
    :vartype placement_group_id: str
    """

    _attribute_map = {
        "platform_update_domain": {"key": "platformUpdateDomain", "type": "int"},
        "platform_fault_domain": {"key": "platformFaultDomain", "type": "int"},
        "rdp_thumb_print": {"key": "rdpThumbPrint", "type": "str"},
        "vm_agent": {"key": "vmAgent", "type": "VirtualMachineAgentInstanceView"},
        "disks": {"key": "disks", "type": "[DiskInstanceView]"},
        "extensions": {"key": "extensions", "type": "[VirtualMachineExtensionInstanceView]"},
        "boot_diagnostics": {"key": "bootDiagnostics", "type": "BootDiagnosticsInstanceView"},
        "statuses": {"key": "statuses", "type": "[InstanceViewStatus]"},
        "placement_group_id": {"key": "placementGroupId", "type": "str"},
    }

    def __init__(
        self,
        *,
        platform_update_domain: Optional[int] = None,
        platform_fault_domain: Optional[int] = None,
        rdp_thumb_print: Optional[str] = None,
        vm_agent: Optional["_models.VirtualMachineAgentInstanceView"] = None,
        disks: Optional[List["_models.DiskInstanceView"]] = None,
        extensions: Optional[List["_models.VirtualMachineExtensionInstanceView"]] = None,
        boot_diagnostics: Optional["_models.BootDiagnosticsInstanceView"] = None,
        statuses: Optional[List["_models.InstanceViewStatus"]] = None,
        placement_group_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword platform_update_domain: The Update Domain count.
        :paramtype platform_update_domain: int
        :keyword platform_fault_domain: The Fault Domain count.
        :paramtype platform_fault_domain: int
        :keyword rdp_thumb_print: The Remote desktop certificate thumbprint.
        :paramtype rdp_thumb_print: str
        :keyword vm_agent: The VM Agent running on the virtual machine.
        :paramtype vm_agent:
         ~azure.mgmt.compute.v2016_04_30_preview.models.VirtualMachineAgentInstanceView
        :keyword disks: The disks information.
        :paramtype disks: list[~azure.mgmt.compute.v2016_04_30_preview.models.DiskInstanceView]
        :keyword extensions: The extensions information.
        :paramtype extensions:
         list[~azure.mgmt.compute.v2016_04_30_preview.models.VirtualMachineExtensionInstanceView]
        :keyword boot_diagnostics: Boot Diagnostics is a debugging feature which allows you to view
         Console Output and Screenshot to diagnose VM status. :code:`<br>`:code:`<br>` You can easily
         view the output of your console log. :code:`<br>`:code:`<br>` Azure also enables you to see a
         screenshot of the VM from the hypervisor.
        :paramtype boot_diagnostics:
         ~azure.mgmt.compute.v2016_04_30_preview.models.BootDiagnosticsInstanceView
        :keyword statuses: The resource status information.
        :paramtype statuses: list[~azure.mgmt.compute.v2016_04_30_preview.models.InstanceViewStatus]
        :keyword placement_group_id: The placement group in which the VM is running. If the VM is
         deallocated it will not have a placementGroupId.
        :paramtype placement_group_id: str
        """
        super().__init__(**kwargs)
        self.platform_update_domain = platform_update_domain
        self.platform_fault_domain = platform_fault_domain
        self.rdp_thumb_print = rdp_thumb_print
        self.vm_agent = vm_agent
        self.disks = disks
        self.extensions = extensions
        self.boot_diagnostics = boot_diagnostics
        self.statuses = statuses
        self.placement_group_id = placement_group_id


class VirtualMachineScaleSetVMListResult(_serialization.Model):
    """The List Virtual Machine Scale Set VMs operation response.

    All required parameters must be populated in order to send to server.

    :ivar value: The list of virtual machine scale sets VMs. Required.
    :vartype value: list[~azure.mgmt.compute.v2016_04_30_preview.models.VirtualMachineScaleSetVM]
    :ivar next_link: The uri to fetch the next page of Virtual Machine Scale Set VMs. Call
     ListNext() with this to fetch the next page of VMSS VMs.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualMachineScaleSetVM]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.VirtualMachineScaleSetVM"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of virtual machine scale sets VMs. Required.
        :paramtype value: list[~azure.mgmt.compute.v2016_04_30_preview.models.VirtualMachineScaleSetVM]
        :keyword next_link: The uri to fetch the next page of Virtual Machine Scale Set VMs. Call
         ListNext() with this to fetch the next page of VMSS VMs.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VirtualMachineScaleSetVMProfile(_serialization.Model):
    """Describes a virtual machine scale set virtual machine profile.

    :ivar os_profile: The virtual machine scale set OS profile.
    :vartype os_profile:
     ~azure.mgmt.compute.v2016_04_30_preview.models.VirtualMachineScaleSetOSProfile
    :ivar storage_profile: The virtual machine scale set storage profile.
    :vartype storage_profile:
     ~azure.mgmt.compute.v2016_04_30_preview.models.VirtualMachineScaleSetStorageProfile
    :ivar network_profile: The virtual machine scale set network profile.
    :vartype network_profile:
     ~azure.mgmt.compute.v2016_04_30_preview.models.VirtualMachineScaleSetNetworkProfile
    :ivar extension_profile: The virtual machine scale set extension profile.
    :vartype extension_profile:
     ~azure.mgmt.compute.v2016_04_30_preview.models.VirtualMachineScaleSetExtensionProfile
    """

    _attribute_map = {
        "os_profile": {"key": "osProfile", "type": "VirtualMachineScaleSetOSProfile"},
        "storage_profile": {"key": "storageProfile", "type": "VirtualMachineScaleSetStorageProfile"},
        "network_profile": {"key": "networkProfile", "type": "VirtualMachineScaleSetNetworkProfile"},
        "extension_profile": {"key": "extensionProfile", "type": "VirtualMachineScaleSetExtensionProfile"},
    }

    def __init__(
        self,
        *,
        os_profile: Optional["_models.VirtualMachineScaleSetOSProfile"] = None,
        storage_profile: Optional["_models.VirtualMachineScaleSetStorageProfile"] = None,
        network_profile: Optional["_models.VirtualMachineScaleSetNetworkProfile"] = None,
        extension_profile: Optional["_models.VirtualMachineScaleSetExtensionProfile"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword os_profile: The virtual machine scale set OS profile.
        :paramtype os_profile:
         ~azure.mgmt.compute.v2016_04_30_preview.models.VirtualMachineScaleSetOSProfile
        :keyword storage_profile: The virtual machine scale set storage profile.
        :paramtype storage_profile:
         ~azure.mgmt.compute.v2016_04_30_preview.models.VirtualMachineScaleSetStorageProfile
        :keyword network_profile: The virtual machine scale set network profile.
        :paramtype network_profile:
         ~azure.mgmt.compute.v2016_04_30_preview.models.VirtualMachineScaleSetNetworkProfile
        :keyword extension_profile: The virtual machine scale set extension profile.
        :paramtype extension_profile:
         ~azure.mgmt.compute.v2016_04_30_preview.models.VirtualMachineScaleSetExtensionProfile
        """
        super().__init__(**kwargs)
        self.os_profile = os_profile
        self.storage_profile = storage_profile
        self.network_profile = network_profile
        self.extension_profile = extension_profile


class VirtualMachineSize(_serialization.Model):
    """Describes the properties of a VM size.

    :ivar name: The name of the virtual machine size.
    :vartype name: str
    :ivar number_of_cores: The number of cores supported by the virtual machine size.
    :vartype number_of_cores: int
    :ivar os_disk_size_in_mb: The OS disk size, in MB, allowed by the virtual machine size.
    :vartype os_disk_size_in_mb: int
    :ivar resource_disk_size_in_mb: The resource disk size, in MB, allowed by the virtual machine
     size.
    :vartype resource_disk_size_in_mb: int
    :ivar memory_in_mb: The amount of memory, in MB, supported by the virtual machine size.
    :vartype memory_in_mb: int
    :ivar max_data_disk_count: The maximum number of data disks that can be attached to the virtual
     machine size.
    :vartype max_data_disk_count: int
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "number_of_cores": {"key": "numberOfCores", "type": "int"},
        "os_disk_size_in_mb": {"key": "osDiskSizeInMB", "type": "int"},
        "resource_disk_size_in_mb": {"key": "resourceDiskSizeInMB", "type": "int"},
        "memory_in_mb": {"key": "memoryInMB", "type": "int"},
        "max_data_disk_count": {"key": "maxDataDiskCount", "type": "int"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        number_of_cores: Optional[int] = None,
        os_disk_size_in_mb: Optional[int] = None,
        resource_disk_size_in_mb: Optional[int] = None,
        memory_in_mb: Optional[int] = None,
        max_data_disk_count: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the virtual machine size.
        :paramtype name: str
        :keyword number_of_cores: The number of cores supported by the virtual machine size.
        :paramtype number_of_cores: int
        :keyword os_disk_size_in_mb: The OS disk size, in MB, allowed by the virtual machine size.
        :paramtype os_disk_size_in_mb: int
        :keyword resource_disk_size_in_mb: The resource disk size, in MB, allowed by the virtual
         machine size.
        :paramtype resource_disk_size_in_mb: int
        :keyword memory_in_mb: The amount of memory, in MB, supported by the virtual machine size.
        :paramtype memory_in_mb: int
        :keyword max_data_disk_count: The maximum number of data disks that can be attached to the
         virtual machine size.
        :paramtype max_data_disk_count: int
        """
        super().__init__(**kwargs)
        self.name = name
        self.number_of_cores = number_of_cores
        self.os_disk_size_in_mb = os_disk_size_in_mb
        self.resource_disk_size_in_mb = resource_disk_size_in_mb
        self.memory_in_mb = memory_in_mb
        self.max_data_disk_count = max_data_disk_count


class VirtualMachineSizeListResult(_serialization.Model):
    """The List Virtual Machine operation response.

    :ivar value: The list of virtual machine sizes.
    :vartype value: list[~azure.mgmt.compute.v2016_04_30_preview.models.VirtualMachineSize]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualMachineSize]"},
    }

    def __init__(self, *, value: Optional[List["_models.VirtualMachineSize"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: The list of virtual machine sizes.
        :paramtype value: list[~azure.mgmt.compute.v2016_04_30_preview.models.VirtualMachineSize]
        """
        super().__init__(**kwargs)
        self.value = value


class VirtualMachineStatusCodeCount(_serialization.Model):
    """The status code and count of the virtual machine scale set instance view status summary.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The instance view status code.
    :vartype code: str
    :ivar count: The number of instances having a particular status code.
    :vartype count: int
    """

    _validation = {
        "code": {"readonly": True},
        "count": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "count": {"key": "count", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.count = None


class WindowsConfiguration(_serialization.Model):
    """Specifies Windows operating system settings on the virtual machine.

    :ivar provision_vm_agent: Indicates whether virtual machine agent should be provisioned on the
     virtual machine. :code:`<br>`:code:`<br>` When this property is not specified in the request
     body, default behavior is to set it to true.  This will ensure that VM Agent is installed on
     the VM so that extensions can be added to the VM later.
    :vartype provision_vm_agent: bool
    :ivar enable_automatic_updates: Indicates whether virtual machine is enabled for automatic
     updates.
    :vartype enable_automatic_updates: bool
    :ivar time_zone: Specifies the time zone of the virtual machine. e.g. "Pacific Standard Time".
    :vartype time_zone: str
    :ivar additional_unattend_content: Specifies additional base-64 encoded XML formatted
     information that can be included in the Unattend.xml file, which is used by Windows Setup.
    :vartype additional_unattend_content:
     list[~azure.mgmt.compute.v2016_04_30_preview.models.AdditionalUnattendContent]
    :ivar win_rm: Specifies the Windows Remote Management listeners. This enables remote Windows
     PowerShell.
    :vartype win_rm: ~azure.mgmt.compute.v2016_04_30_preview.models.WinRMConfiguration
    """

    _attribute_map = {
        "provision_vm_agent": {"key": "provisionVMAgent", "type": "bool"},
        "enable_automatic_updates": {"key": "enableAutomaticUpdates", "type": "bool"},
        "time_zone": {"key": "timeZone", "type": "str"},
        "additional_unattend_content": {"key": "additionalUnattendContent", "type": "[AdditionalUnattendContent]"},
        "win_rm": {"key": "winRM", "type": "WinRMConfiguration"},
    }

    def __init__(
        self,
        *,
        provision_vm_agent: Optional[bool] = None,
        enable_automatic_updates: Optional[bool] = None,
        time_zone: Optional[str] = None,
        additional_unattend_content: Optional[List["_models.AdditionalUnattendContent"]] = None,
        win_rm: Optional["_models.WinRMConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provision_vm_agent: Indicates whether virtual machine agent should be provisioned on
         the virtual machine. :code:`<br>`:code:`<br>` When this property is not specified in the
         request body, default behavior is to set it to true.  This will ensure that VM Agent is
         installed on the VM so that extensions can be added to the VM later.
        :paramtype provision_vm_agent: bool
        :keyword enable_automatic_updates: Indicates whether virtual machine is enabled for automatic
         updates.
        :paramtype enable_automatic_updates: bool
        :keyword time_zone: Specifies the time zone of the virtual machine. e.g. "Pacific Standard
         Time".
        :paramtype time_zone: str
        :keyword additional_unattend_content: Specifies additional base-64 encoded XML formatted
         information that can be included in the Unattend.xml file, which is used by Windows Setup.
        :paramtype additional_unattend_content:
         list[~azure.mgmt.compute.v2016_04_30_preview.models.AdditionalUnattendContent]
        :keyword win_rm: Specifies the Windows Remote Management listeners. This enables remote Windows
         PowerShell.
        :paramtype win_rm: ~azure.mgmt.compute.v2016_04_30_preview.models.WinRMConfiguration
        """
        super().__init__(**kwargs)
        self.provision_vm_agent = provision_vm_agent
        self.enable_automatic_updates = enable_automatic_updates
        self.time_zone = time_zone
        self.additional_unattend_content = additional_unattend_content
        self.win_rm = win_rm


class WinRMConfiguration(_serialization.Model):
    """Describes Windows Remote Management configuration of the VM.

    :ivar listeners: The list of Windows Remote Management listeners.
    :vartype listeners: list[~azure.mgmt.compute.v2016_04_30_preview.models.WinRMListener]
    """

    _attribute_map = {
        "listeners": {"key": "listeners", "type": "[WinRMListener]"},
    }

    def __init__(self, *, listeners: Optional[List["_models.WinRMListener"]] = None, **kwargs: Any) -> None:
        """
        :keyword listeners: The list of Windows Remote Management listeners.
        :paramtype listeners: list[~azure.mgmt.compute.v2016_04_30_preview.models.WinRMListener]
        """
        super().__init__(**kwargs)
        self.listeners = listeners


class WinRMListener(_serialization.Model):
    """Describes Protocol and thumbprint of Windows Remote Management listener.

    :ivar protocol: Specifies the protocol of listener. :code:`<br>`:code:`<br>` Possible values
     are: :code:`<br>`\\ **http** :code:`<br>`:code:`<br>` **https**. Known values are: "Http" and
     "Https".
    :vartype protocol: str or ~azure.mgmt.compute.v2016_04_30_preview.models.ProtocolTypes
    :ivar certificate_url: This is the URL of a certificate that has been uploaded to Key Vault as
     a secret. For adding a secret to the Key Vault, see `Add a key or secret to the key vault
     <https://docs.microsoft.com/azure/key-vault/key-vault-get-started/#add>`_. In this case, your
     certificate needs to be It is the Base64 encoding of the following JSON Object which is encoded
     in UTF-8: :code:`<br>`:code:`<br>` {:code:`<br>`
     "data":":code:`<Base64-encoded-certificate>`",:code:`<br>`  "dataType":"pfx",:code:`<br>`
     "password":":code:`<pfx-file-password>`":code:`<br>`}.
    :vartype certificate_url: str
    """

    _attribute_map = {
        "protocol": {"key": "protocol", "type": "str"},
        "certificate_url": {"key": "certificateUrl", "type": "str"},
    }

    def __init__(
        self,
        *,
        protocol: Optional[Union[str, "_models.ProtocolTypes"]] = None,
        certificate_url: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword protocol: Specifies the protocol of listener. :code:`<br>`:code:`<br>` Possible values
         are: :code:`<br>`\\ **http** :code:`<br>`:code:`<br>` **https**. Known values are: "Http" and
         "Https".
        :paramtype protocol: str or ~azure.mgmt.compute.v2016_04_30_preview.models.ProtocolTypes
        :keyword certificate_url: This is the URL of a certificate that has been uploaded to Key Vault
         as a secret. For adding a secret to the Key Vault, see `Add a key or secret to the key vault
         <https://docs.microsoft.com/azure/key-vault/key-vault-get-started/#add>`_. In this case, your
         certificate needs to be It is the Base64 encoding of the following JSON Object which is encoded
         in UTF-8: :code:`<br>`:code:`<br>` {:code:`<br>`
         "data":":code:`<Base64-encoded-certificate>`",:code:`<br>`  "dataType":"pfx",:code:`<br>`
         "password":":code:`<pfx-file-password>`":code:`<br>`}.
        :paramtype certificate_url: str
        """
        super().__init__(**kwargs)
        self.protocol = protocol
        self.certificate_url = certificate_url
