# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from typing import Any, Callable, Dict, IO, List, Optional, TypeVar, Union

from azure.core.exceptions import ClientAuthenticationError, HttpResponseError, ResourceExistsError, ResourceNotFoundError, map_error
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._container_operations import build_acquire_lease_request, build_break_lease_request, build_change_lease_request, build_create_request, build_delete_request, build_filter_blobs_request, build_get_access_policy_request, build_get_account_info_request, build_get_properties_request, build_list_blob_flat_segment_request, build_list_blob_hierarchy_segment_request, build_release_lease_request, build_rename_request, build_renew_lease_request, build_restore_request, build_set_access_policy_request, build_set_metadata_request, build_submit_batch_request
T = TypeVar('T')
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]

class ContainerOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.storage.blob.aio.AzureBlobStorage`'s
        :attr:`container` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")


    @distributed_trace_async
    async def create(  # pylint: disable=inconsistent-return-statements
        self,
        timeout: Optional[int] = None,
        metadata: Optional[Dict[str, str]] = None,
        access: Optional[Union[str, "_models.PublicAccessType"]] = None,
        request_id_parameter: Optional[str] = None,
        container_cpk_scope_info: Optional[_models.ContainerCpkScopeInfo] = None,
        **kwargs: Any
    ) -> None:
        """creates a new container under the specified account. If the container with the same name
        already exists, the operation fails.

        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
         Timeouts for Blob Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param metadata: Optional. Specifies a user-defined name-value pair associated with the blob.
         If no name-value pairs are specified, the operation will copy the metadata from the source blob
         or file to the destination blob. If one or more name-value pairs are specified, the destination
         blob is created with the specified metadata, and metadata is not copied from the source blob or
         file. Note that beginning with version 2009-09-19, metadata names must adhere to the naming
         rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata for more
         information. Default value is None.
        :type metadata: dict[str, str]
        :param access: Specifies whether data in the container may be accessed publicly and the level
         of access. Default value is None.
        :type access: str or ~azure.storage.blob.models.PublicAccessType
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled. Default
         value is None.
        :type request_id_parameter: str
        :param container_cpk_scope_info: Parameter group. Default value is None.
        :type container_cpk_scope_info: ~azure.storage.blob.models.ContainerCpkScopeInfo
        :keyword restype: restype. Default value is "container". Note that overriding this default
         value may result in unsupported behavior.
        :paramtype restype: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        restype = kwargs.pop('restype', _params.pop('restype', "container"))  # type: str
        cls = kwargs.pop('cls', None)  # type: ClsType[None]

        _default_encryption_scope = None
        _prevent_encryption_scope_override = None
        if container_cpk_scope_info is not None:
            _default_encryption_scope = container_cpk_scope_info.default_encryption_scope
            _prevent_encryption_scope_override = container_cpk_scope_info.prevent_encryption_scope_override

        request = build_create_request(
            url=self._config.url,
            restype=restype,
            version=self._config.version,
            timeout=timeout,
            metadata=metadata,
            access=access,
            request_id_parameter=request_id_parameter,
            default_encryption_scope=_default_encryption_scope,
            prevent_encryption_scope_override=_prevent_encryption_scope_override,
            template_url=self.create.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
        response_headers['x-ms-client-request-id']=self._deserialize('str', response.headers.get('x-ms-client-request-id'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))


        if cls:
            return cls(pipeline_response, None, response_headers)

    create.metadata = {'url': "{url}/{containerName}"}  # type: ignore


    @distributed_trace_async
    async def get_properties(  # pylint: disable=inconsistent-return-statements
        self,
        timeout: Optional[int] = None,
        request_id_parameter: Optional[str] = None,
        lease_access_conditions: Optional[_models.LeaseAccessConditions] = None,
        **kwargs: Any
    ) -> None:
        """returns all user-defined metadata and system properties for the specified container. The data
        returned does not include the container's list of blobs.

        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
         Timeouts for Blob Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled. Default
         value is None.
        :type request_id_parameter: str
        :param lease_access_conditions: Parameter group. Default value is None.
        :type lease_access_conditions: ~azure.storage.blob.models.LeaseAccessConditions
        :keyword restype: restype. Default value is "container". Note that overriding this default
         value may result in unsupported behavior.
        :paramtype restype: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        restype = kwargs.pop('restype', _params.pop('restype', "container"))  # type: str
        cls = kwargs.pop('cls', None)  # type: ClsType[None]

        _lease_id = None
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id

        request = build_get_properties_request(
            url=self._config.url,
            restype=restype,
            version=self._config.version,
            timeout=timeout,
            lease_id=_lease_id,
            request_id_parameter=request_id_parameter,
            template_url=self.get_properties.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['x-ms-meta']=self._deserialize('{str}', response.headers.get('x-ms-meta'))
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
        response_headers['x-ms-lease-duration']=self._deserialize('str', response.headers.get('x-ms-lease-duration'))
        response_headers['x-ms-lease-state']=self._deserialize('str', response.headers.get('x-ms-lease-state'))
        response_headers['x-ms-lease-status']=self._deserialize('str', response.headers.get('x-ms-lease-status'))
        response_headers['x-ms-client-request-id']=self._deserialize('str', response.headers.get('x-ms-client-request-id'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))
        response_headers['x-ms-blob-public-access']=self._deserialize('str', response.headers.get('x-ms-blob-public-access'))
        response_headers['x-ms-has-immutability-policy']=self._deserialize('bool', response.headers.get('x-ms-has-immutability-policy'))
        response_headers['x-ms-has-legal-hold']=self._deserialize('bool', response.headers.get('x-ms-has-legal-hold'))
        response_headers['x-ms-default-encryption-scope']=self._deserialize('str', response.headers.get('x-ms-default-encryption-scope'))
        response_headers['x-ms-deny-encryption-scope-override']=self._deserialize('bool', response.headers.get('x-ms-deny-encryption-scope-override'))
        response_headers['x-ms-immutable-storage-with-versioning-enabled']=self._deserialize('bool', response.headers.get('x-ms-immutable-storage-with-versioning-enabled'))


        if cls:
            return cls(pipeline_response, None, response_headers)

    get_properties.metadata = {'url': "{url}/{containerName}"}  # type: ignore


    @distributed_trace_async
    async def delete(  # pylint: disable=inconsistent-return-statements
        self,
        timeout: Optional[int] = None,
        request_id_parameter: Optional[str] = None,
        lease_access_conditions: Optional[_models.LeaseAccessConditions] = None,
        modified_access_conditions: Optional[_models.ModifiedAccessConditions] = None,
        **kwargs: Any
    ) -> None:
        """operation marks the specified container for deletion. The container and any blobs contained
        within it are later deleted during garbage collection.

        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
         Timeouts for Blob Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled. Default
         value is None.
        :type request_id_parameter: str
        :param lease_access_conditions: Parameter group. Default value is None.
        :type lease_access_conditions: ~azure.storage.blob.models.LeaseAccessConditions
        :param modified_access_conditions: Parameter group. Default value is None.
        :type modified_access_conditions: ~azure.storage.blob.models.ModifiedAccessConditions
        :keyword restype: restype. Default value is "container". Note that overriding this default
         value may result in unsupported behavior.
        :paramtype restype: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        restype = kwargs.pop('restype', _params.pop('restype', "container"))  # type: str
        cls = kwargs.pop('cls', None)  # type: ClsType[None]

        _lease_id = None
        _if_modified_since = None
        _if_unmodified_since = None
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id
        if modified_access_conditions is not None:
            _if_modified_since = modified_access_conditions.if_modified_since
            _if_unmodified_since = modified_access_conditions.if_unmodified_since

        request = build_delete_request(
            url=self._config.url,
            restype=restype,
            version=self._config.version,
            timeout=timeout,
            lease_id=_lease_id,
            if_modified_since=_if_modified_since,
            if_unmodified_since=_if_unmodified_since,
            request_id_parameter=request_id_parameter,
            template_url=self.delete.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['x-ms-client-request-id']=self._deserialize('str', response.headers.get('x-ms-client-request-id'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))


        if cls:
            return cls(pipeline_response, None, response_headers)

    delete.metadata = {'url': "{url}/{containerName}"}  # type: ignore


    @distributed_trace_async
    async def set_metadata(  # pylint: disable=inconsistent-return-statements
        self,
        timeout: Optional[int] = None,
        metadata: Optional[Dict[str, str]] = None,
        request_id_parameter: Optional[str] = None,
        lease_access_conditions: Optional[_models.LeaseAccessConditions] = None,
        modified_access_conditions: Optional[_models.ModifiedAccessConditions] = None,
        **kwargs: Any
    ) -> None:
        """operation sets one or more user-defined name-value pairs for the specified container.

        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
         Timeouts for Blob Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param metadata: Optional. Specifies a user-defined name-value pair associated with the blob.
         If no name-value pairs are specified, the operation will copy the metadata from the source blob
         or file to the destination blob. If one or more name-value pairs are specified, the destination
         blob is created with the specified metadata, and metadata is not copied from the source blob or
         file. Note that beginning with version 2009-09-19, metadata names must adhere to the naming
         rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata for more
         information. Default value is None.
        :type metadata: dict[str, str]
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled. Default
         value is None.
        :type request_id_parameter: str
        :param lease_access_conditions: Parameter group. Default value is None.
        :type lease_access_conditions: ~azure.storage.blob.models.LeaseAccessConditions
        :param modified_access_conditions: Parameter group. Default value is None.
        :type modified_access_conditions: ~azure.storage.blob.models.ModifiedAccessConditions
        :keyword restype: restype. Default value is "container". Note that overriding this default
         value may result in unsupported behavior.
        :paramtype restype: str
        :keyword comp: comp. Default value is "metadata". Note that overriding this default value may
         result in unsupported behavior.
        :paramtype comp: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        restype = kwargs.pop('restype', _params.pop('restype', "container"))  # type: str
        comp = kwargs.pop('comp', _params.pop('comp', "metadata"))  # type: str
        cls = kwargs.pop('cls', None)  # type: ClsType[None]

        _lease_id = None
        _if_modified_since = None
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id
        if modified_access_conditions is not None:
            _if_modified_since = modified_access_conditions.if_modified_since

        request = build_set_metadata_request(
            url=self._config.url,
            restype=restype,
            comp=comp,
            version=self._config.version,
            timeout=timeout,
            lease_id=_lease_id,
            metadata=metadata,
            if_modified_since=_if_modified_since,
            request_id_parameter=request_id_parameter,
            template_url=self.set_metadata.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
        response_headers['x-ms-client-request-id']=self._deserialize('str', response.headers.get('x-ms-client-request-id'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))


        if cls:
            return cls(pipeline_response, None, response_headers)

    set_metadata.metadata = {'url': "{url}/{containerName}"}  # type: ignore


    @distributed_trace_async
    async def get_access_policy(
        self,
        timeout: Optional[int] = None,
        request_id_parameter: Optional[str] = None,
        lease_access_conditions: Optional[_models.LeaseAccessConditions] = None,
        **kwargs: Any
    ) -> List[_models.SignedIdentifier]:
        """gets the permissions for the specified container. The permissions indicate whether container
        data may be accessed publicly.

        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
         Timeouts for Blob Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled. Default
         value is None.
        :type request_id_parameter: str
        :param lease_access_conditions: Parameter group. Default value is None.
        :type lease_access_conditions: ~azure.storage.blob.models.LeaseAccessConditions
        :keyword restype: restype. Default value is "container". Note that overriding this default
         value may result in unsupported behavior.
        :paramtype restype: str
        :keyword comp: comp. Default value is "acl". Note that overriding this default value may result
         in unsupported behavior.
        :paramtype comp: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: list of SignedIdentifier, or the result of cls(response)
        :rtype: list[~azure.storage.blob.models.SignedIdentifier]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        restype = kwargs.pop('restype', _params.pop('restype', "container"))  # type: str
        comp = kwargs.pop('comp', _params.pop('comp', "acl"))  # type: str
        cls = kwargs.pop('cls', None)  # type: ClsType[List[_models.SignedIdentifier]]

        _lease_id = None
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id

        request = build_get_access_policy_request(
            url=self._config.url,
            restype=restype,
            comp=comp,
            version=self._config.version,
            timeout=timeout,
            lease_id=_lease_id,
            request_id_parameter=request_id_parameter,
            template_url=self.get_access_policy.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['x-ms-blob-public-access']=self._deserialize('str', response.headers.get('x-ms-blob-public-access'))
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
        response_headers['x-ms-client-request-id']=self._deserialize('str', response.headers.get('x-ms-client-request-id'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))

        deserialized = self._deserialize('[SignedIdentifier]', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    get_access_policy.metadata = {'url': "{url}/{containerName}"}  # type: ignore


    @distributed_trace_async
    async def set_access_policy(  # pylint: disable=inconsistent-return-statements
        self,
        timeout: Optional[int] = None,
        access: Optional[Union[str, "_models.PublicAccessType"]] = None,
        request_id_parameter: Optional[str] = None,
        container_acl: Optional[List[_models.SignedIdentifier]] = None,
        lease_access_conditions: Optional[_models.LeaseAccessConditions] = None,
        modified_access_conditions: Optional[_models.ModifiedAccessConditions] = None,
        **kwargs: Any
    ) -> None:
        """sets the permissions for the specified container. The permissions indicate whether blobs in a
        container may be accessed publicly.

        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
         Timeouts for Blob Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param access: Specifies whether data in the container may be accessed publicly and the level
         of access. Default value is None.
        :type access: str or ~azure.storage.blob.models.PublicAccessType
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled. Default
         value is None.
        :type request_id_parameter: str
        :param container_acl: the acls for the container. Default value is None.
        :type container_acl: list[~azure.storage.blob.models.SignedIdentifier]
        :param lease_access_conditions: Parameter group. Default value is None.
        :type lease_access_conditions: ~azure.storage.blob.models.LeaseAccessConditions
        :param modified_access_conditions: Parameter group. Default value is None.
        :type modified_access_conditions: ~azure.storage.blob.models.ModifiedAccessConditions
        :keyword restype: restype. Default value is "container". Note that overriding this default
         value may result in unsupported behavior.
        :paramtype restype: str
        :keyword comp: comp. Default value is "acl". Note that overriding this default value may result
         in unsupported behavior.
        :paramtype comp: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        restype = kwargs.pop('restype', _params.pop('restype', "container"))  # type: str
        comp = kwargs.pop('comp', _params.pop('comp', "acl"))  # type: str
        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', "application/xml"))  # type: Optional[str]
        cls = kwargs.pop('cls', None)  # type: ClsType[None]

        _lease_id = None
        _if_modified_since = None
        _if_unmodified_since = None
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id
        if modified_access_conditions is not None:
            _if_modified_since = modified_access_conditions.if_modified_since
            _if_unmodified_since = modified_access_conditions.if_unmodified_since
        serialization_ctxt = {"xml": {'name': 'SignedIdentifiers', 'wrapped': True, 'itemsName': 'SignedIdentifier'}}
        if container_acl is not None:
            _content = self._serialize.body(container_acl, '[SignedIdentifier]', is_xml=True, serialization_ctxt=serialization_ctxt)
        else:
            _content = None

        request = build_set_access_policy_request(
            url=self._config.url,
            restype=restype,
            comp=comp,
            version=self._config.version,
            content_type=content_type,
            content=_content,
            timeout=timeout,
            lease_id=_lease_id,
            access=access,
            if_modified_since=_if_modified_since,
            if_unmodified_since=_if_unmodified_since,
            request_id_parameter=request_id_parameter,
            template_url=self.set_access_policy.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
        response_headers['x-ms-client-request-id']=self._deserialize('str', response.headers.get('x-ms-client-request-id'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))


        if cls:
            return cls(pipeline_response, None, response_headers)

    set_access_policy.metadata = {'url': "{url}/{containerName}"}  # type: ignore


    @distributed_trace_async
    async def restore(  # pylint: disable=inconsistent-return-statements
        self,
        timeout: Optional[int] = None,
        request_id_parameter: Optional[str] = None,
        deleted_container_name: Optional[str] = None,
        deleted_container_version: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Restores a previously-deleted container.

        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
         Timeouts for Blob Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled. Default
         value is None.
        :type request_id_parameter: str
        :param deleted_container_name: Optional.  Version 2019-12-12 and later.  Specifies the name of
         the deleted container to restore. Default value is None.
        :type deleted_container_name: str
        :param deleted_container_version: Optional.  Version 2019-12-12 and later.  Specifies the
         version of the deleted container to restore. Default value is None.
        :type deleted_container_version: str
        :keyword restype: restype. Default value is "container". Note that overriding this default
         value may result in unsupported behavior.
        :paramtype restype: str
        :keyword comp: comp. Default value is "undelete". Note that overriding this default value may
         result in unsupported behavior.
        :paramtype comp: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        restype = kwargs.pop('restype', _params.pop('restype', "container"))  # type: str
        comp = kwargs.pop('comp', _params.pop('comp', "undelete"))  # type: str
        cls = kwargs.pop('cls', None)  # type: ClsType[None]

        
        request = build_restore_request(
            url=self._config.url,
            restype=restype,
            comp=comp,
            version=self._config.version,
            timeout=timeout,
            request_id_parameter=request_id_parameter,
            deleted_container_name=deleted_container_name,
            deleted_container_version=deleted_container_version,
            template_url=self.restore.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['x-ms-client-request-id']=self._deserialize('str', response.headers.get('x-ms-client-request-id'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))


        if cls:
            return cls(pipeline_response, None, response_headers)

    restore.metadata = {'url': "{url}/{containerName}"}  # type: ignore


    @distributed_trace_async
    async def rename(  # pylint: disable=inconsistent-return-statements
        self,
        source_container_name: str,
        timeout: Optional[int] = None,
        request_id_parameter: Optional[str] = None,
        source_lease_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Renames an existing container.

        :param source_container_name: Required.  Specifies the name of the container to rename.
        :type source_container_name: str
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
         Timeouts for Blob Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled. Default
         value is None.
        :type request_id_parameter: str
        :param source_lease_id: A lease ID for the source path. If specified, the source path must have
         an active lease and the lease ID must match. Default value is None.
        :type source_lease_id: str
        :keyword restype: restype. Default value is "container". Note that overriding this default
         value may result in unsupported behavior.
        :paramtype restype: str
        :keyword comp: comp. Default value is "rename". Note that overriding this default value may
         result in unsupported behavior.
        :paramtype comp: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        restype = kwargs.pop('restype', _params.pop('restype', "container"))  # type: str
        comp = kwargs.pop('comp', _params.pop('comp', "rename"))  # type: str
        cls = kwargs.pop('cls', None)  # type: ClsType[None]

        
        request = build_rename_request(
            url=self._config.url,
            restype=restype,
            comp=comp,
            version=self._config.version,
            source_container_name=source_container_name,
            timeout=timeout,
            request_id_parameter=request_id_parameter,
            source_lease_id=source_lease_id,
            template_url=self.rename.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['x-ms-client-request-id']=self._deserialize('str', response.headers.get('x-ms-client-request-id'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))


        if cls:
            return cls(pipeline_response, None, response_headers)

    rename.metadata = {'url': "{url}/{containerName}"}  # type: ignore


    @distributed_trace_async
    async def submit_batch(
        self,
        content_length: int,
        multipart_content_type: str,
        body: IO,
        timeout: Optional[int] = None,
        request_id_parameter: Optional[str] = None,
        **kwargs: Any
    ) -> IO:
        """The Batch operation allows multiple API calls to be embedded into a single HTTP request.

        :param content_length: The length of the request.
        :type content_length: long
        :param multipart_content_type: Required. The value of this header must be multipart/mixed with
         a batch boundary. Example header value: multipart/mixed; boundary=batch_:code:`<GUID>`.
        :type multipart_content_type: str
        :param body: Initial data.
        :type body: IO
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
         Timeouts for Blob Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled. Default
         value is None.
        :type request_id_parameter: str
        :keyword restype: restype. Default value is "container". Note that overriding this default
         value may result in unsupported behavior.
        :paramtype restype: str
        :keyword comp: comp. Default value is "batch". Note that overriding this default value may
         result in unsupported behavior.
        :paramtype comp: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: IO, or the result of cls(response)
        :rtype: IO
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        restype = kwargs.pop('restype', _params.pop('restype', "container"))  # type: str
        comp = kwargs.pop('comp', _params.pop('comp', "batch"))  # type: str
        cls = kwargs.pop('cls', None)  # type: ClsType[IO]

        _content = self._serialize.body(body, 'IO')

        request = build_submit_batch_request(
            url=self._config.url,
            restype=restype,
            comp=comp,
            version=self._config.version,
            content=_content,
            content_length=content_length,
            multipart_content_type=multipart_content_type,
            timeout=timeout,
            request_id_parameter=request_id_parameter,
            template_url=self.submit_batch.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=True,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['Content-Type']=self._deserialize('str', response.headers.get('Content-Type'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))

        deserialized = response.stream_download(self._client._pipeline)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    submit_batch.metadata = {'url': "{url}/{containerName}"}  # type: ignore


    @distributed_trace_async
    async def filter_blobs(
        self,
        timeout: Optional[int] = None,
        request_id_parameter: Optional[str] = None,
        where: Optional[str] = None,
        marker: Optional[str] = None,
        maxresults: Optional[int] = None,
        include: Optional[List[Union[str, "_models.FilterBlobsIncludeItem"]]] = None,
        **kwargs: Any
    ) -> _models.FilterBlobSegment:
        """The Filter Blobs operation enables callers to list blobs in a container whose tags match a
        given search expression.  Filter blobs searches within the given container.

        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
         Timeouts for Blob Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled. Default
         value is None.
        :type request_id_parameter: str
        :param where: Filters the results to return only to return only blobs whose tags match the
         specified expression. Default value is None.
        :type where: str
        :param marker: A string value that identifies the portion of the list of containers to be
         returned with the next listing operation. The operation returns the NextMarker value within the
         response body if the listing operation did not return all containers remaining to be listed
         with the current page. The NextMarker value can be used as the value for the marker parameter
         in a subsequent call to request the next page of list items. The marker value is opaque to the
         client. Default value is None.
        :type marker: str
        :param maxresults: Specifies the maximum number of containers to return. If the request does
         not specify maxresults, or specifies a value greater than 5000, the server will return up to
         5000 items. Note that if the listing operation crosses a partition boundary, then the service
         will return a continuation token for retrieving the remainder of the results. For this reason,
         it is possible that the service will return fewer results than specified by maxresults, or than
         the default of 5000. Default value is None.
        :type maxresults: int
        :param include: Include this parameter to specify one or more datasets to include in the
         response. Default value is None.
        :type include: list[str or ~azure.storage.blob.models.FilterBlobsIncludeItem]
        :keyword restype: restype. Default value is "container". Note that overriding this default
         value may result in unsupported behavior.
        :paramtype restype: str
        :keyword comp: comp. Default value is "blobs". Note that overriding this default value may
         result in unsupported behavior.
        :paramtype comp: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: FilterBlobSegment, or the result of cls(response)
        :rtype: ~azure.storage.blob.models.FilterBlobSegment
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        restype = kwargs.pop('restype', _params.pop('restype', "container"))  # type: str
        comp = kwargs.pop('comp', _params.pop('comp', "blobs"))  # type: str
        cls = kwargs.pop('cls', None)  # type: ClsType[_models.FilterBlobSegment]

        
        request = build_filter_blobs_request(
            url=self._config.url,
            restype=restype,
            comp=comp,
            version=self._config.version,
            timeout=timeout,
            request_id_parameter=request_id_parameter,
            where=where,
            marker=marker,
            maxresults=maxresults,
            include=include,
            template_url=self.filter_blobs.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['x-ms-client-request-id']=self._deserialize('str', response.headers.get('x-ms-client-request-id'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))

        deserialized = self._deserialize('FilterBlobSegment', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    filter_blobs.metadata = {'url': "{url}/{containerName}"}  # type: ignore


    @distributed_trace_async
    async def acquire_lease(  # pylint: disable=inconsistent-return-statements
        self,
        timeout: Optional[int] = None,
        duration: Optional[int] = None,
        proposed_lease_id: Optional[str] = None,
        request_id_parameter: Optional[str] = None,
        modified_access_conditions: Optional[_models.ModifiedAccessConditions] = None,
        **kwargs: Any
    ) -> None:
        """[Update] establishes and manages a lock on a container for delete operations. The lock duration
        can be 15 to 60 seconds, or can be infinite.

        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
         Timeouts for Blob Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param duration: Specifies the duration of the lease, in seconds, or negative one (-1) for a
         lease that never expires. A non-infinite lease can be between 15 and 60 seconds. A lease
         duration cannot be changed using renew or change. Default value is None.
        :type duration: int
        :param proposed_lease_id: Proposed lease ID, in a GUID string format. The Blob service returns
         400 (Invalid request) if the proposed lease ID is not in the correct format. See Guid
         Constructor (String) for a list of valid GUID string formats. Default value is None.
        :type proposed_lease_id: str
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled. Default
         value is None.
        :type request_id_parameter: str
        :param modified_access_conditions: Parameter group. Default value is None.
        :type modified_access_conditions: ~azure.storage.blob.models.ModifiedAccessConditions
        :keyword comp: comp. Default value is "lease". Note that overriding this default value may
         result in unsupported behavior.
        :paramtype comp: str
        :keyword restype: restype. Default value is "container". Note that overriding this default
         value may result in unsupported behavior.
        :paramtype restype: str
        :keyword action: Describes what lease action to take. Default value is "acquire". Note that
         overriding this default value may result in unsupported behavior.
        :paramtype action: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        comp = kwargs.pop('comp', _params.pop('comp', "lease"))  # type: str
        restype = kwargs.pop('restype', _params.pop('restype', "container"))  # type: str
        action = kwargs.pop('action', _headers.pop('x-ms-lease-action', "acquire"))  # type: str
        cls = kwargs.pop('cls', None)  # type: ClsType[None]

        _if_modified_since = None
        _if_unmodified_since = None
        if modified_access_conditions is not None:
            _if_modified_since = modified_access_conditions.if_modified_since
            _if_unmodified_since = modified_access_conditions.if_unmodified_since

        request = build_acquire_lease_request(
            url=self._config.url,
            comp=comp,
            restype=restype,
            action=action,
            version=self._config.version,
            timeout=timeout,
            duration=duration,
            proposed_lease_id=proposed_lease_id,
            if_modified_since=_if_modified_since,
            if_unmodified_since=_if_unmodified_since,
            request_id_parameter=request_id_parameter,
            template_url=self.acquire_lease.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
        response_headers['x-ms-lease-id']=self._deserialize('str', response.headers.get('x-ms-lease-id'))
        response_headers['x-ms-client-request-id']=self._deserialize('str', response.headers.get('x-ms-client-request-id'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))


        if cls:
            return cls(pipeline_response, None, response_headers)

    acquire_lease.metadata = {'url': "{url}/{containerName}"}  # type: ignore


    @distributed_trace_async
    async def release_lease(  # pylint: disable=inconsistent-return-statements
        self,
        lease_id: str,
        timeout: Optional[int] = None,
        request_id_parameter: Optional[str] = None,
        modified_access_conditions: Optional[_models.ModifiedAccessConditions] = None,
        **kwargs: Any
    ) -> None:
        """[Update] establishes and manages a lock on a container for delete operations. The lock duration
        can be 15 to 60 seconds, or can be infinite.

        :param lease_id: Specifies the current lease ID on the resource.
        :type lease_id: str
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
         Timeouts for Blob Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled. Default
         value is None.
        :type request_id_parameter: str
        :param modified_access_conditions: Parameter group. Default value is None.
        :type modified_access_conditions: ~azure.storage.blob.models.ModifiedAccessConditions
        :keyword comp: comp. Default value is "lease". Note that overriding this default value may
         result in unsupported behavior.
        :paramtype comp: str
        :keyword restype: restype. Default value is "container". Note that overriding this default
         value may result in unsupported behavior.
        :paramtype restype: str
        :keyword action: Describes what lease action to take. Default value is "release". Note that
         overriding this default value may result in unsupported behavior.
        :paramtype action: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        comp = kwargs.pop('comp', _params.pop('comp', "lease"))  # type: str
        restype = kwargs.pop('restype', _params.pop('restype', "container"))  # type: str
        action = kwargs.pop('action', _headers.pop('x-ms-lease-action', "release"))  # type: str
        cls = kwargs.pop('cls', None)  # type: ClsType[None]

        _if_modified_since = None
        _if_unmodified_since = None
        if modified_access_conditions is not None:
            _if_modified_since = modified_access_conditions.if_modified_since
            _if_unmodified_since = modified_access_conditions.if_unmodified_since

        request = build_release_lease_request(
            url=self._config.url,
            comp=comp,
            restype=restype,
            action=action,
            version=self._config.version,
            lease_id=lease_id,
            timeout=timeout,
            if_modified_since=_if_modified_since,
            if_unmodified_since=_if_unmodified_since,
            request_id_parameter=request_id_parameter,
            template_url=self.release_lease.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
        response_headers['x-ms-client-request-id']=self._deserialize('str', response.headers.get('x-ms-client-request-id'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))


        if cls:
            return cls(pipeline_response, None, response_headers)

    release_lease.metadata = {'url': "{url}/{containerName}"}  # type: ignore


    @distributed_trace_async
    async def renew_lease(  # pylint: disable=inconsistent-return-statements
        self,
        lease_id: str,
        timeout: Optional[int] = None,
        request_id_parameter: Optional[str] = None,
        modified_access_conditions: Optional[_models.ModifiedAccessConditions] = None,
        **kwargs: Any
    ) -> None:
        """[Update] establishes and manages a lock on a container for delete operations. The lock duration
        can be 15 to 60 seconds, or can be infinite.

        :param lease_id: Specifies the current lease ID on the resource.
        :type lease_id: str
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
         Timeouts for Blob Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled. Default
         value is None.
        :type request_id_parameter: str
        :param modified_access_conditions: Parameter group. Default value is None.
        :type modified_access_conditions: ~azure.storage.blob.models.ModifiedAccessConditions
        :keyword comp: comp. Default value is "lease". Note that overriding this default value may
         result in unsupported behavior.
        :paramtype comp: str
        :keyword restype: restype. Default value is "container". Note that overriding this default
         value may result in unsupported behavior.
        :paramtype restype: str
        :keyword action: Describes what lease action to take. Default value is "renew". Note that
         overriding this default value may result in unsupported behavior.
        :paramtype action: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        comp = kwargs.pop('comp', _params.pop('comp', "lease"))  # type: str
        restype = kwargs.pop('restype', _params.pop('restype', "container"))  # type: str
        action = kwargs.pop('action', _headers.pop('x-ms-lease-action', "renew"))  # type: str
        cls = kwargs.pop('cls', None)  # type: ClsType[None]

        _if_modified_since = None
        _if_unmodified_since = None
        if modified_access_conditions is not None:
            _if_modified_since = modified_access_conditions.if_modified_since
            _if_unmodified_since = modified_access_conditions.if_unmodified_since

        request = build_renew_lease_request(
            url=self._config.url,
            comp=comp,
            restype=restype,
            action=action,
            version=self._config.version,
            lease_id=lease_id,
            timeout=timeout,
            if_modified_since=_if_modified_since,
            if_unmodified_since=_if_unmodified_since,
            request_id_parameter=request_id_parameter,
            template_url=self.renew_lease.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
        response_headers['x-ms-lease-id']=self._deserialize('str', response.headers.get('x-ms-lease-id'))
        response_headers['x-ms-client-request-id']=self._deserialize('str', response.headers.get('x-ms-client-request-id'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))


        if cls:
            return cls(pipeline_response, None, response_headers)

    renew_lease.metadata = {'url': "{url}/{containerName}"}  # type: ignore


    @distributed_trace_async
    async def break_lease(  # pylint: disable=inconsistent-return-statements
        self,
        timeout: Optional[int] = None,
        break_period: Optional[int] = None,
        request_id_parameter: Optional[str] = None,
        modified_access_conditions: Optional[_models.ModifiedAccessConditions] = None,
        **kwargs: Any
    ) -> None:
        """[Update] establishes and manages a lock on a container for delete operations. The lock duration
        can be 15 to 60 seconds, or can be infinite.

        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
         Timeouts for Blob Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param break_period: For a break operation, proposed duration the lease should continue before
         it is broken, in seconds, between 0 and 60. This break period is only used if it is shorter
         than the time remaining on the lease. If longer, the time remaining on the lease is used. A new
         lease will not be available before the break period has expired, but the lease may be held for
         longer than the break period. If this header does not appear with a break operation, a
         fixed-duration lease breaks after the remaining lease period elapses, and an infinite lease
         breaks immediately. Default value is None.
        :type break_period: int
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled. Default
         value is None.
        :type request_id_parameter: str
        :param modified_access_conditions: Parameter group. Default value is None.
        :type modified_access_conditions: ~azure.storage.blob.models.ModifiedAccessConditions
        :keyword comp: comp. Default value is "lease". Note that overriding this default value may
         result in unsupported behavior.
        :paramtype comp: str
        :keyword restype: restype. Default value is "container". Note that overriding this default
         value may result in unsupported behavior.
        :paramtype restype: str
        :keyword action: Describes what lease action to take. Default value is "break". Note that
         overriding this default value may result in unsupported behavior.
        :paramtype action: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        comp = kwargs.pop('comp', _params.pop('comp', "lease"))  # type: str
        restype = kwargs.pop('restype', _params.pop('restype', "container"))  # type: str
        action = kwargs.pop('action', _headers.pop('x-ms-lease-action', "break"))  # type: str
        cls = kwargs.pop('cls', None)  # type: ClsType[None]

        _if_modified_since = None
        _if_unmodified_since = None
        if modified_access_conditions is not None:
            _if_modified_since = modified_access_conditions.if_modified_since
            _if_unmodified_since = modified_access_conditions.if_unmodified_since

        request = build_break_lease_request(
            url=self._config.url,
            comp=comp,
            restype=restype,
            action=action,
            version=self._config.version,
            timeout=timeout,
            break_period=break_period,
            if_modified_since=_if_modified_since,
            if_unmodified_since=_if_unmodified_since,
            request_id_parameter=request_id_parameter,
            template_url=self.break_lease.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
        response_headers['x-ms-lease-time']=self._deserialize('int', response.headers.get('x-ms-lease-time'))
        response_headers['x-ms-client-request-id']=self._deserialize('str', response.headers.get('x-ms-client-request-id'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))


        if cls:
            return cls(pipeline_response, None, response_headers)

    break_lease.metadata = {'url': "{url}/{containerName}"}  # type: ignore


    @distributed_trace_async
    async def change_lease(  # pylint: disable=inconsistent-return-statements
        self,
        lease_id: str,
        proposed_lease_id: str,
        timeout: Optional[int] = None,
        request_id_parameter: Optional[str] = None,
        modified_access_conditions: Optional[_models.ModifiedAccessConditions] = None,
        **kwargs: Any
    ) -> None:
        """[Update] establishes and manages a lock on a container for delete operations. The lock duration
        can be 15 to 60 seconds, or can be infinite.

        :param lease_id: Specifies the current lease ID on the resource.
        :type lease_id: str
        :param proposed_lease_id: Proposed lease ID, in a GUID string format. The Blob service returns
         400 (Invalid request) if the proposed lease ID is not in the correct format. See Guid
         Constructor (String) for a list of valid GUID string formats.
        :type proposed_lease_id: str
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
         Timeouts for Blob Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled. Default
         value is None.
        :type request_id_parameter: str
        :param modified_access_conditions: Parameter group. Default value is None.
        :type modified_access_conditions: ~azure.storage.blob.models.ModifiedAccessConditions
        :keyword comp: comp. Default value is "lease". Note that overriding this default value may
         result in unsupported behavior.
        :paramtype comp: str
        :keyword restype: restype. Default value is "container". Note that overriding this default
         value may result in unsupported behavior.
        :paramtype restype: str
        :keyword action: Describes what lease action to take. Default value is "change". Note that
         overriding this default value may result in unsupported behavior.
        :paramtype action: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        comp = kwargs.pop('comp', _params.pop('comp', "lease"))  # type: str
        restype = kwargs.pop('restype', _params.pop('restype', "container"))  # type: str
        action = kwargs.pop('action', _headers.pop('x-ms-lease-action', "change"))  # type: str
        cls = kwargs.pop('cls', None)  # type: ClsType[None]

        _if_modified_since = None
        _if_unmodified_since = None
        if modified_access_conditions is not None:
            _if_modified_since = modified_access_conditions.if_modified_since
            _if_unmodified_since = modified_access_conditions.if_unmodified_since

        request = build_change_lease_request(
            url=self._config.url,
            comp=comp,
            restype=restype,
            action=action,
            version=self._config.version,
            lease_id=lease_id,
            proposed_lease_id=proposed_lease_id,
            timeout=timeout,
            if_modified_since=_if_modified_since,
            if_unmodified_since=_if_unmodified_since,
            request_id_parameter=request_id_parameter,
            template_url=self.change_lease.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
        response_headers['x-ms-lease-id']=self._deserialize('str', response.headers.get('x-ms-lease-id'))
        response_headers['x-ms-client-request-id']=self._deserialize('str', response.headers.get('x-ms-client-request-id'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))


        if cls:
            return cls(pipeline_response, None, response_headers)

    change_lease.metadata = {'url': "{url}/{containerName}"}  # type: ignore


    @distributed_trace_async
    async def list_blob_flat_segment(
        self,
        prefix: Optional[str] = None,
        marker: Optional[str] = None,
        maxresults: Optional[int] = None,
        include: Optional[List[Union[str, "_models.ListBlobsIncludeItem"]]] = None,
        timeout: Optional[int] = None,
        request_id_parameter: Optional[str] = None,
        **kwargs: Any
    ) -> _models.ListBlobsFlatSegmentResponse:
        """[Update] The List Blobs operation returns a list of the blobs under the specified container.

        :param prefix: Filters the results to return only containers whose name begins with the
         specified prefix. Default value is None.
        :type prefix: str
        :param marker: A string value that identifies the portion of the list of containers to be
         returned with the next listing operation. The operation returns the NextMarker value within the
         response body if the listing operation did not return all containers remaining to be listed
         with the current page. The NextMarker value can be used as the value for the marker parameter
         in a subsequent call to request the next page of list items. The marker value is opaque to the
         client. Default value is None.
        :type marker: str
        :param maxresults: Specifies the maximum number of containers to return. If the request does
         not specify maxresults, or specifies a value greater than 5000, the server will return up to
         5000 items. Note that if the listing operation crosses a partition boundary, then the service
         will return a continuation token for retrieving the remainder of the results. For this reason,
         it is possible that the service will return fewer results than specified by maxresults, or than
         the default of 5000. Default value is None.
        :type maxresults: int
        :param include: Include this parameter to specify one or more datasets to include in the
         response. Default value is None.
        :type include: list[str or ~azure.storage.blob.models.ListBlobsIncludeItem]
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
         Timeouts for Blob Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled. Default
         value is None.
        :type request_id_parameter: str
        :keyword restype: restype. Default value is "container". Note that overriding this default
         value may result in unsupported behavior.
        :paramtype restype: str
        :keyword comp: comp. Default value is "list". Note that overriding this default value may
         result in unsupported behavior.
        :paramtype comp: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ListBlobsFlatSegmentResponse, or the result of cls(response)
        :rtype: ~azure.storage.blob.models.ListBlobsFlatSegmentResponse
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        restype = kwargs.pop('restype', _params.pop('restype', "container"))  # type: str
        comp = kwargs.pop('comp', _params.pop('comp', "list"))  # type: str
        cls = kwargs.pop('cls', None)  # type: ClsType[_models.ListBlobsFlatSegmentResponse]

        
        request = build_list_blob_flat_segment_request(
            url=self._config.url,
            restype=restype,
            comp=comp,
            version=self._config.version,
            prefix=prefix,
            marker=marker,
            maxresults=maxresults,
            include=include,
            timeout=timeout,
            request_id_parameter=request_id_parameter,
            template_url=self.list_blob_flat_segment.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['Content-Type']=self._deserialize('str', response.headers.get('Content-Type'))
        response_headers['x-ms-client-request-id']=self._deserialize('str', response.headers.get('x-ms-client-request-id'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))

        deserialized = self._deserialize('ListBlobsFlatSegmentResponse', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    list_blob_flat_segment.metadata = {'url': "{url}/{containerName}"}  # type: ignore


    @distributed_trace_async
    async def list_blob_hierarchy_segment(
        self,
        delimiter: str,
        prefix: Optional[str] = None,
        marker: Optional[str] = None,
        maxresults: Optional[int] = None,
        include: Optional[List[Union[str, "_models.ListBlobsIncludeItem"]]] = None,
        timeout: Optional[int] = None,
        request_id_parameter: Optional[str] = None,
        **kwargs: Any
    ) -> _models.ListBlobsHierarchySegmentResponse:
        """[Update] The List Blobs operation returns a list of the blobs under the specified container.

        :param delimiter: When the request includes this parameter, the operation returns a BlobPrefix
         element in the response body that acts as a placeholder for all blobs whose names begin with
         the same substring up to the appearance of the delimiter character. The delimiter may be a
         single character or a string.
        :type delimiter: str
        :param prefix: Filters the results to return only containers whose name begins with the
         specified prefix. Default value is None.
        :type prefix: str
        :param marker: A string value that identifies the portion of the list of containers to be
         returned with the next listing operation. The operation returns the NextMarker value within the
         response body if the listing operation did not return all containers remaining to be listed
         with the current page. The NextMarker value can be used as the value for the marker parameter
         in a subsequent call to request the next page of list items. The marker value is opaque to the
         client. Default value is None.
        :type marker: str
        :param maxresults: Specifies the maximum number of containers to return. If the request does
         not specify maxresults, or specifies a value greater than 5000, the server will return up to
         5000 items. Note that if the listing operation crosses a partition boundary, then the service
         will return a continuation token for retrieving the remainder of the results. For this reason,
         it is possible that the service will return fewer results than specified by maxresults, or than
         the default of 5000. Default value is None.
        :type maxresults: int
        :param include: Include this parameter to specify one or more datasets to include in the
         response. Default value is None.
        :type include: list[str or ~azure.storage.blob.models.ListBlobsIncludeItem]
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
         Timeouts for Blob Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled. Default
         value is None.
        :type request_id_parameter: str
        :keyword restype: restype. Default value is "container". Note that overriding this default
         value may result in unsupported behavior.
        :paramtype restype: str
        :keyword comp: comp. Default value is "list". Note that overriding this default value may
         result in unsupported behavior.
        :paramtype comp: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ListBlobsHierarchySegmentResponse, or the result of cls(response)
        :rtype: ~azure.storage.blob.models.ListBlobsHierarchySegmentResponse
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        restype = kwargs.pop('restype', _params.pop('restype', "container"))  # type: str
        comp = kwargs.pop('comp', _params.pop('comp', "list"))  # type: str
        cls = kwargs.pop('cls', None)  # type: ClsType[_models.ListBlobsHierarchySegmentResponse]

        
        request = build_list_blob_hierarchy_segment_request(
            url=self._config.url,
            restype=restype,
            comp=comp,
            version=self._config.version,
            delimiter=delimiter,
            prefix=prefix,
            marker=marker,
            maxresults=maxresults,
            include=include,
            timeout=timeout,
            request_id_parameter=request_id_parameter,
            template_url=self.list_blob_hierarchy_segment.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['Content-Type']=self._deserialize('str', response.headers.get('Content-Type'))
        response_headers['x-ms-client-request-id']=self._deserialize('str', response.headers.get('x-ms-client-request-id'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))

        deserialized = self._deserialize('ListBlobsHierarchySegmentResponse', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    list_blob_hierarchy_segment.metadata = {'url': "{url}/{containerName}"}  # type: ignore


    @distributed_trace_async
    async def get_account_info(  # pylint: disable=inconsistent-return-statements
        self,
        **kwargs: Any
    ) -> None:
        """Returns the sku name and account kind.

        :keyword restype: restype. Default value is "account". Note that overriding this default value
         may result in unsupported behavior.
        :paramtype restype: str
        :keyword comp: comp. Default value is "properties". Note that overriding this default value may
         result in unsupported behavior.
        :paramtype comp: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        restype = kwargs.pop('restype', _params.pop('restype', "account"))  # type: str
        comp = kwargs.pop('comp', _params.pop('comp', "properties"))  # type: str
        cls = kwargs.pop('cls', None)  # type: ClsType[None]

        
        request = build_get_account_info_request(
            url=self._config.url,
            restype=restype,
            comp=comp,
            version=self._config.version,
            template_url=self.get_account_info.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['x-ms-client-request-id']=self._deserialize('str', response.headers.get('x-ms-client-request-id'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))
        response_headers['x-ms-sku-name']=self._deserialize('str', response.headers.get('x-ms-sku-name'))
        response_headers['x-ms-account-kind']=self._deserialize('str', response.headers.get('x-ms-account-kind'))


        if cls:
            return cls(pipeline_response, None, response_headers)

    get_account_info.metadata = {'url': "{url}/{containerName}"}  # type: ignore

