<xsl:stylesheet id="ss" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
    version="2.0" 
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    xmlns:fos="http://www.w3.org/xpath-functions/spec/namespace"
    xmlns:sf="http://www.saxonica.com/ns/doc/functions"
    xmlns="http://www.saxonica.com/ns/doc/functions"
    exclude-result-prefixes="xs fos sf"
    xpath-default-namespace="http://www.saxonica.com/ns/doc/functions">
    <xsl:output indent="yes" />
    <xsl:key name="fnKey" match="fos:function" use="@name"/>
    <xsl:key name="fnKey2" match="sf:function" use="substring-after(sf:name,':')"/>
    <xsl:variable name="w3c-catalog" select="document('../../w3c-function-catalog/function-catalog.xml')"/>
    <xsl:variable name="saxon-doc" select="//sf:functions"/>
    
    <!--  saxon-catalog document -->
    <xsl:template match="/">
        <xsl:variable name="stage1">
        <functions>
            <xsl:for-each-group select="//sf:function" group-by="sf:name">
                <xsl:sort  select="current-grouping-key()" lang="en" />
                <xsl:variable name="funcName" select="substring-after(sf:name, ':')" />
                <xsl:apply-templates select="current-group()[1]"/>
            </xsl:for-each-group>
            <xsl:apply-templates select="$w3c-catalog//fos:function[not(key('fnKey2',@name,current()))]"/>
        </functions>
        </xsl:variable>
        <functions>
      <xsl:for-each select="$stage1/functions/function">
          <xsl:sort select="name" lang="en"/>
          
          <xsl:copy-of select="."/>
      </xsl:for-each>
      </functions>
    </xsl:template>
    
    <xsl:template match="sf:function">
        <xsl:variable name="funcName" select="substring-after(sf:name, ':')" />
            <xsl:apply-templates select="$w3c-catalog//fos:functions">
                <xsl:with-param  name="MyFuncName" select="$funcName"/>
                <xsl:with-param  name="MyFunc" select="."/>
            </xsl:apply-templates>
    </xsl:template>
    
    <xsl:template match="fos:functions">
        <xsl:param name="MyFuncName" as="xs:string" required="yes"/>
        <xsl:param name="MyFunc" required="yes"/>
            <xsl:variable name=" fn" select="key('fnKey', $MyFuncName, $w3c-catalog)" />
            <xsl:choose>
                <xsl:when test="exists($fn)">
                    <!-- The union of the W3c and Saxon spec. Typically for XPath20 functions -->
                    <function>
                        <name>
                            <xsl:attribute name="namespace">http://www.w3.org/2005/xpath-functions</xsl:attribute>
                            <xsl:value-of select="$fn/@name" />
                        </name>
                        <xsl:apply-templates select="$fn/fos:signatures" mode="change_namespace" >
                            <xsl:with-param name="specs" select="'xpath20','xpath30','xslt20','xslt30'" tunnel="yes"/>
                        </xsl:apply-templates>
                        <xsl:apply-templates select="$MyFunc/sf:status" mode="change_namespace" />
                        <description>
                            <xsl:value-of select="$MyFunc/sf:description" />
                        </description>
                    </function>
                </xsl:when>
                <xsl:when test="not(exists($fn))">
                    <!-- Functions in the Saxon spec. that are not in the W3C spec. Typically  XSLT20 functions -->
                    <function>
                    <name>
                        <xsl:attribute name="namespace">http://www.w3.org/1999/XSL/Transform</xsl:attribute>
                        <xsl:value-of select="substring-after($MyFunc/sf:name,':')" ></xsl:value-of>
                    </name>
                        <xsl:choose>
                            <xsl:when test="exists($MyFunc/sf:signatures)">
                                <xsl:apply-templates select="$MyFunc/sf:signatures" mode="change_namespace" >
                                    <xsl:with-param name="specs" select="'xslt20','xslt30'" tunnel="yes"/>
                                </xsl:apply-templates>
                            </xsl:when>
                            <xsl:otherwise>
                                <signatures>
                                    <proto>
                                        <xsl:attribute name="name">
                                            <xsl:value-of select="substring-after($MyFunc/sf:name, ':')"/>
                                        </xsl:attribute>
                                        <xsl:attribute name="return-type">
                                            <xsl:value-of select="$MyFunc/sf:result/@type"/>
                                        </xsl:attribute>
                                        <xsl:apply-templates select="$MyFunc/sf:args" mode="change_namespace" />
                                        
                                        <in-spec>xslt20</in-spec>
                                        <in-spec>xslt30</in-spec>
                                    </proto>
                                </signatures>
                            </xsl:otherwise>
                        </xsl:choose>
                        
                        <xsl:apply-templates select="$MyFunc/sf:status" mode="change_namespace" />
                        <xsl:apply-templates select="$MyFunc/sf:description" mode="change_namespace" />
                    </function>
                </xsl:when>
            </xsl:choose>
    </xsl:template>
    
    <xsl:template match="fos:function[not(exists(fos:opermap))]">
                <!-- Functions in the W3C spec. that are not in the Saxon spec. Typically these are XPath30 functions -->
                <function>
                    <name>
                        <xsl:choose>
                            <xsl:when test="@prefix='math'"><xsl:attribute name="namespace">http://www.w3.org/2005/xpath-functions/math</xsl:attribute></xsl:when>
                            <xsl:otherwise><xsl:attribute name="namespace">http://www.w3.org/2005/xpath-functions</xsl:attribute></xsl:otherwise>
                        </xsl:choose>
                        <xsl:value-of select="@name" ></xsl:value-of>
                    </name>
                <xsl:apply-templates select="fos:signatures" mode="change_namespace" >
                    <xsl:with-param name="specs" select="'xpath30','xslt30'" tunnel="yes"/>
                </xsl:apply-templates>
                    <xsl:apply-templates select="fos:summary" mode="change_namespace"/>
                </function>
    </xsl:template>
    
    <xsl:template match="*" mode="change_namespace">
        <xsl:element name="{local-name()}" namespace="http://www.saxonica.com/ns/doc/functions">
            <xsl:copy-of select="@*" />
            <xsl:apply-templates mode="change_namespace" />
        </xsl:element>
    </xsl:template>
     
     <xsl:template match="fos:proto" mode="change_namespace">
         <xsl:param name="specs" tunnel="yes" as="xs:string*"/>
         <xsl:element name="{local-name()}" namespace="http://www.saxonica.com/ns/doc/functions">
             <xsl:copy-of select="@*" />
             <xsl:apply-templates mode="change_namespace" />
             <xsl:for-each select="$specs">
                 <in-spec>
                     <xsl:value-of select="." />
                 </in-spec>    
             </xsl:for-each>
             
         </xsl:element>
         
     </xsl:template>
    
</xsl:stylesheet>