/*
 *	file related utilities
 *
 *	Copyright (C) 2010 Olaf Kirch <okir@suse.de>
 *	Copyright (C) 2011-2021 SUSE LCC
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 *	Authors:
 *		Olaf Kirch
 *		Marius Tomaschewski
 *
 *	libnetcontrol contains source code which is based on wicked.
 *	Wicked is licensed under the GPL-2.0+, but permission has been
 *	granted by the authors of wicked to use the code derived from
 *	wicked under the LGPL-2.1+ in libnetcontrol.
 *	See the wicked project at <https://github.com/openSUSE/wicked>.
 *
 */
#ifndef __NETCONTROL_FUTILS_H
#define __NETCONTROL_FUTILS_H
#if defined(HAVE_CONFIG_H)
#include <config.h>
#endif

#include <sutils.h>

#ifdef __GNUC__
# define __fmtattr(f,a) __attribute__ ((format (printf, f, a)))
#else
# define __fmtattr(f,a) /* */
#endif 

int		nc_scandir(const char *path, const char *filter, nc_string_array_t *result);

int		nc_readlink(const char *link, char **path);

const char *	nc_basename(const char *path);

int /* bool */	nc_isdir(const char *path);
int /* bool */	nc_isreg(const char *path);

int /* bool */	nc_file_exists(const char *filename);
int /* bool */	nc_file_exists_fmt(const char *fmt, ...) __fmtattr(1,2);
int /* bool */	nc_file_executable(const char *filename);

/**
  * Create a dot file name with optional suffix, e.g.
  * 	/path/to/file => /path/to/.file[suffix]
  */
int		nc_make_dot_suffix(nc_stringbuf_t *buff, const char *path, const char *suffix);

/**
  * Rename filename to a dot backup, when filename exists.
  */
int		nc_rename_to_dot_backup(const char *filename, const char *dot_suffix);

#undef __fmtattr

#endif /* __NETCONTROL_FUTILS_H */
