/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.dev;

import com.sun.midp.io.j2me.storage.File;
import com.sun.midp.io.j2me.storage.RandomAccessStream;
import com.sun.midp.midlet.MIDletSuite;
import com.sun.midp.midlet.Scheduler;
import com.sun.midp.midletsuite.InvalidJadException;
import com.sun.midp.midletsuite.JadProperties;
import com.sun.midp.midletsuite.MIDletSuiteImpl;
import java.io.IOException;
import java.io.InputStream;

public class DevMIDletSuiteImpl
extends MIDletSuiteImpl {
    private JadProperties bufferedJadProps = null;
    private String initialMIDletClassName = null;
    private String storageRoot = null;
    private int numberOfMidlets = -1;

    public DevMIDletSuiteImpl(String jadFilename, String midletClassName, String storageName) throws IOException, InvalidJadException {
        this.initialize(jadFilename, midletClassName, storageName);
        if (jadFilename == null) {
            this.numberOfMidlets = 1;
        }
    }

    public DevMIDletSuiteImpl(String jadFilename, String midletClassName) throws IOException, InvalidJadException {
        this.initialize(jadFilename, midletClassName, "run_by_class_storage_");
    }

    private void initialize(String jadFilename, String midletClassName, String storageName) throws IOException, InvalidJadException {
        MIDletSuite midletSuite = Scheduler.getScheduler().getMIDletSuite();
        if (midletSuite != null) {
            midletSuite.checkIfPermitted(9);
        }
        if (jadFilename != null) {
            RandomAccessStream storage = new RandomAccessStream();
            storage.connect(jadFilename, 1);
            try {
                InputStream jadStream = storage.openInputStream();
                this.bufferedJadProps = new JadProperties();
                this.bufferedJadProps.load(jadStream);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                storage.disconnect();
            }
        }
        this.storageRoot = File.getStorageRoot() + storageName;
        this.initialMIDletClassName = midletClassName;
        this.numberOfMidlets = this.countMIDlets();
    }

    public String getProperty(String key) {
        if (this.bufferedJadProps == null) {
            return null;
        }
        return this.bufferedJadProps.getProperty(key);
    }

    public int getNumberOfMIDlets() {
        return this.numberOfMidlets;
    }

    public void loadInitialMIDlet() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.loadInitialMIDlet(this.initialMIDletClassName, false);
    }

    public String getSecurityDomainName() {
        return "untrusted";
    }

    public void checkIfPermitted(int action) {
        throw new SecurityException();
    }

    public void schedule() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Scheduler.getScheduler().schedule(this);
    }

    public String getStorageRoot() {
        return this.storageRoot;
    }

    public byte[] getResource(String name) {
        return null;
    }

    public int getStorageUsed() {
        return 0;
    }

    public String getJadUrl() {
        return "None";
    }
}

