/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kssl;

import com.sun.ksecurity.CryptoException;
import com.sun.ksecurity.Key;
import com.sun.kssl.RSASig;

public abstract class Signature {
    public static final byte ALG_RSA_MD5_PKCS1 = 1;
    public static final byte ALG_RSA_SHA_PKCS1 = 2;
    protected static final byte MODE_UNKNOWN = 0;
    public static final byte MODE_SIGN = 1;
    public static final byte MODE_VERIFY = 2;

    protected Signature() {
    }

    public static Signature getInstance(byte alg, boolean ext) throws CryptoException {
        switch (alg) {
            case 1: 
            case 2: {
                return new RSASig(alg);
            }
        }
        throw new CryptoException(4);
    }

    public abstract byte getAlgorithm();

    public abstract short getLength();

    public abstract void init(Key var1, byte var2) throws CryptoException;

    public abstract void init(Key var1, byte var2, byte[] var3, int var4, int var5) throws CryptoException;

    public abstract void update(byte[] var1, int var2, int var3) throws CryptoException;

    public abstract short sign(byte[] var1, int var2, int var3, byte[] var4, int var5) throws CryptoException;

    public abstract boolean verify(byte[] var1, int var2, int var3, byte[] var4, int var5, short var6) throws CryptoException;
}

