#! /bin/bash
#
# Johannes Meixner <jsmeix@suse.de>, 2010

#set -x

# Make sure to have a clean environment:
export PATH="/sbin:/usr/sbin:/usr/bin:/bin"
export LC_ALL="POSIX"
export LANG="POSIX"
umask 022
# Disable bash file name globbing to avoid side-effects
# with characters like '*' and '?' (see bnc #575056):
set -f

# See at
# http://www.linuxfoundation.org/collaborate/workgroups/openprinting/database/query
# the section about "Modification of the output":

wget -O printers.xml 'http://openprinting.org/query.cgi?type=printers&moreinfo=1&format=xml'
# results printers.xml with entries like
# ------------------------------------------------------
#   <printer id="printer/Alps-MD-1300">
#     <id>Alps-MD-1300</id>
#     <make>Alps</make>
#     <model>MD-1300</model>
#     <functionality>A</functionality>
#     <driver>ppmtomd</driver>
#     <drivers>
#       <driver>md1xMono</driver>
#       <driver>md2k</driver>
#       <driver>ppmtocpva</driver>
#       <driver>ppmtomd</driver>
#     </drivers>
# ...
#   </printer>
# ------------------------------------------------------

wget -O drivers.xml 'http://openprinting.org/query.cgi?type=drivers&moreinfo=1&format=xml'
# results drivers.xml with entries like
# (an <obsolete replace="..." /> is optionally):
# ------------------------------------------------------
#   <driver id="driver/cdj690X.upp">
#     <name>cdj690X.upp</name>
#     <url>http://www.ghostscript.com/</url>
#     <obsolete replace="hplip" />
#     ...
#     <freesoftware />
#     <nopatents />
#     <execution>
#       <uniprint />
#     </execution>
#     ...
#   </driver>
# ...
#   <driver id="driver/epson-ep-302">
#     <name>epson-ep-302</name>
#     <url>http://avasys.jp/linux/</url>
#     ...
#     <nonfreesoftware />
#     <nopatents />
#     ...
#     <execution>
#       <cups />
#     </execution>
#     ...
#   </driver>
# ...
#   <driver id="driver/hplip">
#     <name>hplip</name>
#     <url>http://hplipopensource.com/</url>
#     ...
#     <freesoftware />
#     <nopatents />
#     ...
#     <execution>
#       <cups />
#     </execution>
#     ...
#   </driver>
# ...
#   <driver id="driver/ljet4">
#     <name>ljet4</name>
#     <url>http://www.ghostscript.com/</url>
#     ...
#     <freesoftware />
#     <nopatents />
#     ...
#     <execution>
#       <ghostscript />
#     </execution>
#     ...
#   </driver>
# ...
#   <driver id="driver/m2300w">
#     <name>m2300w</name>
#     <url>http://m2300w.sf.net/</url>
#     ...
#     <freesoftware />
#     <nopatents />
#     ...
#     <execution>
#       <filter />
#     </execution>
#     ...
#   </driver>
# ...
#   <driver id="driver/splix">
#     <name>splix</name>
#     <url>http://splix.ap2c.org/</url>
#     ...
#     <freesoftware />
#     <patents />
#     ...
#     <execution>
#       <cups />
#     </execution>
#     ...
#   </driver>
# ------------------------------------------------------

