#! /bin/bash
#
# Johannes Meixner <jsmeix@suse.de>, 2010

#set -x

# Make sure to have a clean environment:
export PATH="/sbin:/usr/sbin:/usr/bin:/bin"
export LC_ALL="POSIX"
export LANG="POSIX"
umask 022
# Disable bash file name globbing to avoid side-effects
# with characters like '*' and '?' (see bnc #575056):
set -f

EXAMPLES="examples_for_drivers_to_be_considered"
EXAMPLE_PPDS_DIR="driver_examples_ppds"
rm -rf $EXAMPLE_PPDS_DIR
mkdir $EXAMPLE_PPDS_DIR

# See at
# http://www.linuxfoundation.org/collaborate/workgroups/openprinting/database/query
# the section about "Downloading PPD files":
exec <$EXAMPLES
while read TYPE DRIVER PRINTER
do echo "Downloading $TYPE PPD for $DRIVER for $PRINTER:"
   if wget --no-verbose -O $EXAMPLE_PPDS_DIR/$PRINTER.$DRIVER.ppd \
           "http://www.openprinting.org/ppd-o-matic.cgi?driver=$DRIVER&printer=$PRINTER"
   then echo "============================================================="
   else echo "Failed to download $TYPE PPD for $DRIVER for $PRINTER" | tee -a example_PPDs_download_failed
   fi
   # Do not flood the OpenPprinting.org server with download requests:
   sleep 2
done
# The useless use of cat is intentional because 'wc -l file' would output also the file name:
if [ "$( cat $EXAMPLES | wc -l )" = "$( ls -1 $EXAMPLE_PPDS_DIR | wc -l  )" ]
then echo "Completely downloaded all PPDs into $EXAMPLE_PPDS_DIR for all examples in $EXAMPLES"
else echo "Failed to download PPDs into $EXAMPLE_PPDS_DIR for one or more examples in $EXAMPLES"
fi

