#! /bin/bash
#
# Johannes Meixner <jsmeix@suse.de>, 2010

#set -x

# Make sure to have a clean environment:
export PATH="/sbin:/usr/sbin:/usr/bin:/bin"
export LC_ALL="POSIX"
export LANG="POSIX"
umask 022
# Disable bash file name globbing to avoid side-effects
# with characters like '*' and '?' (see bnc #575056):
set -f

MY_NAME=${0##*/}
DRIVER_TYPE="$1"
[ -z "$DRIVER_TYPE" ] && { echo -en "\nUsage:\n$MY_NAME driver_type\ndriver_type is one of 'ghostscript', 'uniprint', 'ijs', 'postscript', 'filter', or 'unknown'\n" 1>&2 ; exit 1 ; }
PRINTERS="printers_for_${DRIVER_TYPE}_drivers"
[ -s "$PRINTERS"  ] || { echo -en "\nFile '$PRINTERS' is empty or does not exist\n" 1>&2 ; exit 2 ; }
PRINTER_PPDS_DIR="PPDs_for_printers_for_${DRIVER_TYPE}_drivers"
rm -rf $PRINTER_PPDS_DIR
mkdir $PRINTER_PPDS_DIR

# See at
# http://www.linuxfoundation.org/collaborate/workgroups/openprinting/database/query
# the section about "Downloading PPD files":
exec <$PRINTERS
while read TYPE DRIVER PRINTER
do echo "Downloading $TYPE PPD for $DRIVER for $PRINTER:"
   if wget --no-verbose -O $PRINTER_PPDS_DIR/$PRINTER.$DRIVER.ppd \
           "http://www.openprinting.org/ppd-o-matic.cgi?driver=$DRIVER&printer=$PRINTER"
   then echo "============================================================="
   else echo "Failed to download $TYPE PPD for $DRIVER for $PRINTER" | tee -a ${PRINTERS}_PPDs_download_failed
        echo "#############################################################"
   fi
   if ! test -s $PRINTER_PPDS_DIR/$PRINTER.$DRIVER.ppd
   then rm $PRINTER_PPDS_DIR/$PRINTER.$DRIVER.ppd
        echo "Removed empty downloaded $PRINTER_PPDS_DIR/$PRINTER.$DRIVER.ppd" | tee -a ${PRINTERS}_PPDs_download_failed
        echo "*************************************************************"
   fi
   # Do not flood the OpenPprinting.org server with download requests:
   sleep 5
done
# The useless use of cat is intentional because 'wc -l file' would output also the file name:
if [ "$( cat $PRINTERS | wc -l )" = "$( ls -1 $PRINTER_PPDS_DIR | wc -l  )" ]
then echo "Completely downloaded all PPDs into $PRINTER_PPDS_DIR for all examples in $PRINTERS"
else echo "Failed to download PPDs into $PRINTER_PPDS_DIR for one or more examples in $PRINTERS"
fi

