#! /bin/bash
#
# Johannes Meixner <jsmeix@suse.de>, 2014

#set -x

# Make sure to have a clean environment:
export PATH="/sbin:/usr/sbin:/usr/bin:/bin"
export LC_ALL="POSIX"
export LANG="POSIX"
umask 022
# Disable bash file name globbing to avoid side-effects
# with characters like '*' and '?' (see bnc #575056):
set -f

# Check PPDs only in those directories from which the tarball for the OpenPrintingPPDs package will be made:
POSTSCRIPT_PPDS_DIR="PPDs_for_printers_for_postscript_drivers"
GHOSTSCRIPT_PPDS_DIR="PPDs_for_printers_for_ghostscript_drivers"
HPIJS_PPDS_DIR="PPDs_for_printers_for_hpijs_drivers"

for D in $POSTSCRIPT_PPDS_DIR $GHOSTSCRIPT_PPDS_DIR $HPIJS_PPDS_DIR
do echo "Checking PPDs for non free license text snippets in $D"
   cd $D
   # Re-enable bash file name globbing only for the particular "for" commands:
   set +f
   for P in *.ppd
   do for S in $( cat ../non_free_license_text_snippets )
      do if grep '^\*%' $P | tr -c -d '[:alpha:][:blank:]' | tr -s '[:blank:]' '_' | grep -iq $S
         then echo "Removed $D/$P : contains non free license text snippet $S" | tee -a ../removed_PPDs_with_non_free_license_text_snippet
              rm $P
              # When one non free license text snippet was found and its PPD was removed break to directly proceed with the next PPD:
              break
         fi
      done
   done
   set -f
   cd ..
done

