#! /bin/bash
#
# Johannes Meixner <jsmeix@suse.de>, 2010

#set -x

# Make sure to have a clean environment:
export PATH="/sbin:/usr/sbin:/usr/bin:/bin"
export LC_ALL="POSIX"
export LANG="POSIX"
umask 022
# Disable bash file name globbing to avoid side-effects
# with characters like '*' and '?' (see bnc #575056):
set -f

# Source PPDs directories:
UNIPRINT_PPDS_DIR="PPDs_for_printers_for_uniprint_drivers"
IJS_PPDS_DIR="PPDs_for_printers_for_ijs_drivers"
UNKNOWN_PPDS_DIR="PPDs_for_printers_for_unknown_drivers"
# Source and destination PPDs directory:
POSTSCRIPT_PPDS_DIR="PPDs_for_printers_for_postscript_drivers"
# Destination PPDs directories:
GHOSTSCRIPT_PPDS_DIR="PPDs_for_printers_for_ghostscript_drivers"
HPIJS_PPDS_DIR="PPDs_for_printers_for_hpijs_drivers"
test -d $HPIJS_PPDS_DIR || mkdir $HPIJS_PPDS_DIR

cd $UNIPRINT_PPDS_DIR
# Re-enable bash file name globbing only for the particular "for" commands:
set +f
for P in *.ppd
do mv -v $P ../$GHOSTSCRIPT_PPDS_DIR
done
set -f
cd  ..

cd $IJS_PPDS_DIR
# Re-enable bash file name globbing only for the particular "for" commands:
set +f
for P in *.ppd
do # As of this writing (Sat Mar 29 2014) the FoomaticRIPCommandLines in those PPDs are
   #   *FoomaticRIPCommandLine: "gs -q -dBATCH -dPARANOIDSAFER -dQUIET -dNOPA&&
   #    USE -dNOINTERPOLATE -sDEVICE=ijs -sIjsServer=hpijs -sDeviceManufacture&&
   #    r=&quot;HEWLETT-PACKARD&quot; -sDeviceModel=&quot;HP LaserJet&quot;%A%&&
   #   B%C -dIjsUseOutputFD%Z -sOutputFile=- -"
   #   *End
   # which means all FoomaticRIPCommandLines are the same up to
   #   *FoomaticRIPCommandLine: "gs -q -dBATCH -dPARANOIDSAFER -dQUIET -dNOPA&&
   #   USE -sDEVICE=ijs -sIjsServer=hpijs
   # which means all those PPDs require the IJS driver executable /usr/bin/hpijs.
   if sed -n -e '/^\*FoomaticRIPCommandLine:/,/*End/p' $P \
      | tr -c -d '[:alnum:]' \
      | grep -q '^FoomaticRIPCommandLinegsqdBATCHdPARANOIDSAFERdQUIETdNOPAUSEdNOINTERPOLATEsDEVICEijssIjsServerhpijs'
   then mv -v $P ../$HPIJS_PPDS_DIR
   fi
done
set -f
cd ..

cd $UNKNOWN_PPDS_DIR
# Re-enable bash file name globbing only for the particular "for" commands:
set +f
for P in *.pxlmono-*.ppd
do mv -v $P ../$GHOSTSCRIPT_PPDS_DIR
done
for P in *.pxlcolor-*.ppd
do mv -v $P ../$GHOSTSCRIPT_PPDS_DIR
done
for P in *.Postscript-*.ppd
do set -f
   # PPDs which do not have any cupsFilter specified are pure PostScript PPDs:
   if ! grep -q '^\*cupsFilter:' $P
   then mv -v $P ../$POSTSCRIPT_PPDS_DIR
        continue
   fi
   # PPDs which use the cupsFilter foomatic-rip but the FoomaticRIPCommandLine
   # does not call 'gs' or another real driver program are also PostScript PPDs:
   if grep -q '^\*cupsFilter: "application/vnd.cups-postscript 0 foomatic-rip"' $P
   then # As of this writing (Sat Mar 29 2014) the FoomaticRIPCommandLine in those PPDs are
        #   *FoomaticRIPCommandLine: "printf &quot;%%!PS-Adobe-3.0\n%%%% %%&&
        #   %%\n%A%B%C%D&quot;%%%%; cat;"
        #   *End
        # or
        #   *FoomaticRIPCommandLine: "printf &quot;%%!PS-Adobe-3.0
        #   %%%%Title: (&title;)
        #   %%
        #   %%\n%A%B%C%D&quot;%%%%; cat;"
        #   *End
        # which inserts PostScript snippets from the PPD at the beginning of the PostScript data.
        if sed -n -e '/^\*FoomaticRIPCommandLine:/,/*End/p' $P \
           | tr -c -d '[:alnum:]' \
           | grep -q '^FoomaticRIPCommandLineprintfquotPSAdobe30'
        then mv -v $P ../$POSTSCRIPT_PPDS_DIR
        fi
   fi
done
# Re-enable bash file name globbing only for the particular "for" command:
set +f
for P in *.Postscript2-*.ppd
do set -f
   # PPDs which do not have any cupsFilter specified are pure PostScript PPDs:
   if ! grep -q '^\*cupsFilter:' $P
   then mv -v $P ../$POSTSCRIPT_PPDS_DIR
        continue
   fi
done
cd ..

cd $POSTSCRIPT_PPDS_DIR
# Re-enable bash file name globbing only for the particular "for" commands:
set +f
for P in *.Postscript1.ppd
do set -f
   mv -v $P ../$GHOSTSCRIPT_PPDS_DIR
done
cd ..

