#! /bin/bash
#
# Johannes Meixner <jsmeix@suse.de>, 2010

#set -x

# Make sure to have a clean environment:
export PATH="/sbin:/usr/sbin:/usr/bin:/bin"
export LC_ALL="POSIX"
export LANG="POSIX"
umask 022
# Disable bash file name globbing to avoid side-effects
# with characters like '*' and '?' (see bnc #575056):
set -f

EXAMPLE_PPDS_DIR="driver_examples_ppds"
for suffix in ghostscript uniprint ijs postscript filter unknown
do rm -rf $EXAMPLE_PPDS_DIR.$suffix
   mkdir $EXAMPLE_PPDS_DIR.$suffix
done

cd $EXAMPLE_PPDS_DIR
# Re-enable bash file name globbing only for this particular "for" command:
set +f
for P in *.ppd
do set -f
   driverType="$( grep -o '^\*driverType [^:]*:' $P )"
   if [ "*driverType G/Ghostscript built-in:" = "$driverType" ]
   then cp $P ../$EXAMPLE_PPDS_DIR.ghostscript
        continue
   fi
   if [ "*driverType U/Ghostscript Uniprint:" = "$driverType" ]
   then cp $P ../$EXAMPLE_PPDS_DIR.uniprint
        continue
   fi
   if [ "*driverType I/IJS:" = "$driverType" ]
   then cp $P ../$EXAMPLE_PPDS_DIR.ijs
        continue
   fi
   if [ "*driverType P/PostScript:" = "$driverType" ]
   then cp $P ../$EXAMPLE_PPDS_DIR.postscript
        continue
   fi
   if [ "*driverType F/Filter:" = "$driverType" ]
   then cp $P ../$EXAMPLE_PPDS_DIR.filter
        continue
   fi
   cp $P ../$EXAMPLE_PPDS_DIR.unknown
done
cd ..

# Leave out drivers of type "filter" because usually
# such drivers are not provided (i.e. supported) by openSUSE
# and if such a driver would be supported, it would be provided
# in a separated RPM package which also includes its matching PPDs.
for suffix in ghostscript uniprint ijs postscript unknown
do ls -1 $EXAMPLE_PPDS_DIR.$suffix | cut -s -d '.' -f2 >supported_drivers.$suffix
   sed -i -e "s/^/$suffix /" supported_drivers.$suffix
done
# Uniprint drivers are named "<upp_file_base_name_identifier>.upp":
sed -i -e "s/$/.upp/" supported_drivers.uniprint

