#! /bin/bash
#
# Johannes Meixner <jsmeix@suse.de>, 2010

#set -x

# Make sure to have a clean environment:
export PATH="/sbin:/usr/sbin:/usr/bin:/bin"
export LC_ALL="POSIX"
export LANG="POSIX"
umask 022
# Disable bash file name globbing to avoid side-effects
# with characters like '*' and '?' (see bnc #575056):
set -f

cat /dev/null >cupstestppd_failed

for suffix in ghostscript hpijs postscript
do PPDS_DIR="PPDs_for_printers_for_${suffix}_drivers"
   cd $PPDS_DIR
   # Re-enable bash file name globbing only for this particular "for" command:
   set +f
   for P in *.ppd
   do set -f
      # Do not sort out any PPD because even if a PPD fails badly for cupstestppd
      # it does usually work somehow to use such a PPD for printing nevertheless:
      if ! cupstestppd -W all -r $P
      then echo "cupstestppd failed for $PPDS_DIR/$P" >>../cupstestppd_failed
      fi
   done
   cd ..
done

