# -*- coding: utf-8 -*-
"""\
Tests against text generation.
"""
from __future__ import absolute_import, unicode_literals
import pyqrcodeng as pyqrcode


def test_txt():
    qr = pyqrcode.create('test', error='H')
    expected = '00000000000000000000000000000\n' \
               '00000000000000000000000000000\n' \
               '00000000000000000000000000000\n' \
               '00000000000000000000000000000\n' \
               '00001111111011101011111110000\n' \
               '00001000001001100010000010000\n' \
               '00001011101000100010111010000\n' \
               '00001011101010011010111010000\n' \
               '00001011101000110010111010000\n' \
               '00001000001001010010000010000\n' \
               '00001111111010101011111110000\n' \
               '00000000000001001000000000000\n' \
               '00000010111011000100010010000\n' \
               '00000001100110001011000110000\n' \
               '00001111101010001111011110000\n' \
               '00001111010011011001100100000\n' \
               '00001100011011100001010110000\n' \
               '00000000000010111000010010000\n' \
               '00001111111001100000110110000\n' \
               '00001000001011101010000100000\n' \
               '00001011101010110010110110000\n' \
               '00001011101001000011000100000\n' \
               '00001011101010001101001010000\n' \
               '00001000001001110111110100000\n' \
               '00001111111000100111001110000\n' \
               '00000000000000000000000000000\n' \
               '00000000000000000000000000000\n' \
               '00000000000000000000000000000\n' \
               '00000000000000000000000000000\n'
    assert expected == qr.text()


def test_txt_no_quietzone():
    qr = pyqrcode.create('test', error='h')
    expected = '111111101110101111111\n' \
               '100000100110001000001\n' \
               '101110100010001011101\n' \
               '101110101001101011101\n' \
               '101110100011001011101\n' \
               '100000100101001000001\n' \
               '111111101010101111111\n' \
               '000000000100100000000\n' \
               '001011101100010001001\n' \
               '000110011000101100011\n' \
               '111110101000111101111\n' \
               '111101001101100110010\n' \
               '110001101110000101011\n' \
               '000000001011100001001\n' \
               '111111100110000011011\n' \
               '100000101110101000010\n' \
               '101110101011001011011\n' \
               '101110100100001100010\n' \
               '101110101000110100101\n' \
               '100000100111011111010\n' \
               '111111100010011100111\n'
    assert expected == qr.text(quiet_zone=0)


if __name__ == '__main__':
    import pytest
    pytest.main([__file__])
