/**************************************************************************
Copyright (C) 2000 - 2010 Novell, Inc.
All Rights Reserved.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

**************************************************************************/


/*---------------------------------------------------------------------\
|								       |
|		       __   __	  ____ _____ ____		       |
|		       \ \ / /_ _/ ___|_   _|___ \		       |
|			\ V / _` \___ \ | |   __) |		       |
|			 | | (_| |___) || |  / __/		       |
|			 |_|\__,_|____/ |_| |_____|		       |
|								       |
|				core system			       |
|						     (c) SuSE Linux AG |
\----------------------------------------------------------------------/

  File:		YQZyppSolverDialogPluginStub.cc

  Authors:	Stefan Schubert <schubi@suse.de>

  Textdomain "qt-pkg"


/-*/

#include <qmessagebox.h>
#include "YQZyppSolverDialogPluginStub.h"

#define YUILogComponent "qt-ui"
#include "YUILog.h"
#include "YQi18n.h"

#define PLUGIN_BASE_NAME "qt_zypp_solver_dialog"

using std::endl;

YQZyppSolverDialogPluginStub::YQZyppSolverDialogPluginStub()
    : YUIPlugin( PLUGIN_BASE_NAME )
{
    if ( success() )
    {
	yuiMilestone() << "Loaded " << PLUGIN_BASE_NAME
                       << " plugin successfully from " << pluginLibFullPath()
                       << endl;
    }


    impl = (YQZyppSolverDialogPluginIf*) locateSymbol("ZYPPDIALOGP");

    if ( ! impl )
    {
        yuiError() << "Plugin " << PLUGIN_BASE_NAME << " does not provide ZYPPP symbol" << endl;
    }
}


YQZyppSolverDialogPluginStub::~YQZyppSolverDialogPluginStub()
{
    // NOP
}


bool
YQZyppSolverDialogPluginStub::createZyppSolverDialog( const zypp::PoolItem item )
{
    if ( ! impl )
    {
	QMessageBox::information( 0,
			       _("Missing package") ,
			       _("Package libqdialogsolver is required for this feature."));
	return false;
    }

    return impl->createZyppSolverDialog( item );
}


