Hi all, thanks for using the library, your contributions, and especially for not bitching about me not being very responsive.

I have been giving the future of `ddt` some thought over the past weeks.

To give some background about how `ddt` came to be: I was looking for something that gave to unit tests a similar power as to what one could do with nosetests generators (which only worked for nose function-based tests): the ability to run a test case multiple times with different data. At that time I was beginning to learn me some more advanced Python (I had only been using the language for a few months) and was exploring the various mechanisms for metaprogramming available in the language. I was fascinated that one could add methods to a class at runtime, and I wrote this then tiny library that did that.

Over time I've been taking some people's contributions, some of which grew the feature set into areas I hadn't even considered (like reading data from files) - but in honesty, that tiny initial feature has been enough for me and is about the only one I've actually personally used from the library.

This has unfortunately meant that I've not always been paying as much attention as I should have to backwards compatibility of certain features (which made some people not particularly happy) or simplifying extensibility in general.

Back from that digression, I've often thought that I wanted `ddt` to go back to its simpler origins, but still be easily applicable to other people's more complex use cases. One of the design decisions I've come to regret the most about `ddt` has been using `*args` as the mechanism to pass test data to the test methods, because that limits the potential for the API to grow quite a bit.

My current thinking of what the new ddt should look like is:

- keep the class decorator `ddt`
- a single method decorator that takes test data as an iterable (e.g. similar to the one proposed in https://github.com/txels/ddt/pull/40), and options as keyword arguments. A well defined mechanism would tell ddt how to generate suffixes for the test cases from the test data.
- get rid of all the other decorators for unpacking, reading from file etc.
  - the unpacking options would become keyword arguments to the main decorator (e.g. `unpack`, `unpack_dict` or similar...)
  - the methods to read from file etc would be just methods that read from a file and return some iterable over the data

E.g. assuming we call the new decorator `idata`, it would look like:

```
@idata(test_data, **options)
def test_something(self, value):
```

E.g. in a practical use:

```
@idata(from_file('something.yml'), unpack=TUPLE)
def test_something(self, x, y, z):
```

```
@idata(some_dict, unpack=DICT)
def test_something_else(self, x, y, result):
```



Requested features like cartesian products or even additional boundary test data generation could easily be added as just plain functions with whatever arguments that return an iterable.
