#ifndef _BSC1192036_H_
#define _BSC1192036_H_

int livepatch_bsc1192036_firewire_firedtv_avc_init(void);
void livepatch_bsc1192036_firewire_firedtv_avc_cleanup(void);
int livepatch_bsc1192036_firewire_firedtv_ci_init(void);
void livepatch_bsc1192036_firewire_firedtv_ci_cleanup(void);

/* klp-ccp: from drivers/media/firewire/firedtv.h */
#include <linux/time.h>
#include <linux/dvb/dmx.h>
#include <linux/dvb/frontend.h>
#include <linux/list.h>
#include <linux/mod_devicetable.h>
#include <linux/mutex.h>
#include <linux/spinlock_types.h>
#include <linux/types.h>
#include <linux/wait.h>
#include <linux/workqueue.h>

#include <media/demux.h>
#include <media/dmxdev.h>
#include <media/dvb_demux.h>
#include <media/dvb_frontend.h>
#include <media/dvb_net.h>
#include <media/dvbdev.h>

enum model_type {
	FIREDTV_UNKNOWN = 0,
	FIREDTV_DVB_S   = 1,
	FIREDTV_DVB_C   = 2,
	FIREDTV_DVB_T   = 3,
	FIREDTV_DVB_S2  = 4,
};

struct firedtv {
	struct device *device;
	struct list_head list;

	struct dvb_adapter	adapter;
	struct dmxdev		dmxdev;
	struct dvb_demux	demux;
	struct dmx_frontend	frontend;
	struct dvb_net		dvbnet;
	struct dvb_frontend	fe;

	struct dvb_device	*cadev;
	int			ca_last_command;
	int			ca_time_interval;

	struct mutex		avc_mutex;
	wait_queue_head_t	avc_wait;
	bool			avc_reply_received;
	struct work_struct	remote_ctrl_work;
	struct input_dev	*remote_ctrl_dev;

	enum model_type		type;
	char			subunit;
	s8			isochannel;
	struct fdtv_ir_context	*ir_context;

	enum fe_sec_voltage	voltage;
	enum fe_sec_tone_mode	tone;

	struct mutex		demux_mutex;
	unsigned long		channel_active;
	u16			channel_pid[16];

	int			avc_data_length;
	u8			avc_data[512];
};

int klpp_avc_ca_pmt(struct firedtv *fdtv, char *msg, int length);

#endif /* _BSC1192036_H_ */
