/*
 * Copyright 2004 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
 
package org.apache.xerces.impl;

import org.apache.xerces.xni.XMLResourceIdentifier;

/**
 * <p>This interface describes the properties of entities--their
 * physical location and their name.</p>
 * 
 * @xerces.internal
 *
 * @author Michael Glavassevich, IBM
 * 
 * @version $Id: XMLEntityDescription.java,v 1.2 2005/03/29 13:08:29 nb131165 Exp $
 */
public interface XMLEntityDescription extends XMLResourceIdentifier {
	
    /** 
     * Sets the name of the entity.
     * 
     * @param name the name of the entity
     */
    public void setEntityName(String name);
     
    /** 
     * Returns the name of the entity. 
     *
     * @return the name of the entity 
     */
    public String getEntityName();
    
} // XMLEntityDescription
