/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29_00.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29_00.j9.DataType;
import com.ibm.j9ddr.vm29_00.pointer.U8Pointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.RasGlobalStoragePointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.UtComponentDataPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.UtComponentListPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.UtGlobalDataPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.UtModuleInfoPointer;
import com.ibm.j9ddr.vm29_00.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29_00.structure.RastraceInternalConstants;
import com.ibm.j9ddr.vm29_00.structure.UteModuleConstants;
import java.io.PrintStream;

public class TraceConfigCommand
extends Command {
    private final boolean verbose = false;

    public TraceConfigCommand() {
        this.addCommand("tpconfig", "[<component>|all]", "Lists trace components or tracepoints enabled for specified components");
    }

    @Override
    public void run(String command, String[] args, Context context, final PrintStream out) throws DDRInteractiveCommandException {
        try {
            J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
            RasGlobalStoragePointer rasGlobal = RasGlobalStoragePointer.cast(vm.j9rasGlobalStorage());
            UtGlobalDataPointer utGlobal = UtGlobalDataPointer.cast(rasGlobal.utGlobalData());
            UtComponentListPointer componentList = utGlobal.componentList();
            UtComponentDataPointer head = componentList.head();
            if (args.length == 0) {
                TraceConfigCommand.walkTraceComponents(new ModuleVisitor(){

                    @Override
                    public void visit(UtModuleInfoPointer modInfo) throws CorruptDataException {
                        out.println(TraceConfigCommand.moduleName(modInfo));
                    }
                }, head, context, out);
            } else if ("all".equals(args[0])) {
                TraceConfigCommand.walkTraceComponents(new ModuleVisitor(){

                    @Override
                    public void visit(UtModuleInfoPointer modInfo) throws CorruptDataException {
                        TraceConfigCommand.this.printActiveTracePoints(modInfo, out);
                    }
                }, head, context, out);
            } else {
                for (int i = 0; i < args.length; ++i) {
                    final String componentName = args[i];
                    TraceConfigCommand.walkTraceComponents(new ModuleVisitor(){

                        @Override
                        public void visit(UtModuleInfoPointer modInfo) throws CorruptDataException {
                            if (componentName.equals(TraceConfigCommand.moduleName(modInfo))) {
                                TraceConfigCommand.this.printActiveTracePoints(modInfo, out);
                            }
                        }
                    }, head, context, out);
                }
            }
        }
        catch (CorruptDataException e) {
            e.printStackTrace();
        }
    }

    private void printActiveTracePoints(UtModuleInfoPointer modInfo, PrintStream out) throws CorruptDataException {
        int count = modInfo.count().intValue();
        U8Pointer active = modInfo.active();
        String moduleName = TraceConfigCommand.moduleName(modInfo);
        for (int i = 0; i < count; ++i) {
            long state = active.at(i).longValue();
            if (state == RastraceInternalConstants.UT_NONE) continue;
            String stateStr = this.decodeTraceActivationState(state);
            out.println(moduleName + "." + i + " =" + stateStr);
        }
    }

    private String decodeTraceActivationState(long activeState) {
        String state = "";
        if (activeState == RastraceInternalConstants.UT_NONE) {
            state = state + " NONE";
        }
        if ((activeState & RastraceInternalConstants.UT_MAXIMAL) != 0L) {
            state = state + " MAXIMAL";
        }
        if ((activeState & RastraceInternalConstants.UT_MINIMAL) != 0L) {
            state = state + " MINIMAL";
        }
        if ((activeState & RastraceInternalConstants.UT_COUNT) != 0L) {
            state = state + " COUNT";
        }
        if ((activeState & RastraceInternalConstants.UT_PRINT) != 0L) {
            state = state + " PRINT";
        }
        if ((activeState & RastraceInternalConstants.UT_PLATFORM) != 0L) {
            state = state + " PLATFORM";
        }
        if ((activeState & RastraceInternalConstants.UT_EXCEPTION) != 0L) {
            state = state + " EXCEPTION";
        }
        if ((activeState & RastraceInternalConstants.UT_TRIGGER) != 0L) {
            state = state + " TRIGGER";
        }
        if ((activeState & RastraceInternalConstants.UT_EXTERNAL) != 0L) {
            state = state + " EXTERNAL";
        }
        if ((activeState & RastraceInternalConstants.UT_NONE) != 0L) {
            state = state + " NONE";
        }
        if ((activeState & UteModuleConstants.UT_SPECIAL_ASSERTION) != 0L) {
            state = state + " ASSERTION";
        }
        if (state.equals("")) {
            state = " <error unknown state>";
        }
        return state;
    }

    private static String moduleName(UtModuleInfoPointer modInfo) throws CorruptDataException {
        UtModuleInfoPointer containerModInfo = modInfo.containerModule();
        String moduleName = modInfo.name().getCStringAtOffset(0L, modInfo.namelength().intValue());
        if (containerModInfo != null && containerModInfo.notNull()) {
            String containerName = containerModInfo.name().getCStringAtOffset(0L, containerModInfo.namelength().intValue());
            return containerName + "(" + moduleName + ")";
        }
        return moduleName;
    }

    private static void walkTraceComponents(ModuleVisitor visitor, UtComponentDataPointer head, Context context, PrintStream out) {
        try {
            for (UtComponentDataPointer current = head; current != null && current.notNull(); current = current.next()) {
                UtModuleInfoPointer modInfo = current.moduleInfo();
                visitor.visit(modInfo);
            }
        }
        catch (CorruptDataException e) {
            e.printStackTrace();
        }
    }

    public static interface ModuleVisitor {
        public void visit(UtModuleInfoPointer var1) throws CorruptDataException;
    }
}

