/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29_00.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.tools.ddrinteractive.Table;
import com.ibm.j9ddr.vm29_00.j9.J9ObjectFieldOffset;
import com.ibm.j9ddr.vm29_00.j9.J9ObjectFieldOffsetIterator;
import com.ibm.j9ddr.vm29_00.j9.ObjectFieldInfo;
import com.ibm.j9ddr.vm29_00.j9.ObjectModel;
import com.ibm.j9ddr.vm29_00.j9.gc.GCHeapRegionDescriptor;
import com.ibm.j9ddr.vm29_00.j9.gc.GCHeapRegionIterator;
import com.ibm.j9ddr.vm29_00.j9.gc.GCObjectHeapIterator;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9ROMFieldShapePointer;
import com.ibm.j9ddr.vm29_00.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm29_00.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm29_00.structure.J9Consts;
import com.ibm.j9ddr.vm29_00.structure.J9FieldFlags;
import com.ibm.j9ddr.vm29_00.structure.J9ROMFieldOffsetWalkState;
import com.ibm.j9ddr.vm29_00.types.U32;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;

public class ObjectSizeInfo
extends Command {
    private static final String nl = System.getProperty("line.separator");
    private static final String DATA_SIZE = "Data size";
    private static final String TOTAL_SIZE = "Total size";
    private static final String SPACE_USED = "Space used";
    private String className = null;
    private PrintStream out;
    TreeMap<String, ClassFieldInfo> fieldStats;
    private boolean includeArrays;

    public ObjectSizeInfo() {
        this.addCommand("objectsizeinfo", "[-a] [class name]", "Print information about object fields and size of the objects, including unused space");
        this.includeArrays = true;
    }

    private void printHelp(PrintStream out) {
        CommandUtils.dbgPrint(out, "!objectsizeinfo [-a] [classname]   -- Dump the information about objects of type <classname>.\nIf no name is given, all classes are displayed. \nTotal size includes the header, all instance and hidden fields, including unused space for sub-32-bit fields\nData size includes only the header plus instance and hidden fields\nSpace used is the total space used for objects including padding for minimum size and alignment\n'*' indicates that the size is less than the GC minimum object size.\n-a: suppress inclusion of array classes\n");
    }

    private boolean parseArgs(PrintStream out, String[] args) throws DDRInteractiveCommandException {
        this.className = null;
        this.includeArrays = true;
        if (args.length > 2) {
            out.append("Invalid number of argments" + nl);
            return false;
        }
        for (String a : args) {
            if (a.equals("help")) {
                this.printHelp(out);
                return false;
            }
            if (a.equals("-a")) {
                this.includeArrays = false;
                continue;
            }
            if (!a.startsWith("-")) {
                this.className = a;
                continue;
            }
            out.append("Invalid argment: " + a);
        }
        return true;
    }

    @Override
    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        this.out = out;
        this.fieldStats = new TreeMap();
        Table summary = new Table("Object field size summary");
        summary.row(ClassFieldInfo.getTitleRow());
        HeapFieldInfo hfi = new HeapFieldInfo();
        if (args != null && !this.parseArgs(out, args)) {
            return;
        }
        try {
            this.scanHeap();
            for (FieldInfo fieldInfo : this.fieldStats.values()) {
                summary.row(fieldInfo.getResults());
                hfi.addClass(fieldInfo);
            }
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
        summary.row(FieldInfo.getTitleRow());
        try {
            summary.row(hfi.getResults());
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
        summary.render(out);
    }

    private void scanHeap() {
        try {
            GCHeapRegionIterator regions = GCHeapRegionIterator.from();
            while (regions.hasNext()) {
                GCHeapRegionDescriptor region = regions.next();
                this.scanObjects(region);
            }
        }
        catch (CorruptDataException e) {
            e.printStackTrace();
        }
    }

    private void scanObjects(GCHeapRegionDescriptor region) throws CorruptDataException {
        GCObjectHeapIterator heapIterator = GCObjectHeapIterator.fromHeapRegionDescriptor(region, true, true);
        while (heapIterator.hasNext()) {
            J9ObjectPointer object = heapIterator.next();
            J9ClassPointer objClass = J9ObjectHelper.clazz(object);
            if (objClass.isNull() || J9ClassHelper.isArrayClass(objClass) && !this.includeArrays) continue;
            String objClassString = J9ClassHelper.getJavaName(objClass);
            if (null != this.className && !this.className.equals(objClassString)) continue;
            ClassFieldInfo cfInfo = this.fieldStats.get(objClassString);
            if (null == cfInfo) {
                cfInfo = new ClassFieldInfo(objClass);
                this.fieldStats.put(objClassString, cfInfo);
            }
            cfInfo.addInstance(object);
        }
    }

    static class HeapFieldInfo
    extends FieldInfo {
        public HeapFieldInfo() {
            this.objectClassString = "Heap summary";
        }

        public void addClass(FieldInfo cfi) {
            this.instanceCount += cfi.instanceCount;
            this.charCount += cfi.charCount * cfi.instanceCount;
            this.byteCount += cfi.byteCount * cfi.instanceCount;
            this.shortCount += cfi.shortCount * cfi.instanceCount;
            this.intCount += cfi.intCount * cfi.instanceCount;
            this.longCount += cfi.longCount * cfi.instanceCount;
            this.floatCount += cfi.floatCount * cfi.instanceCount;
            this.doubleCount += cfi.doubleCount * cfi.instanceCount;
            this.boolCount += cfi.boolCount * cfi.instanceCount;
            this.objectCount += cfi.objectCount * cfi.instanceCount;
            this.hiddenFields += cfi.hiddenFields * cfi.instanceCount;
            this.totalInstanceSize += cfi.totalInstanceSize * (long)cfi.instanceCount;
            this.bytesContainingData += cfi.bytesContainingData * (long)cfi.instanceCount;
            this.spaceUsed += cfi.spaceUsed;
        }
    }

    static class ClassFieldInfo
    extends FieldInfo {
        private J9ClassPointer objectClass;

        public int getInstanceCount() {
            return this.instanceCount;
        }

        public String getObjectClassString() {
            return this.objectClassString;
        }

        public ClassFieldInfo(J9ClassPointer objClass) throws CorruptDataException {
            this.objectClass = objClass;
            this.instanceCount = 0;
            this.objectClassString = J9ClassHelper.getJavaName(objClass);
            this.isArray = false;
            if (!J9ClassHelper.isArrayClass(objClass)) {
                U32 flags = new U32(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_INCLUDE_INSTANCE | J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_INCLUDE_HIDDEN);
                J9ClassPointer superclass = J9ClassHelper.superclass(objClass);
                this.totalInstanceSize = objClass.totalInstanceSize().longValue() + (long)ObjectFieldInfo.fj9object_t_SizeOf;
                Iterator<J9ObjectFieldOffset> fieldIter = J9ObjectFieldOffsetIterator.J9ObjectFieldOffsetIteratorFor(objClass.romClass(), objClass, superclass, flags);
                while (fieldIter.hasNext()) {
                    J9ObjectFieldOffset fo = fieldIter.next();
                    if (fo.isStatic()) continue;
                    J9ROMFieldShapePointer f = fo.getField();
                    U32 mods = f.modifiers();
                    if (mods.anyBitsIn(J9FieldFlags.J9FieldTypeByte)) {
                        ++this.byteCount;
                    } else if (mods.anyBitsIn(J9FieldFlags.J9FieldTypeShort)) {
                        ++this.shortCount;
                    } else if (mods.anyBitsIn(J9FieldFlags.J9FieldTypeInt)) {
                        ++this.intCount;
                    } else if (mods.anyBitsIn(J9FieldFlags.J9FieldTypeLong)) {
                        ++this.longCount;
                    } else if (mods.anyBitsIn(J9FieldFlags.J9FieldTypeFloat)) {
                        ++this.floatCount;
                    } else if (mods.anyBitsIn(J9FieldFlags.J9FieldTypeDouble)) {
                        ++this.doubleCount;
                    } else if (mods.anyBitsIn(J9FieldFlags.J9FieldTypeBoolean)) {
                        ++this.boolCount;
                    } else if (mods.anyBitsIn(J9FieldFlags.J9FieldFlagObject)) {
                        ++this.objectCount;
                    } else {
                        ++this.charCount;
                    }
                    if (!fo.isHidden()) continue;
                    ++this.hiddenFields;
                }
                this.bytesContainingData = this.calculateBytesContainingData() + (long)ObjectFieldInfo.fj9object_t_SizeOf;
            } else {
                this.bytesContainingData = 0L;
                this.isArray = true;
            }
        }

        private long calculateBytesContainingData() throws CorruptDataException {
            J9ClassPointer superclass = J9ClassHelper.superclass(this.objectClass);
            long accum = 0L;
            if (!superclass.isNull()) {
                accum = superclass.totalInstanceSize().intValue();
                if (superclass.backfillOffset().gt(0)) {
                    accum -= 4L;
                }
            }
            accum += (long)((this.charCount + this.byteCount + this.boolCount) * 1);
            accum += (long)(this.shortCount * 2);
            accum += (long)((this.intCount + this.floatCount) * 4);
            accum += (long)((this.longCount + this.doubleCount) * 8);
            return accum += (long)(this.objectCount * ObjectFieldInfo.fj9object_t_SizeOf);
        }

        public void addInstance(J9ObjectPointer object) throws CorruptDataException {
            ++this.instanceCount;
            this.spaceUsed += ObjectModel.getConsumedSizeInBytesWithHeader(object).longValue();
        }
    }

    static abstract class FieldInfo {
        protected int instanceCount;
        protected int charCount = 0;
        protected int byteCount = 0;
        protected int shortCount = 0;
        protected int intCount = 0;
        protected int longCount = 0;
        protected int floatCount = 0;
        protected int doubleCount = 0;
        protected int boolCount = 0;
        protected int objectCount = 0;
        protected int hiddenFields = 0;
        protected long spaceUsed = 0L;
        protected long totalInstanceSize;
        protected String objectClassString;
        protected long bytesContainingData;
        protected boolean isArray;

        public static String[] getTitleRow() {
            return new String[]{"Class", ObjectSizeInfo.TOTAL_SIZE, ObjectSizeInfo.DATA_SIZE, ObjectSizeInfo.SPACE_USED, "Instances", "char", "byte", "short", "int", "long", "float", "double", "boolean", "object", "hidden"};
        }

        public String[] getResults() throws CorruptDataException {
            ArrayList<String> results = new ArrayList<String>(16);
            results.add(this.objectClassString);
            String totSizeString = "N/A";
            String minSizeString = "N/A";
            if (!this.isArray) {
                totSizeString = Long.toString(this.totalInstanceSize);
                if (this.totalInstanceSize < J9Consts.J9_GC_MINIMUM_OBJECT_SIZE) {
                    totSizeString = totSizeString + '*';
                }
                minSizeString = Long.toString(this.bytesContainingData);
                if (this.bytesContainingData < J9Consts.J9_GC_MINIMUM_OBJECT_SIZE) {
                    minSizeString = minSizeString + '*';
                }
            }
            results.add(totSizeString);
            results.add(minSizeString);
            results.add(Long.toString(this.spaceUsed));
            results.add(Integer.toString(this.instanceCount));
            results.add(Integer.toString(this.charCount));
            results.add(Integer.toString(this.byteCount));
            results.add(Integer.toString(this.shortCount));
            results.add(Integer.toString(this.intCount));
            results.add(Integer.toString(this.longCount));
            results.add(Integer.toString(this.floatCount));
            results.add(Integer.toString(this.doubleCount));
            results.add(Integer.toString(this.boolCount));
            results.add(Integer.toString(this.objectCount));
            results.add(Integer.toString(this.hiddenFields));
            return results.toArray(new String[results.size()]);
        }
    }
}

