/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29_00.pointer.helper;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29_00.j9.ConstantPoolHelpers;
import com.ibm.j9ddr.vm29_00.j9.ROMHelp;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9ConstantPoolPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9MethodPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9ROMMethodPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9ROMNameAndSignaturePointer;
import com.ibm.j9ddr.vm29_00.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm29_00.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm29_00.structure.J9ROMMethod;

public class J9MethodHelper {
    public static J9ROMMethodPointer romMethod(J9MethodPointer methodPointer) throws CorruptDataException {
        return J9ROMMethodPointer.cast(methodPointer.bytecodes().addOffset(-J9ROMMethod.SIZEOF));
    }

    public static String getName(J9MethodPointer methodPointer) throws CorruptDataException {
        if (methodPointer.isNull()) {
            return "bad ramMethod";
        }
        J9ConstantPoolPointer constantPool = ConstantPoolHelpers.J9_CP_FROM_METHOD(methodPointer);
        if (constantPool.isNull()) {
            return "error reading constant pool from ramMethod";
        }
        J9ClassPointer className = ConstantPoolHelpers.J9_CLASS_FROM_CP(constantPool);
        if (className.isNull()) {
            return "error reading class name from constant pool";
        }
        J9ROMNameAndSignaturePointer nameAndSignature = ROMHelp.J9_ROM_METHOD_FROM_RAM_METHOD(methodPointer).nameAndSignature();
        String name = J9UTF8Helper.stringValue(nameAndSignature.name());
        String signature = J9UTF8Helper.stringValue(nameAndSignature.signature());
        return J9ClassHelper.getName(className) + "." + name + signature;
    }
}

