/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29_00.pointer;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29_00.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29_00.pointer.Pointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29_00.types.Scalar;
import com.ibm.j9ddr.vm29_00.types.UDATA;

public class ObjectClassReferencePointer
extends Pointer {
    public static final ObjectClassReferencePointer NULL = new ObjectClassReferencePointer(0L);
    public static final long SIZEOF = J9BuildFlags.interp_compressedObjectHeader ? 4L : (long)UDATA.SIZEOF;

    protected ObjectClassReferencePointer(long address) {
        super(address);
    }

    public static ObjectClassReferencePointer cast(AbstractPointer pointer) {
        return ObjectClassReferencePointer.cast(pointer.getAddress());
    }

    public static ObjectClassReferencePointer cast(UDATA udata) {
        return ObjectClassReferencePointer.cast(udata.longValue());
    }

    public static ObjectClassReferencePointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new ObjectClassReferencePointer(address);
    }

    @Override
    public ObjectClassReferencePointer add(long count) {
        return new ObjectClassReferencePointer(this.address + SIZEOF * count);
    }

    @Override
    public ObjectClassReferencePointer add(Scalar count) {
        return this.add(count.longValue());
    }

    @Override
    public ObjectClassReferencePointer addOffset(long offset) {
        return new ObjectClassReferencePointer(this.address + offset);
    }

    @Override
    public ObjectClassReferencePointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    @Override
    public J9ClassPointer at(long index) throws CorruptDataException {
        if (J9BuildFlags.interp_compressedObjectHeader) {
            return J9ClassPointer.cast(0xFFFFFFFFL & (long)this.getIntAtOffset(index * SIZEOF));
        }
        return J9ClassPointer.cast(this.getUDATAAtOffset(SIZEOF * index));
    }

    @Override
    public J9ClassPointer at(Scalar index) throws CorruptDataException {
        return this.at(index.longValue());
    }

    @Override
    protected long sizeOfBaseType() {
        return SIZEOF;
    }

    @Override
    public ObjectClassReferencePointer sub(long count) {
        return new ObjectClassReferencePointer(this.address - SIZEOF * count);
    }

    @Override
    public ObjectClassReferencePointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    @Override
    public ObjectClassReferencePointer subOffset(long offset) {
        return new ObjectClassReferencePointer(this.address - offset);
    }

    @Override
    public ObjectClassReferencePointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    @Override
    public ObjectClassReferencePointer untag(long tagBits) {
        return new ObjectClassReferencePointer(this.address & (tagBits ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public ObjectClassReferencePointer untag() {
        return this.untag(SIZEOF - 1L);
    }
}

