/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.InvalidDataTypeException;
import com.ibm.j9ddr.vm29.j9.J9ObjectFieldOffset;
import com.ibm.j9ddr.vm29.j9.J9ObjectFieldOffsetIterator;
import com.ibm.j9ddr.vm29.j9.ObjectAccessBarrier;
import com.ibm.j9ddr.vm29.j9.ObjectModel;
import com.ibm.j9ddr.vm29.j9.gc.GCClassIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCClassIteratorClassSlots;
import com.ibm.j9ddr.vm29.j9.gc.GCExtensions;
import com.ibm.j9ddr.vm29.j9.gc.GCHeapLinkedFreeHeader;
import com.ibm.j9ddr.vm29.j9.gc.GCHeapRegionDescriptor;
import com.ibm.j9ddr.vm29.j9.gc.GCHeapRegionManager;
import com.ibm.j9ddr.vm29.j9.gc.GCObjectIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCScavengerForwardedHeader;
import com.ibm.j9ddr.vm29.j9.gc.GCVMThreadListIterator;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.ObjectReferencePointer;
import com.ibm.j9ddr.vm29.pointer.PointerPointer;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9IndexableObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaStackPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MemorySegmentPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_GCExtensionsPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_HeapRegionManagerPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_OwnableSynchronizerObjectListPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_SublistPuddlePointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_UnfinalizedObjectListPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9IndexableObjectHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm29.structure.J9Class;
import com.ibm.j9ddr.vm29.structure.J9JavaAccessFlags;
import com.ibm.j9ddr.vm29.structure.J9JavaClassFlags;
import com.ibm.j9ddr.vm29.structure.J9MemorySegment;
import com.ibm.j9ddr.vm29.structure.J9Object;
import com.ibm.j9ddr.vm29.structure.J9ROMFieldOffsetWalkState;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.Check;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.CheckBase;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.CheckCycle;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.CheckElement;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.CheckError;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.CheckReporter;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.SegmentTree;
import com.ibm.j9ddr.vm29.types.IDATA;
import com.ibm.j9ddr.vm29.types.U32;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.util.Arrays;
import java.util.Iterator;

class CheckEngine {
    private J9JavaVMPointer _javaVM;
    private CheckReporter _reporter;
    private CheckCycle _cycle;
    private Check _currentCheck;
    private CheckElement _lastHeapObject1 = new CheckElement();
    private CheckElement _lastHeapObject2 = new CheckElement();
    private CheckElement _lastHeapObject3 = new CheckElement();
    private SegmentTree _classSegmentsTree;
    private static final int CLASS_CACHE_SIZE = 19;
    private J9ClassPointer[] _checkedClassCache = new J9ClassPointer[19];
    private J9ClassPointer[] _checkedClassCacheAllowUndead = new J9ClassPointer[19];
    private static final int OBJECT_CACHE_SIZE = 61;
    private J9ObjectPointer[] _checkedObjectCache = new J9ObjectPointer[61];
    private static final int UNINITIALIZED_SIZE = -1;
    private int _ownableSynchronizerObjectCountOnList = -1;
    private int _ownableSynchronizerObjectCountOnHeap = -1;
    private boolean _needVerifyOwnableSynchronizerConsistency;
    private boolean _isVirtualLargeObjectHeapEnabled;
    private GCHeapRegionManager _hrm;

    public CheckEngine(J9JavaVMPointer vm, CheckReporter reporter) throws CorruptDataException {
        this._javaVM = vm;
        this._reporter = reporter;
        MM_GCExtensionsPointer extensions = MM_GCExtensionsPointer.cast(this._javaVM.gcExtensions());
        try {
            this._isVirtualLargeObjectHeapEnabled = extensions.isVirtualLargeObjectHeapEnabled();
        }
        catch (NoSuchFieldException e) {
            this._isVirtualLargeObjectHeapEnabled = false;
        }
        MM_HeapRegionManagerPointer hrmPtr = extensions.heapRegionManager();
        this._hrm = GCHeapRegionManager.fromHeapRegionManager(hrmPtr);
    }

    public J9JavaVMPointer getJavaVM() {
        return this._javaVM;
    }

    public CheckReporter getReporter() {
        return this._reporter;
    }

    public void clearPreviousObjects() {
        this._lastHeapObject1.setNone();
        this._lastHeapObject2.setNone();
        this._lastHeapObject3.setNone();
    }

    public void pushPreviousObject(J9ObjectPointer object) {
        this._lastHeapObject3.copyFrom(this._lastHeapObject2);
        this._lastHeapObject2.copyFrom(this._lastHeapObject1);
        this._lastHeapObject1.setObject(object);
    }

    public void pushPreviousClass(J9ClassPointer clazz) {
        this._lastHeapObject3.copyFrom(this._lastHeapObject2);
        this._lastHeapObject2.copyFrom(this._lastHeapObject1);
        this._lastHeapObject1.setClazz(clazz);
    }

    public boolean isMidscavengeFlagSet() {
        return (this._cycle.getMiscFlags() & 0x10000) != 0;
    }

    public boolean isIndexableDataAddressFlagSet() {
        return (this._cycle.getMiscFlags() & 0x40000) != 0;
    }

    public boolean isScavengerBackoutFlagSet() {
        return (this._cycle.getMiscFlags() & 0x20) != 0;
    }

    public void reportForwardedObject(J9ObjectPointer object, J9ObjectPointer forwardedObject) {
        if ((this._cycle.getMiscFlags() & 1) != 0) {
            this._reporter.reportForwardedObject(object, forwardedObject);
        }
    }

    public int checkObjectHeap(J9ObjectPointer object, GCHeapRegionDescriptor regionDesc) {
        int result = 0;
        boolean isDead = false;
        boolean isIndexable = false;
        J9ClassPointer clazz = null;
        try {
            if (ObjectModel.isHoleObject(object)) {
                result = this.checkJ9LinkedFreeHeader(GCHeapLinkedFreeHeader.fromJ9Object(object), regionDesc, this._cycle.getCheckFlags());
                if (0 != result) {
                    CheckError error = new CheckError(object, this._cycle, this._currentCheck, "Object", result, this._cycle.nextErrorCount());
                    this._reporter.report(error);
                    if (45 != result && 46 != result && 47 != result) {
                        this._reporter.reportHeapWalkError(error, this._lastHeapObject1, this._lastHeapObject2, this._lastHeapObject3);
                        return 1;
                    }
                }
                return 0;
            }
        }
        catch (CorruptDataException e) {
            CheckError error = new CheckError(object, this._cycle, this._currentCheck, "Object ", Integer.MAX_VALUE, this._cycle.nextErrorCount());
            this._reporter.report(error);
            return 1;
        }
        try {
            isIndexable = ObjectModel.isIndexable(object);
            clazz = J9ObjectHelper.clazz(object);
            result = this.checkJ9Object(object, regionDesc, this._cycle.getCheckFlags());
        }
        catch (CorruptDataException cde) {
            CheckError error = new CheckError(object, this._cycle, this._currentCheck, "Object ", Integer.MAX_VALUE, this._cycle.nextErrorCount());
            this._reporter.report(error);
            return 1;
        }
        if (0 != result) {
            String elementName = isIndexable ? "IObject " : "Object ";
            CheckError error = new CheckError(object, this._cycle, this._currentCheck, elementName, result, this._cycle.nextErrorCount());
            this._reporter.report(error);
            if (48 != result) {
                this._reporter.reportHeapWalkError(error, this._lastHeapObject1, this._lastHeapObject2, this._lastHeapObject3);
                return 1;
            }
            return 0;
        }
        try {
            if (this.needVerifyOwnableSynchronizerConsistency() && J9Object.OBJECT_HEADER_SHAPE_MIXED == (long)ObjectModel.getClassShape(clazz).intValue() && !J9ClassHelper.classFlags(clazz).bitAnd(J9JavaAccessFlags.J9AccClassOwnableSynchronizer).eq(0L)) {
                if (ObjectAccessBarrier.isObjectInOwnableSynchronizerList(object).isNull()) {
                    CheckError error = new CheckError(object, this._cycle, this._currentCheck, "Object ", 42, this._cycle.nextErrorCount());
                    this._reporter.report(error);
                } else {
                    ++this._ownableSynchronizerObjectCountOnHeap;
                }
            }
        }
        catch (CorruptDataException cde) {
            CheckError error = new CheckError(object, this._cycle, this._currentCheck, "Object ", Integer.MAX_VALUE, this._cycle.nextErrorCount());
            this._reporter.report(error);
            return 1;
        }
        if (0 == result) {
            VoidPointer address;
            J9ObjectPointer field;
            GCObjectIterator addressIterator;
            GCObjectIterator fieldIterator;
            try {
                fieldIterator = GCObjectIterator.fromJ9Object(object, true);
                addressIterator = GCObjectIterator.fromJ9Object(object, true);
            }
            catch (CorruptDataException e) {
                CheckError error = new CheckError(object, this._cycle, this._currentCheck, "Object ", Integer.MAX_VALUE, this._cycle.nextErrorCount());
                this._reporter.report(error);
                return 1;
            }
            while (fieldIterator.hasNext() && 0 == (result = this.checkSlotObjectHeap(field = fieldIterator.next(), ObjectReferencePointer.cast(address = addressIterator.nextAddress()), regionDesc, object))) {
            }
        }
        if (0 == result) {
            int cacheIndex = (int)(object.getAddress() % 61L);
            this._checkedObjectCache[cacheIndex] = object;
        }
        return result;
    }

    public int checkSlotObjectHeap(J9ObjectPointer object, ObjectReferencePointer objectIndirect, GCHeapRegionDescriptor regionDesc, J9ObjectPointer objectIndirectBase) {
        if (object.isNull()) {
            return 0;
        }
        int result = this.checkObjectIndirect(object);
        if ((this._cycle.getMiscFlags() & 0x8000) != 0) {
            switch (result) {
                case 0: 
                case 1: 
                case 6: {
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    return 0;
                }
            }
        }
        boolean isIndexable = false;
        boolean scavengerEnabled = false;
        try {
            isIndexable = ObjectModel.isIndexable(objectIndirectBase);
            scavengerEnabled = GCExtensions.scavengerEnabled();
        }
        catch (CorruptDataException e) {
            CheckError error = new CheckError(object, this._cycle, this._currentCheck, "Object ", Integer.MAX_VALUE, this._cycle.nextErrorCount());
            this._reporter.report(error);
            return 1;
        }
        if (0 != result) {
            String elementName = isIndexable ? "IObject " : "Object ";
            CheckError error = new CheckError(objectIndirectBase, objectIndirect, this._cycle, this._currentCheck, elementName, result, this._cycle.nextErrorCount());
            this._reporter.report(error);
            return 0;
        }
        if (J9BuildFlags.J9VM_GC_GENERATIONAL && scavengerEnabled) {
            GCHeapRegionDescriptor objectRegion = ObjectModel.findRegionForPointer(this._javaVM, this._hrm, object, regionDesc);
            if (objectRegion == null) {
                return 4;
            }
            if (object.notNull()) {
                boolean isOld;
                boolean isRemembered;
                UDATA objectRegionType;
                UDATA regionType;
                try {
                    regionType = regionDesc.getTypeFlags();
                    objectRegionType = objectRegion.getTypeFlags();
                    isRemembered = ObjectModel.isRemembered(objectIndirectBase);
                    isOld = ObjectModel.isOld(object);
                }
                catch (CorruptDataException e) {
                    CheckError error = new CheckError(objectIndirectBase, this._cycle, this._currentCheck, "Object ", Integer.MAX_VALUE, this._cycle.nextErrorCount());
                    this._reporter.report(error);
                    return 1;
                }
                if (regionType.allBitsIn(J9MemorySegment.MEMORY_TYPE_OLD) && objectRegionType.allBitsIn(J9MemorySegment.MEMORY_TYPE_NEW) && !isRemembered) {
                    String elementName = isIndexable ? "IObject " : "Object ";
                    CheckError error = new CheckError(objectIndirectBase, objectIndirect, this._cycle, this._currentCheck, elementName, 17, this._cycle.nextErrorCount());
                    this._reporter.report(error);
                    return 0;
                }
                if (regionType.allBitsIn(J9MemorySegment.MEMORY_TYPE_OLD) && !isOld && !isRemembered) {
                    String elementName = isIndexable ? "IObject " : "Object ";
                    CheckError error = new CheckError(objectIndirectBase, objectIndirect, this._cycle, this._currentCheck, elementName, 20, this._cycle.nextErrorCount());
                    this._reporter.report(error);
                    return 0;
                }
            }
        }
        return 0;
    }

    private int checkObjectIndirect(J9ObjectPointer object) {
        int result;
        if (object.isNull()) {
            return 0;
        }
        int cacheIndex = (int)Math.abs(object.getAddress() % 61L);
        if (this._checkedObjectCache[cacheIndex] == object) {
            return 0;
        }
        J9ObjectPointer[] newObject = new J9ObjectPointer[]{J9ObjectPointer.NULL};
        GCHeapRegionDescriptor[] objectRegion = new GCHeapRegionDescriptor[1];
        try {
            result = this.checkJ9ObjectPointer(object, newObject, objectRegion);
            if (0 == result) {
                result = this.checkJ9Object(newObject[0], objectRegion[0], this._cycle.getCheckFlags());
            }
        }
        catch (CorruptDataException e) {
            result = Integer.MAX_VALUE;
        }
        if (0 == result) {
            this._checkedObjectCache[cacheIndex] = object;
        }
        return result;
    }

    private int checkJ9ObjectPointer(J9ObjectPointer object, J9ObjectPointer[] newObject, GCHeapRegionDescriptor[] regionDesc) throws CorruptDataException {
        GCScavengerForwardedHeader scavengerForwardedHeader;
        newObject[0] = object;
        if (object.isNull()) {
            return 0;
        }
        regionDesc[0] = ObjectModel.findRegionForPointer(this._javaVM, this._hrm, object, regionDesc[0]);
        if (regionDesc[0] == null) {
            GCVMThreadListIterator threadListIterator = GCVMThreadListIterator.from();
            while (threadListIterator.hasNext()) {
                J9VMThreadPointer vmThread = threadListIterator.next();
                if (!this.isObjectOnStack(object, vmThread.stackObject())) continue;
                return 6;
            }
            UDATA classSlot = J9ObjectHelper.rawClazz(object);
            if (classSlot.eq(0x99669966L)) {
                return 41;
            }
            return 4;
        }
        if (!regionDesc[0].containsObjects()) {
            return 3;
        }
        if (object.anyBitsIn(CheckBase.J9MODRON_GCCHK_J9OBJECT_ALIGNMENT_MASK)) {
            return 1;
        }
        if (this.isMidscavengeFlagSet() && (GCExtensions.isVLHGC() || regionDesc[0].getTypeFlags().allBitsIn(J9MemorySegment.MEMORY_TYPE_NEW)) && (scavengerForwardedHeader = GCScavengerForwardedHeader.fromJ9Object(object)).isForwardedPointer()) {
            newObject[0] = scavengerForwardedHeader.getForwardedObject();
            this.reportForwardedObject(object, newObject[0]);
            object = newObject[0];
            regionDesc[0] = ObjectModel.findRegionForPointer(this._javaVM, this._hrm, object, regionDesc[0]);
            if (regionDesc[0] == null) {
                GCVMThreadListIterator threadListIterator = GCVMThreadListIterator.from();
                while (threadListIterator.hasNext()) {
                    J9VMThreadPointer vmThread = threadListIterator.next();
                    if (!this.isObjectOnStack(object, vmThread.stackObject())) continue;
                    return 6;
                }
                return 4;
            }
            if (!regionDesc[0].containsObjects()) {
                return 3;
            }
            if (object.anyBitsIn(CheckBase.J9MODRON_GCCHK_J9OBJECT_ALIGNMENT_MASK)) {
                return 1;
            }
        }
        if (this.isScavengerBackoutFlagSet() && (scavengerForwardedHeader = GCScavengerForwardedHeader.fromJ9Object(object)).isReverseForwardedPointer()) {
            newObject[0] = scavengerForwardedHeader.getReverseForwardedPointer();
            this.reportForwardedObject(object, newObject[0]);
            object = newObject[0];
            regionDesc[0] = ObjectModel.findRegionForPointer(this._javaVM, this._hrm, object, regionDesc[0]);
            if (regionDesc[0] == null) {
                return 4;
            }
            if (!regionDesc[0].containsObjects()) {
                return 3;
            }
            if (!regionDesc[0].getTypeFlags().allBitsIn(J9MemorySegment.MEMORY_TYPE_NEW)) {
                return 49;
            }
            if (object.anyBitsIn(CheckBase.J9MODRON_GCCHK_J9OBJECT_ALIGNMENT_MASK)) {
                return 1;
            }
        }
        long classShape = -1L;
        try {
            classShape = ObjectModel.getClassShape(J9ObjectHelper.clazz(object)).longValue();
        }
        catch (CorruptDataException vmThread) {
            // empty catch block
        }
        if (classShape == J9Object.OBJECT_HEADER_SHAPE_DOUBLES) {
            J9IndexableObjectPointer array = J9IndexableObjectPointer.cast(object);
            int size = 0;
            VoidPointer elementPtr = VoidPointer.NULL;
            try {
                size = ObjectModel.getSizeInElements(object).intValue();
            }
            catch (InvalidDataTypeException invalidDataTypeException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (0 != size) {
                elementPtr = ObjectModel.getElementAddress(array, 0, 8);
                if (elementPtr.anyBitsIn(7L)) {
                    return 2;
                }
                elementPtr = ObjectModel.getElementAddress(array, size - 1, 8);
                if (elementPtr.anyBitsIn(7L)) {
                    return 2;
                }
            }
        }
        return 0;
    }

    public int checkSlot(PointerPointer objectIndirect, VoidPointer objectIndirectBase, int objectType) {
        try {
            J9ObjectPointer object = J9ObjectPointer.cast(objectIndirect.at(0L));
            int result = this.checkObjectIndirect(object);
            if (0 != result) {
                CheckError error = new CheckError(objectIndirectBase, objectIndirect, this._cycle, this._currentCheck, result, this._cycle.nextErrorCount(), objectType);
                this._reporter.report(error);
            }
        }
        catch (CorruptDataException e) {
            CheckError error = new CheckError(objectIndirectBase, objectIndirect, this._cycle, this._currentCheck, Integer.MAX_VALUE, this._cycle.nextErrorCount(), objectType);
            this._reporter.report(error);
        }
        return 0;
    }

    public int checkSlotVMThread(PointerPointer objectIndirect, VoidPointer objectIndirectBase, int objectType, int iteratorState) {
        try {
            J9ObjectPointer object = J9ObjectPointer.cast(objectIndirect.at(0L));
            int result = this.checkObjectIndirect(object);
            if (3 == iteratorState && 6 == result) {
                result = this.checkStackObject(object);
            }
            if (0 != result) {
                CheckError error = new CheckError(objectIndirectBase, objectIndirect, this._cycle, this._currentCheck, result, this._cycle.nextErrorCount(), objectType);
                this._reporter.report(error);
            }
        }
        catch (CorruptDataException e) {
            CheckError error = new CheckError(objectIndirectBase, objectIndirect, this._cycle, this._currentCheck, Integer.MAX_VALUE, this._cycle.nextErrorCount(), objectType);
            this._reporter.report(error);
        }
        return 0;
    }

    public int checkSlotStack(PointerPointer objectIndirect, J9VMThreadPointer vmThread, VoidPointer stackLocation) {
        try {
            J9ObjectPointer object = J9ObjectPointer.cast(objectIndirect.at(0L));
            int result = this.checkObjectIndirect(object);
            if (6 == result) {
                result = this.checkStackObject(object);
            }
            if (0 != result) {
                CheckError error = new CheckError(vmThread, objectIndirect, stackLocation, this._cycle, this._currentCheck, result, this._cycle.nextErrorCount());
                this._reporter.report(error);
                return 2;
            }
        }
        catch (CorruptDataException e) {
            CheckError error = new CheckError(vmThread, objectIndirect, stackLocation, this._cycle, this._currentCheck, Integer.MAX_VALUE, this._cycle.nextErrorCount());
            this._reporter.report(error);
            return 2;
        }
        return 0;
    }

    private int checkStackObject(J9ObjectPointer object) {
        if (object.isNull()) {
            return 0;
        }
        if (object.anyBitsIn(CheckBase.J9MODRON_GCCHK_ONSTACK_ALIGNMENT_MASK)) {
            return 1;
        }
        if ((this._cycle.getCheckFlags() & 1) != 0) {
            try {
                int ret = this.checkJ9ClassPointer(J9ObjectHelper.clazz(object));
                if (0 != ret) {
                    return ret;
                }
            }
            catch (CorruptDataException e) {
                return Integer.MAX_VALUE;
            }
        }
        if ((this._cycle.getCheckFlags() & 8) != 0) {
            try {
                if (!this.checkIndexableFlag(object)) {
                    return 13;
                }
            }
            catch (CorruptDataException e) {
                return Integer.MAX_VALUE;
            }
        }
        return 0;
    }

    public int checkSlotRememberedSet(PointerPointer objectIndirect, MM_SublistPuddlePointer puddle) {
        try {
            int result;
            J9ObjectPointer object = J9ObjectPointer.cast(objectIndirect.at(0L));
            if (this.isMidscavengeFlagSet() && object.anyBitsIn(1L)) {
                object = object.untag(1L);
            }
            if (0 != (result = this.checkObjectIndirect(object))) {
                CheckError error = new CheckError(puddle, objectIndirect, this._cycle, this._currentCheck, result, this._cycle.nextErrorCount());
                this._reporter.report(error);
                return 0;
            }
            if (object.notNull()) {
                GCScavengerForwardedHeader scavengerForwardedHeader;
                GCHeapRegionDescriptor objectRegion = ObjectModel.findRegionForPointer(this._javaVM, this._hrm, object, null);
                if (objectRegion == null) {
                    CheckError error = new CheckError(puddle, objectIndirect, this._cycle, this._currentCheck, 4, this._cycle.nextErrorCount());
                    this._reporter.report(error);
                    return 0;
                }
                if (objectRegion.getTypeFlags().allBitsIn(J9MemorySegment.MEMORY_TYPE_NEW)) {
                    CheckError error = new CheckError(puddle, objectIndirect, this._cycle, this._currentCheck, 18, this._cycle.nextErrorCount());
                    this._reporter.report(error);
                    return 0;
                }
                boolean skipObject = false;
                if (this.isScavengerBackoutFlagSet() && (scavengerForwardedHeader = GCScavengerForwardedHeader.fromJ9Object(object)).isReverseForwardedPointer()) {
                    skipObject = true;
                }
                if (!(skipObject || ObjectModel.isOld(object) && ObjectModel.isRemembered(object))) {
                    CheckError error = new CheckError(puddle, objectIndirect, this._cycle, this._currentCheck, 19, this._cycle.nextErrorCount());
                    this._reporter.report(error);
                    this._reporter.reportObjectHeader(error, object, null);
                    return 0;
                }
            }
        }
        catch (CorruptDataException e) {
            CheckError error = new CheckError(puddle, objectIndirect, this._cycle, this._currentCheck, Integer.MAX_VALUE, this._cycle.nextErrorCount());
            this._reporter.report(error);
        }
        return 0;
    }

    public int checkSlotPool(PointerPointer objectIndirect, VoidPointer objectIndirectBase) {
        try {
            J9ObjectPointer object = J9ObjectPointer.cast(objectIndirect.at(0L));
            int result = this.checkObjectIndirect(object);
            if (0 != result) {
                CheckError error = new CheckError(objectIndirectBase, objectIndirect, this._cycle, this._currentCheck, result, this._cycle.nextErrorCount(), 0);
                this._reporter.report(error);
            }
        }
        catch (CorruptDataException e) {
            CheckError error = new CheckError(objectIndirectBase, objectIndirect, this._cycle, this._currentCheck, Integer.MAX_VALUE, this._cycle.nextErrorCount(), 0);
            this._reporter.report(error);
        }
        return 0;
    }

    public int checkClassHeap(J9ClassPointer clazz, J9MemorySegmentPointer segment) {
        try {
            int result = this.checkJ9Class(clazz, segment, this._cycle.getCheckFlags());
            if (0 != result) {
                CheckError error = new CheckError(clazz, this._cycle, this._currentCheck, "Class ", result, this._cycle.nextErrorCount());
                this._reporter.report(error);
            }
            GCClassIterator classIterator = GCClassIterator.fromJ9Class(clazz);
            while (classIterator.hasNext()) {
                PointerPointer slotPtr = PointerPointer.cast(classIterator.nextAddress());
                J9ObjectPointer object = J9ObjectPointer.cast(slotPtr.at(0L));
                result = this.checkObjectIndirect(object);
                if (0 != result) {
                    String elementName = "";
                    switch (classIterator.getState()) {
                        case 1: {
                            elementName = "static ";
                            break;
                        }
                        case 2: {
                            elementName = "constant ";
                            break;
                        }
                        case 3: {
                            elementName = "slots ";
                        }
                    }
                    CheckError error = new CheckError(clazz, slotPtr, this._cycle, this._currentCheck, elementName, result, this._cycle.nextErrorCount());
                    this._reporter.report(error);
                    return 0;
                }
                if (!GCExtensions.isStandardGC() || !object.notNull() || ObjectModel.isOld(object) || ObjectModel.isRemembered(clazz.classObject())) continue;
                CheckError error = new CheckError(clazz, slotPtr, this._cycle, this._currentCheck, "Class ", 20, this._cycle.nextErrorCount());
                this._reporter.report(error);
                return 0;
            }
            if (0 != this.checkClassStatics(clazz)) {
                return 0;
            }
            J9ClassPointer replaced = clazz.replacedClass();
            if (replaced.notNull() && !J9ClassHelper.isSwappedOut(replaced)) {
                CheckError error = new CheckError(clazz, clazz.replacedClassEA(), this._cycle, this._currentCheck, "Class ", 40, this._cycle.nextErrorCount());
                this._reporter.report(error);
                return 0;
            }
            GCClassIteratorClassSlots classIteratorClassSlots = GCClassIteratorClassSlots.fromJ9Class(clazz);
            while (classIteratorClassSlots.hasNext()) {
                PointerPointer classSlotPtr = PointerPointer.cast(classIteratorClassSlots.nextAddress());
                J9ClassPointer classSlot = J9ClassPointer.cast(classSlotPtr.at(0L));
                String elementName = "";
                result = 0;
                switch (classIteratorClassSlots.getState()) {
                    case 1: {
                        if (classSlot.notNull()) {
                            result = this.checkJ9ClassPointer(classSlot);
                        }
                        elementName = "constant ";
                        break;
                    }
                    case 2: {
                        result = this.checkJ9ClassPointer(classSlot);
                        elementName = "superclass ";
                        break;
                    }
                    case 3: {
                        result = this.checkJ9ClassPointer(classSlot);
                        elementName = "interface ";
                        break;
                    }
                    case 4: {
                        if (classSlot.notNull()) {
                            result = this.checkJ9ClassPointer(classSlot);
                        }
                        elementName = "array class ";
                    }
                }
                if (0 == result) continue;
                CheckError error = new CheckError(clazz, classSlotPtr, this._cycle, this._currentCheck, elementName, result, this._cycle.nextErrorCount());
                this._reporter.report(error);
                return 0;
            }
        }
        catch (CorruptDataException e) {
            CheckError error = new CheckError(clazz, this._cycle, this._currentCheck, "Class ", Integer.MAX_VALUE, this._cycle.nextErrorCount());
            this._reporter.report(error);
        }
        return 0;
    }

    private int checkClassStatics(J9ClassPointer clazz) {
        int result = 0;
        try {
            boolean validationRequired = true;
            if (J9ClassHelper.isSwappedOut(clazz)) {
                if (J9ClassHelper.isArrayClass(clazz)) {
                    result = 39;
                    CheckError error = new CheckError(clazz, this._cycle, this._currentCheck, "Class ", result, this._cycle.nextErrorCount());
                    this._reporter.report(error);
                    return result;
                }
                if (J9ClassHelper.areExtensionsEnabled() && clazz.ramStatics().isNull()) {
                    validationRequired = false;
                }
                try {
                    if (J9ClassHelper.extendedClassFlags(clazz).allBitsIn(J9JavaClassFlags.J9ClassReusedStatics)) {
                        validationRequired = false;
                    }
                }
                catch (NoSuchFieldError error) {
                    // empty catch block
                }
            }
            if (validationRequired) {
                J9ROMClassPointer romClazz = clazz.romClass();
                UDATA numberOfReferences = new UDATA(0L);
                PointerPointer sectionStart = PointerPointer.NULL;
                PointerPointer sectionEnd = PointerPointer.NULL;
                if (!romClazz.objectStaticCount().eq(0L)) {
                    sectionStart = PointerPointer.cast(clazz.ramStatics());
                    sectionEnd = sectionStart.add(romClazz.objectStaticCount());
                }
                Iterator<J9ObjectFieldOffset> objectFieldOffsetIterator = J9ObjectFieldOffsetIterator.J9ObjectFieldOffsetIteratorFor(clazz, J9ClassHelper.superclass(clazz), new U32(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_INCLUDE_STATIC | J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_ONLY_OBJECT_SLOTS));
                while (objectFieldOffsetIterator.hasNext()) {
                    J9ObjectFieldOffset fieldOffset = objectFieldOffsetIterator.next();
                    numberOfReferences = numberOfReferences.add(1L);
                    PointerPointer address = sectionStart.addOffset(fieldOffset.getOffsetOrAddress());
                    if (address.gte(sectionStart) && address.lt(sectionEnd)) continue;
                    result = 32;
                    CheckError error = new CheckError(clazz, address, this._cycle, this._currentCheck, "Class ", result, this._cycle.nextErrorCount());
                    this._reporter.report(error);
                }
                if (!numberOfReferences.eq(romClazz.objectStaticCount())) {
                    result = 33;
                    CheckError error = new CheckError(clazz, this._cycle, this._currentCheck, "Class ", result, this._cycle.nextErrorCount());
                    this._reporter.report(error);
                }
            }
        }
        catch (CorruptDataException e) {
            CheckError error = new CheckError(clazz, this._cycle, this._currentCheck, "Class ", Integer.MAX_VALUE, this._cycle.nextErrorCount());
            this._reporter.report(error);
        }
        return result;
    }

    private int checkJ9Class(J9ClassPointer clazz, J9MemorySegmentPointer segment, int checkFlags) throws CorruptDataException {
        UDATA delta;
        if (clazz.isNull()) {
            return 0;
        }
        if (clazz.anyBitsIn(CheckBase.J9MODRON_GCCHK_J9CLASS_ALIGNMENT_MASK)) {
            return 8;
        }
        int ret = this.checkJ9ClassHeader(clazz);
        if (0 != ret) {
            return ret;
        }
        ret = this.checkJ9ClassIsNotUnloaded(clazz);
        if (0 != ret) {
            return ret;
        }
        if ((checkFlags & 2) != 2 && (delta = UDATA.cast(segment.heapAlloc()).sub(UDATA.cast(clazz))).lt(J9Class.SIZEOF)) {
            return 10;
        }
        return 0;
    }

    public int checkJ9ClassPointer(J9ClassPointer clazz) throws CorruptDataException {
        return this.checkJ9ClassPointer(clazz, false);
    }

    public int checkJ9ClassPointer(J9ClassPointer clazz, boolean allowUndead) throws CorruptDataException {
        IDATA delta;
        if (clazz == null || clazz.isNull()) {
            return 7;
        }
        int cacheIndex = (int)(clazz.longValue() % 19L);
        if (allowUndead && clazz.eq(this._checkedClassCacheAllowUndead[cacheIndex])) {
            return 0;
        }
        if (clazz.eq(this._checkedClassCache[cacheIndex])) {
            return 0;
        }
        if (UDATA.cast(clazz).anyBitsIn(CheckBase.J9MODRON_GCCHK_J9CLASS_ALIGNMENT_MASK)) {
            return 8;
        }
        J9MemorySegmentPointer segment = this.findSegmentForClass(clazz);
        if (segment == null) {
            return 9;
        }
        if (!allowUndead && (segment.type().longValue() & J9MemorySegment.MEMORY_TYPE_UNDEAD_CLASS) != 0L) {
            return 29;
        }
        int result = this.checkJ9ClassHeader(clazz);
        if (0 != result) {
            return result;
        }
        result = this.checkJ9ClassIsNotUnloaded(clazz);
        if (0 != result) {
            return result;
        }
        if ((this._cycle.getCheckFlags() & 2) != 0 && (delta = segment.heapAlloc().sub(U8Pointer.cast(clazz))).lt(J9Class.SIZEOF)) {
            return 10;
        }
        if (allowUndead) {
            this._checkedClassCacheAllowUndead[cacheIndex] = clazz;
        } else {
            this._checkedClassCache[cacheIndex] = clazz;
        }
        return 0;
    }

    private int checkJ9ClassHeader(J9ClassPointer clazz) throws CorruptDataException {
        if (!clazz.eyecatcher().eq(0x99669966L)) {
            return 26;
        }
        return 0;
    }

    private int checkJ9ClassIsNotUnloaded(J9ClassPointer clazz) throws CorruptDataException {
        if (!clazz.classDepthAndFlags().bitAnd(J9JavaAccessFlags.J9AccClassDying).eq(0L)) {
            return 48;
        }
        return 0;
    }

    private int checkJ9LinkedFreeHeader(GCHeapLinkedFreeHeader hole, GCHeapRegionDescriptor regionDesc, int checkFlags) throws CorruptDataException {
        J9ObjectPointer object = hole.getObject();
        if (ObjectModel.isSingleSlotHoleObject(object)) {
            return 0;
        }
        UDATA holeSize = hole.getSize();
        if (holeSize.eq(0L)) {
            return 16;
        }
        if (holeSize.anyBitsIn(CheckBase.J9MODRON_GCCHK_J9OBJECT_ALIGNMENT_MASK)) {
            return 44;
        }
        UDATA regionStart = UDATA.cast(regionDesc.getLowAddress());
        UDATA regionEnd = regionStart.add(regionDesc.getSize());
        UDATA delta = regionEnd.sub(UDATA.cast(object));
        if (delta.lt(holeSize)) {
            return 5;
        }
        GCHeapLinkedFreeHeader nextHole = hole.getNext();
        J9ObjectPointer nextObject = nextHole.getObject();
        if (!nextObject.isNull()) {
            if (!ObjectModel.isHoleObject(nextObject)) {
                return 45;
            }
            if (regionStart.gt(UDATA.cast(nextObject)) || regionEnd.lte(UDATA.cast(nextObject))) {
                return 46;
            }
            if (holeSize.add(UDATA.cast(object)).gt(UDATA.cast(nextObject)) && object.lt(nextObject)) {
                return 47;
            }
        }
        return 0;
    }

    private int checkJ9Object(J9ObjectPointer object, GCHeapRegionDescriptor regionDesc, int checkFlags) throws CorruptDataException {
        J9IndexableObjectPointer array;
        int ret;
        if (object.isNull()) {
            return 0;
        }
        if (!regionDesc.containsObjects()) {
            return 3;
        }
        if (object.anyBitsIn(CheckBase.J9MODRON_GCCHK_J9OBJECT_ALIGNMENT_MASK)) {
            return 1;
        }
        if ((checkFlags & 1) != 0 && 0 != (ret = this.checkJ9ClassPointer(J9ObjectHelper.clazz(object), true))) {
            return ret;
        }
        if (this._isVirtualLargeObjectHeapEnabled && ObjectModel.isIndexable(object) && !J9IndexableObjectHelper.hasCorrectDataAddrPointer(array = J9IndexableObjectPointer.cast(object))) {
            return 34;
        }
        if ((checkFlags & 2) != 0) {
            UDATA regionEnd = UDATA.cast(regionDesc.getLowAddress()).add(regionDesc.getSize());
            long delta = regionEnd.sub(UDATA.cast(object)).longValue();
            if (delta < J9ObjectHelper.headerSize()) {
                return 5;
            }
            if (ObjectModel.isIndexable(object) && delta < J9IndexableObjectHelper.contiguousHeaderSize()) {
                return 5;
            }
            if (delta < ObjectModel.getSizeInBytesWithHeader(object).longValue()) {
                return 5;
            }
            if ((checkFlags & 8) != 0) {
                if (!this.checkIndexableFlag(object)) {
                    return 13;
                }
                if (GCExtensions.isStandardGC()) {
                    UDATA regionFlags = regionDesc.getTypeFlags();
                    if (regionFlags.allBitsIn(J9MemorySegment.MEMORY_TYPE_OLD)) {
                        if (!ObjectModel.isOld(object)) {
                            return 14;
                        }
                    } else if (regionFlags.allBitsIn(J9MemorySegment.MEMORY_TYPE_NEW) && ObjectModel.isOld(object)) {
                        return 15;
                    }
                }
            }
        }
        return 0;
    }

    private boolean checkIndexableFlag(J9ObjectPointer object) throws CorruptDataException {
        UDATA classShape = ObjectModel.getClassShape(J9ObjectHelper.clazz(object));
        boolean isIndexable = ObjectModel.isIndexable(object);
        if (classShape.eq(J9Object.OBJECT_HEADER_SHAPE_POINTERS)) {
            return isIndexable;
        }
        if (classShape.eq(J9Object.OBJECT_HEADER_SHAPE_BYTES)) {
            return isIndexable;
        }
        if (classShape.eq(J9Object.OBJECT_HEADER_SHAPE_WORDS)) {
            return isIndexable;
        }
        if (classShape.eq(J9Object.OBJECT_HEADER_SHAPE_LONGS)) {
            return isIndexable;
        }
        if (classShape.eq(J9Object.OBJECT_HEADER_SHAPE_DOUBLES)) {
            return isIndexable;
        }
        return !isIndexable;
    }

    public void startCheckCycle(CheckCycle checkCycle) throws CorruptDataException {
        this._cycle = checkCycle;
        this._currentCheck = null;
        this.clearPreviousObjects();
        this.clearCheckedCache();
        this._needVerifyOwnableSynchronizerConsistency = 131072 == (this._cycle.getMiscFlags() & 0x20000);
        this.clearCountsForOwnableSynchronizerObjects();
        this.prepareForHeapWalk();
    }

    public void prepareForHeapWalk() throws CorruptDataException {
        this._classSegmentsTree = new SegmentTree(this._javaVM.classMemorySegments());
    }

    public void endCheckCycle() {
    }

    public void startNewCheck(Check check) {
        this._currentCheck = check;
        this.clearPreviousObjects();
    }

    private void clearCheckedCache() {
        Arrays.fill(this._checkedClassCache, null);
        Arrays.fill(this._checkedClassCacheAllowUndead, null);
        Arrays.fill(this._checkedObjectCache, null);
    }

    private boolean isPointerInSegment(AbstractPointer pointer, J9MemorySegmentPointer segment) {
        try {
            return pointer.gte(segment.heapBase()) && pointer.lt(segment.heapAlloc());
        }
        catch (CorruptDataException e) {
            return false;
        }
    }

    private boolean isObjectOnStack(J9ObjectPointer object, J9JavaStackPointer stack) {
        try {
            return object.lt(stack.end()) && object.gte(stack.add(1L));
        }
        catch (CorruptDataException e) {
            return false;
        }
    }

    private J9MemorySegmentPointer findSegmentForClass(J9ClassPointer clazz) {
        J9MemorySegmentPointer segment = this._classSegmentsTree.findSegment(clazz);
        if (segment != null) {
            if (!this.isPointerInSegment(clazz, segment)) {
                return null;
            }
            try {
                if (segment.type().anyBitsIn(J9MemorySegment.MEMORY_TYPE_RAM_CLASS | J9MemorySegment.MEMORY_TYPE_UNDEAD_CLASS)) {
                    return segment;
                }
            }
            catch (CorruptDataException e) {
                return null;
            }
        }
        return null;
    }

    public int checkSlotUnfinalizedList(J9ObjectPointer object, MM_UnfinalizedObjectListPointer currentList) {
        int result = this.checkObjectIndirect(object);
        if (0 != result) {
            CheckError error = new CheckError(currentList, object, this._cycle, this._currentCheck, result, this._cycle.nextErrorCount());
            this._reporter.report(error);
        }
        return 0;
    }

    public int checkSlotOwnableSynchronizerList(J9ObjectPointer object, MM_OwnableSynchronizerObjectListPointer currentList) {
        if (this.needVerifyOwnableSynchronizerConsistency()) {
            ++this._ownableSynchronizerObjectCountOnList;
        }
        try {
            int result = this.checkObjectIndirect(object);
            if (0 != result) {
                CheckError error = new CheckError(currentList, object, this._cycle, this._currentCheck, result, this._cycle.nextErrorCount());
                this._reporter.report(error);
                this._reporter.reportHeapWalkError(error, this._lastHeapObject1, this._lastHeapObject2, this._lastHeapObject3);
                return 1;
            }
            J9ClassPointer instanceClass = J9ObjectHelper.clazz(object);
            if (J9ClassHelper.classFlags(instanceClass).bitAnd(J9JavaAccessFlags.J9AccClassOwnableSynchronizer).eq(0L)) {
                CheckError error = new CheckError(currentList, object, this._cycle, this._currentCheck, 13, this._cycle.nextErrorCount());
                this._reporter.report(error);
            }
        }
        catch (CorruptDataException e) {
            CheckError error = new CheckError(currentList, object, this._cycle, this._currentCheck, Integer.MAX_VALUE, this._cycle.nextErrorCount());
            this._reporter.report(error);
            this._reporter.reportHeapWalkError(error, this._lastHeapObject1, this._lastHeapObject2, this._lastHeapObject3);
            return 1;
        }
        return 0;
    }

    public int checkSlotFinalizableList(J9ObjectPointer object) {
        int result = this.checkObjectIndirect(object);
        if (0 != result) {
            CheckError error = new CheckError((AbstractPointer)object, null, this._cycle, this._currentCheck, result, this._cycle.nextErrorCount(), 6);
            this._reporter.report(error);
        }
        return 0;
    }

    public void setMaxErrorsToReport(int count) {
        this._reporter.setMaxErrorsToReport(count);
    }

    public void clearCountsForOwnableSynchronizerObjects() {
        this._ownableSynchronizerObjectCountOnList = -1;
        this._ownableSynchronizerObjectCountOnHeap = -1;
    }

    public boolean verifyOwnableSynchronizerObjectCounts() {
        boolean ret = true;
        if (-1 != this._ownableSynchronizerObjectCountOnList && -1 != this._ownableSynchronizerObjectCountOnHeap && this._ownableSynchronizerObjectCountOnList != this._ownableSynchronizerObjectCountOnHeap) {
            this._reporter.println(String.format("<gc check: found count=%d of OwnableSynchronizerObjects on Heap doesn't match count=%d on lists>", this._ownableSynchronizerObjectCountOnHeap, this._ownableSynchronizerObjectCountOnList));
            ret = false;
        }
        return ret;
    }

    public void reportOwnableSynchronizerCircularReferenceError(J9ObjectPointer object, MM_OwnableSynchronizerObjectListPointer currentList) {
        CheckError error = new CheckError(currentList, object, this._cycle, this._currentCheck, 43, this._cycle.nextErrorCount());
        this._reporter.report(error);
        this._reporter.reportHeapWalkError(error, this._lastHeapObject1, this._lastHeapObject2, this._lastHeapObject3);
    }

    public void initializeOwnableSynchronizerCountOnList() {
        this._ownableSynchronizerObjectCountOnList = 0;
    }

    public void initializeOwnableSynchronizerCountOnHeap() {
        this._ownableSynchronizerObjectCountOnHeap = 0;
    }

    public boolean needVerifyOwnableSynchronizerConsistency() {
        return this._needVerifyOwnableSynchronizerConsistency;
    }
}

