/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.LinearDumper;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.RomClassWalker;
import java.io.PrintStream;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class QueryRomClassCommand
extends Command {
    public QueryRomClassCommand() {
        this.addCommand("queryromclass", "<addr>,q1[,q2,...]", "query the specified J9ROMClass (equivalent to -drq in cfdump)\n" + String.format("%-25s %-20s \n", "    Query examples:", "<addr>,/romHeader,/romHeader/className,/methods,") + String.format("%-25s %-20s \n", "", "<addr>,/methods/method[0],/methods/method[3]/name,") + String.format("%-25s %-20s", "", "<addr>,/methods/method[3]/methodBytecodes"));
    }

    @Override
    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        if (args.length == 0) {
            this.printUsage(out);
            return;
        }
        try {
            String[] queries = args[0].split(",");
            long address = CommandUtils.parsePointer(queries[0], J9BuildFlags.J9VM_ENV_DATA64);
            J9ROMClassPointer romClass = J9ROMClassPointer.cast(address);
            queries[0] = "";
            RomClassWalker classWalker = new RomClassWalker(romClass, context);
            LinearDumper linearDumper = new LinearDumper();
            LinearDumper.J9ClassRegionNode allRegionsNode = linearDumper.getAllRegions(classWalker);
            for (String query : queries) {
                if (query.length() == 0) continue;
                this.queryROMClass(out, romClass, query, allRegionsNode);
            }
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }

    private void printUsage(PrintStream out) {
        CommandUtils.dbgPrint(out, "Usage:" + nl);
        out.println("!queryromclass <addr>,q1[,q2,...] - query the specified J9ROMClass (equivalent to -drq in cfdump)");
        out.println("Query examples: <addr>,/romHeader,/romHeader/className,/methods,");
        out.println("\t<addr>,/methods/method[0],/methods/method[3]/name,");
        out.println("\t<addr>,/methods/method[3]/methodBytecodes");
    }

    private void queryROMClass(PrintStream out, J9ROMClassPointer romClass, String query, LinearDumper.J9ClassRegionNode allRegionsNode) throws CorruptDataException {
        String[] parts;
        for (String part : parts = query.split("/")) {
            int index;
            String sectionName;
            if (part.length() == 0) continue;
            if (part.endsWith("]")) {
                Pattern p = Pattern.compile("^(.*)\\[(\\d*)\\]");
                Matcher m = p.matcher(part);
                m.find();
                sectionName = m.group(1).trim();
                index = Integer.parseInt(m.group(2).trim());
            } else {
                sectionName = part;
                index = 0;
            }
            List<LinearDumper.J9ClassRegionNode> children = allRegionsNode.getChildren();
            if (children.size() <= index) {
                out.println("Error: section not found or bad formatting");
                this.printUsage(out);
                return;
            }
            for (LinearDumper.J9ClassRegionNode classRegionNode : children) {
                if (classRegionNode.getNodeValue() == null || !classRegionNode.getNodeValue().getName().equals(sectionName) || index-- != 0) continue;
                allRegionsNode = classRegionNode;
            }
        }
        CommandUtils.dbgPrint(out, String.format("ROM Class '%s' at %s:\n\n", J9UTF8Helper.stringValue(romClass.className()), romClass.getHexAddress()));
        LinearDumper.printAllRegions(out, romClass, 9L, allRegionsNode, 0);
    }
}

