/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.util.PatternString;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.walkers.ClassIterator;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassLoaderPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ModulePointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.JavaVersionHelper;
import java.io.PrintStream;
import java.util.Iterator;

public class DumpAllClassesInModuleCommand
extends Command {
    public DumpAllClassesInModuleCommand() {
        this.addCommand("dumpallclassesinmodule", "<moduleAddress>", "dump all loaded classes in the target module");
    }

    @Override
    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        if (args.length != 1) {
            CommandUtils.dbgPrint(out, "Usage: !dumpallclassesinmodule <moduleAddress>\n");
            return;
        }
        try {
            J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
            if (JavaVersionHelper.ensureJava9AndUp(vm, out)) {
                String targetModuleAddress = args[0];
                J9ModulePointer modulePtr = J9ModulePointer.cast(Long.decode(targetModuleAddress));
                J9ClassLoaderPointer classLoaderPtr = modulePtr.classLoader();
                Iterator<J9ClassPointer> iterator = ClassIterator.fromJ9Classloader(classLoaderPtr);
                J9ClassPointer classPtr = null;
                int hitCount = 0;
                PatternString pattern = new PatternString(targetModuleAddress);
                while (iterator.hasNext()) {
                    classPtr = iterator.next();
                    String moduleAddr = classPtr.module().getHexAddress();
                    if (!pattern.isMatch(moduleAddr)) continue;
                    String className = J9ClassHelper.getName(classPtr);
                    String classAddress = classPtr.getHexAddress();
                    ++hitCount;
                    out.printf("%-30s !j9class %s%n", className, classAddress);
                }
                out.printf("Found %d loaded classes in !j9module %s\n", hitCount, targetModuleAddress);
            }
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }
}

