/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.StructureReader;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.StructureCommandUtil;
import com.ibm.j9ddr.vm29.pointer.StructurePointer;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.IClassWalkCallbacks;
import java.util.HashMap;
import java.util.regex.Pattern;

public abstract class ClassWalker {
    protected HashMap<String, String> debugExtMap = new HashMap();
    protected StructurePointer clazz;
    protected IClassWalkCallbacks classWalkerCallback;
    private static final Pattern TypeTagPattern = Pattern.compile("\\s*\\b(class|struct)\\s+");

    public abstract void allSlotsInObjectDo(IClassWalkCallbacks var1) throws CorruptDataException;

    public abstract Context getContext();

    protected void fillDebugExtMap() {
    }

    public StructurePointer getClazz() {
        return this.clazz;
    }

    public IClassWalkCallbacks getClassWalkerCallbacks() {
        return this.classWalkerCallback;
    }

    protected String getDebugExtForMethodName(String methodName) {
        return this.debugExtMap.get(methodName);
    }

    protected void addObjectsAsSlot(StructurePointer methodClass, HashMap<String, String> renameFields) throws CorruptDataException {
        String structureName = methodClass.getClass().getSimpleName().substring(0, methodClass.getClass().getSimpleName().indexOf("Pointer"));
        StructureReader.StructureDescriptor sd = StructureCommandUtil.getStructureDescriptor(structureName, this.getContext());
        if (sd == null) {
            throw new CorruptDataException("Structure \"" + structureName + "\" can not be found.");
        }
        for (StructureReader.FieldDescriptor fd : sd.getFields()) {
            if (!fd.isPresent()) continue;
            String outName = fd.getName();
            IClassWalkCallbacks.SlotType type2 = ClassWalker.getTypeByFieldTypeName(fd.getType());
            U8Pointer address = U8Pointer.cast(methodClass).addOffset(fd.getOffset());
            if (null != renameFields && renameFields.containsKey(outName)) {
                outName = renameFields.get(outName);
            }
            this.classWalkerCallback.addSlot(this.clazz, type2, address, outName, this.getDebugExtForMethodName(outName));
        }
    }

    protected void addObjectsasSlot(StructurePointer methodClass) throws CorruptDataException {
        this.addObjectsAsSlot(methodClass, null);
    }

    private static IClassWalkCallbacks.SlotType getTypeByFieldTypeName(String fieldTypeName) throws CorruptDataException {
        String typeName = TypeTagPattern.matcher(fieldTypeName).replaceAll("");
        if (typeName.equals("J9WSRP") || typeName.startsWith("J9WSRP(")) {
            return IClassWalkCallbacks.SlotType.J9_WSRP;
        }
        if (typeName.equals("J9SRP") || typeName.startsWith("J9SRP(")) {
            return typeName.startsWith("J9SRP(J9UTF8") ? IClassWalkCallbacks.SlotType.J9_SRP_TO_STRING : IClassWalkCallbacks.SlotType.J9_SRP;
        }
        if (typeName.equals("J9UTF8*")) {
            return IClassWalkCallbacks.SlotType.J9_ROM_UTF8;
        }
        if (typeName.equals("U8")) {
            return IClassWalkCallbacks.SlotType.J9_U8;
        }
        if (typeName.equals("I8")) {
            return IClassWalkCallbacks.SlotType.J9_I8;
        }
        if (typeName.equals("U16")) {
            return IClassWalkCallbacks.SlotType.J9_U16;
        }
        if (typeName.equals("I16")) {
            return IClassWalkCallbacks.SlotType.J9_I16;
        }
        if (typeName.equals("U32")) {
            return IClassWalkCallbacks.SlotType.J9_U32;
        }
        if (typeName.equals("I32")) {
            return IClassWalkCallbacks.SlotType.J9_I32;
        }
        if (typeName.equals("U64")) {
            return IClassWalkCallbacks.SlotType.J9_U64;
        }
        if (typeName.equals("I64")) {
            return IClassWalkCallbacks.SlotType.J9_I64;
        }
        if (typeName.equals("UDATA")) {
            return IClassWalkCallbacks.SlotType.J9_UDATA;
        }
        if (typeName.equals("IDATA")) {
            return IClassWalkCallbacks.SlotType.J9_IDATA;
        }
        if (typeName.equals("J9ROMNameAndSignature")) {
            return IClassWalkCallbacks.SlotType.J9_NAS;
        }
        if (typeName.endsWith("*")) {
            return IClassWalkCallbacks.SlotType.J9_UDATA;
        }
        throw new CorruptDataException("Field type name '" + fieldTypeName + "' is not recognized.");
    }
}

