/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.gc.GCArrayletObjectModelBase;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9IndexableObjectPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9IndexableObjectHelper;
import com.ibm.j9ddr.vm29.types.UDATA;

class GCArrayletObjectModel_V2
extends GCArrayletObjectModelBase {
    @Override
    public UDATA getSizeInBytesWithHeader(J9IndexableObjectPointer array) throws CorruptDataException {
        return super.getSpineSize(array);
    }

    @Override
    protected UDATA numArraylets(UDATA dataSizeInBytes) throws CorruptDataException {
        UDATA numberOfArraylets = new UDATA(1L);
        if (!UDATA.MAX.eq(this.arrayletLeafSize)) {
            numberOfArraylets = dataSizeInBytes.rightShift(this.arrayletLeafLogSize).add(dataSizeInBytes.bitAnd(this.arrayletLeafSizeMask).add(this.arrayletLeafSizeMask).rightShift(this.arrayletLeafLogSize));
        }
        return numberOfArraylets;
    }

    @Override
    public UDATA getTotalFootprintInBytesWithHeader(J9IndexableObjectPointer arrayPtr) throws CorruptDataException {
        UDATA spineSize = this.getSizeInBytesWithHeader(arrayPtr);
        UDATA externalArrayletSize = this.externalArrayletsSize(arrayPtr);
        UDATA totalFootprint = spineSize.add(externalArrayletSize);
        return totalFootprint;
    }

    @Override
    public boolean hasCorrectDataAddrPointer(J9IndexableObjectPointer arrayPtr) throws CorruptDataException {
        boolean hasCorrectDataAddrPointer;
        try {
            UDATA dataSizeInBytes = this.getDataSizeInBytes(arrayPtr);
            VoidPointer dataAddr = J9IndexableObjectHelper.getDataAddrForIndexable(arrayPtr);
            if (dataSizeInBytes.isZero()) {
                VoidPointer discontiguousDataAddr = VoidPointer.cast(arrayPtr.addOffset(J9IndexableObjectHelper.discontiguousHeaderSize()));
                hasCorrectDataAddrPointer = dataAddr.isNull() || dataAddr.equals(discontiguousDataAddr);
            } else if (dataSizeInBytes.lt(this.arrayletLeafSize)) {
                VoidPointer contiguousDataAddr = VoidPointer.cast(arrayPtr.addOffset(J9IndexableObjectHelper.contiguousHeaderSize()));
                hasCorrectDataAddrPointer = dataAddr.equals(contiguousDataAddr);
            } else {
                hasCorrectDataAddrPointer = this.isIndexableObjectOffHeap(dataAddr, dataSizeInBytes);
            }
        }
        catch (NoSuchFieldException e) {
            hasCorrectDataAddrPointer = true;
        }
        return hasCorrectDataAddrPointer;
    }
}

