/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.AlgorithmVersion;
import com.ibm.j9ddr.vm29.j9.ObjectMonitor_V1;
import com.ibm.j9ddr.vm29.j9.ObjectMonitor_V2;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectMonitorPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ThreadAbstractMonitorPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9VMThreadPointer;
import java.util.List;

public abstract class ObjectMonitor
implements Comparable<ObjectMonitor> {
    public static ObjectMonitor fromJ9Object(J9ObjectPointer object) throws CorruptDataException {
        AlgorithmVersion version = AlgorithmVersion.getVersionOf("ALG_OBJECT_MONITOR_VERSION");
        switch (version.getAlgorithmVersion()) {
            case 0: {
                ObjectMonitor_V1 v1 = new ObjectMonitor_V1(object);
                if (v1.getLockword().isNull() && !v1.isInTable()) {
                    return null;
                }
                return v1;
            }
        }
        ObjectMonitor_V2 v2 = new ObjectMonitor_V2(object);
        if (v2.getLockword().isNull() && !v2.isInTable()) {
            return null;
        }
        return v2;
    }

    public boolean equals(Object object) {
        return this.compareTo((ObjectMonitor)object) == 0;
    }

    public abstract J9ObjectPointer getObject();

    public abstract J9ObjectMonitorPointer getLockword();

    public abstract J9VMThreadPointer getOwner() throws CorruptDataException;

    public abstract long getCount() throws CorruptDataException;

    public abstract boolean isInflated();

    public abstract boolean isInTable();

    public abstract boolean isContended() throws CorruptDataException;

    public abstract List<J9VMThreadPointer> getWaitingThreads() throws CorruptDataException;

    public abstract List<J9VMThreadPointer> getBlockedThreads() throws CorruptDataException;

    public abstract J9ThreadAbstractMonitorPointer getInflatedMonitor();

    public abstract J9ObjectMonitorPointer getJ9ObjectMonitorPointer();
}

