/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm28.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm28.j9.stackmap.StackMap;
import com.ibm.j9ddr.vm28.j9.stackwalker.FrameCallbackResult;
import com.ibm.j9ddr.vm28.j9.stackwalker.IStackWalkerCallbacks;
import com.ibm.j9ddr.vm28.j9.stackwalker.StackWalkResult;
import com.ibm.j9ddr.vm28.j9.stackwalker.StackWalker;
import com.ibm.j9ddr.vm28.j9.stackwalker.StackWalkerUtils;
import com.ibm.j9ddr.vm28.j9.stackwalker.WalkState;
import com.ibm.j9ddr.vm28.pointer.ObjectReferencePointer;
import com.ibm.j9ddr.vm28.pointer.PointerPointer;
import com.ibm.j9ddr.vm28.pointer.UDATAPointer;
import com.ibm.j9ddr.vm28.pointer.VoidPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm28.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9MethodPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9ROMMethodPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm28.pointer.helper.J9MethodHelper;
import com.ibm.j9ddr.vm28.pointer.helper.J9ROMMethodHelper;
import com.ibm.j9ddr.vm28.structure.J9Consts;
import com.ibm.j9ddr.vm28.structure.J9StackWalkConstants;
import com.ibm.j9ddr.vm28.types.U16;
import com.ibm.j9ddr.vm28.types.UDATA;
import java.io.PrintStream;
import java.util.LinkedList;

public class OSRCommand
extends Command {
    private static final String nl = System.getProperty("line.separator");

    public OSRCommand() {
        this.addCommand("osr", "<vmthread> <OSRBuffer>", "Display On Stack Replacement metadata");
    }

    private void printUsage(PrintStream out) {
        out.println("osr <vmthread> <OSRBuffer> - Display On Stack Replacement metadata");
    }

    @Override
    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        if (2 != args.length) {
            out.println("Invalid args. Usage: ");
            this.printUsage(out);
            return;
        }
        long vmThreadAddress = CommandUtils.parsePointer(args[0], J9BuildFlags.env_data64);
        long osrBufferAddress = CommandUtils.parsePointer(args[1], J9BuildFlags.env_data64);
        J9VMThreadPointer vmThread = J9VMThreadPointer.cast(vmThreadAddress);
        try {
            out.append("OSR Buffer");
            IProcess proc = context.process;
            UDATAPointer cursor = UDATAPointer.cast(proc.getPointerAt(osrBufferAddress));
            out.append("  vmthread:      j9vmthread " + cursor.hexAt(0L) + nl);
            cursor.add(1L);
            out.append("  frame pointer: " + cursor.hexAt(0L) + nl);
            cursor.add(1L);
            LinkedList<OSRFrameRecord> frames = this.stackWalk(vmThread, out);
            if (frames != null) {
                for (OSRFrameRecord record : frames) {
                    int i;
                    out.append("  \tmethod: !j9method " + record.method.getHexAddress() + nl);
                    out.append("  \tpushCount: " + record.pushCount + " tempCount: " + record.tempCount);
                    for (i = 0; i < record.tempCount.intValue(); ++i) {
                        out.append("\t\ttemp: " + cursor.hexAt(0L) + nl);
                        cursor.add(1L);
                    }
                    for (i = 0; i < record.tempCount.intValue(); ++i) {
                        out.append("\t\tpush: " + cursor.hexAt(0L) + nl);
                        cursor.add(1L);
                    }
                }
            }
            out.append(nl);
            out.append(nl);
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }

    private LinkedList<OSRFrameRecord> stackWalk(J9VMThreadPointer vmThread, PrintStream out) {
        StackWalkerUtils.disableVerboseLogging();
        OSRWalkState walkState = new OSRWalkState();
        walkState.flags = J9Consts.J9_STACKWALK_RECORD_BYTECODE_PC_OFFSET;
        walkState.walkThread = vmThread;
        walkState.callBacks = new OSRStackWalkerCallbacks();
        walkState.frameRecordList = new LinkedList();
        StackWalkResult result = StackWalker.walkStackFrames(walkState);
        if (result == StackWalkResult.NONE) {
            return walkState.frameRecordList;
        }
        return null;
    }

    public class OSRFrameRecord {
        public J9MethodPointer method;
        public U16 tempCount;
        public U16 pushCount;
        public U16 maxCount;
    }

    public class OSRStackWalkerCallbacks
    implements IStackWalkerCallbacks {
        @Override
        public FrameCallbackResult frameWalkFunction(J9VMThreadPointer walkThread, WalkState ws) {
            OSRWalkState walkState = (OSRWalkState)ws;
            if (walkState.bp == walkState.framePointer) {
                OSRFrameRecord record = new OSRFrameRecord();
                try {
                    J9MethodPointer method = walkState.method;
                    J9ROMMethodPointer romMethod = J9MethodHelper.romMethod(method);
                    record.method = method;
                    record.pushCount = new U16(this.calculatePushCount(walkState, method, romMethod));
                    record.tempCount = romMethod.tempCount();
                    record.maxCount = romMethod.maxStack();
                    walkState.frameRecordList.add(record);
                }
                catch (CorruptDataException e) {
                    e.printStackTrace();
                }
            } else if (walkState.frameRecordList.size() > 0) {
                return FrameCallbackResult.STOP_ITERATING;
            }
            return FrameCallbackResult.KEEP_ITERATING;
        }

        private int calculatePushCount(OSRWalkState walkState, J9MethodPointer method, J9ROMMethodPointer romMethod) throws CorruptDataException {
            J9ClassPointer clazz = method.constantPool().ramClass();
            J9ROMClassPointer romClass = clazz.romClass();
            if (walkState.resolveFrameFlags.allBitsIn(J9StackWalkConstants.J9_STACK_FLAGS_JIT_RESOLVE_AT_EXCEPTION_CATCH | J9StackWalkConstants.J9_STACK_FLAGS_JIT_MONITOR_NOT_ENTERED)) {
                return 0;
            }
            int pendingStackSize = StackMap.j9stackmap_StackBitsForPC(UDATA.cast(walkState.bytecodePCOffset), romClass, romMethod, null, 0);
            if (pendingStackSize < 0) {
                throw new CorruptDataException("Failed retrieving pending stack size with j9stackmap_StackBitsForPC rc = " + pendingStackSize);
            }
            if (walkState.resolveFrameFlags.allBitsIn(J9StackWalkConstants.J9_STACK_FLAGS_JIT_RESOLVE_ADVANCE_PC)) {
                String sig = J9ROMMethodHelper.getSignature(romMethod);
                int retChar = sig.indexOf(")");
                switch (++retChar) {
                    case 86: {
                        break;
                    }
                    case 68: 
                    case 74: {
                        pendingStackSize -= 2;
                        break;
                    }
                    default: {
                        --pendingStackSize;
                        break;
                    }
                }
            } else {
                pendingStackSize -= walkState.argCount.intValue();
            }
            return pendingStackSize;
        }

        @Override
        public void objectSlotWalkFunction(J9VMThreadPointer walkThread, WalkState walkState, PointerPointer objectSlot, VoidPointer stackLocation) {
        }

        @Override
        public void fieldSlotWalkFunction(J9VMThreadPointer walkThread, WalkState walkState, ObjectReferencePointer objectSlot, VoidPointer stackLocation) {
        }
    }

    public class OSRWalkState
    extends WalkState {
        public int foo;
        public UDATAPointer framePointer;
        LinkedList<OSRFrameRecord> frameRecordList;
    }
}

