/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm28.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm28.events.EventManager;
import com.ibm.j9ddr.vm28.j9.gc.GCMemoryPoolSplitAddressOrderedList;
import com.ibm.j9ddr.vm28.j9.gc.GCModronAllocateHintIterator;
import com.ibm.j9ddr.vm28.pointer.generated.J9ModronAllocateHintPointer;
import com.ibm.j9ddr.vm28.types.UDATA;
import java.util.NoSuchElementException;

public class GCModronAllocateHintIteratorSAOL
extends GCModronAllocateHintIterator {
    protected UDATA _totalListCount = null;
    protected UDATA _freeListIndex = new UDATA(0L);
    protected J9ModronAllocateHintPointer _currentHint = null;
    protected GCMemoryPoolSplitAddressOrderedList _memoryPool = null;

    public GCModronAllocateHintIteratorSAOL(GCMemoryPoolSplitAddressOrderedList memoryPool) throws CorruptDataException {
        this._memoryPool = memoryPool;
        this._totalListCount = memoryPool.getFreeListCount();
        this.advanceHint();
    }

    private void advanceHint() {
        try {
            if (this._currentHint != null) {
                if (this._currentHint.next().notNull()) {
                    this._currentHint = this._currentHint.next();
                    return;
                }
                this._freeListIndex = this._freeListIndex.add(1L);
            }
            while (this._freeListIndex.lt(this._totalListCount)) {
                this._currentHint = this._memoryPool.getFirstHintForFreeList(this._freeListIndex);
                if (this._currentHint.notNull()) {
                    return;
                }
                this._freeListIndex = this._freeListIndex.add(1L);
            }
            this._currentHint = null;
        }
        catch (CorruptDataException e) {
            EventManager.raiseCorruptDataEvent("Hint corruption detected", e, false);
            this._currentHint = null;
        }
    }

    @Override
    public int getFreeListNumber() {
        return this._freeListIndex.intValue();
    }

    @Override
    public boolean hasNext() {
        return null != this._currentHint;
    }

    @Override
    public J9ModronAllocateHintPointer next() {
        if (this.hasNext()) {
            J9ModronAllocateHintPointer next = this._currentHint;
            this.advanceHint();
            return next;
        }
        throw new NoSuchElementException("There are no more items available through this iterator");
    }

    @Override
    public String toString() {
        GCModronAllocateHintIteratorSAOL tempIter = null;
        try {
            tempIter = new GCModronAllocateHintIteratorSAOL(this._memoryPool);
        }
        catch (CorruptDataException e) {
            EventManager.raiseCorruptDataEvent("Corruption detected", e, false);
            return e.toString();
        }
        StringBuilder builder = new StringBuilder();
        String NEW_LINE = System.getProperty("line.separator");
        while (tempIter.hasNext()) {
            builder.append(tempIter.next().getHexAddress() + NEW_LINE);
        }
        return builder.toString();
    }
}

