/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.tools.ddrinteractive.commands;

import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm27.j9.ObjectAccessBarrier;
import com.ibm.j9ddr.vm27.pointer.VoidPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm27.pointer.generated.J9ObjectPointer;
import java.io.PrintStream;

public class CompressedRefMappingCommand
extends Command {
    public CompressedRefMappingCommand() {
        this.addCommand("fj9object", "<address>", "Display the j9object given a compressed refs address.");
        this.addCommand("fj9objecttoj9object", "<address>", "Convert the compressed refs address to a j9object address.");
        this.addCommand("j9objecttofj9object", "<address>", "Convert the j9object address to a compressed refs address.");
    }

    private void printHelp(PrintStream out) {
        out.append("Usage: \n");
        out.append("  !fj9object <address>\n");
        out.append("  !fj9objecttoj9object <address>\n");
        out.append("  !j9objecttofj9object <address>\n");
    }

    @Override
    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        if (args.length == 0) {
            this.printHelp(out);
            return;
        }
        long address = CommandUtils.parsePointer(args[0], J9BuildFlags.env_data64);
        VoidPointer ptr = VoidPointer.cast(address);
        if (command.startsWith("!fj9object")) {
            J9ObjectPointer mappedValue = J9BuildFlags.gc_compressedPointers ? ObjectAccessBarrier.convertPointerFromToken(ptr.getAddress()) : J9ObjectPointer.cast(ptr);
            if (command.startsWith("!fj9objecttoj9object")) {
                out.println(String.format("!fj9object %s -> !j9object %s", ptr.getHexAddress(), mappedValue.getHexAddress()));
            } else {
                context.execute("!j9object", new String[]{mappedValue.getHexAddress()}, out);
            }
        } else {
            long tokenValue = J9BuildFlags.gc_compressedPointers ? ObjectAccessBarrier.convertTokenFromPointer(J9ObjectPointer.cast(ptr)) : ptr.getAddress();
            out.println(String.format("!j9object %s -> !fj9object 0x%s\n", ptr.getHexAddress(), Long.toHexString(tokenValue)));
        }
    }
}

