/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm27.j9.AlgorithmVersion;
import com.ibm.j9ddr.vm27.j9.MonitorTableList;
import com.ibm.j9ddr.vm27.j9.ObjectMonitor_V1;
import com.ibm.j9ddr.vm27.j9.tenant.TenantModel;
import com.ibm.j9ddr.vm27.pointer.generated.J9ObjectMonitorPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9TenantNativeDataPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ThreadAbstractMonitorPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9VMThreadPointer;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class ObjectMonitor
implements Comparable<ObjectMonitor> {
    public static ObjectMonitor fromJ9Object(J9ObjectPointer object, J9TenantNativeDataPointer tenant) throws CorruptDataException {
        AlgorithmVersion version = AlgorithmVersion.getVersionOf("OBJECT_MONITOR_VERSION");
        switch (version.getAlgorithmVersion()) {
            default: 
        }
        ObjectMonitor_V1 v1 = new ObjectMonitor_V1(object, tenant);
        if (v1.getLockword().isNull() && !v1.isInTable()) {
            return null;
        }
        return v1;
    }

    public static Set<ObjectMonitor> fromJ9Object(J9ObjectPointer object) throws CorruptDataException {
        HashSet<ObjectMonitor> objectMonitorHashSet = new HashSet<ObjectMonitor>();
        AlgorithmVersion version = AlgorithmVersion.getVersionOf("OBJECT_MONITOR_VERSION");
        switch (version.getAlgorithmVersion()) {
            default: 
        }
        Set<J9ObjectMonitorPointer> j9ObjectMonitors = MonitorTableList.peek(object);
        if (j9ObjectMonitors.isEmpty()) {
            ObjectMonitor objectMonitor = ObjectMonitor.fromJ9Object(object, J9TenantNativeDataPointer.NULL);
            if (objectMonitor != null) {
                objectMonitorHashSet.add(objectMonitor);
            }
        } else {
            for (J9ObjectMonitorPointer j9ObjectMonitorPointer : j9ObjectMonitors) {
                ObjectMonitor objectMonitor;
                J9TenantNativeDataPointer tenant = J9TenantNativeDataPointer.NULL;
                if (TenantModel.isTenantEnabled()) {
                    tenant = j9ObjectMonitorPointer.tenant();
                }
                if ((objectMonitor = ObjectMonitor.fromJ9Object(object, tenant)) == null) continue;
                objectMonitorHashSet.add(objectMonitor);
            }
        }
        return objectMonitorHashSet;
    }

    public boolean equals(Object object) {
        return this.compareTo((ObjectMonitor)object) == 0;
    }

    public abstract J9ObjectPointer getObject();

    public abstract J9ObjectMonitorPointer getLockword();

    public abstract J9VMThreadPointer getOwner() throws CorruptDataException;

    public abstract long getCount() throws CorruptDataException;

    public abstract boolean isInflated();

    public abstract boolean isInTable();

    public abstract boolean isContended() throws CorruptDataException;

    public abstract List<J9VMThreadPointer> getWaitingThreads() throws CorruptDataException;

    public abstract List<J9VMThreadPointer> getBlockedThreads() throws CorruptDataException;

    public abstract J9ThreadAbstractMonitorPointer getInflatedMonitor();

    public abstract J9ObjectMonitorPointer getJ9ObjectMonitorPointer();
}

