/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.InvalidDataTypeException;
import com.ibm.j9ddr.StructureReader;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.vm27.pointer.UDATAPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9RASPointer;
import com.ibm.j9ddr.vm27.types.UDATA;
import java.lang.reflect.Method;

public abstract class DataType {
    protected static IProcess process;
    protected static byte SIZEOF_BOOL;
    protected static byte BITFIELD_FORMAT;
    static J9RASPointer J9RASPOINTER;
    protected static String pointerPackageName;
    protected static String structurePackageName;

    public static void init(IProcess process, StructureReader structureReader) {
        DataType.process = process;
        SIZEOF_BOOL = structureReader.getSizeOfBool();
        BITFIELD_FORMAT = structureReader.getBitFieldFormat();
        pointerPackageName = structureReader.getPackageName(StructureReader.PackageNameType.POINTER_PACKAGE_DOT_NAME);
        structurePackageName = structureReader.getPackageName(StructureReader.PackageNameType.STRUCTURE_PACKAGE_DOT_NAME);
    }

    public static void setJ9RASPointer(J9RASPointer j9RASPoitner) {
        J9RASPOINTER = j9RASPoitner;
    }

    public static J9RASPointer getJ9RASPointer() {
        return J9RASPOINTER;
    }

    public static IProcess getProcess() {
        return process;
    }

    public static DataType getStructure(String name, long address) {
        if (address == 0L) {
            return null;
        }
        try {
            Class<?> clazz;
            try {
                clazz = Class.forName(pointerPackageName + "." + name);
            }
            catch (ClassNotFoundException notFound) {
                try {
                    clazz = Class.forName(UDATAPointer.class.getPackage().getName() + "." + name);
                }
                catch (ClassNotFoundException stillNotFound) {
                    throw notFound;
                }
            }
            return (DataType)DataType.getStructure(clazz, address);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot create the structure " + name, e);
        }
    }

    public static DataType getStructure(String name, UDATA udata) {
        return DataType.getStructure(name, udata.longValue());
    }

    public static <T> T getStructure(Class<T> clazz, long address) {
        if (address == 0L) {
            return null;
        }
        try {
            Method method = clazz.getDeclaredMethod("cast", Long.TYPE);
            Object result = method.invoke(null, address);
            return (T)result;
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot create the structure " + clazz.getSimpleName(), e);
        }
    }

    public abstract long longValue() throws CorruptDataException;

    public String formatShortInteractive() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName().toLowerCase());
        builder.append(": 0x");
        try {
            builder.append(Long.toHexString(this.longValue()));
        }
        catch (CorruptDataException e) {
            builder.append("FAULT");
        }
        catch (InvalidDataTypeException e) {
            builder.append("<FAULT : " + e.getMessage() + ">");
        }
        builder.append(" (");
        try {
            builder.append(this.longValue());
        }
        catch (CorruptDataException e) {
            builder.append("FAULT");
        }
        builder.append(")");
        return builder.toString();
    }

    public static String getPointerPackageName() {
        return pointerPackageName;
    }

    public static String getStructurePackageName() {
        return structurePackageName;
    }
}

