/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.pointer.helper;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm26.j9.AlgorithmVersion;
import com.ibm.j9ddr.vm26.pointer.U8Pointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9ROMMethodPointer;
import com.ibm.j9ddr.vm26.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm26.structure.J9CfrClassFile;
import com.ibm.j9ddr.vm26.structure.J9JavaAccessFlags;
import com.ibm.j9ddr.vm26.structure.J9ROMMethod;
import com.ibm.j9ddr.vm26.types.UDATA;

public class J9ROMMethodHelper {
    public static int getReflectModifiers(J9ROMMethodPointer method) throws CorruptDataException {
        return method.modifiers().bitAnd(J9CfrClassFile.CFR_METHOD_ACCESS_MASK).intValue();
    }

    public static String getName(J9ROMMethodPointer method) throws CorruptDataException {
        return J9UTF8Helper.stringValue(method.nameAndSignature().name());
    }

    public static String getSignature(J9ROMMethodPointer method) throws CorruptDataException {
        return J9UTF8Helper.stringValue(method.nameAndSignature().signature());
    }

    public static U8Pointer bytecodes(J9ROMMethodPointer method) throws CorruptDataException {
        return U8Pointer.cast(method).addOffset(J9ROMMethod.SIZEOF);
    }

    public static UDATA bytecodeSize(J9ROMMethodPointer method) throws CorruptDataException {
        return method.bytecodeSizeLow().add(new UDATA(method.bytecodeSizeHigh().leftShift(16)));
    }

    public static U8Pointer bytecodeEnd(J9ROMMethodPointer method) throws CorruptDataException {
        return J9ROMMethodHelper.bytecodes(method).add(J9ROMMethodHelper.bytecodeSize(method));
    }

    public static boolean isGetter(J9ROMMethodPointer method) throws CorruptDataException {
        return method.modifiers().allBitsIn(J9JavaAccessFlags.J9AccGetterMethod);
    }

    public static boolean isForwarder(J9ROMMethodPointer method) throws CorruptDataException {
        return method.modifiers().allBitsIn(J9JavaAccessFlags.J9AccForwarderMethod);
    }

    public static boolean isEmpty(J9ROMMethodPointer method) throws CorruptDataException {
        return method.modifiers().allBitsIn(J9JavaAccessFlags.J9AccEmptyMethod);
    }

    public static boolean hasVTable(J9ROMMethodPointer method) throws CorruptDataException {
        return method.modifiers().allBitsIn(J9JavaAccessFlags.J9AccMethodVTable);
    }

    public static boolean isStatic(J9ROMMethodPointer method) throws CorruptDataException {
        return method.modifiers().allBitsIn(J9JavaAccessFlags.J9AccStatic);
    }

    public static boolean hasExceptionInfo(J9ROMMethodPointer method) throws CorruptDataException {
        return method.modifiers().allBitsIn(J9JavaAccessFlags.J9AccMethodHasExceptionInfo);
    }

    public static boolean hasBackwardBranches(J9ROMMethodPointer method) throws CorruptDataException {
        return method.modifiers().allBitsIn(J9JavaAccessFlags.J9AccMethodHasBackwardBranches);
    }

    public static boolean isAsyncInterruptable(J9ROMMethodPointer method) throws CorruptDataException {
        return method.modifiers().allBitsIn(J9JavaAccessFlags.J9AccMethodAsyncInterruptable);
    }

    public static boolean isDebuggable(J9ROMMethodPointer method) throws CorruptDataException {
        return method.modifiers().allBitsIn(J9JavaAccessFlags.J9AccMethodDebuggable);
    }

    public static boolean hasGenericSignature(J9ROMMethodPointer method) throws CorruptDataException {
        return method.modifiers().allBitsIn(J9JavaAccessFlags.J9AccMethodHasGenericSignature);
    }

    public static boolean hasManyIterationLoops(J9ROMMethodPointer method) throws CorruptDataException {
        return method.modifiers().allBitsIn(J9JavaAccessFlags.J9AccMethodHasManyIterationsLoops);
    }

    public static boolean hasMethodAnnotations(J9ROMMethodPointer method) throws CorruptDataException {
        return method.modifiers().allBitsIn(J9JavaAccessFlags.J9AccMethodHasMethodAnnotations);
    }

    public static boolean hasParameterAnnotations(J9ROMMethodPointer method) throws CorruptDataException {
        return method.modifiers().allBitsIn(J9JavaAccessFlags.J9AccMethodHasParameterAnnotations);
    }

    public static boolean hasDefaultAnnotation(J9ROMMethodPointer method) throws CorruptDataException {
        return method.modifiers().allBitsIn(J9JavaAccessFlags.J9AccMethodHasDefaultAnnotation);
    }

    public static boolean hasDebugInfo(J9ROMMethodPointer method) throws CorruptDataException {
        return method.modifiers().allBitsIn(J9JavaAccessFlags.J9AccMethodHasDebugInfo);
    }

    public static boolean hasStackMap(J9ROMMethodPointer method) throws CorruptDataException {
        return method.modifiers().allBitsIn(J9JavaAccessFlags.J9AccMethodHasStackMap);
    }

    public static boolean isNonEmptyObjectConstructor(J9ROMMethodPointer method) throws CorruptDataException {
        if (AlgorithmVersion.getVersionOf("ALG_OBJECT_CONSTRUCTOR_VERSION").getAlgorithmVersion() >= 1) {
            return method.modifiers().maskAndCompare(J9JavaAccessFlags.J9AccMethodObjectConstructor + J9JavaAccessFlags.J9AccEmptyMethod, J9JavaAccessFlags.J9AccMethodObjectConstructor);
        }
        return false;
    }
}

