/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm26.events.EventManager;
import com.ibm.j9ddr.vm26.j9.HashTable;
import com.ibm.j9ddr.vm26.j9.SlotIterator;
import com.ibm.j9ddr.vm26.j9.StringTable;
import com.ibm.j9ddr.vm26.j9.gc.GCExtensions;
import com.ibm.j9ddr.vm26.pointer.AbstractPointer;
import com.ibm.j9ddr.vm26.pointer.PointerPointer;
import com.ibm.j9ddr.vm26.pointer.VoidPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9HashTablePointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm26.pointer.generated.MM_GCExtensionsPointer;
import com.ibm.j9ddr.vm26.pointer.generated.MM_StringTablePointer;
import com.ibm.j9ddr.vm26.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm26.types.U32;
import com.ibm.j9ddr.vm26.types.UDATA;
import java.util.NoSuchElementException;

public class StringTable_V2
extends StringTable {
    protected StringHashFunction<PointerPointer> _hashFn;

    protected StringTable_V2(MM_StringTablePointer stringTable) throws CorruptDataException {
        this._stringTable = stringTable;
        this._tableCount = stringTable._tableCount().longValue();
        this._hashFn = new StringHashFunction();
    }

    public static StringTable from() throws CorruptDataException {
        MM_GCExtensionsPointer extensions = GCExtensions.getGCExtensionsPointer();
        return new StringTable_V2(extensions.stringTable());
    }

    @Override
    public StringTable.StringSlotIterator iterator() {
        return new StringTable.StringSlotIterator(){
            private SlotIterator<PointerPointer> hashTableIterator = null;
            protected long _currentIndex = 0L;

            @Override
            public boolean hasNext() {
                while (true) {
                    if (this.hashTableIterator != null) {
                        if (this.hashTableIterator.hasNext()) {
                            return true;
                        }
                        ++this._currentIndex;
                    }
                    if (this._currentIndex >= StringTable_V2.this._tableCount) {
                        this.hashTableIterator = null;
                        return false;
                    }
                    try {
                        J9HashTablePointer hashTable = J9HashTablePointer.cast(StringTable_V2.this._stringTable._table().at(this._currentIndex));
                        HashTable currentHashTable = StringTable_V2.this.getHashTable(hashTable);
                        this.hashTableIterator = currentHashTable.iterator();
                        continue;
                    }
                    catch (CorruptDataException e) {
                        EventManager.raiseCorruptDataEvent("Error getting next item", e, false);
                        continue;
                    }
                    break;
                }
            }

            @Override
            public J9ObjectPointer next() {
                if (this.hasNext()) {
                    PointerPointer next = (PointerPointer)this.hashTableIterator.next();
                    return J9ObjectPointer.cast(next);
                }
                throw new NoSuchElementException("There are no more items available through this iterator");
            }

            @Override
            public VoidPointer nextAddress() {
                if (this.hasNext()) {
                    return VoidPointer.cast(this.hashTableIterator.nextAddress());
                }
                throw new NoSuchElementException("There are no more items available through this iterator");
            }

            @Override
            public J9HashTablePointer getCurrentHashTable() throws CorruptDataException {
                return J9HashTablePointer.cast(StringTable_V2.this._stringTable._table().at(this._currentIndex));
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("The image is read only and cannot be modified.");
            }
        };
    }

    private HashTable<PointerPointer> getHashTable(J9HashTablePointer hashTable) throws CorruptDataException {
        HashTable<PointerPointer> result = HashTable.fromJ9HashTable(hashTable, false, PointerPointer.class, new StringHashFunction(), new StringComparatorFunction());
        return result;
    }

    private UDATA getTableIndex(UDATA hash) throws CorruptDataException {
        return hash.mod(this._stringTable._tableCount());
    }

    private J9HashTablePointer getTable(UDATA tableIndex) throws CorruptDataException {
        J9HashTablePointer hashTablePtr = J9HashTablePointer.cast(this._stringTable._table().at(tableIndex));
        return hashTablePtr;
    }

    @Override
    public J9ObjectPointer search(J9ObjectPointer objectPointer) throws CorruptDataException {
        UDATA hashCode = this._hashFn.hash(PointerPointer.cast(objectPointer));
        UDATA tableIndex = this.getTableIndex(hashCode);
        J9HashTablePointer hashTablePtr = this.getTable(tableIndex);
        HashTable<J9ObjectPointer> currentHashTable = HashTable.fromJ9HashTable(hashTablePtr, false, J9ObjectPointer.class, new StringHashFunction(), new StringComparatorFunction());
        J9ObjectPointer result = currentHashTable.find(objectPointer);
        return result;
    }

    public static class StringHashFunction<StructType extends AbstractPointer>
    implements HashTable.HashFunction<StructType> {
        @Override
        public UDATA hash(StructType entry) {
            try {
                J9ObjectPointer entryObject = J9ObjectPointer.cast(entry);
                String stringValue = J9ObjectHelper.stringValue(entryObject);
                U32 hashCode = new U32(stringValue.hashCode());
                return new UDATA(hashCode);
            }
            catch (CorruptDataException e) {
                EventManager.raiseCorruptDataEvent("Error calculating hash", e, false);
                return new UDATA(0L);
            }
        }
    }

    public static class StringComparatorFunction<StructType extends AbstractPointer>
    implements HashTable.HashComparatorFunction<StructType> {
        @Override
        public int compare(StructType o1, StructType o2) throws CorruptDataException {
            J9ObjectPointer leftObject = J9ObjectPointer.cast(o1);
            J9ObjectPointer rightObject = J9ObjectPointer.cast(o2);
            String leftString = J9ObjectHelper.stringValue(leftObject);
            String rightString = J9ObjectHelper.stringValue(rightObject);
            return leftString.compareTo(rightString);
        }
    }

    public static class StringEqualFunction<StructType extends AbstractPointer>
    implements HashTable.HashEqualFunction<StructType> {
        @Override
        public boolean equal(StructType left, StructType right) {
            try {
                J9ObjectPointer leftObject = J9ObjectPointer.cast(left);
                J9ObjectPointer rightObject = J9ObjectPointer.cast(right);
                String leftString = J9ObjectHelper.stringValue(leftObject);
                String rightString = J9ObjectHelper.stringValue(rightObject);
                return leftString.equals(rightString);
            }
            catch (CorruptDataException e) {
                EventManager.raiseCorruptDataEvent("Error checking equality", e, true);
                return false;
            }
        }
    }
}

