/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm24.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm24.j9.walkers.SegmentIterator;
import com.ibm.j9ddr.vm24.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm24.pointer.generated.J9MemorySegmentListPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9MemorySegmentPointer;
import java.io.PrintStream;

public class SegmentsUtil {
    private static final String nl = System.getProperty("line.separator");

    public static void dbgDumpSegmentList(PrintStream out, J9MemorySegmentListPointer segmentListPointer) throws CorruptDataException {
        String fmt = null;
        if (J9BuildFlags.env_data64) {
            out.append("+----------------+----------------+----------------+----------------+--------+--------+\n");
            out.append("|    segment     |     start      |     alloc      |      end       |  type  |  size  |\n");
            out.append("+----------------+----------------+----------------+----------------+--------+--------+\n");
            fmt = " %016x %016x %016x %016x %016x %16x";
        } else {
            out.append("+--------+--------+--------+--------+--------+--------+\n");
            out.append("|segment | start  | alloc  |  end   |  type  |  size  |\n");
            out.append("+--------+--------+--------+--------+--------+--------+\n");
            fmt = " %08x %08x %08x %08x %08x %8x";
        }
        SegmentIterator segmentIterator = new SegmentIterator(segmentListPointer, -1L, false);
        while (segmentIterator.hasNext()) {
            J9MemorySegmentPointer seg = (J9MemorySegmentPointer)segmentIterator.next();
            String msg = String.format(fmt, seg.getAddress(), seg.heapBase().getAddress(), seg.heapAlloc().getAddress(), seg.heapTop().getAddress(), seg.type().longValue(), seg.size().longValue());
            out.append(msg);
            out.append(nl);
            seg = segmentListPointer.nextSegment();
        }
        if (J9BuildFlags.env_data64) {
            out.append("+----------------+----------------+----------------+----------------+--------+--------+\n");
        } else {
            out.append("+--------+--------+--------+--------+--------+--------+\n");
        }
        out.append(nl);
    }
}

