/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm24.j9.stackwalker;

import com.ibm.j9ddr.AddressedCorruptDataException;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.InvalidDataTypeException;
import com.ibm.j9ddr.vm24.events.EventManager;
import com.ibm.j9ddr.vm24.j9.AlgorithmPicker;
import com.ibm.j9ddr.vm24.j9.AlgorithmVersion;
import com.ibm.j9ddr.vm24.j9.BaseAlgorithm;
import com.ibm.j9ddr.vm24.j9.IAlgorithm;
import com.ibm.j9ddr.vm24.j9.ROMHelp;
import com.ibm.j9ddr.vm24.j9.stackmap.DebugLocalMap;
import com.ibm.j9ddr.vm24.j9.stackmap.LocalMap;
import com.ibm.j9ddr.vm24.j9.stackmap.StackMap;
import com.ibm.j9ddr.vm24.j9.stackwalker.FrameCallbackResult;
import com.ibm.j9ddr.vm24.j9.stackwalker.JITStackWalker;
import com.ibm.j9ddr.vm24.j9.stackwalker.StackWalkResult;
import com.ibm.j9ddr.vm24.j9.stackwalker.StackWalkerUtils;
import com.ibm.j9ddr.vm24.j9.stackwalker.WalkState;
import com.ibm.j9ddr.vm24.pointer.PointerPointer;
import com.ibm.j9ddr.vm24.pointer.U8Pointer;
import com.ibm.j9ddr.vm24.pointer.UDATAPointer;
import com.ibm.j9ddr.vm24.pointer.VoidPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm24.pointer.generated.J9ConstantPoolPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9I2JStatePointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9JITExceptionTablePointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9MethodPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9ROMMethodPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9SFJ2IFramePointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9SFJITResolveFramePointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9SFJNICallInFramePointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9SFMethodFramePointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9SFSpecialFramePointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9SFStackFramePointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm24.pointer.helper.J9ROMMethodHelper;
import com.ibm.j9ddr.vm24.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm24.structure.J9Consts;
import com.ibm.j9ddr.vm24.structure.J9JavaAccessFlags;
import com.ibm.j9ddr.vm24.structure.J9JavaVM;
import com.ibm.j9ddr.vm24.structure.J9SFJ2IFrame;
import com.ibm.j9ddr.vm24.structure.J9SFJNICallInFrame;
import com.ibm.j9ddr.vm24.structure.J9SFStackFrame;
import com.ibm.j9ddr.vm24.structure.J9StackWalkConstants;
import com.ibm.j9ddr.vm24.structure.J9StackWalkState;
import com.ibm.j9ddr.vm24.types.U8;
import com.ibm.j9ddr.vm24.types.UDATA;
import java.util.LinkedList;

public class StackWalker {
    private static final long LOCALS_ARRAY_UBOUND = 65792L;
    private static IStackWalker impl;
    private static final AlgorithmPicker<IStackWalker> picker;

    public static StackWalkResult walkStackFrames(WalkState walkState) {
        return StackWalker.getImpl().walkStackFrames(walkState);
    }

    static FrameCallbackResult walkFrame(WalkState walkState) throws CorruptDataException {
        return StackWalker.getImpl().walkFrame(walkState);
    }

    private static IStackWalker getImpl() {
        if (impl == null) {
            impl = picker.pickAlgorithm();
        }
        return impl;
    }

    static {
        picker = new AlgorithmPicker<IStackWalker>("ALG_STACKWALKER_VERSION"){

            @Override
            protected Iterable<? extends IStackWalker> allAlgorithms() {
                LinkedList<StackWalker_24_V0> toReturn = new LinkedList<StackWalker_24_V0>();
                toReturn.add(new StackWalker_24_V0());
                return toReturn;
            }
        };
    }

    private static class StackWalker_24_V0
    extends BaseAlgorithm
    implements IStackWalker {
        protected StackWalker_24_V0() {
            super(40, 0);
        }

        @Override
        public StackWalkResult walkStackFrames(WalkState walkState) {
            StackWalkResult rc = StackWalkResult.NONE;
            UDATAPointer nextA0 = null;
            U8Pointer nextPC = null;
            boolean endOfStackReached = false;
            boolean keepWalking = true;
            boolean startAtJITFrame = false;
            StackWalkerUtils.resetOSlotsCorruptionThreshold();
            if (AlgorithmVersion.getVersionOf("ALG_STACKWALKER_VERSION").getAlgorithmVersion() == 0 && (walkState.flags & J9Consts.J9_STACKWALK_SAVE_STACKED_REGISTERS) != 0L) {
                throw new UnsupportedOperationException("J9_STACKWALK_SAVE_STACKED_REGISTERS not supported by offline walker");
            }
            try {
                rc = walkState.walkThread.privateFlags().anyBitsIn(J9Consts.J9_PRIVATE_FLAGS_STACK_CORRUPT) ? StackWalkResult.STACK_CORRUPT : StackWalkResult.NONE;
                walkState.framesWalked = 0L;
                walkState.previousFrameFlags = new UDATA(0L);
                walkState.searchFrameFound = false;
                if (J9BuildFlags.interp_debugSupport) {
                    walkState.popProtectedFrame = null;
                }
                walkState.arg0EA = walkState.walkThread.arg0EA();
                walkState.pcAddress = walkState.walkThread.pcEA();
                walkState.pc = walkState.walkThread.pc();
                walkState.walkSP = walkState.walkThread.sp();
                walkState.literals = walkState.walkThread.literals();
                walkState.argCount = new U8(0L);
                if (J9BuildFlags.interp_nativeSupport) {
                    walkState.jitInfo = J9JITExceptionTablePointer.NULL;
                    walkState.inlineDepth = 0L;
                    walkState.inlinerMap = null;
                    walkState.walkedEntryLocalStorage = walkState.walkThread.entryLocalStorage();
                    walkState.i2jState = walkState.walkedEntryLocalStorage.notNull() ? walkState.walkedEntryLocalStorage.i2jState() : null;
                    walkState.j2iFrame = walkState.walkThread.j2iFrame();
                    if (J9BuildFlags.jit_fullSpeedDebug) {
                        walkState.decompilationStack = walkState.walkThread.decompilationStack();
                        walkState.resolveFrameFlags = new UDATA(0L);
                    }
                }
            }
            catch (CorruptDataException ex) {
                EventManager.raiseCorruptDataEvent("CDE thrown extracting initial stack walk state. walkThread = " + Long.toHexString(walkState.walkThread.getAddress()), ex, true);
                return StackWalkResult.STACK_CORRUPT;
            }
            StackWalkerUtils.swPrintf(walkState, 1, "*** BEGIN STACK WALK, flags = {0} walkThread = {1} ***", String.format("%08X", walkState.flags), Long.toHexString(walkState.walkThread.getAddress()));
            if ((walkState.flags & J9Consts.J9_STACKWALK_START_AT_JIT_FRAME) != 0L) {
                StackWalkerUtils.swPrintf(walkState, 2, "\tSTART_AT_JIT_FRAME", new Object[0]);
            }
            if ((walkState.flags & J9Consts.J9_STACKWALK_COUNT_SPECIFIED) != 0L) {
                StackWalkerUtils.swPrintf(walkState, 2, "\tCOUNT_SPECIFIED", new Object[0]);
            }
            if ((walkState.flags & J9Consts.J9_STACKWALK_INCLUDE_NATIVES) != 0L) {
                StackWalkerUtils.swPrintf(walkState, 2, "\tINCLUDE_NATIVES", new Object[0]);
            }
            if ((walkState.flags & J9Consts.J9_STACKWALK_INCLUDE_CALL_IN_FRAMES) != 0L) {
                StackWalkerUtils.swPrintf(walkState, 2, "\tINCLUDE_CALL_IN_FRAMES", new Object[0]);
            }
            if ((walkState.flags & J9Consts.J9_STACKWALK_ITERATE_FRAMES) != 0L) {
                StackWalkerUtils.swPrintf(walkState, 2, "\tITERATE_FRAMES", new Object[0]);
            }
            if ((walkState.flags & J9Consts.J9_STACKWALK_ITERATE_HIDDEN_JIT_FRAMES) != 0L) {
                StackWalkerUtils.swPrintf(walkState, 2, "\tITERATE_HIDDEN_JIT_FRAMES", new Object[0]);
            }
            if ((walkState.flags & J9Consts.J9_STACKWALK_ITERATE_O_SLOTS) != 0L) {
                StackWalkerUtils.swPrintf(walkState, 2, "\tITERATE_O_SLOTS", new Object[0]);
            }
            if ((walkState.flags & J9Consts.J9_STACKWALK_ITERATE_METHOD_CLASS_SLOTS) != 0L) {
                StackWalkerUtils.swPrintf(walkState, 2, "\tITERATE_METHOD_CLASS_SLOTS", new Object[0]);
            }
            if ((walkState.flags & J9Consts.J9_STACKWALK_MAINTAIN_REGISTER_MAP) != 0L) {
                StackWalkerUtils.swPrintf(walkState, 2, "\tMAINTAIN_REGISTER_MAP", new Object[0]);
            }
            if ((walkState.flags & J9Consts.J9_STACKWALK_SEARCH_BY_BP) != 0L) {
                StackWalkerUtils.swPrintf(walkState, 2, "\tSEARCH_BY_BP", new Object[0]);
            }
            if ((walkState.flags & J9Consts.J9_STACKWALK_SEARCH_BY_BP_ABOVE) != 0L) {
                StackWalkerUtils.swPrintf(walkState, 2, "\tSEARCH_BY_BP_ABOVE", new Object[0]);
            }
            if ((walkState.flags & J9Consts.J9_STACKWALK_SKIP_INLINES) != 0L) {
                StackWalkerUtils.swPrintf(walkState, 2, "\tSKIP_INLINES", new Object[0]);
            }
            if ((walkState.flags & J9Consts.J9_STACKWALK_VISIBLE_ONLY) != 0L) {
                StackWalkerUtils.swPrintf(walkState, 2, "\tVISIBLE_ONLY", new Object[0]);
            }
            if ((walkState.flags & J9Consts.J9_STACKWALK_HIDE_EXCEPTION_FRAMES) != 0L) {
                StackWalkerUtils.swPrintf(walkState, 2, "\tHIDE_EXCEPTION_FRAMES", new Object[0]);
            }
            if ((walkState.flags & J9Consts.J9_STACKWALK_RECORD_BYTECODE_PC_OFFSET) != 0L) {
                StackWalkerUtils.swPrintf(walkState, 2, "\tRECORD_BYTECODE_PC_OFFSET", new Object[0]);
            }
            StackWalkerUtils.swPrintf(walkState, 2, "Initial values: walkSP = " + StackWalkerUtils.formatPointer(walkState.walkSP) + ", PC = " + StackWalkerUtils.formatPointer(walkState.pc) + ", literals = " + StackWalkerUtils.formatPointer(walkState.literals) + ", A0 = " + StackWalkerUtils.formatPointer(walkState.arg0EA) + ", j2iFrame = " + (J9BuildFlags.interp_nativeSupport ? StackWalkerUtils.formatPointer(walkState.j2iFrame) : "0") + ", ELS = " + (J9BuildFlags.interp_nativeSupport ? StackWalkerUtils.formatPointer(walkState.walkedEntryLocalStorage) : "0") + ", decomp = " + (J9BuildFlags.jit_fullSpeedDebug ? StackWalkerUtils.formatPointer(walkState.decompilationStack) : "0"), new Object[0]);
            if ((walkState.flags & J9Consts.J9_STACKWALK_SEARCHING) != 0L) {
                StackWalkerUtils.swPrintf(walkState, 2, "Searching for BP " + StackWalkerUtils.formatPointer(walkState.searchValue), new Object[0]);
            }
            if ((walkState.flags & J9Consts.J9_STACKWALK_COUNT_SPECIFIED) != 0L && walkState.maxFrames == 0L) {
                keepWalking = false;
            }
            if (J9BuildFlags.interp_nativeSupport) {
                if (walkState.flags == J9Consts.J9_STACKWALK_ITERATE_O_SLOTS) {
                    walkState.flags |= J9Consts.J9_STACKWALK_SKIP_INLINES;
                }
                if ((walkState.flags & J9Consts.J9_STACKWALK_ITERATE_O_SLOTS) != 0L) {
                    walkState.flags |= J9Consts.J9_STACKWALK_MAINTAIN_REGISTER_MAP;
                }
                if ((walkState.flags & J9Consts.J9_STACKWALK_START_AT_JIT_FRAME) != 0L) {
                    startAtJITFrame = true;
                }
            }
            if ((walkState.flags & (J9Consts.J9_STACKWALK_ITERATE_FRAMES | J9Consts.J9_STACKWALK_ITERATE_O_SLOTS)) != 0L && walkState.callBacks == null) {
                throw new NullPointerException("User requested iterate frames or slots and didn't provide a callback. See WalkState.callBacks.");
            }
            try {
                while (keepWalking) {
                    StackWalkerUtils.swPrintf(walkState, 3, "Top of WALKING_LOOP", new Object[0]);
                    if (!startAtJITFrame) {
                        walkState.constantPool = J9ConstantPoolPointer.NULL;
                        walkState.unwindSP = UDATAPointer.NULL;
                        walkState.method = J9MethodPointer.NULL;
                        walkState.sp = walkState.walkSP.sub(walkState.argCount);
                        walkState.outgoingArgCount = walkState.argCount;
                        walkState.bytecodePCOffset = U8Pointer.cast(-1L);
                        StackWalkerUtils.swPrintf(walkState, 3, "walkState.pc={0}", StackWalkerUtils.formatPointer(walkState.pc));
                        if (walkState.pc.getAddress() == J9SFStackFrame.J9SF_FRAME_TYPE_END_OF_STACK) {
                            StackWalkerUtils.swPrintf(walkState, 3, "PC Switch: End of Stack", new Object[0]);
                            endOfStackReached = true;
                            break;
                        }
                        if (walkState.pc.getAddress() == J9SFStackFrame.J9SF_FRAME_TYPE_GENERIC_SPECIAL) {
                            StackWalkerUtils.swPrintf(walkState, 3, "PC Switch: Generic Special", new Object[0]);
                            this.walkGenericSpecialFrame(walkState);
                        } else if (walkState.pc.getAddress() == J9SFStackFrame.J9SF_FRAME_TYPE_METHOD || walkState.pc.getAddress() == J9SFStackFrame.J9SF_FRAME_TYPE_NATIVE_METHOD || walkState.pc.getAddress() == J9SFStackFrame.J9SF_FRAME_TYPE_JNI_NATIVE_METHOD) {
                            StackWalkerUtils.swPrintf(walkState, 3, "PC Switch: walkMethodFrame", new Object[0]);
                            this.walkMethodFrame(walkState);
                        } else if (J9BuildFlags.interp_nativeSupport && walkState.pc.getAddress() == J9SFStackFrame.J9SF_FRAME_TYPE_JIT_RESOLVE) {
                            StackWalkerUtils.swPrintf(walkState, 3, "PC Switch: JIT Resolve", new Object[0]);
                            this.walkJITResolveFrame(walkState);
                        } else if (J9BuildFlags.interp_nativeSupport && walkState.pc.getAddress() == J9SFStackFrame.J9SF_FRAME_TYPE_JIT_JNI_CALLOUT) {
                            StackWalkerUtils.swPrintf(walkState, 3, "PC Switch: JIT_JNI_CALLOUT", new Object[0]);
                            this.walkJITJNICalloutFrame(walkState);
                        } else {
                            StackWalkerUtils.swPrintf(walkState, 3, "PC Switch: default", new Object[0]);
                            if (new UDATA(walkState.pc.getAddress()).lte(new U8(J9SFStackFrame.J9SF_MAX_SPECIAL_FRAME_TYPE))) {
                                this.printFrameType(walkState, "Unknown");
                                StackWalkerUtils.swPrintf(walkState, 0, "Aborting walk due to unknown special frame type", new Object[0]);
                                break;
                            }
                            if (J9BuildFlags.interp_debugSupport && (walkState.pc.eq(walkState.walkThread.javaVM().popProtectedPC()) || walkState.pc.eq(walkState.walkThread.javaVM().popProtectedPC().addOffset(3L)))) {
                                walkState.pc = walkState.pc.sub(new UDATA(walkState.walkThread.javaVM().popProtectedPC().getAddress()).sub(new UDATA(walkState.walkThread.popProtectedSavedPC().getAddress())));
                                walkState.popProtectedFrame = walkState.bp;
                            }
                            if (walkState.pc.eq(walkState.walkThread.javaVM().callInReturnPC()) || walkState.pc.eq(walkState.walkThread.javaVM().callInReturnPC().addOffset(3L))) {
                                StackWalkerUtils.swPrintf(walkState, 3, "PC Switch: default: walkJNICallInFrame", new Object[0]);
                                this.walkJNICallInFrame(walkState);
                            } else {
                                StackWalkerUtils.swPrintf(walkState, 3, "PC Switch: default: walkBytecodeFrame", new Object[0]);
                                this.walkBytecodeFrame(walkState);
                            }
                        }
                        UDATA nextPCUDATA = new UDATA(walkState.bp.getAddress());
                        nextPCUDATA = nextPCUDATA.sub(J9SFStackFrame.SIZEOF);
                        nextPCUDATA = nextPCUDATA.add(UDATA.SIZEOF);
                        J9SFStackFramePointer tmpFrame = J9SFStackFramePointer.cast(nextPCUDATA);
                        nextPC = tmpFrame.savedPC();
                        if (this.walkFrame(walkState) != FrameCallbackResult.KEEP_ITERATING) break;
                        walkState.previousFrameFlags = walkState.frameFlags;
                    }
                    if (J9BuildFlags.interp_nativeSupport && ((walkState.frameFlags.longValue() & J9StackWalkConstants.J9_STACK_FLAGS_JIT_TRANSITION_TO_INTERPRETER) != 0L || startAtJITFrame)) {
                        startAtJITFrame = false;
                        if (JITStackWalker.jitWalkStackFrames(walkState) == FrameCallbackResult.KEEP_ITERATING) continue;
                        break;
                    }
                    J9SFStackFramePointer fixedStackFrame = J9SFStackFramePointer.cast(walkState.bp.subOffset(J9SFStackFrame.SIZEOF).addOffset(UDATA.SIZEOF));
                    J9MethodPointer nextLiterals = fixedStackFrame.savedCP();
                    nextA0 = UDATAPointer.cast(fixedStackFrame.savedA0()).untag();
                    walkState.pcAddress = fixedStackFrame.savedPCEA();
                    walkState.walkSP = walkState.arg0EA.add(1L);
                    walkState.pc = nextPC;
                    walkState.literals = nextLiterals;
                    walkState.arg0EA = nextA0;
                }
            }
            catch (CorruptDataException ex) {
                EventManager.raiseCorruptDataEvent("CorruptDataException thrown walking stack. walkThread = " + Long.toHexString(walkState.walkThread.getAddress()), ex, true);
                return StackWalkResult.STACK_CORRUPT;
            }
            if (endOfStackReached) {
                StackWalkerUtils.swPrintf(walkState, 2, "<end of stack>", new Object[0]);
                if ((walkState.flags & J9Consts.J9_STACKWALK_SEARCHING) != 0L) {
                    rc = StackWalkResult.FRAME_NOT_FOUND;
                    StackWalkerUtils.swPrintf(walkState, 2, "failed to find frame " + StackWalkerUtils.formatPointer(walkState.searchValue), new Object[0]);
                }
            }
            if (StackWalkerUtils.oSlotsCorruptionThresholdReached() && rc == StackWalkResult.NONE) {
                rc = StackWalkResult.STACK_CORRUPT;
            }
            StackWalkerUtils.swPrintf(walkState, 1, "*** END STACK WALK (rc = {0}) ***", new Object[]{rc});
            return rc;
        }

        private void walkMethodFrame(WalkState walkState) throws CorruptDataException {
            block21: {
                J9SFMethodFramePointer methodFrame = J9SFMethodFramePointer.cast(walkState.walkSP.addOffset(UDATA.cast(walkState.literals)));
                walkState.bp = UDATAPointer.cast(methodFrame.savedA0EA());
                walkState.frameFlags = methodFrame.specialFrameFlags();
                walkState.method = methodFrame.method();
                walkState.unwindSP = UDATAPointer.cast(methodFrame);
                if (walkState.pc.getAddress() == J9SFStackFrame.J9SF_FRAME_TYPE_METHOD) {
                    this.printFrameType(walkState, walkState.frameFlags.anyBitsIn(J9StackWalkConstants.J9_STACK_FLAGS_JIT_NATIVE_TRANSITION) ? "JIT generic transition" : "Generic method");
                } else if (walkState.pc.getAddress() == J9SFStackFrame.J9SF_FRAME_TYPE_NATIVE_METHOD) {
                    this.printFrameType(walkState, walkState.frameFlags.anyBitsIn(J9StackWalkConstants.J9_STACK_FLAGS_JIT_NATIVE_TRANSITION) ? "JIT INL transition" : "INL native method");
                } else if (walkState.pc.getAddress() == J9SFStackFrame.J9SF_FRAME_TYPE_JNI_NATIVE_METHOD) {
                    this.printFrameType(walkState, walkState.frameFlags.anyBitsIn(J9StackWalkConstants.J9_STACK_FLAGS_JIT_NATIVE_TRANSITION) ? "JIT JNI transition" : "JNI native method");
                } else {
                    this.printFrameType(walkState, walkState.frameFlags.anyBitsIn(J9StackWalkConstants.J9_STACK_FLAGS_JIT_NATIVE_TRANSITION) ? "JIT unknown transition" : "Unknown method");
                }
                if ((walkState.flags & J9Consts.J9_STACKWALK_ITERATE_O_SLOTS) != 0L && walkState.literals.notNull()) {
                    try {
                        if (walkState.frameFlags.anyBitsIn(J9Consts.J9_SSF_JNI_REFS_REDIRECTED)) {
                            this.walkPushedJNIRefs(walkState);
                        } else {
                            this.walkObjectPushes(walkState);
                        }
                    }
                    catch (CorruptDataException ex) {
                        StackWalkerUtils.handleOSlotsCorruption(walkState, "StackWalker_24_V0", "walkMethodFrame", ex);
                    }
                }
                if (walkState.method.notNull()) {
                    J9ROMMethodPointer romMethod = ROMHelp.J9_ROM_METHOD_FROM_RAM_METHOD(walkState.method);
                    walkState.constantPool = StackWalkerUtils.UNTAGGED_METHOD_CP(walkState.method);
                    walkState.argCount = romMethod.argCount();
                    if ((walkState.flags & J9Consts.J9_STACKWALK_ITERATE_O_SLOTS) != 0L) {
                        try {
                            StackWalkerUtils.WALK_METHOD_CLASS(walkState);
                            if (walkState.argCount.longValue() == 0L) break block21;
                            int[] result = new int[8];
                            StackWalkerUtils.swPrintf(walkState, 4, "\tUsing signature mapper", new Object[0]);
                            LocalMap.j9localmap_ArgBitsForPC0(romMethod, result);
                            StackWalkerUtils.swPrintf(walkState, 4, "\tArguments starting at {0} for {1} slots", StackWalkerUtils.formatPointer(walkState.arg0EA), walkState.argCount);
                            walkState.slotType = (int)J9StackWalkState.J9_STACKWALK_SLOT_TYPE_METHOD_LOCAL;
                            walkState.slotIndex = 0;
                            if (walkState.frameFlags.anyBitsIn(J9Consts.J9_SSF_JNI_REFS_REDIRECTED)) {
                                this.walkIndirectDescribedPushes(walkState, walkState.arg0EA, walkState.argCount.intValue(), result);
                                break block21;
                            }
                            this.walkDescribedPushes(walkState, walkState.arg0EA, walkState.argCount.intValue(), result);
                        }
                        catch (CorruptDataException ex) {
                            StackWalkerUtils.handleOSlotsCorruption(walkState, "StackWalker_24_V0", "walkMethodFrame", ex);
                        }
                    }
                } else {
                    if ((walkState.flags & J9Consts.J9_STACKWALK_ITERATE_O_SLOTS) != 0L && !walkState.arg0EA.eq(walkState.bp)) {
                        try {
                            this.walkJNIRefs(walkState, walkState.bp.add(1L), walkState.arg0EA.sub(walkState.bp).intValue());
                        }
                        catch (CorruptDataException ex) {
                            StackWalkerUtils.handleOSlotsCorruption(walkState, "StackWalker_24_V0", "walkMethodFrame", ex);
                        }
                        catch (InvalidDataTypeException e) {
                            CorruptDataException ex = new CorruptDataException("Corruption walking JNI references", e);
                            StackWalkerUtils.handleOSlotsCorruption(walkState, "StackWalker_24_V0", "walkMethodFrame", ex);
                        }
                    }
                    walkState.constantPool = null;
                    walkState.argCount = new U8(0L);
                }
            }
        }

        private void walkJNIRefs(WalkState walkState, UDATAPointer currentRef, int refCount) throws CorruptDataException {
            StackWalkerUtils.swPrintf(walkState, 4, "\tJNI local ref pushes starting at {0} for {1} slots", StackWalkerUtils.formatPointer(currentRef), refCount);
            walkState.slotType = (int)J9StackWalkState.J9_STACKWALK_SLOT_TYPE_JNI_LOCAL;
            walkState.slotIndex = 0;
            do {
                if (currentRef.at(0L).anyBitsIn(1L)) {
                    PointerPointer realRef = PointerPointer.cast(currentRef.at(0L).bitAnd(new UDATA(1L).bitNot()));
                    StackWalkerUtils.WALK_INDIRECT_O_SLOT(walkState, realRef, VoidPointer.cast(currentRef));
                } else {
                    StackWalkerUtils.WALK_O_SLOT(walkState, PointerPointer.cast(currentRef));
                }
                currentRef = currentRef.add(1L);
                ++walkState.slotIndex;
            } while (--refCount > 0);
        }

        private void walkIndirectDescribedPushes(WalkState walkState, UDATAPointer highestIndirectSlot, int slotCount, int[] descriptionSlots) throws CorruptDataException {
            int descriptionBitsRemaining = 0;
            int description = 0;
            int descriptionSlotPointer = 0;
            while (slotCount > 0) {
                if (descriptionBitsRemaining == 0) {
                    description = descriptionSlots[descriptionSlotPointer++];
                    descriptionBitsRemaining = 32;
                }
                if (description & true) {
                    StackWalkerUtils.WALK_INDIRECT_O_SLOT(walkState, PointerPointer.cast(highestIndirectSlot.at(0L).bitAnd(new UDATA(1L).bitNot())), VoidPointer.cast(highestIndirectSlot));
                } else {
                    StackWalkerUtils.WALK_INDIRECT_I_SLOT(walkState, PointerPointer.cast(highestIndirectSlot.at(0L).bitAnd(new UDATA(1L).bitNot())), VoidPointer.cast(highestIndirectSlot));
                }
                description >>= 1;
                --descriptionBitsRemaining;
                highestIndirectSlot = highestIndirectSlot.sub(1L);
                --slotCount;
                ++walkState.slotIndex;
            }
        }

        private void walkObjectPushes(WalkState walkState) throws CorruptDataException {
            UDATA byteCount = UDATA.cast(walkState.literals);
            PointerPointer currentSlot = PointerPointer.cast(walkState.walkSP);
            StackWalkerUtils.swPrintf(walkState, 4, "\tObject pushes starting at {0} for {1} slots", StackWalkerUtils.formatPointer(currentSlot), byteCount.longValue() / (long)UDATA.SIZEOF);
            walkState.slotType = (int)J9StackWalkState.J9_STACKWALK_SLOT_TYPE_INTERNAL;
            walkState.slotIndex = 0;
            while (!byteCount.eq(0L)) {
                StackWalkerUtils.WALK_O_SLOT(walkState, currentSlot);
                currentSlot = currentSlot.add(1L);
                byteCount = byteCount.sub(UDATA.SIZEOF);
                ++walkState.slotIndex;
            }
        }

        private void walkPushedJNIRefs(WalkState walkState) throws CorruptDataException {
            UDATA refCount = walkState.frameFlags.bitAnd(J9Consts.J9_SSF_JNI_PUSHED_REF_COUNT_MASK);
            UDATA pushCount = new UDATA(walkState.literals.getAddress() / (long)UDATA.SIZEOF).sub(refCount);
            if (!pushCount.eq(0L)) {
                walkState.literals = J9MethodPointer.cast(pushCount.longValue() * (long)UDATA.SIZEOF);
                this.walkObjectPushes(walkState);
            }
            if (!refCount.eq(0L)) {
                this.walkJNIRefs(walkState, walkState.walkSP.add(pushCount), refCount.intValue());
            }
        }

        @Override
        public FrameCallbackResult walkFrame(WalkState walkState) throws CorruptDataException {
            block12: {
                block13: {
                    if ((walkState.flags & J9Consts.J9_STACKWALK_VISIBLE_ONLY) != 0L) {
                        J9ROMMethodPointer romMethod;
                        if ((UDATA.cast(walkState.pc).eq(J9SFStackFrame.J9SF_FRAME_TYPE_NATIVE_METHOD) || UDATA.cast(walkState.pc).eq(J9SFStackFrame.J9SF_FRAME_TYPE_JNI_NATIVE_METHOD)) && (walkState.flags & J9Consts.J9_STACKWALK_INCLUDE_NATIVES) == 0L) {
                            return FrameCallbackResult.KEEP_ITERATING;
                        }
                        if (!(J9BuildFlags.interp_nativeSupport && !walkState.jitInfo.isNull() || !walkState.bp.at(0L).anyBitsIn(J9SFStackFrame.J9SF_A0_INVISIBLE_TAG) || (walkState.flags & J9Consts.J9_STACKWALK_INCLUDE_CALL_IN_FRAMES) != 0L && walkState.pc.eq(walkState.walkThread.javaVM().callInReturnPC()))) {
                            return FrameCallbackResult.KEEP_ITERATING;
                        }
                        if (walkState.skipCount > 0) {
                            --walkState.skipCount;
                            return FrameCallbackResult.KEEP_ITERATING;
                        }
                        if ((walkState.flags & J9Consts.J9_STACKWALK_HIDE_EXCEPTION_FRAMES) != 0L && !(romMethod = ROMHelp.J9_ROM_METHOD_FROM_RAM_METHOD(walkState.method)).modifiers().anyBitsIn(J9Consts.J9_JAVA_STATIC)) {
                            if (J9UTF8Helper.stringValue(romMethod.nameAndSignature().name()).charAt(0) == '<' && walkState.arg0EA.at(0L).eq(UDATA.cast(walkState.restartException))) {
                                return FrameCallbackResult.KEEP_ITERATING;
                            }
                            walkState.flags &= J9Consts.J9_STACKWALK_HIDE_EXCEPTION_FRAMES ^ 0xFFFFFFFFFFFFFFFFL;
                        }
                    }
                    ++walkState.framesWalked;
                    if ((walkState.flags & J9Consts.J9_STACKWALK_COUNT_SPECIFIED) != 0L && walkState.framesWalked == walkState.maxFrames || (walkState.flags & J9Consts.J9_STACKWALK_ITERATE_FRAMES) != 0L) break block12;
                    if ((walkState.flags & J9Consts.J9_STACKWALK_SEARCHING) == 0L) break block13;
                    if ((walkState.flags & J9Consts.J9_STACKWALK_SEARCH_BY_BP_ABOVE) != 0L && walkState.searchFrameFound) break block12;
                    if (walkState.bp.equals(walkState.searchValue) && (!J9BuildFlags.interp_nativeSupport || walkState.inlineDepth == 0L)) {
                        walkState.searchFrameFound = true;
                    }
                    if ((walkState.flags & J9Consts.J9_STACKWALK_SEARCH_BY_BP) != 0L && walkState.searchFrameFound) break block12;
                }
                return FrameCallbackResult.KEEP_ITERATING;
            }
            if ((walkState.flags & J9Consts.J9_STACKWALK_ITERATE_FRAMES) != 0L) {
                FrameCallbackResult rc = walkState.callBacks.frameWalkFunction(walkState.walkThread, walkState);
                if ((walkState.flags & J9Consts.J9_STACKWALK_COUNT_SPECIFIED) != 0L && walkState.framesWalked == walkState.maxFrames) {
                    rc = FrameCallbackResult.STOP_ITERATING;
                }
                return rc;
            }
            return FrameCallbackResult.STOP_ITERATING;
        }

        private void walkBytecodeFrame(WalkState walkState) throws CorruptDataException {
            walkState.method = walkState.literals;
            if (J9BuildFlags.jit_microJit) {
                walkState.pc = this.findRealPCFromPCandMethod(walkState.walkThread, walkState.pc, walkState.method);
            }
            walkState.constantPool = StackWalkerUtils.UNTAGGED_METHOD_CP(walkState.method);
            walkState.bytecodePCOffset = walkState.pc.sub(walkState.method.bytecodes().getAddress());
            if (walkState.method.isNull()) {
                walkState.bp = UDATAPointer.cast(0L);
                walkState.unwindSP = UDATAPointer.cast(0L);
                walkState.frameFlags = new UDATA(0L);
                this.printFrameType(walkState, "BAD bytecode (expect crash)");
            }
            J9ROMMethodPointer romMethod = ROMHelp.getOriginalROMMethod(walkState.method);
            walkState.argCount = ROMHelp.J9_ARG_COUNT_FROM_ROM_METHOD(romMethod);
            UDATA argTempCount = new UDATA(ROMHelp.J9_TEMP_COUNT_FROM_ROM_METHOD(romMethod)).add(walkState.argCount);
            walkState.bp = UDATAPointer.cast(walkState.arg0EA).sub(argTempCount);
            if (J9BuildFlags.opt_realTimeExtensions && romMethod.modifiers().anyBitsIn(J9JavaAccessFlags.J9AccMethodAsyncInterruptable)) {
                walkState.bp = walkState.bp.sub(1L);
            }
            if (romMethod.modifiers().anyBitsIn(J9JavaAccessFlags.J9AccSynchronized)) {
                walkState.bp = walkState.bp.sub(1L);
            } else if (J9ROMMethodHelper.isNonEmptyObjectConstructor(romMethod)) {
                walkState.bp = walkState.bp.sub(1L);
            }
            if (J9BuildFlags.interp_nativeSupport && walkState.bp.eq(walkState.j2iFrame)) {
                walkState.unwindSP = walkState.bp.subOffset(J9SFJ2IFrame.SIZEOF).addOffset(UDATA.SIZEOF);
                walkState.frameFlags = J9SFJ2IFramePointer.cast(walkState.unwindSP).specialFrameFlags();
            } else {
                walkState.unwindSP = walkState.bp.subOffset(J9SFStackFrame.SIZEOF).addOffset(UDATA.SIZEOF);
                walkState.frameFlags = new UDATA(0L);
            }
            this.printFrameType(walkState, walkState.frameFlags.intValue() != 0 ? "J2I" : "Bytecode");
            if (J9BuildFlags.opt_realTimeExtensions && romMethod.modifiers().anyBitsIn(J9JavaAccessFlags.J9AccMethodAsyncInterruptable)) {
                StackWalkerUtils.swPrintf(walkState, 3, "\tMethod is AI, defer count = {0}", walkState.bp.at(romMethod.modifiers().anyBitsIn(J9JavaAccessFlags.J9AccSynchronized) ? 2L : 1L));
            }
            StackWalkerUtils.swPrintf(walkState, 3, "\tBytecode index = {0}", walkState.bytecodePCOffset.getAddress());
            if ((walkState.flags & J9Consts.J9_STACKWALK_ITERATE_O_SLOTS) != 0L) {
                try {
                    UDATA pushCount = new UDATA(walkState.unwindSP.sub(walkState.walkSP));
                    J9ROMClassPointer romClass = walkState.constantPool.ramClass().romClass();
                    StackWalkerUtils.WALK_METHOD_CLASS(walkState);
                    if (romMethod.modifiers().anyBitsIn(J9JavaAccessFlags.J9AccSynchronized)) {
                        StackWalkerUtils.swPrintf(walkState, 4, "\tSync object for synchronized method", new Object[0]);
                        walkState.slotType = (int)J9StackWalkState.J9_STACKWALK_SLOT_TYPE_INTERNAL;
                        walkState.slotIndex = -1;
                        StackWalkerUtils.WALK_O_SLOT(walkState, PointerPointer.cast(walkState.bp.add(1L)));
                    } else if (J9ROMMethodHelper.isNonEmptyObjectConstructor(romMethod)) {
                        StackWalkerUtils.swPrintf(walkState, 4, "\tReceiver object for java.lang.Object.<init>\n", new Object[0]);
                        walkState.slotType = (int)J9StackWalkState.J9_STACKWALK_SLOT_TYPE_INTERNAL;
                        walkState.slotIndex = -1;
                        StackWalkerUtils.WALK_O_SLOT(walkState, PointerPointer.cast(walkState.bp.add(1L)));
                    }
                    StackWalkerUtils.swPrintf(walkState, 4, "argTempCount={0}, pushCount={1}", argTempCount, pushCount);
                    int resultArraySize = 0;
                    if (argTempCount.gt(32) || pushCount.gt(32)) {
                        UDATA maxCount = argTempCount.gt(pushCount) ? argTempCount : pushCount;
                        resultArraySize = maxCount.add(31L).rightShift(5).intValue();
                        if (resultArraySize <= 0 || (long)resultArraySize > 65792L) {
                            throw new CorruptDataException("Corrupt frame detected : " + walkState.pc.longValue());
                        }
                    } else {
                        resultArraySize = 1;
                    }
                    StackWalkerUtils.swPrintf(walkState, 4, "Result array size = {0}", resultArraySize);
                    int[] result = new int[resultArraySize];
                    if (argTempCount.intValue() != 0) {
                        StackWalker_24_V0.getLocalsMap(walkState, romClass, romMethod, walkState.bytecodePCOffset, result, argTempCount);
                        StackWalkerUtils.swPrintf(walkState, 4, "Locals starting at {0} for {1} slots", StackWalkerUtils.formatPointer(walkState.arg0EA), argTempCount);
                        walkState.slotType = (int)J9StackWalkState.J9_STACKWALK_SLOT_TYPE_METHOD_LOCAL;
                        walkState.slotIndex = 0;
                        this.walkDescribedPushes(walkState, walkState.arg0EA, argTempCount.intValue(), result);
                    }
                    if (pushCount.intValue() != 0) {
                        this.getStackMap(walkState, romClass, romMethod, UDATA.cast(walkState.bytecodePCOffset), pushCount, result);
                        StackWalkerUtils.swPrintf(walkState, 4, "\tPending stack starting at {0} for {1} slots", StackWalkerUtils.formatPointer(walkState.unwindSP.sub(1L)), pushCount);
                        walkState.slotType = (int)J9StackWalkState.J9_STACKWALK_SLOT_TYPE_PENDING;
                        walkState.slotIndex = 0;
                        this.walkDescribedPushes(walkState, walkState.unwindSP.sub(1L), pushCount.intValue(), result);
                    }
                }
                catch (CorruptDataException ex) {
                    StackWalkerUtils.handleOSlotsCorruption(walkState, "StackWalker_24_V0", "walkBytecodeFrame", ex);
                }
            }
        }

        private void getStackMap(WalkState walkState, J9ROMClassPointer romClass, J9ROMMethodPointer romMethod, UDATA offsetPC, UDATA pushCount, int[] result) throws CorruptDataException {
            int errorCode = StackMap.j9stackmap_StackBitsForPC(offsetPC, romClass, romMethod, result, pushCount.intValue());
            if (errorCode < 0) {
                throw new AddressedCorruptDataException(romMethod.getAddress(), "Stack map failed, result = " + errorCode);
            }
        }

        private void walkDescribedPushes(WalkState walkState, UDATAPointer highestSlot, int slotCount, int[] descriptionSlots) throws CorruptDataException {
            int descriptionBitsRemaining = 0;
            int description = 0;
            int descriptionSlotPointer = 0;
            while (slotCount > 0) {
                if (descriptionBitsRemaining == 0) {
                    description = descriptionSlots[descriptionSlotPointer++];
                    descriptionBitsRemaining = 32;
                }
                if (description & true) {
                    StackWalkerUtils.WALK_O_SLOT(walkState, PointerPointer.cast(highestSlot));
                } else {
                    StackWalkerUtils.WALK_I_SLOT(walkState, PointerPointer.cast(highestSlot));
                }
                description >>= 1;
                --descriptionBitsRemaining;
                highestSlot = highestSlot.sub(1L);
                --slotCount;
                ++walkState.slotIndex;
            }
        }

        private static void getLocalsMap(WalkState walkState, J9ROMClassPointer romClass, J9ROMMethodPointer romMethod, U8Pointer offsetPC, int[] result, UDATA argTempCount) throws CorruptDataException {
            int errorCode;
            if (walkState.bp.at(0L).anyBitsIn(J9SFStackFrame.J9SF_A0_INVISIBLE_TAG) || walkState.previousFrameFlags.anyBitsIn(J9Consts.J9_SSF_METHOD_ENTRY)) {
                if (walkState.bp.at(0L).anyBitsIn(J9SFStackFrame.J9SF_A0_INVISIBLE_TAG)) {
                    StackWalkerUtils.swPrintf(walkState, 4, "\tAt method entry (hidden bytecode frame = monitor enter/stack grow), using signature mapper", new Object[0]);
                } else {
                    StackWalkerUtils.swPrintf(walkState, 4, "\tAt method entry (previous frame = report monitor enter), using signature mapper", new Object[0]);
                }
                LocalMap.j9localmap_ArgBitsForPC0(romMethod, result);
                return;
            }
            if (walkState.walkThread.javaVM().requiredDebugAttributes().anyBitsIn(J9JavaVM.J9VM_DEBUG_ATTRIBUTE_LOCAL_VARIABLE_TABLE)) {
                StackWalkerUtils.swPrintf(walkState, 4, "\tUsing debug local mapper", new Object[0]);
                errorCode = DebugLocalMap.j9localmap_DebugLocalBitsForPC(romMethod, UDATA.cast(offsetPC), result);
            } else {
                StackWalkerUtils.swPrintf(walkState, 4, "\tUsing local mapper", new Object[0]);
                errorCode = LocalMap.j9localmap_LocalBitsForPC(romMethod, UDATA.cast(offsetPC), result);
            }
            if (errorCode < 0) {
                StackWalkerUtils.swPrintf(walkState, 3, "Local map failed, result = {0}", errorCode);
                throw new CorruptDataException("Local map failed thread " + StackWalkerUtils.formatPointer(walkState.walkThread) + ", romMethod = " + StackWalkerUtils.formatPointer(romMethod) + ", result - " + errorCode);
            }
        }

        private U8Pointer findRealPCFromPCandMethod(J9VMThreadPointer walkThread, U8Pointer pc, J9MethodPointer method) {
            return pc;
        }

        private void walkJNICallInFrame(WalkState walkState) throws CorruptDataException {
            walkState.bp = walkState.arg0EA;
            J9SFJNICallInFramePointer callInFrame = J9SFJNICallInFramePointer.cast(walkState.bp.subOffset(J9SFJNICallInFrame.SIZEOF).addOffset(UDATA.SIZEOF));
            walkState.unwindSP = UDATAPointer.cast(callInFrame.subOffset(UDATA.cast(walkState.literals)));
            walkState.frameFlags = callInFrame.specialFrameFlags();
            this.printFrameType(walkState, "JNI call-in");
            if ((walkState.flags & J9Consts.J9_STACKWALK_ITERATE_O_SLOTS) != 0L) {
                try {
                    if (!walkState.walkSP.eq(walkState.unwindSP)) {
                        if (!walkState.pc.eq(walkState.walkThread.javaVM().callInReturnPC().add(3L))) {
                            StackWalkerUtils.swPrintf(walkState, 0, "Error: PC should have been advanced in order to push return value, pc = {0}, cipc = {1} !!!", StackWalkerUtils.formatPointer(walkState.pc), StackWalkerUtils.formatPointer(walkState.walkThread.javaVM().callInReturnPC()));
                        }
                        if (walkState.frameFlags.anyBitsIn(J9Consts.J9_SSF_RETURNS_OBJECT)) {
                            StackWalkerUtils.swPrintf(walkState, 4, "\tObject push (return value from call-in method)", new Object[0]);
                            StackWalkerUtils.WALK_O_SLOT(walkState, PointerPointer.cast(walkState.walkSP));
                        } else {
                            StackWalkerUtils.swPrintf(walkState, 2, "\tCall-in return value (non-object) takes {0} slots at {1}", UDATA.cast(walkState.unwindSP).sub(UDATA.cast(walkState.walkSP)), StackWalkerUtils.formatPointer(walkState.walkSP));
                        }
                        walkState.walkSP = walkState.unwindSP;
                    }
                    if (walkState.literals.notNull()) {
                        this.walkObjectPushes(walkState);
                    }
                }
                catch (CorruptDataException ex) {
                    StackWalkerUtils.handleOSlotsCorruption(walkState, "StackWalker_24_V0", "walkJNICallInFrame", ex);
                }
            }
            if (J9BuildFlags.interp_nativeSupport) {
                walkState.walkedEntryLocalStorage = walkState.walkedEntryLocalStorage.oldEntryLocalStorage();
                walkState.i2jState = walkState.walkedEntryLocalStorage.getAddress() != 0L ? J9I2JStatePointer.cast(walkState.walkedEntryLocalStorage.i2jStateEA()) : J9I2JStatePointer.cast(0L);
                StackWalkerUtils.swPrintf(walkState, 2, "\tNew ELS = {0}", StackWalkerUtils.formatPointer(walkState.walkedEntryLocalStorage));
            }
            walkState.argCount = new U8(0L);
        }

        private void printFrameType(WalkState walkState, String frameType) throws CorruptDataException {
            StackWalkerUtils.swPrintf(walkState, 2, "{0} frame: bp = {1}, sp = {2}, pc = {3}, cp = {4}, arg0EA = {5}, flags = {6}", frameType, StackWalkerUtils.formatPointer(walkState.bp), StackWalkerUtils.formatPointer(walkState.walkSP), StackWalkerUtils.formatPointer(walkState.pc), StackWalkerUtils.formatPointer(walkState.constantPool), StackWalkerUtils.formatPointer(walkState.arg0EA), walkState.frameFlags);
            StackWalkerUtils.swPrintMethod(walkState);
        }

        private void walkJITJNICalloutFrame(WalkState walkState) throws CorruptDataException {
            J9SFMethodFramePointer methodFrame = J9SFMethodFramePointer.cast(walkState.walkSP.addOffset(UDATA.cast(walkState.literals)));
            walkState.argCount = new U8(0L);
            walkState.bp = UDATAPointer.cast(methodFrame.savedA0EA());
            walkState.frameFlags = methodFrame.specialFrameFlags();
            walkState.method = methodFrame.method();
            walkState.constantPool = StackWalkerUtils.UNTAGGED_METHOD_CP(walkState.method);
            this.printFrameType(walkState, "JIT JNI call-out");
            if ((walkState.flags & J9Consts.J9_STACKWALK_ITERATE_O_SLOTS) != 0L) {
                try {
                    StackWalkerUtils.WALK_METHOD_CLASS(walkState);
                    if (walkState.literals.notNull()) {
                        this.walkPushedJNIRefs(walkState);
                    }
                }
                catch (CorruptDataException ex) {
                    StackWalkerUtils.handleOSlotsCorruption(walkState, "StackWalker_24_V0", "walkJITJNICalloutFrame", ex);
                }
            }
        }

        private void walkJITResolveFrame(WalkState walkState) throws CorruptDataException {
            J9SFJITResolveFramePointer jitResolveFrame = J9SFJITResolveFramePointer.cast(walkState.walkSP.addOffset(UDATA.cast(walkState.literals)));
            walkState.argCount = new U8(0L);
            walkState.bp = UDATAPointer.cast(jitResolveFrame.taggedRegularReturnSPEA());
            walkState.frameFlags = jitResolveFrame.specialFrameFlags();
            this.printFrameType(walkState, "JIT resolve");
            if ((walkState.flags & J9Consts.J9_STACKWALK_ITERATE_O_SLOTS) != 0L) {
                try {
                    PointerPointer savedJITExceptionSlot = jitResolveFrame.savedJITExceptionEA();
                    StackWalkerUtils.swPrintf(walkState, 4, "\tObject push (savedJITException)", new Object[0]);
                    StackWalkerUtils.WALK_O_SLOT(walkState, savedJITExceptionSlot);
                    if (walkState.literals.notNull()) {
                        this.walkObjectPushes(walkState);
                    }
                }
                catch (CorruptDataException ex) {
                    StackWalkerUtils.handleOSlotsCorruption(walkState, "StackWalker_24_V0", "walkJITResolveFrame", ex);
                }
            }
        }

        private void walkGenericSpecialFrame(WalkState walkState) throws CorruptDataException {
            J9SFSpecialFramePointer specialFrame = J9SFSpecialFramePointer.cast(walkState.walkSP.addOffset(UDATA.cast(walkState.literals)));
            walkState.bp = UDATAPointer.cast(specialFrame.savedA0EA());
            walkState.frameFlags = specialFrame.specialFrameFlags();
            this.printFrameType(walkState, "Generic special");
            if ((walkState.flags & J9Consts.J9_STACKWALK_ITERATE_O_SLOTS) != 0L && walkState.literals.notNull()) {
                try {
                    this.walkObjectPushes(walkState);
                }
                catch (CorruptDataException ex) {
                    StackWalkerUtils.handleOSlotsCorruption(walkState, "StackWalker_24_V0", "walkGenericSpecialFrame", ex);
                }
            }
            walkState.argCount = new U8(0L);
        }

        @Override
        public boolean matches(AlgorithmVersion version) {
            if (version.getAlgorithmVersion() == 1) {
                return true;
            }
            return super.matches(version);
        }
    }

    private static interface IStackWalker
    extends IAlgorithm {
        public StackWalkResult walkStackFrames(WalkState var1);

        public FrameCallbackResult walkFrame(WalkState var1) throws CorruptDataException;
    }
}

