/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm24.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm24.j9.ObjectMonitor;
import com.ibm.j9ddr.vm24.j9.walkers.ThreadListIterator;
import com.ibm.j9ddr.vm24.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm24.pointer.generated.J9ObjectMonitorPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9ThreadAbstractMonitorPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9ThreadPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm24.pointer.helper.J9ThreadHelper;
import com.ibm.j9ddr.vm24.structure.J9Consts;
import com.ibm.j9ddr.vm24.structure.J9Object;
import com.ibm.j9ddr.vm24.types.UDATA;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

class ObjectMonitor_V1
extends ObjectMonitor {
    private static HashMap<J9ObjectPointer, List<J9VMThreadPointer>> blockedThreadsCache;
    private J9VMThreadPointer owner;
    private long count;
    private boolean isInflated;
    private J9ObjectPointer object;
    private J9ObjectMonitorPointer lockword;
    private J9ThreadAbstractMonitorPointer monitor;
    private ArrayList<J9VMThreadPointer> waitingThreads;
    private ArrayList<J9VMThreadPointer> blockedThreads;
    private boolean ownerAndCountInitialized = false;

    protected ObjectMonitor_V1(J9ObjectPointer object) throws CorruptDataException {
        this.object = object;
        this.initializeLockword();
    }

    @Override
    public J9ObjectPointer getObject() {
        return this.object;
    }

    @Override
    public J9ObjectMonitorPointer getLockword() {
        return this.lockword;
    }

    @Override
    public J9ThreadAbstractMonitorPointer getInflatedMonitor() {
        return this.monitor;
    }

    @Override
    public J9VMThreadPointer getOwner() throws CorruptDataException {
        if (!this.ownerAndCountInitialized) {
            this.initializeOwnerAndCount();
        }
        return this.owner;
    }

    @Override
    public long getCount() throws CorruptDataException {
        if (!this.ownerAndCountInitialized) {
            this.initializeOwnerAndCount();
        }
        return this.count;
    }

    @Override
    public boolean isInflated() {
        return this.isInflated;
    }

    @Override
    public List<J9VMThreadPointer> getWaitingThreads() throws CorruptDataException {
        if (this.waitingThreads == null) {
            this.initializeWaitingThreads();
        }
        return this.waitingThreads;
    }

    @Override
    public List<J9VMThreadPointer> getBlockedThreads() throws CorruptDataException {
        if (this.blockedThreads == null) {
            this.initializeBlockedThreads();
        }
        return this.blockedThreads;
    }

    @Override
    public boolean isContended() throws CorruptDataException {
        if (this.isInflated) {
            return this.getBlockedThreads().size() > 0;
        }
        return this.lockword.allBitsIn(J9Object.OBJECT_HEADER_LOCK_FLC);
    }

    private void initializeOwnerAndCount() throws CorruptDataException {
        if (this.isInflated) {
            J9ThreadPointer osOwner = this.monitor.owner();
            if (osOwner.notNull()) {
                this.owner = J9ThreadHelper.getVMThread(osOwner);
                this.count = this.monitor.count().longValue();
                if (this.count == 0L) {
                    this.owner = J9VMThreadPointer.NULL;
                }
            }
        } else {
            this.owner = J9VMThreadPointer.cast(this.lockword.untag(J9Object.OBJECT_HEADER_LOCK_BITS_MASK));
            if (this.owner.notNull()) {
                UDATA base = UDATA.cast(this.lockword).bitAnd(J9Object.OBJECT_HEADER_LOCK_BITS_MASK).rightShift((int)J9Object.OBJECT_HEADER_LOCK_RECURSION_OFFSET);
                if (J9BuildFlags.thr_lockReservation) {
                    if (!this.lockword.allBitsIn(J9Object.OBJECT_HEADER_LOCK_RESERVED)) {
                        base = base.add(1L);
                    }
                    this.count = base.longValue();
                } else {
                    this.count = base.add(1L).longValue();
                }
                if (this.count == 0L) {
                    this.owner = J9VMThreadPointer.NULL;
                }
            }
        }
        this.ownerAndCountInitialized = true;
    }

    private void initializeWaitingThreads() throws CorruptDataException {
        this.waitingThreads = new ArrayList();
        if (!this.isInflated) {
            return;
        }
        J9ThreadPointer thread = this.monitor.waiting();
        while (thread.notNull()) {
            J9VMThreadPointer vmThread = J9ThreadHelper.getVMThread(thread);
            if (vmThread.notNull()) {
                this.waitingThreads.add(vmThread);
            }
            thread = thread.next();
        }
    }

    private void initializeBlockedThreads() throws CorruptDataException {
        this.blockedThreads = new ArrayList();
        if (this.isInflated) {
            if (J9BuildFlags.thr_threeTierLocking) {
                J9ThreadPointer thread = this.monitor.blocking();
                while (thread.notNull()) {
                    J9VMThreadPointer vmThread = J9ThreadHelper.getVMThread(thread);
                    if (vmThread.notNull()) {
                        this.blockedThreads.add(vmThread);
                    }
                    thread = thread.next();
                }
            } else {
                List<J9VMThreadPointer> list = ObjectMonitor_V1.getBlockedThreads(this.object);
                if (list != null) {
                    this.blockedThreads.addAll(list);
                }
            }
        } else {
            List<J9VMThreadPointer> list = ObjectMonitor_V1.getBlockedThreads(this.object);
            if (list != null) {
                this.blockedThreads.addAll(list);
            }
        }
    }

    private void initializeLockword() throws CorruptDataException {
        this.lockword = J9ObjectMonitorPointer.cast(this.object.monitor());
        if (this.lockword.notNull()) {
            this.isInflated = this.lockword.allBitsIn(J9Object.OBJECT_HEADER_LOCK_INFLATED);
            if (this.isInflated) {
                J9ObjectMonitorPointer objectMonitor = J9ObjectMonitorPointer.cast(this.lockword.untag(J9Object.OBJECT_HEADER_LOCK_INFLATED));
                this.monitor = J9ThreadAbstractMonitorPointer.cast(objectMonitor.monitor());
            }
        }
    }

    private static List<J9VMThreadPointer> getBlockedThreads(J9ObjectPointer blockingObject) throws CorruptDataException {
        if (blockedThreadsCache == null) {
            blockedThreadsCache = new HashMap();
            ThreadListIterator iterator = ThreadListIterator.from();
            while (iterator.hasNext()) {
                J9ObjectPointer object;
                J9VMThreadPointer vmThread = iterator.next();
                if (!vmThread.publicFlags().allBitsIn(J9Consts.J9_PUBLIC_FLAGS_THREAD_BLOCKED) || !(object = vmThread.blockingEnterObject()).notNull()) continue;
                List<J9VMThreadPointer> list = blockedThreadsCache.get(object);
                if (list == null) {
                    list = new ArrayList<J9VMThreadPointer>();
                    blockedThreadsCache.put(object, list);
                }
                list.add(vmThread);
            }
        }
        return blockedThreadsCache.get(blockingObject);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ObjectMonitor_V1)) {
            return false;
        }
        ObjectMonitor_V1 monitor = (ObjectMonitor_V1)o;
        if (this.lockword != null) {
            return this.lockword.eq(monitor.lockword);
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }
}

