/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools.ddrinteractive.commands;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class TraceFileHeaderWriter {
    private static final int UT_VERSION = 5;
    private static final int UT_MODIFICATION = 0;
    private ByteBuffer headerBytes = null;
    private final int bufferSize;
    private final boolean bigEndian;
    private final int cpuCount;
    private final int wordSize;
    private int arch = 0;
    private int subtype = 0;
    private static final int traceCounter = 7;
    private String serviceLevel = "";
    private String startupOptions = "";
    private String traceConfig = "";
    private long startPlatform = 0L;
    private long startSystem = 0L;
    private int type = 0;
    private int generations = 0;
    private static final String[] Archs = new String[]{"Unknown", "x86", "S390", "Power", "IA64", "S390X", "AMD64", "RISCV", "AArch64"};
    private static final String[] SubTypes = new String[]{"i486", "i586", "Pentium II", "Pentium III", "Merced", "McKinley", "PowerRS", "PowerPC", "GigaProcessor", "ESA", "Pentium IV", "T-Rex", "Opteron", "RV64G", "Armv8-A"};
    private static final String[] trCounter = new String[]{"Sequence Counter", "Special", "RDTSC Timer", "AIX Timer", "MFSPR Timer", "MFTB Timer", "STCK Timer", "J9 timer"};

    public TraceFileHeaderWriter(String snapTraceFileName, boolean bigEndian, int cpuCount, int wordSize, int bufferSize, String arch, String processorSubType, String serviceLevel, String startupOptions, String traceConfig, long startPlatform, long startSystem, int type2, int generations) throws IOException {
        int i;
        try {
            this.headerBytes = ByteBuffer.allocate(163840);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException();
        }
        this.bigEndian = bigEndian;
        this.cpuCount = cpuCount;
        this.wordSize = wordSize;
        this.bufferSize = bufferSize;
        if (!this.bigEndian) {
            this.headerBytes.order(ByteOrder.LITTLE_ENDIAN);
        } else {
            this.headerBytes.order(ByteOrder.BIG_ENDIAN);
        }
        for (i = 0; i < Archs.length; ++i) {
            if (!Archs[i].equalsIgnoreCase(arch)) continue;
            this.arch = i;
        }
        for (i = 0; i < SubTypes.length; ++i) {
            if (!SubTypes[i].equalsIgnoreCase(processorSubType)) continue;
            this.subtype = i;
        }
        this.serviceLevel = serviceLevel;
        this.startupOptions = startupOptions;
        this.traceConfig = traceConfig;
        this.startPlatform = startPlatform;
        this.startSystem = startSystem;
        this.type = type2;
        this.generations = generations;
    }

    public byte[] createAndWriteTraceFileHeader() throws IOException {
        int length = this.writeTraceFileHeader();
        byte[] bytesToWrite = new byte[length];
        this.headerBytes.position(0);
        this.headerBytes.get(bytesToWrite);
        return bytesToWrite;
    }

    private int writeTraceFileHeader() {
        int utDataHeaderPos = this.headerBytes.position();
        int offset = this.writeUtDataHeader("UTTH", -559038737);
        this.headerBytes.putInt(this.bufferSize);
        offset += 4;
        this.headerBytes.putInt(305419896);
        offset += 4;
        int traceStart_pos = this.headerBytes.position();
        this.headerBytes.putInt(-559038737);
        offset += 4;
        int serviceStart_pos = this.headerBytes.position();
        this.headerBytes.putInt(-559038737);
        offset += 4;
        int startupStart_pos = this.headerBytes.position();
        this.headerBytes.putInt(-559038737);
        offset += 4;
        int activeStart_pos = this.headerBytes.position();
        this.headerBytes.putInt(-559038737);
        offset += 4;
        int processorStart_pos = this.headerBytes.position();
        this.headerBytes.putInt(-559038737);
        this.headerBytes.putInt(traceStart_pos, offset += 4);
        this.headerBytes.putInt(serviceStart_pos, offset += this.writeTraceSection());
        this.headerBytes.putInt(startupStart_pos, offset += this.writeServiceSection());
        this.headerBytes.putInt(activeStart_pos, offset += this.writeStartupSection());
        this.headerBytes.putInt(processorStart_pos, offset += this.writeActiveSection());
        int length = this.headerBytes.position() - utDataHeaderPos;
        this.headerBytes.position(utDataHeaderPos);
        this.writeUtDataHeader("UTTH", offset += this.writeProcSection());
        return length;
    }

    private int writeProcSection() {
        int utDataHeaderPos = this.headerBytes.position();
        int offset = this.writeUtDataHeader("XXXX", -559038737);
        this.writeUtProcessorInfo();
        int length = this.headerBytes.position() - utDataHeaderPos;
        this.headerBytes.position(utDataHeaderPos);
        this.writeUtDataHeader("UTPR", length);
        this.headerBytes.position(utDataHeaderPos + length);
        return length;
    }

    private int writeUtProcessorInfo() {
        int utDataHeaderPos = this.headerBytes.position();
        int offset = this.writeUtDataHeader("XXXX", -559038737);
        this.headerBytes.putInt(this.arch);
        this.headerBytes.putInt(this.bigEndian ? 1 : 0);
        this.headerBytes.putInt(this.wordSize);
        this.headerBytes.putInt(this.cpuCount);
        this.writeUtProcInfo();
        this.headerBytes.putInt(4096);
        this.headerBytes.putInt(0);
        int length = this.headerBytes.position() - utDataHeaderPos;
        this.headerBytes.position(utDataHeaderPos);
        this.writeUtDataHeader("PINF", length);
        this.headerBytes.position(utDataHeaderPos + length);
        return length;
    }

    private int writeUtProcInfo() {
        int utDataHeaderPos = this.headerBytes.position();
        int offset = this.writeUtDataHeader("XXXX", -559038737);
        this.headerBytes.putInt(this.subtype);
        this.headerBytes.putInt(7);
        int length = this.headerBytes.position() - utDataHeaderPos;
        this.headerBytes.position(utDataHeaderPos);
        this.writeUtDataHeader("PIN", length);
        this.headerBytes.position(utDataHeaderPos + length);
        return length;
    }

    private int writeActiveSection() {
        int utDataHeaderPos = this.headerBytes.position();
        int offset = this.writeUtDataHeader("XXXX", -559038737);
        try {
            this.headerBytes.put(this.traceConfig.getBytes("UTF-8"));
            this.headerBytes.put(new byte[]{0});
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        int length = this.headerBytes.position() - utDataHeaderPos;
        this.headerBytes.position(utDataHeaderPos);
        this.writeUtDataHeader("UTTA", length);
        this.headerBytes.position(utDataHeaderPos + length);
        return length;
    }

    private int writeStartupSection() {
        int utDataHeaderPos = this.headerBytes.position();
        int offset = this.writeUtDataHeader("XXXX", -559038737);
        try {
            this.headerBytes.put(this.startupOptions.getBytes("UTF-8"));
            this.headerBytes.put(new byte[]{0});
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        int length = this.headerBytes.position() - utDataHeaderPos;
        this.headerBytes.position(utDataHeaderPos);
        this.writeUtDataHeader("UTSO", length);
        this.headerBytes.position(utDataHeaderPos + length);
        return length;
    }

    private int writeServiceSection() {
        int utDataHeaderPos = this.headerBytes.position();
        int offset = this.writeUtDataHeader("XXXX", -559038737);
        try {
            this.headerBytes.put(this.serviceLevel.getBytes("UTF-8"));
            this.headerBytes.put(new byte[]{0});
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        int length = this.headerBytes.position() - utDataHeaderPos;
        this.headerBytes.position(utDataHeaderPos);
        this.writeUtDataHeader("UTSS", length);
        this.headerBytes.position(utDataHeaderPos + length);
        return length;
    }

    private int writeTraceSection() {
        int utDataHeaderPos = this.headerBytes.position();
        int offset = this.writeUtDataHeader("XXXX", -559038737);
        this.headerBytes.putLong(this.startPlatform);
        this.headerBytes.putLong(this.startSystem);
        this.headerBytes.putInt(this.type);
        this.headerBytes.putInt(this.generations);
        this.headerBytes.putInt(this.wordSize / 8);
        int length = this.headerBytes.position() - utDataHeaderPos;
        this.headerBytes.position(utDataHeaderPos);
        this.writeUtDataHeader("UTTS", offset);
        this.headerBytes.position(utDataHeaderPos + length);
        return length;
    }

    private int writeUtDataHeader(String eyeCatcher, int length) {
        int startPos = this.headerBytes.position();
        try {
            byte[] eyeBytes = new byte[4];
            System.arraycopy(eyeCatcher.getBytes("US-ASCII"), 0, eyeBytes, 0, eyeCatcher.length());
            this.headerBytes.put(eyeBytes);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.headerBytes.putInt(length);
        this.headerBytes.putInt(5);
        this.headerBytes.putInt(0);
        return this.headerBytes.position() - startPos;
    }
}

