/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.tdump.zebedee.dumpreader;

import com.ibm.j9ddr.corereaders.tdump.zebedee.dumpreader.AddressSpace;
import com.ibm.j9ddr.corereaders.tdump.zebedee.util.ProgressMeter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

public class SystemTrace {
    private AddressSpace space;
    private ArrayList entries = new ArrayList();
    private HashMap contextMap = new HashMap();
    private int cachedAddress;
    private Map cachedMap;
    private Properties pcDescriptions;
    private Properties svcDescriptions;
    private Properties ssrvDescriptions;
    private static int debugIndex;
    private static Logger log;
    public static final int UNKNOWN = 0;
    public static final int SSCH = 1;
    public static final int EXT = 3;
    public static final int SVC = 5;
    public static final int PGM = 7;
    public static final int SPER = 9;
    public static final int IO = 11;
    public static final int DSP = 15;
    public static final int MCH = 19;
    public static final int RST = 21;
    public static final int ACR = 23;
    public static final int SUSP = 25;
    public static final int ALTR = 27;
    public static final int RCVY = 29;
    public static final int TIME = 31;
    public static final int MSCH = 257;
    public static final int EMS = 259;
    public static final int SVCR = 261;
    public static final int SRB = 271;
    public static final int HSCH = 513;
    public static final int SS = 515;
    public static final int SSRV = 517;
    public static final int SSRB = 527;
    public static final int CSCH = 769;
    public static final int CALL = 771;
    public static final int RSCH = 1025;
    public static final int CLKC = 1027;
    public static final int SIGA = 1281;
    public static final int XSCH = 1537;
    public static final int SVCE = 3845;
    public static final int WAIT = 3855;
    public static final int USR0 = 127;
    public static final int SSAR = 16;
    public static final int PC = 33;
    public static final int PC64 = 34;
    public static final int PT = 49;
    public static final int PR = 50;
    public static final int BSG = 65;
    private static final int[] log2bytes;

    public SystemTrace(AddressSpace space) throws IOException {
        this.space = space;
        InputStream is = this.getClass().getResourceAsStream("pcnumbers.properties");
        this.pcDescriptions = new Properties();
        this.pcDescriptions.load(is);
        is.close();
        is = this.getClass().getResourceAsStream("svcnumbers.properties");
        this.svcDescriptions = new Properties();
        this.svcDescriptions.load(is);
        is.close();
        is = this.getClass().getResourceAsStream("ssrvnumbers.properties");
        this.ssrvDescriptions = new Properties();
        this.ssrvDescriptions.load(is);
        is.close();
        this.readTrace();
        ProgressMeter.set("sorting trace entries", 0);
        final int nlogn = this.entries.size() * SystemTrace.log2(this.entries.size());
        Collections.sort(this.entries, new Comparator(){
            int n;

            public int compare(Object o1, Object o2) {
                if (this.n < nlogn) {
                    ProgressMeter.set(this.n++ * 100 / nlogn);
                }
                Entry e1 = (Entry)o1;
                Entry e2 = (Entry)o2;
                if (e1.getRawTime() == e2.getRawTime()) {
                    return e1.address - e2.address;
                }
                return e1.getRawTime() < e2.getRawTime() ? -1 : 1;
            }

            @Override
            public boolean equals(Object obj) {
                throw new Error("oops");
            }
        });
    }

    public List getEntries() {
        return this.entries;
    }

    private boolean inDebugRange(int index) {
        return false;
    }

    private void readTrace() throws IOException {
        long ttch = this.space.getLowestAddress();
        int zosRelease = 0;
        try {
            zosRelease = Integer.parseInt(this.space.getDump().getProductRelease());
        }
        catch (NumberFormatException e) {
            throw new Error("oops: " + e);
        }
        boolean newFormat = zosRelease >= 9;
        int numProcessors = this.space.readUnsignedShort(ttch + 28L);
        int todtop = this.space.readInt(ttch + 32L);
        long tod = todtop >> 16;
        long lastTod = tod <<= 48;
        Object lastSpace = null;
        ProgressMeter.set("reading trace entries", 0);
        for (int proc = 0; proc < numProcessors; ++proc) {
            if (this.inDebugRange(debugIndex)) {
                System.out.println("index " + debugIndex + " :go to proc " + proc);
            }
            long procEntry = ttch + 56L + (long)(proc * (newFormat ? 16 : 8));
            int ttchnumb = newFormat ? this.space.readInt(procEntry + 8L) : this.space.readUnsignedShort(procEntry);
            int ttchcpid = this.space.readUnsignedShort(procEntry + 2L);
            int ttchbptr = this.space.readInt(procEntry + 4L);
            boolean tcb = false;
            for (int buffer = 0; buffer < ttchnumb; ++buffer) {
                if (this.inDebugRange(debugIndex)) {
                    System.out.println("index " + debugIndex + " :go to buffer " + buffer);
                }
                ProgressMeter.set(proc * 100 / numProcessors + buffer * (100 / numProcessors) / ttchnumb);
                int flags = this.space.readUnsignedShort(ttchbptr + buffer * 40 + 8);
                int ttchcptr = this.space.readInt(ttchbptr + buffer * 40);
                int ttchclen = this.space.readInt(ttchbptr + buffer * 40 + 4);
                Entry entry = null;
                Entry lastTimedEntry = null;
                ArrayList<TimelessEntry> orphans = null;
                for (int entryPtr = ttchcptr; entryPtr < ttchcptr + ttchclen; entryPtr += entry.length()) {
                    Context context;
                    int id = this.space.readUnsignedByte(entryPtr);
                    if (this.inDebugRange(debugIndex)) {
                        System.out.println("index " + debugIndex + " :go to id " + id);
                    }
                    if (id < 112 || id >= 128) {
                        context = this.getContext(tod, ttchcpid, 0);
                        entry = this.getTimelessEntry(context, entryPtr, lastTimedEntry);
                        if (lastTimedEntry != null) {
                            this.entries.add(entry);
                            if (!this.inDebugRange(debugIndex)) continue;
                            System.out.println("index " + debugIndex + " :add to entry " + lastTimedEntry.index);
                            continue;
                        }
                        if (orphans == null) {
                            orphans = new ArrayList<TimelessEntry>();
                        }
                        orphans.add((TimelessEntry)entry);
                        if (!this.inDebugRange(debugIndex)) continue;
                        System.out.println("index " + debugIndex + " :orphan");
                        continue;
                    }
                    context = this.getContext(tod, ttchcpid, this.space.readUnsignedShort(entryPtr + 8));
                    entry = this.getEntry(context, entryPtr);
                    if (orphans != null) {
                        if (this.inDebugRange(debugIndex)) {
                            System.out.println("index " + debugIndex + " :adding orphans to " + entry.index);
                        }
                        for (TimelessEntry orphan : orphans) {
                            orphan.lastTimedEntry = entry;
                            this.entries.add(orphan);
                        }
                        orphans = null;
                    }
                    this.entries.add(entry);
                    lastTimedEntry = entry;
                }
            }
        }
    }

    private Entry getEntry(Context context, int address) throws IOException {
        int type2 = this.space.readUnsignedShort(address + 10);
        switch (type2) {
            case 1: {
                return new SSCH(context, address);
            }
            case 3: {
                return new EXT(context, address);
            }
            case 5: {
                return new SVC(context, address);
            }
            case 7: {
                return new PGM(context, address);
            }
            case 9: {
                return new SPER(context, address);
            }
            case 11: {
                return new IO(context, address);
            }
            case 15: {
                return new DSP(context, address);
            }
            case 19: {
                return new MCH(context, address);
            }
            case 21: {
                return new RST(context, address);
            }
            case 23: {
                return new ACR(context, address);
            }
            case 25: {
                return new SUSP(context, address);
            }
            case 27: {
                return new ALTR(context, address);
            }
            case 29: {
                return new RCVY(context, address);
            }
            case 31: {
                return new TIME(context, address);
            }
            case 257: {
                return new MSCH(context, address);
            }
            case 259: {
                return new EMS(context, address);
            }
            case 261: {
                return new SVCR(context, address);
            }
            case 271: {
                return new SRB(context, address);
            }
            case 513: {
                return new HSCH(context, address);
            }
            case 515: {
                return new SS(context, address);
            }
            case 517: {
                return new SSRV(context, address);
            }
            case 527: {
                return new SSRB(context, address);
            }
            case 769: {
                return new CSCH(context, address);
            }
            case 771: {
                return new CALL(context, address);
            }
            case 1025: {
                return new RSCH(context, address);
            }
            case 1027: {
                return new CLKC(context, address);
            }
            case 1281: {
                return new SIGA(context, address);
            }
            case 1537: {
                return new XSCH(context, address);
            }
            case 3845: {
                return new SVCE(context, address);
            }
            case 3855: {
                return new WAIT(context, address);
            }
            case 127: {
                return new USR0(context, address);
            }
        }
        log.info("Unknown entry type: " + type2);
        return new UNKNOWN(context, address);
    }

    private TimelessEntry getTimelessEntry(Context context, int address, Entry lastTimedEntry) throws IOException {
        switch (this.space.readUnsignedByte(address)) {
            case 16: {
                return new SSAR(context, address, lastTimedEntry);
            }
            case 33: {
                return new PC(context, address, lastTimedEntry);
            }
            case 34: {
                return new PC64(context, address, lastTimedEntry);
            }
            case 49: {
                return new PT(context, address, lastTimedEntry);
            }
            case 50: {
                return new PR(context, address, lastTimedEntry);
            }
            case 65: {
                return new BSG(context, address, lastTimedEntry);
            }
        }
        log.info("Unknown timeless entry type: " + this.space.readUnsignedByte(address));
        return new UNKNOWNT(context, address, lastTimedEntry);
    }

    private Context getContext(long tod, int pid, int ppid) {
        Integer key = pid << 16 | ppid;
        Context context = (Context)this.contextMap.get(key);
        if (context == null) {
            context = new Context(tod, pid, ppid);
            this.contextMap.put(key, context);
        }
        return context;
    }

    private static String hex(long i) {
        return Long.toHexString(i);
    }

    private static String hex(int i) {
        return Integer.toHexString(i);
    }

    private static String hexpad(int word) {
        return SystemTrace.hexpad(word, 8);
    }

    private static String hexpad(int word, int length) {
        String s = Integer.toHexString(word);
        for (int i = s.length(); i < length; ++i) {
            s = "0" + s;
        }
        return s;
    }

    private static String spacepad(String s, int length) {
        for (int i = s.length(); i < length; ++i) {
            s = " " + s;
        }
        return s;
    }

    private static String rspacepad(String s, int length) {
        for (int i = s.length(); i < length; ++i) {
            s = s + " ";
        }
        return s;
    }

    private static String hexpad(long word) {
        String s = Long.toHexString(word);
        for (int i = s.length(); i < 8; ++i) {
            s = "0" + s;
        }
        return s;
    }

    private static int log2(int n) {
        int bit = 0;
        while ((n & 0xFFFFFF00) != 0) {
            bit += 8;
            n >>>= 8;
        }
        return bit + log2bytes[n];
    }

    static {
        log = Logger.getLogger("j9ddr.core_readers");
        log2bytes = new int[]{-1, 0, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
    }

    private class PT
    extends TimelessEntry {
        PT(Context context, int address, Entry lastTimedEntry) {
            super(context, address, lastTimedEntry);
        }

        @Override
        public String getIdentString() {
            return "PT";
        }

        @Override
        public int getIdent() {
            return 49;
        }

        @Override
        public String getPswString() throws IOException {
            return "  " + (SystemTrace.this.space.readUnsignedByte(this.address + 1) >> 4) + "     ";
        }

        @Override
        int addressOffset() {
            return 4;
        }

        @Override
        public String getUnique2String() throws IOException {
            return SystemTrace.hexpad(SystemTrace.this.space.readUnsignedShort(this.address + 2), 4) + "    ";
        }
    }

    private class PR
    extends TimelessEntry {
        PR(Context context, int address, Entry lastTimedEntry) {
            super(context, address, lastTimedEntry);
        }

        @Override
        public String getIdentString() {
            return "PR";
        }

        @Override
        public int getIdent() {
            return 50;
        }

        @Override
        public String getPswString() throws IOException {
            return "  " + (SystemTrace.this.space.readUnsignedByte(this.address + 1) >> 4) + "     ";
        }

        @Override
        int addressOffset() {
            return 4;
        }

        @Override
        int pasdOffset() {
            return 2;
        }

        @Override
        public String getUnique2String() throws IOException {
            if ((SystemTrace.this.space.readUnsignedByte(this.address + 1) & 2) == 2) {
                return "00_" + SystemTrace.hexpad(SystemTrace.this.space.readInt(this.address + 8));
            }
            return SystemTrace.hexpad(SystemTrace.this.space.readInt(this.address + 8) & Integer.MAX_VALUE);
        }
    }

    private class PC64
    extends TimelessEntry {
        PC64(Context context, int address, Entry lastTimedEntry) {
            super(context, address, lastTimedEntry);
        }

        @Override
        public String getIdentString() {
            return "PC";
        }

        @Override
        public int getIdent() {
            return 34;
        }

        @Override
        public String getPswString() throws IOException {
            return "  " + (SystemTrace.this.space.readUnsignedByte(this.address + 1) >> 4) + "   0 ";
        }

        @Override
        int addressOffset() {
            return 4;
        }

        @Override
        int u2Offset() {
            return 8;
        }
    }

    private class PC
    extends TimelessEntry {
        PC(Context context, int address, Entry lastTimedEntry) {
            super(context, address, lastTimedEntry);
        }

        @Override
        public String getIdentString() {
            return "PC";
        }

        @Override
        public int getIdent() {
            return 33;
        }

        @Override
        public String getPswString() throws IOException {
            return "  " + (SystemTrace.this.space.readUnsignedByte(this.address + 1) >> 4) + "     ";
        }

        @Override
        int u2Offset() {
            return 2;
        }

        @Override
        int u2Length() {
            return 2;
        }

        @Override
        int addressOffset() {
            return 4;
        }

        String pcnumber() throws IOException {
            return SystemTrace.hexpad(SystemTrace.this.space.readInt(this.address) & 0xFFFFF, 5);
        }

        @Override
        public String getUnique2String() throws IOException {
            return SystemTrace.spacepad(this.pcnumber(), 8);
        }

        @Override
        public String getDescription() throws IOException {
            return SystemTrace.this.pcDescriptions.getProperty(this.pcnumber().toUpperCase());
        }
    }

    private class BSG
    extends TimelessEntry {
        BSG(Context context, int address, Entry lastTimedEntry) {
            super(context, address, lastTimedEntry);
        }

        @Override
        public String getIdentString() {
            return "BSG";
        }

        @Override
        public int getIdent() {
            return 65;
        }

        @Override
        public String getPswString() throws IOException {
            return SystemTrace.spacepad(SystemTrace.hexpad(SystemTrace.this.space.readInt(this.address) & 0xFFFFFF, 4), 8);
        }

        @Override
        int addressOffset() {
            return 4;
        }
    }

    private class SSAR
    extends TimelessEntry {
        SSAR(Context context, int address, Entry lastTimedEntry) {
            super(context, address, lastTimedEntry);
        }

        @Override
        public String getIdentString() {
            return "SSAR";
        }

        @Override
        public int getIdent() {
            return 16;
        }

        @Override
        public String getPswString() throws IOException {
            return SystemTrace.spacepad(SystemTrace.hexpad(SystemTrace.this.space.readUnsignedShort(this.address + 2), 4), 8);
        }

        @Override
        int sasdOffset() {
            return 2;
        }
    }

    private class UNKNOWNT
    extends TimelessEntry {
        UNKNOWNT(Context context, int address, Entry lastTimedEntry) {
            super(context, address, lastTimedEntry);
        }

        @Override
        public String getIdentString() {
            return "UNKNOWN";
        }

        @Override
        public int getIdent() {
            return 0;
        }
    }

    private class SPER
    extends Entry {
        SPER(Context context, int address) {
            super(context, address);
        }

        @Override
        public String getIdentString() {
            return "SPER";
        }

        @Override
        public int getIdent() {
            return 9;
        }
    }

    private class MSCH
    extends Entry {
        MSCH(Context context, int address) {
            super(context, address);
        }

        @Override
        public String getIdentString() {
            return "MSCH";
        }

        @Override
        public int getIdent() {
            return 257;
        }
    }

    private class TIME
    extends Entry {
        TIME(Context context, int address) {
            super(context, address);
        }

        @Override
        public String getIdentString() {
            return "TIME";
        }

        @Override
        public int getIdent() {
            return 31;
        }
    }

    private class RCVY
    extends Entry {
        RCVY(Context context, int address) {
            super(context, address);
        }

        @Override
        public String getIdentString() {
            return "RCVY";
        }

        @Override
        public int getIdent() {
            return 29;
        }
    }

    private class ALTR
    extends Entry {
        ALTR(Context context, int address) {
            super(context, address);
        }

        @Override
        public String getIdentString() {
            return "ALTR";
        }

        @Override
        public int getIdent() {
            return 27;
        }
    }

    private class ACR
    extends Entry {
        ACR(Context context, int address) {
            super(context, address);
        }

        @Override
        public String getIdentString() {
            return "ACR";
        }

        @Override
        public int getIdent() {
            return 23;
        }
    }

    private class RST
    extends Entry {
        RST(Context context, int address) {
            super(context, address);
        }

        @Override
        public String getIdentString() {
            return "RST";
        }

        @Override
        public int getIdent() {
            return 21;
        }
    }

    private class MCH
    extends Entry {
        MCH(Context context, int address) {
            super(context, address);
        }

        @Override
        public String getIdentString() {
            return "MCH";
        }

        @Override
        public int getIdent() {
            return 19;
        }
    }

    private class USR0
    extends Entry {
        USR0(Context context, int address) {
            super(context, address);
        }

        @Override
        public String getIdentString() {
            return "USR0";
        }

        @Override
        public int getIdent() {
            return 127;
        }
    }

    private class SVCE
    extends Entry {
        SVCE(Context context, int address) {
            super(context, address);
        }

        @Override
        public String getIdentString() {
            return "SVCE";
        }

        @Override
        public int getIdent() {
            return 3845;
        }
    }

    private class XSCH
    extends Entry {
        XSCH(Context context, int address) {
            super(context, address);
        }

        @Override
        public String getIdentString() {
            return "XSCH";
        }

        @Override
        public int getIdent() {
            return 1537;
        }
    }

    private class CLKC
    extends Entry {
        CLKC(Context context, int address) {
            super(context, address);
        }

        @Override
        public String getIdentString() {
            return "CLKC";
        }

        @Override
        public int getIdent() {
            return 1027;
        }

        @Override
        int pswOffset() {
            return 24;
        }

        @Override
        int addressOffset() {
            return 28;
        }

        @Override
        int u1Offset() {
            return 32;
        }

        @Override
        int u2Offset() {
            return 36;
        }

        @Override
        int u3Offset() {
            return 42;
        }

        @Override
        int u3Length() {
            return 2;
        }

        @Override
        public String getUnique3String() throws IOException {
            return "    " + SystemTrace.hexpad(SystemTrace.this.space.readUnsignedShort(this.address + 42), 4);
        }

        @Override
        int clhsOffset() {
            return 44;
        }

        @Override
        int localOffset() {
            return 48;
        }

        @Override
        int clhseOffset() {
            return 52;
        }

        @Override
        int pasdOffset() {
            return 20;
        }

        @Override
        int sasdOffset() {
            return 22;
        }
    }

    private class CSCH
    extends Entry {
        CSCH(Context context, int address) {
            super(context, address);
        }

        @Override
        public String getIdentString() {
            return "CSCH";
        }

        @Override
        public int getIdent() {
            return 769;
        }
    }

    private class SS
    extends Entry {
        SS(Context context, int address) {
            super(context, address);
        }

        @Override
        public String getIdentString() {
            return "SS";
        }

        @Override
        public int getIdent() {
            return 515;
        }
    }

    private class HSCH
    extends Entry {
        HSCH(Context context, int address) {
            super(context, address);
        }

        @Override
        public String getIdentString() {
            return "HSCH";
        }

        @Override
        public int getIdent() {
            return 513;
        }
    }

    private class WAIT
    extends Entry {
        WAIT(Context context, int address) {
            super(context, address);
        }

        @Override
        public String getIdentString() {
            return "WAIT";
        }

        @Override
        public int getIdent() {
            return 3855;
        }
    }

    private class UNKNOWN
    extends Entry {
        UNKNOWN(Context context, int address) {
            super(context, address);
        }

        @Override
        public String getIdentString() {
            return "UNKNOWN";
        }

        @Override
        public int getIdent() {
            return 0;
        }
    }

    private class SIGA
    extends Entry {
        SIGA(Context context, int address) {
            super(context, address);
        }

        @Override
        public String getIdentString() {
            return "SIGA";
        }

        @Override
        public int getIdent() {
            return 1281;
        }

        @Override
        int codeOffset() {
            return 22;
        }

        @Override
        int pswOffset() {
            return 20;
        }

        @Override
        int pswLength() {
            return 2;
        }

        @Override
        public String getPswString() throws IOException {
            return SystemTrace.hexpad(SystemTrace.this.space.readUnsignedByte(this.address + 20) & 3, 2) + "  " + SystemTrace.hexpad(SystemTrace.this.space.readUnsignedByte(this.address + 21), 2) + "  ";
        }

        @Override
        int addressOffset() {
            return 36;
        }

        @Override
        int u1Offset() {
            return 24;
        }

        @Override
        int u2Offset() {
            return 28;
        }

        @Override
        int u3Offset() {
            return 32;
        }

        @Override
        int u4Offset() {
            return 40;
        }
    }

    private class RSCH
    extends Entry {
        RSCH(Context context, int address) {
            super(context, address);
        }

        @Override
        public String getIdentString() {
            return "RSCH";
        }

        @Override
        public int getIdent() {
            return 1025;
        }

        @Override
        int codeOffset() {
            return 22;
        }

        @Override
        public String getCodeString() throws IOException {
            return SystemTrace.hexpad(SystemTrace.this.space.readUnsignedShort(this.address + 22), 5);
        }

        @Override
        int pswOffset() {
            return 20;
        }

        @Override
        int pswLength() {
            return 2;
        }

        @Override
        public String getPswString() throws IOException {
            return SystemTrace.hexpad(SystemTrace.this.space.readUnsignedByte(this.address + 20) & 3, 2) + "  " + SystemTrace.hexpad(SystemTrace.this.space.readUnsignedByte(this.address + 21), 2) + "  ";
        }

        @Override
        int addressOffset() {
            return 28;
        }

        @Override
        int u1Offset() {
            return 24;
        }
    }

    private class CALL
    extends Entry {
        CALL(Context context, int address) {
            super(context, address);
        }

        @Override
        public String getIdentString() {
            return "CALL";
        }

        @Override
        public int getIdent() {
            return 771;
        }

        @Override
        int pswOffset() {
            return 24;
        }

        @Override
        int addressOffset() {
            return 28;
        }

        @Override
        int u1Offset() {
            return 32;
        }

        @Override
        int u2Offset() {
            return 36;
        }

        @Override
        int clhsOffset() {
            return 40;
        }

        @Override
        int localOffset() {
            return 44;
        }

        @Override
        int clhseOffset() {
            return 48;
        }

        @Override
        int pasdOffset() {
            return 20;
        }

        @Override
        int sasdOffset() {
            return 22;
        }
    }

    private class SSRB
    extends Entry {
        SSRB(Context context, int address) {
            super(context, address);
        }

        @Override
        public String getIdentString() {
            return "SSRB";
        }

        @Override
        public int getIdent() {
            return 527;
        }

        @Override
        int pswOffset() {
            return 24;
        }

        @Override
        int addressOffset() {
            return 28;
        }

        @Override
        int u1Offset() {
            return 40;
        }

        @Override
        int u3Offset() {
            return 36;
        }

        @Override
        int u4Offset() {
            return 32;
        }

        @Override
        int clhsOffset() {
            return 17;
        }

        @Override
        int clhsLength() {
            return 1;
        }

        @Override
        public String getPsaclhsString() throws IOException {
            return SystemTrace.spacepad(SystemTrace.hexpad(SystemTrace.this.space.readUnsignedByte(this.address + 17), 2), 8);
        }

        @Override
        int localOffset() {
            return 44;
        }

        @Override
        int pasdOffset() {
            return 20;
        }

        @Override
        int sasdOffset() {
            return 22;
        }
    }

    private class SSRV
    extends Entry {
        SSRV(Context context, int address) {
            super(context, address);
        }

        @Override
        public String getIdentString() {
            return "SSRV";
        }

        @Override
        public int getIdent() {
            return 517;
        }

        @Override
        int codeOffset() {
            return 16;
        }

        @Override
        int addressOffset() {
            return 20;
        }

        @Override
        int u1Offset() {
            return 24;
        }

        @Override
        int u2Offset() {
            return 28;
        }

        @Override
        int u3Offset() {
            return 32;
        }

        @Override
        int u4Offset() {
            return 36;
        }

        @Override
        public String getDescription() throws IOException {
            int ssid = SystemTrace.this.space.readUnsignedShort(this.address + 16);
            switch (ssid) {
                case 95: {
                    int r0 = SystemTrace.this.space.readInt(this.address + 28);
                    switch (r0 & 0xFF) {
                        case 3: {
                            return "Sysevent NIOWait";
                        }
                        case 4: {
                            return "Sysevent UserRdy";
                        }
                        case 12: {
                            return "Sysevent QsceSt";
                        }
                        case 13: {
                            return "Sysevent QsceCmp";
                        }
                        case 20: {
                            return "Sysevent EnqHold";
                        }
                        case 21: {
                            return "Sysevent EnqRlse";
                        }
                        case 41: {
                            return "Sysevent DontSwap";
                        }
                        case 42: {
                            return "Sysevent OkSwap";
                        }
                        case 82: {
                            return "Sysevent ReqASD";
                        }
                        case 87: {
                            return "Sysevent EncCreat";
                        }
                        case 88: {
                            return "Sysevent EncDelet";
                        }
                        case 105: {
                            return "Sysevent WlmQueue";
                        }
                        case 106: {
                            return "Sysevent EncAssoc";
                        }
                    }
                    return "Unknown r0: " + SystemTrace.hex(r0);
                }
                case 120: {
                    int r15 = SystemTrace.this.space.readInt(this.address + 24);
                    return (r15 & 1) == 1 ? "Freemain" : "Getmain";
                }
            }
            return SystemTrace.this.ssrvDescriptions.getProperty(SystemTrace.hex(ssid).toUpperCase());
        }
    }

    private class SVCR
    extends Entry {
        SVCR(Context context, int address) {
            super(context, address);
        }

        @Override
        public String getIdentString() {
            return "SVCR";
        }

        @Override
        public int getIdent() {
            return 261;
        }

        @Override
        int codeOffset() {
            return 16;
        }

        @Override
        int pswOffset() {
            return 20;
        }

        @Override
        int addressOffset() {
            return 24;
        }

        @Override
        int u1Offset() {
            return 28;
        }

        @Override
        int u2Offset() {
            return 32;
        }

        @Override
        int u3Offset() {
            return 36;
        }
    }

    private class SRB
    extends Entry {
        SRB(Context context, int address) {
            super(context, address);
        }

        @Override
        public String getIdentString() {
            return "SRB";
        }

        @Override
        public int getIdent() {
            return 271;
        }

        @Override
        int pswOffset() {
            return 20;
        }

        @Override
        int addressOffset() {
            return 24;
        }

        @Override
        int u1Offset() {
            return 28;
        }

        @Override
        int u2Offset() {
            return 32;
        }

        @Override
        int u3Offset() {
            return 36;
        }

        @Override
        int u4Offset() {
            return 40;
        }

        @Override
        int u5Offset() {
            return 16;
        }

        @Override
        int u5Length() {
            return 1;
        }

        @Override
        public String getUnique5String() throws IOException {
            return SystemTrace.rspacepad(SystemTrace.hexpad(SystemTrace.this.space.readUnsignedByte(this.address + 16), 2), 8);
        }

        @Override
        int clhsOffset() {
            return 17;
        }

        @Override
        int clhsLength() {
            return 1;
        }

        @Override
        public String getPsaclhsString() throws IOException {
            return SystemTrace.spacepad(SystemTrace.hexpad(SystemTrace.this.space.readUnsignedByte(this.address + 17), 2), 8);
        }

        @Override
        int pasdOffset() {
            return 18;
        }

        @Override
        int sasdOffset() {
            return 18;
        }
    }

    private class EMS
    extends Entry {
        EMS(Context context, int address) {
            super(context, address);
        }

        @Override
        public String getIdentString() {
            return "EMS";
        }

        @Override
        public int getIdent() {
            return 259;
        }

        @Override
        int pswOffset() {
            return 24;
        }

        @Override
        int addressOffset() {
            return 28;
        }

        @Override
        int u1Offset() {
            return 32;
        }

        @Override
        int u2Offset() {
            return 36;
        }

        @Override
        int u3Offset() {
            return 40;
        }

        @Override
        int u4Offset() {
            return 44;
        }

        @Override
        int clhsOffset() {
            return 48;
        }

        @Override
        int localOffset() {
            return 52;
        }

        @Override
        int clhseOffset() {
            return 56;
        }

        @Override
        int pasdOffset() {
            return 20;
        }

        @Override
        int sasdOffset() {
            return 22;
        }
    }

    private class SUSP
    extends Entry {
        SUSP(Context context, int address) {
            super(context, address);
        }

        @Override
        public String getIdentString() {
            return "SUSP";
        }

        @Override
        public int getIdent() {
            return 25;
        }

        @Override
        int addressOffset() {
            return 20;
        }

        @Override
        int u1Offset() {
            return 24;
        }

        @Override
        int u2Offset() {
            return 32;
        }

        @Override
        int u3Offset() {
            return 36;
        }

        @Override
        int u4Offset() {
            return 28;
        }

        @Override
        int clhsOffset() {
            return 40;
        }

        @Override
        int localOffset() {
            return 44;
        }

        @Override
        int clhseOffset() {
            return 48;
        }

        @Override
        public String getUnique2String() throws IOException {
            return SystemTrace.this.space.readEbcdicString(this.address + 32, 4) + "    ";
        }
    }

    private class DSP
    extends Entry {
        DSP(Context context, int address) {
            super(context, address);
        }

        @Override
        public String getIdentString() {
            return "DSP";
        }

        @Override
        public int getIdent() {
            return 15;
        }

        @Override
        int pswOffset() {
            return 24;
        }

        @Override
        int addressOffset() {
            return 28;
        }

        @Override
        int u1Offset() {
            return 40;
        }

        @Override
        int u2Offset() {
            return 32;
        }

        @Override
        int u3Offset() {
            return 36;
        }

        @Override
        int clhsOffset() {
            return 44;
        }

        @Override
        int localOffset() {
            return 48;
        }

        @Override
        int pasdOffset() {
            return 20;
        }

        @Override
        int sasdOffset() {
            return 22;
        }
    }

    private class IO
    extends Entry {
        IO(Context context, int address) {
            super(context, address);
        }

        @Override
        public String getIdentString() {
            return "I/O";
        }

        @Override
        public int getIdent() {
            return 11;
        }

        @Override
        int codeOffset() {
            return 16;
        }

        @Override
        public String getCodeString() throws IOException {
            int code = SystemTrace.this.space.readUnsignedShort(this.address + 16);
            int u4 = SystemTrace.this.space.readInt(this.address + 64);
            if ((u4 & 0x20000) != 0) {
                code |= 0x10000;
            }
            return SystemTrace.hexpad(code, 5);
        }

        @Override
        int pswOffset() {
            return 24;
        }

        @Override
        int addressOffset() {
            return 28;
        }

        @Override
        int u1Offset() {
            return 32;
        }

        @Override
        int u2Offset() {
            return 36;
        }

        @Override
        int u3Offset() {
            return 40;
        }

        @Override
        int u4Offset() {
            return 64;
        }

        @Override
        public String getUnique4String() throws IOException {
            int u4 = SystemTrace.this.space.readInt(this.address + 64);
            if ((u4 & 0x20000) != 0) {
                return SystemTrace.spacepad(SystemTrace.hexpad(u4 & 0xFFFF, 4), 8);
            }
            return null;
        }

        @Override
        int u5Offset() {
            return 48;
        }

        @Override
        int u6Offset() {
            return 44;
        }

        @Override
        int clhsOffset() {
            return 52;
        }

        @Override
        int localOffset() {
            return 56;
        }

        @Override
        int clhseOffset() {
            return 60;
        }

        @Override
        int pasdOffset() {
            return 20;
        }

        @Override
        int sasdOffset() {
            return 22;
        }
    }

    private class PGM
    extends Entry {
        PGM(Context context, int address) {
            super(context, address);
        }

        @Override
        public String getIdentString() {
            return "PGM";
        }

        @Override
        public int getIdent() {
            return 7;
        }

        @Override
        int codeOffset() {
            return 46;
        }

        @Override
        public String getCodeString() throws IOException {
            return SystemTrace.hexpad(SystemTrace.this.space.readUnsignedShort(this.address + 46), 3);
        }

        @Override
        int pswOffset() {
            return 36;
        }

        @Override
        int addressOffset() {
            return 40;
        }

        @Override
        int u1Offset() {
            return 44;
        }

        @Override
        int u2Offset() {
            return 48;
        }

        @Override
        int u5Offset() {
            return 52;
        }

        @Override
        int clhsOffset() {
            return 24;
        }

        @Override
        int localOffset() {
            return 28;
        }

        @Override
        int clhseOffset() {
            return 32;
        }

        @Override
        int pasdOffset() {
            return 20;
        }

        @Override
        int sasdOffset() {
            return 22;
        }
    }

    private class SVC
    extends Entry {
        SVC(Context context, int address) {
            super(context, address);
        }

        @Override
        public String getIdentString() {
            return "SVC";
        }

        @Override
        public int getIdent() {
            return 5;
        }

        @Override
        int codeOffset() {
            return 16;
        }

        @Override
        int pswOffset() {
            return 20;
        }

        @Override
        int addressOffset() {
            return 24;
        }

        @Override
        int u1Offset() {
            return 28;
        }

        @Override
        int u2Offset() {
            return 32;
        }

        @Override
        int u3Offset() {
            return 36;
        }

        @Override
        public String getDescription() throws IOException {
            int svcnumber = SystemTrace.this.space.readUnsignedShort(this.address + 16);
            int r15 = SystemTrace.this.space.readInt(this.address + 28);
            int r0 = SystemTrace.this.space.readInt(this.address + 32);
            int r1 = SystemTrace.this.space.readInt(this.address + 36);
            switch (svcnumber) {
                case 10: {
                    return r1 < 0 ? "Getmain" : "Freemain";
                }
                case 120: {
                    return (r15 & 1) == 1 ? "Freemain" : "Getmain";
                }
                case 46: {
                    if ((r1 & 8) == 0) {
                        if ((r1 & 1) == 1) {
                            return "TTimer Cancel";
                        }
                        return "TTimer Set";
                    }
                    if ((r1 & 1) == 1) {
                        return "STimerM Cancel";
                    }
                    return "STimerM";
                }
                case 47: {
                    if ((r0 & 0x4000000) == 0) {
                        return "STimer   Set";
                    }
                    return "STimerM  Set";
                }
                case 79: {
                    switch (r0 & 0xFFFF) {
                        case 1: {
                            return "MCStep Set";
                        }
                        case 3: {
                            return "NDStep Set";
                        }
                        case 4: {
                            return "NDSys Set";
                        }
                        case 5: {
                            return "NDTcb Set";
                        }
                        case 6: {
                            return "Stop  SRBs/TCBs";
                        }
                    }
                    return "Uknown";
                }
            }
            return SystemTrace.this.svcDescriptions.getProperty(SystemTrace.hex(svcnumber).toUpperCase());
        }
    }

    private class EXT
    extends Entry {
        EXT(Context context, int address) {
            super(context, address);
        }

        @Override
        public String getIdentString() {
            return "EXT";
        }

        @Override
        public int getIdent() {
            return 3;
        }

        @Override
        int codeOffset() {
            return 32;
        }

        @Override
        int codeLength() {
            return 4;
        }

        @Override
        int pswOffset() {
            return 24;
        }

        @Override
        int addressOffset() {
            return 28;
        }

        @Override
        int u1Offset() {
            return 32;
        }

        @Override
        int clhsOffset() {
            return 36;
        }

        @Override
        int localOffset() {
            return 40;
        }

        @Override
        int clhseOffset() {
            return 44;
        }

        @Override
        int pasdOffset() {
            return 20;
        }

        @Override
        int sasdOffset() {
            return 22;
        }
    }

    private class SSCH
    extends Entry {
        SSCH(Context context, int address) {
            super(context, address);
        }

        @Override
        public String getIdentString() {
            return "SSCH";
        }

        @Override
        public int getIdent() {
            return 1;
        }

        @Override
        int codeOffset() {
            return 22;
        }

        @Override
        public String getCodeString() throws IOException {
            int u6;
            int code = SystemTrace.this.space.readUnsignedShort(this.address + 22);
            if (code != (u6 = SystemTrace.this.space.readUnsignedShort(this.address + 46))) {
                code |= 0x10000;
            }
            return SystemTrace.hexpad(code, 5);
        }

        @Override
        int pswOffset() {
            return 20;
        }

        @Override
        int pswLength() {
            return 2;
        }

        @Override
        public String getPswString() throws IOException {
            return SystemTrace.hexpad(SystemTrace.this.space.readUnsignedByte(this.address + 20) & 3, 2) + "  " + SystemTrace.hexpad(SystemTrace.this.space.readUnsignedByte(this.address + 21), 2) + "  ";
        }

        @Override
        int addressOffset() {
            return 40;
        }

        @Override
        int u1Offset() {
            return 24;
        }

        @Override
        int u2Offset() {
            return 28;
        }

        @Override
        int u3Offset() {
            return 32;
        }

        @Override
        int u4Offset() {
            return 46;
        }

        @Override
        int u4Length() {
            return 2;
        }

        @Override
        public String getUnique4String() throws IOException {
            int u6;
            int code = SystemTrace.this.space.readUnsignedShort(this.address + 22);
            if (code != (u6 = SystemTrace.this.space.readUnsignedShort(this.address + 46))) {
                return SystemTrace.spacepad(SystemTrace.hexpad(u6, 4), 8);
            }
            return null;
        }
    }

    private class Context {
        long tod;
        String processorId;
        String physicalProcessorId;

        Context(long tod, int pid, int ppid) {
            this.tod = tod;
            this.processorId = SystemTrace.hexpad(pid, 2);
            this.physicalProcessorId = SystemTrace.hexpad(ppid, 2);
        }

        String getProcessorId() {
            return this.processorId;
        }

        String getPhysicalProcessorId() {
            return this.physicalProcessorId;
        }
    }

    private abstract class TimelessEntry
    extends Entry {
        Entry lastTimedEntry;

        TimelessEntry(Context context, int address, Entry lastTimedEntry) {
            super(context, address);
            this.lastTimedEntry = lastTimedEntry;
        }

        @Override
        public int length() throws IOException {
            return ((this.getId() & 0xF) + 1) * 4;
        }

        @Override
        long getRawTime() {
            return this.lastTimedEntry.getRawTime();
        }

        @Override
        public String getTimestamp() {
            return this.lastTimedEntry.getTimestamp();
        }

        @Override
        public boolean hasTimestamp() {
            return false;
        }

        @Override
        public int getAsid() throws IOException {
            return this.lastTimedEntry.getHomeAsid();
        }

        @Override
        public String getTcbAddress() throws IOException {
            return this.lastTimedEntry.getTcbAddress();
        }

        @Override
        public String getCodeString() throws IOException {
            return " ...";
        }

        @Override
        public String getAddressString() throws IOException {
            if (this.addressOffset() == 0) {
                return null;
            }
            return SystemTrace.hex(SystemTrace.this.space.readInt(this.address + this.addressOffset()) & Integer.MAX_VALUE);
        }
    }

    public abstract class Entry {
        int address;
        Context context;
        public int index;

        Entry(Context context, int address) {
            this.address = address;
            this.context = context;
            this.index = debugIndex++;
        }

        public int getEntryAddress() {
            return this.address;
        }

        int getId() throws IOException {
            return SystemTrace.this.space.readUnsignedByte(this.address);
        }

        public int length() throws IOException {
            return 16 + (this.getId() & 0xF) * 4;
        }

        public String getProcessorId() {
            return this.context.getProcessorId();
        }

        public String getPhysicalProcessorId() {
            return this.context.getPhysicalProcessorId();
        }

        long getRawTime() {
            try {
                return SystemTrace.this.space.readLong(this.address) & 0xFFFFFFFFFFFFFFL;
            }
            catch (IOException e) {
                assert (false);
                return 0L;
            }
        }

        public String getTimestamp() {
            return SystemTrace.hex(this.getRawTime() | this.context.tod);
        }

        public boolean hasTimestamp() {
            return true;
        }

        int getHomeAsid() throws IOException {
            return SystemTrace.this.space.readUnsignedShort(this.address + 18);
        }

        public String getAsidString() throws IOException {
            return SystemTrace.hex(this.getAsid());
        }

        public int getAsid() throws IOException {
            int type2 = SystemTrace.this.space.readUnsignedShort(this.address + 10);
            if (type2 == 1025 || type2 == 1) {
                return SystemTrace.this.space.readUnsignedShort(this.address + 16);
            }
            return this.getHomeAsid();
        }

        public String getTcbAddress() throws IOException {
            return SystemTrace.hex(this.getTcb());
        }

        public int getTcb() throws IOException {
            return SystemTrace.this.space.readInt(this.address + 12);
        }

        public abstract String getIdentString();

        public abstract int getIdent();

        int codeLength() {
            return 2;
        }

        int pswLength() {
            return 4;
        }

        int u2Length() {
            return 4;
        }

        int u3Length() {
            return 4;
        }

        int u4Length() {
            return 4;
        }

        int u5Length() {
            return 4;
        }

        int clhsLength() {
            return 4;
        }

        int codeOffset() {
            return 0;
        }

        int pswOffset() {
            return 0;
        }

        int addressOffset() {
            return 0;
        }

        int u1Offset() {
            return 0;
        }

        int u2Offset() {
            return 0;
        }

        int u3Offset() {
            return 0;
        }

        int u4Offset() {
            return 0;
        }

        int u5Offset() {
            return 0;
        }

        int u6Offset() {
            return 0;
        }

        int clhsOffset() {
            return 0;
        }

        int localOffset() {
            return 0;
        }

        int clhseOffset() {
            return 0;
        }

        int pasdOffset() {
            return 0;
        }

        int sasdOffset() {
            return 0;
        }

        Integer getField(int offset, int length) throws IOException {
            if (offset != 0) {
                if (length == 1) {
                    return SystemTrace.this.space.readUnsignedByte(this.address + offset);
                }
                if (length == 2) {
                    return SystemTrace.this.space.readUnsignedShort(this.address + offset);
                }
                return SystemTrace.this.space.readInt(this.address + offset);
            }
            return null;
        }

        public int readInt(int offset) throws IOException {
            return SystemTrace.this.space.readInt(this.address + offset);
        }

        String getFieldString(Integer field) throws IOException {
            return field == null ? null : SystemTrace.hex(field);
        }

        public Integer getCode() throws IOException {
            return this.getField(this.codeOffset(), this.codeLength());
        }

        public String getCodeString() throws IOException {
            return this.getFieldString(this.getCode());
        }

        public Integer getPsw() throws IOException {
            return this.getField(this.pswOffset(), this.pswLength());
        }

        public String getPswString() throws IOException {
            return this.getFieldString(this.getPsw());
        }

        public Integer getAddress() throws IOException {
            return this.getField(this.addressOffset(), 4);
        }

        public String getAddressString() throws IOException {
            return this.getFieldString(this.getAddress());
        }

        public Integer getUnique1() throws IOException {
            return this.getField(this.u1Offset(), 4);
        }

        public String getUnique1String() throws IOException {
            return this.getFieldString(this.getUnique1());
        }

        public Integer getUnique2() throws IOException {
            return this.getField(this.u2Offset(), this.u2Length());
        }

        public String getUnique2String() throws IOException {
            return this.getFieldString(this.getUnique2());
        }

        public Integer getUnique3() throws IOException {
            return this.getField(this.u3Offset(), this.u3Length());
        }

        public String getUnique3String() throws IOException {
            return this.getFieldString(this.getUnique3());
        }

        public Integer getUnique4() throws IOException {
            return this.getField(this.u4Offset(), this.u4Length());
        }

        public String getUnique4String() throws IOException {
            return this.getFieldString(this.getUnique4());
        }

        public Integer getUnique5() throws IOException {
            return this.getField(this.u5Offset(), this.u5Length());
        }

        public String getUnique5String() throws IOException {
            return this.getFieldString(this.getUnique5());
        }

        public Integer getUnique6() throws IOException {
            return this.getField(this.u6Offset(), 4);
        }

        public String getUnique6String() throws IOException {
            return this.getFieldString(this.getUnique6());
        }

        public Integer getPsaclhs() throws IOException {
            return this.getField(this.clhsOffset(), this.clhsLength());
        }

        public String getPsaclhsString() throws IOException {
            return this.getFieldString(this.getPsaclhs());
        }

        public Integer getPsalocal() throws IOException {
            return this.getField(this.localOffset(), 4);
        }

        public String getPsalocalString() throws IOException {
            return this.getFieldString(this.getPsalocal());
        }

        public Integer getPsaclhse() throws IOException {
            return this.getField(this.clhseOffset(), 4);
        }

        public String getPsaclhseString() throws IOException {
            return this.getFieldString(this.getPsaclhse());
        }

        public Integer getPasd() throws IOException {
            return this.getField(this.pasdOffset(), 2);
        }

        public String getPasdString() throws IOException {
            return this.getFieldString(this.getPasd());
        }

        public Integer getSasd() throws IOException {
            return this.getField(this.sasdOffset(), 2);
        }

        public String getSasdString() throws IOException {
            return this.getFieldString(this.getSasd());
        }

        public String getDescription() throws IOException {
            return null;
        }
    }
}

