/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.macho;

import com.ibm.j9ddr.corereaders.macho.BuildVersionCommand;
import com.ibm.j9ddr.corereaders.macho.DSymtabCommand;
import com.ibm.j9ddr.corereaders.macho.DyldInfoCommand;
import com.ibm.j9ddr.corereaders.macho.DylibCommand;
import com.ibm.j9ddr.corereaders.macho.DylinkerCommand;
import com.ibm.j9ddr.corereaders.macho.EncryptionCommand64;
import com.ibm.j9ddr.corereaders.macho.EntryPointCommand;
import com.ibm.j9ddr.corereaders.macho.LinkeditDataCommand;
import com.ibm.j9ddr.corereaders.macho.LinkerOptionCommand;
import com.ibm.j9ddr.corereaders.macho.NoteCommand;
import com.ibm.j9ddr.corereaders.macho.PrebindChecksumCommand;
import com.ibm.j9ddr.corereaders.macho.PreboundDylibCommand;
import com.ibm.j9ddr.corereaders.macho.RoutinesCommand64;
import com.ibm.j9ddr.corereaders.macho.RpathCommand;
import com.ibm.j9ddr.corereaders.macho.SegmentCommand64;
import com.ibm.j9ddr.corereaders.macho.SourceVersionCommand;
import com.ibm.j9ddr.corereaders.macho.SubCommand;
import com.ibm.j9ddr.corereaders.macho.SymtabCommand;
import com.ibm.j9ddr.corereaders.macho.ThreadCommand;
import com.ibm.j9ddr.corereaders.macho.TwoLevelHintsCommand;
import com.ibm.j9ddr.corereaders.macho.UuidCommand;
import com.ibm.j9ddr.corereaders.macho.VersionMinCommand;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import javax.imageio.stream.ImageInputStream;

public class LoadCommand {
    public static final int LC_REQ_DYLD = Integer.MIN_VALUE;
    public static final int LC_SEGMENT = 1;
    public static final int LC_SYMTAB = 2;
    public static final int LC_SYMSEG = 3;
    public static final int LC_THREAD = 4;
    public static final int LC_UNIXTHREAD = 5;
    public static final int LC_LOADFVMLIB = 6;
    public static final int LC_IDFVMLIB = 7;
    public static final int LC_IDENT = 8;
    public static final int LC_FVMFILE = 9;
    public static final int LC_PREPAGE = 10;
    public static final int LC_DYSYMTAB = 11;
    public static final int LC_LOAD_DYLIB = 12;
    public static final int LC_ID_DYLIB = 13;
    public static final int LC_LOAD_DYLINKER = 14;
    public static final int LC_ID_DYLINKER = 15;
    public static final int LC_PREBOUND_DYLIB = 16;
    public static final int LC_ROUTINES = 17;
    public static final int LC_SUB_FRAMEWORK = 18;
    public static final int LC_SUB_UMBRELLA = 19;
    public static final int LC_SUB_CLIENT = 20;
    public static final int LC_SUB_LIBRARY = 21;
    public static final int LC_TWOLEVEL_HINTS = 22;
    public static final int LC_PREBIND_CKSUM = 23;
    public static final int LC_LOAD_WEAK_DYLIB = -2147483624;
    public static final int LC_SEGMENT_64 = 25;
    public static final int LC_ROUTINES_64 = 26;
    public static final int LC_UUID = 27;
    public static final int LC_RPATH = -2147483620;
    public static final int LC_CODE_SIGNATURE = 29;
    public static final int LC_SEGMENT_SPLIT_INFO = 30;
    public static final int LC_REEXPORT_DYLIB = -2147483617;
    public static final int LC_LAZY_LOAD_DYLIB = 32;
    public static final int LC_ENCRYPTION_INFO = 33;
    public static final int LC_DYLD_INFO = 34;
    public static final int LC_DYLD_INFO_ONLY = -2147483614;
    public static final int LC_LOAD_UPWARD_DYLIB = -2147483613;
    public static final int LC_VERSION_MIN_MACOSX = 36;
    public static final int LC_VERSION_MIN_IPHONEOS = 37;
    public static final int LC_FUNCTION_STARTS = 38;
    public static final int LC_DYLD_ENVIRONMENT = 39;
    public static final int LC_MAIN = -2147483608;
    public static final int LC_DATA_IN_CODE = 41;
    public static final int LC_SOURCE_VERSION = 42;
    public static final int LC_DYLIB_CODE_SIGN_DRS = 43;
    public static final int LC_ENCRYPTION_INFO_64 = 44;
    public static final int LC_LINKER_OPTION = 45;
    public static final int LC_LINKER_OPTIMIZATION_HINT = 46;
    public static final int LC_VERSION_MIN_TVOS = 47;
    public static final int LC_VERSION_MIN_WATCHOS = 48;
    public static final int LC_NOTE = 49;
    public static final int LC_BUILD_VERSION = 50;
    public int cmdType;
    public long cmdSize;
    public long absoluteOffset;
    public long segmentOffset;

    public static String getStringFromAsciiChars(byte[] chars) throws UnsupportedEncodingException {
        return LoadCommand.getStringFromAsciiChars(chars, 0);
    }

    public static String getStringFromAsciiChars(byte[] chars, int start) {
        int count;
        if (start < 0 || start >= chars.length) {
            return null;
        }
        for (count = 0; count < chars.length && 0 != chars[start + count]; ++count) {
        }
        return new String(chars, start, count, StandardCharsets.US_ASCII);
    }

    protected LoadCommand() {
    }

    public LoadCommand(int type2, long size, long offset) {
        this.cmdType = type2;
        this.cmdSize = size;
        this.absoluteOffset = offset;
    }

    public LoadCommand readCommand(ImageInputStream stream, long streamSegmentOffset) throws IOException {
        this.absoluteOffset = stream.getStreamPosition();
        this.segmentOffset = streamSegmentOffset;
        this.cmdType = stream.readInt();
        this.cmdSize = stream.readUnsignedInt();
        return this;
    }

    public static LoadCommand readFullCommand(ImageInputStream stream, long streamOffset, long segmentOffset, int cpuType) throws IOException {
        LoadCommand command;
        stream.seek(streamOffset);
        int cmdType = stream.readInt();
        switch (cmdType) {
            case 25: {
                command = new SegmentCommand64();
                break;
            }
            case -2147483624: 
            case -2147483617: 
            case 12: 
            case 13: {
                command = new DylibCommand();
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                command = new SubCommand();
                break;
            }
            case 16: {
                command = new PreboundDylibCommand();
                break;
            }
            case 14: 
            case 15: 
            case 39: {
                command = new DylinkerCommand();
                break;
            }
            case 4: 
            case 5: {
                command = new ThreadCommand(cpuType);
                break;
            }
            case 26: {
                command = new RoutinesCommand64();
                break;
            }
            case 2: {
                command = new SymtabCommand();
                break;
            }
            case 11: {
                command = new DSymtabCommand();
                break;
            }
            case 22: {
                command = new TwoLevelHintsCommand();
                break;
            }
            case 23: {
                command = new PrebindChecksumCommand();
                break;
            }
            case 27: {
                command = new UuidCommand();
                break;
            }
            case -2147483620: {
                command = new RpathCommand();
                break;
            }
            case 29: 
            case 30: 
            case 38: 
            case 41: 
            case 43: 
            case 46: {
                command = new LinkeditDataCommand();
                break;
            }
            case 44: {
                command = new EncryptionCommand64();
                break;
            }
            case 36: {
                command = new VersionMinCommand();
                break;
            }
            case 50: {
                command = new BuildVersionCommand();
                break;
            }
            case -2147483614: 
            case 34: {
                command = new DyldInfoCommand();
                break;
            }
            case 45: {
                command = new LinkerOptionCommand();
                break;
            }
            case -2147483608: {
                command = new EntryPointCommand();
                break;
            }
            case 42: {
                command = new SourceVersionCommand();
                break;
            }
            case 49: {
                command = new NoteCommand();
                break;
            }
            default: {
                command = new LoadCommand();
            }
        }
        stream.seek(streamOffset);
        command.readCommand(stream, segmentOffset);
        return command;
    }

    public class LoadCommandString {
        long offset;
        String value;

        public void readLcString(ImageInputStream stream) throws IOException {
            this.offset = stream.readInt();
            long currentOffset = stream.getStreamPosition();
            stream.seek(LoadCommand.this.absoluteOffset + this.offset);
            int stringSize = (int)(LoadCommand.this.cmdSize - this.offset);
            byte[] stringBytes = new byte[stringSize];
            stream.readFully(stringBytes);
            this.value = LoadCommand.getStringFromAsciiChars(stringBytes);
            stream.seek(currentOffset);
        }
    }
}

